function LineChart (top, left, width, height, bgColor) {
this.id = LineChart.currentId++;
this.top = top;
this.left = left;
this.width = width;
this.height = height;
this.bgColor = bgColor;
if (document.layers) {
this.chart = new Layer(this.width);
this.chart.left = left;
this.chart.top = top;
this.chart.bgColor = this.bgColor;
this.chart.clip.width = this.width;
this.chart.clip.height = this.height;
this.chart.visibility = 'show';
}
else if (document.all || document.getElementById) {
var html = '';
html += '<DIV ID="chart' + this.id + '"';
html += ' STYLE="';
html += ' position: absolute; left: ' + this.left + 'px; top: ' + 
this.top + 'px;';
html += ' overflow: hidden;';
html += ' width: ' + this.width + 'px; height: ' + this.height 
+ 'px;';
html += ' background-color: ' + this.bgColor + ';';
html += '"';
html += '>';
html += '</DIV>';
if (document.all) {
document.body.insertAdjacentHTML('beforeEnd', html);
this.chart = document.all['chart' + this.id];
}
else {
var range = document.createRange();
range.setStartAfter(document.body.lastChild);
var docFrag = range.createContextualFragment(html);
document.body.appendChild(docFrag);
this.chart = document.getElementById('chart' + this.id);
}
}
}
function LineChart_addGraph (points, color) {
this.plotPoints(points, color);
}
LineChart.prototype.addGraph = LineChart_addGraph;
function LineChart_plotPoints (points, color) {
for (var p = 0; p < points.length; p++) {
var x = points[p].x;
var y = this.height - points[p].y;
if (document.layers) {
var l = new Layer (1, this.chart);
l.clip.width = l.clip.height = 1;
l.left = x; l.top = y;
l.bgColor = color;
l.visibility = 'show';
}
else if (document.all || document.getElementById) {
var html = '';
html += '<SPAN';
html += ' STYLE="';
html += ' position: absolute; left: ' + x + 'px; top: ' + y 
+ 'px;';
html += ' width: 1px; height: 1px;';
html += document.all ? ' clip: rect(0 1 1 0);' : '';
html += ' background-color: ' + color + ';';
html += '"';
html += '>';
html += '</SPAN>';
if (document.all)
this.chart.insertAdjacentHTML('beforeEnd', html);
else {
var range = document.createRange();
range.setStartAfter(this.chart.lastChild);
var docFrag = range.createContextualFragment(html);
this.chart.appendChild(docFrag);
}
}
}
}
LineChart.prototype.plotPoints = LineChart_plotPoints;
function LineChart_addAxis (type, pos, color) {
var width = type = 'horizontal' ? this.width : 1;
var height = type = 'horizontal' ? 1 : this.height;
var left = type = 'horizontal' ? 0 : pos;
var top = type = 'horizontal' ? this.height - pos : 0;
if (document.layers) {
var l = new Layer (width, this.chart);
l.left = left; l.top = top;
l.clip.width = width; l.clip.height = height;
l.bgColor = color;
l.visibility = 'show';
}
else if (document.all || document.getElementById) {
var html = '';
html += '<SPAN';
html += ' STYLE="position: absolute; left: ' + left + 'px; top: ' + 
top + 'px;';
html += ' width: ' + width + 'px; height: ' + height + 'px;';
html += document.all ? 
' clip: rect (0 ' + width + ' ' + height + ' 0);' : '';
html += ' background-color: ' + color + ';';
html += '"';
html += '>';
html += '</SPAN>';
if (document.all)
this.chart.insertAdjacentHTML('beforeEnd', html);
else {
var range = document.createRange();
range.setStartAfter(this.chart.lastChild);
var docFrag = range.createContextualFragment(html);
this.chart.appendChild(docFrag);
}
}
}
LineChart.prototype.addAxis = LineChart_addAxis;
LineChart.currentId = 0;
function Point (x, y) {
this.x = x;
this.y = y;
}

