--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: onlop
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO onlop;

SET search_path = public, pg_catalog;

--
-- Name: descprov(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_codigo||'  -  '||prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.descprov(integer) OWNER TO onlop;


--
-- Name: f_au_testh(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_au_testh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if int4ne(NEW.th_estado,OLD.th_estado) THEN 
	update testc set tc_estado=NEW.th_estado where tc_idth=OLD.th_id;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_testh() OWNER TO onlop;


--
-- Name: nompais(smallint); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nompais(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select pai_nombre from pais where pai_codigo= $1 ;$_$;


ALTER FUNCTION public.nompais(smallint) OWNER TO onlop;

--
-- Name: nomprov(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pro_nombre from provin where pro_codigo= $1 ;$_$;


ALTER FUNCTION public.nomprov(integer) OWNER TO onlop;

--
-- Name: numero_letras(numeric); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION numero_letras(numeric) RETURNS text
    LANGUAGE plpgsql
    AS $_$
DECLARE
     numero	ALIAS FOR $1;
     lnEntero INTEGER;
     lcRetorno TEXT;
     lnTerna INTEGER;
     lcMiles TEXT;
     lcCadena TEXT;
     lnUnidades INTEGER;
     lnDecenas INTEGER;
     lnCentenas INTEGER;
     lnFraccion INTEGER;
     lnSw INTEGER;
BEGIN
     lnEntero := FLOOR(numero)::INTEGER;--Obtenemos la parte Entera
     lnFraccion := FLOOR(((numero - lnEntero) * 100))::INTEGER;--Obtenemos la Fraccion del Monto
     lcRetorno := '';
     lnTerna := 1;
     IF lnEntero > 0 THEN
     lnSw := LENGTH(lnEntero);
     WHILE lnTerna <= lnSw LOOP
        -- Recorro terna por terna
        lcCadena = '';
        lnUnidades = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
        lnDecenas = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
        lnCentenas = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
    -- Analizo las unidades
       SELECT
         CASE /* UNIDADES */
           WHEN lnUnidades = 1 AND lnTerna = 1 THEN 'UNO ' || lcCadena
           WHEN lnUnidades = 1 AND lnTerna <> 1 THEN 'UN ' || lcCadena
           WHEN lnUnidades = 2 THEN 'DOS ' || lcCadena
           WHEN lnUnidades = 3 THEN 'TRES ' || lcCadena
           WHEN lnUnidades = 4 THEN 'CUATRO ' || lcCadena
           WHEN lnUnidades = 5 THEN 'CINCO ' || lcCadena
           WHEN lnUnidades = 6 THEN 'SEIS ' || lcCadena
           WHEN lnUnidades = 7 THEN 'SIETE ' || lcCadena
           WHEN lnUnidades = 8 THEN 'OCHO ' || lcCadena
           WHEN lnUnidades = 9 THEN 'NUEVE ' || lcCadena
           ELSE lcCadena
          END INTO lcCadena;
          /* UNIDADES */
    -- Analizo las decenas
    SELECT
    CASE /* DECENAS */
      WHEN lnDecenas = 1 THEN
        CASE lnUnidades
          WHEN 0 THEN 'DIEZ '
          WHEN 1 THEN 'ONCE '
          WHEN 2 THEN 'DOCE '
          WHEN 3 THEN 'TRECE '
          WHEN 4 THEN 'CATORCE '
          WHEN 5 THEN 'QUINCE '
          ELSE 'DIECI' || lcCadena
        END
      WHEN lnDecenas = 2 AND lnUnidades = 0 THEN 'VEINTE ' || lcCadena
      WHEN lnDecenas = 2 AND lnUnidades <> 0 THEN 'VEINTI' || lcCadena
      WHEN lnDecenas = 3 AND lnUnidades = 0 THEN 'TREINTA ' || lcCadena
      WHEN lnDecenas = 3 AND lnUnidades <> 0 THEN 'TREINTA Y ' || lcCadena
      WHEN lnDecenas = 4 AND lnUnidades = 0 THEN 'CUARENTA ' || lcCadena
      WHEN lnDecenas = 4 AND lnUnidades <> 0 THEN 'CUARENTA Y ' || lcCadena
      WHEN lnDecenas = 5 AND lnUnidades = 0 THEN 'CINCUENTA ' || lcCadena
      WHEN lnDecenas = 5 AND lnUnidades <> 0 THEN 'CINCUENTA Y ' || lcCadena
      WHEN lnDecenas = 6 AND lnUnidades = 0 THEN 'SESENTA ' || lcCadena
      WHEN lnDecenas = 6 AND lnUnidades <> 0 THEN 'SESENTA Y ' || lcCadena
      WHEN lnDecenas = 7 AND lnUnidades = 0 THEN 'SETENTA ' || lcCadena
      WHEN lnDecenas = 7 AND lnUnidades <> 0 THEN 'SETENTA Y ' || lcCadena
      WHEN lnDecenas = 8 AND lnUnidades = 0 THEN 'OCHENTA ' || lcCadena
      WHEN lnDecenas = 8 AND lnUnidades <> 0 THEN 'OCHENTA Y ' || lcCadena
      WHEN lnDecenas = 9 AND lnUnidades = 0 THEN 'NOVENTA ' || lcCadena
      WHEN lnDecenas = 9 AND lnUnidades <> 0 THEN 'NOVENTA Y ' || lcCadena
      ELSE lcCadena
    END INTO lcCadena; /* DECENAS */
    -- Analizo las centenas
    SELECT
    CASE /* CENTENAS */
      WHEN lnCentenas = 1 AND lnUnidades = 0 AND lnDecenas = 0 THEN 'CIEN ' || lcCadena
      WHEN lnCentenas = 1 AND NOT(lnUnidades = 0 AND lnDecenas = 0) THEN 'CIENTO ' || lcCadena
      WHEN lnCentenas = 2 THEN 'DOSCIENTOS ' || lcCadena
      WHEN lnCentenas = 3 THEN 'TRESCIENTOS ' || lcCadena
      WHEN lnCentenas = 4 THEN 'CUATROCIENTOS ' || lcCadena
      WHEN lnCentenas = 5 THEN 'QUINIENTOS ' || lcCadena
      WHEN lnCentenas = 6 THEN 'SEISCIENTOS ' || lcCadena
      WHEN lnCentenas = 7 THEN 'SETECIENTOS ' || lcCadena
      WHEN lnCentenas = 8 THEN 'OCHOCIENTOS ' || lcCadena
      WHEN lnCentenas = 9 THEN 'NOVECIENTOS ' || lcCadena
      ELSE lcCadena
    END INTO lcCadena;/* CENTENAS */
    -- Analizo la terna
    SELECT
    CASE /* TERNA */
      WHEN lnTerna = 1 THEN lcCadena
      WHEN lnTerna = 2 AND (lnUnidades + lnDecenas + lnCentenas <> 0) THEN lcCadena || ' MIL '
      WHEN lnTerna = 3 AND (lnUnidades + lnDecenas + lnCentenas <> 0) AND
        lnUnidades = 1 AND lnDecenas = 0 AND lnCentenas = 0 THEN lcCadena || ' MILLON '
      WHEN lnTerna = 3 AND (lnUnidades + lnDecenas + lnCentenas <> 0) AND
        NOT (lnUnidades = 1 AND lnDecenas = 0 AND lnCentenas = 0) THEN lcCadena || ' MILLONES '
      WHEN lnTerna = 4 AND (lnUnidades + lnDecenas + lnCentenas <> 0) THEN lcCadena || ' MIL MILLONES '
      ELSE ''
    END INTO lcCadena;/* TERNA */
 
    --Retornamos los Valores Obtenidos
    lcRetorno = lcCadena  || lcRetorno;
    lnTerna = lnTerna + 1;
    END LOOP;
  END IF;
  IF lnTerna = 1 THEN
    lcRetorno := 'CERO';
  END IF;
  lcRetorno :=' PESOS ' || RTRIM(lcRetorno) || ' CON ' || LTRIM(lnFraccion) || '/100 CENTAVOS';
RETURN lcRetorno;
end;$_$;


ALTER FUNCTION public.numero_letras(numeric) OWNER TO onlop;

--
-- Name: valvaramb(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION valvaramb(integer, integer, character varying) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	codigo		ALIAS FOR $3; 
	otro 		integer;
	retval 		varchar;
    BEGIN

    select vari_valor into retval from
    	 varambi where int4eq(ptovta,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);

    if not found then
	select vari_valor into retval from
    	    varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	if not found then
	    select vari_valor into retval from
    		varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq(codigo,vari_codigo);
	end if;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.valvaramb(integer, integer, character varying) OWNER TO onlop;




SET default_tablespace = '';


SET default_with_oids = true;

--
-- Name: antecedentes; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE antecedentes (
    ant_paciente integer NOT NULL,
    ant_fecest timestamp without time zone DEFAULT now() NOT NULL,
    ant_concepto integer NOT NULL,
    ant_antiguedad numeric(8,2),
    ant_tratamiento integer DEFAULT 1 NOT NULL,
    ant_modo integer,
    ant_leyen1 character varying(60),
    ant_leyen2 character varying(60),
    ant_leyen3 character varying(60),
    ant_leyen4 character varying(60),
    ant_leyen5 character varying(60),
    ant_medicacion text
);


ALTER TABLE public.antecedentes OWNER TO onlop;


--
-- Name: consultas; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE consultas (
    con_id integer NOT NULL,
    con_paciente integer NOT NULL,
    con_fecha timestamp without time zone DEFAULT now() NOT NULL,
    con_nota text,
    con_doctor integer NOT NULL,
    con_estado integer DEFAULT 1
);


ALTER TABLE public.consultas OWNER TO onlop;

--
-- Name: consultas_con_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE consultas_con_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.consultas_con_id_seq OWNER TO onlop;

--
-- Name: consultas_con_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE consultas_con_id_seq OWNED BY consultas.con_id;


--
-- Name: convivencia; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE convivencia (
    cv_codigo integer NOT NULL,
    cv_nombre character varying(60) NOT NULL
);


ALTER TABLE public.convivencia OWNER TO onlop;


--
-- Name: ecivil; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE ecivil (
    ec_codigo smallint NOT NULL,
    ec_nombre character varying(60) NOT NULL
);


ALTER TABLE public.ecivil OWNER TO onlop;


--
-- Name: educacion; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE educacion (
    ed_codigo integer NOT NULL,
    ed_nombre character varying(60) NOT NULL
);


ALTER TABLE public.educacion OWNER TO onlop;


--
-- Name: grupos; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE grupos (
    gpo_id integer NOT NULL,
    gpo_nombre character varying(60) NOT NULL
);


ALTER TABLE public.grupos OWNER TO onlop;

--
-- Name: grupos_gpo_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE grupos_gpo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.grupos_gpo_id_seq OWNER TO onlop;

--
-- Name: grupos_gpo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE grupos_gpo_id_seq OWNED BY grupos.gpo_id;



--
-- Name: impresiones; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE impresiones (
    imp_codigo smallint NOT NULL,
    imp_name text,
    imp_query text,
    imp_enscript text,
    imp_filter text,
    imp_shell text
);


ALTER TABLE public.impresiones OWNER TO onlop;


--
-- Name: operadores; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE operadores (
    operad_id integer NOT NULL,
    operad_nombre character varying(60) NOT NULL,
    operad_pass character varying(40) NOT NULL,
    operad_sector character varying(60),
    operad_estado smallint DEFAULT 1 NOT NULL,
    operad_nivaut1 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_nivaut2 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_count smallint DEFAULT 1 NOT NULL,
    operad_grupo smallint,
    operad_cliente smallint,
    operad_login character varying(40) NOT NULL,
    operad_last date DEFAULT date(now()),
    operad_contacto character varying(90),
    operad_telefono character varying(90),
    operad_codemp integer,
    operad_ptovta integer
);


ALTER TABLE public.operadores OWNER TO onlop;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE operadores_operad_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.operadores_operad_id_seq OWNER TO onlop;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE operadores_operad_id_seq OWNED BY operadores.operad_id;



--
-- Name: pacientes; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE pacientes (
    pac_id integer NOT NULL,
    pac_codigo integer DEFAULT 1 NOT NULL,
    pac_nombre character varying(100),
    pac_sexo integer DEFAULT 1 NOT NULL,
    pac_fecnac date,
    pac_tdoc character varying(5),
    pac_ndoc integer,
    pac_fecest timestamp without time zone DEFAULT now() NOT NULL,
    pac_civil integer,
    pac_domicilio character varying(65),
    pac_locali character varying(65),
    pac_codpos character varying(15),
    pac_provin integer,
    pac_operador integer,
    pac_grupo integer,
    pac_cliente integer,
    pac_trabajo integer,
    pac_siempre integer,
    pac_cuanttra numeric(8,2),
    pac_trabact integer,
    pac_cuanttraa numeric(8,2),
    pac_educacion integer,
    pac_eduanios integer,
    pac_tipedu integer,
    pac_nacion integer,
    pac_lateralidad integer,
    pac_zurderiaflia integer,
    pac_convivencia integer,
    pac_medrefer integer,
    pac_nommed character varying(65),
    pac_estado integer DEFAULT 1
);


ALTER TABLE public.pacientes OWNER TO onlop;

--
-- Name: pacientes_pac_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE pacientes_pac_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pacientes_pac_id_seq OWNER TO onlop;

--
-- Name: pacientes_pac_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE pacientes_pac_id_seq OWNED BY pacientes.pac_id;


--
-- Name: pais; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE pais (
    pai_codigo smallint NOT NULL,
    pai_nombre character varying(60) NOT NULL
);


ALTER TABLE public.pais OWNER TO onlop;

--
-- Name: palabrasn; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE palabrasn (
    p_ingles character varying(20),
    p_valorm character varying(20),
    p_valorf character varying(20)
);


ALTER TABLE public.palabrasn OWNER TO onlop;


--
-- Name: provin; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE provin (
    pro_codigo integer NOT NULL,
    pro_nombre character varying(60) NOT NULL,
    pro_tasa numeric(15,5),
    pro_coef numeric(15,5),
    pro_valor numeric(15,2) DEFAULT 0
);


ALTER TABLE public.provin OWNER TO onlop;

--
-- Name: provin_pro_codigo_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE provin_pro_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.provin_pro_codigo_seq OWNER TO onlop;

--
-- Name: provin_pro_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE provin_pro_codigo_seq OWNED BY provin.pro_codigo;


--
-- Name: ptestn; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE ptestn (
    ptn_id integer NOT NULL,
    ptn_valorm character varying(20),
    ptn_valorf character varying(20)
);


ALTER TABLE public.ptestn OWNER TO onlop;

--
-- Name: ptestn_ptn_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE ptestn_ptn_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ptestn_ptn_id_seq OWNER TO onlop;

--
-- Name: ptestn_ptn_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE ptestn_ptn_id_seq OWNED BY ptestn.ptn_id;



--
-- Name: telefon; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE telefon (
    tel_id integer NOT NULL,
    tel_tipent integer NOT NULL,
    tel_codigo integer NOT NULL,
    tel_tiptel integer NOT NULL,
    tel_contact character varying(60) NOT NULL,
    tel_leyen text,
    tel_dato character varying(300)
);


ALTER TABLE public.telefon OWNER TO onlop;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE telefon_tel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.telefon_tel_id_seq OWNER TO onlop;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE telefon_tel_id_seq OWNED BY telefon.tel_id;


--
-- Name: testc; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE testc (
    tc_id integer NOT NULL,
    tc_idth integer DEFAULT (-1) NOT NULL,
    tc_orden integer DEFAULT (-1) NOT NULL,
    tc_idtn integer,
    tc_respuesta character varying(80),
    tc_acierto integer,
    tc_ini timestamp without time zone,
    tc_fin timestamp without time zone,
    tc_tiempo time without time zone,
    tc_puntaje numeric(20,5),
    tc_estado integer DEFAULT 1
);


ALTER TABLE public.testc OWNER TO onlop;

--
-- Name: testc_tc_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE testc_tc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.testc_tc_id_seq OWNER TO onlop;

--
-- Name: testc_tc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE testc_tc_id_seq OWNED BY testc.tc_id;


--
-- Name: testh; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE testh (
    th_id integer NOT NULL,
    th_consulta integer NOT NULL,
    th_paciente integer NOT NULL,
    th_fecha timestamp without time zone DEFAULT now() NOT NULL,
    th_aciertos integer,
    th_nota text,
    th_puntos numeric(15,5) DEFAULT 0,
    th_tiempo time without time zone,
    th_estado integer DEFAULT 1
);


ALTER TABLE public.testh OWNER TO onlop;

--
-- Name: testh_th_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE testh_th_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.testh_th_id_seq OWNER TO onlop;

--
-- Name: testh_th_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE testh_th_id_seq OWNED BY testh.th_id;



--
-- Name: testn; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE testn (
    tn_id integer NOT NULL,
    tn_posicion integer DEFAULT 1 NOT NULL,
    tn_v1 character varying(20),
    tn_v2 character varying(20),
    tn_v3 character varying(20),
    tn_v4 character varying(20),
    tn_v5 character varying(20),
    tn_v6 character varying(20),
    tn_v7 character varying(20),
    tn_valida character varying(20),
    tn_imagen character varying(80),
    tn_sexo integer DEFAULT 1 NOT NULL,
    tn_estado integer DEFAULT 1,
    tn_test integer DEFAULT -1
);


ALTER TABLE public.testn OWNER TO onlop;

--
-- Name: testn_tn_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE testn_tn_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.testn_tn_id_seq OWNER TO onlop;

--
-- Name: testn_tn_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE testn_tn_id_seq OWNED BY testn.tn_id;



--
-- Name: tipante; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tipante (
    tan_codigo integer NOT NULL,
    tan_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tipante OWNER TO onlop;


--
-- Name: tipdocu; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tipdocu (
    td_codigo character varying(5) NOT NULL,
    td_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tipdocu OWNER TO onlop;

--
-- Name: tipentid; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tipentid (
    tet_codigo integer NOT NULL,
    tet_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tipentid OWNER TO onlop;

--
-- Name: tipentid_tet_codigo_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE tipentid_tet_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tipentid_tet_codigo_seq OWNER TO onlop;

--
-- Name: tipentid_tet_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE tipentid_tet_codigo_seq OWNED BY tipentid.tet_codigo;


--
-- Name: tiptel; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tiptel (
    ttl_codigo integer NOT NULL,
    ttl_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tiptel OWNER TO onlop;

--
-- Name: tiptel_ttl_codigo_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE tiptel_ttl_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tiptel_ttl_codigo_seq OWNER TO onlop;

--
-- Name: tiptel_ttl_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE tiptel_ttl_codigo_seq OWNED BY tiptel.ttl_codigo;


--
-- Name: tmedico; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tmedico (
    med_codigo integer NOT NULL,
    med_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tmedico OWNER TO onlop;

--
-- Name: trabajo; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE trabajo (
    tb_codigo integer NOT NULL,
    tb_nombre character varying(60) NOT NULL
);


ALTER TABLE public.trabajo OWNER TO onlop;

--
-- Name: varamb; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE varamb (
    var_codigo character varying(60) NOT NULL,
    var_nombre character varying(60) NOT NULL,
    var_valor character varying(60)
);


ALTER TABLE public.varamb OWNER TO onlop;

--
-- Name: varambi; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE varambi (
    vari_codemp integer DEFAULT 0 NOT NULL,
    vari_idptov integer DEFAULT 0 NOT NULL,
    vari_codigo character varying(60) NOT NULL,
    vari_nombre character varying(60) NOT NULL,
    vari_valor character varying(60),
    vari_tipo integer DEFAULT 1
);


ALTER TABLE public.varambi OWNER TO onlop;


--
-- Name: con_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE consultas ALTER COLUMN con_id SET DEFAULT nextval('consultas_con_id_seq'::regclass);



--
-- Name: gpo_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE grupos ALTER COLUMN gpo_id SET DEFAULT nextval('grupos_gpo_id_seq'::regclass);



--
-- Name: operad_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE operadores ALTER COLUMN operad_id SET DEFAULT nextval('operadores_operad_id_seq'::regclass);


--
-- Name: pac_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE pacientes ALTER COLUMN pac_id SET DEFAULT nextval('pacientes_pac_id_seq'::regclass);



--
-- Name: pro_codigo; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE provin ALTER COLUMN pro_codigo SET DEFAULT nextval('provin_pro_codigo_seq'::regclass);


--
-- Name: ptn_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE ptestn ALTER COLUMN ptn_id SET DEFAULT nextval('ptestn_ptn_id_seq'::regclass);



--
-- Name: tel_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE telefon ALTER COLUMN tel_id SET DEFAULT nextval('telefon_tel_id_seq'::regclass);


--
-- Name: tc_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE testc ALTER COLUMN tc_id SET DEFAULT nextval('testc_tc_id_seq'::regclass);


--
-- Name: th_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE testh ALTER COLUMN th_id SET DEFAULT nextval('testh_th_id_seq'::regclass);


--
-- Name: tn_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE testn ALTER COLUMN tn_id SET DEFAULT nextval('testn_tn_id_seq'::regclass);


--
-- Name: tet_codigo; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE tipentid ALTER COLUMN tet_codigo SET DEFAULT nextval('tipentid_tet_codigo_seq'::regclass);


--
-- Name: ttl_codigo; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE tiptel ALTER COLUMN ttl_codigo SET DEFAULT nextval('tiptel_ttl_codigo_seq'::regclass);


--
-- Name: antecedentes_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY antecedentes
    ADD CONSTRAINT antecedentes_pkey PRIMARY KEY (ant_paciente, ant_concepto, ant_fecest);



--
-- Name: convivencia_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY convivencia
    ADD CONSTRAINT convivencia_pkey PRIMARY KEY (cv_codigo);


--
-- Name: ecivil_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY ecivil
    ADD CONSTRAINT ecivil_pkey PRIMARY KEY (ec_codigo);


--
-- Name: educacion_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY educacion
    ADD CONSTRAINT educacion_pkey PRIMARY KEY (ed_codigo);


--
-- Name: grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY grupos
    ADD CONSTRAINT grupos_pkey PRIMARY KEY (gpo_id);


--
-- Name: operadores_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY operadores
    ADD CONSTRAINT operadores_pkey PRIMARY KEY (operad_id);


--
-- Name: pais_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY pais
    ADD CONSTRAINT pais_pkey PRIMARY KEY (pai_codigo);


--
-- Name: provin_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY provin
    ADD CONSTRAINT provin_pkey PRIMARY KEY (pro_codigo);


--
-- Name: telefon_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT telefon_pkey PRIMARY KEY (tel_id);


--
-- Name: tipante_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tipante
    ADD CONSTRAINT tipante_pkey PRIMARY KEY (tan_codigo);


--
-- Name: tipdocu_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tipdocu
    ADD CONSTRAINT tipdocu_pkey PRIMARY KEY (td_codigo);


--
-- Name: tipentid_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tipentid
    ADD CONSTRAINT tipentid_pkey PRIMARY KEY (tet_codigo);


--
-- Name: tiptel_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tiptel
    ADD CONSTRAINT tiptel_pkey PRIMARY KEY (ttl_codigo);


--
-- Name: tmedico_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tmedico
    ADD CONSTRAINT tmedico_pkey PRIMARY KEY (med_codigo);


--
-- Name: trabajo_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY trabajo
    ADD CONSTRAINT trabajo_pkey PRIMARY KEY (tb_codigo);


--
-- Name: varamb_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY varamb
    ADD CONSTRAINT varamb_pkey PRIMARY KEY (var_codigo);


--
-- Name: varambi_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY varambi
    ADD CONSTRAINT varambi_pkey PRIMARY KEY (vari_codemp, vari_idptov, vari_codigo);


--
-- Name: idx_operadores_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_operadores_2 ON operadores USING btree (operad_login);


--
-- Name: idx_telefon_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_telefon_1 ON telefon USING btree (tel_tipent, tel_codigo, tel_tiptel);


--
-- Name: idx_telefon_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_telefon_2 ON telefon USING btree (tel_dato);


--
-- Name: idx_telefon_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_telefon_3 ON telefon USING btree (tel_contact);


--
-- Name: au_testh; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER au_testh
    AFTER UPDATE ON testh
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_testh();


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: antecedentes; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE antecedentes FROM PUBLIC;
REVOKE ALL ON TABLE antecedentes FROM onlop;
GRANT ALL ON TABLE antecedentes TO onlop;
GRANT ALL ON TABLE antecedentes TO nobody;


--
-- Name: consultas; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE consultas FROM PUBLIC;
REVOKE ALL ON TABLE consultas FROM onlop;
GRANT ALL ON TABLE consultas TO onlop;
GRANT ALL ON TABLE consultas TO nobody;


--
-- Name: consultas_con_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE consultas_con_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE consultas_con_id_seq FROM onlop;
GRANT ALL ON SEQUENCE consultas_con_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE consultas_con_id_seq TO nobody;


--
-- Name: convivencia; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE convivencia FROM PUBLIC;
REVOKE ALL ON TABLE convivencia FROM onlop;
GRANT ALL ON TABLE convivencia TO onlop;
GRANT ALL ON TABLE convivencia TO nobody;


--
-- Name: ecivil; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE ecivil FROM PUBLIC;
REVOKE ALL ON TABLE ecivil FROM onlop;
GRANT ALL ON TABLE ecivil TO onlop;
GRANT ALL ON TABLE ecivil TO nobody;


--
-- Name: educacion; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE educacion FROM PUBLIC;
REVOKE ALL ON TABLE educacion FROM onlop;
GRANT ALL ON TABLE educacion TO onlop;
GRANT ALL ON TABLE educacion TO nobody;


--
-- Name: grupos; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE grupos FROM PUBLIC;
REVOKE ALL ON TABLE grupos FROM onlop;
GRANT ALL ON TABLE grupos TO onlop;
GRANT ALL ON TABLE grupos TO nobody;


--
-- Name: grupos_gpo_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE grupos_gpo_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE grupos_gpo_id_seq FROM onlop;
GRANT ALL ON SEQUENCE grupos_gpo_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE grupos_gpo_id_seq TO nobody;


--
-- Name: impresiones; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE impresiones FROM PUBLIC;
REVOKE ALL ON TABLE impresiones FROM onlop;
GRANT ALL ON TABLE impresiones TO onlop;
GRANT ALL ON TABLE impresiones TO nobody;


--
-- Name: operadores; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE operadores FROM PUBLIC;
REVOKE ALL ON TABLE operadores FROM onlop;
GRANT ALL ON TABLE operadores TO onlop;
GRANT ALL ON TABLE operadores TO nobody;


--
-- Name: operadores_operad_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM onlop;
GRANT ALL ON SEQUENCE operadores_operad_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE operadores_operad_id_seq TO nobody;


--
-- Name: pacientes; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE pacientes FROM PUBLIC;
REVOKE ALL ON TABLE pacientes FROM onlop;
GRANT ALL ON TABLE pacientes TO onlop;
GRANT ALL ON TABLE pacientes TO nobody;


--
-- Name: pacientes_pac_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE pacientes_pac_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE pacientes_pac_id_seq FROM onlop;
GRANT ALL ON SEQUENCE pacientes_pac_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE pacientes_pac_id_seq TO nobody;


--
-- Name: pais; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE pais FROM PUBLIC;
REVOKE ALL ON TABLE pais FROM onlop;
GRANT ALL ON TABLE pais TO onlop;
GRANT ALL ON TABLE pais TO nobody;


--
-- Name: palabrasn; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE palabrasn FROM PUBLIC;
REVOKE ALL ON TABLE palabrasn FROM onlop;
GRANT ALL ON TABLE palabrasn TO onlop;


--
-- Name: provin; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE provin FROM PUBLIC;
REVOKE ALL ON TABLE provin FROM onlop;
GRANT ALL ON TABLE provin TO onlop;
GRANT ALL ON TABLE provin TO nobody;


--
-- Name: provin_pro_codigo_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE provin_pro_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE provin_pro_codigo_seq FROM onlop;
GRANT ALL ON SEQUENCE provin_pro_codigo_seq TO onlop;
GRANT UPDATE ON SEQUENCE provin_pro_codigo_seq TO nobody;


--
-- Name: ptestn_ptn_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE ptestn_ptn_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ptestn_ptn_id_seq FROM onlop;
GRANT ALL ON SEQUENCE ptestn_ptn_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE ptestn_ptn_id_seq TO nobody;


--
-- Name: telefon; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE telefon FROM PUBLIC;
REVOKE ALL ON TABLE telefon FROM onlop;
GRANT ALL ON TABLE telefon TO onlop;
GRANT ALL ON TABLE telefon TO nobody;


--
-- Name: telefon_tel_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM onlop;
GRANT ALL ON SEQUENCE telefon_tel_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE telefon_tel_id_seq TO nobody;


--
-- Name: testc; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE testc FROM PUBLIC;
REVOKE ALL ON TABLE testc FROM onlop;
GRANT ALL ON TABLE testc TO onlop;
GRANT ALL ON TABLE testc TO nobody;


--
-- Name: testc_tc_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE testc_tc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE testc_tc_id_seq FROM onlop;
GRANT ALL ON SEQUENCE testc_tc_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE testc_tc_id_seq TO nobody;


--
-- Name: testh; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE testh FROM PUBLIC;
REVOKE ALL ON TABLE testh FROM onlop;
GRANT ALL ON TABLE testh TO onlop;
GRANT ALL ON TABLE testh TO nobody;


--
-- Name: testh_th_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE testh_th_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE testh_th_id_seq FROM onlop;
GRANT ALL ON SEQUENCE testh_th_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE testh_th_id_seq TO nobody;


--
-- Name: testn; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE testn FROM PUBLIC;
REVOKE ALL ON TABLE testn FROM onlop;
GRANT ALL ON TABLE testn TO onlop;
GRANT ALL ON TABLE testn TO nobody;


--
-- Name: testn_tn_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE testn_tn_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE testn_tn_id_seq FROM onlop;
GRANT ALL ON SEQUENCE testn_tn_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE testn_tn_id_seq TO nobody;


--
-- Name: tipante; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tipante FROM PUBLIC;
REVOKE ALL ON TABLE tipante FROM onlop;
GRANT ALL ON TABLE tipante TO onlop;
GRANT ALL ON TABLE tipante TO nobody;


--
-- Name: tipdocu; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tipdocu FROM PUBLIC;
REVOKE ALL ON TABLE tipdocu FROM onlop;
GRANT ALL ON TABLE tipdocu TO onlop;
GRANT ALL ON TABLE tipdocu TO nobody;


--
-- Name: tipentid; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tipentid FROM PUBLIC;
REVOKE ALL ON TABLE tipentid FROM onlop;
GRANT ALL ON TABLE tipentid TO onlop;
GRANT ALL ON TABLE tipentid TO nobody;


--
-- Name: tipentid_tet_codigo_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE tipentid_tet_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipentid_tet_codigo_seq FROM onlop;
GRANT ALL ON SEQUENCE tipentid_tet_codigo_seq TO onlop;
GRANT UPDATE ON SEQUENCE tipentid_tet_codigo_seq TO nobody;


--
-- Name: tiptel; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tiptel FROM PUBLIC;
REVOKE ALL ON TABLE tiptel FROM onlop;
GRANT ALL ON TABLE tiptel TO onlop;
GRANT ALL ON TABLE tiptel TO nobody;


--
-- Name: tiptel_ttl_codigo_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE tiptel_ttl_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tiptel_ttl_codigo_seq FROM onlop;
GRANT ALL ON SEQUENCE tiptel_ttl_codigo_seq TO onlop;
GRANT UPDATE ON SEQUENCE tiptel_ttl_codigo_seq TO nobody;


--
-- Name: tmedico; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tmedico FROM PUBLIC;
REVOKE ALL ON TABLE tmedico FROM onlop;
GRANT ALL ON TABLE tmedico TO onlop;
GRANT ALL ON TABLE tmedico TO nobody;


--
-- Name: trabajo; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE trabajo FROM PUBLIC;
REVOKE ALL ON TABLE trabajo FROM onlop;
GRANT ALL ON TABLE trabajo TO onlop;
GRANT ALL ON TABLE trabajo TO nobody;


--
-- Name: varamb; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE varamb FROM PUBLIC;
REVOKE ALL ON TABLE varamb FROM onlop;
GRANT ALL ON TABLE varamb TO onlop;
GRANT ALL ON TABLE varamb TO nobody;


--
-- Name: varambi; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE varambi FROM PUBLIC;
REVOKE ALL ON TABLE varambi FROM onlop;
GRANT ALL ON TABLE varambi TO onlop;
GRANT ALL ON TABLE varambi TO nobody;



CREATE TABLE tiptest (
    tt_codigo smallint NOT NULL,
    tt_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tiptest OWNER TO onlop;

ALTER TABLE ONLY tiptest
    ADD CONSTRAINT tiptest_pkey PRIMARY KEY (tt_codigo);


REVOKE ALL ON TABLE tiptest FROM PUBLIC;
REVOKE ALL ON TABLE tiptest FROM onlop;
GRANT ALL ON TABLE tiptest TO onlop;
GRANT ALL ON TABLE tiptest TO nobody;




--
-- PostgreSQL database dump complete
--

