--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: onlop
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO onlop;

SET search_path = public, pg_catalog;

--
-- Name: act_talon(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION act_talon(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select tal_valor from talon where tal_id = $1;$_$;


ALTER FUNCTION public.act_talon(integer) OWNER TO onlop;

--
-- Name: anioastoh(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION anioastoh(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select ash_anio from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.anioastoh(integer) OWNER TO onlop;

--
-- Name: ashdeastc(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION ashdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_idastoh from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.ashdeastc(integer) OWNER TO onlop;

--
-- Name: astcdecomp(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION astcdecomp(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_idastoh= $1 and astc_ctacble= $2 limit 1 ;$_$;


ALTER FUNCTION public.astcdecomp(integer, integer) OWNER TO onlop;

--
-- Name: astcdecompchq(character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION astcdecompchq(character varying, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_codemp=1 and astc_idptov=$2 and bpchareq(codcomp(astc_comprob)::varchar, $1::varchar) and astc_numero= $3 and astc_ctacble=10 limit 1 ;$_$;


ALTER FUNCTION public.astcdecompchq(character varying, integer, integer) OWNER TO onlop;

--
-- Name: astcdecompchqn(character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION astcdecompchqn(character varying, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_codemp=1 and astc_idptov=$2 and bpchareq(codcomp(astc_comprob)::varchar, $1::varchar) and astc_numero= $3 and astc_ctacble=10 and astc_importe<0 limit 1 ;$_$;


ALTER FUNCTION public.astcdecompchqn(character varying, integer, integer) OWNER TO onlop;

--
-- Name: astcdecompchqp(character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION astcdecompchqp(character varying, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_codemp=1 and astc_idptov=$2 and bpchareq(codcomp(astc_comprob)::varchar, $1::varchar) and astc_numero= $3 and astc_ctacble=10 and astc_importe>0 limit 1 ;$_$;


ALTER FUNCTION public.astcdecompchqp(character varying, integer, integer) OWNER TO onlop;

--
-- Name: astcdecompxctacte(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION astcdecompxctacte(integer, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_idastoh= $1 and astc_ctacble= $2 and astc_ctacte= idprov(1, $3) limit 1 ;$_$;


ALTER FUNCTION public.astcdecompxctacte(integer, integer, integer) OWNER TO onlop;

--
-- Name: astcdecompxctacte2(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION astcdecompxctacte2(integer, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_idastoh= $1 and astc_ctacble= $2 and astc_ctacte= idcli(1, $3) limit 1 ;$_$;


ALTER FUNCTION public.astcdecompxctacte2(integer, integer, integer) OWNER TO onlop;

--
-- Name: astcdecompximp(integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION astcdecompximp(integer, integer, numeric) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_id from astoctas where astc_idastoh= $1 and astc_ctacble= $2 and astc_importe= $3 limit 1 ;$_$;


ALTER FUNCTION public.astcdecompximp(integer, integer, numeric) OWNER TO onlop;

--
-- Name: cantingmovcxa(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION cantingmovcxa(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(movc_canti) from movstoc where movc_estado=2 and movc_artic= $1 ;$_$;


ALTER FUNCTION public.cantingmovcxa(integer) OWNER TO onlop;

--
-- Name: cantretmovsxa(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION cantretmovsxa(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(movs_canti) from movsto where movs_estado=2 and movs_artic= $1 ;$_$;


ALTER FUNCTION public.cantretmovsxa(integer) OWNER TO onlop;

--
-- Name: cbleok(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION cbleok(integer, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	codigo		ALIAS FOR $2;
	empre		ALIAS FOR $3;
	esisti		integer;
	retval 		boolean;
    BEGIN
    retval:='f';
    if int4eq(codemp,empre) then
	    retval:='t';
	else
	    if int4eq(codemp,0) then
		retval:='t';
		select count(*) into esisti from ctacble 
		    where cbl_codemp in (codemp,empre) and cbl_codigo=codigo;
    		if int4gt(esisti,1) then
		    retval:='f';
		end if;
	    end if;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.cbleok(integer, integer, integer) OWNER TO onlop;

--
-- Name: cierre_ejercicio(character varying, date, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION cierre_ejercicio(character varying, date, integer, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
comprobante	 alias for $1;
fecha		 alias for $2;
tipo		 alias for $3; -- 1 Resultado, 2 Patrimoniales
codemp		 alias for $4;
idptov		 alias for $5;
ret 		 boolean;
registro	 record;
elcomprob 	 integer;
cuentardo 	 integer;
nrocomp 	 integer;
cuenta 	 	 integer;
subcuenta 	 integer;
resultad 	 numeric(15,2);
tituloa	 	 character varying;
idastoh 	 integer;
begin
ret:='f';

    select idcomp(comprobante,idptov) into elcomprob;
    select numtalon(idptov,elcomprob,1) into nrocomp;
    select comp_nombre || ' EJERCICIO CERRADO AL ' || fecha into tituloa from comprob where comp_id=elcomprob;

    insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_nro2,ash_estado) 
	values (codemp,idptov,substr(fecha,7,4)::int2,substr(fecha,4,2)::int2,elcomprob,nrocomp,tituloa,fecha,fecha,'Cierre de Cuentas del Ejercicio ',0,-1);

    select ash_id into idastoh from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=elcomprob and ash_numero=nrocomp;

    select idcbl(codemp,valvaramb(codemp,0,'CTARDOE')::integer)  into cuentardo;   

    if(int4eq(tipo,1::int4)) then
	for registro in select 
	    astc_ctacble, sum(astc_importe * -1) as cuanto from astoctas 
	      where astc_estado=2 and astc_codemp=codemp and date_le(astc_fecval,fecha) and codcble(astc_ctacble)>=3000 and codcomp(astc_comprob) not in ('AR','Ar') and astc_fecval>'30-06-2008' group by 1  
	    loop
		if(registro.cuanto != 0) then
		    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
    	    	     values (idastoh,registro.astc_ctacble,registro.cuanto,codemp,idptov,elcomprob,nrocomp,fecha,-1);	
		end if;
	    end loop; 

	select sum(astc_importe * -1) into resultad from astoctas where astc_idastoh=idastoh;

	
	if(resultad != 0) then
	    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
    	     values (idastoh,cuentardo,resultad,codemp,idptov,elcomprob,nrocomp,fecha,-1);	
	end if;
	ret:='t';


      else

	for registro in select 
	    astc_ctacble, sum(astc_importe * -1) as cuanto from astoctas 
	      where astc_estado=2 and astc_codemp=codemp and date_le(astc_fecval,fecha) and codcomp(astc_comprob) not in ('AR','Ar') and astc_fecval>'30-06-2008'  group by 1  
	    loop
		if(registro.cuanto != 0) then
		    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
    	    	     values (idastoh,registro.astc_ctacble,registro.cuanto,codemp,idptov,elcomprob,nrocomp,fecha,-1);	
		end if;
	    end loop; 

	ret:='t';

    end if;
    return ret;
end;$_$;


ALTER FUNCTION public.cierre_ejercicio(character varying, date, integer, integer, integer) OWNER TO onlop;

--
-- Name: cliedeastc(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION cliedeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_ctacte from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'DEUDXV')::integer) limit 1;$_$;


ALTER FUNCTION public.cliedeastc(integer) OWNER TO onlop;

--
-- Name: climodfac(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION climodfac(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cli_modfac from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.climodfac(integer) OWNER TO onlop;

--
-- Name: codartic(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codartic(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select art_codigo from articvta where art_id = $1;$_$;


ALTER FUNCTION public.codartic(integer) OWNER TO onlop;

--
-- Name: codcble(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codcble(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_codigo from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.codcble(integer) OWNER TO onlop;

--
-- Name: codcli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codcli(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_codigo from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.codcli(integer) OWNER TO onlop;

--
-- Name: codclideastoh(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codclideastoh(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select emi_codcli from emiti where emi_idastoh= $1 ;$_$;


ALTER FUNCTION public.codclideastoh(integer) OWNER TO onlop;

--
-- Name: codcomp(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.codcomp(integer) OWNER TO onlop;

--
-- Name: codcompash(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codcompash(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob,astoh where comp_id=ash_comprob and ash_id= $1 ;$_$;


ALTER FUNCTION public.codcompash(integer) OWNER TO onlop;

--
-- Name: codcompastc(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codcompastc(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.codcompastc(integer) OWNER TO onlop;

--
-- Name: codctes(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codctes(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cte_codigo from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.codctes(integer) OWNER TO onlop;

--
-- Name: codempcli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codempcli(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_codemp from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.codempcli(integer) OWNER TO onlop;

--
-- Name: codidecartic(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codidecartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_codi from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.codidecartic(integer) OWNER TO onlop;

--
-- Name: codposclie(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codposclie(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select trim(sucu_codpos) from sucursal where sucu_cliente= $1 ;$_$;


ALTER FUNCTION public.codposclie(integer) OWNER TO onlop;

--
-- Name: codprov(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_codigo from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.codprov(integer) OWNER TO onlop;

--
-- Name: codprovdeastoh(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION codprovdeastoh(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cpra_prove from compra where cpra_idastoh= $1 ;$_$;


ALTER FUNCTION public.codprovdeastoh(integer) OWNER TO onlop;

--
-- Name: compadunombre(character varying); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION compadunombre(character varying) RETURNS character
    LANGUAGE sql
    AS $_$select cad_nombre from compadu where bpchareq(cad_codigo::varchar, $1::varchar );$_$;


ALTER FUNCTION public.compadunombre(character varying) OWNER TO onlop;

--
-- Name: compdeastc(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION compdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_comprob from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.compdeastc(integer) OWNER TO onlop;

--
-- Name: compnro(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION compnro(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.comp_codigo::character varying||'  -  '||b.ash_numero from comprob a, astoh  b where b.ash_id= $1 and b.ash_comprob=a.comp_id;$_$;


ALTER FUNCTION public.compnro(integer) OWNER TO onlop;

--
-- Name: compnrodeastoctas(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION compnrodeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||' - '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.compnrodeastoctas(integer) OWNER TO onlop;

--
-- Name: conchequsado(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION conchequsado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from cheques,astoctas where chq_idastoc=astc_id and astc_idastoh= $1 and chq_idastoce is not null ;$_$;


ALTER FUNCTION public.conchequsado(integer) OWNER TO onlop;

--
-- Name: condocusado(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION condocusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from docum,astoctas where doc_idastoc=astc_id and astc_idastoh= $1 and doc_idastoce is not null ;$_$;


ALTER FUNCTION public.condocusado(integer) OWNER TO onlop;

--
-- Name: condolusado(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION condolusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from monex,astoctas where mne_idastoc=astc_id and astc_idastoh= $1 and mne_idastoce is not null ;$_$;


ALTER FUNCTION public.condolusado(integer) OWNER TO onlop;

--
-- Name: conivacli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION conivacli(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cli_coniva from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.conivacli(integer) OWNER TO onlop;

--
-- Name: conivaprov(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION conivaprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_coniva from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.conivaprov(integer) OWNER TO onlop;

--
-- Name: conpagcli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION conpagcli(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_conpag from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.conpagcli(integer) OWNER TO onlop;

--
-- Name: cotmoneda(date, smallint); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION cotmoneda(date, smallint) RETURNS numeric
    LANGUAGE sql
    AS $_$select cot_cotiz from cotiza WHERE int2eq(cot_moneda, $2 ::int2) and  date_le(cot_fecha, $1 ::date) order by cot_fecha desc limit 1;$_$;


ALTER FUNCTION public.cotmoneda(date, smallint) OWNER TO onlop;

--
-- Name: cotpeso(date); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION cotpeso(date) RETURNS numeric
    LANGUAGE sql
    AS $_$select cot_cotiz from cotiza WHERE int2eq(cot_moneda,1::int2) and  date_le(cot_fecha, $1 ::date) order by cot_fecha desc limit 1;$_$;


ALTER FUNCTION public.cotpeso(date) OWNER TO onlop;

--
-- Name: cual_moneda(character varying); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION cual_moneda(character varying) RETURNS smallint
    LANGUAGE sql
    AS $_$select mon_codigo from moneda where bpchareq(trim(mon_simbol),trim($1));$_$;


ALTER FUNCTION public.cual_moneda(character varying) OWNER TO onlop;

--
-- Name: cuitcli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION cuitcli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cli_nrcuit from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.cuitcli(integer) OWNER TO onlop;

--
-- Name: cuitprov(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION cuitprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nrcuit from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.cuitprov(integer) OWNER TO onlop;

--
-- Name: descartic(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_codi||'  -  '||art_nombre from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.descartic(integer) OWNER TO onlop;

--
-- Name: desccble(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION desccble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_codigo||'  -  '||cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.desccble(integer) OWNER TO onlop;

--
-- Name: descchq(smallint); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descchq(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select bco_codigo||'  -  '||bco_nombre from bancos where bco_codigo= $1 ;$_$;


ALTER FUNCTION public.descchq(smallint) OWNER TO onlop;

--
-- Name: descchqt(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descchqt(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select bco_nombre||'  - Nro: '||chq_nucheq||'  - Fecha: '||chq_fecheq||'  - Importe: $ '||chq_importe from cheques,bancos where chq_codbco=bco_codigo and chq_id= $1 and chq_idastoce is not null ;$_$;


ALTER FUNCTION public.descchqt(integer) OWNER TO onlop;

--
-- Name: desccli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION desccli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cli_codigo||'  -  '||cli_nombre from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.desccli(integer) OWNER TO onlop;

--
-- Name: desccli_emiti(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION desccli_emiti(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.cli_codigo||'  -  '||a.cli_nombre from clientes a, emiti b where a.cli_id=b.emi_codcli and b.emi_id= $1 ;$_$;


ALTER FUNCTION public.desccli_emiti(integer) OWNER TO onlop;

--
-- Name: desccomp(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION desccomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.desccomp(integer) OWNER TO onlop;

--
-- Name: desccompdeastoctas(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION desccompdeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre||'  Nro:  '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.desccompdeastoctas(integer) OWNER TO onlop;

--
-- Name: descctes(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descctes(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cte_codigo||'  -  '||cte_nombre from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.descctes(integer) OWNER TO onlop;

--
-- Name: descemp(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descemp(integer, integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empres		ALIAS FOR $1; 
	ptovt		ALIAS FOR $2; 
	cuantos		integer;
	nomemp 		varchar;
	nomptov		varchar;
	retval 		varchar;
    BEGIN
    
    select count(*) into cuantos from
    	 ptovta where int4eq(empres,ptv_codemp);
    
	 if int4eq(cuantos,1) then
		select emp_nombre into retval from empresa where int4eq(empres,emp_codigo);
	    else
		select emp_nombre into nomemp from empresa where int4eq(empres,emp_codigo);
		select ptv_nombre into nomptov from ptovta where int4eq(ptovt,ptv_id) and int4eq(empres,ptv_codemp);
		retval:= nomemp ||'  -  '|| nomptov;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.descemp(integer, integer) OWNER TO onlop;

--
-- Name: descempptv(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descempptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.emp_nombre||'  -  '||b.ptv_nombre from ptovta b, empresa a where a.emp_codigo=b.ptv_codemp and ptv_id= $1 ;$_$;


ALTER FUNCTION public.descempptv(integer) OWNER TO onlop;

--
-- Name: descfacg(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descfacg(integer, integer, integer, integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select desccomp(astc_comprob)||'  Nro  '||astc_numero from astoctas where astc_codemp= $1 and astc_tipcta= $2 and astc_ctacte= $3 and astc_grupo= $4 order by astc_fecval asc,astc_importe desc limit 1;$_$;


ALTER FUNCTION public.descfacg(integer, integer, integer, integer) OWNER TO onlop;

--
-- Name: descfactcpra(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descfactcpra(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select 'Prov: '|| cpra_nomprov || '  Factura:  '|| cpra_lecomp ||' - '|| lpad(cpra_sucomp,4,0) ||' - '|| lpad(cpra_nucomp,8,0) from compra where cpra_id= $1 ;$_$;


ALTER FUNCTION public.descfactcpra(integer) OWNER TO onlop;

--
-- Name: descfc(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descfc(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select cpra_lecomp ||' - '|| lpad(cpra_sucomp,4,0) ||' - '|| lpad(cpra_nucomp,8,0) from compra where cpra_idastoh= $1 ;$_$;


ALTER FUNCTION public.descfc(integer) OWNER TO onlop;

--
-- Name: descmon(smallint); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descmon(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select mon_codigo||'  -  '||mon_nombre from moneda where mon_codigo= $1 ;$_$;


ALTER FUNCTION public.descmon(smallint) OWNER TO onlop;

--
-- Name: descprov(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_codigo||'  -  '||prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.descprov(integer) OWNER TO onlop;

--
-- Name: descptv(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION descptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ptv_codigo||'  -  '||ptv_nombre from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.descptv(integer) OWNER TO onlop;

--
-- Name: despachoarticvt(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION despachoarticvt(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select artv_despacho from articvt where artv_id= $1 ;$_$;


ALTER FUNCTION public.despachoarticvt(integer) OWNER TO onlop;

--
-- Name: diasconpag(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION diasconpag(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cdp_dias from conpag where cdp_codigo= $1 ;$_$;


ALTER FUNCTION public.diasconpag(integer) OWNER TO onlop;

--
-- Name: dsctocli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION dsctocli(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select cli_descto from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.dsctocli(integer) OWNER TO onlop;

--
-- Name: elprecio(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION elprecio(integer, integer, character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	cli		ALIAS FOR $2; 
	articulo	ALIAS FOR $3; 
	idart 		integer;
	retval 		numeric(15,2);
    BEGIN
    select idarticvta(codemp,articulo) into idart;
    select ltp_precio into retval from
    	 listpre where int4eq(cli,ltp_idcli) and int4eq(idart,ltp_idart);

    if not found then
	    select art_precio into retval from
    		articvta where int4eq(idart,art_id);
    end if;

    if retval is null then
    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elprecio(integer, integer, character varying) OWNER TO onlop;

--
-- Name: elpreciodto(integer, integer, character varying, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION elpreciodto(integer, integer, character varying, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	cli		ALIAS FOR $2; 
	articulo	ALIAS FOR $3; 
	idastoh		ALIAS FOR $4; 
	idart 		integer;
	dto 		numeric(15,2);
	retval 		numeric(15,2);
    BEGIN
    retval:=0;

    select idarticvta(codemp,articulo) into idart;
    select emi_desre into dto from emiti where emi_idastoh=idastoh;
    if dto is null then
        dto:=0;
    end if;
    
    select ltp_precio * (1+(dto/100)) into retval from listpre where int4eq(cli,ltp_idcli) and int4eq(idart,ltp_idart);

    if not found then
	select art_precio * (1+(dto/100)) / (1+(art_tasa/100)) into retval from	articvta where int4eq(idart,art_id);
    end if;

    if retval is null then
    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elpreciodto(integer, integer, character varying, integer) OWNER TO onlop;

--
-- Name: elpreciodtoc(integer, integer, character varying, integer, numeric); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION elpreciodtoc(integer, integer, character varying, integer, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	cli		ALIAS FOR $2; 
	articulo	ALIAS FOR $3; 
	idastoh		ALIAS FOR $4; 
	cotiz		ALIAS FOR $5; 
	idart 		integer;
	dto 		numeric(15,2);
	retval 		numeric(15,2);
    BEGIN
    retval:=0;

    select idarticvta(codemp,articulo) into idart;
    select emi_desre into dto from emiti where emi_idastoh=idastoh;
    if dto is null then
	dto:=0;
    end if;
    
    select ltp_precio * (1+(dto/100)) * cotiz into retval from
    	 listpre where int4eq(cli,ltp_idcli) and int4eq(idart,ltp_idart);

    if not found then
	    select art_precio * (1+(dto/100)) * cotiz  / (1+(art_tasa/100)) into retval from
    		articvta where int4eq(idart,art_id);
    end if;



    if retval is null then
    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elpreciodtoc(integer, integer, character varying, integer, numeric) OWNER TO onlop;

--
-- Name: elprecioid(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION elprecioid(integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	cli		ALIAS FOR $2; 
	idart		ALIAS FOR $3; 
	retval 		numeric;
    BEGIN
    select ltp_precio into retval from
    	 listpre where int4eq(cli,ltp_idcli) and int4eq(idart,ltp_idart);

    if not found then
	    select art_precio into retval from
    		articvta where int4eq(idart,art_id);
    end if;

    if retval is null then
    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elprecioid(integer, integer, integer) OWNER TO onlop;

--
-- Name: estaensubd(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION estaensubd(integer, integer) RETURNS boolean
    LANGUAGE sql
    AS $_$select true from subxcomp where subxc_idsub= $1 and subxc_comprob= $2 ;$_$;


ALTER FUNCTION public.estaensubd(integer, integer) OWNER TO onlop;

--
-- Name: eval_funcion(text); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION eval_funcion(text) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	res		record;
    BEGIN
	for res in execute 'select '||$1||' as result' loop
	return res.result;
	end loop;
END;$_$;


ALTER FUNCTION public.eval_funcion(text) OWNER TO onlop;

--
-- Name: f_ai_astoctas(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_ai_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ctabco		integer;
	tctabco		integer;
    BEGIN
    select idcbl(NEW.astc_codemp, valvaramb(NEW.astc_codemp,NEW.astc_idptov,'BANCO')::smallint) into ctabco;
    select valvaramb(NEW.astc_codemp,NEW.astc_idptov,'TCTBANCO') into tctabco;

    if(int4eq(NEW.astc_ctacble,ctabco))  THEN 

	if(NEW.astc_fecvto is null)  THEN 
	    update astoctas set astc_fecvto=NEW.astc_fecval where astc_id=NEW.astc_id;
	END IF;

	if (NEW.astc_tipcta is null) then 
	    update astoctas set astc_tipcta=tctabco where astc_id=NEW.astc_id;
	END IF;

    END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_astoctas() OWNER TO onlop;

--
-- Name: f_ai_clientes(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_ai_clientes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
	insert into ctes (cte_nombre,cte_codemp,cte_codigo,cte_tipcta) values (NEW.cli_nombre,NEW.cli_codemp,NEW.cli_codigo,31);
	insert into sucursal (sucu_cliente,sucu_nombre) values (NEW.cli_id,NEW.cli_nombre);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_clientes() OWNER TO onlop;

--
-- Name: f_ai_facturacion(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_ai_facturacion() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
	if NEW.fac_anio is null then NEW.fac_anio=date_part('year',NEW.fac_fecha)::int2; end if;
	if NEW.fac_anio is null then NEW.fac_mes=date_part('month',NEW.fac_fecha)::int2; end if;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_facturacion() OWNER TO onlop;

--
-- Name: f_ai_movstoc(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_ai_movstoc() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
cual	integer;
vamospor numeric;
BEGIN

    vamospor:=NEW.movc_canti;
    WHILE numeric_gt(vamospor,0) LOOP
	vamospor:=vamospor-1;
	insert into articvt (artv_codemp,artv_idmovstoc,artv_idashing,artv_idartic,artv_precioc,artv_tasaiva,artv_codi) values (NEW.movc_codemp,NEW.movc_id,NEW.movc_idastoh,NEW.movc_artic,NEW.movc_impdolar/NEW.movc_canti,NEW.movc_tasa,codidecartic(NEW.movc_artic));
	if(numeric_gt(vamospor,0) and numeric_lt(vamospor,1)) then
	    insert into articvt (artv_codemp,artv_canti,artv_idmovstoc,artv_idashing,artv_idartic,artv_precioc,artv_tasaiva,artv_codi) values (NEW.movc_codemp,vamospor,NEW.movc_id,NEW.movc_idastoh,NEW.movc_artic,NEW.movc_impdolar/NEW.movc_canti,NEW.movc_tasa,codidecartic(NEW.movc_artic));
	end if;
    END LOOP;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_ai_movstoc() OWNER TO onlop;

--
-- Name: f_ai_prove(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_ai_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    BEGIN
	insert into ctes (cte_nombre,cte_codemp,cte_codigo,cte_tipcta) values (NEW.prov_nombre,NEW.prov_codemp,NEW.prov_id,eval_funcion(valvaramb(NEW.prov_codemp,ptovdefault(NEW.prov_codemp),'TIPCTADXC')));
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_prove() OWNER TO onlop;

--
-- Name: f_au_astoctas(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_au_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	total	numeric;
BEGIN

    if int4ne(NEW.astc_estado,OLD.astc_estado) THEN 
	update cheques set chq_estado=NEW.astc_estado where chq_idastoc=OLD.astc_id;
	update monex set mne_estado=NEW.astc_estado where mne_idastoc=OLD.astc_id;
	update docum set doc_estado=NEW.astc_estado where doc_idastoc=OLD.astc_id;
	END IF;

    if int4ne(NEW.astc_ctacte,OLD.astc_ctacte) THEN 
	if int4eq(OLD.astc_ctacble,18) THEN 
	    update emiti set emi_codcli=NEW.astc_ctacte where emi_idastoh=OLD.astc_idastoh;
	END IF;
	
	if int4eq(OLD.astc_ctacble,134) THEN 
		update compra set cpra_prove=NEW.astc_ctacte where cpra_idastoh=OLD.astc_idastoh;
	END IF;
    END IF;

    if (int4ne(NEW.astc_estado,OLD.astc_estado) and int4eq(NEW.astc_estado,2)) THEN 
	select sum(astc_importe) into total from astoctas where astc_idastoh=OLD.astc_idastoh and astc_importe>0;
	update compra set cpra_total=total where cpra_idastoh=OLD.astc_idastoh;
    END IF;


    if (int4eq(NEW.astc_estado,999) and int2eq(NEW.astc_cierra,2::int2) and (int4eq(NEW.astc_ctacble,idcbl(NEW.astc_codemp,valvaramb(NEW.astc_codemp,1,'DEUDXV')::integer)) or int4eq(NEW.astc_ctacble,idcbl(NEW.astc_codemp,valvaramb(NEW.astc_codemp,1,'DEUDXC')::integer))))  THEN 
	update astoctas set astc_cierra=1 where astc_ctacble=NEW.astc_ctacble and astc_tipcta=NEW.astc_tipcta and astc_ctacte=NEW.astc_ctacte and astc_grupo=NEW.astc_grupo and astc_idastoh!=OLD.astc_idastoh;
    END IF;


    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_astoctas() OWNER TO onlop;

--
-- Name: f_au_astoh(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_au_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.ash_estado,OLD.ash_estado) THEN 
	update astoctas set astc_estado=NEW.ash_estado where astc_idastoh=OLD.ash_id;
	update compra set cpra_estado=NEW.ash_estado where cpra_idastoh=OLD.ash_id;
	update emiti set emi_estado=NEW.ash_estado where emi_idastoh=OLD.ash_id;
	delete from astoctas where astc_importe=0 and astc_idastoh=OLD.ash_id;
	END IF;

    if (int4ne(NEW.ash_estado,OLD.ash_estado) and int4eq(NEW.ash_estado,999))  THEN 
	update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idastoh=OLD.ash_id;
	END IF;

    if date_ne(NEW.ash_fecval,OLD.ash_fecval) THEN 
	update astoctas set astc_fecval=NEW.ash_fecval where astc_idastoh=OLD.ash_id;
	update compra set cpra_fecval=NEW.ash_fecval where cpra_idastoh=OLD.ash_id;
	update emiti set emi_fecval=NEW.ash_fecval where emi_idastoh=OLD.ash_id;
	update astoh set ash_anio=date_part('year',NEW.ash_fecval),ash_mes=date_part('month',NEW.ash_fecval) where ash_id=OLD.ash_id;
	END IF;

    if date_ne(NEW.ash_fecomp,OLD.ash_fecomp) THEN 
	update compra set cpra_fecori=NEW.ash_fecomp where cpra_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_comprob,OLD.ash_comprob) THEN 
	update astoctas set astc_comprob=NEW.ash_comprob where astc_idastoh=OLD.ash_id;
	update compra set cpra_comprob=NEW.ash_comprob where cpra_idastoh=OLD.ash_id;
	update emiti set emi_comprob=NEW.ash_comprob where emi_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_numero,OLD.ash_numero) THEN 
	update astoctas set astc_numero=NEW.ash_numero where astc_idastoh=OLD.ash_id;
	update compra set cpra_numero=NEW.ash_numero where cpra_idastoh=OLD.ash_id;
	update emiti set emi_numero=NEW.ash_numero where emi_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_codemp,OLD.ash_codemp) THEN 
	update astoctas set astc_codemp=NEW.ash_codemp where astc_idastoh=OLD.ash_id;
	update compra set cpra_codemp=NEW.ash_codemp where cpra_idastoh=OLD.ash_id;
	update emiti set emi_codemp=NEW.ash_codemp where emi_idastoh=OLD.ash_id;
	END IF;

    if int4ne(NEW.ash_idptov,OLD.ash_idptov) THEN 
	update astoctas set astc_idptov=NEW.ash_idptov where astc_idastoh=OLD.ash_id;
	update compra set cpra_idptov=NEW.ash_idptov where cpra_idastoh=OLD.ash_id;
	update emiti set emi_idptov=NEW.ash_idptov where emi_idastoh=OLD.ash_id;
	END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_astoh() OWNER TO onlop;

--
-- Name: f_au_cambubic(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_au_cambubic() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.cub_estado,OLD.cub_estado) THEN 
	update movubic set mcub_estado=NEW.cub_estado where mcub_idcub=OLD.cub_id;
	END IF;

    if int4ne(NEW.cub_origen,OLD.cub_origen)  THEN 
	update movubic set mcub_origen=NEW.cub_origen where mcub_idcub=OLD.cub_id;
	END IF;

    if int4ne(NEW.cub_destino,OLD.cub_destino)  THEN 
	update movubic set mcub_destino=NEW.cub_destino where mcub_idcub=OLD.cub_id;
	END IF;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_cambubic() OWNER TO onlop;

--
-- Name: f_au_clientes(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_au_clientes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if bpcharne(NEW.cli_nombre,OLD.cli_nombre) THEN 
	update ctes set cte_nombre=NEW.cli_nombre where cte_codigo=OLD.cli_id and cte_codemp=OLD.cli_codemp and cte_tipcta=eval_funcion(valvaramb(NEW.cli_codemp,ptovdefault(NEW.cli_codemp),'TIPCTADXV'));
	update sucursal set sucu_nombre=NEW.cli_nombre where sucu_cliente=OLD.cli_id and sucu_nombre=OLD.cli_nombre;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_clientes() OWNER TO onlop;

--
-- Name: f_au_compra(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_au_compra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if(int4ne(NEW.cpra_prove,OLD.cpra_prove)) THEN 
	update compra set cpra_nomprov=nomprove(NEW.cpra_prove), cpra_nrcuit=cuitprov(NEW.cpra_prove),cpra_coniva=conivaprov(NEW.cpra_prove) where cpra_id=OLD.cpra_id;
    END IF;

    if int4ne(NEW.cpra_estado,OLD.cpra_estado) THEN 
	update movstoc set movc_estado=NEW.cpra_estado where movc_idcompra=OLD.cpra_id;
	END IF;

    if date_ne(NEW.cpra_fecval,OLD.cpra_fecval) THEN 
	update movstoc set movc_fecval=NEW.cpra_fecval where movc_idcompra=OLD.cpra_id;
	END IF;

    if int2ne(NEW.cpra_moneda,OLD.cpra_moneda) THEN 
	update compra set cpra_impdolar=(ult_cotiz(NEW.cpra_moneda)*cpra_impmon) where cpra_id=OLD.cpra_id;
	update movstoc set movc_moneda=NEW.cpra_moneda,movc_impdolar=(ult_cotiz(NEW.cpra_moneda)*movc_impmon) where movc_idcompra=OLD.cpra_id;
	update movstoc set movc_importe=(cotpeso(movc_fecval)*movc_impdolar) where movc_idcompra=OLD.cpra_id;
	END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_compra() OWNER TO onlop;

--
-- Name: f_au_emiti(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_au_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if int4ne(NEW.emi_estado,OLD.emi_estado) THEN 
	update movsto set movs_estado=NEW.emi_estado where movs_idemiti=OLD.emi_id;
	END IF;

    if int4ne(NEW.emi_codcli,OLD.emi_codcli) THEN 
	update emiti set emi_nomcli=nomcli(NEW.emi_codcli),emi_nrocuit=cuitcli(NEW.emi_codcli),emi_conivac=conivacli(NEW.emi_codcli) where emi_id=OLD.emi_id;
	END IF;



    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_emiti() OWNER TO onlop;

--
-- Name: f_au_movstoc(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_au_movstoc() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
cual	integer;
enarticvt numeric;
vamospor numeric;
BEGIN

    if int2ne(OLD.movc_estado,NEW.movc_estado) THEN 
	update articvt set artv_estado=NEW.movc_estado where artv_idmovstoc=NEW.movc_id;
    end if;

    if(int2eq(NEW.movc_estado,-1::int2) or int2eq(NEW.movc_estado,1::int2)) THEN 
	if(numeric_ne(NEW.movc_canti,OLD.movc_canti)) THEN 
	    delete from articvt where artv_idmovstoc=NEW.movc_id;
	    vamospor:=NEW.movc_canti;
	    WHILE numeric_gt(vamospor,0) LOOP
		vamospor:=vamospor-1;
		insert into articvt (artv_codemp,artv_idmovstoc,artv_idashing,artv_idartic,artv_precioc,artv_tasaiva,artv_codi) values (NEW.movc_codemp,NEW.movc_id,NEW.movc_idastoh,NEW.movc_artic,NEW.movc_precio,NEW.movc_tasa,NEW.movc_impdolar/NEW.movc_canti,codidecartic(NEW.movc_artic));
		if(numeric_gt(vamospor,0) and numeric_lt(vamospor,1)) then
		    insert into articvt (artv_codemp,artv_canti,artv_idmovstoc,artv_idashing,artv_idartic,artv_precioc,artv_tasaiva,artv_codi) values (NEW.movc_codemp,vamospor,NEW.movc_id,NEW.movc_idastoh,NEW.movc_artic,NEW.movc_precio,NEW.movc_tasa,NEW.movc_impdolar/NEW.movc_canti,codidecartic(NEW.movc_artic));
		end if;
	    END LOOP;
	end if;
    end if;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_movstoc() OWNER TO onlop;

--
-- Name: f_au_movubic(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_au_movubic() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if (int4eq(NEW.mcub_estado,2) and int4eq(OLD.mcub_estado,1)) THEN 
	if int4eq(NEW.mcub_origen,1) THEN 
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep6=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep7=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,2) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep2=art_dep2-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep2=art_dep2-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep2=art_dep2-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep2=art_dep2-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep2=art_dep1-NEW.mcub_canti,art_dep6=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep2=art_dep1-NEW.mcub_canti,art_dep7=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,3) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep3=art_dep3-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep3=art_dep3-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep3=art_dep3-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep3=art_dep3-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep3=art_dep1-NEW.mcub_canti,art_dep6=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep3=art_dep1-NEW.mcub_canti,art_dep7=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,4) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep4=art_dep4-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep4=art_dep4-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep4=art_dep4-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep4=art_dep4-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep4=art_dep1-NEW.mcub_canti,art_dep6=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep4=art_dep1-NEW.mcub_canti,art_dep7=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,5) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep5=art_dep1-NEW.mcub_canti,art_dep6=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep5=art_dep1-NEW.mcub_canti,art_dep7=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,6) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep6=art_dep5-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep6=art_dep5-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep6=art_dep5-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep6=art_dep5-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep6=art_dep1-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep6=art_dep1-NEW.mcub_canti,art_dep7=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,7) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep5=art_dep1-NEW.mcub_canti,art_dep6=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep5=art_dep1-NEW.mcub_canti,art_dep7=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;



	END IF;




    if int4eq(NEW.mcub_estado,2) THEN 
	if numeric_ne(NEW.mcub_canti,OLD.mcub_canti)  THEN 
	    if int4eq(OLD.mcub_origen,1) THEN 
		if int4eq(OLD.mcub_destino,2) THEN 
		    update articvta set art_dep1=art_dep1-NEW.mcub_canti+OLD.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,3) THEN 
		    update articvta set art_dep1=art_dep1-NEW.mcub_canti+OLD.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,4) THEN 
		    update articvta set art_dep1=art_dep1-NEW.mcub_canti+OLD.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,5) THEN 
		    update articvta set art_dep1=art_dep1-NEW.mcub_canti+OLD.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,6) THEN 
		    update articvta set art_dep1=art_dep1-NEW.mcub_canti+OLD.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,7) THEN 
		    update articvta set art_dep1=art_dep1-NEW.mcub_canti+OLD.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		END IF;

	    if int4eq(OLD.mcub_origen,2) THEN 
		if int4eq(OLD.mcub_destino,1) THEN 
		    update articvta set art_dep2=art_dep2-NEW.mcub_canti+OLD.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,3) THEN 
		    update articvta set art_dep2=art_dep2-NEW.mcub_canti+OLD.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,4) THEN 
		    update articvta set art_dep2=art_dep2-NEW.mcub_canti+OLD.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,5) THEN 
		    update articvta set art_dep2=art_dep2-NEW.mcub_canti+OLD.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,6) THEN 
		    update articvta set art_dep2=art_dep2-NEW.mcub_canti+OLD.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,7) THEN 
		    update articvta set art_dep2=art_dep2-NEW.mcub_canti+OLD.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		END IF;

	    if int4eq(OLD.mcub_origen,3) THEN 
		if int4eq(OLD.mcub_destino,1) THEN 
		    update articvta set art_dep3=art_dep3-NEW.mcub_canti+OLD.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,2) THEN 
		    update articvta set art_dep3=art_dep3-NEW.mcub_canti+OLD.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,4) THEN 
		    update articvta set art_dep3=art_dep3-NEW.mcub_canti+OLD.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,5) THEN 
		    update articvta set art_dep3=art_dep3-NEW.mcub_canti+OLD.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,6) THEN 
		    update articvta set art_dep3=art_dep3-NEW.mcub_canti+OLD.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,7) THEN 
		    update articvta set art_dep3=art_dep3-NEW.mcub_canti+OLD.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		END IF;

	    if int4eq(OLD.mcub_origen,4) THEN 
		if int4eq(OLD.mcub_destino,1) THEN 
		    update articvta set art_dep4=art_dep4-NEW.mcub_canti+OLD.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,2) THEN 
		    update articvta set art_dep4=art_dep4-NEW.mcub_canti+OLD.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,3) THEN 
		    update articvta set art_dep4=art_dep4-NEW.mcub_canti+OLD.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,5) THEN 
		    update articvta set art_dep4=art_dep4-NEW.mcub_canti+OLD.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,6) THEN 
		    update articvta set art_dep4=art_dep4-NEW.mcub_canti+OLD.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,7) THEN 
		    update articvta set art_dep4=art_dep4-NEW.mcub_canti+OLD.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		END IF;

	    if int4eq(OLD.mcub_origen,5) THEN 
		if int4eq(OLD.mcub_destino,1) THEN 
		    update articvta set art_dep5=art_dep5-NEW.mcub_canti+OLD.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,2) THEN 
		    update articvta set art_dep5=art_dep5-NEW.mcub_canti+OLD.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,3) THEN 
		    update articvta set art_dep5=art_dep5-NEW.mcub_canti+OLD.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,4) THEN 
		    update articvta set art_dep5=art_dep5-NEW.mcub_canti+OLD.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,6) THEN 
		    update articvta set art_dep5=art_dep5-NEW.mcub_canti+OLD.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,7) THEN 
		    update articvta set art_dep5=art_dep5-NEW.mcub_canti+OLD.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		END IF;

	    if int4eq(OLD.mcub_origen,6) THEN 
		if int4eq(OLD.mcub_destino,1) THEN 
		    update articvta set art_dep6=art_dep6-NEW.mcub_canti+OLD.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,2) THEN 
		    update articvta set art_dep6=art_dep6-NEW.mcub_canti+OLD.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,3) THEN 
		    update articvta set art_dep6=art_dep6-NEW.mcub_canti+OLD.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,4) THEN 
		    update articvta set art_dep6=art_dep6-NEW.mcub_canti+OLD.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,5) THEN 
		    update articvta set art_dep6=art_dep6-NEW.mcub_canti+OLD.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,7) THEN 
		    update articvta set art_dep6=art_dep6-NEW.mcub_canti+OLD.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		END IF;

	    if int4eq(OLD.mcub_origen,7) THEN 
		if int4eq(OLD.mcub_destino,1) THEN 
		    update articvta set art_dep7=art_dep7-NEW.mcub_canti+OLD.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,2) THEN 
		    update articvta set art_dep7=art_dep7-NEW.mcub_canti+OLD.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,3) THEN 
		    update articvta set art_dep7=art_dep7-NEW.mcub_canti+OLD.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,4) THEN 
		    update articvta set art_dep7=art_dep7-NEW.mcub_canti+OLD.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,5) THEN 
		    update articvta set art_dep7=art_dep7-NEW.mcub_canti+OLD.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		if int4eq(OLD.mcub_destino,6) THEN 
		    update articvta set art_dep7=art_dep7-NEW.mcub_canti+OLD.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti-OLD.mcub_canti where art_id=NEW.mcub_artic;
		    END IF;
		END IF;
	    END IF;
	END IF;



    if (int4eq(NEW.mcub_estado,999) and int4eq(OLD.mcub_estado,2)) THEN 
	if int4eq(NEW.mcub_origen,1) THEN 
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,2) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,3) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,4) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,5) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;


	if int4eq(NEW.mcub_origen,6) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;


	if int4eq(NEW.mcub_origen,7) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	END IF;




    if (int4eq(NEW.mcub_estado,1) and int4eq(OLD.mcub_estado,2)) THEN 
	if int4eq(NEW.mcub_origen,1) THEN 
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,2) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,3) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,4) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,5) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,6) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,7) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;


	if int4eq(NEW.mcub_origen,7) THEN 
	    if int4eq(NEW.mcub_destino,1) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,2) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,3) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,4) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,5) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(NEW.mcub_destino,6) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;
	END IF;



    if int4ne(NEW.mcub_destino,OLD.mcub_destino) THEN 
	if int4eq(NEW.mcub_destino,1) THEN 
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep1=art_dep1+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_destino,2) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep2=art_dep2+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_destino,3) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep3=art_dep3+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_destino,4) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep4=art_dep4+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_destino,5) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep5=art_dep5+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_destino,6) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep6=art_dep6+NEW.mcub_canti,art_dep7=art_dep7-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_destino,7) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep1=art_dep1-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep2=art_dep2-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep3=art_dep3-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep4=art_dep4-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep5=art_dep5-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep7=art_dep7+NEW.mcub_canti,art_dep6=art_dep6-NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;
	END IF;



    if int4ne(NEW.mcub_origen,OLD.mcub_origen) THEN 
	if int4eq(NEW.mcub_origen,1) THEN 
	    if int4eq(OLD.mcub_origen,2) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,3) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,4) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,5) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,6) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,7) THEN 
		update articvta set art_dep1=art_dep1-NEW.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,2) THEN 
	    if int4eq(OLD.mcub_origen,1) THEN 
		update articvta set art_dep2=art_dep2-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,3) THEN 
		update articvta set art_dep2=art_dep2-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,4) THEN 
		update articvta set art_dep2=art_dep2-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,5) THEN 
		update articvta set art_dep2=art_dep2-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,6) THEN 
		update articvta set art_dep2=art_dep2-NEW.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,7) THEN 
		update articvta set art_dep2=art_dep2-NEW.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,3) THEN 
	    if int4eq(OLD.mcub_origen,1) THEN 
		update articvta set art_dep3=art_dep3-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,2) THEN 
		update articvta set art_dep3=art_dep3-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,4) THEN 
		update articvta set art_dep3=art_dep3-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,5) THEN 
		update articvta set art_dep3=art_dep3-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,6) THEN 
		update articvta set art_dep3=art_dep3-NEW.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,7) THEN 
		update articvta set art_dep3=art_dep3-NEW.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,4) THEN 
	    if int4eq(OLD.mcub_origen,1) THEN 
		update articvta set art_dep4=art_dep4-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,2) THEN 
		update articvta set art_dep4=art_dep4-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,3) THEN 
		update articvta set art_dep4=art_dep4-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,5) THEN 
		update articvta set art_dep4=art_dep4-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,6) THEN 
		update articvta set art_dep4=art_dep4-NEW.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,7) THEN 
		update articvta set art_dep4=art_dep4-NEW.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,5) THEN 
	    if int4eq(OLD.mcub_origen,1) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,2) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,3) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,4) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,6) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,7) THEN 
		update articvta set art_dep5=art_dep5-NEW.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;


	if int4eq(NEW.mcub_origen,6) THEN 
	    if int4eq(OLD.mcub_origen,1) THEN 
		update articvta set art_dep6=art_dep6-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,2) THEN 
		update articvta set art_dep6=art_dep6-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,3) THEN 
		update articvta set art_dep6=art_dep6-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,4) THEN 
		update articvta set art_dep6=art_dep6-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,5) THEN 
		update articvta set art_dep6=art_dep6-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,7) THEN 
		update articvta set art_dep6=art_dep6-NEW.mcub_canti,art_dep7=art_dep7+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	if int4eq(NEW.mcub_origen,7) THEN 
	    if int4eq(OLD.mcub_origen,1) THEN 
		update articvta set art_dep7=art_dep7-NEW.mcub_canti,art_dep1=art_dep1+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,2) THEN 
		update articvta set art_dep7=art_dep7-NEW.mcub_canti,art_dep2=art_dep2+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,3) THEN 
		update articvta set art_dep7=art_dep7-NEW.mcub_canti,art_dep3=art_dep3+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,4) THEN 
		update articvta set art_dep7=art_dep7-NEW.mcub_canti,art_dep4=art_dep4+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,5) THEN 
		update articvta set art_dep7=art_dep7-NEW.mcub_canti,art_dep5=art_dep5+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_origen,6) THEN 
		update articvta set art_dep7=art_dep7-NEW.mcub_canti,art_dep6=art_dep6+NEW.mcub_canti where art_id=NEW.mcub_artic;
		END IF;
	    END IF;

	END IF;


    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_movubic() OWNER TO onlop;

--
-- Name: f_au_prove(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_au_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN

    if bpcharne(NEW.prov_nombre,OLD.prov_nombre) THEN 
	update ctes set cte_nombre=NEW.prov_nombre where cte_codigo=OLD.prov_id and cte_codemp=OLD.prov_codemp and cte_tipcta=eval_funcion(valvaramb(NEW.prov_codemp,ptovdefault(NEW.prov_codemp),'TIPCTADXC'));
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_prove() OWNER TO onlop;

--
-- Name: f_bd_articvta(); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION f_bd_articvta() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
aux_texto 	text;
salidas		numeric;

BEGIN

    select sum(artv_canti) into salidas from articvt where artv_idartic=OLD.art_id and artv_estado!=999;
    if(salidas) THEN 
	RAISE EXCEPTION  'NO SE PUEDE MODIFICAR LA CANTIDAD YA QUE HAY ARTICULOS YA VENDIDOS O COMPROMETIDOS bd_articvta';
    END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_articvta() OWNER TO zona;

--
-- Name: f_bd_astoctas(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bd_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

----------------------------  CHEQUES ---------------------------------------    
	
    select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id) and chq_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN CHEQUE ASIGNADO ANTERIORMENTE';
	    else
		delete from cheques where int4eq(chq_idastoc,OLD.astc_id);
	END IF;
    END IF;


    select count(*) into cuantos from cheques where int4eq(chq_idastoce,OLD.astc_id);
    if found then
	update cheques set chq_estado=2,chq_idastoce=NULL where int4eq(chq_idastoce,OLD.astc_id);
    END IF;

----------------------------  MONEX ---------------------------------------    

    select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id) and mne_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from monex where int4eq(mne_idastoc,OLD.astc_id);
	END IF;
    END IF;

    select count(*) into cuantos from monex where int4eq(mne_idastoce,OLD.astc_id);
    if found then
	update monex set mne_estado=2,mne_idastoce=NULL where int4eq(mne_idastoce,OLD.astc_id);
    END IF;


----------------------------  DOCUM ---------------------------------------    

    select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id) and doc_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from docum where int4eq(doc_idastoc,OLD.astc_id);
	END IF;
    END IF;

    select count(*) into cuantos from docum where int4eq(doc_idastoce,OLD.astc_id);
    if found then
	update docum set doc_estado=2,doc_idastoce=NULL where int4eq(doc_idastoce,OLD.astc_id);
    END IF;

    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_astoctas() OWNER TO onlop;

--
-- Name: f_bd_astoh(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bd_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

    delete from emiti where int4eq(emi_idastoh,OLD.ash_id);
--    delete from compliq where int4eq(cliq_idastoh,OLD.ash_id);
    delete from compra where int4eq(cpra_idastoh,OLD.ash_id);
    delete from astoctas where int4eq(astc_idastoh,OLD.ash_id);
    update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idastoh=OLD.ash_id;
    update articvt set artv_estado=2,artv_idashout=NULL,artv_ubic=3 where artv_idashout=OLD.ash_id;
    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_astoh() OWNER TO onlop;

--
-- Name: f_bd_cambubic(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bd_cambubic() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

    delete from movubic where int4eq(mcub_idcub,OLD.cub_id);
    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_cambubic() OWNER TO onlop;

--
-- Name: f_bd_clientes(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bd_clientes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

    delete from sucursal where int4eq(sucu_cliente,OLD.cli_id);
    delete from telefon where int4eq(tel_codigo,OLD.cli_id) and tel_tiptel=10;
    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_clientes() OWNER TO onlop;

--
-- Name: f_bd_compra(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bd_compra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

    delete from movstoc where int4eq(movc_idcompra,OLD.cpra_id);
    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_compra() OWNER TO onlop;

--
-- Name: f_bd_emiti(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bd_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

    delete from movsto where int4eq(movs_idemiti,OLD.emi_id);
    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_emiti() OWNER TO onlop;

--
-- Name: f_bd_movstoc(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bd_movstoc() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cual	integer;
    BEGIN

    delete from articvt where artv_idmovstoc=OLD.movc_id;
    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_movstoc() OWNER TO onlop;

--
-- Name: f_bd_movubic(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bd_movubic() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN

    if int4eq(OLD.mcub_estado,2) THEN 
	if int4eq(OLD.mcub_origen,1) THEN 
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep1=art_dep1+OLD.mcub_canti,art_dep2=art_dep2-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep1=art_dep1+OLD.mcub_canti,art_dep3=art_dep3-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep1=art_dep1+OLD.mcub_canti,art_dep4=art_dep4-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep1=art_dep1+OLD.mcub_canti,art_dep5=art_dep5-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep1=art_dep1+OLD.mcub_canti,art_dep6=art_dep6-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep1=art_dep1+OLD.mcub_canti,art_dep7=art_dep7-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    END IF;

	if int4eq(OLD.mcub_origen,2) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep2=art_dep2+OLD.mcub_canti,art_dep1=art_dep1-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep2=art_dep2+OLD.mcub_canti,art_dep3=art_dep3-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep2=art_dep2+OLD.mcub_canti,art_dep4=art_dep4-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep2=art_dep2+OLD.mcub_canti,art_dep5=art_dep5-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep2=art_dep2+OLD.mcub_canti,art_dep6=art_dep6-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep2=art_dep2+OLD.mcub_canti,art_dep7=art_dep7-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    END IF;

	if int4eq(OLD.mcub_origen,3) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep3=art_dep3+OLD.mcub_canti,art_dep1=art_dep1-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep3=art_dep3+OLD.mcub_canti,art_dep2=art_dep2-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep3=art_dep3+OLD.mcub_canti,art_dep4=art_dep4-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep3=art_dep3+OLD.mcub_canti,art_dep5=art_dep5-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep3=art_dep3+OLD.mcub_canti,art_dep6=art_dep6-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep3=art_dep3+OLD.mcub_canti,art_dep7=art_dep7-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    END IF;

	if int4eq(OLD.mcub_origen,4) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep4=art_dep4+OLD.mcub_canti,art_dep1=art_dep1-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep4=art_dep4+OLD.mcub_canti,art_dep2=art_dep2-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep4=art_dep4+OLD.mcub_canti,art_dep3=art_dep3-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep4=art_dep4+OLD.mcub_canti,art_dep5=art_dep5-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep4=art_dep4+OLD.mcub_canti,art_dep6=art_dep6-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep4=art_dep4+OLD.mcub_canti,art_dep7=art_dep7-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    END IF;

	if int4eq(OLD.mcub_origen,5) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep5=art_dep5+OLD.mcub_canti,art_dep1=art_dep1-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep5=art_dep5+OLD.mcub_canti,art_dep2=art_dep2-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep5=art_dep5+OLD.mcub_canti,art_dep3=art_dep3-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep5=art_dep5+OLD.mcub_canti,art_dep4=art_dep4-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep5=art_dep5+OLD.mcub_canti,art_dep6=art_dep6-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep5=art_dep5+OLD.mcub_canti,art_dep7=art_dep7-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    END IF;

	if int4eq(OLD.mcub_origen,6) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep6=art_dep6+OLD.mcub_canti,art_dep1=art_dep1-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep6=art_dep6+OLD.mcub_canti,art_dep2=art_dep2-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep6=art_dep6+OLD.mcub_canti,art_dep3=art_dep3-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep6=art_dep6+OLD.mcub_canti,art_dep4=art_dep4-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep6=art_dep6+OLD.mcub_canti,art_dep5=art_dep5-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,7) THEN 
		update articvta set art_dep6=art_dep6+OLD.mcub_canti,art_dep7=art_dep7-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    END IF;

	if int4eq(OLD.mcub_origen,7) THEN 
	    if int4eq(OLD.mcub_destino,1) THEN 
		update articvta set art_dep7=art_dep7+OLD.mcub_canti,art_dep1=art_dep1-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,2) THEN 
		update articvta set art_dep7=art_dep7+OLD.mcub_canti,art_dep2=art_dep2-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,3) THEN 
		update articvta set art_dep7=art_dep7+OLD.mcub_canti,art_dep3=art_dep3-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,4) THEN 
		update articvta set art_dep7=art_dep7+OLD.mcub_canti,art_dep4=art_dep4-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,5) THEN 
		update articvta set art_dep7=art_dep7+OLD.mcub_canti,art_dep5=art_dep5-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    if int4eq(OLD.mcub_destino,6) THEN 
		update articvta set art_dep7=art_dep7+OLD.mcub_canti,art_dep6=art_dep6-OLD.mcub_canti where art_id=OLD.mcub_artic;
		END IF;
	    END IF;
	END IF;
    
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_movubic() OWNER TO onlop;

--
-- Name: f_bu_astoh(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bu_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN


if(int4eq(NEW.ash_estado,2) and int4eq(OLD.ash_estado,-1)) THEN 


------------------ PARTIDA DOBLE -----------------------------------

    select sum(astc_importe) into saldo from astoctas where astc_idastoh=NEW.ash_id;
    if numeric_ne(saldo,0) then
	RAISE EXCEPTION  'NO SE PUEDE FINALIZAR EL ASIENTO YA QUE EL SALDO ES DISTINTO DE CERO';
    end if;

------------------ CASO CHEQUES -----------------------------------



END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_astoh() OWNER TO onlop;

--
-- Name: f_bu_cheques(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bu_cheques() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN


if(int4eq(NEW.chq_estado,2) and int4ne(OLD.chq_estado,2)) THEN 


    select astc_importe into saldo from astoctas where astc_id=NEW.chq_idastoce;
    if found then
	RAISE EXCEPTION  'NO SE PUEDE CAMBIAR DE ESTADO UN CHEQUE UTILIZADO';
    end if;

END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_cheques() OWNER TO onlop;

--
-- Name: f_bu_movstoc(); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION f_bu_movstoc() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos	numeric;
    cuantos1	numeric;
    hayenarticv	numeric;
    aux_texto	text;
    BEGIN

    if int2eq(NEW.movc_estado,2::int2) THEN 
	if(numeric_ne(NEW.movc_canti,OLD.movc_canti)) THEN 
	    select sum(artv_canti) into hayenarticv from articvt where artv_idmovstoc=NEW.movc_id;
	    if(numeric_ne(NEW.movc_canti,hayenarticv)) THEN 
		RAISE EXCEPTION  'NO SE PUEDE MODIFICAR LA CANTIDAD YA QUE NO COINCIDE CON ARTICVT bu_movsto';
		END IF;
	    aux_texto:='El usuario autorizado ha modificado la cantidad del ingreso en MOVSTOC '|| NEW.movc_id ||' del Asiento noticias '|| NEW.movc_idastoh ||' que tenia una cantidad de '||OLD.movc_canti||' por una cantidad de '||NEW.movc_canti;
    	    insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.movc_idastoh,aux_texto);
	    END IF;

	if(numeric_ne(NEW.movc_precio,OLD.movc_precio)) THEN 
	    aux_texto:='El usuario autorizado ha modificado el precio del ingreso en MOVSTOC '|| NEW.movc_id ||' del Asiento noticias '|| NEW.movc_idastoh ||' que tenia un precio de '||OLD.movc_precio||' por un precio de '||NEW.movc_precio;
    	    insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.movc_idastoh,aux_texto);
	    END IF;

	if(numeric_ne(NEW.movc_importe,OLD.movc_importe)) THEN 
	    aux_texto:='El usuario autorizado ha modificado el importe del ingreso en MOVSTOC '|| NEW.movc_id ||' del Asiento noticias '|| NEW.movc_idastoh ||' que tenia un importe de '||OLD.movc_importe||' por un importe de '||NEW.movc_importe;
    	    insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.movc_idastoh,aux_texto);
	    END IF;

	if(int2ne(NEW.movc_moneda,OLD.movc_moneda)) THEN 
	    aux_texto:='El usuario autorizado ha modificado la moneda del ingreso en MOVSTOC '|| NEW.movc_id ||' del Asiento noticias '|| NEW.movc_idastoh ||' que tenia la moneda '||OLD.movc_moneda||' por la moneda  '||NEW.movc_moneda;
    	    insert into noticias(not_tipo,not_numero,not_texto)values(1,NEW.movc_idastoh,aux_texto);
	    END IF;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_movstoc() OWNER TO onlop;

--
-- Name: facturo(integer, integer, smallint, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION facturo(integer, integer, smallint, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	cliente		ALIAS FOR $2; 
	estado		ALIAS FOR $3; 
	operador	ALIAS FOR $4; 
	ivaemp 		smallint;
	ivacli 		smallint;
	registro	record;
	regi		record;
	aux_texto 	text;
	idcompro	integer;
	idmovsto	integer;
	idastoh		integer;
	idemiti		integer;
	lineas		integer;
	yvan		integer;
	primera		integer;
	numero		integer;
	ptonew		integer;
	ptoold		integer;
	clinew		integer;
	cliold		integer;
	yapase		integer;
	eliva		numeric;
	elivast		numeric;
	retval 		integer;
    BEGIN
    retval:=0;
    primera:=0;
    ptoold:=0;
    ptonew:=0;
    yapase:=0;
    yvan:=0;


    select valvaramb(codemp,ptovdefault(codemp),'LINFAC') into lineas;
    select emp_coniva into ivaemp from empresa where emp_codigo=codemp;

    if(int4eq(cliente,0)) then
	for registro in select * from facturacion where fac_codemp=codemp and fac_estado=estado 
	loop
	    ptonew:=registro.fac_ptov;
	    clinew:=registro.fac_cliente;

	    if(int4eq(primera,0) or int4ne(ptonew,ptoold) or int4ne(clinew,cliold)) then
		ptoold:=registro.fac_ptov;
		cliold:=registro.fac_cliente;
		select cli_coniva into ivacli from clientes where cli_id=registro.fac_cliente;
		if(int2eq(ivaemp,1::int2)) then
		    if(int2eq(ivacli,1::int2)) then
			select idcomp('FA',ptonew) into idcompro;
		      else		
			select idcomp('FB',ptonew) into idcompro;
		    end if;
	          else
		    select idcomp('FC',ptonew) into idcompro;
		end if;


		select numtalon(ptonew,idcompro,1) into numero;
		select nomcomp(idcompro) into aux_texto;
		insert into astoh (ash_estado,ash_codemp,ash_idptov,ash_anio,ash_mes,ash_fecomp,ash_fecval,ash_operad,ash_comprob,ash_numero,ash_titulo) values (-2,registro.fac_codemp,registro.fac_ptov,registro.fac_anio,registro.fac_mes,registro.fac_fecha,registro.fac_fecfac,operador,idcompro,numero,aux_texto);
		select max(ash_id) into idastoh from astoh;
		insert into emiti (emi_idastoh,emi_codemp,emi_idptov,emi_comprob,emi_numero,emi_fecval,emi_codcli,emi_nomcli,emi_nrocuit,emi_provin,emi_grupo,emi_succli,emi_conivac,emi_conpag,emi_estado) values (idastoh,registro.fac_codemp,registro.fac_ptov,idcompro,numero,registro.fac_fecfac,registro.fac_cliente,nomcli(registro.fac_cliente),cuitcli(registro.fac_cliente),provinclie(registro.fac_cliente,registro.fac_ptov),grupocli(registro.fac_cliente,1),registro.fac_ptov,ivacli,conpagcli(registro.fac_cliente),-2);
		select max(emi_id) into idemiti from emiti;
		update astoh set ash_idemiti=idemiti where ash_id=idastoh;
		insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_tasa,movs_estado,movs_codcli,movs_clireal,movs_idoper,movs_leyen) values (idastoh,idemiti,registro.fac_codemp,registro.fac_ptov,registro.fac_fecha,registro.fac_idart,registro.fac_canti,registro.fac_dias,registro.fac_precio,registro.fac_importe,tasaartic(registro.fac_idart),-2,registro.fac_cliente,registro.fac_clireal,registro.fac_idoper,registro.fac_leyen);
		primera:=1;
		yvan:=1;

	      else

		select movs_id into idmovsto from movsto where movs_idastoh=idastoh and movs_idemiti=idemiti and movs_artic=registro.fac_idart and movs_precio=registro.fac_precio;
		if not found then
		    insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_tasa,movs_estado,movs_codcli,movs_clireal,movs_idoper,movs_leyen) values (idastoh,idemiti,registro.fac_codemp,registro.fac_ptov,registro.fac_fecfac,registro.fac_idart,registro.fac_canti,registro.fac_dias,registro.fac_precio,registro.fac_importe,tasaartic(registro.fac_idart),-2,registro.fac_cliente,registro.fac_clireal,registro.fac_idoper,registro.fac_leyen);
		    yvan:=yvan + 1; 
		    if int4eq(yvan,lineas)then
		      primera:=0;
		      yvan:=0; 
		    end if;
		  else
		    update movsto set movs_canti=movs_canti+registro.fac_canti,movs_importe=movs_importe+registro.fac_importe,movs_dias=movs_dias+registro.fac_dias where movs_id=idmovsto;
		    update movsto set movs_dias=movs_importe/movs_canti/movs_precio where movs_id=idmovsto;
		end if;

	    end if;
	end loop;
    update facturacion set fac_estado=2 where fac_codemp=codemp and fac_estado=estado;
    end if;


    if(int4ne(cliente,0)) then
	for registro in select * from facturacion where fac_codemp=codemp and fac_cliente=cliente and fac_estado=estado
	loop
	    ptonew:=registro.fac_ptov;
	    if(int4eq(primera,0) or int4ne(ptonew,ptoold)) then
		ptoold:=registro.fac_ptov;
		select cli_coniva into ivacli from clientes where cli_id=cliente;
		if(int2eq(ivaemp,1::int2)) then
		    if(int2eq(ivacli,1::int2)) then
			select idcomp('FA',ptonew) into idcompro;
		      else		
			select idcomp('FB',ptonew) into idcompro;
		    end if;
	          else
		    select idcomp('FC',ptonew) into idcompro;
		end if;
		select numtalon(ptonew,idcompro,1) into numero;
		select nomcomp(idcompro) into aux_texto;
		insert into astoh (ash_estado,ash_codemp,ash_idptov,ash_anio,ash_mes,ash_fecomp,ash_fecval,ash_operad,ash_comprob,ash_numero,ash_titulo) values (-2,registro.fac_codemp,registro.fac_ptov,registro.fac_anio,registro.fac_mes,registro.fac_fecha,registro.fac_fecfac,operador,idcompro,numero,aux_texto);
		select max(ash_id) into idastoh from astoh;
		insert into emiti (emi_idastoh,emi_codemp,emi_idptov,emi_comprob,emi_numero,emi_fecval,emi_codcli,emi_nomcli,emi_nrocuit,emi_provin,emi_grupo,emi_succli,emi_conivac,emi_conpag,emi_estado) values (idastoh,registro.fac_codemp,registro.fac_ptov,idcompro,numero,registro.fac_fecfac,registro.fac_cliente,nomcli(registro.fac_cliente),cuitcli(registro.fac_cliente),provinclie(registro.fac_cliente,registro.fac_ptov),grupocli(registro.fac_cliente,1),registro.fac_ptov,ivacli,conpagcli(registro.fac_cliente),-2);
		select max(emi_id) into idemiti from emiti;
		update astoh set ash_idemiti=idemiti where ash_id=idastoh;
		insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_tasa,movs_estado,movs_codcli,movs_clireal,movs_idoper,movs_leyen) values (idastoh,idemiti,registro.fac_codemp,registro.fac_ptov,registro.fac_fecha,registro.fac_idart,registro.fac_canti,registro.fac_dias,registro.fac_precio,registro.fac_importe,tasaartic(registro.fac_idart),-2,registro.fac_cliente,registro.fac_clireal,registro.fac_idoper,registro.fac_leyen);
		primera:=1;
		yvan:=1;

	      else

		select movs_id into idmovsto from movsto where movs_idastoh=idastoh and movs_idemiti=idemiti and movs_artic=registro.fac_idart and movs_precio=registro.fac_precio;
		if not found then
		    insert into movsto (movs_idastoh,movs_idemiti,movs_codemp,movs_idptov,movs_fecval,movs_artic,movs_canti,movs_dias,movs_precio,movs_importe,movs_tasa,movs_estado,movs_codcli,movs_clireal,movs_idoper,movs_leyen) values (idastoh,idemiti,registro.fac_codemp,registro.fac_ptov,registro.fac_fecfac,registro.fac_idart,registro.fac_canti,registro.fac_dias,registro.fac_precio,registro.fac_importe,tasaartic(registro.fac_idart),-2,registro.fac_cliente,registro.fac_clireal,registro.fac_idoper,registro.fac_leyen);
		    yvan:=yvan + 1; 
		    if int4eq(yvan,lineas)then
		      primera:=0;
		      yvan:=0; 
		    end if;
		  else
		    update movsto set movs_canti=movs_canti+registro.fac_canti, movs_importe=movs_importe+registro.fac_importe, movs_dias=movs_dias+registro.fac_dias where movs_id=idmovsto;
		    update movsto set movs_dias=movs_importe/movs_canti/movs_precio where movs_id=idmovsto;
		end if;
	    end if;
	end loop;
    update facturacion set fac_estado=2 where fac_codemp=codemp and fac_cliente=cliente and fac_estado=estado;
    end if;


    eliva:=0;
    elivast:=0;
    for regi in select * from astoh where ash_estado=-2
	loop
	    select sum(movs_importe * movs_tasa / 100) into eliva from movsto where movs_idastoh=regi.ash_id;
	    select graboastocta(regi.ash_id,eliva,elivast,0::numeric) into yapase;
	end loop;
    update astoh set ash_estado=-1 where ash_estado=-2;

    retval:=yapase;

RETURN retval;
END;$_$;


ALTER FUNCTION public.facturo(integer, integer, smallint, integer) OWNER TO onlop;

--
-- Name: fecdechq(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION fecdechq(integer) RETURNS date
    LANGUAGE sql
    AS $_$select chq_fecheq from cheques where chq_id= $1 ;$_$;


ALTER FUNCTION public.fecdechq(integer) OWNER TO onlop;

--
-- Name: fecvalash(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION fecvalash(integer) RETURNS date
    LANGUAGE sql
    AS $_$select ash_fecval from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.fecvalash(integer) OWNER TO onlop;

--
-- Name: fecvalastc(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION fecvalastc(integer) RETURNS date
    LANGUAGE sql
    AS $_$select astc_fecval from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.fecvalastc(integer) OWNER TO onlop;

--
-- Name: gastoct(integer, integer, integer, numeric); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION gastoct(integer, integer, integer, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	cuenta		ALIAS FOR $2; 
	grupo		ALIAS FOR $3; 
	importe		ALIAS FOR $4; 
	retval 		integer;
    BEGIN
    retval:=0;
    if numeric_ne(importe,0::numeric) then

	insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_grupo,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado) 
	     select idastoh,cuenta,importe,grupo,ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval,-1 
	         from astoh where ash_id=idastoh;

	select astc_id into retval from astoctas order by astc_id desc limit 1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.gastoct(integer, integer, integer, numeric) OWNER TO onlop;

--
-- Name: gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	cuenta		ALIAS FOR $2; 
	grupo		ALIAS FOR $3; 
	importe		ALIAS FOR $4; 
	tipcta		ALIAS FOR $5; 
	ctacte		ALIAS FOR $6; 
	nucheq		ALIAS FOR $7; 
	fecvto		ALIAS FOR $8; 
	retval 		integer;
    BEGIN
    retval:=0;
    if numeric_ne(importe,0::numeric) then
	insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_grupo,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_tipcta,astc_ctacte,astc_nucheq,astc_fecvto) 
	     select idastoh,cuenta,importe,grupo,ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval,-1,tipcta,ctacte,nucheq,fecvto
	         from astoh where ash_id=idastoh;

	select astc_id into retval from astoctas order by astc_id desc limit 1;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.gastoct_cta(integer, integer, integer, numeric, integer, integer, integer, date) OWNER TO onlop;

--
-- Name: graboarticvt(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION graboarticvt(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	vamospor	numeric;
	elcli		integer;
	idemiti		integer;
	idarticvt	integer;
	registro	record;
	retval 		integer;
    BEGIN

    retval:=0;
    select emi_codcli,emi_id into elcli,idemiti from emiti where emi_idastoh=idastoh;

    for registro in select * from movsto where movs_idastoh=idastoh 
        loop
	    vamospor:=registro.movs_canti;
	    WHILE numeric_gt(vamospor,0) 
		LOOP
		    vamospor:=vamospor-1;
		    select artv_id into idarticvt from articvt where artv_idartic=registro.movs_artic and artv_estado=2 and artv_ubic in (2,3,4)and artv_canti=1 order by artv_id limit 1;
		    update articvt set artv_idashout=idastoh,
			 artv_estado=101,artv_ubic=101,artv_cliente=elcli,artv_preciov=registro.movs_precio
			  where artv_id=idarticvt;
			  
		    if(numeric_gt(vamospor,0) and numeric_lt(vamospor,1)) then
		    select artv_id into idarticvt from articvt where artv_idartic=registro.movs_artic and artv_estado=2 and artv_ubic in (2,3,4)and artv_canti!=1 order by artv_id limit 1;
		    update articvt set artv_idashout=idastoh,
			 artv_estado=101,artv_ubic=101,artv_cliente=elcli,artv_preciov=registro.movs_precio,artv_canti=artv_canti-vamospor
			  where artv_id=idarticvt;
		    end if;
		retval:=1;
		END LOOP;
	END LOOP;
    RETURN retval;
END;$_$;


ALTER FUNCTION public.graboarticvt(integer) OWNER TO onlop;

--
-- Name: graboastocta(integer, numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION graboastocta(integer, numeric, numeric, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva		ALIAS FOR $2; 
	ivast		ALIAS FOR $3; 
	descto		ALIAS FOR $4; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	fecval		date;
	total		numeric;
	otros		numeric;
	ctadeud		integer;
	tipct		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXV')::smallint) into ctadeud;
select valvaramb(codemp,1,'TIPCTADEPG')::integer into tctdepg;
select tipctacbl(ctadeud) into tipct;
select emi_codcli,emi_grupo into elcli,grupo from emiti where emi_idastoh=idastoh;
select codcompash(idastoh) into codcompr;

if (bpchareq(codcompr,'CA') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'CC')) then
	signo= -1; 
    else
	signo= 1; 
end if;


total:=0;
for registro in select a.art_idcbl as cuenta, b.movs_tasa as latasa, tipctacbl(a.art_idcbl) as cualtipcta, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh 
        and b.movs_artic=a.art_id group by 1,2,3
	loop

	if found then 
	    if(int4eq(registro.cualtipcta, tctdepg)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (idctes(tctdepg,codcli(elcli)),tctdepg,registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	    total:=total + registro.cuanto;
	end if;
end loop; 


for regis in select movs_tasa as vlatasa, sum(movs_importe) as vcuanto
     from movsto where movs_idastoh=idastoh group by 1
	loop
	if found then 
	    if numeric_ne(regis.vlatasa,0::numeric) then 
		select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVA')::smallint) into ctaiva;
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.vlatasa,ctaiva,(regis.vcuanto * -1 * regis.vlatasa / 100)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	end if;
end loop; 


if numeric_ne(iva,0::numeric) then
    total:=total + iva;
end if;

if numeric_ne(ivast,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVAST')::smallint) into ctaivast;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctaivast,(ivast * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (ivast * signo);
end if;

if numeric_ne(descto,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTADESCTO')::smallint) into ctadescto;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctadescto,(descto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (descto * signo);
end if;

insert into astoctas (astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (grupo,elcli,tipct,ctadeud,total::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

update emiti set emi_total=total where emi_idastoh=idastoh;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastocta(integer, numeric, numeric, numeric) OWNER TO onlop;

--
-- Name: graboastoctac(integer, numeric, numeric, numeric, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION graboastoctac(integer, numeric, numeric, numeric, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva		ALIAS FOR $2; 
	ivast		ALIAS FOR $3; 
	descto		ALIAS FOR $4; 
	tipcta		ALIAS FOR $5; 
	ctact		ALIAS FOR $6; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	fecval		date;
	total		numeric;
	otros		numeric;
	ctadeud		integer;
	tipct		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXV')::smallint) into ctadeud;
select valvaramb(codemp,1,'TIPCTADEPG')::integer into tctdepg;
select tipctacbl(ctadeud) into tipct;
select emi_codcli,emi_grupo into elcli,grupo from emiti where emi_idastoh=idastoh;
select codcompash(idastoh) into codcompr;

if (bpchareq(codcompr,'CA') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'CC')) then
	signo= -1; 
    else
	signo= 1; 
end if;


total:=0;
for registro in select a.art_idcbl as cuenta, b.movs_tasa as latasa, tipctacbl(a.art_idcbl) as cualtipcta, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh 
        and b.movs_artic=a.art_id group by 1,2,3
	loop

	if found then 
	    if(int4eq(registro.cualtipcta, tctdepg)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (idctes(tctdepg,codcli(elcli)),tctdepg,registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
	    if(int4eq(registro.cualtipcta, tipcta)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (ctact,tipcta,registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (registro.latasa,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	    end if;
	    total:=total + registro.cuanto;
	end if;
end loop; 


for regis in select movs_tasa as vlatasa, sum(movs_importe) as vcuanto
     from movsto where movs_idastoh=idastoh group by 1
	loop
	if found then 
	    if numeric_ne(regis.vlatasa,0::numeric) then 
		select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVA')::smallint) into ctaiva;
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (regis.vlatasa,ctaiva,(regis.vcuanto * -1 * regis.vlatasa / 100)::numeric(15,2),idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	end if;
end loop; 


if numeric_ne(iva,0::numeric) then
    total:=total + iva;
end if;

if numeric_ne(ivast,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTAIVAST')::smallint) into ctaivast;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctaivast,(ivast * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (ivast * signo);
end if;

if numeric_ne(descto,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTADESCTO')::smallint) into ctadescto;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctadescto,(descto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (descto * signo);
end if;

insert into astoctas (astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (grupo,elcli,tipct,ctadeud,total::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

update emiti set emi_total=total where emi_idastoh=idastoh;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastoctac(integer, numeric, numeric, numeric, integer, integer) OWNER TO onlop;

--
-- Name: graboastoctam(integer, numeric, numeric, numeric); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION graboastoctam(integer, numeric, numeric, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idastoh		ALIAS FOR $1; 
	iva		ALIAS FOR $2; 
	ivast		ALIAS FOR $3; 
	descto		ALIAS FOR $4; 
	registro	record;
	regis		record;
	codemp		integer;
	idptov		integer;
	comprob 	integer;
	numero		integer;
	fecval		date;
	total		numeric;
	otros		numeric;
	ctadeud		integer;
	tipct		integer;
	tctdepg		integer;
	elcli		integer;
	signo		integer;
	grupo		integer;
	ctaiva		integer;
	ctaivast	integer;
	ctadescto	integer;
	codcompr	character varying;
	retval 		integer;
    BEGIN
select ash_codemp,ash_idptov,ash_comprob,ash_numero,ash_fecval into codemp,idptov,comprob,numero,fecval from astoh where ash_id=idastoh;
select idcbl(codemp, valvaramb(codemp,idptov,'DEUDXV')::smallint) into ctadeud;
select valvaramb(codemp,1,'TIPCTADEPG')::integer into tctdepg;
select tipctacbl(ctadeud) into tipct;
select emi_codcli,emi_grupo into elcli,grupo from emiti where emi_idastoh=idastoh;
select codcompash(idastoh) into codcompr;

if (bpchareq(codcompr,'CA') or bpchareq(codcompr,'CB') or bpchareq(codcompr,'CC')) then
	signo= -1; 
    else
	signo= 1; 
end if;


total:=0;
for registro in select a.art_idcbl as cuenta, b.movs_tasa as latasa, tipctacbl(a.art_idcbl) as cualtipcta, sum(b.movs_importe) as cuanto 
     from movsto b, articvta a where b.movs_idastoh=idastoh 
        and b.movs_artic=a.art_id group by 1,2,3
	loop

	if found then 
	    if(int4eq(registro.cualtipcta, tctdepg)) then
		insert into astoctas (astc_ctacte,astc_tipcta,astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (idctes(tctdepg,codcli(elcli)),tctdepg,0,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	      else
		insert into astoctas (astc_tasa,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
		    values (0,registro.cuenta,(registro.cuanto * -1)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
	    end if;
	    total:=total + registro.cuanto;
	end if;
end loop; 


if numeric_ne(descto,0::numeric) then
select idcbl(codemp, valvaramb(codemp,idptov,'CTADESCTO')::smallint) into ctadescto;
    insert into astoctas (astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (ctadescto,(descto * -1 * signo)::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);
total:=total + (descto * signo);
end if;

insert into astoctas (astc_grupo,astc_ctacte,astc_tipcta,astc_ctacble,astc_importe,astc_idastoh,astc_estado,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval) 
	values (grupo,elcli,tipct,ctadeud,total::numeric,idastoh,-1::int2,codemp,idptov,comprob,numero,fecval::date);

update emiti set emi_total=total where emi_idastoh=idastoh;

retval:=signo;

RETURN retval;
END;$_$;


ALTER FUNCTION public.graboastoctam(integer, numeric, numeric, numeric) OWNER TO onlop;

--
-- Name: grabocontrapart(integer, integer, numeric, numeric); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION grabocontrapart(integer, integer, numeric, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
sitem			alias for $1; -- Id del Subitem retirado
operacion 		alias for $2; -- Operacion de contrapartida
cantidad 		alias for $3; -- Cantidad Retirada a Ingresar
importe 		alias for $4; -- Importe del Subitem a crear (retiro)
registro_op 		RECORD;
registro_artic		RECORD;
registro_item 		RECORD;
registro_sitem 		RECORD;
nuevoiditem		int4;
codarticulo		varchar;
articulo		int4;
iddelitem		int4;
impsitem		numeric;
impdolsitem		numeric;
idsitemcreado		int4;
ret			int4;

begin

for registro_op in select 
    op_directo as directo, 
    op_indirecto as indirecto, 
    op_moneda as monedao, 
    op_deposito as deposito 
     from operaciones where op_id=operacion
	loop
	    ret:=1;		
	end loop; 

    for registro_sitem in select 
	sitem_iditem as iditem, 
	sitem_idoper as operacontrap, 
        sitem_artic as idartic, 
	sitem_tipemb as tipemb, 
	sitem_deposito as sdeposito, 
        sitem_compbte as compbte 
	 from subitem where sitem_id=sitem
	    loop
	    iddelitem:=registro_sitem.iditem;
	    ret:=1;		
	end loop; 

select artic_codigo into codarticulo from articu
where artic_id=registro_sitem.idartic;


select artic_id into articulo from articu
where artic_codigo=codarticulo and artic_indirecto=registro_op.indirecto;
if not found then

for registro_artic in select 
    artic_marca as marca, 
    artic_modelo as modelo, 
    artic_descrip as descrip, 
    artic_present as present, 
    artic_tiprod as arttiprod, 
    artic_posa as artposa, 
    artic_unimed as artunimed 
     from articu where artic_id=registro_sitem.idartic
	loop

if(registro_artic.arttiprod is null) then registro_artic.arttiprod:=1; end if;
if(registro_artic.artunimed is null) then registro_artic.artunimed:=1; end if;
if(registro_artic.artposa is null) then registro_artic.artposa:='DESCONOCIDA'; end if;
if(registro_artic.marca is null) then registro_artic.marca:='DESCONOCIDA'; end if;
if(registro_artic.modelo is null) then registro_artic.modelo:='DESCONOCIDA'; end if;
if(registro_artic.descrip is null) then registro_artic.descrip:='DESCONOCIDA'; end if;
if(registro_artic.present is null) then registro_artic.present:='DESCONOCIDA'; end if;
--begin work; 
--lock item in access exclusive mode;
insert into articu (artic_indirecto,artic_codigo,artic_marca,artic_modelo,artic_descrip,artic_present,artic_tiprod,artic_posa,artic_unimed) 
values (registro_op.indirecto,codarticulo,registro_artic.marca,registro_artic.modelo,registro_artic.descrip,registro_artic.present,registro_artic.arttiprod,registro_artic.artposa,registro_artic.artunimed);

select max(artic_id) into articulo from articu;
--commit;
end loop; 
end if;


	for registro_item in select 
	    item_moneda as moneda, 
	    item_tipprod as tipprod, 
	    item_unimed as unimed, 
	    item_posa as posa 
	     from item where item_id=iddelitem
		loop

	    if(registro_item.moneda is null) then registro_item.moneda:=registro_op.monedao; end if;
	    if(registro_item.tipprod is null) then registro_item.tipprod:=registro_artic.arttiprod; end if;
	    if(registro_item.unimed is null) then registro_item.unimed:=registro_artic.artunimed; end if;
	    if(registro_item.posa is null) then registro_item.posa:=registro_artic.artposa; end if;
	    
--	    begin work; 
--	    lock item in access exclusive mode;
	    insert into item (item_idoper,item_moneda,item_tipprod,item_unimed,item_posa) 
	    values (operacion,registro_item.moneda,registro_item.tipprod,registro_item.unimed,registro_item.posa);
	    select max(item_id) into nuevoiditem from item;
--	    commit;

	    if(registro_op.deposito is null) then registro_op.deposito:=registro_sitem.sdeposito; end if;

	    if (importe>0) then
		    impsitem:=importe;
		    impdolsitem:=importe * moncteopera(operacion);
		else
		    impsitem:=cantidad*precio_unitariod(sitem);
		    impdolsitem:=impsitem;
	    end if;

	    insert into subitem (sitem_iditem,sitem_artic,sitem_tipemb,sitem_compbte,sitem_idoper,sitem_canting,sitem_importe,sitem_deposito,sitem_directo,sitem_indirecto,sitem_imp_dolar) values (nuevoiditem,articulo,registro_sitem.tipemb,registro_sitem.compbte,operacion,cantidad,impsitem,registro_op.deposito,registro_op.directo,registro_op.indirecto,impdolsitem);
	    select max(sitem_id) into idsitemcreado from subitem;
	
	    ret:=idsitemcreado;		
	end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.grabocontrapart(integer, integer, numeric, numeric) OWNER TO onlop;

--
-- Name: grabocontrapart(integer, integer, real, numeric); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION grabocontrapart(integer, integer, real, numeric) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
declare
sitem			alias for $1; -- Id del Subitem retirado
operacion 		alias for $2; -- Operacion de contrapartida
cantidad 		alias for $3; -- Cantidad Retirada a Ingresar
importe 		alias for $4; -- Importe del Subitem a crear (retiro)
registro_op 		RECORD;
registro_artic		RECORD;
registro_item 		RECORD;
registro_sitem 		RECORD;
nuevoiditem		int4;
codarticulo		varchar;
articulo		int4;
iddelitem		int4;
impsitem		numeric;
impdolsitem		numeric;
idsitemcreado		int4;
ret			int4;

begin

for registro_op in select 
    op_directo as directo, 
    op_indirecto as indirecto, 
    op_moneda as monedao, 
    op_deposito as deposito 
     from operaciones where op_id=operacion
	loop
	    ret:=1;		
	end loop; 

    for registro_sitem in select 
	sitem_iditem as iditem, 
	sitem_idoper as operacontrap, 
        sitem_artic as idartic, 
	sitem_tipemb as tipemb, 
	sitem_deposito as sdeposito, 
        sitem_compbte as compbte 
	 from subitem where sitem_id=sitem
	    loop
	    iddelitem:=registro_sitem.iditem;
	    ret:=1;		
	end loop; 

select artic_codigo into codarticulo from articu
where artic_id=registro_sitem.idartic;


select artic_id into articulo from articu
where artic_codigo=codarticulo and artic_indirecto=registro_op.indirecto;
if not found then

for registro_artic in select 
    artic_marca as marca, 
    artic_modelo as modelo, 
    artic_descrip as descrip, 
    artic_present as present, 
    artic_tiprod as arttiprod, 
    artic_posa as artposa, 
    artic_unimed as artunimed 
     from articu where artic_id=registro_sitem.idartic
	loop

if(registro_artic.arttiprod is null) then registro_artic.arttiprod:=1; end if;
if(registro_artic.artunimed is null) then registro_artic.artunimed:=1; end if;
if(registro_artic.artposa is null) then registro_artic.artposa:='DESCONOCIDA'; end if;
if(registro_artic.marca is null) then registro_artic.marca:='DESCONOCIDA'; end if;
if(registro_artic.modelo is null) then registro_artic.modelo:='DESCONOCIDA'; end if;
if(registro_artic.descrip is null) then registro_artic.descrip:='DESCONOCIDA'; end if;
if(registro_artic.present is null) then registro_artic.present:='DESCONOCIDA'; end if;
--begin work; 
--lock item in access exclusive mode;
insert into articu (artic_indirecto,artic_codigo,artic_marca,artic_modelo,artic_descrip,artic_present,artic_tiprod,artic_posa,artic_unimed) 
values (registro_op.indirecto,codarticulo,registro_artic.marca,registro_artic.modelo,registro_artic.descrip,registro_artic.present,registro_artic.arttiprod,registro_artic.artposa,registro_artic.artunimed);

select max(artic_id) into articulo from articu;
--commit;
end loop; 
end if;


	for registro_item in select 
	    item_moneda as moneda, 
	    item_tipprod as tipprod, 
	    item_unimed as unimed, 
	    item_posa as posa 
	     from item where item_id=iddelitem
		loop

	    if(registro_item.moneda is null) then registro_item.moneda:=registro_op.monedao; end if;
	    if(registro_item.tipprod is null) then registro_item.tipprod:=registro_artic.arttiprod; end if;
	    if(registro_item.unimed is null) then registro_item.unimed:=registro_artic.artunimed; end if;
	    if(registro_item.posa is null) then registro_item.posa:=registro_artic.artposa; end if;
	    
--	    begin work; 
--	    lock item in access exclusive mode;
	    insert into item (item_idoper,item_moneda,item_tipprod,item_unimed,item_posa) 
	    values (operacion,registro_item.moneda,registro_item.tipprod,registro_item.unimed,registro_item.posa);
	    select max(item_id) into nuevoiditem from item;
--	    commit;

	    if(registro_op.deposito is null) then registro_op.deposito:=registro_sitem.sdeposito; end if;

	    if (importe>0) then
		    impsitem:=importe;
		    impdolsitem:=importe * moncteopera(operacion);
		else
		    impsitem:=cantidad*precio_unitariod(sitem);
		    impdolsitem:=impsitem;
	    end if;

	    insert into subitem (sitem_iditem,sitem_artic,sitem_tipemb,sitem_compbte,sitem_idoper,sitem_canting,sitem_importe,sitem_deposito,sitem_directo,sitem_indirecto,sitem_imp_dolar) values (nuevoiditem,articulo,registro_sitem.tipemb,registro_sitem.compbte,operacion,cantidad,impsitem,registro_op.deposito,registro_op.directo,registro_op.indirecto,impdolsitem);
	    select max(sitem_id) into idsitemcreado from subitem;
	
	    ret:=idsitemcreado;		
	end loop; 

return ret;
end;$_$;


ALTER FUNCTION public.grabocontrapart(integer, integer, real, numeric) OWNER TO onlop;

--
-- Name: grupocli(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION grupocli(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cliente		ALIAS FOR $1; 
	modo		ALIAS FOR $2; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN
    select cli_grupo into retval from
    	 clientes where int4eq(cliente,cli_id);

    if found then
	if int4eq(modo,1) then
	    update clientes set cli_grupo=cli_grupo+1 where int4eq(cliente,cli_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.grupocli(integer, integer) OWNER TO onlop;

--
-- Name: grupoprov(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION grupoprov(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	provd		ALIAS FOR $1; 
	modo		ALIAS FOR $2; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN
    select prov_grupo into retval from
    	 prove where int4eq(provd,prov_id);

    if found then
	if int4eq(modo,1) then
	    update prove set prov_grupo=prov_grupo+1 where int4eq(provd,prov_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.grupoprov(integer, integer) OWNER TO onlop;

--
-- Name: habro_ejercicio(character varying, date, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION habro_ejercicio(character varying, date, integer, integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
declare
comprobante	 alias for $1;
fecha		 alias for $2;
codemp		 alias for $3;
idptov		 alias for $4;
ret 		 boolean;
registro	 record;
elcomprob 	 integer;
compcierre 	 integer;
cuentardo 	 integer;
nrocomp 	 integer;
cuenta 	 	 integer;
subcuenta 	 integer;
resultad 	 numeric(15,2);
tituloa	 	 character varying;
idastoh 	 integer;
idashcierre 	 integer;
begin
ret:='f';
    select idcomp(comprobante,idptov) into elcomprob;
    select idcomp('ZZ',idptov) into compcierre;
    select numtalon(idptov,elcomprob,1) into nrocomp;
    select comp_nombre || ' INICIADO EL ' || fecha into tituloa from comprob where comp_id=elcomprob;

    insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_nro2,ash_estado) 
	values (codemp,idptov,substr(fecha,7,4)::int2,substr(fecha,4,2)::int2,elcomprob,nrocomp,tituloa,fecha,fecha,'Apertura de Cuentas del Ejercicio ',0,-1);

    select ash_id into idastoh from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=elcomprob and ash_numero=nrocomp;

    select ash_id into idashcierre from astoh where ash_codemp=codemp and ash_idptov=idptov and ash_comprob=compcierre and date_le(ash_fecval,fecha) order by ash_id desc limit 1;

    for registro in select 
	    astc_ctacble, astc_tipcta, astc_ctacte, (astc_importe * -1) as cuanto from astoctas 
	      where astc_idastoh=idashcierre  
	    loop
		if(registro.cuanto != 0) then
		    insert into astoctas (astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_tipcta,astc_ctacte) 
    	    	     values (idastoh,registro.astc_ctacble,registro.cuanto,codemp,idptov,elcomprob,nrocomp,fecha,-1,registro.astc_tipcta,registro.astc_ctacte);	
		end if;
	ret:='t';
    end loop; 
    return ret;
end;$_$;


ALTER FUNCTION public.habro_ejercicio(character varying, date, integer, integer) OWNER TO onlop;

--
-- Name: hay_cont_recipro(integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION hay_cont_recipro(integer, integer, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	operacion	ALIAS FOR $1; 	-- id dela operacion
	directo		ALIAS FOR $2; 	-- Usuario Directo
	modo		ALIAS FOR $3; 	-- modo
					--1 valido en publicacion
					--2 valido solo
	indirecto 	int4;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_texto 	text;
    BEGIN
    retval:='t';		
    for registro in select sitem_deposito as y,count(*) as z
     from subitem where sitem_idoper=operacion  group by y
	loop
	select unif_usuario into indirecto from unifun where unif_codigo=registro.y;
	    if int4ne(directo,indirecto) then
		    trans:=hay_contrato(directo,indirecto,2::int2,operacion,5::int2);
		else
		    trans:='t';		
	    end if;
	end loop; 

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.hay_cont_recipro(integer, integer, smallint) OWNER TO onlop;

--
-- Name: hay_cont_valido(integer, integer, smallint); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION hay_cont_valido(integer, integer, smallint) RETURNS boolean
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	usuario		ALIAS FOR $1; 	-- Titular de la unifun 
	directo		ALIAS FOR $2; 	-- Usuario Directo o indirecto
	modo 		alias for $3;  	-- 1  valida que exista contrato
					-- 2 valida que exista y este aprobado
					-- 3 valida que exista contrato y no graba noticias
					-- 4 valida que exista y este aprobado y no graba noticias
					-- 43 valida que exista  tipo contrato 3 y este aprobado y no graba noticias
					-- 443 valida que exista  tipo contrato 4 y este aprobado y no graba noticias
	indirecto 	int4;
	operacion 	int4;
	registro 	RECORD;
	retval 		boolean;
	trans 		boolean;
	aux_texto 	text;
    BEGIN
    retval:='f';		
    operacion=1;

if(usuario!=directo) then
    if usuario is not null then
	if int4ne(directo,usuario) then
	        if int2eq(modo,43::int2) then
	    		trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
		    else
	    		if int2eq(modo,443::int2) then
	    			trans:=hay_contrato(usuario,directo,modo::int2,operacion,4::int2);
				if booleq(trans,'f')then
				    trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
				end if;
			    else
				trans:=hay_contrato(usuario,directo,modo::int2,operacion,3::int2);
				if booleq(trans,'f')then
				    trans:=hay_contrato(usuario,directo,modo::int2,operacion,4::int2);
				    if booleq(trans,'f')then
					trans:=hay_contrato(usuario,directo,modo::int2,operacion,5::int2);
					if booleq(trans,'f')then
					    trans:=hay_contrato(usuario,directo,modo::int2,operacion,2::int2);
					end if;
				    end if;
				end if;
			end if;
		end if;
	    else
		trans:='t';		
	end if;
	retval:=trans;
    end if;
else
    retval:='t';		
end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.hay_cont_valido(integer, integer, smallint) OWNER TO onlop;

--
-- Name: idarticvta(integer, character varying); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION idarticvta(integer, character varying) RETURNS integer
    LANGUAGE sql
    AS $_$select art_id from articvta where art_codemp= $1 and bpchareq(trim( $2 ),art_codi);$_$;


ALTER FUNCTION public.idarticvta(integer, character varying) OWNER TO onlop;

--
-- Name: idashdecomp(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION idashdecomp(integer, integer, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ash_id from astoh where ash_codemp= $1 and ash_idptov= $2 and ash_comprob= $3 and ash_numero= $4;$_$;


ALTER FUNCTION public.idashdecomp(integer, integer, integer, integer) OWNER TO onlop;

--
-- Name: idcbl(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION idcbl(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_id from ctacble where cbl_codemp in ( $1,0) and cbl_codigo= $2 order by cbl_codemp desc limit 1;$_$;


ALTER FUNCTION public.idcbl(integer, integer) OWNER TO onlop;

--
-- Name: idcli(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION idcli(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cli_id from clientes where cli_codemp= $1 and cli_codigo= $2;$_$;


ALTER FUNCTION public.idcli(integer, integer) OWNER TO onlop;

--
-- Name: idcomp(character varying, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION idcomp(character varying, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select comp_id from comprob where bpchareq(trim(comp_codigo),trim( $1 )) and comp_idptov in ( $2 ,0) limit 1;$_$;


ALTER FUNCTION public.idcomp(character varying, integer) OWNER TO onlop;

--
-- Name: idctes(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION idctes(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cte_id from ctes where cte_tipcta= $1 and cte_codigo= $2;$_$;


ALTER FUNCTION public.idctes(integer, integer) OWNER TO onlop;

--
-- Name: idprov(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION idprov(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_id from prove where prov_codemp= $1 and prov_codigo= $2;$_$;


ALTER FUNCTION public.idprov(integer, integer) OWNER TO onlop;

--
-- Name: idptov(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION idptov(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_id from ptovta where ptv_codemp= $1 and ptv_codigo= $2;$_$;


ALTER FUNCTION public.idptov(integer, integer) OWNER TO onlop;

--
-- Name: llevastock(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION llevastock(integer) RETURNS boolean
    LANGUAGE sql
    AS $_$select true from varambi where vari_codemp= $1 and vari_codigo='STOCK' and vari_valor='1' limit 1;$_$;


ALTER FUNCTION public.llevastock(integer) OWNER TO onlop;

--
-- Name: marcadeartic(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION marcadeartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_marca from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.marcadeartic(integer) OWNER TO onlop;

--
-- Name: meapeso(smallint, date); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION meapeso(smallint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	moneda		ALIAS FOR $1; 
	fecha		ALIAS FOR $2; 
	cotipes		numeric;
	retval 		numeric;
    BEGIN

    select cotpeso(fecha) into cotipes;
    select (cot_cotiz * cotipes) into retval from cotiza WHERE int2eq(moneda,cot_moneda) and  date_le(cot_fecha,fecha) order by cot_fecha desc limit 1;

    if retval is NULL then
	    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.meapeso(smallint, date) OWNER TO onlop;

--
-- Name: mesastoh(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION mesastoh(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select ash_mes from astoh where ash_id= $1;$_$;


ALTER FUNCTION public.mesastoh(integer) OWNER TO onlop;

--
-- Name: monedacbl(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION monedacbl(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_moneda from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.monedacbl(integer) OWNER TO onlop;

--
-- Name: monedeempre(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION monedeempre(integer, integer) RETURNS boolean
    LANGUAGE sql
    AS $_$select true from monex a, astoctas b where a.mne_id= $2 and a.mne_idastoc=b.astc_id and b.astc_codemp= $1 ;$_$;


ALTER FUNCTION public.monedeempre(integer, integer) OWNER TO onlop;

--
-- Name: nomartic(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_nombre from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.nomartic(integer) OWNER TO onlop;

--
-- Name: nomcble(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomcble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.nomcble(integer) OWNER TO onlop;

--
-- Name: nomcli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomcli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cli_nombre from clientes where cli_id= $1 ;$_$;


ALTER FUNCTION public.nomcli(integer) OWNER TO onlop;

--
-- Name: nomcomp(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_nombre from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.nomcomp(integer) OWNER TO onlop;

--
-- Name: nomconpag(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomconpag(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cdp_nombre from conpag where cdp_codigo= $1 ;$_$;


ALTER FUNCTION public.nomconpag(integer) OWNER TO onlop;

--
-- Name: nomemp(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomemp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select emp_nombre from empresa where emp_codigo= $1 ;$_$;


ALTER FUNCTION public.nomemp(integer) OWNER TO onlop;

--
-- Name: nomiva(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomiva(integer) RETURNS character
    LANGUAGE sql
    AS $_$select iva_nombre from coniva where iva_codigo= $1 ;$_$;


ALTER FUNCTION public.nomiva(integer) OWNER TO onlop;

--
-- Name: nomivacli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomivacli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select iva_nombre from coniva,clientes where iva_codigo=cli_coniva and cli_id= $1 ;$_$;


ALTER FUNCTION public.nomivacli(integer) OWNER TO onlop;

--
-- Name: nomonlop(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomonlop(integer) RETURNS character
    LANGUAGE sql
    AS $_$select zon_nombre from onlop where zon_codigo= $1 ;$_$;


ALTER FUNCTION public.nomonlop(integer) OWNER TO onlop;

--
-- Name: nomopera(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomopera(integer) RETURNS character
    LANGUAGE sql
    AS $_$select operad_nombre from operadores where operad_id= $1 ;$_$;


ALTER FUNCTION public.nomopera(integer) OWNER TO onlop;

--
-- Name: nompais(smallint); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nompais(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select pai_nombre from pais where pai_codigo= $1 ;$_$;


ALTER FUNCTION public.nompais(smallint) OWNER TO onlop;

--
-- Name: nompaiscli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nompaiscli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pai_nombre from pais,sucursal where pai_codigo=sucu_pais and sucu_cliente= $1 ;$_$;


ALTER FUNCTION public.nompaiscli(integer) OWNER TO onlop;

--
-- Name: nomprov(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pro_nombre from provin where pro_codigo= $1 ;$_$;


ALTER FUNCTION public.nomprov(integer) OWNER TO onlop;

--
-- Name: nomprovcli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomprovcli(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pro_nombre from provin,sucursal where pro_codigo=sucu_provin and sucu_cliente= $1 ;$_$;


ALTER FUNCTION public.nomprovcli(integer) OWNER TO onlop;

--
-- Name: nomprove(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomprove(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.nomprove(integer) OWNER TO onlop;

--
-- Name: nomptv(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ptv_nombre from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.nomptv(integer) OWNER TO onlop;

--
-- Name: nomtipcta(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomtipcta(integer) RETURNS character
    LANGUAGE sql
    AS $_$select tct_nombre from tipcta where tct_codigo = $1;$_$;


ALTER FUNCTION public.nomtipcta(integer) OWNER TO onlop;

--
-- Name: nomvend(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomvend(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ven_nombre from vendedor where ven_id= $1 ;$_$;


ALTER FUNCTION public.nomvend(integer) OWNER TO onlop;

--
-- Name: nomzona(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nomzona(integer) RETURNS character
    LANGUAGE sql
    AS $_$select zon_nombre from zona where zon_codigo= $1 ;$_$;


ALTER FUNCTION public.nomzona(integer) OWNER TO onlop;

--
-- Name: nroastc(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION nroastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_numero from astoctas where astc_id= $1 ;$_$;


ALTER FUNCTION public.nroastc(integer) OWNER TO onlop;

--
-- Name: numero_letras(numeric); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION numero_letras(numeric) RETURNS text
    LANGUAGE plpgsql
    AS $_$
DECLARE
     numero	ALIAS FOR $1;
     lnEntero INTEGER;
     lcRetorno TEXT;
     lnTerna INTEGER;
     lcMiles TEXT;
     lcCadena TEXT;
     lnUnidades INTEGER;
     lnDecenas INTEGER;
     lnCentenas INTEGER;
     lnFraccion INTEGER;
     lnSw INTEGER;
BEGIN
     lnEntero := FLOOR(numero)::INTEGER;--Obtenemos la parte Entera
     lnFraccion := FLOOR(((numero - lnEntero) * 100))::INTEGER;--Obtenemos la Fraccion del Monto
     lcRetorno := '';
     lnTerna := 1;
     IF lnEntero > 0 THEN
     lnSw := LENGTH(lnEntero);
     WHILE lnTerna <= lnSw LOOP
        -- Recorro terna por terna
        lcCadena = '';
        lnUnidades = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
        lnDecenas = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
        lnCentenas = lnEntero % 10;
        lnEntero = CAST(lnEntero/10 AS INTEGER);
    -- Analizo las unidades
       SELECT
         CASE /* UNIDADES */
           WHEN lnUnidades = 1 AND lnTerna = 1 THEN 'UNO ' || lcCadena
           WHEN lnUnidades = 1 AND lnTerna <> 1 THEN 'UN ' || lcCadena
           WHEN lnUnidades = 2 THEN 'DOS ' || lcCadena
           WHEN lnUnidades = 3 THEN 'TRES ' || lcCadena
           WHEN lnUnidades = 4 THEN 'CUATRO ' || lcCadena
           WHEN lnUnidades = 5 THEN 'CINCO ' || lcCadena
           WHEN lnUnidades = 6 THEN 'SEIS ' || lcCadena
           WHEN lnUnidades = 7 THEN 'SIETE ' || lcCadena
           WHEN lnUnidades = 8 THEN 'OCHO ' || lcCadena
           WHEN lnUnidades = 9 THEN 'NUEVE ' || lcCadena
           ELSE lcCadena
          END INTO lcCadena;
          /* UNIDADES */
    -- Analizo las decenas
    SELECT
    CASE /* DECENAS */
      WHEN lnDecenas = 1 THEN
        CASE lnUnidades
          WHEN 0 THEN 'DIEZ '
          WHEN 1 THEN 'ONCE '
          WHEN 2 THEN 'DOCE '
          WHEN 3 THEN 'TRECE '
          WHEN 4 THEN 'CATORCE '
          WHEN 5 THEN 'QUINCE '
          ELSE 'DIECI' || lcCadena
        END
      WHEN lnDecenas = 2 AND lnUnidades = 0 THEN 'VEINTE ' || lcCadena
      WHEN lnDecenas = 2 AND lnUnidades <> 0 THEN 'VEINTI' || lcCadena
      WHEN lnDecenas = 3 AND lnUnidades = 0 THEN 'TREINTA ' || lcCadena
      WHEN lnDecenas = 3 AND lnUnidades <> 0 THEN 'TREINTA Y ' || lcCadena
      WHEN lnDecenas = 4 AND lnUnidades = 0 THEN 'CUARENTA ' || lcCadena
      WHEN lnDecenas = 4 AND lnUnidades <> 0 THEN 'CUARENTA Y ' || lcCadena
      WHEN lnDecenas = 5 AND lnUnidades = 0 THEN 'CINCUENTA ' || lcCadena
      WHEN lnDecenas = 5 AND lnUnidades <> 0 THEN 'CINCUENTA Y ' || lcCadena
      WHEN lnDecenas = 6 AND lnUnidades = 0 THEN 'SESENTA ' || lcCadena
      WHEN lnDecenas = 6 AND lnUnidades <> 0 THEN 'SESENTA Y ' || lcCadena
      WHEN lnDecenas = 7 AND lnUnidades = 0 THEN 'SETENTA ' || lcCadena
      WHEN lnDecenas = 7 AND lnUnidades <> 0 THEN 'SETENTA Y ' || lcCadena
      WHEN lnDecenas = 8 AND lnUnidades = 0 THEN 'OCHENTA ' || lcCadena
      WHEN lnDecenas = 8 AND lnUnidades <> 0 THEN 'OCHENTA Y ' || lcCadena
      WHEN lnDecenas = 9 AND lnUnidades = 0 THEN 'NOVENTA ' || lcCadena
      WHEN lnDecenas = 9 AND lnUnidades <> 0 THEN 'NOVENTA Y ' || lcCadena
      ELSE lcCadena
    END INTO lcCadena; /* DECENAS */
    -- Analizo las centenas
    SELECT
    CASE /* CENTENAS */
      WHEN lnCentenas = 1 AND lnUnidades = 0 AND lnDecenas = 0 THEN 'CIEN ' || lcCadena
      WHEN lnCentenas = 1 AND NOT(lnUnidades = 0 AND lnDecenas = 0) THEN 'CIENTO ' || lcCadena
      WHEN lnCentenas = 2 THEN 'DOSCIENTOS ' || lcCadena
      WHEN lnCentenas = 3 THEN 'TRESCIENTOS ' || lcCadena
      WHEN lnCentenas = 4 THEN 'CUATROCIENTOS ' || lcCadena
      WHEN lnCentenas = 5 THEN 'QUINIENTOS ' || lcCadena
      WHEN lnCentenas = 6 THEN 'SEISCIENTOS ' || lcCadena
      WHEN lnCentenas = 7 THEN 'SETECIENTOS ' || lcCadena
      WHEN lnCentenas = 8 THEN 'OCHOCIENTOS ' || lcCadena
      WHEN lnCentenas = 9 THEN 'NOVECIENTOS ' || lcCadena
      ELSE lcCadena
    END INTO lcCadena;/* CENTENAS */
    -- Analizo la terna
    SELECT
    CASE /* TERNA */
      WHEN lnTerna = 1 THEN lcCadena
      WHEN lnTerna = 2 AND (lnUnidades + lnDecenas + lnCentenas <> 0) THEN lcCadena || ' MIL '
      WHEN lnTerna = 3 AND (lnUnidades + lnDecenas + lnCentenas <> 0) AND
        lnUnidades = 1 AND lnDecenas = 0 AND lnCentenas = 0 THEN lcCadena || ' MILLON '
      WHEN lnTerna = 3 AND (lnUnidades + lnDecenas + lnCentenas <> 0) AND
        NOT (lnUnidades = 1 AND lnDecenas = 0 AND lnCentenas = 0) THEN lcCadena || ' MILLONES '
      WHEN lnTerna = 4 AND (lnUnidades + lnDecenas + lnCentenas <> 0) THEN lcCadena || ' MIL MILLONES '
      ELSE ''
    END INTO lcCadena;/* TERNA */
 
    --Retornamos los Valores Obtenidos
    lcRetorno = lcCadena  || lcRetorno;
    lnTerna = lnTerna + 1;
    END LOOP;
  END IF;
  IF lnTerna = 1 THEN
    lcRetorno := 'CERO';
  END IF;
  lcRetorno :=' PESOS ' || RTRIM(lcRetorno) || ' CON ' || LTRIM(lnFraccion) || '/100 CENTAVOS';
RETURN lcRetorno;
end;$_$;


ALTER FUNCTION public.numero_letras(numeric) OWNER TO onlop;

--
-- Name: numtalon(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION numtalon(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	ptovta		ALIAS FOR $1; 
	comproba	ALIAS FOR $2; 
	modo		ALIAS FOR $3; -- 1:graba  2:consulta
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN

    select comp_talon into talonario from
    	 comprob where int4eq(comproba,comp_id);

    select tal_valor into retval from
    	 talon where int4eq(talonario,tal_id);

    if found then
	if int4eq(modo,1) then
	    update talon set tal_valor=tal_valor+1 where int4eq(talonario,tal_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.numtalon(integer, integer, integer) OWNER TO onlop;

--
-- Name: numtalonf(integer, integer, date); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION numtalonf(integer, integer, date) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	ptovta		ALIAS FOR $1; 
	comprob		ALIAS FOR $2; 
	fecha		ALIAS FOR $3;
	otro 		integer;
	anter		date;
	retval 		integer;
    BEGIN

    select tal_fecha into anter from
    	 talon where int4eq(ptovta,tal_idptov) and int4eq(comprob,tal_comprob);

    if(date_le(anter,fecha)) then
	select tal_valor into retval from
    	    talon where int4eq(ptovta,tal_idptov) and int4eq(comprob,tal_comprob);
	if not found then
		otro:=0;
		select tal_valor into retval from talon where int4eq(otro,tal_idptov) and int4eq(comprob,tal_comprob);
		update talon set tal_valor=tal_valor+1,tal_fecha=fecha where int4eq(otro,tal_idptov) and int4eq(comprob,tal_comprob);
	     else
		update talon set tal_valor=tal_valor+1,tal_fecha=fecha where int4eq(ptovta,tal_idptov) and int4eq(comprob,tal_comprob);
	end if;
      else
        retval:=-1;
    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.numtalonf(integer, integer, date) OWNER TO onlop;

--
-- Name: pendmovsto(character varying); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION pendmovsto(character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codi		ALIAS FOR $1; 
	retval 		numeric;
    BEGIN
    
    retval:=0;
    
    select sum(movs_canti) into retval from movsto,articvta WHERE bpchareq(art_codi,trim(codi)) and art_id=movs_artic and movs_estado in (1,-1);
    if retval is null then
        retval:=0;
    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.pendmovsto(character varying) OWNER TO onlop;

--
-- Name: provdeastc(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION provdeastc(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select astc_ctacte from astoctas where astc_idastoh= $1 and astc_ctacble=idcbl(astc_codemp,valvaramb(astc_codemp,astc_idptov,'DEUDXC')::integer) limit 1;$_$;


ALTER FUNCTION public.provdeastc(integer) OWNER TO onlop;

--
-- Name: provinclie(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION provinclie(integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select sucu_provin from sucursal where sucu_cliente= $1 and sucu_codigo= $2 ;$_$;


ALTER FUNCTION public.provinclie(integer, integer) OWNER TO onlop;

--
-- Name: proxcodprov(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION proxcodprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select max(prov_codigo)+1 from prove where prov_codemp= $1 ;$_$;


ALTER FUNCTION public.proxcodprov(integer) OWNER TO onlop;

--
-- Name: ptovdefault(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION ptovdefault(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_id from ptovta where ptv_codemp= $1 order by ptv_id limit 1;$_$;


ALTER FUNCTION public.ptovdefault(integer) OWNER TO onlop;

--
-- Name: ptovemp(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION ptovemp(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empresa		ALIAS FOR $1; 
	retval 		integer;
	cuantos		integer;
    BEGIN
    select count(*) into cuantos from
    	 ptovta where int4eq(empresa,ptv_codemp);

	 if int4eq(cuantos,1) then
		select ptv_id into retval from
    		ptovta where int4eq(empresa,ptv_codemp);
	    else
		retval:=-1;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.ptovemp(integer) OWNER TO onlop;

--
-- Name: retenig(integer, numeric, date); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION retenig(integer, numeric, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	provd		ALIAS FOR $1; 
	imppago		ALIAS FOR $2;
	fecha		ALIAS FOR $3;
	codemp		integer;
	ptov		integer;
	tipct		integer;
	retsn		integer;
	idastoh		integer;
	deudxc		integer;
	ctaretig	integer;
	compnk		integer;
	registro	record;
	totpagt		numeric;
	totrett		numeric;
	totpag 		numeric;
	totret 		numeric;
	mnoi 		numeric;
	tasa 		numeric;
	retval 		numeric;
    BEGIN
    select prov_codemp into codemp from prove where prov_id=provd;
    select prov_idptov into ptov from prove where prov_id=provd;
    select valvaramb(codemp,ptov,'TIPCTADXC') into tipct;	
    select idcbl(codemp,valvaramb(codemp,ptov,'DEUDXC')::int4) into deudxc;
    select idcbl(codemp,valvaramb(codemp,ptov,'CTARETIG')::int4) into ctaretig;
    select valvaramb(codemp,ptov,'MNIRETIG') into mnoi;
    select valvaramb(codemp,ptov,'TASARIG') into tasa;
    select prov_retig into retsn from prove where prov_id=provd;
    select idcomp('NK',1) into compnk;

    totrett:=0;
    totpagt:=0;
    totret:=0;
    totpag:=0;
    retval:=0;


    if int4eq(retsn,1) then

	for registro in select 
         * from astoctas where astc_estado=2 and astc_ctacble=deudxc and astc_tipcta=tipct and astc_ctacte=provd and date_part('year',astc_fecval)=date_part('year',fecha::date) and date_part('month',astc_fecval)=date_part('month',fecha::date) and astc_importe>0 and astc_comprob!=compnk  
	    loop 
	    select sum(astc_importe*-1) into totrett from astoctas where astc_idastoh=registro.astc_idastoh and astc_ctacble=ctaretig and astc_importe<0; 
	    select sum(astc_importe*-1) into totpagt from astoctas where astc_idastoh=registro.astc_idastoh and astc_importe<0; 
	
	    if totpagt is null then
		totpagt:=0;
	    end if;

	    if totrett is null then
		totrett:=0;
	    end if;

	    totpag:= totpag + totpagt;
	    totret:= totret + totrett;
	    
	    end loop;

	    
	if totpag is null then
	    totpag:=0;
	end if;

	if totret is null then
	    totret:=0;
	end if;

	totpag:= ((totpag + imppago)/1.21) - mnoi;


	if(totpag > 0 ) then
	    retval:= ( totpag * tasa / 100) - totret;
	end if;

	if(retval < 0 ) then
	end if;

    end if;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.retenig(integer, numeric, date) OWNER TO onlop;

--
-- Name: saldoal(integer, integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION saldoal(integer, integer, integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	tipcta		ALIAS FOR $3; 
	ctacte		ALIAS FOR $4;
	fechad		ALIAS FOR $5;
	salant 		numeric;
	retval 		numeric;
    BEGIN
    select sum(astc_importe) into retval from astoctas 
	where astc_codemp=codemp and astc_idptov=ptovta and astc_tipcta=tipcta 
	and astc_ctacte=ctacte and astc_fecval< fechad and astc_cierra= 1
	and astc_estado=2;

    if retval is NULL then
	    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.saldoal(integer, integer, integer, integer, date) OWNER TO onlop;

--
-- Name: saldocbl(integer, integer, integer, date); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION saldocbl(integer, integer, integer, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	cuenta		ALIAS FOR $3; 
	fechad		ALIAS FOR $4;
	retval 		numeric;
    BEGIN
    if int4eq(codemp,-1) then
	    select sum(astc_importe) into retval from astoctas 
		where astc_ctacble=cuenta and astc_fecval< fechad and astc_estado=2 and codcomp(astc_comprob)!='AR' ;
        else
	    if int4eq(ptovta,0) then
		    select sum(astc_importe) into retval from astoctas 
			where astc_codemp=codemp and astc_ctacble=cuenta 
			    and astc_estado=2 and astc_comprob not in (6,7,147,157) and astc_fecval< fechad;
    		else
		    select sum(astc_importe) into retval from astoctas 
			where astc_codemp=codemp and astc_idptov=ptovta  
			    and astc_ctacble=cuenta and astc_estado=2 and astc_comprob not in (6,7,147,157) 
			    and astc_fecval< fechad ;
	    end if;
    end if;

    if retval is NULL then
	    retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.saldocbl(integer, integer, integer, date) OWNER TO onlop;

--
-- Name: salgrup(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION salgrup(integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	tipcta		ALIAS FOR $2;
	ctacte		ALIAS FOR $3;
	grupo		ALIAS FOR $4;
	esisti		integer;
	retval 		numeric;
    BEGIN
    if int4eq(grupo,0) then
	    select sum(astc_importe) into retval from astoctas
		where astc_codemp=codemp and astc_estado=2 and astc_tipcta=tipcta
		    and astc_ctacte=ctacte and astc_grupo is null;
	else
	    select sum(astc_importe) into retval from astoctas
		where astc_codemp=codemp and astc_estado=2 and astc_tipcta=tipcta
		    and astc_ctacte=ctacte and astc_grupo=grupo;
    end if;

    if not found then
	retval:=0;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.salgrup(integer, integer, integer, integer) OWNER TO onlop;

--
-- Name: seriedeartic(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION seriedeartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_serie from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.seriedeartic(integer) OWNER TO onlop;

--
-- Name: simbmoneda(smallint); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION simbmoneda(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select mon_simbol from moneda where mon_codigo= $1 ;$_$;


ALTER FUNCTION public.simbmoneda(smallint) OWNER TO onlop;

--
-- Name: stasaconiva(smallint); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION stasaconiva(smallint) RETURNS numeric
    LANGUAGE sql
    AS $_$select iva_stasa from coniva where iva_codigo= $1;$_$;


ALTER FUNCTION public.stasaconiva(smallint) OWNER TO onlop;

--
-- Name: stivacli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION stivacli(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select stasaconiva(cli_coniva) from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.stivacli(integer) OWNER TO onlop;

--
-- Name: tasaartic(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION tasaartic(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select art_tasa from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.tasaartic(integer) OWNER TO onlop;

--
-- Name: tasaconiva(smallint); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION tasaconiva(smallint) RETURNS numeric
    LANGUAGE sql
    AS $_$select iva_tasa from coniva where iva_codigo= $1;$_$;


ALTER FUNCTION public.tasaconiva(smallint) OWNER TO onlop;

--
-- Name: tiene_funcion(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION tiene_funcion(integer, integer, integer, integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idreg		ALIAS FOR $1;  -- id del registro
	idartic		ALIAS FOR $2;  -- id del articulo 
	idoper		ALIAS FOR $3; 
	tabla		ALIAS FOR $4;  -- 1=voling   y   2=volegr 
	modo		int4;
	pase		int4;
	sinfun		int4;
	registro	record;
	valorfob	text;
	funcion		text;
	funcion2	text;
	funcion3	text;
	cotiz		text;
	peso		text;
	volumen		numeric;
	cantidad	numeric;
	preciopul	numeric;
	precio		numeric;
	retval		numeric;
    BEGIN
    retval:=0;
    pase:=0;
    sinfun:=1;

	select cfac_funcion into funcion from complfac where cfac_id=idreg;
	if not found then
	    select art_funcion into funcion from articvta where art_id=idartic;
	    if not found then
		sinfun:=0;
	    end if;
	end if;


	select cfac_precio into preciopul from complfac where cfac_id=idreg;
	if not found then
	    select art_precio into precio from articvta where art_id=idartic;
	end if;

if sinfun then
	if funcion then
	    if numeric_gt(preciopul,0) then
		    retval:=preciopul; 
		else
		    if(precio) then
			retval:=precio; 
		    end if;
	    end if;
	end if;
end if;


RETURN retval;
END;$_$;


ALTER FUNCTION public.tiene_funcion(integer, integer, integer, integer) OWNER TO onlop;

--
-- Name: tipctacbl(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION tipctacbl(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_tipcta from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.tipctacbl(integer) OWNER TO onlop;

--
-- Name: tipprove(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION tipprove(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_tipo from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.tipprove(integer) OWNER TO onlop;

--
-- Name: titastoh(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION titastoh(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ash_titulo from astoh where ash_id= $1 ;$_$;


ALTER FUNCTION public.titastoh(integer) OWNER TO onlop;

--
-- Name: tivacli(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION tivacli(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select tasaconiva(cli_coniva) from clientes where cli_id= $1;$_$;


ALTER FUNCTION public.tivacli(integer) OWNER TO onlop;

--
-- Name: totimpastc(integer, integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION totimpastc(integer, integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select astc_importe from astoctas where astc_ctacble= $1 and astc_idastoh= $2 ;$_$;


ALTER FUNCTION public.totimpastc(integer, integer) OWNER TO onlop;

--
-- Name: tposastc(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION tposastc(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(astc_importe) from astoctas where astc_idastoh= $1 and astc_importe>0 ;$_$;


ALTER FUNCTION public.tposastc(integer) OWNER TO onlop;

--
-- Name: trae_cotiza(smallint, date); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION trae_cotiza(smallint, date) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
moneda		 alias for $1;
fecha		 alias for $2;
ret 		 numeric;
begin
     SELECT  cot_cotiz  INTO     ret 
	    FROM cotiza    
		WHERE int2eq(moneda,cot_moneda) and  
		    date_le(cot_fecha,fecha) 
	    order by cot_fecha desc limit 1;
return ret;
END;$_$;


ALTER FUNCTION public.trae_cotiza(smallint, date) OWNER TO onlop;

--
-- Name: ult_cotiz(integer); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION ult_cotiz(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select cot_cotiz  from cotiza where cot_moneda = $1  order by cot_fecha desc limit 1;$_$;


ALTER FUNCTION public.ult_cotiz(integer) OWNER TO onlop;

--
-- Name: valor_moncte(smallint, date, numeric, numeric); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION valor_moncte(smallint, date, numeric, numeric) RETURNS numeric
    LANGUAGE plpgsql
    AS $_$
declare
moneda		 alias for $1;
fecha		 alias for $2;
cuanto		 alias for $3;
tipo_de_cambio	 alias for $4;
aux_mon		 int2;
cotiz		 numeric;
ret 		 numeric;
begin

 SELECT  var_valor 
 INTO     aux_mon -- Codigo Moneda Homogenea
    FROM varamb    WHERE var_codigo like 'MONH%';

if int2eq(aux_mon,moneda) then
	    ret:= cuanto;
   else
     if numeric_eq(tipo_de_cambio,0::numeric) then -- busco la cotizacion
	    cotiz:=trae_cotiza(moneda,fecha)::numeric;
	    if (cotiz is not null) then 
		    if (cotiz!=0) then 
			ret:=cuanto / cotiz;
		    end if;
		else
		    ret:=0;
	    end if;
	else

	    ret:= cuanto / tipo_de_cambio;

--	    cotiz:=trae_cotiza(1::int2,fecha)::numeric;
--	    if(cotiz) then 
--		    ret:= cuanto * (tipo_de_cambio / cotiz);
--		else
--		    ret:=0;
--	    end if;
    end if;

end if;

return ret;
END;$_$;


ALTER FUNCTION public.valor_moncte(smallint, date, numeric, numeric) OWNER TO onlop;

--
-- Name: valvaramb(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: onlop
--

CREATE FUNCTION valvaramb(integer, integer, character varying) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	codigo		ALIAS FOR $3; 
	otro 		integer;
	retval 		varchar;
    BEGIN

    select vari_valor into retval from
    	 varambi where int4eq(ptovta,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);

    if not found then
	select vari_valor into retval from
    	    varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	if not found then
	    select vari_valor into retval from
    		varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq(codigo,vari_codigo);
	end if;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.valvaramb(integer, integer, character varying) OWNER TO onlop;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: antecedentes; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE antecedentes (
    ant_paciente integer NOT NULL,
    ant_fecest timestamp without time zone DEFAULT now() NOT NULL,
    ant_concepto integer NOT NULL,
    ant_antiguedad numeric(8,2),
    ant_tratamiento integer DEFAULT 1 NOT NULL,
    ant_modo integer,
    ant_leyen1 character varying(60),
    ant_leyen2 character varying(60),
    ant_leyen3 character varying(60),
    ant_leyen4 character varying(60),
    ant_leyen5 character varying(60),
    ant_medicacion text
);


ALTER TABLE public.antecedentes OWNER TO onlop;

SET default_with_oids = false;

--
-- Name: articvt; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE articvt (
    artv_id integer NOT NULL,
    artv_idartic integer NOT NULL,
    artv_idmovstoc integer NOT NULL,
    artv_idashing integer NOT NULL,
    artv_idashout integer,
    artv_estado smallint DEFAULT 1,
    artv_ubic integer DEFAULT 0,
    artv_cliente integer,
    artv_tasaiva numeric(15,5) DEFAULT 0,
    artv_precioc numeric(15,5) DEFAULT 0,
    artv_gtosimp numeric(15,5) DEFAULT 0,
    artv_preciov numeric(15,5) DEFAULT 0,
    artv_codi character varying(60) NOT NULL,
    artv_codigo character varying(60),
    artv_despacho character varying(20),
    artv_serie character varying(60),
    artv_barra character varying(30),
    artv_canti numeric(15,5) DEFAULT 1,
    artv_obs text,
    artv_codemp integer
);


ALTER TABLE public.articvt OWNER TO onlop;

--
-- Name: articvt_artv_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE articvt_artv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.articvt_artv_id_seq OWNER TO onlop;

--
-- Name: articvt_artv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE articvt_artv_id_seq OWNED BY articvt.artv_id;


SET default_with_oids = true;

--
-- Name: articvta; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE articvta (
    art_id integer NOT NULL,
    art_codemp integer,
    art_idptov integer,
    art_codi character varying(60),
    art_marca character varying(100),
    art_serie character varying(100),
    art_nombre character varying(60),
    art_estado smallint DEFAULT 1,
    art_tasa numeric(15,5) DEFAULT 0.21,
    art_stock numeric(15,5),
    art_canting numeric(15,5) DEFAULT 0,
    art_cantcomp numeric(15,5) DEFAULT 0,
    art_cantcons numeric(15,5) DEFAULT 0,
    art_cantret numeric(15,5) DEFAULT 0,
    art_cantmala numeric(15,5) DEFAULT 0,
    art_posa character varying(30),
    art_precio numeric(15,5) DEFAULT 0,
    art_funcion text,
    art_idcbl integer,
    art_nivrep numeric(15,5),
    art_unimed smallint,
    art_tipoper integer,
    art_siste smallint DEFAULT 1,
    art_tipo smallint DEFAULT 1,
    art_codrub smallint,
    art_codsrb integer,
    art_peso numeric(15,5),
    art_ancho numeric(15,5) DEFAULT 0,
    art_alto numeric(15,5) DEFAULT 0,
    art_codigo smallint,
    art_present numeric(15,5),
    art_profund numeric(15,5) DEFAULT 0,
    art_dep1 numeric(15,5) DEFAULT 0,
    art_dep2 numeric(15,5) DEFAULT 0,
    art_dep3 numeric(15,5) DEFAULT 0,
    art_dep4 numeric(15,5) DEFAULT 0,
    art_dep5 numeric(15,5) DEFAULT 0,
    art_dep6 numeric(15,5) DEFAULT 0,
    art_dep7 numeric(15,5) DEFAULT 0,
    art_leyen text
);


ALTER TABLE public.articvta OWNER TO onlop;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE articvta_art_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.articvta_art_id_seq OWNER TO onlop;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE articvta_art_id_seq OWNED BY articvta.art_id;


--
-- Name: astoctas; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE astoctas (
    astc_id integer NOT NULL,
    astc_idastoh integer NOT NULL,
    astc_codemp integer NOT NULL,
    astc_idptov integer,
    astc_iddiv integer,
    astc_idcco integer,
    astc_comprob integer NOT NULL,
    astc_numero integer NOT NULL,
    astc_fecval date NOT NULL,
    astc_ctacble integer NOT NULL,
    astc_moneda smallint DEFAULT 1 NOT NULL,
    astc_valor numeric(15,2) DEFAULT 0,
    astc_cotiza numeric(15,5) DEFAULT 0,
    astc_importe numeric(15,2) DEFAULT 0 NOT NULL,
    astc_tipcta integer,
    astc_ctacte integer,
    astc_nucheq integer DEFAULT 0,
    astc_fecvto date,
    astc_estado smallint DEFAULT 1 NOT NULL,
    astc_cierra smallint DEFAULT 1 NOT NULL,
    astc_grupo integer DEFAULT 1 NOT NULL,
    astc_tasa numeric(15,5),
    astc_leyen character varying(100),
    astc_idashce integer
);


ALTER TABLE public.astoctas OWNER TO onlop;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE astoctas_astc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.astoctas_astc_id_seq OWNER TO onlop;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE astoctas_astc_id_seq OWNED BY astoctas.astc_id;


--
-- Name: astoh; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE astoh (
    ash_id integer NOT NULL,
    ash_codemp integer NOT NULL,
    ash_idptov integer,
    ash_anio smallint NOT NULL,
    ash_mes smallint NOT NULL,
    ash_comprob integer NOT NULL,
    ash_numero integer NOT NULL,
    ash_titulo character varying(60),
    ash_fecomp date NOT NULL,
    ash_fecval date,
    ash_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    ash_estado smallint DEFAULT 1,
    ash_idcpra integer,
    ash_idemiti integer,
    ash_nro2 integer,
    ash_leyen text,
    ash_operad integer,
    ash_date date
);


ALTER TABLE public.astoh OWNER TO onlop;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE astoh_ash_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.astoh_ash_id_seq OWNER TO onlop;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE astoh_ash_id_seq OWNED BY astoh.ash_id;


--
-- Name: bancos; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE bancos (
    bco_codigo smallint NOT NULL,
    bco_nombre character varying(60) NOT NULL,
    bco_estado smallint DEFAULT 1
);


ALTER TABLE public.bancos OWNER TO onlop;

--
-- Name: cambubic; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE cambubic (
    cub_id integer NOT NULL,
    cub_comprob integer NOT NULL,
    cub_numero integer NOT NULL,
    cub_codemp integer NOT NULL,
    cub_idptov integer,
    cub_fecha date,
    cub_estado integer DEFAULT 1,
    cub_origen integer,
    cub_destino integer,
    cub_operador integer,
    cub_respons character varying(150),
    cub_leyen text
);


ALTER TABLE public.cambubic OWNER TO onlop;

--
-- Name: cambubic_cub_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE cambubic_cub_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.cambubic_cub_id_seq OWNER TO onlop;

--
-- Name: cambubic_cub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE cambubic_cub_id_seq OWNED BY cambubic.cub_id;


--
-- Name: catego; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE catego (
    cat_codigo integer NOT NULL,
    cat_nombre character varying(60) NOT NULL
);


ALTER TABLE public.catego OWNER TO onlop;

--
-- Name: catego_cat_codigo_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE catego_cat_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.catego_cat_codigo_seq OWNER TO onlop;

--
-- Name: catego_cat_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE catego_cat_codigo_seq OWNED BY catego.cat_codigo;


--
-- Name: centroc; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE centroc (
    cco_id integer NOT NULL,
    cco_codemp integer NOT NULL,
    cco_idptov integer NOT NULL,
    cco_coddiv integer NOT NULL,
    cco_codigo smallint NOT NULL,
    cco_nombre character varying(60)
);


ALTER TABLE public.centroc OWNER TO onlop;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE centroc_cco_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.centroc_cco_id_seq OWNER TO onlop;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE centroc_cco_id_seq OWNED BY centroc.cco_id;


--
-- Name: cheques; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE cheques (
    chq_id integer NOT NULL,
    chq_codbco smallint NOT NULL,
    chq_nucheq integer NOT NULL,
    chq_codemp integer NOT NULL,
    chq_idptov integer,
    chq_idastoc integer NOT NULL,
    chq_fechaem date,
    chq_fecheq date NOT NULL,
    chq_moneda smallint DEFAULT 1 NOT NULL,
    chq_importe numeric(15,2) DEFAULT 0 NOT NULL,
    chq_estado smallint DEFAULT 1 NOT NULL,
    chq_nrcuit character varying(20),
    chq_ctacte integer,
    chq_idastoce integer,
    chq_observ text
);


ALTER TABLE public.cheques OWNER TO onlop;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE cheques_chq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.cheques_chq_id_seq OWNER TO onlop;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE cheques_chq_id_seq OWNED BY cheques.chq_id;


--
-- Name: chqrech; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE chqrech (
    chqr_id integer NOT NULL,
    chqr_cliente integer DEFAULT 1,
    chqr_idchq integer,
    chqr_idastoh integer,
    chqr_idastohc integer,
    chqr_texto text,
    chqr_estado smallint DEFAULT 1
);


ALTER TABLE public.chqrech OWNER TO onlop;

--
-- Name: chqrech_chqr_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE chqrech_chqr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.chqrech_chqr_id_seq OWNER TO onlop;

--
-- Name: chqrech_chqr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE chqrech_chqr_id_seq OWNED BY chqrech.chqr_id;


--
-- Name: clientes; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE clientes (
    cli_id integer NOT NULL,
    cli_codemp integer NOT NULL,
    cli_idptov integer,
    cli_codigo integer NOT NULL,
    cli_codaso integer,
    cli_nrcuit character varying(20),
    cli_tipcli smallint,
    cli_nombre character varying(60),
    cli_fantasy character varying(60),
    cli_nomabre character varying(60),
    cli_coniva smallint NOT NULL,
    cli_descto numeric(15,5) DEFAULT 0,
    cli_conpag integer,
    cli_catego integer,
    cli_limcred numeric(15,2),
    cli_interes numeric(15,5),
    cli_grupo integer,
    cli_saldo numeric(15,2),
    cli_estado smallint DEFAULT 1 NOT NULL,
    cli_modfac smallint DEFAULT 1
);


ALTER TABLE public.clientes OWNER TO onlop;

--
-- Name: clientes_cli_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE clientes_cli_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.clientes_cli_id_seq OWNER TO onlop;

--
-- Name: clientes_cli_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE clientes_cli_id_seq OWNED BY clientes.cli_id;


--
-- Name: complfac; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE complfac (
    cfac_id integer NOT NULL,
    cfac_codemp integer NOT NULL,
    cfac_ptov smallint DEFAULT 1,
    cfac_cliente integer,
    cfac_anio smallint,
    cfac_mes smallint,
    cfac_fechad date DEFAULT date(now()),
    cfac_fechah date,
    cfac_idart integer NOT NULL,
    cfac_canti numeric(15,5) DEFAULT 1,
    cfac_dias smallint DEFAULT 1,
    cfac_importe numeric(15,2) DEFAULT 0,
    cfac_estado smallint DEFAULT 1,
    cfac_funcion text,
    cfac_evento smallint DEFAULT 1,
    cfac_leyen text DEFAULT ' '::text,
    cfac_precio numeric(15,5)
);


ALTER TABLE public.complfac OWNER TO onlop;

--
-- Name: complfac_cfac_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE complfac_cfac_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.complfac_cfac_id_seq OWNER TO onlop;

--
-- Name: complfac_cfac_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE complfac_cfac_id_seq OWNED BY complfac.cfac_id;


--
-- Name: compra; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE compra (
    cpra_id integer NOT NULL,
    cpra_idastoh integer NOT NULL,
    cpra_codemp integer NOT NULL,
    cpra_idptov integer,
    cpra_comprob integer NOT NULL,
    cpra_numero integer NOT NULL,
    cpra_prove integer,
    cpra_lecomp character varying(2),
    cpra_sucomp smallint,
    cpra_nucomp integer,
    cpra_fecori date,
    cpra_fecval date,
    cpra_fecvto date,
    cpra_estado smallint DEFAULT 1 NOT NULL,
    cpra_nomprov character varying(60),
    cpra_nrcuit character varying(20),
    cpra_coniva smallint,
    cpra_total numeric(15,2) DEFAULT 0,
    cpra_stock integer DEFAULT 0,
    cpra_despacho character varying(16),
    cpra_peso numeric(15,5) DEFAULT 0,
    cpra_proced smallint,
    cpra_moneda smallint,
    cpra_impmon numeric(15,2) DEFAULT 0,
    cpra_impdolar numeric(15,2) DEFAULT 0,
    cpra_importe numeric(15,2) DEFAULT 0,
    cpra_tipo_cambio numeric(15,6) DEFAULT 0,
    cpra_idret integer DEFAULT 0
);


ALTER TABLE public.compra OWNER TO onlop;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE compra_cpra_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.compra_cpra_id_seq OWNER TO onlop;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE compra_cpra_id_seq OWNED BY compra.cpra_id;


--
-- Name: comprob; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE comprob (
    comp_id integer NOT NULL,
    comp_codigo character(3) NOT NULL,
    comp_nombre character varying(60) NOT NULL,
    comp_idptov integer,
    comp_sistem smallint DEFAULT 1,
    comp_siste smallint DEFAULT 4,
    comp_credeb smallint DEFAULT 1,
    comp_stcksn smallint DEFAULT 1,
    comp_tipo smallint DEFAULT 1,
    comp_intext smallint DEFAULT 1,
    comp_cuenta integer,
    comp_talon integer,
    comp_copias integer,
    comp_letra character varying(3),
    comp_leyen text,
    comp_codemp integer
);


ALTER TABLE public.comprob OWNER TO onlop;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE comprob_comp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.comprob_comp_id_seq OWNER TO onlop;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE comprob_comp_id_seq OWNED BY comprob.comp_id;


--
-- Name: coniva; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE coniva (
    iva_codigo smallint NOT NULL,
    iva_nombre character varying(60) NOT NULL,
    iva_tasa numeric(15,5),
    iva_stasa numeric(15,5),
    iva_discrim smallint DEFAULT 1
);


ALTER TABLE public.coniva OWNER TO onlop;

--
-- Name: conpag; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE conpag (
    cdp_codigo integer NOT NULL,
    cdp_nombre character varying(60) NOT NULL,
    cdp_dias smallint
);


ALTER TABLE public.conpag OWNER TO onlop;

--
-- Name: conpag_cdp_codigo_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE conpag_cdp_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.conpag_cdp_codigo_seq OWNER TO onlop;

--
-- Name: conpag_cdp_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE conpag_cdp_codigo_seq OWNED BY conpag.cdp_codigo;


--
-- Name: consulta; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE consulta (
    con_id integer NOT NULL,
    con_paciente integer NOT NULL,
    con_fecha timestamp without time zone DEFAULT now() NOT NULL,
    con_nota text,
    con_doctor integer NOT NULL,
    con_estado integer DEFAULT 1,
    con_test integer
);



--
-- Name: convivencia; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE convivencia (
    cv_codigo integer NOT NULL,
    cv_nombre character varying(60) NOT NULL
);


ALTER TABLE public.convivencia OWNER TO onlop;

--
-- Name: cotiza; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE cotiza (
    cot_moneda smallint NOT NULL,
    cot_fecha date NOT NULL,
    cot_cotiz numeric(15,6) DEFAULT 1 NOT NULL
);


ALTER TABLE public.cotiza OWNER TO onlop;

--
-- Name: ctacble; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE ctacble (
    cbl_id integer NOT NULL,
    cbl_codemp integer,
    cbl_codigo smallint NOT NULL,
    cbl_nombre character varying(90) NOT NULL,
    cbl_identi integer,
    cbl_moneda smallint NOT NULL,
    cbl_tipcta integer,
    cbl_ajuste smallint DEFAULT 1 NOT NULL,
    cbl_indice smallint,
    cbl_present character varying(15)
);


ALTER TABLE public.ctacble OWNER TO onlop;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE ctacble_cbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ctacble_cbl_id_seq OWNER TO onlop;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE ctacble_cbl_id_seq OWNED BY ctacble.cbl_id;


--
-- Name: ctes; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE ctes (
    cte_id integer NOT NULL,
    cte_codemp integer,
    cte_tipcta integer NOT NULL,
    cte_tipct smallint,
    cte_codigo integer NOT NULL,
    cte_nombre character varying(60),
    cte_idtal integer,
    cte_estado smallint DEFAULT 1
);


ALTER TABLE public.ctes OWNER TO onlop;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE ctes_cte_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ctes_cte_id_seq OWNER TO onlop;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE ctes_cte_id_seq OWNED BY ctes.cte_id;


--
-- Name: division; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE division (
    div_id integer NOT NULL,
    div_codemp integer NOT NULL,
    div_idptov integer NOT NULL,
    div_codigo smallint NOT NULL,
    div_nombre character varying(60)
);


ALTER TABLE public.division OWNER TO onlop;

--
-- Name: division_div_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE division_div_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.division_div_id_seq OWNER TO onlop;

--
-- Name: division_div_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE division_div_id_seq OWNED BY division.div_id;


--
-- Name: docum; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE docum (
    doc_id integer NOT NULL,
    doc_codemp integer NOT NULL,
    doc_idptov integer,
    doc_idastoc integer NOT NULL,
    doc_numero integer NOT NULL,
    doc_fechaem date,
    doc_fecdoc date NOT NULL,
    doc_moneda smallint DEFAULT 1 NOT NULL,
    doc_importe numeric(15,2) DEFAULT 0 NOT NULL,
    doc_estado smallint DEFAULT 1 NOT NULL,
    doc_nrcuit character varying(20),
    doc_ctacte integer,
    doc_idastoce integer,
    doc_observ text
);


ALTER TABLE public.docum OWNER TO onlop;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE docum_doc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.docum_doc_id_seq OWNER TO onlop;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE docum_doc_id_seq OWNED BY docum.doc_id;


SET default_with_oids = false;

--
-- Name: ecivil; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE ecivil (
    ec_codigo smallint NOT NULL,
    ec_nombre character varying(60) NOT NULL
);


ALTER TABLE public.ecivil OWNER TO onlop;

SET default_with_oids = true;

--
-- Name: educacion; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE educacion (
    ed_codigo integer NOT NULL,
    ed_nombre character varying(60) NOT NULL
);


ALTER TABLE public.educacion OWNER TO onlop;

--
-- Name: emiti; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE emiti (
    emi_id integer NOT NULL,
    emi_idastoh integer NOT NULL,
    emi_codemp integer NOT NULL,
    emi_idptov integer,
    emi_comprob integer NOT NULL,
    emi_numero integer NOT NULL,
    emi_fecval date,
    emi_grupo integer,
    emi_conpag integer,
    emi_codcli integer,
    emi_succli integer,
    emi_nomcli character varying(60),
    emi_conivac smallint,
    emi_nrocuit character varying(20),
    emi_vended integer,
    emi_provin integer,
    emi_onlop integer,
    emi_desre numeric(15,2) DEFAULT 0,
    emi_total numeric(15,2) DEFAULT 0,
    emi_retiro integer,
    emi_estado smallint DEFAULT 1,
    emi_leyen text,
    emi_zona integer,
    emi_cotiza numeric(15,5),
    emi_remito integer,
    emi_remitos character varying(200)
);


ALTER TABLE public.emiti OWNER TO onlop;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE emiti_emi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.emiti_emi_id_seq OWNER TO onlop;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE emiti_emi_id_seq OWNED BY emiti.emi_id;


--
-- Name: empresa; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE empresa (
    emp_codigo integer NOT NULL,
    emp_nombre character varying(60),
    emp_direcc character varying(60),
    emp_locali character varying(60),
    emp_codpos character varying(10),
    emp_provin integer,
    emp_pais smallint,
    emp_nrcuit character varying(20),
    emp_estado smallint DEFAULT 1,
    emp_tipo smallint,
    emp_coniva smallint,
    emp_anti date,
    emp_fecint date,
    emp_grupo integer,
    emp_redond smallint,
    emp_nomabr character varying(7)
);


ALTER TABLE public.empresa OWNER TO onlop;

--
-- Name: entidad; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE entidad (
    ent_id integer NOT NULL,
    ent_niv1 smallint DEFAULT 0 NOT NULL,
    ent_niv2 smallint DEFAULT 0 NOT NULL,
    ent_niv3 smallint DEFAULT 0 NOT NULL,
    ent_niv4 smallint DEFAULT 0 NOT NULL,
    ent_niv5 smallint DEFAULT 0 NOT NULL,
    ent_nombre character varying(60)
);


ALTER TABLE public.entidad OWNER TO onlop;

--
-- Name: entidad_ent_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE entidad_ent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.entidad_ent_id_seq OWNER TO onlop;

--
-- Name: entidad_ent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE entidad_ent_id_seq OWNED BY entidad.ent_id;


--
-- Name: entrevc; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE entrevc (
    etv_id integer NOT NULL,
    etv_idastoh integer DEFAULT (-1) NOT NULL,
    etv_orden integer DEFAULT (-1) NOT NULL,
    etv_imagen character varying(80),
    etv_respuesta character varying(80),
    etv_ini timestamp without time zone,
    etv_fin timestamp without time zone,
    etv_tiempo time without time zone,
    etv_puntaje numeric(20,5),
    etv_estado integer DEFAULT 1
);


ALTER TABLE public.entrevc OWNER TO onlop;

--
-- Name: entrevc_etv_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE entrevc_etv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.entrevc_etv_id_seq OWNER TO onlop;

--
-- Name: entrevc_etv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE entrevc_etv_id_seq OWNED BY entrevc.etv_id;


--
-- Name: entrevh; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE entrevh (
    eth_id integer NOT NULL,
    eth_paciente integer NOT NULL,
    eth_consulta integer NOT NULL,
    eth_aciertos integer,
    eth_tiempo time without time zone,
    eth_estado integer DEFAULT 1
);


ALTER TABLE public.entrevh OWNER TO onlop;

--
-- Name: entrevh_eth_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE entrevh_eth_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.entrevh_eth_id_seq OWNER TO onlop;

--
-- Name: entrevh_eth_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE entrevh_eth_id_seq OWNED BY entrevh.eth_id;


--
-- Name: esclisp; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE esclisp (
    elp_idart integer NOT NULL,
    elp_orden smallint DEFAULT 1 NOT NULL,
    elp_nombre character varying(60) DEFAULT '1'::character varying,
    elp_precio numeric(15,2) NOT NULL
);


ALTER TABLE public.esclisp OWNER TO onlop;

--
-- Name: eventos; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE eventos (
    eve_codigo smallint NOT NULL,
    eve_nombre character varying(60) NOT NULL
);


ALTER TABLE public.eventos OWNER TO onlop;

--
-- Name: evindi; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE evindi (
    evi_indice smallint NOT NULL,
    evi_fecha date NOT NULL,
    evi_valor numeric(15,5) DEFAULT 1
);


ALTER TABLE public.evindi OWNER TO onlop;

--
-- Name: facturacion; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE facturacion (
    fac_id integer NOT NULL,
    fac_codemp integer NOT NULL,
    fac_ptov smallint DEFAULT 1,
    fac_cliente integer NOT NULL,
    fac_fecha date DEFAULT date(now()),
    fac_fecfac date,
    fac_fecdes date,
    fac_fechas date,
    fac_anio smallint,
    fac_mes smallint,
    fac_idart integer NOT NULL,
    fac_canti numeric(15,5) DEFAULT 1,
    fac_dias smallint DEFAULT 1,
    fac_importe numeric(15,2) DEFAULT 0,
    fac_estado smallint DEFAULT 1,
    fac_fecreg timestamp without time zone DEFAULT now(),
    fac_idoper integer,
    fac_idemiti integer,
    fac_clireal integer,
    fac_leyen text,
    fac_precio numeric(15,5)
);


ALTER TABLE public.facturacion OWNER TO onlop;

--
-- Name: facturacion_fac_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE facturacion_fac_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.facturacion_fac_id_seq OWNER TO onlop;

--
-- Name: facturacion_fac_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE facturacion_fac_id_seq OWNED BY facturacion.fac_id;


--
-- Name: firman; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE firman (
    fir_id integer NOT NULL,
    fir_nrcuit character varying(20) NOT NULL,
    fir_nombre character varying(60) NOT NULL,
    fir_direcc character varying(60),
    fir_locali character varying(60),
    fir_codpos character varying(10),
    fir_provin integer,
    fir_pais smallint,
    fir_estado smallint DEFAULT 1,
    fir_observ text
);


ALTER TABLE public.firman OWNER TO onlop;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE firman_fir_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.firman_fir_id_seq OWNER TO onlop;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE firman_fir_id_seq OWNED BY firman.fir_id;


SET default_with_oids = false;

--
-- Name: grupos; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE grupos (
    gpo_id integer NOT NULL,
    gpo_nombre character varying(60) NOT NULL
);


ALTER TABLE public.grupos OWNER TO onlop;

--
-- Name: grupos_gpo_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE grupos_gpo_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.grupos_gpo_id_seq OWNER TO onlop;

--
-- Name: grupos_gpo_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE grupos_gpo_id_seq OWNED BY grupos.gpo_id;


SET default_with_oids = true;

--
-- Name: impresiones; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE impresiones (
    imp_codigo smallint NOT NULL,
    imp_name text,
    imp_query text,
    imp_enscript text,
    imp_filter text,
    imp_shell text
);


ALTER TABLE public.impresiones OWNER TO onlop;

--
-- Name: indices; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE indices (
    ind_codigo smallint NOT NULL,
    ind_nombre character varying(60) NOT NULL
);


ALTER TABLE public.indices OWNER TO onlop;

--
-- Name: interes; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE interes (
    int_codemp integer NOT NULL,
    int_fecha date NOT NULL,
    int_valor numeric(15,4) DEFAULT 0
);


ALTER TABLE public.interes OWNER TO onlop;

--
-- Name: listpre; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE listpre (
    ltp_id integer NOT NULL,
    ltp_idcli integer,
    ltp_idart integer NOT NULL,
    ltp_orden integer,
    ltp_precio numeric(15,5) DEFAULT 0
);


ALTER TABLE public.listpre OWNER TO onlop;

--
-- Name: listpre_ltp_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE listpre_ltp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.listpre_ltp_id_seq OWNER TO onlop;

--
-- Name: listpre_ltp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE listpre_ltp_id_seq OWNED BY listpre.ltp_id;


--
-- Name: lotes; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE lotes (
    lot_id integer NOT NULL,
    lot_codseccion smallint,
    lot_codmza smallint,
    lot_codigo smallint NOT NULL,
    lot_nombre character varying(60)
);


ALTER TABLE public.lotes OWNER TO onlop;

--
-- Name: lotes_lot_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE lotes_lot_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.lotes_lot_id_seq OWNER TO onlop;

--
-- Name: lotes_lot_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE lotes_lot_id_seq OWNED BY lotes.lot_id;


--
-- Name: manzana; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE manzana (
    mza_codigo smallint NOT NULL,
    mza_codseccion smallint NOT NULL,
    mza_nombre character varying(60) NOT NULL
);


ALTER TABLE public.manzana OWNER TO onlop;

--
-- Name: moneda; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE moneda (
    mon_codigo smallint NOT NULL,
    mon_nombre character varying(60) NOT NULL,
    mon_simbol character varying(5)
);


ALTER TABLE public.moneda OWNER TO onlop;

--
-- Name: monex; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE monex (
    mne_id integer NOT NULL,
    mne_idastoc integer NOT NULL,
    mne_moneda smallint NOT NULL,
    mne_numero character varying(60),
    mne_valor numeric(15,2),
    mne_estado smallint DEFAULT 1,
    mne_idastoce integer
);


ALTER TABLE public.monex OWNER TO onlop;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE monex_mne_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.monex_mne_id_seq OWNER TO onlop;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE monex_mne_id_seq OWNED BY monex.mne_id;


--
-- Name: movsto; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE movsto (
    movs_id integer NOT NULL,
    movs_idastoh integer NOT NULL,
    movs_idemiti integer NOT NULL,
    movs_codemp integer NOT NULL,
    movs_idptov integer,
    movs_fecval date,
    movs_artic integer,
    movs_canti numeric(15,5) DEFAULT 0,
    movs_dias numeric(15,2) DEFAULT 0,
    movs_precio numeric(15,2) DEFAULT 0,
    movs_importe numeric(15,2) DEFAULT 0,
    movs_tasa numeric(15,5) DEFAULT 0,
    movs_peso numeric(15,2) DEFAULT 0,
    movs_volum numeric(15,2) DEFAULT 0,
    movs_entreg numeric(15,2) DEFAULT 0,
    movs_fecrep date,
    movs_estado smallint DEFAULT 1,
    movs_codcli integer,
    movs_indir integer,
    movs_clireal integer,
    movs_idoper integer,
    movs_ticket integer,
    movs_leyen text,
    movs_origen integer,
    movs_destino integer
);


ALTER TABLE public.movsto OWNER TO onlop;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE movsto_movs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.movsto_movs_id_seq OWNER TO onlop;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE movsto_movs_id_seq OWNED BY movsto.movs_id;


--
-- Name: movstoc; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE movstoc (
    movc_id integer NOT NULL,
    movc_idastoh integer NOT NULL,
    movc_idcompra integer NOT NULL,
    movc_codemp integer NOT NULL,
    movc_idptov integer,
    movc_estado smallint DEFAULT 1,
    movc_artic integer,
    movc_canti numeric(15,5) DEFAULT 0,
    movc_precio numeric(15,2) DEFAULT 0,
    movc_importe numeric(15,2) DEFAULT 0,
    movc_moneda smallint,
    movc_impmon numeric(15,2),
    movc_impdolar numeric(15,2),
    movc_otrdol numeric(15,2),
    movc_fecval date,
    movc_tasa numeric(15,5) DEFAULT 0,
    movc_item integer,
    movc_subitem integer,
    movc_peso numeric(15,2) DEFAULT 0,
    movc_volum numeric(15,2) DEFAULT 0,
    movc_entreg numeric(15,2) DEFAULT 0,
    movc_fecrep date,
    movc_codpro integer,
    movc_leyen text,
    movc_cantret numeric(15,2) DEFAULT 0
);


ALTER TABLE public.movstoc OWNER TO onlop;

--
-- Name: movstoc_movc_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE movstoc_movc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.movstoc_movc_id_seq OWNER TO onlop;

--
-- Name: movstoc_movc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE movstoc_movc_id_seq OWNED BY movstoc.movc_id;


--
-- Name: movubic; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE movubic (
    mcub_id integer NOT NULL,
    mcub_idcub integer NOT NULL,
    mcub_estado integer DEFAULT 1,
    mcub_origen integer,
    mcub_destino integer,
    mcub_artic integer,
    mcub_canti numeric(15,5)
);


ALTER TABLE public.movubic OWNER TO onlop;

--
-- Name: movubic_mcub_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE movubic_mcub_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.movubic_mcub_id_seq OWNER TO onlop;

--
-- Name: movubic_mcub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE movubic_mcub_id_seq OWNED BY movubic.mcub_id;


--
-- Name: noticias; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE noticias (
    not_id integer NOT NULL,
    not_tipo smallint DEFAULT 1 NOT NULL,
    not_numero integer NOT NULL,
    not_texto text,
    not_fecha timestamp without time zone DEFAULT now()
);


ALTER TABLE public.noticias OWNER TO onlop;

--
-- Name: noticias_not_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE noticias_not_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.noticias_not_id_seq OWNER TO onlop;

--
-- Name: noticias_not_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE noticias_not_id_seq OWNED BY noticias.not_id;


SET default_with_oids = false;

--
-- Name: operadores; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE operadores (
    operad_id integer NOT NULL,
    operad_nombre character varying(60) NOT NULL,
    operad_pass character varying(40) NOT NULL,
    operad_sector character varying(60),
    operad_estado smallint DEFAULT 1 NOT NULL,
    operad_nivaut1 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_nivaut2 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_count smallint DEFAULT 1 NOT NULL,
    operad_grupo smallint,
    operad_cliente smallint,
    operad_login character varying(40) NOT NULL,
    operad_last date DEFAULT date(now()),
    operad_contacto character varying(90),
    operad_telefono character varying(90),
    operad_codemp integer,
    operad_ptovta integer
);


ALTER TABLE public.operadores OWNER TO onlop;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE operadores_operad_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.operadores_operad_id_seq OWNER TO onlop;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE operadores_operad_id_seq OWNED BY operadores.operad_id;


SET default_with_oids = true;

--
-- Name: pacientes; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE pacientes (
    pac_id integer NOT NULL,
    pac_codigo integer DEFAULT 1 NOT NULL,
    pac_nombre character varying(100),
    pac_sexo integer DEFAULT 1 NOT NULL,
    pac_fecnac date,
    pac_tdoc character varying(5),
    pac_ndoc integer,
    pac_fecest timestamp without time zone DEFAULT now() NOT NULL,
    pac_civil integer,
    pac_domicilio character varying(65),
    pac_locali character varying(65),
    pac_codpos character varying(15),
    pac_provin integer,
    pac_operador integer,
    pac_grupo integer,
    pac_cliente integer,
    pac_trabajo integer,
    pac_siempre integer,
    pac_cuanttra numeric(8,2),
    pac_trabact integer,
    pac_cuanttraa numeric(8,2),
    pac_educacion integer,
    pac_eduanios integer,
    pac_tipedu integer,
    pac_nacion integer,
    pac_lateralidad integer,
    pac_zurderiaflia integer,
    pac_convivencia integer,
    pac_medrefer integer,
    pac_estado integer DEFAULT 1
);


ALTER TABLE public.pacientes OWNER TO onlop;

--
-- Name: pacientes_pac_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE pacientes_pac_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.pacientes_pac_id_seq OWNER TO onlop;

--
-- Name: pacientes_pac_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE pacientes_pac_id_seq OWNED BY pacientes.pac_id;


--
-- Name: pais; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE pais (
    pai_codigo smallint NOT NULL,
    pai_nombre character varying(60) NOT NULL
);


ALTER TABLE public.pais OWNER TO onlop;

--
-- Name: palabrasn; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE palabrasn (
    p_ingles character varying(20),
    p_valorm character varying(20),
    p_valorf character varying(20)
);


ALTER TABLE public.palabrasn OWNER TO onlop;

--
-- Name: prove; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE prove (
    prov_id integer NOT NULL,
    prov_nrcuit character varying(20),
    prov_codemp integer,
    prov_idptov integer,
    prov_codigo integer,
    prov_nombre character varying(60),
    prov_direcc character varying(60),
    prov_locali character varying(60),
    prov_provin integer DEFAULT 1 NOT NULL,
    prov_pais smallint DEFAULT 200 NOT NULL,
    prov_estado smallint DEFAULT 1 NOT NULL,
    prov_direce character varying(90),
    prov_observ text,
    prov_grupo integer DEFAULT 1,
    prov_tipo integer DEFAULT 1,
    prov_coniva integer DEFAULT 1,
    prov_retig integer DEFAULT 1,
    prov_codpos character varying
);


ALTER TABLE public.prove OWNER TO onlop;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE prove_prov_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.prove_prov_id_seq OWNER TO onlop;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE prove_prov_id_seq OWNED BY prove.prov_id;


--
-- Name: provin; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE provin (
    pro_codigo integer NOT NULL,
    pro_nombre character varying(60) NOT NULL,
    pro_tasa numeric(15,5),
    pro_coef numeric(15,5),
    pro_valor numeric(15,2) DEFAULT 0
);


ALTER TABLE public.provin OWNER TO onlop;

--
-- Name: provin_pro_codigo_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE provin_pro_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.provin_pro_codigo_seq OWNER TO onlop;

--
-- Name: provin_pro_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE provin_pro_codigo_seq OWNED BY provin.pro_codigo;


--
-- Name: ptestn; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE ptestn (
    ptn_id integer NOT NULL,
    ptn_valorm character varying(20),
    ptn_valorf character varying(20)
);


ALTER TABLE public.ptestn OWNER TO onlop;

--
-- Name: ptestn_ptn_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE ptestn_ptn_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ptestn_ptn_id_seq OWNER TO onlop;

--
-- Name: ptestn_ptn_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE ptestn_ptn_id_seq OWNED BY ptestn.ptn_id;


--
-- Name: ptovta; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE ptovta (
    ptv_id integer NOT NULL,
    ptv_nombre character varying(60),
    ptv_codemp integer,
    ptv_codigo integer NOT NULL,
    ptv_direcc character varying(60),
    ptv_locali character varying(60),
    ptv_codpos character varying(10),
    ptv_provin integer,
    ptv_pais smallint,
    ptv_estado smallint DEFAULT 1
);


ALTER TABLE public.ptovta OWNER TO onlop;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE ptovta_ptv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ptovta_ptv_id_seq OWNER TO onlop;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE ptovta_ptv_id_seq OWNED BY ptovta.ptv_id;


--
-- Name: rubros; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE rubros (
    rub_id integer NOT NULL,
    rub_tipo integer DEFAULT 1,
    rub_codigo integer,
    rub_nombre character varying(60) NOT NULL
);


ALTER TABLE public.rubros OWNER TO onlop;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE rubros_rub_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.rubros_rub_id_seq OWNER TO onlop;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE rubros_rub_id_seq OWNED BY rubros.rub_id;


--
-- Name: seccion; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE seccion (
    sec_codigo smallint NOT NULL,
    sec_nombre character varying(60) NOT NULL
);


ALTER TABLE public.seccion OWNER TO onlop;

--
-- Name: stock; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE stock (
    stk_id integer NOT NULL,
    stk_idsitem integer NOT NULL,
    stk_iditem integer NOT NULL,
    stk_idoper integer,
    stk_codigo smallint DEFAULT 0 NOT NULL,
    stk_artic integer,
    stk_canting numeric(15,5) DEFAULT 0 NOT NULL,
    stk_cantret numeric(15,5) DEFAULT 0,
    stk_cantcomp numeric(15,5) DEFAULT 0,
    stk_cantmala numeric(15,5) DEFAULT 0,
    stk_importe numeric(15,2) DEFAULT 0 NOT NULL,
    stk_imp_dolar numeric(15,2) DEFAULT 0,
    stk_volumen numeric(15,5) DEFAULT 0,
    stk_peso numeric(15,5) DEFAULT 0,
    stk_tipemb smallint,
    stk_deposito smallint,
    stk_idacta integer,
    stk_estado integer DEFAULT 1,
    stk_directo integer NOT NULL,
    stk_indirecto integer NOT NULL,
    stk_compbte character varying(16),
    stk_cliente integer,
    stk_comptras character varying(16)
);


ALTER TABLE public.stock OWNER TO onlop;

--
-- Name: stock_stk_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE stock_stk_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.stock_stk_id_seq OWNER TO onlop;

--
-- Name: stock_stk_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE stock_stk_id_seq OWNED BY stock.stk_id;


--
-- Name: subd; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE subd (
    subd_id integer NOT NULL,
    subd_codemp integer DEFAULT 0 NOT NULL,
    subd_idptov integer DEFAULT 0,
    subd_nombre character varying(60),
    subd_titulo character varying(60),
    subd_fecd date,
    subd_fech date,
    subd_estado smallint DEFAULT 1 NOT NULL,
    subd_proxnum integer
);


ALTER TABLE public.subd OWNER TO onlop;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE subd_subd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.subd_subd_id_seq OWNER TO onlop;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE subd_subd_id_seq OWNED BY subd.subd_id;


--
-- Name: subrub; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE subrub (
    srb_id integer NOT NULL,
    srb_rubro integer NOT NULL,
    srb_codigo smallint NOT NULL,
    srb_nombre character varying(60) NOT NULL,
    srb_precio numeric(15,2) DEFAULT 0,
    srb_leyen text,
    srb_codtg smallint DEFAULT 1,
    srb_conper smallint DEFAULT 1
);


ALTER TABLE public.subrub OWNER TO onlop;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE subrub_srb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.subrub_srb_id_seq OWNER TO onlop;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE subrub_srb_id_seq OWNED BY subrub.srb_id;


--
-- Name: subxcomp; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE subxcomp (
    subxc_idsub integer NOT NULL,
    subxc_comprob integer NOT NULL
);


ALTER TABLE public.subxcomp OWNER TO onlop;

--
-- Name: sucursal; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE sucursal (
    sucu_cliente integer NOT NULL,
    sucu_codigo smallint DEFAULT 1 NOT NULL,
    sucu_nombre character varying(60) NOT NULL,
    sucu_direcc character varying(60),
    sucu_locali character varying(60),
    sucu_codpos character varying(15),
    sucu_provin integer DEFAULT 1,
    sucu_pais smallint,
    sucu_repres character varying(60),
    sucu_contacto character varying(60),
    sucu_observ text,
    sucu_direccl character varying(60),
    sucu_localil character varying(60),
    sucu_codposl character varying(15),
    sucu_codprovl integer,
    sucu_paisl smallint
);


ALTER TABLE public.sucursal OWNER TO onlop;

--
-- Name: talon; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE talon (
    tal_id integer NOT NULL,
    tal_idptov integer,
    tal_comprob integer,
    tal_nombre character varying(60) NOT NULL,
    tal_valor integer,
    tal_fecha date,
    tal_estado smallint DEFAULT 1,
    tal_vald integer DEFAULT 1,
    tal_valh integer DEFAULT 100000,
    tal_fecvto date DEFAULT '2028-12-31'::date,
    tal_codemp integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.talon OWNER TO onlop;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE talon_tal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.talon_tal_id_seq OWNER TO onlop;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE talon_tal_id_seq OWNED BY talon.tal_id;


--
-- Name: telefon; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE telefon (
    tel_id integer NOT NULL,
    tel_tipent integer NOT NULL,
    tel_codigo integer NOT NULL,
    tel_tiptel integer NOT NULL,
    tel_contact character varying(60) NOT NULL,
    tel_leyen text,
    tel_dato character varying(300)
);


ALTER TABLE public.telefon OWNER TO onlop;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE telefon_tel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.telefon_tel_id_seq OWNER TO onlop;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE telefon_tel_id_seq OWNED BY telefon.tel_id;


SET default_with_oids = false;

--
-- Name: testn; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE testn (
    tn_id integer NOT NULL,
    tn_posicion integer DEFAULT 1 NOT NULL,
    tn_v1 character varying(20),
    tn_v2 character varying(20),
    tn_v3 character varying(20),
    tn_v4 character varying(20),
    tn_v5 character varying(20),
    tn_v6 character varying(20),
    tn_v7 character varying(20),
    tn_valida character varying(20),
    tn_imagen character varying(80),
    tn_sexo integer DEFAULT 1 NOT NULL,
    tn_estado integer DEFAULT 1
);


ALTER TABLE public.testn OWNER TO onlop;

--
-- Name: testn_tn_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE testn_tn_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.testn_tn_id_seq OWNER TO onlop;

--
-- Name: testn_tn_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE testn_tn_id_seq OWNED BY testn.tn_id;


SET default_with_oids = true;

--
-- Name: tipante; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tipante (
    tan_codigo integer NOT NULL,
    tan_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tipante OWNER TO onlop;

--
-- Name: tipcta; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tipcta (
    tct_codigo integer NOT NULL,
    tct_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tipcta OWNER TO onlop;

--
-- Name: tipcta_tct_codigo_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE tipcta_tct_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tipcta_tct_codigo_seq OWNER TO onlop;

--
-- Name: tipcta_tct_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE tipcta_tct_codigo_seq OWNED BY tipcta.tct_codigo;


--
-- Name: tipdocu; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tipdocu (
    td_codigo character varying(5) NOT NULL,
    td_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tipdocu OWNER TO onlop;

--
-- Name: tipemp; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tipemp (
    tem_codigo smallint NOT NULL,
    tem_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tipemp OWNER TO onlop;

--
-- Name: tipentid; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tipentid (
    tet_codigo integer NOT NULL,
    tet_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tipentid OWNER TO onlop;

--
-- Name: tipentid_tet_codigo_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE tipentid_tet_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tipentid_tet_codigo_seq OWNER TO onlop;

--
-- Name: tipentid_tet_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE tipentid_tet_codigo_seq OWNED BY tipentid.tet_codigo;


--
-- Name: tiptel; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tiptel (
    ttl_codigo integer NOT NULL,
    ttl_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tiptel OWNER TO onlop;

--
-- Name: tiptel_ttl_codigo_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE tiptel_ttl_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.tiptel_ttl_codigo_seq OWNER TO onlop;

--
-- Name: tiptel_ttl_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE tiptel_ttl_codigo_seq OWNED BY tiptel.ttl_codigo;


--
-- Name: tmedico; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE tmedico (
    med_codigo integer NOT NULL,
    med_nombre character varying(60) NOT NULL
);


ALTER TABLE public.tmedico OWNER TO onlop;

--
-- Name: trabajo; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE trabajo (
    tb_codigo integer NOT NULL,
    tb_nombre character varying(60) NOT NULL
);


ALTER TABLE public.trabajo OWNER TO onlop;

--
-- Name: unilot; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE unilot (
    unil_codunifun smallint NOT NULL,
    unit_idlote integer NOT NULL
);


ALTER TABLE public.unilot OWNER TO onlop;

--
-- Name: unimed; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE unimed (
    uni_codigo smallint NOT NULL,
    uni_nombre character varying(60) NOT NULL,
    uni_coef numeric(15,5),
    uni_simbolo character(3)
);


ALTER TABLE public.unimed OWNER TO onlop;

--
-- Name: varamb; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE varamb (
    var_codigo character varying(60) NOT NULL,
    var_nombre character varying(60) NOT NULL,
    var_valor character varying(60)
);


ALTER TABLE public.varamb OWNER TO onlop;

--
-- Name: varambi; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE varambi (
    vari_codemp integer DEFAULT 0 NOT NULL,
    vari_idptov integer DEFAULT 0 NOT NULL,
    vari_codigo character varying(60) NOT NULL,
    vari_nombre character varying(60) NOT NULL,
    vari_valor character varying(60),
    vari_tipo integer DEFAULT 1
);


ALTER TABLE public.varambi OWNER TO onlop;

--
-- Name: vendedor; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE vendedor (
    ven_id integer NOT NULL,
    ven_codemp integer NOT NULL,
    ven_nombre character varying(60) NOT NULL,
    ven_direcc character varying(60),
    ven_locali character varying(60),
    ven_codpos character varying(10),
    ven_provin integer,
    ven_pais smallint,
    ven_nrcuit character varying(20),
    ven_estado smallint DEFAULT 1,
    ven_comis numeric(15,5) DEFAULT 0
);


ALTER TABLE public.vendedor OWNER TO onlop;

--
-- Name: vendedor_ven_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE vendedor_ven_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vendedor_ven_id_seq OWNER TO onlop;

--
-- Name: vendedor_ven_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE vendedor_ven_id_seq OWNED BY vendedor.ven_id;


--
-- Name: zona; Type: TABLE; Schema: public; Owner: onlop; Tablespace: 
--

CREATE TABLE zona (
    zon_codigo integer NOT NULL,
    zon_pais integer,
    zon_provin smallint,
    zon_ciudad integer,
    zon_barrio integer,
    zon_nombre character varying(60) NOT NULL
);


ALTER TABLE public.zona OWNER TO onlop;

--
-- Name: zona_zon_codigo_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE zona_zon_codigo_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.zona_zon_codigo_seq OWNER TO onlop;

--
-- Name: zona_zon_codigo_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE zona_zon_codigo_seq OWNED BY zona.zon_codigo;


--
-- Name: artv_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE articvt ALTER COLUMN artv_id SET DEFAULT nextval('articvt_artv_id_seq'::regclass);


--
-- Name: art_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE articvta ALTER COLUMN art_id SET DEFAULT nextval('articvta_art_id_seq'::regclass);


--
-- Name: astc_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE astoctas ALTER COLUMN astc_id SET DEFAULT nextval('astoctas_astc_id_seq'::regclass);


--
-- Name: ash_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE astoh ALTER COLUMN ash_id SET DEFAULT nextval('astoh_ash_id_seq'::regclass);


--
-- Name: cub_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE cambubic ALTER COLUMN cub_id SET DEFAULT nextval('cambubic_cub_id_seq'::regclass);


--
-- Name: cat_codigo; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE catego ALTER COLUMN cat_codigo SET DEFAULT nextval('catego_cat_codigo_seq'::regclass);


--
-- Name: cco_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE centroc ALTER COLUMN cco_id SET DEFAULT nextval('centroc_cco_id_seq'::regclass);


--
-- Name: chq_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE cheques ALTER COLUMN chq_id SET DEFAULT nextval('cheques_chq_id_seq'::regclass);


--
-- Name: chqr_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE chqrech ALTER COLUMN chqr_id SET DEFAULT nextval('chqrech_chqr_id_seq'::regclass);


--
-- Name: cli_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE clientes ALTER COLUMN cli_id SET DEFAULT nextval('clientes_cli_id_seq'::regclass);


--
-- Name: cfac_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE complfac ALTER COLUMN cfac_id SET DEFAULT nextval('complfac_cfac_id_seq'::regclass);


--
-- Name: cpra_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE compra ALTER COLUMN cpra_id SET DEFAULT nextval('compra_cpra_id_seq'::regclass);


--
-- Name: comp_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE comprob ALTER COLUMN comp_id SET DEFAULT nextval('comprob_comp_id_seq'::regclass);


--
-- Name: cdp_codigo; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE conpag ALTER COLUMN cdp_codigo SET DEFAULT nextval('conpag_cdp_codigo_seq'::regclass);


ALTER TABLE public.consulta OWNER TO onlop;

--
-- Name: consulta_con_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE consulta_con_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.consulta_con_id_seq OWNER TO onlop;

--
-- Name: consulta_con_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE consulta_con_id_seq OWNED BY consulta.con_id;

--
-- Name: con_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE consulta ALTER COLUMN con_id SET DEFAULT nextval('consulta_con_id_seq'::regclass);


--
-- Name: cbl_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE ctacble ALTER COLUMN cbl_id SET DEFAULT nextval('ctacble_cbl_id_seq'::regclass);


--
-- Name: cte_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE ctes ALTER COLUMN cte_id SET DEFAULT nextval('ctes_cte_id_seq'::regclass);


--
-- Name: div_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE division ALTER COLUMN div_id SET DEFAULT nextval('division_div_id_seq'::regclass);


--
-- Name: doc_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE docum ALTER COLUMN doc_id SET DEFAULT nextval('docum_doc_id_seq'::regclass);


--
-- Name: emi_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE emiti ALTER COLUMN emi_id SET DEFAULT nextval('emiti_emi_id_seq'::regclass);


--
-- Name: ent_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE entidad ALTER COLUMN ent_id SET DEFAULT nextval('entidad_ent_id_seq'::regclass);


--
-- Name: etv_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE entrevc ALTER COLUMN etv_id SET DEFAULT nextval('entrevc_etv_id_seq'::regclass);


--
-- Name: eth_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE public.entrevh OWNER TO onlop;

--
-- Name: entrevh_eth_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE entrevh_eth_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.entrevh_eth_id_seq OWNER TO onlop;

--
-- Name: entrevh_eth_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE entrevh_eth_id_seq OWNED BY entrevh.eth_id;


ALTER TABLE entrevh ALTER COLUMN eth_id SET DEFAULT nextval('entrevh_eth_id_seq'::regclass);


--
-- Name: fac_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE facturacion ALTER COLUMN fac_id SET DEFAULT nextval('facturacion_fac_id_seq'::regclass);


--
-- Name: fir_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE firman ALTER COLUMN fir_id SET DEFAULT nextval('firman_fir_id_seq'::regclass);


--
-- Name: gpo_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE grupos ALTER COLUMN gpo_id SET DEFAULT nextval('grupos_gpo_id_seq'::regclass);


--
-- Name: ltp_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE listpre ALTER COLUMN ltp_id SET DEFAULT nextval('listpre_ltp_id_seq'::regclass);


--
-- Name: lot_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE lotes ALTER COLUMN lot_id SET DEFAULT nextval('lotes_lot_id_seq'::regclass);


--
-- Name: mne_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE monex ALTER COLUMN mne_id SET DEFAULT nextval('monex_mne_id_seq'::regclass);


--
-- Name: movs_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE movsto ALTER COLUMN movs_id SET DEFAULT nextval('movsto_movs_id_seq'::regclass);


--
-- Name: movc_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE movstoc ALTER COLUMN movc_id SET DEFAULT nextval('movstoc_movc_id_seq'::regclass);


--
-- Name: mcub_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE movubic ALTER COLUMN mcub_id SET DEFAULT nextval('movubic_mcub_id_seq'::regclass);


--
-- Name: not_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE noticias ALTER COLUMN not_id SET DEFAULT nextval('noticias_not_id_seq'::regclass);


--
-- Name: operad_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE operadores ALTER COLUMN operad_id SET DEFAULT nextval('operadores_operad_id_seq'::regclass);


--
-- Name: pac_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE pacientes ALTER COLUMN pac_id SET DEFAULT nextval('pacientes_pac_id_seq'::regclass);


--
-- Name: prov_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE prove ALTER COLUMN prov_id SET DEFAULT nextval('prove_prov_id_seq'::regclass);


--
-- Name: pro_codigo; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE provin ALTER COLUMN pro_codigo SET DEFAULT nextval('provin_pro_codigo_seq'::regclass);


--
-- Name: ptn_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE ptestn ALTER COLUMN ptn_id SET DEFAULT nextval('ptestn_ptn_id_seq'::regclass);


--
-- Name: ptv_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE ptovta ALTER COLUMN ptv_id SET DEFAULT nextval('ptovta_ptv_id_seq'::regclass);


--
-- Name: rub_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE rubros ALTER COLUMN rub_id SET DEFAULT nextval('rubros_rub_id_seq'::regclass);


--
-- Name: stk_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE stock ALTER COLUMN stk_id SET DEFAULT nextval('stock_stk_id_seq'::regclass);


--
-- Name: subd_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE subd ALTER COLUMN subd_id SET DEFAULT nextval('subd_subd_id_seq'::regclass);


--
-- Name: srb_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE subrub ALTER COLUMN srb_id SET DEFAULT nextval('subrub_srb_id_seq'::regclass);


--
-- Name: tal_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE talon ALTER COLUMN tal_id SET DEFAULT nextval('talon_tal_id_seq'::regclass);


--
-- Name: tel_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE telefon ALTER COLUMN tel_id SET DEFAULT nextval('telefon_tel_id_seq'::regclass);


--
-- Name: tn_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE testn ALTER COLUMN tn_id SET DEFAULT nextval('testn_tn_id_seq'::regclass);


--
-- Name: tct_codigo; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE tipcta ALTER COLUMN tct_codigo SET DEFAULT nextval('tipcta_tct_codigo_seq'::regclass);


--
-- Name: tet_codigo; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE tipentid ALTER COLUMN tet_codigo SET DEFAULT nextval('tipentid_tet_codigo_seq'::regclass);


--
-- Name: ttl_codigo; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE tiptel ALTER COLUMN ttl_codigo SET DEFAULT nextval('tiptel_ttl_codigo_seq'::regclass);


--
-- Name: ven_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE vendedor ALTER COLUMN ven_id SET DEFAULT nextval('vendedor_ven_id_seq'::regclass);


--
-- Name: zon_codigo; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE zona ALTER COLUMN zon_codigo SET DEFAULT nextval('zona_zon_codigo_seq'::regclass);


--
-- Name: antecedentes_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY antecedentes
    ADD CONSTRAINT antecedentes_pkey PRIMARY KEY (ant_paciente, ant_fecest);


--
-- Name: articvt_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY articvt
    ADD CONSTRAINT articvt_pkey PRIMARY KEY (artv_id);


--
-- Name: articvta_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT articvta_pkey PRIMARY KEY (art_id);


--
-- Name: astoctas_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_pkey PRIMARY KEY (astc_id);


--
-- Name: astoh_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_pkey PRIMARY KEY (ash_id);


--
-- Name: bancos_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY bancos
    ADD CONSTRAINT bancos_pkey PRIMARY KEY (bco_codigo);


--
-- Name: cambubic_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY cambubic
    ADD CONSTRAINT cambubic_pkey PRIMARY KEY (cub_id);


--
-- Name: catego_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY catego
    ADD CONSTRAINT catego_pkey PRIMARY KEY (cat_codigo);


--
-- Name: centroc_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_pkey PRIMARY KEY (cco_id);


--
-- Name: cheques_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_pkey PRIMARY KEY (chq_id);


--
-- Name: clientes_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY clientes
    ADD CONSTRAINT clientes_pkey PRIMARY KEY (cli_id);


--
-- Name: complcfac_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY complfac
    ADD CONSTRAINT complcfac_pkey PRIMARY KEY (cfac_id);


--
-- Name: compra_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_pkey PRIMARY KEY (cpra_id);


--
-- Name: comprob_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY comprob
    ADD CONSTRAINT comprob_pkey PRIMARY KEY (comp_id);


--
-- Name: coniva_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY coniva
    ADD CONSTRAINT coniva_pkey PRIMARY KEY (iva_codigo);


--
-- Name: conpag_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY conpag
    ADD CONSTRAINT conpag_pkey PRIMARY KEY (cdp_codigo);


--
-- Name: convivencia_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY convivencia
    ADD CONSTRAINT convivencia_pkey PRIMARY KEY (cv_codigo);


--
-- Name: cotiza_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY cotiza
    ADD CONSTRAINT cotiza_pkey PRIMARY KEY (cot_moneda, cot_fecha);


--
-- Name: ctacble_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT ctacble_pkey PRIMARY KEY (cbl_id);


--
-- Name: ctes_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY ctes
    ADD CONSTRAINT ctes_pkey PRIMARY KEY (cte_id);


--
-- Name: division_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_pkey PRIMARY KEY (div_id);


--
-- Name: docum_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_pkey PRIMARY KEY (doc_id);


--
-- Name: ecivil_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY ecivil
    ADD CONSTRAINT ecivil_pkey PRIMARY KEY (ec_codigo);


--
-- Name: educacion_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY educacion
    ADD CONSTRAINT educacion_pkey PRIMARY KEY (ed_codigo);


--
-- Name: emiti_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_pkey PRIMARY KEY (emi_id);


--
-- Name: empresa_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY empresa
    ADD CONSTRAINT empresa_pkey PRIMARY KEY (emp_codigo);


--
-- Name: entidad_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY entidad
    ADD CONSTRAINT entidad_pkey PRIMARY KEY (ent_id);


--
-- Name: esclisp_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY esclisp
    ADD CONSTRAINT esclisp_pkey PRIMARY KEY (elp_idart, elp_orden);


--
-- Name: eventos_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY eventos
    ADD CONSTRAINT eventos_pkey PRIMARY KEY (eve_codigo);


--
-- Name: evindi_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY evindi
    ADD CONSTRAINT evindi_pkey PRIMARY KEY (evi_indice, evi_fecha);


--
-- Name: facturacion_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY facturacion
    ADD CONSTRAINT facturacion_pkey PRIMARY KEY (fac_id);


--
-- Name: firman_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY firman
    ADD CONSTRAINT firman_pkey PRIMARY KEY (fir_id);


--
-- Name: grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY grupos
    ADD CONSTRAINT grupos_pkey PRIMARY KEY (gpo_id);


--
-- Name: indices_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY indices
    ADD CONSTRAINT indices_pkey PRIMARY KEY (ind_codigo);


--
-- Name: interes_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_pkey PRIMARY KEY (int_codemp, int_fecha);


--
-- Name: listpre_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY listpre
    ADD CONSTRAINT listpre_pkey PRIMARY KEY (ltp_id);


--
-- Name: lotes_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY lotes
    ADD CONSTRAINT lotes_pkey PRIMARY KEY (lot_id);


--
-- Name: manzana_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY manzana
    ADD CONSTRAINT manzana_pkey PRIMARY KEY (mza_codigo, mza_codseccion);


--
-- Name: moneda_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY moneda
    ADD CONSTRAINT moneda_pkey PRIMARY KEY (mon_codigo);


--
-- Name: monex_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY monex
    ADD CONSTRAINT monex_pkey PRIMARY KEY (mne_id);


--
-- Name: movsto_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_pkey PRIMARY KEY (movs_id);


--
-- Name: movstoc_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT movstoc_pkey PRIMARY KEY (movc_id);


--
-- Name: movubic_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY movubic
    ADD CONSTRAINT movubic_pkey PRIMARY KEY (mcub_id);


--
-- Name: operadores_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY operadores
    ADD CONSTRAINT operadores_pkey PRIMARY KEY (operad_id);


--
-- Name: pais_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY pais
    ADD CONSTRAINT pais_pkey PRIMARY KEY (pai_codigo);


--
-- Name: prove_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY prove
    ADD CONSTRAINT prove_pkey PRIMARY KEY (prov_id);


--
-- Name: provin_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY provin
    ADD CONSTRAINT provin_pkey PRIMARY KEY (pro_codigo);


--
-- Name: ptovta_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT ptovta_pkey PRIMARY KEY (ptv_id);


--
-- Name: rubros_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY rubros
    ADD CONSTRAINT rubros_pkey PRIMARY KEY (rub_id);


--
-- Name: seccion_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY seccion
    ADD CONSTRAINT seccion_pkey PRIMARY KEY (sec_codigo);


--
-- Name: stock_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY stock
    ADD CONSTRAINT stock_pkey PRIMARY KEY (stk_id);


--
-- Name: subd_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY subd
    ADD CONSTRAINT subd_pkey PRIMARY KEY (subd_id);


--
-- Name: subrub_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY subrub
    ADD CONSTRAINT subrub_pkey PRIMARY KEY (srb_id);


--
-- Name: subxcomp_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY subxcomp
    ADD CONSTRAINT subxcomp_pkey PRIMARY KEY (subxc_idsub, subxc_comprob);


--
-- Name: sucursal_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY sucursal
    ADD CONSTRAINT sucursal_pkey PRIMARY KEY (sucu_cliente, sucu_codigo);


--
-- Name: talon_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT talon_pkey PRIMARY KEY (tal_id);


--
-- Name: telefon_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT telefon_pkey PRIMARY KEY (tel_id);


--
-- Name: tipante_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tipante
    ADD CONSTRAINT tipante_pkey PRIMARY KEY (tan_codigo);


--
-- Name: tipcta_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tipcta
    ADD CONSTRAINT tipcta_pkey PRIMARY KEY (tct_codigo);


--
-- Name: tipdocu_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tipdocu
    ADD CONSTRAINT tipdocu_pkey PRIMARY KEY (td_codigo);


--
-- Name: tipemp_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tipemp
    ADD CONSTRAINT tipemp_pkey PRIMARY KEY (tem_codigo);


--
-- Name: tipentid_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tipentid
    ADD CONSTRAINT tipentid_pkey PRIMARY KEY (tet_codigo);


--
-- Name: tiptel_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tiptel
    ADD CONSTRAINT tiptel_pkey PRIMARY KEY (ttl_codigo);


--
-- Name: tmedico_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY tmedico
    ADD CONSTRAINT tmedico_pkey PRIMARY KEY (med_codigo);


--
-- Name: trabajo_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY trabajo
    ADD CONSTRAINT trabajo_pkey PRIMARY KEY (tb_codigo);


--
-- Name: unilot_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY unilot
    ADD CONSTRAINT unilot_pkey PRIMARY KEY (unil_codunifun, unit_idlote);


--
-- Name: unimed_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY unimed
    ADD CONSTRAINT unimed_pkey PRIMARY KEY (uni_codigo);


--
-- Name: varamb_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY varamb
    ADD CONSTRAINT varamb_pkey PRIMARY KEY (var_codigo);


--
-- Name: varambi_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY varambi
    ADD CONSTRAINT varambi_pkey PRIMARY KEY (vari_codemp, vari_idptov, vari_codigo);


--
-- Name: vendedor_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY vendedor
    ADD CONSTRAINT vendedor_pkey PRIMARY KEY (ven_id);


--
-- Name: zona_pkey; Type: CONSTRAINT; Schema: public; Owner: onlop; Tablespace: 
--

ALTER TABLE ONLY zona
    ADD CONSTRAINT zona_pkey PRIMARY KEY (zon_codigo);


--
-- Name: artico; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX artico ON complfac USING btree (cfac_codemp, cfac_ptov, cfac_cliente, cfac_estado, cfac_idart);


--
-- Name: cfac_empresa; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX cfac_empresa ON complfac USING btree (cfac_codemp, cfac_ptov, cfac_cliente);


--
-- Name: cfac_estado; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX cfac_estado ON complfac USING btree (cfac_codemp, cfac_ptov, cfac_cliente, cfac_estado);


--
-- Name: idx_articvt_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_articvt_1 ON articvt USING btree (artv_idartic);


--
-- Name: idx_articvt_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_articvt_2 ON articvt USING btree (artv_idartic, artv_estado);


--
-- Name: idx_articvt_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_articvt_3 ON articvt USING btree (artv_codi);


--
-- Name: idx_articvt_4; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_articvt_4 ON articvt USING btree (artv_codigo);


--
-- Name: idx_articvt_5; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_articvt_5 ON articvt USING btree (artv_idashing);


--
-- Name: idx_articvt_6; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_articvt_6 ON articvt USING btree (artv_idashout);


--
-- Name: idx_articvta_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_1 ON articvta USING btree (art_codemp, art_codi);


--
-- Name: idx_articvta_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_2 ON articvta USING btree (art_codemp, art_estado, art_codi);


--
-- Name: idx_articvta_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_3 ON articvta USING btree (art_codemp, art_marca, art_codi);


--
-- Name: idx_articvta_4; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_articvta_4 ON articvta USING btree (art_codemp, art_marca);


--
-- Name: idx_articvta_5; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_articvta_5 ON articvta USING btree (art_codemp, art_marca, art_serie);


--
-- Name: idx_astoctas_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_1 ON astoctas USING btree (astc_idastoh);


--
-- Name: idx_astoctas_10; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_10 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_11; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_11 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_12; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_12 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_moneda);


--
-- Name: idx_astoctas_13; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_13 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_14; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_14 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_15; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_15 ON astoctas USING btree (astc_codemp, astc_estado, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_2 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_3 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_4; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_4 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_fecval);


--
-- Name: idx_astoctas_5; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_5 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_6; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_6 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecvto);


--
-- Name: idx_astoctas_7; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_7 ON astoctas USING btree (astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_8; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_8 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_ctacte, astc_grupo);


--
-- Name: idx_astoctas_9; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoctas_9 ON astoctas USING btree (astc_codemp, astc_idptov, astc_comprob, astc_numero);


--
-- Name: idx_astoh_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_astoh_1 ON astoh USING btree (ash_codemp, ash_idptov, ash_comprob, ash_numero);


--
-- Name: idx_astoh_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoh_2 ON astoh USING btree (ash_codemp, ash_anio, ash_mes, ash_fecomp);


--
-- Name: idx_astoh_5; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_astoh_5 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_fecomp);


--
-- Name: idx_cambubic_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cambubic_1 ON cambubic USING btree (cub_comprob, cub_numero);


--
-- Name: idx_cambubic_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cambubic_2 ON cambubic USING btree (cub_origen);


--
-- Name: idx_cambubic_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cambubic_3 ON cambubic USING btree (cub_destino);


--
-- Name: idx_centroc_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_centroc_1 ON centroc USING btree (cco_codemp, cco_idptov, cco_coddiv, cco_codigo);


--
-- Name: idx_cheques_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cheques_1 ON cheques USING btree (chq_codemp, chq_estado);


--
-- Name: idx_cheques_10; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cheques_10 ON cheques USING btree (chq_moneda, chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cheques_2 ON cheques USING btree (chq_codemp, chq_idptov, chq_estado);


--
-- Name: idx_cheques_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cheques_3 ON cheques USING btree (chq_codbco, chq_nucheq);


--
-- Name: idx_cheques_4; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cheques_4 ON cheques USING btree (chq_idastoc);


--
-- Name: idx_cheques_5; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cheques_5 ON cheques USING btree (chq_idastoce);


--
-- Name: idx_cheques_6; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cheques_6 ON cheques USING btree (chq_estado);


--
-- Name: idx_cheques_7; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cheques_7 ON cheques USING btree (chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_8; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cheques_8 ON cheques USING btree (chq_estado, chq_fecheq);


--
-- Name: idx_cheques_9; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_cheques_9 ON cheques USING btree (chq_moneda);


--
-- Name: idx_clientes_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_clientes_1 ON clientes USING btree (cli_codemp, cli_idptov, cli_codigo);


--
-- Name: idx_clientes_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_clientes_2 ON clientes USING btree (cli_codemp, cli_codaso);


--
-- Name: idx_compra_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_compra_1 ON compra USING btree (cpra_codemp, cpra_idptov, cpra_comprob, cpra_numero);


--
-- Name: idx_compra_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_compra_2 ON compra USING btree (cpra_codemp, cpra_fecval);


--
-- Name: idx_compra_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_compra_3 ON compra USING btree (cpra_idastoh);


--
-- Name: idx_compra_4; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_compra_4 ON compra USING btree (cpra_idret);


--
-- Name: idx_comprob_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_comprob_1 ON comprob USING btree (comp_idptov, comp_codigo);


--
-- Name: idx_comprob_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_comprob_2 ON comprob USING btree (comp_siste, comp_idptov, comp_codigo);


--
-- Name: idx_ctacble_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctacble_1 ON ctacble USING btree (cbl_codemp, cbl_codigo);


--
-- Name: idx_ctes_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctes_1 ON ctes USING btree (cte_codemp, cte_tipcta, cte_tipct, cte_codigo);


--
-- Name: idx_division_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_division_1 ON division USING btree (div_codemp, div_idptov, div_codigo);


--
-- Name: idx_docum_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_docum_1 ON docum USING btree (doc_nrcuit);


--
-- Name: idx_docum_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_docum_2 ON docum USING btree (doc_estado, doc_nrcuit);


--
-- Name: idx_docum_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_docum_3 ON docum USING btree (doc_codemp, doc_idptov, doc_estado);


--
-- Name: idx_docum_4; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_docum_4 ON docum USING btree (doc_idastoc);


--
-- Name: idx_docum_5; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_docum_5 ON docum USING btree (doc_idastoce);


--
-- Name: idx_docum_6; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_docum_6 ON docum USING btree (doc_estado);


--
-- Name: idx_emiti_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_emiti_1 ON emiti USING btree (emi_codemp, emi_idptov, emi_comprob, emi_numero);


--
-- Name: idx_emiti_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_emiti_2 ON emiti USING btree (emi_codemp, emi_fecval);


--
-- Name: idx_emiti_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_emiti_3 ON emiti USING btree (emi_idastoh);


--
-- Name: idx_empresa_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_empresa_1 ON empresa USING btree (emp_nrcuit);


--
-- Name: idx_firman_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_firman_1 ON firman USING btree (fir_nrcuit);


--
-- Name: idx_listpre_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_listpre_1 ON listpre USING btree (ltp_idcli, ltp_idart);


--
-- Name: idx_movsto_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movsto_1 ON movsto USING btree (movs_idemiti);


--
-- Name: idx_movsto_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movsto_2 ON movsto USING btree (movs_idastoh);


--
-- Name: idx_movsto_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movsto_3 ON movsto USING btree (movs_artic);


--
-- Name: idx_movsto_4; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movsto_4 ON movsto USING btree (movs_codemp, movs_idptov, movs_artic);


--
-- Name: idx_movsto_5; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movsto_5 ON movsto USING btree (movs_idastoh, movs_artic);


--
-- Name: idx_movstoc_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movstoc_1 ON movstoc USING btree (movc_idcompra);


--
-- Name: idx_movstoc_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movstoc_2 ON movstoc USING btree (movc_idastoh);


--
-- Name: idx_movstoc_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movstoc_3 ON movstoc USING btree (movc_artic);


--
-- Name: idx_movstoc_4; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movstoc_4 ON movstoc USING btree (movc_codemp, movc_idptov, movc_artic);


--
-- Name: idx_movstoc_5; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movstoc_5 ON movstoc USING btree (movc_idastoh, movc_artic);


--
-- Name: idx_movubic_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movubic_2 ON movubic USING btree (mcub_origen);


--
-- Name: idx_movubic_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movubic_3 ON movubic USING btree (mcub_destino);


--
-- Name: idx_movubic_4; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_movubic_4 ON movubic USING btree (mcub_idcub);


--
-- Name: idx_operadores_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_operadores_2 ON operadores USING btree (operad_login);


--
-- Name: idx_prove_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_prove_1 ON prove USING btree (prov_nrcuit);


--
-- Name: idx_prove_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_prove_2 ON prove USING btree (prov_codemp, prov_codigo);


--
-- Name: idx_ptovta_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_ptovta_1 ON ptovta USING btree (ptv_codemp, ptv_codigo);


--
-- Name: idx_rubros_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_rubros_1 ON rubros USING btree (rub_tipo, rub_codigo);


--
-- Name: idx_stock_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_stock_1 ON stock USING btree (stk_idoper, stk_id);


--
-- Name: idx_stock_10; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_10 ON stock USING btree (stk_comptras);


--
-- Name: idx_stock_11; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_11 ON stock USING btree (stk_estado, stk_cliente);


--
-- Name: idx_stock_12; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_12 ON stock USING btree (stk_cliente);


--
-- Name: idx_stock_13; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_13 ON stock USING btree (stk_idsitem);


--
-- Name: idx_stock_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_2 ON stock USING btree (stk_estado, stk_idsitem);


--
-- Name: idx_stock_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_3 ON stock USING btree (stk_estado, stk_directo, stk_indirecto, stk_compbte, stk_artic);


--
-- Name: idx_stock_4; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_4 ON stock USING btree (stk_estado, stk_compbte);


--
-- Name: idx_stock_5; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_5 ON stock USING btree (stk_estado, stk_deposito);


--
-- Name: idx_stock_6; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_6 ON stock USING btree (stk_estado, stk_directo, stk_indirecto, stk_artic);


--
-- Name: idx_stock_7; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_7 ON stock USING btree (stk_estado, stk_indirecto);


--
-- Name: idx_stock_8; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_8 ON stock USING btree (stk_estado, stk_artic);


--
-- Name: idx_stock_9; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_stock_9 ON stock USING btree (stk_artic);


--
-- Name: idx_subd_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_subd_1 ON subd USING btree (subd_codemp, subd_idptov);


--
-- Name: idx_subrub_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_subrub_1 ON subrub USING btree (srb_rubro, srb_codigo);


--
-- Name: idx_talon_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE UNIQUE INDEX idx_talon_1 ON talon USING btree (tal_idptov, tal_comprob);


--
-- Name: idx_telefon_1; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_telefon_1 ON telefon USING btree (tel_tipent, tel_codigo, tel_tiptel);


--
-- Name: idx_telefon_2; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_telefon_2 ON telefon USING btree (tel_dato);


--
-- Name: idx_telefon_3; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX idx_telefon_3 ON telefon USING btree (tel_contact);


--
-- Name: periodo; Type: INDEX; Schema: public; Owner: onlop; Tablespace: 
--

CREATE INDEX periodo ON facturacion USING btree (fac_codemp, fac_ptov, fac_cliente, fac_anio, fac_mes);


--
-- Name: ai_astoctas; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER ai_astoctas
    AFTER INSERT ON astoctas
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_astoctas();


--
-- Name: ai_clientes; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER ai_clientes
    AFTER INSERT ON clientes
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_clientes();


--
-- Name: ai_movstoc; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER ai_movstoc
    AFTER INSERT ON movstoc
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_movstoc();


--
-- Name: ai_prove; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER ai_prove
    AFTER INSERT ON prove
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_prove();


--
-- Name: au_astoctas; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER au_astoctas
    AFTER UPDATE ON astoctas
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_astoctas();


--
-- Name: au_astoh; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER au_astoh
    AFTER UPDATE ON astoh
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_astoh();


--
-- Name: au_cambubic; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER au_cambubic
    AFTER UPDATE ON cambubic
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_cambubic();


--
-- Name: au_clientes; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER au_clientes
    AFTER UPDATE ON clientes
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_clientes();


--
-- Name: au_compra; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER au_compra
    AFTER UPDATE ON compra
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_compra();


--
-- Name: au_emiti; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER au_emiti
    AFTER UPDATE ON emiti
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_emiti();


--
-- Name: au_movstoc; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER au_movstoc
    AFTER UPDATE ON movstoc
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_movstoc();


--
-- Name: au_movubic; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER au_movubic
    AFTER UPDATE ON movubic
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_movubic();


--
-- Name: au_prove; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER au_prove
    AFTER UPDATE ON prove
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_prove();


--
-- Name: bd_articvta; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bd_articvta
    BEFORE DELETE ON articvta
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_articvta();


--
-- Name: bd_astoctas; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bd_astoctas
    BEFORE DELETE ON astoctas
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_astoctas();


--
-- Name: bd_astoh; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bd_astoh
    BEFORE DELETE ON astoh
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_astoh();


--
-- Name: bd_cambubic; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bd_cambubic
    BEFORE DELETE ON cambubic
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_cambubic();


--
-- Name: bd_clientes; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bd_clientes
    BEFORE DELETE ON clientes
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_clientes();


--
-- Name: bd_compra; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bd_compra
    BEFORE DELETE ON compra
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_compra();


--
-- Name: bd_emiti; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bd_emiti
    BEFORE DELETE ON emiti
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_emiti();


--
-- Name: bd_movstoc; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bd_movstoc
    BEFORE DELETE ON movstoc
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_movstoc();


--
-- Name: bd_movubic; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bd_movubic
    BEFORE DELETE ON movubic
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_movubic();


--
-- Name: bu_astoh; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bu_astoh
    BEFORE UPDATE ON astoh
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_astoh();


--
-- Name: bu_cheques; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bu_cheques
    BEFORE UPDATE ON cheques
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_cheques();


--
-- Name: bu_movstoc; Type: TRIGGER; Schema: public; Owner: onlop
--

CREATE TRIGGER bu_movstoc
    BEFORE UPDATE ON movstoc
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_movstoc();


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT "$1" FOREIGN KEY (tal_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT "$1" FOREIGN KEY (movs_idastoh) REFERENCES astoh(ash_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT "$1" FOREIGN KEY (movc_idastoh) REFERENCES astoh(ash_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY cambubic
    ADD CONSTRAINT "$1" FOREIGN KEY (cub_comprob) REFERENCES comprob(comp_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY movubic
    ADD CONSTRAINT "$1" FOREIGN KEY (mcub_idcub) REFERENCES cambubic(cub_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY articvt
    ADD CONSTRAINT "$1" FOREIGN KEY (artv_idartic) REFERENCES articvta(art_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT "$2" FOREIGN KEY (movs_idemiti) REFERENCES emiti(emi_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT "$2" FOREIGN KEY (movc_idcompra) REFERENCES compra(cpra_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY movubic
    ADD CONSTRAINT "$2" FOREIGN KEY (mcub_artic) REFERENCES articvta(art_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY articvt
    ADD CONSTRAINT "$2" FOREIGN KEY (artv_idashing) REFERENCES astoh(ash_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT "$3" FOREIGN KEY (movs_artic) REFERENCES articvta(art_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT "$3" FOREIGN KEY (movc_artic) REFERENCES articvta(art_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY articvt
    ADD CONSTRAINT "$3" FOREIGN KEY (artv_idmovstoc) REFERENCES movstoc(movc_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT "$4" FOREIGN KEY (movs_codcli) REFERENCES clientes(cli_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: onlop
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT "$4" FOREIGN KEY (movc_codpro) REFERENCES prove(prov_id);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: antecedentes; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE antecedentes FROM PUBLIC;
REVOKE ALL ON TABLE antecedentes FROM onlop;
GRANT ALL ON TABLE antecedentes TO onlop;
GRANT ALL ON TABLE antecedentes TO nobody;


--
-- Name: articvt; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE articvt FROM PUBLIC;
REVOKE ALL ON TABLE articvt FROM onlop;
GRANT ALL ON TABLE articvt TO onlop;
GRANT ALL ON TABLE articvt TO nobody;


--
-- Name: articvt_artv_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE articvt_artv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articvt_artv_id_seq FROM onlop;
GRANT ALL ON SEQUENCE articvt_artv_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE articvt_artv_id_seq TO nobody;


--
-- Name: articvta; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE articvta FROM PUBLIC;
REVOKE ALL ON TABLE articvta FROM onlop;
GRANT ALL ON TABLE articvta TO onlop;
GRANT ALL ON TABLE articvta TO nobody;


--
-- Name: articvta_art_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM onlop;
GRANT ALL ON SEQUENCE articvta_art_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE articvta_art_id_seq TO nobody;


--
-- Name: astoctas; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE astoctas FROM PUBLIC;
REVOKE ALL ON TABLE astoctas FROM onlop;
GRANT ALL ON TABLE astoctas TO onlop;
GRANT ALL ON TABLE astoctas TO nobody;


--
-- Name: astoctas_astc_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM onlop;
GRANT ALL ON SEQUENCE astoctas_astc_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE astoctas_astc_id_seq TO nobody;


--
-- Name: astoh; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE astoh FROM PUBLIC;
REVOKE ALL ON TABLE astoh FROM onlop;
GRANT ALL ON TABLE astoh TO onlop;
GRANT ALL ON TABLE astoh TO nobody;


--
-- Name: astoh_ash_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM onlop;
GRANT ALL ON SEQUENCE astoh_ash_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE astoh_ash_id_seq TO nobody;


--
-- Name: bancos; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE bancos FROM PUBLIC;
REVOKE ALL ON TABLE bancos FROM onlop;
GRANT ALL ON TABLE bancos TO onlop;
GRANT ALL ON TABLE bancos TO nobody;


--
-- Name: cambubic; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE cambubic FROM PUBLIC;
REVOKE ALL ON TABLE cambubic FROM onlop;
GRANT ALL ON TABLE cambubic TO onlop;
GRANT ALL ON TABLE cambubic TO nobody;


--
-- Name: cambubic_cub_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE cambubic_cub_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cambubic_cub_id_seq FROM onlop;
GRANT ALL ON SEQUENCE cambubic_cub_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE cambubic_cub_id_seq TO nobody;


--
-- Name: catego; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE catego FROM PUBLIC;
REVOKE ALL ON TABLE catego FROM onlop;
GRANT ALL ON TABLE catego TO onlop;
GRANT ALL ON TABLE catego TO nobody;


--
-- Name: catego_cat_codigo_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE catego_cat_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE catego_cat_codigo_seq FROM onlop;
GRANT ALL ON SEQUENCE catego_cat_codigo_seq TO onlop;
GRANT UPDATE ON SEQUENCE catego_cat_codigo_seq TO nobody;


--
-- Name: centroc; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE centroc FROM PUBLIC;
REVOKE ALL ON TABLE centroc FROM onlop;
GRANT ALL ON TABLE centroc TO onlop;
GRANT ALL ON TABLE centroc TO nobody;


--
-- Name: centroc_cco_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE centroc_cco_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE centroc_cco_id_seq FROM onlop;
GRANT ALL ON SEQUENCE centroc_cco_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE centroc_cco_id_seq TO nobody;


--
-- Name: cheques; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE cheques FROM PUBLIC;
REVOKE ALL ON TABLE cheques FROM onlop;
GRANT ALL ON TABLE cheques TO onlop;
GRANT ALL ON TABLE cheques TO nobody;


--
-- Name: cheques_chq_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM onlop;
GRANT ALL ON SEQUENCE cheques_chq_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE cheques_chq_id_seq TO nobody;


--
-- Name: chqrech; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE chqrech FROM PUBLIC;
REVOKE ALL ON TABLE chqrech FROM onlop;
GRANT ALL ON TABLE chqrech TO onlop;
GRANT ALL ON TABLE chqrech TO nobody;


--
-- Name: chqrech_chqr_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE chqrech_chqr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chqrech_chqr_id_seq FROM onlop;
GRANT ALL ON SEQUENCE chqrech_chqr_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE chqrech_chqr_id_seq TO nobody;


--
-- Name: clientes; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE clientes FROM PUBLIC;
REVOKE ALL ON TABLE clientes FROM onlop;
GRANT ALL ON TABLE clientes TO onlop;
GRANT ALL ON TABLE clientes TO nobody;


--
-- Name: clientes_cli_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE clientes_cli_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE clientes_cli_id_seq FROM onlop;
GRANT ALL ON SEQUENCE clientes_cli_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE clientes_cli_id_seq TO nobody;


--
-- Name: complfac; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE complfac FROM PUBLIC;
REVOKE ALL ON TABLE complfac FROM onlop;
GRANT ALL ON TABLE complfac TO onlop;
GRANT ALL ON TABLE complfac TO nobody;


--
-- Name: complfac_cfac_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE complfac_cfac_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE complfac_cfac_id_seq FROM onlop;
GRANT ALL ON SEQUENCE complfac_cfac_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE complfac_cfac_id_seq TO nobody;


--
-- Name: compra; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE compra FROM PUBLIC;
REVOKE ALL ON TABLE compra FROM onlop;
GRANT ALL ON TABLE compra TO onlop;
GRANT ALL ON TABLE compra TO nobody;


--
-- Name: compra_cpra_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM onlop;
GRANT ALL ON SEQUENCE compra_cpra_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE compra_cpra_id_seq TO nobody;


--
-- Name: comprob; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE comprob FROM PUBLIC;
REVOKE ALL ON TABLE comprob FROM onlop;
GRANT ALL ON TABLE comprob TO onlop;
GRANT ALL ON TABLE comprob TO nobody;


--
-- Name: comprob_comp_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM onlop;
GRANT ALL ON SEQUENCE comprob_comp_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE comprob_comp_id_seq TO nobody;


--
-- Name: coniva; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE coniva FROM PUBLIC;
REVOKE ALL ON TABLE coniva FROM onlop;
GRANT ALL ON TABLE coniva TO onlop;
GRANT ALL ON TABLE coniva TO nobody;


--
-- Name: conpag; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE conpag FROM PUBLIC;
REVOKE ALL ON TABLE conpag FROM onlop;
GRANT ALL ON TABLE conpag TO onlop;
GRANT ALL ON TABLE conpag TO nobody;


--
-- Name: conpag_cdp_codigo_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE conpag_cdp_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE conpag_cdp_codigo_seq FROM onlop;
GRANT ALL ON SEQUENCE conpag_cdp_codigo_seq TO onlop;
GRANT UPDATE ON SEQUENCE conpag_cdp_codigo_seq TO nobody;


ALTER TABLE public.consulta OWNER TO onlop;

--
-- Name: consulta_con_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE consulta_con_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.consulta_con_id_seq OWNER TO onlop;

--
-- Name: consulta_con_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE consulta_con_id_seq OWNED BY consulta.con_id;

--
-- Name: con_id; Type: DEFAULT; Schema: public; Owner: onlop
--

ALTER TABLE consulta ALTER COLUMN con_id SET DEFAULT nextval('consulta_con_id_seq'::regclass);

--
-- Name: consulta; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE consulta FROM PUBLIC;
REVOKE ALL ON TABLE consulta FROM onlop;
GRANT ALL ON TABLE consulta TO onlop;
GRANT ALL ON TABLE consulta TO nobody;


--
-- Name: consulta_con_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE consulta_con_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE consulta_con_id_seq FROM onlop;
GRANT ALL ON SEQUENCE consulta_con_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE consulta_con_id_seq TO nobody;


--
-- Name: convivencia; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE convivencia FROM PUBLIC;
REVOKE ALL ON TABLE convivencia FROM onlop;
GRANT ALL ON TABLE convivencia TO onlop;
GRANT ALL ON TABLE convivencia TO nobody;


--
-- Name: cotiza; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE cotiza FROM PUBLIC;
REVOKE ALL ON TABLE cotiza FROM onlop;
GRANT ALL ON TABLE cotiza TO onlop;
GRANT ALL ON TABLE cotiza TO nobody;


--
-- Name: ctacble; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE ctacble FROM PUBLIC;
REVOKE ALL ON TABLE ctacble FROM onlop;
GRANT ALL ON TABLE ctacble TO onlop;
GRANT ALL ON TABLE ctacble TO nobody;


--
-- Name: ctacble_cbl_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM onlop;
GRANT ALL ON SEQUENCE ctacble_cbl_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE ctacble_cbl_id_seq TO nobody;


--
-- Name: ctes; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE ctes FROM PUBLIC;
REVOKE ALL ON TABLE ctes FROM onlop;
GRANT ALL ON TABLE ctes TO onlop;
GRANT ALL ON TABLE ctes TO nobody;


--
-- Name: ctes_cte_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM onlop;
GRANT ALL ON SEQUENCE ctes_cte_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE ctes_cte_id_seq TO nobody;


--
-- Name: division; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE division FROM PUBLIC;
REVOKE ALL ON TABLE division FROM onlop;
GRANT ALL ON TABLE division TO onlop;
GRANT ALL ON TABLE division TO nobody;


--
-- Name: division_div_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE division_div_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE division_div_id_seq FROM onlop;
GRANT ALL ON SEQUENCE division_div_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE division_div_id_seq TO nobody;


--
-- Name: docum; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE docum FROM PUBLIC;
REVOKE ALL ON TABLE docum FROM onlop;
GRANT ALL ON TABLE docum TO onlop;
GRANT ALL ON TABLE docum TO nobody;


--
-- Name: docum_doc_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM onlop;
GRANT ALL ON SEQUENCE docum_doc_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE docum_doc_id_seq TO nobody;


--
-- Name: ecivil; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE ecivil FROM PUBLIC;
REVOKE ALL ON TABLE ecivil FROM onlop;
GRANT ALL ON TABLE ecivil TO onlop;
GRANT ALL ON TABLE ecivil TO nobody;


--
-- Name: educacion; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE educacion FROM PUBLIC;
REVOKE ALL ON TABLE educacion FROM onlop;
GRANT ALL ON TABLE educacion TO onlop;
GRANT ALL ON TABLE educacion TO nobody;


--
-- Name: emiti; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE emiti FROM PUBLIC;
REVOKE ALL ON TABLE emiti FROM onlop;
GRANT ALL ON TABLE emiti TO onlop;
GRANT ALL ON TABLE emiti TO nobody;


--
-- Name: emiti_emi_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM onlop;
GRANT ALL ON SEQUENCE emiti_emi_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE emiti_emi_id_seq TO nobody;


--
-- Name: empresa; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE empresa FROM PUBLIC;
REVOKE ALL ON TABLE empresa FROM onlop;
GRANT ALL ON TABLE empresa TO onlop;
GRANT ALL ON TABLE empresa TO nobody;


--
-- Name: entidad; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE entidad FROM PUBLIC;
REVOKE ALL ON TABLE entidad FROM onlop;
GRANT ALL ON TABLE entidad TO onlop;
GRANT ALL ON TABLE entidad TO nobody;


--
-- Name: entidad_ent_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE entidad_ent_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE entidad_ent_id_seq FROM onlop;
GRANT ALL ON SEQUENCE entidad_ent_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE entidad_ent_id_seq TO nobody;


--
-- Name: entrevc; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE entrevc FROM PUBLIC;
REVOKE ALL ON TABLE entrevc FROM onlop;
GRANT ALL ON TABLE entrevc TO onlop;
GRANT ALL ON TABLE entrevc TO nobody;


--
-- Name: entrevc_etv_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE entrevc_etv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE entrevc_etv_id_seq FROM onlop;
GRANT ALL ON SEQUENCE entrevc_etv_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE entrevc_etv_id_seq TO nobody;


ALTER TABLE public.entrevh OWNER TO onlop;

--
-- Name: entrevh_eth_id_seq; Type: SEQUENCE; Schema: public; Owner: onlop
--

CREATE SEQUENCE entrevh_eth_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.entrevh_eth_id_seq OWNER TO onlop;

--
-- Name: entrevh_eth_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: onlop
--

ALTER SEQUENCE entrevh_eth_id_seq OWNED BY entrevh.eth_id;


ALTER TABLE entrevh ALTER COLUMN eth_id SET DEFAULT nextval('entrevh_eth_id_seq'::regclass);


--
-- Name: entrevh; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE entrevh FROM PUBLIC;
REVOKE ALL ON TABLE entrevh FROM onlop;
GRANT ALL ON TABLE entrevh TO onlop;
GRANT ALL ON TABLE entrevh TO nobody;


--
-- Name: entrevh_eth_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE entrevh_eth_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE entrevh_eth_id_seq FROM onlop;
GRANT ALL ON SEQUENCE entrevh_eth_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE entrevh_eth_id_seq TO nobody;


--
-- Name: esclisp; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE esclisp FROM PUBLIC;
REVOKE ALL ON TABLE esclisp FROM onlop;
GRANT ALL ON TABLE esclisp TO onlop;
GRANT ALL ON TABLE esclisp TO nobody;


--
-- Name: eventos; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE eventos FROM PUBLIC;
REVOKE ALL ON TABLE eventos FROM onlop;
GRANT ALL ON TABLE eventos TO onlop;
GRANT ALL ON TABLE eventos TO nobody;


--
-- Name: evindi; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE evindi FROM PUBLIC;
REVOKE ALL ON TABLE evindi FROM onlop;
GRANT ALL ON TABLE evindi TO onlop;
GRANT ALL ON TABLE evindi TO nobody;


--
-- Name: facturacion; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE facturacion FROM PUBLIC;
REVOKE ALL ON TABLE facturacion FROM onlop;
GRANT ALL ON TABLE facturacion TO onlop;
GRANT ALL ON TABLE facturacion TO nobody;


--
-- Name: facturacion_fac_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE facturacion_fac_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE facturacion_fac_id_seq FROM onlop;
GRANT ALL ON SEQUENCE facturacion_fac_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE facturacion_fac_id_seq TO nobody;


--
-- Name: firman; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE firman FROM PUBLIC;
REVOKE ALL ON TABLE firman FROM onlop;
GRANT ALL ON TABLE firman TO onlop;
GRANT ALL ON TABLE firman TO nobody;


--
-- Name: firman_fir_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM onlop;
GRANT ALL ON SEQUENCE firman_fir_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE firman_fir_id_seq TO nobody;


--
-- Name: grupos; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE grupos FROM PUBLIC;
REVOKE ALL ON TABLE grupos FROM onlop;
GRANT ALL ON TABLE grupos TO onlop;
GRANT ALL ON TABLE grupos TO nobody;


--
-- Name: grupos_gpo_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE grupos_gpo_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE grupos_gpo_id_seq FROM onlop;
GRANT ALL ON SEQUENCE grupos_gpo_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE grupos_gpo_id_seq TO nobody;


--
-- Name: impresiones; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE impresiones FROM PUBLIC;
REVOKE ALL ON TABLE impresiones FROM onlop;
GRANT ALL ON TABLE impresiones TO onlop;
GRANT ALL ON TABLE impresiones TO nobody;


--
-- Name: indices; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE indices FROM PUBLIC;
REVOKE ALL ON TABLE indices FROM onlop;
GRANT ALL ON TABLE indices TO onlop;
GRANT ALL ON TABLE indices TO nobody;


--
-- Name: interes; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE interes FROM PUBLIC;
REVOKE ALL ON TABLE interes FROM onlop;
GRANT ALL ON TABLE interes TO onlop;
GRANT ALL ON TABLE interes TO nobody;


--
-- Name: listpre; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE listpre FROM PUBLIC;
REVOKE ALL ON TABLE listpre FROM onlop;
GRANT ALL ON TABLE listpre TO onlop;
GRANT ALL ON TABLE listpre TO nobody;


--
-- Name: listpre_ltp_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE listpre_ltp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE listpre_ltp_id_seq FROM onlop;
GRANT ALL ON SEQUENCE listpre_ltp_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE listpre_ltp_id_seq TO nobody;


--
-- Name: lotes; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE lotes FROM PUBLIC;
REVOKE ALL ON TABLE lotes FROM onlop;
GRANT ALL ON TABLE lotes TO onlop;
GRANT ALL ON TABLE lotes TO nobody;


--
-- Name: lotes_lot_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE lotes_lot_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE lotes_lot_id_seq FROM onlop;
GRANT ALL ON SEQUENCE lotes_lot_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE lotes_lot_id_seq TO nobody;


--
-- Name: manzana; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE manzana FROM PUBLIC;
REVOKE ALL ON TABLE manzana FROM onlop;
GRANT ALL ON TABLE manzana TO onlop;
GRANT ALL ON TABLE manzana TO nobody;


--
-- Name: moneda; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE moneda FROM PUBLIC;
REVOKE ALL ON TABLE moneda FROM onlop;
GRANT ALL ON TABLE moneda TO onlop;
GRANT ALL ON TABLE moneda TO nobody;


--
-- Name: monex; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE monex FROM PUBLIC;
REVOKE ALL ON TABLE monex FROM onlop;
GRANT ALL ON TABLE monex TO onlop;
GRANT ALL ON TABLE monex TO nobody;


--
-- Name: monex_mne_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM onlop;
GRANT ALL ON SEQUENCE monex_mne_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE monex_mne_id_seq TO nobody;


--
-- Name: movsto; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE movsto FROM PUBLIC;
REVOKE ALL ON TABLE movsto FROM onlop;
GRANT ALL ON TABLE movsto TO onlop;
GRANT ALL ON TABLE movsto TO nobody;


--
-- Name: movsto_movs_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM onlop;
GRANT ALL ON SEQUENCE movsto_movs_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE movsto_movs_id_seq TO nobody;


--
-- Name: movstoc; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE movstoc FROM PUBLIC;
REVOKE ALL ON TABLE movstoc FROM onlop;
GRANT ALL ON TABLE movstoc TO onlop;
GRANT ALL ON TABLE movstoc TO nobody;


--
-- Name: movstoc_movc_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE movstoc_movc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movstoc_movc_id_seq FROM onlop;
GRANT ALL ON SEQUENCE movstoc_movc_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE movstoc_movc_id_seq TO nobody;


--
-- Name: movubic; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE movubic FROM PUBLIC;
REVOKE ALL ON TABLE movubic FROM onlop;
GRANT ALL ON TABLE movubic TO onlop;
GRANT ALL ON TABLE movubic TO nobody;


--
-- Name: movubic_mcub_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE movubic_mcub_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movubic_mcub_id_seq FROM onlop;
GRANT ALL ON SEQUENCE movubic_mcub_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE movubic_mcub_id_seq TO nobody;


--
-- Name: noticias; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE noticias FROM PUBLIC;
REVOKE ALL ON TABLE noticias FROM onlop;
GRANT ALL ON TABLE noticias TO onlop;
GRANT ALL ON TABLE noticias TO nobody;


--
-- Name: noticias_not_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE noticias_not_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE noticias_not_id_seq FROM onlop;
GRANT ALL ON SEQUENCE noticias_not_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE noticias_not_id_seq TO nobody;


--
-- Name: operadores; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE operadores FROM PUBLIC;
REVOKE ALL ON TABLE operadores FROM onlop;
GRANT ALL ON TABLE operadores TO onlop;
GRANT ALL ON TABLE operadores TO nobody;


--
-- Name: operadores_operad_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM onlop;
GRANT ALL ON SEQUENCE operadores_operad_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE operadores_operad_id_seq TO nobody;


--
-- Name: pacientes; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE pacientes FROM PUBLIC;
REVOKE ALL ON TABLE pacientes FROM onlop;
GRANT ALL ON TABLE pacientes TO onlop;
GRANT ALL ON TABLE pacientes TO nobody;


--
-- Name: pacientes_pac_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE pacientes_pac_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE pacientes_pac_id_seq FROM onlop;
GRANT ALL ON SEQUENCE pacientes_pac_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE pacientes_pac_id_seq TO nobody;


--
-- Name: pais; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE pais FROM PUBLIC;
REVOKE ALL ON TABLE pais FROM onlop;
GRANT ALL ON TABLE pais TO onlop;
GRANT ALL ON TABLE pais TO nobody;


--
-- Name: palabrasn; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE palabrasn FROM PUBLIC;
REVOKE ALL ON TABLE palabrasn FROM onlop;
GRANT ALL ON TABLE palabrasn TO onlop;


--
-- Name: prove; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE prove FROM PUBLIC;
REVOKE ALL ON TABLE prove FROM onlop;
GRANT ALL ON TABLE prove TO onlop;
GRANT ALL ON TABLE prove TO nobody;


--
-- Name: prove_prov_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM onlop;
GRANT ALL ON SEQUENCE prove_prov_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE prove_prov_id_seq TO nobody;


--
-- Name: provin; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE provin FROM PUBLIC;
REVOKE ALL ON TABLE provin FROM onlop;
GRANT ALL ON TABLE provin TO onlop;
GRANT ALL ON TABLE provin TO nobody;


--
-- Name: provin_pro_codigo_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE provin_pro_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE provin_pro_codigo_seq FROM onlop;
GRANT ALL ON SEQUENCE provin_pro_codigo_seq TO onlop;
GRANT UPDATE ON SEQUENCE provin_pro_codigo_seq TO nobody;


--
-- Name: ptestn_ptn_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE ptestn_ptn_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ptestn_ptn_id_seq FROM onlop;
GRANT ALL ON SEQUENCE ptestn_ptn_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE ptestn_ptn_id_seq TO nobody;


--
-- Name: ptovta; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE ptovta FROM PUBLIC;
REVOKE ALL ON TABLE ptovta FROM onlop;
GRANT ALL ON TABLE ptovta TO onlop;
GRANT ALL ON TABLE ptovta TO nobody;


--
-- Name: ptovta_ptv_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM onlop;
GRANT ALL ON SEQUENCE ptovta_ptv_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE ptovta_ptv_id_seq TO nobody;


--
-- Name: rubros; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE rubros FROM PUBLIC;
REVOKE ALL ON TABLE rubros FROM onlop;
GRANT ALL ON TABLE rubros TO onlop;
GRANT ALL ON TABLE rubros TO nobody;


--
-- Name: rubros_rub_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM onlop;
GRANT ALL ON SEQUENCE rubros_rub_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE rubros_rub_id_seq TO nobody;


--
-- Name: seccion; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE seccion FROM PUBLIC;
REVOKE ALL ON TABLE seccion FROM onlop;
GRANT ALL ON TABLE seccion TO onlop;
GRANT ALL ON TABLE seccion TO nobody;


--
-- Name: stock; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE stock FROM PUBLIC;
REVOKE ALL ON TABLE stock FROM onlop;
GRANT ALL ON TABLE stock TO onlop;
GRANT ALL ON TABLE stock TO nobody;


--
-- Name: stock_stk_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE stock_stk_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE stock_stk_id_seq FROM onlop;
GRANT ALL ON SEQUENCE stock_stk_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE stock_stk_id_seq TO nobody;


--
-- Name: subd; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE subd FROM PUBLIC;
REVOKE ALL ON TABLE subd FROM onlop;
GRANT ALL ON TABLE subd TO onlop;
GRANT ALL ON TABLE subd TO nobody;


--
-- Name: subd_subd_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM onlop;
GRANT ALL ON SEQUENCE subd_subd_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE subd_subd_id_seq TO nobody;


--
-- Name: subrub; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE subrub FROM PUBLIC;
REVOKE ALL ON TABLE subrub FROM onlop;
GRANT ALL ON TABLE subrub TO onlop;
GRANT ALL ON TABLE subrub TO nobody;


--
-- Name: subrub_srb_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE subrub_srb_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subrub_srb_id_seq FROM onlop;
GRANT ALL ON SEQUENCE subrub_srb_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE subrub_srb_id_seq TO nobody;


--
-- Name: subxcomp; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE subxcomp FROM PUBLIC;
REVOKE ALL ON TABLE subxcomp FROM onlop;
GRANT ALL ON TABLE subxcomp TO onlop;
GRANT ALL ON TABLE subxcomp TO nobody;


--
-- Name: sucursal; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE sucursal FROM PUBLIC;
REVOKE ALL ON TABLE sucursal FROM onlop;
GRANT ALL ON TABLE sucursal TO onlop;
GRANT ALL ON TABLE sucursal TO nobody;


--
-- Name: talon; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE talon FROM PUBLIC;
REVOKE ALL ON TABLE talon FROM onlop;
GRANT ALL ON TABLE talon TO onlop;
GRANT ALL ON TABLE talon TO nobody;


--
-- Name: talon_tal_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM onlop;
GRANT ALL ON SEQUENCE talon_tal_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE talon_tal_id_seq TO nobody;


--
-- Name: telefon; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE telefon FROM PUBLIC;
REVOKE ALL ON TABLE telefon FROM onlop;
GRANT ALL ON TABLE telefon TO onlop;
GRANT ALL ON TABLE telefon TO nobody;


--
-- Name: telefon_tel_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM onlop;
GRANT ALL ON SEQUENCE telefon_tel_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE telefon_tel_id_seq TO nobody;


--
-- Name: testn; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE testn FROM PUBLIC;
REVOKE ALL ON TABLE testn FROM onlop;
GRANT ALL ON TABLE testn TO onlop;
GRANT ALL ON TABLE testn TO nobody;


--
-- Name: testn_tn_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE testn_tn_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE testn_tn_id_seq FROM onlop;
GRANT ALL ON SEQUENCE testn_tn_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE testn_tn_id_seq TO nobody;


--
-- Name: tipante; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tipante FROM PUBLIC;
REVOKE ALL ON TABLE tipante FROM onlop;
GRANT ALL ON TABLE tipante TO onlop;
GRANT ALL ON TABLE tipante TO nobody;


--
-- Name: tipcta; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tipcta FROM PUBLIC;
REVOKE ALL ON TABLE tipcta FROM onlop;
GRANT ALL ON TABLE tipcta TO onlop;
GRANT ALL ON TABLE tipcta TO nobody;


--
-- Name: tipcta_tct_codigo_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE tipcta_tct_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipcta_tct_codigo_seq FROM onlop;
GRANT ALL ON SEQUENCE tipcta_tct_codigo_seq TO onlop;
GRANT UPDATE ON SEQUENCE tipcta_tct_codigo_seq TO nobody;


--
-- Name: tipdocu; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tipdocu FROM PUBLIC;
REVOKE ALL ON TABLE tipdocu FROM onlop;
GRANT ALL ON TABLE tipdocu TO onlop;
GRANT ALL ON TABLE tipdocu TO nobody;


--
-- Name: tipemp; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tipemp FROM PUBLIC;
REVOKE ALL ON TABLE tipemp FROM onlop;
GRANT ALL ON TABLE tipemp TO onlop;
GRANT ALL ON TABLE tipemp TO nobody;


--
-- Name: tipentid; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tipentid FROM PUBLIC;
REVOKE ALL ON TABLE tipentid FROM onlop;
GRANT ALL ON TABLE tipentid TO onlop;
GRANT ALL ON TABLE tipentid TO nobody;


--
-- Name: tipentid_tet_codigo_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE tipentid_tet_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tipentid_tet_codigo_seq FROM onlop;
GRANT ALL ON SEQUENCE tipentid_tet_codigo_seq TO onlop;
GRANT UPDATE ON SEQUENCE tipentid_tet_codigo_seq TO nobody;


--
-- Name: tiptel; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tiptel FROM PUBLIC;
REVOKE ALL ON TABLE tiptel FROM onlop;
GRANT ALL ON TABLE tiptel TO onlop;
GRANT ALL ON TABLE tiptel TO nobody;


--
-- Name: tiptel_ttl_codigo_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE tiptel_ttl_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE tiptel_ttl_codigo_seq FROM onlop;
GRANT ALL ON SEQUENCE tiptel_ttl_codigo_seq TO onlop;
GRANT UPDATE ON SEQUENCE tiptel_ttl_codigo_seq TO nobody;


--
-- Name: tmedico; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE tmedico FROM PUBLIC;
REVOKE ALL ON TABLE tmedico FROM onlop;
GRANT ALL ON TABLE tmedico TO onlop;
GRANT ALL ON TABLE tmedico TO nobody;


--
-- Name: trabajo; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE trabajo FROM PUBLIC;
REVOKE ALL ON TABLE trabajo FROM onlop;
GRANT ALL ON TABLE trabajo TO onlop;
GRANT ALL ON TABLE trabajo TO nobody;


--
-- Name: unilot; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE unilot FROM PUBLIC;
REVOKE ALL ON TABLE unilot FROM onlop;
GRANT ALL ON TABLE unilot TO onlop;
GRANT ALL ON TABLE unilot TO nobody;


--
-- Name: unimed; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE unimed FROM PUBLIC;
REVOKE ALL ON TABLE unimed FROM onlop;
GRANT ALL ON TABLE unimed TO onlop;
GRANT ALL ON TABLE unimed TO nobody;


--
-- Name: varamb; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE varamb FROM PUBLIC;
REVOKE ALL ON TABLE varamb FROM onlop;
GRANT ALL ON TABLE varamb TO onlop;
GRANT ALL ON TABLE varamb TO nobody;


--
-- Name: varambi; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE varambi FROM PUBLIC;
REVOKE ALL ON TABLE varambi FROM onlop;
GRANT ALL ON TABLE varambi TO onlop;
GRANT ALL ON TABLE varambi TO nobody;


--
-- Name: vendedor; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE vendedor FROM PUBLIC;
REVOKE ALL ON TABLE vendedor FROM onlop;
GRANT ALL ON TABLE vendedor TO onlop;
GRANT ALL ON TABLE vendedor TO nobody;


--
-- Name: vendedor_ven_id_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE vendedor_ven_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE vendedor_ven_id_seq FROM onlop;
GRANT ALL ON SEQUENCE vendedor_ven_id_seq TO onlop;
GRANT UPDATE ON SEQUENCE vendedor_ven_id_seq TO nobody;


--
-- Name: zona; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON TABLE zona FROM PUBLIC;
REVOKE ALL ON TABLE zona FROM onlop;
GRANT ALL ON TABLE zona TO onlop;
GRANT ALL ON TABLE zona TO nobody;


--
-- Name: zona_zon_codigo_seq; Type: ACL; Schema: public; Owner: onlop
--

REVOKE ALL ON SEQUENCE zona_zon_codigo_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE zona_zon_codigo_seq FROM onlop;
GRANT ALL ON SEQUENCE zona_zon_codigo_seq TO onlop;
GRANT UPDATE ON SEQUENCE zona_zon_codigo_seq TO nobody;


--
-- PostgreSQL database dump complete
--

