/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter.encoders;

import com.fusioncharts.exporter.encoders.Encoder;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageInputStream;

public class BasicEncoder
implements Encoder {
    String defaultFormat = "JPEG";

    public void encode(BufferedImage bufferedImage, FileImageOutputStream fileImageOutputStream) throws Throwable {
        this.encode(bufferedImage, fileImageOutputStream, 1.0f);
    }

    public void encode(BufferedImage bufferedImage, FileImageOutputStream fileImageOutputStream, float quality) throws Throwable {
        this.encode(bufferedImage, fileImageOutputStream, quality, this.defaultFormat);
    }

    public void encode(BufferedImage bufferedImage, FileImageOutputStream fileImageOutputStream, float quality, String format) throws Throwable {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
        ImageWriter writer = writers.next();
        ImageWriteParam iwp = writer.getDefaultWriteParam();
        writer.setOutput(fileImageOutputStream);
        writer.write(null, new IIOImage(bufferedImage, null, null), iwp);
        fileImageOutputStream.close();
    }

    public void encode(BufferedImage bufferedImage, OutputStream outputStream) throws Throwable {
        this.encode(bufferedImage, outputStream, 1.0f);
    }

    public void encode(BufferedImage bufferedImage, OutputStream outputStream, float quality) throws Throwable {
        this.encode(bufferedImage, outputStream, quality, this.defaultFormat);
    }

    public void encode(BufferedImage bufferedImage, OutputStream outputStream, float quality, String format) throws Throwable {
        ImageInputStream ios = null;
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
            ImageWriter writer = writers.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            ios = ImageIO.createImageOutputStream(outputStream);
            writer.setOutput(ios);
            writer.write(null, new IIOImage(bufferedImage, null, null), iwp);
            ios.close();
        }
        catch (IllegalArgumentException e) {
            if (ios != null) {
                ios.close();
            }
            throw new Throwable();
        }
        catch (IOException e) {
            if (ios != null) {
                ios.close();
            }
            throw new Throwable();
        }
    }

    public void encode(BufferedImage bufferedImage, Writer out, float quality, String format) throws Throwable {
        ImageInputStream ios = null;
        try {
            Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName(format);
            ImageWriter writer = writers.next();
            ImageWriteParam iwp = writer.getDefaultWriteParam();
            ios = ImageIO.createImageOutputStream(out);
            writer.setOutput(ios);
            writer.write(null, new IIOImage(bufferedImage, null, null), iwp);
            ios.close();
        }
        catch (IllegalArgumentException e) {
            if (ios != null) {
                ios.close();
            }
            throw new Throwable();
        }
        catch (IOException e) {
            if (ios != null) {
                ios.close();
            }
            throw new Throwable();
        }
    }
}

