/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter.generators;

import com.fusioncharts.exporter.beans.ChartMetadata;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;

public class ImageGenerator {
    private static Logger logger = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.fusioncharts.exporter.generators.ImageGenerator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public static BufferedImage getChartImage(String data, ChartMetadata metadata) {
        logger.info("Creating the Chart image");
        int width = 0;
        int height = 0;
        String bgcolor = "";
        width = metadata.getWidth();
        height = metadata.getHeight();
        if (width == 0 || height == 0) {
            logger.severe("Image width/height not provided.");
        }
        if ((bgcolor = metadata.getBgColor()) == null || bgcolor == "" || bgcolor == null) {
            bgcolor = "FFFFFF";
        }
        Color bgColor = new Color(Integer.parseInt(bgcolor, 16));
        if (data == null) {
            logger.severe("Image Data not supplied.");
        }
        BufferedImage chart = null;
        try {
            String[] rows = new String[height + 1];
            rows = data.split(";");
            chart = new BufferedImage(width, height, 5);
            Graphics2D gr = chart.createGraphics();
            gr.setColor(bgColor);
            gr.fillRect(0, 0, width, height);
            int ri = 0;
            int i = 0;
            while (i < rows.length) {
                String[] pixels = rows[i].split(",");
                ri = 0;
                int j = 0;
                while (j < pixels.length) {
                    String[] clrs = pixels[j].split("_");
                    String c = clrs[0];
                    int r = Integer.parseInt(clrs[1]);
                    if (c != null && c.length() > 0 && c != "") {
                        if (c.length() < 6) {
                            StringBuffer str = new StringBuffer(c);
                            int p = c.length() + 1;
                            while (p <= 6) {
                                str.insert(0, "0");
                                ++p;
                            }
                            c = str.toString();
                        }
                        int k = 1;
                        while (k <= r) {
                            gr.setColor(new Color(Integer.parseInt(c, 16)));
                            gr.fillRect(ri, i, 1, 1);
                            ++ri;
                            ++k;
                        }
                    } else {
                        ri += r;
                    }
                    ++j;
                }
                ++i;
            }
            logger.info("Image created successfully");
        }
        catch (Exception e) {
            logger.severe("Image data is not in proper format:" + e.toString());
        }
        return chart;
    }
}

