/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter.error;

import com.fusioncharts.exporter.beans.ExportConfiguration;
import com.fusioncharts.exporter.beans.LogMessageSetVO;
import com.fusioncharts.exporter.error.LOGMESSAGE;
import com.fusioncharts.exporter.error.Status;
import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;

public class ErrorHandler {
    private static Logger logger = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.fusioncharts.exporter.error.ErrorHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public static String buildResponse(LogMessageSetVO logMessageSetVO, boolean isHTML) {
        String otherMessages;
        Iterator warnIter;
        StringBuffer err_buf = new StringBuffer();
        StringBuffer warn_buf = new StringBuffer();
        String errors = "";
        String notices = "";
        Set errorSet = logMessageSetVO.getErrorsSet();
        Set warningSet = logMessageSetVO.getWarningSet();
        Iterator errorIter = errorSet.iterator();
        if (errorIter != null) {
            while (errorIter.hasNext()) {
                err_buf.append(errorIter.next().toString());
            }
        }
        if ((warnIter = warningSet.iterator()) != null) {
            while (warnIter.hasNext()) {
                err_buf.append(warnIter.next().toString());
            }
        }
        errors = err_buf.length() > 0 ? String.valueOf(isHTML ? "<BR>" : "&") + "statusMessage=" + err_buf.substring(0) + (isHTML ? "<BR>" : "&") + "statusCode=" + Status.FAILURE.getCode() : "statusMessage=" + Status.SUCCESS + "&statusCode=" + Status.SUCCESS.getCode();
        if (warn_buf.length() > 0) {
            notices = String.valueOf(isHTML ? "<BR>" : "&") + "notice=" + warn_buf.substring(0);
        }
        otherMessages = (otherMessages = logMessageSetVO.getOtherMessages()) == null ? "" : otherMessages;
        logger.info("Errors=" + errors);
        logger.info("Notices=" + notices);
        logger.info("Miscellaneous Messages=" + otherMessages);
        return String.valueOf(errors) + notices + otherMessages;
    }

    public static LogMessageSetVO checkServerSaveStatus(String fileName) {
        LogMessageSetVO errorSetVO = new LogMessageSetVO();
        String pathToSaveFolder = ExportConfiguration.SAVEABSOLUTEPATH;
        File saveFolder = new File(pathToSaveFolder);
        if (!saveFolder.exists()) {
            errorSetVO.addError(LOGMESSAGE.E508);
        } else if (!saveFolder.canWrite()) {
            errorSetVO.addError(LOGMESSAGE.E403);
        } else {
            String completeFilePath = String.valueOf(pathToSaveFolder) + File.separator + fileName;
            File saveFile = new File(completeFilePath);
            if (saveFile.exists()) {
                errorSetVO.addWarning(LOGMESSAGE.W509);
                if (ExportConfiguration.OVERWRITEFILE) {
                    errorSetVO.addWarning(LOGMESSAGE.W510);
                    if (!saveFile.canWrite()) {
                        errorSetVO.addError(LOGMESSAGE.E511);
                    }
                } else if (!ExportConfiguration.INTELLIGENTFILENAMING) {
                    errorSetVO.addError(LOGMESSAGE.E512);
                }
            }
        }
        return errorSetVO;
    }

    public static boolean doesServerSaveFolderExist() {
        boolean saveFolderExists = true;
        String pathToSaveFolder = ExportConfiguration.SAVEABSOLUTEPATH;
        File saveFolder = new File(pathToSaveFolder);
        if (!saveFolder.exists()) {
            saveFolderExists = false;
        }
        return saveFolderExists;
    }
}

