/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.jsp.taglib;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FCParameters {
    HashMap<FCParams, String> parameters = new HashMap();

    public static String quote(String string) {
        if (string == null || string.length() == 0) {
            return "\"\"";
        }
        char c = '\u0000';
        int len = string.length();
        StringBuffer sb = new StringBuffer(len + 4);
        sb.append('\"');
        int i = 0;
        while (i < len) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    break;
                }
                case '\b': {
                    sb.append("\\b");
                    break;
                }
                case '\t': {
                    sb.append("\\t");
                    break;
                }
                case '\n': {
                    sb.append("\\n");
                    break;
                }
                case '\f': {
                    sb.append("\\f");
                    break;
                }
                case '\r': {
                    sb.append("\\r");
                    break;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u" + t.substring(t.length() - 4));
                        break;
                    }
                    sb.append(c);
                }
            }
            ++i;
        }
        sb.append('\"');
        return sb.toString();
    }

    public FCParameters() {
    }

    public FCParameters(String swfFilename, String chartId, String width, String height, String debugMode, String registerWithJS, String windowMode, String bgColor, String scaleMode, String lang, String detectFlashVersion, String autoInstallRedirect, String dataSource, String dataFormat, String renderer, String renderAt) {
        this.addParameterValue(FCParams.ID.toString(), chartId);
        this.addParameterValue(FCParams.SWFURL.toString(), swfFilename);
        this.addParameterValue(FCParams.WIDTH.toString(), width);
        this.addParameterValue(FCParams.HEIGHT.toString(), height);
        this.addParameterValue(FCParams.DEBUGMODE.toString(), debugMode);
        this.addParameterValue(FCParams.REGISTERWITHJS.toString(), registerWithJS);
        this.addParameterValue(FCParams.WMODE.toString(), windowMode);
        this.addParameterValue(FCParams.SCALEMODE.toString(), scaleMode);
        this.addParameterValue(FCParams.BGCOLOR.toString(), bgColor);
        this.addParameterValue(FCParams.LANG.toString(), lang);
        this.addParameterValue(FCParams.AUTOINSTALLREDIRECT.toString(), autoInstallRedirect);
        this.addParameterValue(FCParams.DETECTFLASHVERSION.toString(), detectFlashVersion);
        this.addParameterValue(FCParams.RENDERER.toString(), renderer);
        this.addParameterValue(FCParams.RENDERAT.toString(), renderAt);
        this.addParameterValue(FCParams.DATAFORMAT.toString(), dataFormat);
        this.addParameterValue(FCParams.DATASOURCE.toString(), dataSource);
    }

    public boolean addParameterValue(String key, String value) {
        boolean validKey = this.testValidity(key);
        if (validKey && value != null) {
            this.parameters.put(Enum.valueOf(FCParams.class, key), value);
        }
        return validKey;
    }

    public boolean addParameterValues(HashMap<String, String> params) {
        boolean validKey = true;
        Set<String> keySet = params.keySet();
        String key2 = "";
        String value = "";
        for (String key2 : keySet) {
            value = params.get(key2);
            this.addParameterValue(key2, value);
        }
        return validKey;
    }

    public Object remove(String key) {
        return this.parameters.remove(key);
    }

    public boolean testValidity(String key) {
        boolean validParam = true;
        try {
            FCParams FCParams2 = Enum.valueOf(FCParams.class, key);
        }
        catch (IllegalArgumentException ex) {
            validParam = false;
        }
        return validParam;
    }

    public String toJSON() {
        String json_representation = "";
        try {
            Iterator<FCParams> keys = this.parameters.keySet().iterator();
            StringBuffer sb = new StringBuffer("{");
            while (keys.hasNext()) {
                if (sb.length() > 1) {
                    sb.append(',');
                }
                FCParams o = keys.next();
                sb.append(FCParameters.quote(o.getParamName()));
                sb.append(':');
                sb.append(FCParameters.quote(this.parameters.get((Object)o)));
            }
            sb.append('}');
            json_representation = sb.toString();
        }
        catch (Exception e) {
            return null;
        }
        return json_representation;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FCParams {
        SWFURL("swfUrl"),
        WIDTH("width"),
        HEIGHT("height"),
        RENDERAT("renderAt"),
        RENDERER("renderer"),
        DATASOURCE("dataSource"),
        DATAFORMAT("dataFormat"),
        ID("id"),
        LANG("lang"),
        DEBUGMODE("debugMode"),
        REGISTERWITHJS("registerWithJS"),
        DETECTFLASHVERSION("detectFlashVersion"),
        AUTOINSTALLREDIRECT("autoInstallRedirect"),
        WMODE("wMode"),
        SCALEMODE("scaleMode"),
        MENU("menu"),
        BGCOLOR("bgColor"),
        QUALITY("quality");

        String paramName = "";

        private FCParams(String paramName) {
            this.paramName = paramName;
        }

        public String getParamName() {
            return this.paramName;
        }
    }
}

