/*
 * Decompiled with CFR 0.152.
 */
package com.fusioncharts.exporter.resources;

import com.fusioncharts.exporter.ErrorHandler;
import com.fusioncharts.exporter.FusionChartsExportHelper;
import com.fusioncharts.exporter.beans.ChartMetadata;
import com.fusioncharts.exporter.beans.ExportBean;
import com.fusioncharts.exporter.beans.ExportConfiguration;
import com.fusioncharts.exporter.beans.LogMessageSetVO;
import com.fusioncharts.exporter.encoders.BasicEncoder;
import com.fusioncharts.exporter.encoders.JPEGEncoder;
import com.fusioncharts.exporter.generators.ImageGenerator;
import com.fusioncharts.exporter.resources.FCExporter_Format;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.imageio.stream.FileImageOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public class FCExporter_IMG
extends FCExporter_Format {
    private ExportBean exportBean = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String exportOutput(Object exportObj, HttpServletResponse response) {
        String meta_values;
        String noticeMessage;
        boolean isHTML;
        LogMessageSetVO logMessageSetVO;
        block29: {
            String action = (String)this.exportBean.getExportParameterValue("exportaction");
            String exportFormat = (String)this.exportBean.getExportParameterValue("exportformat");
            String exportTargetWindow = (String)this.exportBean.getExportParameterValue("exporttargetwindow");
            String fileNameWithoutExt = (String)this.exportBean.getExportParameterValue("exportfilename");
            String extension = FusionChartsExportHelper.getExtensionFor((String)exportFormat.toLowerCase());
            String fileName = String.valueOf(fileNameWithoutExt) + "." + extension;
            String stream = this.exportBean.getStream();
            logMessageSetVO = new LogMessageSetVO();
            BufferedImage chartImage = (BufferedImage)exportObj;
            isHTML = false;
            if (action.equals("download")) {
                isHTML = true;
            }
            noticeMessage = "";
            meta_values = this.exportBean.getMetadataAsQueryString(null, false, isHTML);
            if (!action.equals("download")) {
                block28: {
                    noticeMessage = "&notice=";
                    String pathToSaveFolder = ExportConfiguration.SAVEABSOLUTEPATH;
                    File saveFolder = new File(pathToSaveFolder);
                    String completeFilePath = String.valueOf(pathToSaveFolder) + File.separator + fileName;
                    String completeFilePathWithoutExt = String.valueOf(pathToSaveFolder) + File.separator + fileNameWithoutExt;
                    File saveFile = new File(completeFilePath);
                    if (saveFile.exists()) {
                        noticeMessage = String.valueOf(noticeMessage) + ErrorHandler.LOGMESSAGE.W509;
                        if (!ExportConfiguration.OVERWRITEFILE && ExportConfiguration.INTELLIGENTFILENAMING) {
                            noticeMessage = String.valueOf(noticeMessage) + ErrorHandler.LOGMESSAGE.W514;
                            completeFilePath = FusionChartsExportHelper.getUniqueFileName((String)completeFilePathWithoutExt, (String)extension);
                            File tempFile = new File(completeFilePath);
                            fileName = tempFile.getName();
                            noticeMessage = String.valueOf(noticeMessage) + ErrorHandler.LOGMESSAGE.W515 + fileName;
                            logMessageSetVO.addWarning(ErrorHandler.LOGMESSAGE.W515);
                        }
                    }
                    String pathToDisplay = String.valueOf(ExportConfiguration.HTTP_URI) + "/" + fileName;
                    if (ExportConfiguration.HTTP_URI.endsWith("/")) {
                        pathToDisplay = String.valueOf(ExportConfiguration.HTTP_URI) + fileName;
                    }
                    meta_values = this.exportBean.getMetadataAsQueryString(pathToDisplay, false, isHTML);
                    try {
                        FileImageOutputStream fios = new FileImageOutputStream(new File(completeFilePath));
                        if (exportFormat.toLowerCase().equalsIgnoreCase("jpg") || exportFormat.toLowerCase().equalsIgnoreCase("jpeg")) {
                            JPEGEncoder jpegEncoder = new JPEGEncoder();
                            try {
                                jpegEncoder.encode(chartImage, fios);
                            }
                            catch (Throwable e) {
                                logMessageSetVO.addError(ErrorHandler.LOGMESSAGE.E516);
                            }
                            chartImage = null;
                            break block28;
                        }
                        BasicEncoder basicEncoder = new BasicEncoder();
                        try {
                            basicEncoder.encode(chartImage, fios, 1.0f, exportFormat.toLowerCase());
                        }
                        catch (Throwable e) {
                            System.out.println(" Unable to encode the buffered image");
                            logMessageSetVO.addError(ErrorHandler.LOGMESSAGE.E516);
                        }
                        chartImage = null;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (logMessageSetVO.getErrorsSet() == null || logMessageSetVO.getErrorsSet().isEmpty()) {
                    try {
                        PrintWriter out = response.getWriter();
                        out.print(String.valueOf(meta_values) + noticeMessage + "&statusCode=" + ErrorHandler.Status.SUCCESS.getCode() + "&statusMessage=" + ErrorHandler.Status.SUCCESS);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                try {
                    response.setContentType(FusionChartsExportHelper.getMimeTypeFor((String)exportFormat.toLowerCase()));
                    ServletOutputStream os = response.getOutputStream();
                    if (exportTargetWindow.equalsIgnoreCase("_self")) {
                        response.addHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                    } else {
                        response.addHeader("Content-Disposition", "inline; filename=\"" + fileName + "\"");
                    }
                    if (exportFormat.toLowerCase().equalsIgnoreCase("jpg") || exportFormat.toLowerCase().equalsIgnoreCase("jpeg")) {
                        JPEGEncoder jpegEncoder = new JPEGEncoder();
                        try {
                            jpegEncoder.encode(chartImage, (OutputStream)os);
                            os.flush();
                        }
                        catch (Throwable e) {
                            System.out.println("Unable to (JPEG) encode the buffered image");
                            logMessageSetVO.addError(ErrorHandler.LOGMESSAGE.E516);
                            meta_values = this.exportBean.getMetadataAsQueryString(null, true, isHTML);
                            response.reset();
                            response.setContentType("text/html");
                            PrintWriter out = response.getWriter();
                            out.print(String.valueOf(meta_values) + noticeMessage + ErrorHandler.buildResponse((LogMessageSetVO)logMessageSetVO, (boolean)isHTML));
                            return null;
                        }
                        chartImage = null;
                        break block29;
                    }
                    BasicEncoder basicEncoder = new BasicEncoder();
                    try {
                        basicEncoder.encode(chartImage, (OutputStream)os, 1.0f, exportFormat.toLowerCase());
                        os.flush();
                    }
                    catch (Throwable e) {
                        System.out.println("Unable to encode the buffered image");
                        logMessageSetVO.addError(ErrorHandler.LOGMESSAGE.E516);
                        meta_values = this.exportBean.getMetadataAsQueryString(null, true, isHTML);
                        response.reset();
                        response.setContentType("text/html");
                        PrintWriter out = response.getWriter();
                        out.print(String.valueOf(meta_values) + noticeMessage + ErrorHandler.buildResponse((LogMessageSetVO)logMessageSetVO, (boolean)isHTML));
                        return null;
                    }
                    chartImage = null;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (logMessageSetVO.getErrorsSet() != null) {
            if (!logMessageSetVO.getErrorsSet().isEmpty()) return "";
        }
        meta_values = this.exportBean.getMetadataAsQueryString(null, true, isHTML);
        try {
            PrintWriter out = response.getWriter();
            out.print(String.valueOf(meta_values) + noticeMessage + "&statusCode=" + ErrorHandler.Status.SUCCESS.getCode() + "&statusMessage=" + ErrorHandler.Status.SUCCESS);
            return "";
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public Object exportProcessor(ExportBean pExportBean) {
        this.exportBean = pExportBean;
        String stream = this.exportBean.getStream();
        ChartMetadata metadata = this.exportBean.getMetadata();
        BufferedImage chartImage = ImageGenerator.getChartImage((String)stream, (ChartMetadata)metadata);
        return chartImage;
    }
}

