            $(document).ready(function() {
                App.datatables();
               /*******************************************************/
                /* https://datatables.net/plug-ins/dataRender/datetime */
                /*******************************************************/
                // UMD
                (function( factory ) {
                    "use strict";
                 
                    if ( typeof define === 'function' && define.amd ) {
                        // AMD
                        define( ['jquery'], function ( $ ) {
                            return factory( $, window, document );
                        } );
                    }
                    else if ( typeof exports === 'object' ) {
                        // CommonJS
                        module.exports = function (root, $) {
                            if ( ! root ) {
                                root = window;
                            }
                 
                            if ( ! $ ) {
                                $ = typeof window !== 'undefined' ?
                                    require('jquery') :
                                    require('jquery')( root );
                            }
                 
                            return factory( $, root, root.document );
                        };
                    }
                    else {
                        // Browser
                        factory( jQuery, window, document );
                    }
                }
                (function( $, window, document ) {
                 
                 
                $.fn.dataTable.render.moment = function ( from, to, locale ) {
                    // Argument shifting
                    if ( arguments.length === 1 ) {
                        locale = 'en';
                        to = from;
                        from = 'YYYY-MM-DD';
                    }
                    else if ( arguments.length === 2 ) {
                        locale = 'en';
                    }
                 
                    return function ( d, type, row ) {
                        var m = window.moment( d, from, locale, true );
                 
                        // Order and type get a number value from Moment, everything else
                        // sees the rendered value
                        return m.format( type === 'sort' || type === 'type' ? 'x' : to );
                    };
                };
                 
                 
                }));

		$.extend( $.fn.dataTable.defaults, {
responsive: true,
autoWidth: false
		} );

                $('.tablabase').DataTable( { 
		    aaSorting: [],
		});


                $('.tablafecha').DataTable( { 
                    order: [[ 1, "desc" ]],
                    columnDefs: [
			{
                          targets: 0,
                          render: $.fn.dataTable.render.moment( 'YYYY-MM-DD', 'DD-MM-YYYY')
                        },
			{
                          targets: 1,
                          visible: false,
                          searchable: false
                        } 

		    ],
		});

                $('.novedad').dataTable( {
                    columnDefs: [ {
                          targets: 0,
                          render: $.fn.dataTable.render.moment( 'YYYY-MM-DD', 'DD-MM-YYYY')
                        } ],
                    order: [[ 0, "desc" ]],
                    "columns": [
                        null,
                        { "width": "15%" },
                        { "width": "65%" },
                        null
                      ]
                } );

                $('.dataTables_filter input').attr('placeholder', 'Buscar...');
            } );

        $(document).ready(function(){

            $(".activar").click(function(){
                div = $(this).parent();
                div = $(div).parent(); 
                fieldset= $(div).siblings();            
                var isDisabled = $(fieldset).is(':disabled');
                if (isDisabled) { 
                    $(fieldset).removeAttr('disabled');
                } else {
                   $(fieldset).attr('disabled',true);
                }
                $('#email').attr('disabled',true);
            });

	    $.fn.datepicker.defaults.format = "dd/mm/yyyy";
	    $.fn.datepicker.defaults.language = "es";


        });


	    $(function() {
		$( "#datepicker" ).datepicker({format: "dd/mm/yyyy"}).on('changeDate', function(){
		    $(this).datepicker('hide');
		});
	    });


