$(document).ready(function() {
  //al pulsar en un campo del calendario
  $('.dia').on('click', function() {

    //obtenemos el número del día
    var num_dia = $(this).find('div').html();
 
    //citas nos da el número de citas para ese día 
    //ejemplo: 1 = solo 1 hora escogida, sobran 10 horas ese día
    var actividad = $(this).find('div').attr('title');
    console.log(actividad);
 
    //obtenemos el día de hoy
//    var hoy = $(this).find('.highlight').html();
 
    //si pulsamos en un cuadro que no es un día mostramos el siguiente mensaje
    if (num_dia == null) 
    {
      new_popup("Por favor, escoge un día disponible.","Error");
      return false;
    }

    //obtenemos el año a través del campo oculto del formulario
    var year = $(".year").val();

    //obtenemos el mes a través del campo oculto del formulario
    var month = $(".month").val();

    var uf = $(".uf").val();

    var csrf = $("#csrf").val();


    //obtenemos el mes a través del campo oculto del formulario
    //y le restamos uno porque en javascript los meses igual que
    //los días empiezan en 0, si es enero debe ser 0 y no 1
    var monthjs = $(".month").val() - 1;

    //anteponemos el 0 si es un sólo número para poder trabajar
    //correctamente la fecha
    if (num_dia.lenght == 1) {
      num_dia = '0' + num_dia;
    }

    //anteponemos el 0 si es un sólo número para poder trabajar
    //correctamente la fecha
    if (month.lenght == 1) {
      month = '0' + month;
    }

    //creamos la fecha sobre la que el usuario ha pulsado
    var fecha = new Date(year, monthjs, num_dia);
 
    //creamos un array con los meses de año para mostrar un mensaje final
    //más útil para el usuario
    var meses = ["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
    var mes_escogido = meses[fecha.getMonth()];
 
    //lo mismo que con el mes, pero con los días de la semana
    var dias_semana = ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"];
    var dia_escogido = dias_semana[fecha.getDay()];


    var el_id = $(this).find('div').attr('id');
    //si no es dia permitido
    if (el_id=="oc_fest") 
    {
      new_popup("El dia seleccionado no admite reservas para la actividad seleccionada.", "Dia no permitido.");
      return false;
    }else if (el_id=="oc_post") {
      new_popup("La actividad no admite reservas para esta fecha.", "Dia no permitido.");
      return false;
    }

 
    //si es un día anterior al día de hoy
    var hoy = new Date();
    hoy.setHours(0,0,0,0);
    if (fecha < hoy) 
    {
      new_popup("Escoja un dia actual.","Dia anterior");
      return false;
    }
    //si es distinto de nulo significa que hemos pulsado en un cuadro
    //del calendario que tiene número
    //si num no es null, significa que el usuario ha picado en un campo del formulario que contiene números dejamos seguir
    if (num_dia != null) {
        year = $('.year').val();
        month = $(".month").val();
        //console.log(num_dia + "-" + month + "-" + year)
        $.ajax({
          type : 'POST',
          url : 'https://sistema.lostroncoscc.com.ar/Reservas/coger_hora',
          data : {
            'num' : num_dia,
            'year' : year,
            'month' : month,
            'dia_escogido' : dia_escogido,
            'mes_escogido' : mes_escogido,
            'actividad' : actividad,
	    'csrf_test_name' : csrf,
            'uf' : uf,
          },
          beforeSend : function() {
 
          },
 
          success : function(data2) {
            if (data2) {
              $("#midiv").dialog({
                modal : true,
//                title : 'Escoge una hora',
		position: { my: "center", at: "top" },
		closeText: 'Cerrar',
                buttons : {
                  "Confirmar Reserva" : {
			click: function(){
                	    if($("#desde_hora").val() == ""){
                		new_popup("Debes seleccionar una hora.", "Error formulario");
                		return;
                	    }
                	    if($("#select_vajilla").val() == "-1"){
                		new_popup("Debes seleccionar si deseas o no vajilla.", "Error formulario");
                		return;
                	    }
                	    $.ajax({
                		url : $('#form_coger_cita').attr("action"),
                		type : 'POST',
                		data : $('#form_coger_cita').serialize(),
                		beforeSend : function() {
                		},
                		success : function(data3) {
                		    $("#midiv").dialog('close');
				    new_popup_fin("<h5> Usted ha reservado la actividad, la fecha sera: " + data3 + ". </h5>", "Actividad reservada");
                		},
                		error : function() {
                		    $('.formulario_citas').html("<div>Ha ocurrido un error, intentelo de nuevo más tarde.</div>");
                		}
                	    });
                	    return false;
            		},
			class: 'btn btn-primary',
			text: 'Confirmar Reserva'
		    },
		  "Cerrar" : {
			click: function() {
                	    $(this).dialog('close');
            		},
			class: 'btn btn-primary',
			text: 'Cerrar'
		    }
                },
              });
              $('#midiv').html(data2);
            }
          },
          error : function() {
            alert('Ha habido un error, inténtalo de nuevo más tarde');
          }
        });
        return false;
    }
 
  })
}); 


//mostramos un popup con un error personalizado pasando el mensaje y el título 
//que queremos mostrar, al ser una cosa demasiado repetitiva mejor escribirla una
//vez y llamarla las veces necesarias
function new_popup(message, titulo)
{
  $("#sms").empty();
  $("#sms").dialog({
    title : titulo,
    height : 260,
    width : 350,
    modal : true,
    buttons : {
      "Aceptar" : function() {
        $(this).dialog('close');
      }
    }
  });
  $("#sms").html(message);
}


function new_popup_fin(message, titulo)
{

    $("#sms").empty();
    $("#sms").dialog({
	title : titulo,
	height : 260,
	width : 350,
	modal : true,
	buttons : {
	    "Aceptar" : function() {
		$(this).dialog('close');
	    }
	},
	close : function() {
	    $("#form_volver").submit();
	}
     });
    $("#sms").html(message);
}


