CREATE TABLE invitados (
  i_id serial,
  i_nombre text,
  i_dia date default now()::date,
  i_hora time default now()::time,
  i_fecreg timestamp without time zone default now(),
  i_edad integer,
  i_cupon integer,
  i_iduser integer,
  i_estado INTEGER NOT NULL DEFAULT 1
);


ALTER TABLE public.invitados OWNER TO zona;

ALTER TABLE ONLY invitados
    ADD CONSTRAINT invitados_pkey PRIMARY KEY (i_id);

REVOKE ALL ON TABLE invitados FROM PUBLIC;
REVOKE ALL ON TABLE invitados FROM zona;
GRANT ALL ON TABLE invitados TO zona;
GRANT ALL ON TABLE invitados TO nobody;

REVOKE ALL ON TABLE invitados_i_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE invitados_i_id_seq FROM zona;
GRANT ALL ON TABLE invitados_i_id_seq TO zona;
GRANT UPDATE ON TABLE invitados_i_id_seq TO nobody;



CREATE TABLE cupos (
  c_id serial,
  c_iduser integer,
  c_canti integer,
  c_edad integer,
  c_estado INTEGER NOT NULL DEFAULT 1
);


ALTER TABLE public.cupos OWNER TO zona;

ALTER TABLE ONLY cupos
    ADD CONSTRAINT cupos_pkey PRIMARY KEY (c_id);

REVOKE ALL ON TABLE cupos FROM PUBLIC;
REVOKE ALL ON TABLE cupos FROM zona;
GRANT ALL ON TABLE cupos TO zona;
GRANT ALL ON TABLE cupos TO nobody;

REVOKE ALL ON TABLE cupos_c_id_seq FROM PUBLIC;
REVOKE ALL ON TABLE cupos_c_id_seq FROM zona;
GRANT ALL ON TABLE cupos_c_id_seq TO zona;
GRANT UPDATE ON TABLE cupos_c_id_seq TO nobody;


