<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Llave_model extends CI_Model
{

	function puedoLlave($barrio){
		$this->db->where('l_estado', 1);
		$this->db->where('l_idptov', $barrio);
		$q=$this->db->get('llave');
		if($q->num_rows() >0){
		    return 1;
		}else{
		    return NULL;
		}
	}

	function get_llaves($iduser){


		$this->db->where('l_estado !=', 999);
		$this->db->where('l_iduser', $iduser);
		$this->db->order_by('l_dia','DESC');
		$q=$this->db->get('llave');
		return $q;
	}

	function get_cuponeras_mes($mes,$anio ){
		$this->db->select('*');
		$this->db->select('cast(c_fecreg::date as date) AS fecreg');
		$this->db->where('c_estado', 1);
		$this->db->where("date_part('month',c_fecreg::date)", $mes);
		$this->db->where("date_part('year',c_fecreg::date)", $anio);
		$this->db->order_by('c_iduser','ASC');
		$this->db->order_by('c_fecreg','ASC');
		$q=$this->db->get('cupos');
		return $q;
	}

	function get_cupos($user,$edad){
	    $cupos=$this->get_cuponeras($user,$edad);
	    $inv=$this->get_invitados_cupon($user,$edad);

	    if($cupos>0 && $inv>0){
		$cupos=$cupos-$inv;
	    }
	    return $cupos;
	}

	function get_cuponeras($user,$edad){
		$this->db->select_sum('c_canti');
		$this->db->where('c_estado', 1);
		$this->db->where('c_edad', $edad);
		$this->db->where('c_iduser', $user);
		$q=$this->db->get('cupos');
		if($q->num_rows() >0){
		    $q=$q->row();
		    return $q->c_canti;
		}else{
		    return 0;
		}
	}

	function get_invitados_cupon($user,$edad){
		$this->db->select_sum('i_cupon');
		$this->db->where('i_estado', 1);
		$this->db->where('i_desconto', $edad);
		$this->db->where('i_iduser', $user);
		$this->db->where('i_cupon', 1);
		$q=$this->db->get('invitados');
		if($q->num_rows() >0){
		    $q=$q->row();
		    return $q->i_cupon;
		}else{
		    return 0;
		}
	}



}
