<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Director_model extends CI_Model
{


	function getBarrio(){
		return 42;
	}

	function get_procedext($id){
		$this->db->select('ae_nombre');
		$this->db->where('ae_id', $id);
		$q=$this->db->get('procedext');
		$q=$q->row();
		$id=$q->ae_nombre;
		return $id;
	}

	function get_proced(){
		$q=$this->db->get('procedext');
		$q=$q->result();
		return $q;
	}



	function get_gruposActivi($barrio, $id = NULL){
		$this->db->where('ga_estado', 1);
		$this->db->where('ga_idptov', $barrio);
		$this->db->order_by('ga_id');

		if($id) $this->db->where('ga_id', $id);

		$q=$this->db->get('gruposactivi');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}

	function get_profes($barrio,$mail = NULL){
		$this->db->where('pf_estado', 1);
		$this->db->where('pf_idptov', $barrio);

		if($mail) $this->db->where('pf_mail', $mail);

		$q=$this->db->get('profesores');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}

	function get_profe($id){
		$this->db->where('pf_id', $id);

		$q=$this->db->get('profesores');
		if($q->num_rows() >0){
			$q=$q->row();
			return $q;
		}else{
			return false;
		}

	}


	function profes_por_grupo($grupo,$profe = NULL){
		$this->db->distinct();
		$this->db->select('profesores.*');
		$this->db->join('profesores','profesores.pf_id = pfxgpo.pg_idprofe');
		$this->db->where('pg_estado', 1);
		$this->db->where('pg_idgrupo', $grupo);
		if($profe) $this->db->where('pg_idprofe', $profe);
		$q=$this->db->get('pfxgpo');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}


	function alumnos_por_grupo($grupo,$alumnos = NULL){
		$this->db->distinct();
		$this->db->select('alumnos.*');
		$this->db->join('alumnos','alumnos.al_id = aluxgpo.ag_idalumno');
		$this->db->where('ag_estado', 1);
		$this->db->where('ag_idgrupo', $grupo);
		if($alumnos) $this->db->where('ag_idalumno', $alumnos);
		$q=$this->db->get('aluxgpo');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}

	function tipo_grupo($id){
		$this->db->select('ga_tipo');
		$this->db->where('ga_id', $id);
		$q=$this->db->get('gruposactivi');
		$q=$q->row();
		$id=$q->ga_tipo;
		return $id;
	}


	function get_mail($cop_id){
		$q="select string_agg(tel_dato::text,';') as telmail from telefon where tel_codigo=$cop_id and tel_tipent=99 and tel_tiptel=5;";
		$q=$this->db->query($q);
		$q=$q->row();
		return $q->telmail;
	}

	function get_dato_tabla($tabla,$busco,$nid,$id){
		$this->db->select($busco);
		$this->db->where($nid, $id);
		$q=$this->db->get($tabla);
		$q=$q->row();
		$id=$q->$busco;
		return $id;
	}



	function get_mails_grupo($grupo){
		$tipo_grupo=$this->tipo_grupo($grupo);
		$mails=array();
		if($tipo_grupo==1){
		    $this->db->distinct();
		    $this->db->select('alumnos.*');
		    $this->db->join('alumnos','alumnos.al_id = aluxgpo.ag_idalumno');
		    $this->db->where('ag_estado', 1);
		    $this->db->where('ag_idgrupo', $grupo);
		    $q=$this->db->get('aluxgpo');
		    if($q->num_rows() >0){
			$q=$q->result();
			foreach($q as $alumno){
			    $gfd=$alumno->al_idgfd;
			    $gfi=$alumno->al_idgfi;
			    $gfe=$alumno->al_ext;
			    $cop_id=NULL;

			    if(isset($gfd) && $gfd>0){
				$cop_id=$this->get_dato_tabla('grupof_d','gf_idcopr','gf_id',$gfd);
			    }else if(isset($gfi) && $gfi>0){
				$cop_id=$this->get_dato_tabla('grupof_inq','gf_idcopr','gf_id',$gfi);
			    }else if(isset($gfe) && $gfe>0){
				$mailp=$this->get_dato_tabla('alexternos','ae_mailp','ae_id',$gfe);
				$mailm=$this->get_dato_tabla('alexternos','ae_mailm','ae_id',$gfe);
				if(isset($mailp)) $mails[]=$mailp;
				if(isset($mailm)) $mails[]=$mailm;
			    }

			    if(isset($cop_id) && $cop_id>0){
				$mailcop=$this->get_mail($cop_id);
				if(isset($mailcop)){
				    $mailcop=explode(';',$mailcop);
				    foreach($mailcop as $mm){
					$mails[]=trim($mm);
				    }
				}
			    }

			}
		    }

		    $q=$this->getSuscr($grupo);
		    if($q){
			foreach($q as $alumno){
			    $usr=$alumno->sg_iduser;
			    $cops=$this->Sec_model->cop_id($usr);
			    foreach($cops as $cp){
				$cop_id=$cp->ufd;
				if(isset($cop_id) && $cop_id>0){
				    $mailcop=$this->get_mail($cop_id);
				    if(isset($mailcop)){
					$mailcop=explode(';',$mailcop);
					foreach($mailcop as $mm){
					    $mails[]=trim($mm);
					}
				    }
				}
			    }
			}
		    }


		    if($mails){
			$mails=array_unique($mails);
			return $mails;
		    }else{
			return false;
		    }
		}else{
		    $barrio=$this->Sec_model->getBarrio();
		    $coprops=$this->Sec_model->unidades_barrio($barrio);
		    foreach($coprops as $cop){
			$cop_id=$cop->cop_id;
			if(isset($cop_id) && $cop_id>0){
			    $mailcop=$this->get_mail($cop_id);
			    if(isset($mailcop)){
				$mailcop=explode(';',$mailcop);
				foreach($mailcop as $mm){
				    $mails[]=trim($mm);
				}
			    }
			}
		    }
		    $mails=array_unique($mails);
		    return $mails;
		}

	}




	function asistencia_por_grupo($activi,$asist = NULL){
		$this->db->distinct();
		$this->db->select('alumnos.*');
		$this->db->join('alumnos','alumnos.al_id = asistxactivi.aa_idalu');
		$this->db->join('activi','activi.ac_id = asistxactivi.aa_idact');
		$this->db->where('aa_estado', 1);
		$this->db->where('ac_id', $activi);
		$this->db->where('ac_estado', 1);
		if($asist) $this->db->where('aa_asistio', $asist);
		$q=$this->db->get('asistxactivi');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}


	function asistencia_por_alumno($activi,$alumno){
		$this->db->select('aa_asistio');
		$this->db->where('aa_estado', 1);
		$this->db->where('aa_idact', $activi);
		$this->db->where('aa_idalu', $alumno);
		$q=$this->db->get('asistxactivi');
		if($q->num_rows() >0){
			$q=$q->row();
			return $q->aa_asistio;
		}else{
			return -1;
		}

	}





	function asistentes_faltantes($activi){
		$this->db->distinct();
		$this->db->select('alumnos.*');
		$this->db->join('alumnos','alumnos.al_id = aluxgpo.ag_idalumno');
		$this->db->join('activi','activi.ac_idgpo = aluxgpo.ag_idgrupo');
		$this->db->where('ag_estado', 1);
		$this->db->where('ac_id', $activi);
		$this->db->where('ac_estado', 1);
		$q=$this->db->get('aluxgpo');
		if($q->num_rows() >0){
		    $q=$q->result();
		    $faltantes=array();
		    foreach($q as $alumno){

			$this->db->select('alumnos.*');
			$this->db->join('alumnos','alumnos.al_id = asistxactivi.aa_idalu');
			$this->db->join('activi','activi.ac_id = asistxactivi.aa_idact');
			$this->db->where('aa_estado', 1);
			$this->db->where('ac_id', $activi);
			$this->db->where('ac_estado', 1);
			$this->db->where_in('aa_asistio', array(1,2));
			$this->db->where('aa_idalu', $alumno->al_id);
			$q2=$this->db->get('asistxactivi');
			if($q2->num_rows() >0){
			    $q2=$q2->row();
			}else{
			    $faltantes[]=$alumno;
			}
		    }

		    return $faltantes;
		}else{
			return false;
		}

	}






	function dato_alumno($tabla,$dato,$nomid,$id){
		$this->db->select($dato);
		$this->db->where($nomid, $id);
		$q=$this->db->get($tabla);
		if($q->num_rows() >0){
			$q=$q->row();
			return $q;
		}else{
			return false;
		}

	}

	function get_alumno($idptov, $tabla = NULL,$id = NULL){
		if($tabla && $id){
		    if($tabla=="grupof_d") $this->db->where('al_idgfd', $id);
		    else if($tabla=="grupof_inq") $this->db->where('al_idgfi', $id);
		    else if($tabla=="alexternos") $this->db->where('al_ext', $id);
		}
		$this->db->where('al_idptov', $idptov);
		$q=$this->db->get('alumnos');
		if($q->num_rows() >0){
			$q=$q->row();
			return $q;
		}else{
			return false;
		}

	}

	function get_alumnos($idptov){
		$this->db->where('al_idptov', $idptov);
		$this->db->where('al_estado', 1);
		$this->db->order_by('al_id');
		$q=$this->db->get('alumnos');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}


	function get_alumno_externo($barrio,$nrodoc){
		$this->db->where('ae_idptov', $barrio);
		$this->db->where('ae_nrodoc', $nrodoc);
		$q=$this->db->get('alexternos');
		if($q->num_rows() >0){
			$q=$q->row();
			return $q;
		}else{
			return false;
		}

	}

	function get_alumno_externo_id($id){
		$this->db->where('ae_id', $id);
		$q=$this->db->get('alexternos');
		if($q->num_rows() >0){
			$q=$q->row();
			return $q;
		}else{
			return false;
		}

	}


	function get_suscripciones($id){
		$this->db->where('sg_iduser', $id);
		$this->db->where('sg_estado', 1);
		$this->db->join('gruposactivi','gruposactivi.ga_id = suscrgpo.sg_idgpo');
		$q=$this->db->get('suscrgpo');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return NULL;
		}

	}


	function tengoSuscr($gpo,$id){
		$this->db->where('sg_iduser', $id);
		$this->db->where('sg_idgpo', $gpo);
		$this->db->where('sg_estado', 1);
		$q=$this->db->get('suscrgpo');
		if($q->num_rows() >0){
			return 1;
		}else{
			return NULL;
		}

	}

	function getSuscr($gpo){
		$this->db->where('sg_idgpo', $gpo);
		$this->db->where('sg_estado', 1);
		$q=$this->db->get('suscrgpo');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return NULL;
		}

	}




	function get_alumno_id($id){
		$this->db->where('al_id', $id);
		$q=$this->db->get('alumnos');
		if($q->num_rows() >0){
			$q=$q->row();
			return $q;
		}else{
			return false;
		}

	}




	function get_alumnos_externos($barrio){
		$this->db->where('ae_estado', 1);
		$this->db->where('ae_idptov', $barrio);
		$q=$this->db->get('alexternos');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}







	function get_gf($term,$idptov){
		$resultado=array();
		$q="select *,'grupof_d' as tabla,codcop(gf_idcopr) as uf from grupof_d where gf_id in (select al_idgfd from alumnos where al_estado=1 and al_idptov=$idptov) and (gf_nrodoc='$term' or gf_nombre ilike '%$term%' or codcop(gf_idcopr)::text ilike '$term') order by gf_nombre;";
		$q=$this->db->query($q);
		if($q) $resultado=$q->result();

		$q1="select *,'grupof_inq' as tabla,codcop(gf_idcopr) as uf from grupof_inq where gf_id in (select al_idgfi from alumnos where al_estado=1 and al_idptov=$idptov) and (gf_nrodoc='$term' or gf_nombre ilike '%$term%' or codcop(gf_idcopr)::text ilike '$term') order by gf_nombre;";
		$q1=$this->db->query($q1);
		if($q1){
		    $res=$q1->result();
		    foreach($res as $r){
			$resultado[]=$r;
		    }
		}


		if($resultado) return $resultado;
		else return false;
	}


	function get_ext($term,$idptov){
		$resultado=array();
		$q="select *,'alexternos' as tabla,(case when ae_invitadopor is not null then codcop(ae_invitadopor)::text else 'Externo'::text end) as uf from alexternos where ae_estado=1 and ae_idptov=$idptov and (ae_nrodoc='$term' or ae_nombre ilike '%$term%' or (ae_invitadopor is not null and codcop(ae_invitadopor)::text ilike '$term')) order by ae_nombre;";
		$q=$this->db->query($q);
		if($q) $resultado=$q->result();

		if($resultado) return $resultado;
		else return false;
	}

	function get_edad($fn){
		$q="select extract(year from age('$fn'::date)) as edad;";
		$q=$this->db->query($q);
		if($q) $resultado=$q->result();

		if($resultado) return $resultado[0]->edad;
		else return false;
	}



	function cargoalumnos($idptov){
		$q="select cargoalumnos($idptov);";
		$q=$this->db->query($q);
		return true;
	}


	function delAlumnosAusentes($id){
		$q="delete from asistxactivi where aa_idact=$id and aa_asistio=2 and aa_estado=1;";
		$q=$this->db->query($q);
		return true;
	}




	function delAsistenciaGrupo($idGrupo,$idAlumno){
		$q="delete from asistxactivi where aa_idact in (select ac_id from activi where ac_idgpo=$idGrupo and ac_fecha>=now()::date and ac_estado=1) and aa_idalu=$idAlumno and aa_estado=1;";
		$q=$this->db->query($q);
		return true;
	}






	function get_activi($barrio,$id = NULL){
		$this->db->join('gruposactivi','activi.ac_idgpo = gruposactivi.ga_id');
		$this->db->where('ac_estado', 1);
		$this->db->where('ac_idptov', $barrio);
		if($id) $this->db->where('ac_id', $id);
		$q=$this->db->order_by('ac_fecha','desc');
		$q=$this->db->order_by('ac_hora','desc');
		$q=$this->db->get('activi');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}



	function hayActivi($grupo,$fecha){
		$barrio=$this->Sec_model->getBarrio();
		$this->db->where('ac_estado', 1);
		$this->db->where('ac_fecha', $fecha);
		$this->db->where('ac_idgpo', $grupo);
		$this->db->where('ac_idptov', $barrio);
		$q=$this->db->order_by('ac_fecha','desc');
		$q=$this->db->order_by('ac_hora','desc');
		$q=$this->db->get('activi');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return -1;
		}

	}





	function get_activi_1s($barrio,$id = NULL){
		$hoy=strtotime(date("d-m-Y"));
		$hasta=date("d-m-Y",strtotime('+7 days',$hoy));

		$this->db->join('gruposactivi','activi.ac_idgpo = gruposactivi.ga_id');
		$this->db->where('ac_estado', 1);
		$this->db->where('ac_fecha <=', $hasta);
		$this->db->where('ac_idptov', $barrio);
		if($id) $this->db->where('ac_id', $id);
		$q=$this->db->order_by('ac_fecha','desc');
		$q=$this->db->order_by('ac_hora','desc');
		$q=$this->db->get('activi');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}

	function get_activi_0s($barrio,$id = NULL){
		$hoy=date("d-m-Y");

		$this->db->join('gruposactivi','activi.ac_idgpo = gruposactivi.ga_id');
		$this->db->where('ac_estado', 1);
		$this->db->where('ac_fecha <=', $hoy);
		$this->db->where('ac_idptov', $barrio);
		if($id) $this->db->where('ac_id', $id);
		$q=$this->db->order_by('ac_fecha','desc');
		$q=$this->db->order_by('ac_hora','desc');
		$q=$this->db->get('activi');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}



    function dirit() {
	$dir = "assets/bcoimg/";
	return $dir;
    }

    function dirgr() {
	$dir = base_url() . "uploads/crimg/";
	return $dir;
    }

    function iterate() {
        $this->load->helper('directory');
	$dir=$this->dirit();
        $map = directory_map('./'.$dir, 1);
        return $map;
    }


}
