<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
class Calendario_model extends CI_Model
{
 
    /**
     *cogemos los datos de la tabla calendario y la colocamos en cada día añadiendo una clase
     *del calendario
     * @access public
     * @param $month - int número de mes
     * @param $year - int número de año
     * @return array - información del estado de cada día del mes para pintar el calendario
     */
    function get_calendar_data($year, $month, $actividad) {
 
	$primerDia="01-$month-$year";
	$qLastDay="select ('$primerDia'::date + interval '1 month' - interval '1 day')::date as lastDay;";
	$rLastDay=$this->db->query($qLastDay);
	$ultimoDia=$rLastDay->row()->lastday;
	$this->db->where("fecha BETWEEN '$primerDia'::date and '$ultimoDia'::date");
	$this->db->where('actividad', $actividad);
	$query=$this->db->get('calendario');
        $cal_data = array();
 
        foreach ($query->result() as $row) {
 
            $index = ltrim(substr($row->fecha, 0, 2), '0');
            $cal_data[$index] = $row->estado;
            $cal_data[$index].= "act".$actividad;
 
        }
        return $cal_data;
 
    }
 
     /**
     *hacemos que el usuario pueda coger hora a través del calendario con varios intervalos de horas
     * @access public
     * @param $dia_calendario - string fecha pulsada en el calendario formato 2013/09/01
     * @param $month - string número de mes
     * @param $year - int número de año
     * @return html - calendario con la información de la base de datos
     */
    public function generar_calendario($year, $month, $actividad) {
 
        $conf_calendar = array('show_next_prev' => FALSE, 'next_prev_url' => 'http://sistema.lostroncoscc.com.ar/Reservas/buscoReserva', 'start_day' => 'lunes', 'template' => '  
                                      
               {table_open}<table border="0" cellpadding="0" cellspacing="0" class="table calendario">{/table_open}
 
               {heading_row_start}<tr id="head_links">{/heading_row_start}
            
               {heading_previous_cell}<th class="previo"><a href="{previous_url}"><</a></th>{/heading_previous_cell}
               {heading_title_cell}<th class="fecha_actual" colspan="{colspan}">{heading}</th>{/heading_title_cell}
               {heading_next_cell}<th class="siguiente"><a href="{next_url}">></a></th>{/heading_next_cell} 
            
               {heading_row_end}</tr>{/heading_row_end}
               
               {week_row_start}<tr>{/week_row_start}
               {week_day_cell}<td class="dias_semana">{week_day}</td>{/week_day_cell}
               {week_row_end}</tr>{/week_row_end}
               
               {cal_row_start}<tr>{/cal_row_start}
               {cal_cell_start}<td class="dia">{/cal_cell_start}   
            
               {cal_cell_content}<div id=oc_{content} class="otro_dia {content}" title="{actividad}">{day}</div>{/cal_cell_content}
               {cal_cell_content_today}<div id="oc_{content}" class="highlight" title="{actividad}">{day}</div>{/cal_cell_content_today}
                   
               {cal_cell_no_content}<div class="highlight" title="{actividad}">{day}</div>{/cal_cell_no_content}
               {cal_cell_no_content_today}<div id="oc_{content}" class="highlight" title="{actividad}">{day}</div>{/cal_cell_no_content_today}
                   
               {cal_cell_blank}<br><br>{/cal_cell_blank}
                   
               {cal_cell_end}</td>{/cal_cell_end}
               {cal_row_end}</tr>{/cal_row_end}
            
               {table_close}</table>{/table_close}             
        ');
 
        $this->load->library('calendar', $conf_calendar);
 
        $calendar_data = $this->get_calendar_data($year, $month, $actividad);
 
        return $this->calendar->generate($year, $month, $calendar_data);
 
    }
 
  
     /**
     * @access public
     * @param $month - int número de mes
     * @param $year - int número de año
     * @return array - total días del mes
     */
    public function get_total_days($month, $year) 
    {
        //array con los días de cada mes del año
        $days_in_month = array(31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
 
        //si no es un mes salimos de la función
        if ($month < 1 OR $month > 12) 
        {
            return;
        }
 
        //Si es febrero y es año bisiesto tiene 29 días
        if ($month == 2) 
        {
            if ($year % 400 == 0 OR ($year % 4 == 0 AND $year % 100 != 0)) 
            {
                return 29;
            }
        }
        //devolvemos un array con los días del mes
        return $days_in_month[$month - 1];
    }


    public function get_diff_days($fecha1,$fecha2){

	$fecha1 = strtotime($fecha1);
	$fecha2 = strtotime($fecha2);
	$datediff = $fecha2 - $fecha1;
	return floor($datediff / (60 * 60 * 24));
    }

 
    /**
     *al situarnos en un mes comprobamos si existen los datos de ese mes en la base de datos
     *si no existen los introducimos, en otro caso no hacemos nada
     * @access public
     * @param $month - int número de mes
     * @param $year - int número de año
     */
    public function insert_calendario($month, $year, $actividad) 
    {
 
        $dias_total_mes = $this -> get_total_days($month, $year);

	$primerDia="01-$month-$year";
	$qLastDay="select ('$primerDia'::date + interval '1 month' - interval '1 day')::date as lastDay;";
	$rLastDay=$this->db->query($qLastDay);
	$ultimoDia=$rLastDay->row()->lastday;
	$this->db->where("fecha BETWEEN '$primerDia'::date and '$ultimoDia'::date");
	$this->db->where('actividad',$actividad);
//        $this->db->like('fecha', "$month-$year", 'before');
        $query = $this->db->get('calendario');

	$this->db->where('am_id', $actividad);
	$rAmenity=$this->db->get('amenity');
	$rAmenity=$rAmenity->row();
	$maxDias=$rAmenity->am_maxdias;


	$this->db->where('dxa_idam', $actividad);
	$rDiasxam=$this->db->get('diasxam');
	$dias=array();
	if($rDiasxam->num_rows()>0){
	    $fDiasxam=$rDiasxam->result();
	    foreach($fDiasxam as $fila){
		$elDia=$fila->dxa_nrodia;
		$dias[]=$elDia;
	    }
	}

        if ($query -> num_rows() == 0) 
        {
            for ($i = 1; $i <= $dias_total_mes; $i++) 
            {

                //obtenemos cada uno de los días del mes
                $weekDay = date('w', strtotime(date($year . "-" . $month . "-" . $i)));
                //comprobamos si es saábado o domingo

                //comprobamos si es una fecha anterior a la actual
                if ($month == date('m') && $i < date('d')) 
                {
 
                    $data[$i] = array('fecha' => $year . "-" . $month . "-" . $i, 'comentario' => '', 'estado' => 'ant', 'actividad' => $actividad);
 
                } 
                //días posteriores al día actual
                else if ($month < date('m') && $year <= date('Y')) 
                {
 
                    $data[$i] = array('fecha' => $year . "-" . $month . "-" . $i, 'comentario' => '', 'estado' => 'ant', 'actividad' => $actividad);
 
                } 
                else if (!in_array($weekDay,$dias)) 
                {
 
                    $data[$i] = array('fecha' => $year . "-" . $month . "-" . $i, 'comentario' => '', 'estado' => 'fest', 'actividad' => $actividad);
 
                } 
                else if ($this->get_diff_days(date("d-m-Y"),"$i-$month-$year") > $maxDias) 
                {
 
                    $data[$i] = array('fecha' => $year . "-" . $month . "-" . $i, 'comentario' => '', 'estado' => 'post', 'actividad' => $actividad);
 
                } 
                else 
                {
 
                    $data[$i] = array('fecha' => $year . "-" . $month . "-" . $i, 'comentario' => '', 'estado' => '', 'actividad' => $actividad);
 
                }
 
                //insertamos los días del mes en la base de datos
                $this->db->insert('calendario', $data[$i]);
 
            }
        }
    }
 
    /**
     *al pulsar en cualquier fecha del calendario comprobamos si existe en la tabla citas
     *si no existe creamos las horas para esa fecha en la tabla citas
     * @access public
     * @param $day - int número de dia
     * @param $month - int número de mes
     * @param $year - int número de año
     */
    public function insert_horas($year, $month, $day) 
    {
        $this->db->where('fecha', $day . "-" . $month . "-" . $year);
        $get_calendar = $this->db->get('calendario');
 
        $this->db->where('dia_calendario', $day . "-" . $month . "-" . $year);
        $query = $this->db->get('citas');
        if ($query->num_rows() < 10) {
            //i es desde la hora que queremos empezar a dar horas y 21 una hora antes
            //este ejemplo es de las 10 de la mañana a las 8 de la tarde, modificalo a tus necesidades
            for ($i = 10; $i < 21; $i++) 
            {
 
                $data[$i] = array(
                    'dia_calendario' => $year . "-" . $month . "-" . $day, 'hora_cita' => $i . ':00:00', 
                    'comentario_cita' => '', 
                    'estado' => 'libre'
                );
 
                $this->db->insert('citas', $data[$i]);
            }
        }
    }
 
    /**
     *comprobamos si hay horas disponibles para ese día en concreto
     * @access public
     * @param $day - int número de dia
     * @param $month - int número de mes
     * @param $year - int número de año
     */
    public function horas_seleccionadas($year, $month, $day, $actividad) 
    {
 
	$loQueDevuelvo=array();
        $this->db->where('am_id', $actividad);
        $qAmenity = $this->db->get('amenity');
        if ($qAmenity -> num_rows() > 0) {
	    $am=$qAmenity->row();
	    $comienzo=$am->am_comienzo;
	    $fin=$am->am_fin;
	    $duracion=$am->am_duracion;
	    $termino=1;
	    $estaHora=$comienzo;

	    if($day) $day=str_pad($day,2,'0',STR_PAD_LEFT);

	    $fechaPasada="$day-$month-$year";
	    $fechaHoy=date("d-m-Y");
	    $queHora=date("H:i");
	    $qLastDay1="select ('$queHora'::time)::time as lastDay;";
	    $rLastDay1=$this->db->query($qLastDay1);
	    $queHora=$rLastDay1->row()->lastday;

	    while($termino==1){
    		$this->db->where('evt_fecha', $day . "-" . $month . "-" . $year);
    		$this->db->where('evt_idamenity', $actividad);
    		$this->db->where('evt_horad', $estaHora);
    		$this->db->where('evt_estado', 2);
    		$query = $this->db->get('eventos');
    		if ($query -> num_rows() > 0){
		    $evt=$query->row();
		    $quien=$evt->evt_idcopr;
		    if($quien>0) $quien_n=$this->get_uf($quien)->cop_nombre;
		    else $quien_n="El Barrio";
		    $estado="ocupado";
		    $auxDev=array('hora_cita' => $estaHora, 'estado' => $estado, 'ocupada_por' => $quien_n);
		    $loQueDevuelvo[]=$auxDev;
		}else{
		    if($fechaPasada==$fechaHoy){
			if(strtotime($estaHora)<=strtotime($queHora)){
			    $quien_n="Hora vencida";
			    $estado="ocupado";
			    $auxDev=array('hora_cita' => $estaHora, 'estado' => $estado, 'ocupada_por' => $quien_n);
			    $loQueDevuelvo[]=$auxDev;
			}else{
			    $estado="disponible";
			    $auxDev=array('hora_cita' => $estaHora, 'estado' => $estado);
			    $loQueDevuelvo[]=$auxDev;
			}
		    }else{
			$estado="disponible";
			$auxDev=array('hora_cita' => $estaHora, 'estado' => $estado);
			$loQueDevuelvo[]=$auxDev;
		    }
		}
		$qLastDay="select ('$estaHora'::time + interval '$duracion minutes')::time as lastDay;";
		$rLastDay=$this->db->query($qLastDay);
		$estaHora=$rLastDay->row()->lastday;
		if($estaHora==$fin) $termino=2;
	    }
            return $loQueDevuelvo;
        }else{
            return false;
        }
    }
 
    /**
     *hacemos que el usuario pueda coger hora a través del calendario con varios intervalos de horas
     * @access public
     * @param $dia_calendario - string fecha pulsada en el calendario formato 2013/09/01
     * @param $month - string número de mes
     * @param $year - int número de año
     */
    public function nueva_cita($dia_calendario, $hora, $comentario_cita, $uf, $actividad, $ufs_arr) 
    {

	$this->db->where("evt_horad", $hora);
	$this->db->where("evt_fecha", $dia_calendario);
	$this->db->where("evt_idamenity", $actividad);
	$this->db->where("evt_estado", 2);
	$valido=$this->db->get("eventos");
	if($valido->num_rows()>0){
	    return "antes";
	}else{
	    $unidad=$this->get_uf($uf);
	    $activ=$this->get_amenity($actividad);

	    $codemp=$unidad->cop_codemp;
	    $idptov=$unidad->cop_idptov;
	    $division=$unidad->cop_division;
	    $centro=$unidad->cop_centro;
	    $duracion=$activ->am_duracion;
	    $reqaut=$activ->am_reqaut;
	    $qLastDay1="select ('$hora'::time + interval '$duracion minutes')::time as lastDay;";
	    $rLastDay1=$this->db->query($qLastDay1);
	    $horah=$rLastDay1->row()->lastday;

	    if($reqaut==2){
		$estado=2;
	    }else{
		$estado=1;
	    }


	    $data = array(
		"evt_codemp" => $codemp,
		"evt_idptov" => $idptov,
		"evt_division" => $division,
		"evt_centro" => $centro,
		"evt_idcopr" => $uf,
		"evt_idamenity" => $actividad,
		"evt_horad" => $hora,
		"evt_horah" => $horah,
		"evt_estado" => $estado,
		"evt_fecha" => $dia_calendario,
		"evt_obs" => $comentario_cita,
	    );
	    $query = $this->db->insert("eventos",$data);
	    $evt_id= $this->db->insert_id('eventos_evt_id_seq');

	    if ($query) {
		//si se crea el evento vemos si se confirma automaticamente o no

		if($ufs_arr){
		    foreach($ufs_arr as $uf_p){
			if($uf_p>0){
			    $data2 = array(
				"ue_idevt" => $evt_id,
				"ue_idcopr" => $uf_p,
			    );
			    $query2 = $this->db->insert("ufsxevt",$data2);
			}
		    }
		}

		if($reqaut==2){
		    return "confirmada";
		}else{
		    return "pendiente";
		}
	    }
	}
    }

    public function get_uf($id){
		$this->db->where('cop_id', $id);
		$q=$this->db->get('coprop');
		$q=$q->row();
		return $q;
	}

    public function get_amenity($id){
		$this->db->where('am_id', $id);
		$q=$this->db->get('amenity');
		$q=$q->row();
		return $q;
	}

    public function tieneMaxcop($cop_id, $am_id){
		$this->db->where('am_id', $am_id);
		$q=$this->db->get('amenity');
		if($q->num_rows() >0){
			$maxcop=$q->row()->am_maxcop;

			//cuantos eventos ya reservo el muchacho?
			$qReservas="select * from eventos where evt_estado in (-1,2) and (evt_fecha + evt_horah)>=now() and evt_idamenity=$am_id and evt_idcopr=$cop_id";
			$rReservas=$this->db->query($qReservas);
			if($rReservas->num_rows()>0) $rReservas=$rReservas->num_rows(); else $rReservas=NULL;

			if($rReservas){
			    if($rReservas>=$maxcop){
				$leyen="La actividad definida permite &uacute;nicamente $maxcop reservas activas (pendientes de confirmaci&oacute;n/confirmadas) por copropietario y usted ya posee $rReservas reservas. Debe cumplir/anular las mismas para poder volver a reservar. <BR />";
				return $leyen;
			    }else{
				return false;
			    }
			}else{
//				$leyen="ya posee x reservas. Debe cumplir/anular las mismas para poder volver a reservar. <BR />";
//				return $leyen;
			    return false;
			}

		}else{
			return false;
		}
	}


 
}
//end calendario_model