<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Autorizaciones_model extends CI_Model
{


	function visitas_agendadas($user_id){

		$tipo=$this->Sec_model->tipo_usuario($user_id);
		$elBarrio=$this->Sec_model->getBarrio();
		$cops=$this->Sec_model->usuario_barrio_unidad($user_id,$elBarrio);
		if($cops){
		    $cops=$cops[0]->cop_id;
		}else $cops=-1;
		
		$q="select * from gente,gtexuf where gte_id=gxu_idgente and gxu_idcop=$cops and gxu_tipusu=$tipo and gxu_vtovisita>=now()::date and gxu_estado in (1,2) and gte_idptov=$elBarrio order by gxu_vtovisita,gte_dni;";
		$q=$this->db->query($q);
		return $q;
	}



	function estado_gente($gte_id){
		$this->db->where('gte_id', $gte_id);
		$q=$this->db->get('gente');
		if($q->num_rows() >0){
			$q=$q->row()->gte_estado;
			return $q;
		}else{
			return false;
		}
	}





	function get_ciaseg_autos(){
		$this->db->select('cs_id,cs_nombre');
		$this->db->where('cs_estado', 1);
		$this->db->where('cs_tipo', 1);
		$this->db->order_by('cs_nombre', 'asc');
		$q=$this->db->get('ciaseg');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}
	}

	function get_ciaseg_art(){
		$this->db->select('cs_id,cs_nombre');
		$this->db->where('cs_estado', 1);
		$estados=array(1,2);
		$this->db->where_in('cs_tipo', $estados);
		$this->db->order_by('cs_nombre', 'asc');
		$q=$this->db->get('ciaseg');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}
	}


	function get_gxu($id){
		$q="select * from gtexuf,gente where gxu_id=$id and gxu_idgente=gte_id;";
		$q=$this->db->query($q);
		if($q) return $q->result();
		else return false;
	}

	function get_nota($id){
		$q="select * from gtexuf,notaxgxu where gxu_id=$id and gxu_id=ng_idgxu and ng_estado=1;";
		$q=$this->db->query($q);
		if($q) return $q->result();
		else return false;
	}



	function get_gte($id){
		$q="select * from gtexuf,gente where gte_id=$id and gxu_idgente=gte_id;";
		$q=$this->db->query($q);
		if($q) return $q->result();
		else return false;
	}


	function delfoto($id){
		$q="update gente set gte_foto='' where gte_id=$id;";
		$q=$this->db->query($q);
		if($q) return true;
		else return false;
	}



	function get_gente($term,$idptov){
		$q="select * from gente where gte_estado=1 and gte_idptov=$idptov and gte_nombre ilike '%$term%' order by gte_nombre;";
		$q=$this->db->query($q);
		if($q) return $q->result();
		else return false;
	}


	function get_empresa($term,$idptov){
		$q="select * from gente where gte_estado=1 and gte_idptov=$idptov and gte_empresa ilike '%$term%' order by gte_nombre;";
		$q=$this->db->query($q);
		if($q) return $q->result();
		else return false;
	}


	function get_last_lv($id){
		$q="select * from livianos where lv_id in (select io_idliv from inout where io_idliv is not null and io_idgente=$id order by io_id desc limit 1);";
		$q=$this->db->query($q);
		if($q) $q=$q->result();
		if($q) return $q;
		else{
		    $q="select * from livianos where lv_id in (select gl_idliv from gtexliv where gl_idgente=$id order by gl_id desc limit 1);";
		    $q=$this->db->query($q);
		    if($q) return $q->result();
		    else return false;
		}
	}

	function get_lv($id){
		$q="select * from livianos where lv_id=$id;";
		$q=$this->db->query($q);
		if($q) return $q->result();
		else return false;
	}

	function get_gente_lv($id){
		$q="select * from gtexliv,livianos where gl_idgente=$id and gl_idliv=lv_id order by lv_id desc;";
		$q=$this->db->query($q);
		if($q) return $q->result();
		else return false;
	}

	function get_gente_gxu($id){
		$q="select * from gtexuf where gxu_idgente=$id and gxu_estado=1 and gxu_segart is not null order by gxu_id desc;";
		$q=$this->db->query($q);
		if($q) return $q->result();
		else return false;
	}




	function existe_gente_dni($dni){
		$this->db->where('gte_dni', trim($dni));
		$this->db->where('gte_idptov', 42);
		$q=$this->db->get('gente');
		if($q->num_rows() >0){
		    $q=$q->row();
		    return $q;
		}
		return NULL;
	}

	function existe_gente_empresa($emp){
		$this->db->where('gte_empresa ilike', trim($emp));
		$this->db->where('gte_idptov', 42);
		$q=$this->db->get('gente');
		if($q->num_rows() >0){
		    $q=$q->row();
		    return $q;
		}
		return NULL;
	}

	function existe_gente_nombre($emp){
		$this->db->where('gte_nombre ilike', trim($emp));
		$this->db->where('gte_idptov', 42);
		$q=$this->db->get('gente');
		if($q->num_rows() >0){
		    $q=$q->row();
		    return $q;
		}
		return NULL;
	}


	function existe_liviano_patente($patente){
		$this->db->where('lv_patente', trim($patente));
		$q=$this->db->get('livianos');
		if($q->num_rows() >0){
		    $q=$q->row();
		    return $q;
		}
		return NULL;
	}

	function existe_rel_lv_gte($gte_id,$lv_id){
		$this->db->where('gl_idgente', $gte_id);
		$this->db->where('gl_idliv', $lv_id);
		$q=$this->db->get('gtexliv');
		if($q->num_rows() >0){
		    $q=$q->row();
		    return $q;
		}
		return NULL;
	}

	function existe_rel_gte_uf($gte_id,$cop_id,$tipo,$motivo,$tipusu){
		$this->db->where('gxu_idgente', $gte_id);
		$this->db->where('gxu_idcop', $cop_id);
		$this->db->where('gxu_tipo', $tipo);
		$this->db->where('gxu_tipusu', $tipusu);
		$this->db->where('gxu_motivo', $motivo);
		$this->db->where('gxu_estado', 1);
		$q=$this->db->get('gtexuf');
		if($q->num_rows() >0){
		    $q=$q->row();
		    return $q;
		}
		return NULL;
	}




}
