<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Sec extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Sec_model','calendario_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));

		$this->lang->load('auth');
		$admins = array(1,3);
		$this->data['admins'] =array(1,3);
	}

	// redirect if needed, otherwise display the user list
	public function index()
	{

	}

	function add_rel(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
			$this->session->set_flashdata('message', 'Accion no permitida');
			redirect('Auth', 'refresh');
		}else{


			$this->form_validation->set_rules('id', 'Usuario', 'required');
			$this->form_validation->set_rules('ptv_id[]', 'Barrio', 'required');
			$this->form_validation->set_rules('ufd', 'Unidad', 'required');

			//var_dump($this->input->post());exit;
			if ($this->form_validation->run() === TRUE)
			{
				if($this->ion_auth->is_admin()){$estado = 1;}else{$estado = 0;}
					$tabla='user_rel_ptovta_rel_ufs';
					$barrios=$this->input->post('ptv_id[]');
					$ufd = $this->input->post('ufd');


					foreach($barrios as $barrio){
						$datos=array(
							'id_user'=> $user->id,
							'ptv_id' => $barrio,
							'ufd'    => $ufd,
							'estado' => $estado
						);
						if($this->Sec_model->insert($tabla,$datos) == FALSE){
							echo $this->db->last_query();
							exit;
						}
					}

					$this->session->set_flashdata('message', 'Se ha solicitado la nueva relaci&oacute;n al administrador del barrio. En 48hs como m&aacute;ximo el administrador confirmar&aacute; su solicitud.');
					redirect('Auth', 'refresh');
			}else{
				$this->session->set_flashdata('message', validation_errors());
				redirect('Auth', $this->data);
			}
		}
	}

	function add_rel_ufd(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
			$this->session->set_flashdata('message', 'Accion no permitida');
			redirect('Auth', 'refresh');
		}else{


			$this->form_validation->set_rules('id', 'Usuario', 'required');
			$this->form_validation->set_rules('ptv_id', 'Barrio', 'required');
			$this->form_validation->set_rules('ufd[]', 'Unidad', 'required');

			//var_dump($this->input->post());exit;
			if ($this->form_validation->run() === TRUE)
			{
				if($this->ion_auth->is_admin()){$estado = 1;}else{$estado = 0;}
					$tabla='user_rel_ptovta_rel_ufs';
					$barrio=$this->input->post('ptv_id');
					$ufd = $this->input->post('ufd');
						$datos=array(
							'id_user'=> $user->id,
							'ptv_id' => $barrio,
							'ufd'    => $ufd,
							'estado' => $estado
						);
						if($this->Sec_model->insert($tabla,$datos) == FALSE){
							echo $this->db->last_query();
							exit;
						}

					$this->session->set_flashdata('message', 'Se ha solicitado la nueva relaci&oacute;n al administrador del barrio. En 48hs como m&aacute;ximo el administrador confirmar&aacute; su solicitud.');
					redirect('Auth', 'refresh');
			}else{
				$this->session->set_flashdata('message', validation_errors());
				redirect('Auth', $this->data);
			}
		}
	}

	function sendmail($usermail,$subject,$sms){
	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'No Responder');
	    $this->email->to($usermail);
//	    $this->email->bcc('fl.catware@gmail.com'); 
	    $this->email->subject($subject);
	    $this->email->message($sms);
	    if ($this->email->send())
		$this->session->set_flashdata('message', 'Se ha enviado el e-mail.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }
	}


	function sendmail_adj($usermail,$subject,$sms,$file){
	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'No Responder');
	    $this->email->to($usermail);
//	    $this->email->bcc('fl.catware@gmail.com'); 
	    $this->email->subject($subject);
	    $this->email->message($sms);
	    $this->email->attach($file);
	    if ($this->email->send())
		$this->session->set_flashdata('message', 'Se ha enviado el e-mail.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }
	}







	function estado_rel($id_rel, $estado){
		$admins = array(1,3);
		$this->data['admins'] =array(1,3);
		if(!$this->ion_auth->in_group($admins)){
			$this->session->set_flashdata('message', 'página de administración');
		redirect('Auth', 'refresh');
		}else{
			$datos=array('estado'=> $estado,);
			if($this->Sec_model->update('user_rel_ptovta_rel_ufs',$id_rel,$datos)==true){
				$this->session->set_flashdata('message', 'Se han realizado los cambios.');
				redirect('Auth', 'refresh');
			}else{
				$this->session->set_flashdata('message', 'ERROR: No se han podido realizar los cambios.');
				redirect('Auth', 'refresh');
			}
		}
	}

	function delete_rel($id_rel, $id_user){

		$user=$this->ion_auth->user()->row();
		if (!$user->id == $id_user) {
			if(!$this->ion_auth->is_admin()){
				$this->session->set_flashdata('message', 'página de administración');
				redirect('Auth', 'refresh');
			}
		}

			if($this->Sec_model->delete('user_rel_ptovta_rel_ufs',$id_rel)==true){
				$this->session->set_flashdata('message', 'Se ha eliminado la relación solicitada.');
				redirect('Auth', 'refresh');
			}else{
				$this->session->set_flashdata('message', 'ERROR: No se han podido realizar los cambios.');
				redirect('Auth', 'refresh');
			}

	}

	function unidades_en_barrio(){
		$options = "";
        if ($this->input->post('ptv_id')) {
            $ptv_id = $this->input->post('ptv_id');
            $unidades = $this->Sec_model->unidades_barrio($ptv_id);
            if($unidades == FALSE){
				echo "<option>--</option>";
            }else{
//            	echo "<option value=\"0\">Administrador de Barrio</option>";
            	foreach($unidades as $unidad){?>
					<option value="<?php echo $unidad->cop_id;?>"><?php echo $unidad->cop_unifun.' - '.$unidad->cop_nombre;?></option>
				<?php }
            }			
		}else{
			echo "<option>--</option>";
		}
	}

	function unidades_en_barrio_tot(){
		$options = "";
        if ($this->input->post('ptv_id')) {
            $ptv_id = $this->input->post('ptv_id');
            $unidades = $this->Sec_model->unidades_barrio_tot($ptv_id);
            if($unidades == FALSE){
				echo "<option>--</option>";
            }else{
//            	echo "<option value=\"0\">Administrador de Barrio</option>";
            	foreach($unidades as $unidad){?>
					<option value="<?php echo $unidad->cop_id;?>"><?php echo $unidad->cop_unifun;?></option>
				<?php }
            }			
		}else{
			echo "<option>--</option>";
		}
	}


	function unidades_en_barrio_prop(){
		$options = "";
        if ($this->input->post('ptv_id') && $this->input->post('user_id')) {
            $ptv_id = $this->input->post('ptv_id');
            $user_id = $this->input->post('user_id');
            $unidades = $this->Sec_model->unidades_barrio_prop($user_id,$ptv_id);
            if($unidades == FALSE){
				echo "<option>---/option>";
            }else{
            	foreach($unidades as $unidad){?>
					<option value="<?php echo $unidad->cop_id;?>"><?php echo $unidad->cop_unifun;?></option>
				<?php }
            }			
		}else{
			echo "<option>--</option>";
		}
	}

	function bancos_de_barrio(){
		$options = "";
        if ($this->input->post('ptv_id')) {
            $ptv_id = $this->input->post('ptv_id');
            $unidades = $this->Sec_model->bancos_barrio($ptv_id);
            if($unidades == FALSE){
				echo "<option>---</option>";
            }else{
            	foreach($unidades as $unidad){?>
					<option value="<?php echo $unidad->cte_id;?>"><?php echo $unidad->cte_nombre;?></option>
				<?php }
            }			
		}else{
			echo "<option>--</option>";
		}
	}



	function desccomp($astc_comprob){
		$this->db->select('comp_codigo,comp_nombre');
		$this->db->where('comp_id', $astc_comprob);
		$q=$this->db->get('comprob');
		$q=$q->row();
		$concatenado = $q->comp_codigo."-".$q->comp_nombre;
		return $concatenado;

	}


	function volver(){

	    $user=$this->ion_auth->user()->row();
	    $this->session->set_flashdata('pestania_activa', 'reservas');
	    redirect('Auth', 'refresh');

	}

	function vuelvo_visitas(){

	    $user=$this->ion_auth->user()->row();
	    $this->session->set_flashdata('pestania_activa', 'visitas');
	    redirect('Auth', 'refresh');

	}
























/* GRUPO FAMILIAR*/

	public function grupo_familiar(){

	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$idcopr=$this->input->post('gf_idcopr');
		$cant_mayores=$this->input->post('cant_mayores_'.$idcopr);
		$cant_menores=$this->input->post('cant_menores_'.$idcopr);


		$this->form_validation->set_rules('cant_mayores_'.$idcopr, 'Cantidad de Miembros Mayores', 'required');
		$this->form_validation->set_rules('cant_menores_'.$idcopr, 'Cantidad de Miembros Menores', 'required');
		$this->form_validation->set_rules('gf_idcopr', 'Unidad Funcional', 'required');

		if ($this->form_validation->run() === TRUE){

		    $tipusu=$this->Sec_model->tipo_usuario($user->id);
		    if($tipusu==2){
			$contr_id=$this->Sec_model->get_idcontr($idcopr);
			if(!$contr_id || $contr_id==false){
			    $this->session->set_flashdata('message', 'NO EXISTE CONTRATO DE LOCACION DEFINIDO, ANTES DE CONTINUAR COMUNIQUESE CON LA ADMINISTRACION.');
			    redirect('Auth', $this->data);
			}
		    }

		    //NO PUEDE DISMINUIR MAYORES
		    $mayores_anteriores=$this->Sec_model->cant_grupof($idcopr,$user->id,1);
		    $mayores_anteriores=$mayores_anteriores->result();
		    if($mayores_anteriores) $mayores_anteriores = $mayores_anteriores[0]->canti;
		    else $mayores_anteriores=0;
		    if($mayores_anteriores>$cant_mayores){
			$this->session->set_flashdata('message', 'NO ES POSIBLE DISMINUIR LA CANTIDAD DE MAYORES DE LA UF. PARA REALIZAR DICHA ACCION COMUNIQUESE POR FAVOR CON LA ADMINISTRACION.');
			redirect('Auth', $this->data);
		    }

		    //NO PUEDE DISMINUIR MENORES
		    $menores_anteriores=$this->Sec_model->cant_grupof($idcopr,$user->id,2);
		    $menores_anteriores=$menores_anteriores->result();
		    if($menores_anteriores) $menores_anteriores = $menores_anteriores[0]->canti;
		    else $menores_anteriores=0;
		    if($menores_anteriores>$cant_menores){
			$this->session->set_flashdata('message', 'NO ES POSIBLE DISMINUIR LA CANTIDAD DE MENORES DE LA UF. PARA REALIZAR DICHA ACCION COMUNIQUESE POR FAVOR CON LA ADMINISTRACION.');
			redirect('Auth', $this->data);
		    }


		    for($m=0;$m<$cant_menores;$m++){
			$fecnac=$this->input->post('fecnac'.$m.'_'.$idcopr);
			if(!$fecnac){
			    $this->session->set_flashdata('message', 'ES OBLIGATORIO COMPLETAR LA FECHA DE NACIMIENTO DE TODOS LOS MENORES.');
			    redirect('Auth', $this->data);
			}
		    }



		    $elBarrio=$this->Sec_model->id_barrios_user($user->id)[0];
//		    $this->Sec_model->inh_grupof($idcopr,$user->id);
		    $uno=1;

		    for($m=0;$m<$cant_mayores;$m++){
			$id=$this->input->post('idmay_'.$m.'_'.$idcopr);
			$nombre=$this->input->post('nom_may_'.$m.'_'.$idcopr);
			$dni=$this->input->post('dni_may_'.$m.'_'.$idcopr);
			$tel=$this->input->post('tel_'.$m.'_'.$idcopr);
			if(!$tel) $tel='';
			if(!$nombre) $nombre='';
			if(!$dni) $dni='';

			if($tipusu==1){
			    $tabla1='grupof_d';
			    $datos1=array(
				'gf_idptov'=> $elBarrio,
				'gf_idcopr' => $idcopr,
				'gf_mayor'    => $uno,
				'gf_nombre'    => $nombre,
				'gf_nrodoc'    => $dni,
				'gf_tel'    => $tel,
			    );
			}else if($tipusu==2){
			    $tabla1='grupof_inq';
			    $datos1=array(
				'gf_idptov'=> $elBarrio,
				'gf_idcontr' => $contr_id,
				'gf_idcopr' => $idcopr,
				'gf_mayor'    => $uno,
				'gf_nombre'    => $nombre,
				'gf_nrodoc'    => $dni,
				'gf_tel'    => $tel,
			    );
			}

			if($id){
			    if($this->Sec_model->update_p($tabla1,"gf_id",$id,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			    }
			}else{
			    if($this->Sec_model->insert($tabla1,$datos1) == true){
				if($tipusu==1) $gf_id=$this->db->insert_id('grupof_d_gf_id_seq');
				else $gf_id=$this->db->insert_id('grupof_inq_gf_id_seq');
				$tabla2="cambiosgf";
				$datos2=array(
				    'cgf_idgf'=>$gf_id,
				    'cgf_tabla'=>$tabla1,
				    'cgf_cambio'=>'Alta de mayor desde el usuario web'
				);
				$this->Sec_model->insert($tabla2,$datos2);
			    }else{
				echo $this->db->last_query();
				exit;
			    }
			}
		    }
		    for($m=0;$m<$cant_menores;$m++){
			$id=$this->input->post('idmen_'.$m.'_'.$idcopr);
			$nombre=$this->input->post('nom_men_'.$m.'_'.$idcopr);
			$dni=$this->input->post('dni_men_'.$m.'_'.$idcopr);
			$fecnac=$this->input->post('fecnac'.$m.'_'.$idcopr);
			if(!$nombre) $nombre='';
			if(!$dni) $dni='';

			$edad=$this->Sec_model->edad_gf($fecnac);
			if($edad<3) $uno=NULL; else $uno=1;


			if($tipusu==1){
			    $tabla1='grupof_d';
			    $datos1=array(
				'gf_idptov'=> $elBarrio,
				'gf_idcopr' => $idcopr,
				'gf_fecnac'    => $fecnac,
				'gf_menor'    => $uno,
				'gf_nombre'    => $nombre,
				'gf_nrodoc'    => $dni,
			    );
			}else if($tipusu==2){
			    $tabla1='grupof_inq';
			    $datos1=array(
				'gf_idptov'=> $elBarrio,
				'gf_idcontr' => $contr_id,
				'gf_idcopr' => $idcopr,
				'gf_fecnac'    => $fecnac,
				'gf_menor'    => $uno,
				'gf_nombre'    => $nombre,
				'gf_nrodoc'    => $dni,
			    );
			}
			if($id){
			    if($this->Sec_model->update_p($tabla1,"gf_id",$id,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			    }
			}else{
			    if($this->Sec_model->insert($tabla1,$datos1) == true){
				if($tipusu==1) $gf_id=$this->db->insert_id('grupof_d_gf_id_seq');
				else $gf_id=$this->db->insert_id('grupof_inq_gf_id_seq');
				$tabla2="cambiosgf";
				$datos2=array(
				    'cgf_idgf'=>$gf_id,
				    'cgf_tabla'=>$tabla1,
				    'cgf_cambio'=>'Alta de menor desde el usuario web'
				);
				$this->Sec_model->insert($tabla2,$datos2);
			    }else{
				echo $this->db->last_query();
				exit;
			    }
			}


		    }

		    $this->session->set_flashdata('message', 'Usted ha actualizado los datos del grupo familiar. Si cargo todos los datos requeridos para todas sus UFs asociadas podra continuar operando. Muchas gracias.');
		    redirect('Auth', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Auth', $this->data);
		}
	    }
	}




















	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}











}