<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Reservas extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Reservas_model','Sec_model','calendario_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));



		$admins = array(1,3);
		$this->data['admins'] =array(1,3);
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
			    $this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
			    $this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
			}
		    }
		}


		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list
	public function index(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
        	$this->_render_page('body/reservas', $this->data);
	    }

	}





	function get_amenities(){
		$options = "";
        if ($this->input->post('ptv_id')) {
            $ptv_id = $this->input->post('ptv_id');
            $unidades = $this->Reservas_model->get_amenities($ptv_id);
            if($unidades == FALSE){
				echo "<option>---</option>";
            }else{
		?>
		<option selected value='-1'> Indistinto </option>
		<?php
            	foreach($unidades as $unidad){?>
					<option value="<?php echo $unidad->am_id;?>"><?php echo $unidad->am_nombre;?></option>
				<?php }
            }			
		}else{
			echo "<option>--</option>";
		}
	}

	function get_grupos(){
		$options = "";
        if ($this->input->post('ptv_id')) {
            $ptv_id = $this->input->post('ptv_id');
            $unidades = $this->Reservas_model->get_grupos($ptv_id);
            if($unidades == FALSE){
				echo "<option>---</option>";
            }else{
            	foreach($unidades as $unidad){?>
					<option value="<?php echo $unidad->gam_id;?>"><?php echo $unidad->gam_nombre;?></option>
				<?php }
            }			
		}else{
			echo "<option>--</option>";
		}
	}

	function Actividades_de_grupo(){
		$options = "";
        if ($this->input->post('grupoam')) {
            $gam_id = $this->input->post('grupoam');
            $unidades = $this->Reservas_model->get_actividades($gam_id);
            if($unidades == FALSE){
				echo "<option>---</option>";
            }else{
		?>
		<option selected value='-1'> Indistinto </option>
		<?php
            	foreach($unidades as $unidad){?>
					<option value="<?php echo $unidad->am_id;?>"><?php echo $unidad->am_nombre;?></option>
				<?php }
            }			
		}else{
			echo "<option>--</option>";
		}
	}




	function buscoReserva($year = null, $month = null){

	    $barrio=$this->input->post('ptv_id');
	    $terminos=$this->input->post('register-terms');
	    $uf=$this->input->post('ufd');
	    $grupo=$this->input->post('grupoam');
	    $actividad=$this->input->post('actividad');
	    $user_id=$this->input->post('id');
	    $year=$this->input->post('anio');
	    $month=$this->input->post('mes');
	    $csrf=$this->input->post($this->security->get_csrf_token_name());

	    $this->data['barrio']=$barrio;
	    $this->data['uf']=$uf;
	    $this->data['actividad']=$actividad;
	    $this->data['user_id']=$user_id;

    	    if(!$year){
        	$year = date('Y');
    	    }
    	    if(!$month){
        	$month = date('m');
    	    }



	    //HAGO VALIDACIONES
	    //1 = Copropietario no Inhabilitado
	    //2 = Maxcop x actividad
	    //1
	    $estaInHabilitado = $this->Reservas_model->estaInHabilitado($uf);
	    $errores=NULL;


	    if(!$terminos) $errores[]="Debe aceptar los terminos y condiciones para realizar una reserva.";

	    if($grupo=="---" || $actividad=="---") $errores[]="Se debe definir un grupo y una actividad (esta &uacute;ltima puede ser Indistinta)";


	    if($estaInHabilitado) $errores.=$estaInHabilitado;

	    $deuda = $this->Sec_model->deuda($uf);
	    $ultimalq = $this->Sec_model->ultimalq($uf);
	    if($deuda>=($ultimalq*3)) $errores[]="No puede reservar dado que la UF debe m&aacute;s de 3 expensas.";


	    if($errores){
		$this->session->set_flashdata('errores', $errores);
		redirect('reservas', $this->data);
	    }else if($actividad>0){
		//2
		$tieneMaxcop = $this->Reservas_model->tieneMaxcop($uf,$actividad);
		if($tieneMaxcop) $errores.=$tieneMaxcop;
		if($errores){
		    $this->session->set_flashdata('errores', $errores);
		    $this->load->view('back/reservas/index_reservas.php', $this->data);
		}else{
		    $this->calendario_model->insert_calendario($month,$year,$actividad);
		    //como vemos a generar_calendario le pasamos el año y el mes 
		    //para que sepa que debe mostrar
		    $this->data['anio']=$year;
		    $this->data['mes']=$month;
		    $this->data['uf']=$uf;
		    $this->data['titulo'][0] = $this->Reservas_model->nombre_actividad($actividad);
		    $this->data['calendario'][0] = $this->calendario_model->generar_calendario($year, $month, $actividad);
		    $this->data['canti']=1;
		    $this->data[$this->security->get_csrf_token_name()]=$csrf;

		    $txtevt=$this->Reservas_model->texto_grupo($grupo);
		    if($txtevt){
			$this->session->set_flashdata('message', $txtevt);
		    }
		    $this->load->view('back/reservas/index_reservas.php', $this->data);
		}
	    }else{
		$actividades=$this->Reservas_model->get_actividades($grupo);
		$i=0;
		$this->data['anio']=$year;
		$this->data['mes']=$month;
		$this->data['uf']=$uf;
		$this->data[$this->security->get_csrf_token_name()]=$csrf;
		foreach($actividades as $act){
		    $activ=$act->am_id;
		    if(!$errores){
			$tieneMaxcop = $this->Reservas_model->tieneMaxcop($uf,$activ);
			if($tieneMaxcop) $errores.=$tieneMaxcop;
		    }
		    if(!$errores){
			$this->calendario_model->insert_calendario($month,$year,$activ);
			$this->data['titulo'][$i] = $this->Reservas_model->nombre_actividad($activ);
			$this->data['actividad'][$i] = $activ;
			$this->data['calendario'][$i] = $this->calendario_model->generar_calendario($year, $month, $activ);
			$i++;
		    }else{
			$this->session->set_flashdata('errores', $errores);
		    }
		}
		$this->data['canti']=$i;

/*		$txtevt=$this->Reservas_model->texto_grupo($grupo);
		if($txtevt){
		    $this->session->set_flashdata('message', $txtevt);
		}
*/
		$this->load->view('back/reservas/index_reservas.php', $this->data);
	    }
	}



    function volver(){
	redirect('Reservas','refresh');
    }








/*CALENDAR*/


  function cal($year = null, $month = null)
    {     
 
        if(!$year)
        {
            $year = date('Y');
        }
        if(!$month)
        {
            $month = date('m');
        }
      
        $this->calendario_model->insert_calendario($month,$year);
 
        //si el año y el mes al que queremos acceder es menor que el actual no dejamos
        if($this->uri->segment(3).'/'.$this->uri->segment(4) < date('Y').'/'.date('m'))
      {
        redirect(base_url('calendario/cal/'.date('Y').'/'.date('m')));
      }
      
        //como vemos a generar_calendario le pasamos el año y el mes 
        //para que sepa que debe mostrar
        $data =  array('titulo' => 'Calendario con ci','calendario' => $this->calendario_model->generar_calendario($year, $month));
        $this->load->view('back/calendario_view', $data);
    }
 
    //al pulsar en cualquier día laborable o por delante de la fecha actual 
    //insertamos en citas todas las horas de ese día y, si ya existían 
    //mostramos un formulario con un select y las horas disponibles en un popup
    function coger_hora()
    {
        //comprobamos que sea una petición ajax
        if($this->input->is_ajax_request())
        {
            $dia = $this->input->post('num');
            $year = $this->input->post('year');
            $month = $this->input->post('month');
            $uf = $this->input->post('uf');
            $actividad = $this->input->post('actividad');
            $csrf = $this->input->post('csrf_test_name');

            $fecha_completa = $dia.'-'.$month.'-'.$year;

            $dia_escogido = $this->input->post('dia_escogido');
            $mes_escogido = $this->input->post('mes_escogido');

            //obtenemos la información de las horas de ese día
            $info_dia = $this->calendario_model->horas_seleccionadas($year,$month,$dia,$actividad);
            $ufs_disp = $this->Sec_model->get_ufs($uf);

	    $vajilla = $this->Reservas_model->get_actividad($actividad);
	    $vajilla=$vajilla->am_vajilla;

            $data = array(
                "year" => $year,
                "dia" => $dia,
                "month" => $month,
                "uf" => $uf,
                "vajilla" => $vajilla,
                "actividad" => $actividad,
                "fecha_completa" => $fecha_completa,
                "dia_escogido" => $dia_escogido, 
                "mes_escogido" => $mes_escogido,
                "csrf_test_name" => $csrf,
                "ufs_disp" => $ufs_disp,
                "info_dia" => $info_dia
            );
            //si hay horas disponibles para ese día mostramos 
            //la vista pasando la info en el array data
            if($info_dia !== false)
            {    
                $this->load->view("back/reservas/get_hora_view",$data);
            }
        }else{
            show_404();
        }
    }
 
    //hacemos el update de la tabla citas cuando 
    //el usuario hace submit al form popup del calendario
    function nueva_cita()
    {

        //comprobamos que sea una petición ajax
        if($this->input->is_ajax_request())
        {
            $this->form_validation->set_rules('textarea', 'Comentario', 'trim|xss_clean');
            $this->form_validation->set_rules('hora', 'Hora', 'trim|xss_clean');
            $this->form_validation->set_rules('svajilla', 'Vajilla', 'required| grater_than[0]');

            $dia_calendario = $this->input->post('dia_update');
            $hora = $this->input->post('hora');
            $uf = $this->input->post('uf');
            $actividad = $this->input->post('actividad');
            $svajilla = $this->input->post('svajilla');
            $comentario_cita = $this->input->post('textarea') == '' ? '' : $this->input->post('textarea');

	    if($svajilla==1) $comentario_cita.=" LA UF SOLICITA UTILIZAR LA VAJILLA";

            $ufs_arr = $this->input->post('ufs');
	    if(!$ufs_arr[0]) $ufs_arr=array();
            $estado = 'ocupado';
            $fecha_escogida = $this->input->post('fecha_escogida');

            $nueva_cita = $this->calendario_model->nueva_cita($dia_calendario,$hora,$comentario_cita,$uf,$actividad,$ufs_arr);

	    if($nueva_cita == "antes"){
		echo 'antes';
	    }else if($nueva_cita == "confirmada"){
		echo $fecha_escogida.' a las '.$hora.'. La misma se encuentra confirmada, puede presentarse el d&iacute;a y hora a realizar la actividad';
		$actividad_n=$this->Reservas_model->nombre_actividad($actividad);
		$ufd_unifun= $this->Sec_model->get_cop_unifun($uf);
		$usmail="intendencia@lostroncoscc.com.ar";
		$asunto="Reserva Confirmada";
		$mensaje = "La UF $ufd_unifun acaba de reservar $actividad_n para el dia $dia_calendario a las $hora. Expresa en su reserva: $comentario_cita. ";
//		$this->sendmail($usmail,$asunto,$mensaje);
	    }else if($nueva_cita == "pendiente"){
		echo $fecha_escogida.' a las '.$hora.'. La misma se encuentra pendiente de confirmaci&oacute;n por un administrador del sistema.';
	    }else if($nueva_cita == "validacion"){
		echo 'validacion';
	    }else{
		echo 'error';
	    }

        }else{
            show_404();
        }
    }


























	function sendmail($usermail,$subject,$sms){
	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'No Responder');
	    $this->email->to($usermail);
//	    $this->email->bcc('fl.catware@gmail.com'); 
	    $this->email->subject($subject);
	    $this->email->message($sms);
	    if ($this->email->send())
		$this->session->set_flashdata('message', 'Se ha enviado el e-mail.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }
	}


	function sendmail_adj($usermail,$subject,$sms,$file){
	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'No Responder');
	    $this->email->to($usermail);
//	    $this->email->bcc('fl.catware@gmail.com'); 
	    $this->email->subject($subject);
	    $this->email->message($sms);
	    $this->email->attach($file);
	    if ($this->email->send())
		$this->session->set_flashdata('message', 'Se ha enviado el e-mail.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }
	}








	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}