<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Reclamos extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Reclamos_model','Sec_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));



		$admins = array(1,3);
		$this->data['admins'] =array(1,3);
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
			    $this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
			    $this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
			}
		    }
		}


		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list
	public function index(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
        	$this->_render_page('body/reclamos', $this->data);
	    }

	}


	public function activi(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$ufs="";
		$lasRelaciones = $this->Sec_model->barrios_user($user->id);
		if($lasRelaciones){
		    $barrio = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $unidades=$this->Sec_model->unidades_barrio_prop($user->id,$barrio);
		    if($unidades){
			foreach($unidades as $cop){
			    if(!$ufs) $ufs="$cop->cop_unifun"; else $ufs.=" / $cop->cop_unifun";
			}
		    }
		}

		$this->data['user']=$user;
		$this->data['ufs']=$ufs;
		$this->data['nombre']=$user->first_name.' '.$user->last_name;
		$this->data['correos']=$user->email.' ; '.$user->company;
        	$this->_render_page('body/activi', $this->data);
	    }

	}


	public function consejo(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$ufs="";
		$lasRelaciones = $this->Sec_model->barrios_user($user->id);
		if($lasRelaciones){
		    $barrio = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $unidades=$this->Sec_model->unidades_barrio_prop($user->id,$barrio);
		    if($unidades){
			foreach($unidades as $cop){
			    if(!$ufs) $ufs="$cop->cop_unifun"; else $ufs.=" / $cop->cop_unifun";
			}
		    }
		}

		$this->data['user']=$user;
		$this->data['ufs']=$ufs;
		$this->data['nombre']=$user->first_name.' '.$user->last_name;
		$this->data['correos']=$user->email.' ; '.$user->company;
        	$this->_render_page('body/consejo', $this->data);
	    }

	}


	public function seguridad(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$ufs="";
		$lasRelaciones = $this->Sec_model->barrios_user($user->id);
		if($lasRelaciones){
		    $barrio = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $unidades=$this->Sec_model->unidades_barrio_prop($user->id,$barrio);
		    if($unidades){
			foreach($unidades as $cop){
			    if(!$ufs) $ufs="$cop->cop_unifun"; else $ufs.=" / $cop->cop_unifun";
			}
		    }
		}

		$this->data['user']=$user;
		$this->data['ufs']=$ufs;
		$this->data['nombre']=$user->first_name.' '.$user->last_name;
		$this->data['correos']=$user->email.' ; '.$user->company;
        	$this->_render_page('body/seguridad', $this->data);
	    }

	}





	// redirect if needed, otherwise display the user list
	public function Reabrir_reclamo($idReclam){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$this->data['in_id']=$idReclam;
		$reclamo=$this->Reclamos_model->get_reclamo($idReclam);
		$this->data['fullreclamo']=$reclamo;
        	$this->_render_page('body/reabrir_reclamo', $this->data);
	    }

	}


	// redirect if needed, otherwise display the user list
	public function Alquileres(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
        	$this->_render_page('body/alquileres', $this->data);
	    }

	}






	function categ_incid(){
	    $options = "";
            $unidades = $this->Reclamos_model->categorias_reclamo();
            if($unidades == FALSE){
				echo "<option>--</option>";
            }else{
            	foreach($unidades as $unidad){?>
		    <option value="<?php echo $unidad->cat_codigo;?>"><?php echo $unidad->cat_nombre;?></option>
		<?php }
            }			
	}





	function prior_incid(){
		$options = "";
            $unidades = $this->Reclamos_model->prioridades_reclamo();
            if($unidades == FALSE){
		echo "<option>--</option>";
            }else{
            	foreach($unidades as $unidad){?>
			<option value="<?php echo $unidad->pri_codigo;?>"><?php echo $unidad->pri_nombre;?></option>
		<?php }
            }			
	}




	function Informar_Alquiler(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('ia_idcopr', 'Unidad', 'required');
		$this->form_validation->set_rules('ia_fecdes', 'Fecha Desde', 'required');
		$this->form_validation->set_rules('ia_fechas', 'Fecha Hasta', 'required');
		$this->form_validation->set_rules('ia_nominq', 'Nombre del Inquilino', 'required');
		$this->form_validation->set_rules('ia_cantmay', 'Cantidad de Mayores', 'required');
		$this->form_validation->set_rules('ia_cantmen', 'Cantidad de Menores', 'required');

		$config['upload_path']          = './uploads/reclamos/';
		$config['allowed_types']        = 'jpg|jpeg|gif|png|pdf|doc|docx';
		$config['max_size']             = 10240;
		$this->load->library('upload', $config);
		$this->load->library('image_lib');
		$ia_phoja=$ia_shoja="";


		if ($this->form_validation->run() === TRUE){
		    if(isset($_FILES)){
			if ($this->upload->do_upload('file_phoja')) {
			    $upload_data = $this->upload->data();
			    $data_ary = array(
				    'title'     => $upload_data['client_name'],
				    'file'      => $upload_data['file_name'],
				    'width'     => $upload_data['image_width'],
				    'height'    => $upload_data['image_height'],
				    'type'      => $upload_data['image_type'],
				    'size'      => $upload_data['file_size'],
				    'path'      => $upload_data['full_path'],
				    'date'      => time(),
			    );
			    $configer =  array(
				    'image_library'   => 'gd2',
				    'source_image'    =>  $upload_data['full_path'],
				    'maintain_ratio'  =>  TRUE,
				    'width'           =>  600,
				    'height'          =>  480,
			    );
			    $this->image_lib->clear();
			    $this->image_lib->initialize($configer);
			    $this->image_lib->resize();
			    $data = array('upload_data' => $upload_data);
			    $ia_phoja=$data_ary['path'];
			}else{
			    if($_FILES['file_phoja']['error'] == 4){
				$error = array('error' => 'La primera hoja del contrato (o el contrato completo) de alquiler es obligatoria.');
			    }else{
				$error = array('error' => $this->upload->display_errors());
			    }
			    $new_data=array(
				'message'=>$error
			    );
			    $this->session->set_flashdata($new_data);
			    redirect('Reclamos/Alquileres', $this->data);
			}

			if ($this->upload->do_upload('file_shoja')) {
			    $upload_data = $this->upload->data();
			    $data_ary = array(
				    'title'     => $upload_data['client_name'],
				    'file'      => $upload_data['file_name'],
				    'width'     => $upload_data['image_width'],
				    'height'    => $upload_data['image_height'],
				    'type'      => $upload_data['image_type'],
				    'size'      => $upload_data['file_size'],
				    'path'      => $upload_data['full_path'],
				    'date'      => time(),
			    );
			    $configer =  array(
				    'image_library'   => 'gd2',
				    'source_image'    =>  $upload_data['full_path'],
				    'maintain_ratio'  =>  TRUE,
				    'width'           =>  600,
				    'height'          =>  480,
			    );
			    $this->image_lib->clear();
			    $this->image_lib->initialize($configer);
			    $this->image_lib->resize();
			    $data = array('upload_data' => $upload_data);
			    $ia_shoja=$data_ary['path'];
			}else{
			    if($_FILES['file_shoja']['error'] != 4){
				$error = array('error' => $this->upload->display_errors());
				$new_data=array(
				    'message'=>$error
				);
				$this->session->set_flashdata($new_data);
				redirect('Reclamos/Alquileres', $this->data);
			    }
			}
		    }
		    $barrio=$this->Sec_model->id_barrios_user($user->id)[0];
		    $ia_idcopr = $this->input->post('ia_idcopr');
		    $ia_fecdes = $this->input->post('ia_fecdes');
		    $ia_fechas = $this->input->post('ia_fechas');
		    $ia_nominq = $this->input->post('ia_nominq');
		    $ia_cantmay = $this->input->post('ia_cantmay');
		    $ia_cantmen = $this->input->post('ia_cantmen');
		    $ia_obs = $this->input->post('ia_obs');

		    $tabla1='infalquiler';
		    $datos1=array(
			'ia_idptov'=> $barrio,
			'ia_idcopr'=> $ia_idcopr,
			'ia_fecdes' => $ia_fecdes,
			'ia_fechas'    => $ia_fechas,
			'ia_nominq'    => $ia_nominq,
			'ia_cantmay'    => $ia_cantmay,
			'ia_cantmen'    => $ia_cantmen,
			'ia_phoja'    => $ia_phoja,
			'ia_shoja'    => $ia_shoja,
			'ia_obs'    => $ia_obs
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }
		    $this->session->set_flashdata('message', 'Usted ha informado su pr&oacute;ximo alquiler correctamente.');
		    redirect('Reclamos/Alquileres', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Reclamos/Alquileres', $this->data);
		}
	    }
	}











	function Reclamo(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
			$this->session->set_flashdata('message', 'Accion no permitida');
			redirect('Auth', 'refresh');
		}else{
			$this->form_validation->set_rules('id', 'Usuario', 'required');
			$this->form_validation->set_rules('ptv_id', 'Barrio', 'required');
			$this->form_validation->set_rules('ufd', 'Unidad', 'required');
//			$this->form_validation->set_rules('categoria', 'Categoria', 'required');
//			$this->form_validation->set_rules('prioridad', 'Prioridad', 'required');
			$this->form_validation->set_rules('asunto', 'Asunto', 'required');
			$this->form_validation->set_rules('descripcion', 'Descripcion', 'required');

            		$config['upload_path']          = './uploads/reclamos/';
            		$config['allowed_types']        = 'jpg|jpeg|gif|png';
            		$config['max_size']             = 10240;
            		$this->load->library('upload', $config);
            		$this->load->library('image_lib');
			$inf_file="";



			$file="";
			//var_dump($this->input->post());exit;
		    if ($this->form_validation->run() === TRUE){
			if(isset($_FILES)){
			    if ($this->upload->do_upload('file_reclamo')) {
				$upload_data = $this->upload->data();
				$data_ary = array(
				    'title'     => $upload_data['client_name'],
				    'file'      => $upload_data['file_name'],
				    'width'     => $upload_data['image_width'],
				    'height'    => $upload_data['image_height'],
				    'type'      => $upload_data['image_type'],
				    'size'      => $upload_data['file_size'],
				    'path'      => $upload_data['full_path'],
				    'date'      => time(),
				);
				$configer =  array(
            			    'image_library'   => 'gd2',
            			    'source_image'    =>  $upload_data['full_path'],
            			    'maintain_ratio'  =>  TRUE,
            			    'width'           =>  600,
            			    'height'          =>  480,
            			);
            			$this->image_lib->clear();
            			$this->image_lib->initialize($configer);
            			$this->image_lib->resize();
				$data = array('upload_data' => $upload_data);
				$file=$data_ary['path'];
			    }else{
				if($_FILES['file_reclamo']['error'] != 4){
				    $error = array('error' => $this->upload->display_errors());
				    $new_data=array(
					'pestania_activa'=>'reclamo',
					'message'=>$error
				    );
				    $this->session->set_flashdata($new_data);
				    redirect('reclamos', $this->data);
				}
			    }
			}
					$barrio=$this->input->post('ptv_id');
					$ufd = $this->input->post('ufd');
					$categoria = 5;
					$prioridad = 3;
					$asunto = $this->input->post('asunto');
					$descripcion = $this->input->post('descripcion');

					$descripcion=str_replace("“","\"",$descripcion);
					$descripcion=str_replace("”","\"",$descripcion);
					$descripcion=str_replace("‘","\'",$descripcion);
					$descripcion=str_replace("’","\'",$descripcion);
					$descripcion=utf8_encode($descripcion);


					$asunto=str_replace("“","\"",$asunto);
					$asunto=str_replace("”","\"",$asunto);
					$asunto=str_replace("‘","\'",$asunto);
					$asunto=str_replace("’","\'",$asunto);
					$asunto=utf8_encode($asunto);


					$usmail=$user->username;

					$anio=date("Y");
					$in_codemp=$this->Sec_model->get_codemp($barrio);
					$codigo=$this->Reclamos_model->get_codigo_incidencia($anio);

					$destinatario = $this->Reclamos_model->destinRecl();
					$destinatario = $destinatario[0]->vari_valor;
					$tabla1='incidencias';
					$datos1=array(
						'in_codemp'=> $in_codemp,
						'in_idptov'=> $barrio,
						'in_idcopr' => $ufd,
						'in_mail'    => $usmail,
						'in_asunto'    => $asunto,
						'in_estado'    => 1,
						'in_visibilidad'    => 1,
						'in_categoria'    => $categoria,
						'in_anio'    => $anio,
						'in_codigo'    => $codigo,
					);
					if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
						echo $this->db->last_query();
						exit;
					}else{
					    $in_id=$this->db->insert_id('incidencias_in_id_seq');
					    $tabla2='operincid';
					    $datos2=array(
						'oi_idinc'=> $in_id,
						'oi_operal'=> $destinatario,
						'oi_operasign' => $destinatario,
						'oi_prioridad'    => $prioridad,
						'oi_observ'    => $descripcion,
						'oi_userweb'    => $user->id,
						'oi_estado'    => 1,
					    );
					    if($this->Sec_model->insert($tabla2,$datos2) == FALSE){
						echo $this->db->last_query();
						exit;
					    }
					    if($file){
						$tabla3='imgincid';
						$datos3=array(
						    'img_idinc'=> $in_id,
						    'img_file'    => $file,
						);
						if($this->Sec_model->insert($tabla3,$datos3) == FALSE){
						    echo $this->db->last_query();
						    exit;
						}
					    }
					}
					$this->session->set_flashdata('message', 'Usted ha cargado el reclamo n&uacute;mero '.$codigo.'/'.$anio.'.');

					if($categoria==5 || $categoria==6){
					    /* ----- PARA ENVIAR MAIL -------*/
					    $barrio_n=$this->Sec_model->ver_barrios($barrio)->ptv_nombre;
					    $ufd_unifun= $this->Sec_model->get_cop_unifun($ufd);
					    $asunto="Reclamo Realizado - $asunto";
					    $descripcion=utf8_decode($descripcion);
					    $mensaje = "El usuario $user->username de la UF $ufd_unifun del barrio $barrio_n reclama: <BR /> $descripcion";
					    $to_mail=array("consejo@lostroncoscc.com.ar","intendencia@lostroncoscc.com.ar");
					    if($file) $this->sendmail_adj($to_mail,$asunto,$mensaje,$file);
					    else $this->sendmail($to_mail,$asunto,$mensaje);
					}else if($categoria>=8){
					    $barrio_n=$this->Sec_model->ver_barrios($barrio)->ptv_nombre;
					    $ufd_unifun= $this->Sec_model->get_cop_unifun($ufd);
					    $asunto="Reclamo Realizado - $asunto";
					    $descripcion=utf8_decode($descripcion);
					    $mensaje = "El usuario $user->username de la UF $ufd_unifun del barrio $barrio_n reclama: <BR /> $descripcion";
					    $to_mail=array("intendencia@lostroncoscc.com.ar");
					    if($file) $this->sendmail_adj($to_mail,$asunto,$mensaje,$file);
					    else $this->sendmail($to_mail,$asunto,$mensaje);
					}
//					exit();
					redirect('Reclamos', 'refresh');
			}else{
				$this->session->set_flashdata('message', validation_errors());
				redirect('Reclamos', $this->data);
			}
		}

	}


	function ActualizarReclamo(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
			$this->session->set_flashdata('message', 'Accion no permitida');
			redirect('Auth', 'refresh');
		}else{
			$this->form_validation->set_rules('id', 'Usuario', 'required');
			$this->form_validation->set_rules('in_id', 'Reclamo', 'required');
			$this->form_validation->set_rules('descripcion', 'Descripcion', 'required');

			//var_dump($this->input->post());exit;
		    if ($this->form_validation->run() === TRUE){
					$in_id = $this->input->post('in_id');
					$prioridad = $this->input->post('prioridad');
					$descripcion = $this->input->post('descripcion');
					$destinatario = $this->Reclamos_model->destinRecl();
					$destinatario = $destinatario[0]->vari_valor;

					$tabla1='incidencias';
					$datos1=array(
						'in_estado'=> 1,
					);
					if($this->Sec_model->update_p($tabla1,"in_id",$in_id,$datos1) == FALSE){
						echo $this->db->last_query();
						exit;
					}else{
					    $tabla2='operincid';
					    $datos2=array(
						'oi_idinc'=> $in_id,
						'oi_operal'=> $destinatario,
						'oi_operasign' => $destinatario,
						'oi_prioridad'    => $prioridad,
						'oi_observ'    => $descripcion,
						'oi_userweb'    => $user->id,
						'oi_estado'    => 1,
					    );
					    if($this->Sec_model->insert($tabla2,$datos2) == FALSE){
						echo $this->db->last_query();
						exit;
					    }
					}
					$this->session->set_flashdata('message', 'Usted ha abierto el reclamo nuevamente.');
					$reclamo=$this->Reclamos_model->get_reclamo($in_id);
					$codigo=$reclamo[0]->in_codigo;
					$anio=$reclamo[0]->in_anio;
					$asunto=$reclamo[0]->in_asunto;
					$categoria=$reclamo[0]->in_categoria;
					$ufd=$reclamo[0]->in_idcopr;
					if($ufd) $ufd_unifun= $this->Sec_model->get_cop_unifun($ufd);

					$asunto="Reclamo Reabierto - $asunto";
					$descripcion=utf8_decode($descripcion);
					$mensaje = "El usuario $user->username de la UF $ufd_unifun abrio nuevamente el reclamo $codigo / $anio de asunto $asunto y agrega: <BR /> $descripcion";
					if($categoria==5 || $categoria==6){
					    $to_mail=array("consejo@lostroncoscc.com.ar","intendencia@lostroncoscc.com.ar");
					    $this->sendmail($to_mail,$asunto,$mensaje);
					}else if($categoria>=8){
					    $to_mail=array("intendencia@lostroncoscc.com.ar");
					    $this->sendmail($to_mail,$asunto,$mensaje);
					}
					redirect('Reclamos', 'refresh');
			}else{
				$this->session->set_flashdata('message', validation_errors());
				redirect('Reclamos', $this->data);
			}
		}

	}






	function del_infalq($id){
		
		$tabla1='infalquiler';
		$datos1=array(
		    'ia_estado'=> 9,
		);
		if($this->Sec_model->update_p($tabla1,"ia_id",$id,$datos1) == FALSE){
		    echo $this->db->last_query();
		    exit;
		}
		redirect('Reclamos/Alquileres', 'refresh');
	}









	function ContactoActivi(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
		    $this->session->set_flashdata('message', 'Accion no permitida');
		    redirect('Auth', 'refresh');
		}else{
		    $this->form_validation->set_rules('id', 'Usuario', 'required');
		    $this->form_validation->set_rules('asunto', 'Asunto', 'required');
		    $this->form_validation->set_rules('descripcion', 'Mensaje', 'required');

		    if ($this->form_validation->run() === TRUE){
			$nombre = $this->input->post('nombre');
			$reply = $this->input->post('correos');
			$asunto = $this->input->post('asunto');
			$ufs = $this->input->post('ufs');
			$descripcion = $this->input->post('descripcion');

			$mensaje="<b> El Sr. $nombre de la/s UF/s $ufs se contacta por: </b> <BR /> $descripcion";

			$to_mail=array("consejoactividades@lostroncoscc.com.ar");
			$this->sendmail_reply($to_mail,$asunto,$mensaje,$reply,$nombre);
			redirect('Reclamos/activi', 'refresh');
		    }else{
			$this->session->set_flashdata('message', validation_errors());
			redirect('Reclamos/activi', $this->data);
		    }
		}

	}


	function ContactoConsejo(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
		    $this->session->set_flashdata('message', 'Accion no permitida');
		    redirect('Auth', 'refresh');
		}else{
		    $this->form_validation->set_rules('id', 'Usuario', 'required');
		    $this->form_validation->set_rules('asunto', 'Asunto', 'required');
		    $this->form_validation->set_rules('descripcion', 'Mensaje', 'required');

		    if ($this->form_validation->run() === TRUE){
			$nombre = $this->input->post('nombre');
			$reply = $this->input->post('correos');
			$asunto = $this->input->post('asunto');
			$ufs = $this->input->post('ufs');
			$descripcion = $this->input->post('descripcion');

			$mensaje="<b> El Sr. $nombre de la/s UF/s $ufs se contacta por: </b> <BR /> $descripcion";

			$to_mail=array("consejo@lostroncoscc.com.ar","ado.lostroncos@gmail.com");
			$this->sendmail_reply($to_mail,$asunto,$mensaje,$reply,$nombre);
			redirect('Reclamos/consejo', 'refresh');
		    }else{
			$this->session->set_flashdata('message', validation_errors());
			redirect('Reclamos/consejo', $this->data);
		    }
		}

	}




	function ContactoSeguridad(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
		    $this->session->set_flashdata('message', 'Accion no permitida');
		    redirect('Auth', 'refresh');
		}else{
		    $this->form_validation->set_rules('id', 'Usuario', 'required');
		    $this->form_validation->set_rules('asunto', 'Asunto', 'required');
		    $this->form_validation->set_rules('descripcion', 'Mensaje', 'required');

		    if ($this->form_validation->run() === TRUE){
			$nombre = $this->input->post('nombre');
			$reply = $this->input->post('correos');
			$asunto = $this->input->post('asunto');
			$ufs = $this->input->post('ufs');
			$descripcion = $this->input->post('descripcion');

			$mensaje="<b> El Sr. $nombre de la/s UF/s $ufs se contacta por: </b> <BR /> $descripcion";

			$to_mail=array("seguridad@lostroncoscc.com.ar");
			$this->sendmail_reply($to_mail,$asunto,$mensaje,$reply,$nombre);
			redirect('Reclamos/seguridad', 'refresh');
		    }else{
			$this->session->set_flashdata('message', validation_errors());
			redirect('Reclamos/seguridad', $this->data);
		    }
		}

	}














	function sendmail($usermail,$subject,$sms){
	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'No Responder');
	    $this->email->to($usermail);
//	    $this->email->bcc('fl.catware@gmail.com'); 
	    $this->email->subject($subject);
	    $this->email->message($sms);
	    if ($this->email->send())
		$ok=1;
//		$this->session->set_flashdata('message', 'Se ha enviado el e-mail.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }
	}


	function sendmail_reply($usermail,$subject,$sms,$replyto,$nombre){

	    $reply=explode(" ; ",$replyto);

	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'Los Troncos CC.');
	    $this->email->reply_to($reply[0], $nombre);
	    $this->email->to($usermail);
//	    $this->email->bcc('fl.catware@gmail.com'); 
	    $subject=utf8_decode($subject);
	    $this->email->subject($subject);
	    $sms=utf8_decode($sms);
	    $this->email->message($sms);
	    if ($this->email->send())
		$this->session->set_flashdata('message', 'Se ha contactado correctamente.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }

	}




	function sendmail_adj($usermail,$subject,$sms,$file){
	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'No Responder');
	    $this->email->to($usermail);
//	    $this->email->bcc('fl.catware@gmail.com'); 
	    $this->email->subject($subject);
	    $this->email->message($sms);
	    $this->email->attach($file);
	    if ($this->email->send())
		$ok=1;
//		$this->session->set_flashdata('message', 'Se ha enviado el e-mail.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }
	}








	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}