<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Profesor extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Director_model','Sec_model','Profesor_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));



		$admins = array(1);
		$this->data['admins'] = $admins;
		$this->data['barrio'] = $this->Director_model->getBarrio();
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list






/* ************************ INICIO PROFESORES ******************* */


	public function idxprofesores(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;

		$profe=$this->Profesor_model->get_profe_by_user($user->id);
		if($profe){
		    $id=$profe->pf_id;
		    $gruposActivi=$this->Profesor_model->get_gruposActivi($barrio,$id);
		    if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;
		    $profe=$this->Director_model->get_profe($id);
		    if($profe) $this->data['profe'] = $profe;
		}


		$this->_render_page('profesor/nprofe', $this->data);
	    }

	}



	function EditProfe(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$tables = $this->config->item('tables','ion_auth');
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('nombre', 'Nombre', 'required');
		$this->form_validation->set_rules('telefono', 'Telefono', 'required');
		$this->form_validation->set_rules('pass', 'Contrase&ntilde;a', 'required');


		if ($this->form_validation->run() === TRUE){

	            $password = $this->input->post('pass');
	            $user_id = $this->input->post('pf_userid');
	            $pf_id = $this->input->post('pf_id');


		    $nombre = $this->input->post('nombre');
		    $tel = $this->input->post('telefono');

		    if($password){
			$query = $this->db->select('id, password, salt')
		                  ->where('id', $user_id)
		                  ->limit(1)
		    			  ->order_by('id', 'desc')
		                  ->get('users');

			$pfuser = $query->row();
			$hashed_new_password  = $this->ion_auth->hash_password($password, $pfuser->salt);
			$data = array(
			    'password' => $hashed_new_password,
			    'remember_code' => NULL,
			);
			$successfully_changed_password_in_db = $this->db->update('users', $data, array('id' => $user_id));
		    }

		    $tabla1='profesores';
		    $datos1=array(
			'pf_nombre'=> $nombre,
			'pf_tel'    => $tel,
		    );
		    if($this->db->update($tabla1,$datos1,array('pf_id' => $pf_id)) == FALSE){
			echo $this->db->last_query();
			exit;
		    }
		    $this->session->set_flashdata('message', 'Usted ha modificado al profesor en el sistema.');
		    redirect('Profesor/idxprofesores', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Profesor/idxprofesores', $this->data);
	        }
	    }
	}


/* ************************ FIN PROFESORES ******************* */



/* ************************ VEO TOT ALUMNOS ******************* */

	public function idxtodos(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;

		$profe=$this->Profesor_model->get_profe_by_user($user->id);
		$idPf=$profe->pf_id;
		$gruposActivi=$this->Profesor_model->get_gruposActivi($barrio,$idPf);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;
		$this->data['pf_id']=$idPf;

		$this->_render_page('profesor/totalumno', $this->data);
	    }

	}



/* ************************ FIN ALUMNOS ******************* */




/************************************* ABM ACTIVIDADES ****************************************************/


	public function idxactivi($id = NULL){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;

		$profe=$this->Profesor_model->get_profe_by_user($user->id);
		$idPf=$profe->pf_id;
		$this->data['idProfe'] = $idPf;

		$gruposActivi=$this->Profesor_model->get_gruposActivi($barrio,$idPf);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		if($id){
		    $id = $this->Sec_model->decrypt($id);
		    $activiActual=$this->Director_model->get_activi($barrio,$id);
		    if($activiActual){
			$this->data['activiActual'] = $activiActual[0];
		    }
		}

		$map = $this->Director_model->iterate();
		$this->data['map'] = $map;
		$dir = $this->Director_model->dirit();
		$dir=base_url().$dir;
		$this->data['dir'] = $dir;

		$this->_render_page('profesor/nactivi', $this->data);
	    }

	}

	function NuevaActivi(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('dias', 'Dia de la Actividad', 'required');
		$this->form_validation->set_rules('horario', 'Hora de la Actividad', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();
		    $nombre = $this->input->post('grupo');
		    $nomGr=$this->Director_model->get_gruposActivi($barrio, $nombre);
		    $nomGr=$nomGr[0]->ga_nombre;
		    $dias = $this->input->post('dias');
		    $horarios = $this->input->post('horario');
		    $imagen = $this->input->post('imagen');
		    $informa = $this->input->post('informa');
		    $activi = $this->input->post('activi');


		    $tabla1='activi';
		    $datos1=array(
			'ac_idptov'=> $barrio,
			'ac_idgpo'=> $nombre,
			'ac_fecha'=> $dias,
			'ac_activi'=> $activi,
			'ac_img'=> $imagen,
			'ac_fecha'=> $dias,
			'ac_iduser'=> $user->id,
			'ac_hora'=> $horarios
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }

		    if($informa){
			$act_id=$this->db->insert_id('activi_ac_id_seq');
			$dirgrab=$this->GenerImg($imagen,$nomGr,$horarios,$dias,$activi,$act_id);
			$datos2=array(
			    'ac_dirgrab' => $dirgrab
			);
			if($this->db->update($tabla1,$datos2,array('ac_id' => $act_id)) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}
		    }

		    $this->session->set_flashdata('message', 'Usted ha cargado la actividad correctamente. Preceda a la brevedad a tomar lista.');
		    redirect('Profesor/idxactivi', 'refresh');


		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Profesor/idxactivi', $this->data);
		}
	    }
	}


	function GenerImg($imagen,$nomGr,$horarios,$dias,$activi,$id){
	    $dir = $this->Director_model->dirit();
	    $dir=base_url().$dir;
	    $imgx=$dir.$imagen;

	    $nombre_archivo = $imgx;
	    $im = ImageCreateTruecolor(640, 480);
	    $im1 = ImageCreateFromJpeg($nombre_archivo);
	    list($ancho, $alto) = GetImageSize($nombre_archivo);
	    ImageCopyResized  ( $im, $im1, 0, 0, 0, 0, 640, 480, $ancho, $alto ); 
	    ImageDestroy($im1);

	    $color = ImageColorAllocateAlpha($im, 0, 0, 0, 0);
	    $rojo     = imagecolorallocatealpha($im, 255, 255, 255, 75);
	    $fuente = realpath('/opt/www/html/lostroncoscc.com.ar/ci/assets/css/raleway.ttf');

	    $txt1="Grupo: $nomGr";
	    $txt2="Da: $dias";
	    $txt3="Horario: $horarios";
	    $txt4="Actividad: $activi";
	    $largo1=imagettfbbox(28,0,$fuente,$txt1)[4];
	    $largo2=imagettfbbox(22,0,$fuente,$txt2)[4];
	    $largo3=imagettfbbox(22,0,$fuente,$txt3)[4];
	    $corte=53;
	    $strlen=strlen($txt4);
	    if($strlen>=$corte){
		$split=explode(" ",$txt4);
		$ag=array();
		$m=0;
		$res=$res1="";
		foreach($split as $st){
		    if(!$res1) $res1=$st; else $res1.=" $st";
		    if(strlen($res1)>$corte){
			$ag[$m]=$res;
			$m++;
			$res=$res1="$st";
		    }else
			if(!$res) $res=$st; else $res.=" $st";
		}
		$ag[$m]=$res;
		$j=4;
		foreach($ag as $a){
		    ${'txt'.$j}=$a;
		    $j++;
		}
		$alto=30*$m;
	    }else{
		$alto=0;
		$txt5=$ag=NULL;
	    }
	    if(strlen($txt4)>strlen($txt5)) $largo4=imagettfbbox(16,0,$fuente,$txt4)[4];
	    else $largo4=imagettfbbox(16,0,$fuente,$txt5)[4];

	    ImageFilledRectangle($im, 50, 40, 50+$largo1, 85, $rojo);
	    ImageFilledRectangle($im, 50, 95, 50+$largo2, 130, $rojo);
	    ImageFilledRectangle($im, 50, 140, 50+$largo3, 175, $rojo);
	    ImageFilledRectangle($im, 50, 185, 50+$largo4, 225+$alto, $rojo);
	    ImageTtfText($im, 28, 0, 50, 80, $color, $fuente, $txt1);
	    ImageTtfText($im, 22, 0, 50, 125, $color, $fuente, $txt2);
	    ImageTtfText($im, 22, 0, 50, 170, $color, $fuente, $txt3);
	    ImageTtfText($im, 16, 0, 50, 215, $color, $fuente, $txt4);
	    if($ag){
		$k=30;
		for($a=1;$a<=$m;$a++){
		    $s=$a+4;
		    ImageTtfText($im, 16, 0, 50, 215+$k, $color, $fuente, ${'txt'.$s});
		    $k+=30;
		}
	    }

	    $dirgrab = '/opt/www/html/lostroncoscc.com.ar/ci/uploads/crimg/p'.$id.'.jpg';
	    ImageJpeg($im,$dirgrab);
	    ImageDestroy($im);
	    return $dirgrab;
	}





	function EditarActivi(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('dias', 'Dia de la Actividad', 'required');
		$this->form_validation->set_rules('horario', 'Hora de la Actividad', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();

		    $dias = $this->input->post('dias');
		    $horarios = $this->input->post('horario');

		    $idActivi = $this->input->post('ac_id');

		    $tabla1='activi';
		    $datos1=array(
			'ac_fecha'=> $dias,
			'ac_hora'=> $horarios,
		    );
		    if($this->db->update($tabla1,$datos1,array('ac_id' => $idActivi)) == FALSE){
			echo $this->db->last_query();
			exit;
		    }

		    $this->session->set_flashdata('message', 'Usted ha actualizado la actividad correctamente.');
		    redirect('Profesor/idxactivi', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Profesor/idxactivi', $this->data);
		}
	    }
	}




	function delActivi($idActivi){

	    $idActivi=$this->Sec_model->decrypt($idActivi);

	    $data = array(
		'ac_estado' => '999',
	    );
	    $this->db->where('ac_id' ,$idActivi);
	    $this->db->update('activi' , $data);


	    redirect('Profesor/idxactivi', $this->data);

	}


/************************************* FIN ABM ACTIVIDADES ****************************************************/








/************************************* ABM ASISTENCIA ****************************************************/


	public function Asistencia($idActivi){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;

		$profe=$this->Profesor_model->get_profe_by_user($user->id);
		$idPf=$profe->pf_id;
		$this->data['idProfe'] = $idPf;


		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		if($idActivi){
		    $id = $this->Sec_model->decrypt($idActivi);
		    $activiActual=$this->Director_model->get_activi($barrio,$id);
		    if($activiActual){
			$grupo= $this->Director_model->tipo_grupo($activiActual[0]->ac_idgpo);
			$this->data['grupoActivi'] = $grupo;
			$this->data['activiActual'] = $activiActual[0];
			$alumnosGrupo = $this->Director_model->asistencia_por_grupo($id,2);
			if($alumnosGrupo){
			    $this->data['alumnosGrupo'] = $alumnosGrupo;
			    $alumnosGrupos = $this->Director_model->asistencia_por_grupo($id,1);
			    if($alumnosGrupos){
				$cantPresentes=count($alumnosGrupos);
				$this->data['cantPresentes'] = $cantPresentes;
			    }
			}else{
			    $alumnosGrupo = $this->Director_model->asistencia_por_grupo($id,1);
			    if(!$alumnosGrupo){
				$alumnosGrupo = $this->Director_model->alumnos_por_grupo($activiActual[0]->ga_id);
				if($alumnosGrupo) $this->data['alumnosGrupo'] = $alumnosGrupo;
			    }else{
				$cantPresentes=count($alumnosGrupo);
				$this->data['cantPresentes'] = $cantPresentes;
			    }
			}
		    }
		}

		$procedExt=$this->Director_model->get_proced();
		if($procedExt) $this->data['procedext'] = $procedExt;

		$coprop=$this->Sec_model->ver_unidades_de_barrio($barrio);
		if($coprop) $this->data['coprop'] = $coprop;

		$this->_render_page('profesor/asistencia', $this->data);
	    }

	}


	public function presentismo(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;

		$profe=$this->Profesor_model->get_profe_by_user($user->id);
		$idPf=$profe->pf_id;
		$this->data['idProfe'] = $idPf;

		$gruposActivi=$this->Profesor_model->get_gruposActivi($barrio,$idPf);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$this->_render_page('profesor/presentismo', $this->data);
	    }

	}





	function TomarAsistencia(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();
		    $id = $this->input->post('ac_id');
		    $activiActual=$this->Director_model->get_activi($barrio,$id);

		    $alumnosGrupo = $this->Director_model->asistencia_por_grupo($id,2);
		    if($alumnosGrupo) $this->data['alumnosGrupo'] = $alumnosGrupo;
		    else{
			$alumnosGrupo = $this->Director_model->alumnos_por_grupo($activiActual[0]->ga_id);
			if($alumnosGrupo) $this->data['alumnosGrupo'] = $alumnosGrupo;
		    }

		    $this->Director_model->delAlumnosAusentes($id);

		    foreach($alumnosGrupo as $dato){
			$idalu = $dato->al_id;
			$asistio=2;
			if($this->input->post($idalu)) $asistio=1;

			$tabla1='asistxactivi';
			$datos1=array(
			    'aa_idalu'=> $idalu,
			    'aa_idact'=> $id,
			    'aa_asistio'=> $asistio,
			    'aa_iduser'=> $user->id
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}
		    }

		    $eId=$this->Sec_model->ecrypt($id);
//		    $this->session->set_flashdata('message', 'Usted ha cargado la actividad correctamente. Preceda a la brevedad a tomar lista.');
		    redirect('Profesor/Asistencia/'.$eId, 'refresh');
		}else{
		    $eId=$this->Sec_model->ecrypt($id);
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Profesor/Asistencia/'.$eId, 'refresh');
		}
	    }
	}


	function TomarAsistencia1(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		if ($this->form_validation->run() === TRUE){
		    $barrio=$this->Director_model->getBarrio();
		    $id = $this->input->post('ac_id');
		    $eId=$this->Sec_model->ecrypt($id);
		    $activiActual=$this->Director_model->get_activi($barrio,$id);

		    $idgf = $this->input->post('idgf');
		    if(!$idgf){
			$this->session->set_flashdata('message', 'Debe definir al menos un alumno (o propietario o inquilino).');
			redirect('Profesor/Asistencia/'.$eId, 'refresh');
		    }

		    if($idgf){
			$tabla1='asistxactivi';
			$datos1=array(
			    'aa_idalu'=> $idgf,
			    'aa_idact'=> $id,
			    'aa_asistio'=> 1,
			    'aa_iduser'=> $user->id
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}
		    }
		    redirect('Profesor/Asistencia/'.$eId, 'refresh');
		}else{
		    $eId=$this->Sec_model->ecrypt($id);
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Profesor/Asistencia/'.$eId, 'refresh');
		}
	    }
	}






	function Foreign(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();
		    $id = $this->input->post('ac_id');
		    $activiActual=$this->Director_model->get_activi($barrio,$id);

		    $asistio=1;


		    $nombre = $this->input->post('externo');
		    $proced = $this->input->post('proced');
		    $idext = $this->input->post('idext');

		    if(!$idext){
			if($proced==1) $invitadopor=$this->input->post('invitadopor');
			else $invitadopor=NULL;

			$tabla1='alexternos';
			$datos1=array(
			    'ae_idptov'=> $barrio,
			    'ae_nombre'=> $nombre,
			    'ae_proced'    => $proced,
			    'ae_invitadopor'    => $invitadopor
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}

			$ae_id=$this->db->insert_id('alexternos_ae_id_seq');
			$tabla2='alumnos';
			$datos2=array(
			    'al_idptov' => $barrio,
			    'al_ext' => $ae_id
			);
			if($this->Sec_model->insert($tabla2,$datos2) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}
			$idalu=$this->db->insert_id('alumnos_al_id_seq');
		    }else{
			$idalu=$idext;
		    }



		    $tabla1='asistxactivi';
		    $datos1=array(
			'aa_idalu'=> $idalu,
			'aa_idact'=> $id,
			'aa_asistio'=> $asistio,
			'aa_iduser'=> $user->id
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }

		    $eId=$this->Sec_model->ecrypt($id);
//		    $this->session->set_flashdata('message', 'Usted ha cargado la actividad correctamente. Preceda a la brevedad a tomar lista.');
		    redirect('Profesor/Asistencia/'.$eId, 'refresh');
		}else{
		    $eId=$this->Sec_model->ecrypt($id);
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Profesor/Asistencia/'.$eId, 'refresh');
		}
	    }
	}


	function delAlumnodeAsist($idActivi, $idAlumno){

	    $barrio=$this->Director_model->getBarrio();
	    $activiActual=$this->Director_model->get_activi($barrio,$idActivi);
	    $pertenece=$this->Director_model->alumnos_por_grupo($activiActual[0]->ac_idgpo,$idAlumno);

	    if($pertenece){
		$data = array(
		    'aa_asistio' => '2',
		);
		$this->db->where('aa_idalu' ,$idAlumno);
		$this->db->where('aa_idact' ,$idActivi);
		$this->db->update('asistxactivi' , $data);
	    }else{
		$this->db->where('aa_idalu' ,$idAlumno);
		$this->db->where('aa_idact' ,$idActivi);
		$this->db->delete('asistxactivi');
	    }

	    $id=$this->Sec_model->ecrypt($idActivi);
	    redirect('Profesor/Asistencia/'.$id, 'refresh');

	}



/************************************* FIN ABM ACTIVIDADES ****************************************************/







	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}