<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Pagos extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Pagos_model','Sec_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));



		$admins = array(1,3);
		$this->data['admins'] =array(1,3);
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
			    $this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
			    $this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
			}
		    }
		}


		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list
	public function index(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
        	$this->_render_page('body/pagos', $this->data);
	    }

	}



	function Inform_pago(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
			$this->session->set_flashdata('message', 'Accion no permitida');
			redirect('Pagos', 'refresh');
		}else{
			$this->form_validation->set_rules('id', 'Usuario', 'required');
			$this->form_validation->set_rules('ptv_id', 'Barrio', 'required');
			$this->form_validation->set_rules('ufd', 'Unidad', 'required');
			$this->form_validation->set_rules('fecha', 'Fecha', 'required');
			$this->form_validation->set_rules('importe', 'Importe', 'required|numeric');

            		$config['upload_path']          = './uploads/pagos/';
            		$config['allowed_types']        = 'jpg|jpeg|gif|png|pdf';
            		$config['max_size']             = 10240;
            		$this->load->library('upload', $config);
            		$this->load->library('image_lib');
			$inf_file="";

			//var_dump($this->input->post());exit;
		    if ($this->form_validation->run() === TRUE){
			if(isset($_FILES)){
			    if ($this->upload->do_upload('file_pago')) {
				$upload_data = $this->upload->data();
				$data_ary = array(
				    'title'     => $upload_data['client_name'],
				    'file'      => $upload_data['file_name'],
				    'width'     => $upload_data['image_width'],
				    'height'    => $upload_data['image_height'],
				    'type'      => $upload_data['image_type'],
				    'size'      => $upload_data['file_size'],
				    'path'      => $upload_data['full_path'],
				    'date'      => time(),
				);

				$ext=pathinfo($data_ary['path'], PATHINFO_EXTENSION);

				if($ext!="pdf"){
				    $configer =  array(
            				'image_library'   => 'gd2',
            				'source_image'    =>  $upload_data['full_path'],
            				'maintain_ratio'  =>  TRUE,
            				'width'           =>  800,
            				'height'          =>  600,
            			    );
            			    $this->image_lib->clear();
            			    $this->image_lib->initialize($configer);
            			    $this->image_lib->resize();
				}
				$data = array('upload_data' => $upload_data);
				$inf_file=$data_ary['path'];
			    }else{
				if($_FILES['file_pago']['error'] != 4){
				    $error = array('error' => $this->upload->display_errors());
				    $new_data=array(
					'pestania_activa'=>'infopago',
					'message'=>$error
				    );
				    $this->session->set_flashdata($new_data);
				    redirect('Auth', $this->data);
				}
			    }
			}
			$tabla='infdep';
			$barrio=$this->input->post('ptv_id');
			$barrio_n=$this->Sec_model->ver_barrios($barrio)->ptv_nombre;
			$ufd = $this->input->post('ufd');
			$ufd_unifun= $this->Sec_model->get_cop_unifun($ufd);
			$bank = $this->input->post('bank');
			$fecha = $this->input->post('fecha');
			$importe = $this->input->post('importe');
			$observacion = $this->input->post('observacion');
			$usmail=$user->username;
			$asunto="Informe de Pago";
			$mensaje = "El usuario $user->username informa que ha realizado un pago en el banco $bank, el dia $fecha por un importe de $importe para la UF $ufd del barrio $barrio_n";
//					$destinatario = $this->Sec_model->destinPago();
//					$destinatario = $destinatario[0]->vari_valor;
			$datos=array(
				'inf_idptov'=> $barrio,
				'inf_idcopr' => $ufd,
				'inf_fecdep'    => $fecha,
				'inf_importe'    => $importe,
				'inf_banco'    => $bank,
				'inf_obs'    => $observacion,
				'inf_mail'    => $usmail,
				'inf_file'    => $inf_file,
			);
			if($this->Sec_model->insert($tabla,$datos) == FALSE){
				echo $this->db->last_query();
				exit;
			}
			$this->session->set_flashdata('message', 'Se ha informado su pago correctamente.');
//					$this->sendmail($usmail,$asunto,$mensaje);
			redirect('Pagos', 'refresh');
		    }else{
			$this->session->set_flashdata('message', validation_errors());
			redirect('Pagos', $this->data);
		    }
		}

	}






	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}