<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Fiestas extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Fiestas_model','Sec_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));



		$admins = array(1,3);
		$this->data['admins'] =array(1,3);
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->getBarrio();
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
			    $this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
			    $this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
			}
		    }
		}

		$hayFiesta=$this->get_fiesta();
		if($hayFiesta) $this->data['fiesta']=$hayFiesta;
		else $this->data['fiesta']=NULL;


		$elBarrio=$this->Sec_model->id_barrios_user($user->id)[0];
		if($elBarrio) $cops=$this->Sec_model->unidades_barrio_prop($user->id,$elBarrio);
		else $cops=array();


		if($cops){
		    $this->data['cops']=$cops;
		}




		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list
	public function index(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{

		$user=$this->ion_auth->user()->row();

		$hayFiesta=$this->get_fiesta();
		if($hayFiesta) $this->data['fiesta']=$hayFiesta;
		else $this->data['fiesta']=NULL;


		$elBarrio=$this->Sec_model->getBarrio();
		if($elBarrio) $cops=$this->Sec_model->unidades_barrio_prop($user->id,$elBarrio);
		else $cops=array();


		foreach($hayFiesta as $fiesta){

		    if($cops){
			$this->data['cops']=$cops;
			foreach($cops as $coprop){
			    if($fiesta->fi_mayores==2) $grupof=$this->Fiestas_model->get_grupof($coprop->cop_id,$user->id,$fiesta->fi_id);
			    else $grupof=$this->Fiestas_model->get_mayores($coprop->cop_id,$user->id,$fiesta->fi_id);
			    if($grupof) $this->data['gf_'.$coprop->cop_id.'fi_'.$fiesta->fi_id]=$grupof;
			}
		    }


		    $hayMenu = $this->Fiestas_model->get_menues($elBarrio,$fiesta->fi_id);
		    if($hayMenu) $this->data['menues'.$fiesta->fi_id]=$hayMenu;
		    else $this->data['menues'.$fiesta->fi_id]=NULL;

		    $canti=$this->Fiestas_model->cant_invitados($fiesta->fi_id);
		    if($canti) $this->data['cantGuests'.$fiesta->fi_id]=$canti[0]->canti;
		    else $this->data['cantGuests'.$fiesta->fi_id]=0;
		}
        	$this->_render_page('body/fiestas', $this->data);
	    }

	}


	function get_menues(){
	    $options = "";
    	    if ($this->input->post('ptv_id')) {
    		$ptv_id = $this->input->post('ptv_id');
    		$fi_id = $this->input->post('fi_id');
        	$unidades = $this->Fiestas_model->get_menues($ptv_id,$fi_id);
        	if($unidades == FALSE){
				echo "<option>--</option>";
        	}else{
		    echo "<option value=\"0\"> Seleccione informacion adicional </option>";
            	    foreach($unidades as $unidad){
			if($unidad->mxf_estado==2){
			?>
			<option disabled value="<?php echo $unidad->mxf_id;?>"><?php echo $unidad->mxf_nombre;?></option>
		    <?php }else{ ?>
			<option value="<?php echo $unidad->mxf_id;?>"><?php echo $unidad->mxf_nombre;?></option>
		    <?php } }
		}
            }			
	}

	function get_fiesta(){
	    $options = "";
    		$ptv_id = $this->data['el_primer_barrio'];
        	$unidades = $this->Fiestas_model->get_fiesta($ptv_id);
	    return $unidades;
	}





	function nuevoInvitado(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
			$this->session->set_flashdata('message', 'Accion no permitida');
			redirect('Auth', 'refresh');
		}else{


			$fiesta = $this->input->post('fiesta');
			$hayFiesta=$this->Fiestas_model->get_fiesta_id($fiesta);
			$elBarrio=$this->Sec_model->getBarrio();

			$hayMenu = $this->Fiestas_model->get_menues($elBarrio,$fiesta);
			if($hayMenu) $esConMenu=1;
			else $esConMenu=NULL;

			if($hayFiesta[0]->fi_vacantes>1) $esConVacantes=1;
			else $esConVacantes=NULL;


			$this->form_validation->set_rules('id', 'Usuario', 'required');
			$this->form_validation->set_rules('ufd', 'Unidad', 'required');
			if($esConMenu==1) $this->form_validation->set_rules('menu', 'Info Adicional', 'required|greater_than[0]');
			$this->form_validation->set_rules('nombre', 'Nombre y Apellido', 'required');

			//var_dump($this->input->post());exit;

		    if ($this->form_validation->run() === TRUE){

			$ufd = $this->input->post('ufd');
			if($esConMenu==1) $menu = $this->input->post('menu');
			$nombre = $this->input->post('nombre');

			if($esConVacantes==1){
			    $canti=$this->Fiestas_model->cant_invitados($hayFiesta[0]->fi_id);
			    if($canti) $cantGuests=$canti[0]->canti;
			    else $cantGuests=0;
			    $cantGuests++;
			    $vacantes=$hayFiesta[0]->fi_vacantes;
			}else{
			    $cantGuests=0;
			    $vacantes=99999;
			}
			if($vacantes>=$cantGuests){

			    $tabla1='invxfiesta';
			    $datos1=array(
				'ixf_idfiesta'=> $fiesta,
				'ixf_idcopr' => $ufd,
				'ixf_nombre'    => $nombre,
			    );
			    if($esConMenu==1) $datos1['ixf_menu'] = $menu;

			    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			    }else{
				$this->session->set_flashdata('message', 'Usted ha cargado invitado correctamente.');
				redirect('Fiestas', 'refresh');
			    }
			}else{
			    $this->session->set_flashdata('message', 'No hay vacantes disponibles para el invitado.');
			    redirect('Fiestas', 'refresh');
			}
		    }else{
			$this->session->set_flashdata('message', validation_errors());
			redirect('Fiestas', $this->data);
		    }
		}
	}



	function confirmoGrupo(){
		
		$user=$this->ion_auth->user()->row();
		$error=2;

		if(!$this->input->post('id') == $user->id){
			$this->session->set_flashdata('message', 'Accion no permitida');
			redirect('Auth', 'refresh');
		}else{
		    $this->form_validation->set_rules('gf_idcopr', 'Copropietario', 'required');
		    if ($this->form_validation->run() === TRUE){

			$fiesta = $this->input->post('fiesta');
			$hayFiesta=$this->Fiestas_model->get_fiesta_id($fiesta);
			$elBarrio=$this->Sec_model->getBarrio();

			$hayMenu = $this->Fiestas_model->get_menues($elBarrio,$fiesta);
			if($hayMenu) $esConMenu=1;
			else $esConMenu=NULL;

			if($hayFiesta[0]->fi_vacantes>1) $esConVacantes=1;
			else $esConVacantes=NULL;

			$gf_idcopr=$this->input->post('gf_idcopr');
			if($hayFiesta[0]->fi_mayores==2) $grupof=$this->Fiestas_model->get_grupof($gf_idcopr,$user->id,$hayFiesta[0]->fi_id);
			else $grupof=$this->Fiestas_model->get_mayores($gf_idcopr,$user->id,$hayFiesta[0]->fi_id);
			if(isset($grupof)){
			    foreach($grupof as $gf){

				$nombre=$gf->gf_nombre;
				$idgf=$gf->gf_id;
				if($esConMenu==1){ $menu = $this->input->post('menu'.$idgf); }
				$asiste = $this->input->post('asiste'.$idgf);
//				$asistegf = $this->input->post('asiste');
//				if($asistegf==$idgf) $asiste=1; else $asiste=2;
				if(!$asiste) $asiste=2;

				if($user->tipo==1) $inq=0; else $inq=1;

 				if($esConMenu==1){
				    if($asiste==1 && $menu){
					$tabla1='invxfiesta';
					$datos1=array(
					    'ixf_idfiesta'=> $fiesta,
					    'ixf_idcopr' => $gf_idcopr,
					    'ixf_nombre'    => $nombre,
					    'ixf_menu'    => $menu,
					    'ixf_idgf'    => $idgf,
					    'ixf_inq'    => $inq,
					);
				
					if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
					    echo $this->db->last_query();
					    exit;
					}
				    }else if(!$menu && $asiste==1){
					$this->session->set_flashdata('message', 'Revise por favor los datos cargados, no todo se ha grabado correctamente.');
					$error=1;
				    }
				}else{
				    if($esConVacantes==1){
					$canti=$this->Fiestas_model->cant_invitados($hayFiesta[0]->fi_id);
					if($canti) $cantGuests=$canti[0]->canti;
					else $cantGuests=0;
					$cantGuests++;
					$vacantes=$hayFiesta[0]->fi_vacantes;
				    }else{
					$cantGuests=0;
					$vacantes=99999;
				    }
					if($vacantes>=$cantGuests && $asiste==1){
					    $tabla1='invxfiesta';
					    $datos1=array(
						    'ixf_idfiesta'=> $fiesta,
						    'ixf_idcopr' => $gf_idcopr,
						    'ixf_nombre'    => $nombre,
						    'ixf_idgf'    => $idgf,
						    'ixf_inq'    => $inq,
					    );
					    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
						echo $this->db->last_query();
						exit;
					    }
					}else if($asiste==1){
					    $this->session->set_flashdata('message', 'Revise por favor los datos cargados, no todo se ha grabado correctamente, o no hay vacantes para todos.');
					    $error=1;
					}
				}
			    }
			}
			if($error==2) $this->session->set_flashdata('message', 'Usted ha cargado asistentes correctamente.');
			redirect('Fiestas', 'refresh');
		    }else{
			$this->session->set_flashdata('message', validation_errors());
			redirect('Fiestas', $this->data);
		    }
		}







	}








	function delInvitado($id){

		$id=$this->Sec_model->decrypt($id);

		$data = array(
			'ixf_estado' => 2,
		);
		if($this->Sec_model->update_p('invxfiesta','ixf_id',$id,$data)==true){
		    redirect('Fiestas', 'refresh');
		}else{
		    $this->session->set_flashdata('message', 'ERROR');
		    redirect('Fiestas', 'refresh');
		}



	}


	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}