<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Autorizaciones extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Autorizaciones_model','Sec_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));



		$admins = array(1,3);
		$this->data['admins'] =array(1,3);
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
			    $this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
			    $this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
			}
		    }
		}


		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list
	public function index(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
        	$this->_render_page('body/autorizaciones', $this->data);
	    }

	}

	public function editar($id){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$id=$this->Sec_model->decrypt($id);

		$gxu=$this->Autorizaciones_model->get_gxu($id);
		$this->data['gxu']=$gxu[0];
		$lv=$this->Autorizaciones_model->get_last_lv($gxu[0]->gte_id);
		if($lv) $this->data['lv']=$lv[0];
        	$this->_render_page('body/edit_autorizaciones', $this->data);
	    }

	}


	public function nota($id){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$id=$this->Sec_model->decrypt($id);

		$gxu=$this->Autorizaciones_model->get_gxu($id);
		$this->data['gxu']=$gxu[0];
		$nota=$this->Autorizaciones_model->get_nota($id);
		if($nota) $this->data['nota']=$nota[0];
		else $this->data['nota']=NULL;
        	$this->_render_page('body/nota_prov', $this->data);
	    }

	}






	public function versegauto($id){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$id=$this->Sec_model->decrypt($id);
		$file=$this->Autorizaciones_model->get_lv($id);
		$this->data['file']=$file[0]->lv_fileauto;
        	$this->_render_page('body/verimg', $this->data);
	    }

	}

	public function versegart($id){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$id=$this->Sec_model->decrypt($id);
		$file=$this->Autorizaciones_model->get_gxu($id);
		$this->data['file']=$file[0]->gxu_fileart;
        	$this->_render_page('body/verimg', $this->data);
	    }

	}

	public function verfoto($id){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$id=$this->Sec_model->decrypt($id);
		$file=$this->Autorizaciones_model->get_gte($id);
		$this->data['file']=$file[0]->gte_foto;
        	$this->_render_page('body/verimg', $this->data);
	    }

	}


	public function borrarfoto($id){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$id=$this->Sec_model->decrypt($id);
		$file=$this->Autorizaciones_model->delfoto($id);
        	$this->_render_page('body/delimg', $this->data);
	    }

	}







	function get_ciaseg_autos($id = NULL){
		$options = "";
            $unidades = $this->Autorizaciones_model->get_ciaseg_autos();
            if($unidades == FALSE){
		echo "<option>--</option>";
            }else{
		if(!$id) echo "<option value=\"-1\">Seleccione una Opcion</option>";
            	foreach($unidades as $unidad){
		    if($id==$unidad->cs_id)
			echo("<option selected value=\"$unidad->cs_id\">$unidad->cs_nombre</option>\n");
		    else
			echo("<option  value=\"$unidad->cs_id\">$unidad->cs_nombre</option>\n");
		}
            }			
	}

	function get_ciaseg_art($id = NULL){
		$options = "";
            $unidades = $this->Autorizaciones_model->get_ciaseg_art();
            if($unidades == FALSE){
		echo "<option>--</option>";
            }else{
		if(!$id) echo "<option value=\"-1\">Seleccione una Opcion</option>";
            	foreach($unidades as $unidad){
		    if($id==$unidad->cs_id)
			echo("<option selected value=\"$unidad->cs_id\">$unidad->cs_nombre</option>\n");
		    else
			echo("<option  value=\"$unidad->cs_id\">$unidad->cs_nombre</option>\n");
		}
            }
	}


	function busco(){

	    $term=$_POST['term'];
	    $ash_idptov=$_POST['ash_idptov'];
	    $tipov=$_POST['tipov'];
	    $motivo=$_POST['motivo'];

	    $gente=$this->Autorizaciones_model->get_gente($term,$ash_idptov);

	    if($gente){
		$respuesta=array();
		foreach($gente as $g){
		    $add=array();
		    $gte_id=$g->gte_id;
		    $gte_nombre=utf8_encode($g->gte_nombre);
		    $gte_nombre=($g->gte_nombre);
		    $gte_empresa=($g->gte_empresa);
		    $gte_dni=$g->gte_dni;

		    $pat=$cia=$vto=NULL;
		    if($tipov==1){
			$vehiculos=$this->Autorizaciones_model->get_gente_lv($gte_id);
			if($vehiculos){
			    $pat=$vehiculos[0]->lv_patente;
			    $cia=$vehiculos[0]->lv_segauto;
			    $vto=$vehiculos[0]->lv_vtoauto;
			}else{
			    $pat=$cia=$vto=NULL;
			}
		    }else{
			$vehiculos=$this->Autorizaciones_model->get_gente_gxu($gte_id);
			if($vehiculos){
			    $cia=$vehiculos[0]->gxu_segart;
			    $vto=$vehiculos[0]->gxu_vtoart;
			}else{
			    $pat=$cia=$vto=NULL;
			}
		    }

		    if(!$cia) $cia=-1;

		    if($tipov==1){
			$add=array("dni"=>$gte_dni,"patente"=>$pat,"ciaseg"=>$cia,"vtoseg"=>$vto,"tipov"=>$tipov,"name"=>$gte_nombre,"value"=>$gte_id);
		    }else{
			$add=array("dni"=>$gte_dni,"motivo"=>$motivo,"ciaseg"=>$cia,"vtoseg"=>$vto,"tipov"=>$tipov,"name"=>$gte_nombre,"value"=>$gte_id);
		    }
		    $respuesta[]=$add;
		}
		echo $_GET['callback']."(".json_encode($respuesta).")";
	    }else echo $_GET['callback']."()";


	}

	function busco_empresa(){

	    $term=$_POST['term'];
	    $ash_idptov=$_POST['ash_idptov'];
	    $tipov=$_POST['tipov'];
	    $motivo=$_POST['motivo'];

	    $gente=$this->Autorizaciones_model->get_empresa($term,$ash_idptov);

	    if($gente){
		$respuesta=array();
		foreach($gente as $g){
		    $add=array();
		    $gte_id=$g->gte_id;
		    $gte_empresa=($g->gte_empresa);

		    $add=array("name"=>$gte_empresa,"value"=>$gte_id);
		    $respuesta[]=$add;
		}
		echo $_GET['callback']."(".json_encode($respuesta).")";
	    }else echo $_GET['callback']."()";


	}








	function AgendarVisitas(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
                $config['upload_path']          = './uploads/visitas/';
                $config['allowed_types']        = 'gif|jpg|png|pdf|doc|docx|jpeg';
                $config['max_size']             = 1024;
                $this->load->library('upload', $config);
                $this->load->library('image_lib');

                $config2['upload_path']          = './uploads/visitas/';
                $config2['allowed_types']        = 'gif|jpg|png|jpeg';
                $config2['max_size']             = 10240;


		$this->form_validation->set_rules('tipo', 'Tipo Visita', 'required');


		$tipo = $this->input->post('tipo');
		$dni = $this->input->post('dni');
		$nombre=$this->input->post('nombre');
		$empresa=$this->input->post('empresa');
		$patente=$this->input->post('patente');
		$segauto=$this->input->post('seguro_auto');
		$vtoauto=$this->input->post('fechavto_auto');
		$tempo_visita=$this->input->post('permanente');
		if($tempo_visita<=1) $vtovisita="31/12/2500";
		else $vtovisita=$this->input->post('fechavto_vis');
		$ddevisita=$this->input->post('desde_vis');
		$llamada=$this->input->post('llamada');
		$motivo=$this->input->post('motivo');
		$llaves=$this->input->post('llaves');
		$obsllaves=$this->input->post('tipo_llaves');
		$segart=$this->input->post('seguro_art');
		$vtoart=$this->input->post('fechavto_art');
		$cargavehi=$this->input->post('cargavehi');
		$elBarrio=$this->Sec_model->getBarrio();

		if($tipo==1){
		    if(!$motivo) $motivo=1;
		    if(!$llaves) $llaves=1;
		}

		$dni=str_replace(" ","",$dni);
		$dni=str_replace("-","",$dni);
		$dni=str_replace(".","",$dni);
		$dni=trim($dni);
		$nombre=trim($nombre);
		$empresa=trim($empresa);
		if($cargavehi==1){
		    $this->form_validation->set_rules('patente', 'Patente', 'required');
		}

		if(!$empresa){
		    $this->form_validation->set_rules('dni', 'DNI', 'required');
		    $this->form_validation->set_rules('nombre', 'Nombre', 'required');
		}

		if($tipo>1){
		    $this->form_validation->set_rules('motivo', 'Motivo de Autorizacion', 'required');
		    $this->form_validation->set_rules('llaves', 'Entrega de Llaves', 'required');
		    $this->form_validation->set_rules('permanente', 'Temporalidad de Visita', 'required');
		}
		$this->form_validation->set_rules('llamada', 'Aviso de Guardia', 'required');

		if(!$dni) $dni=NULL;
		if(!$vtoart) $vtoart=NULL;
		if(!$vtoauto) $vtoauto=NULL;
		if($tempo_visita!=1 && !$vtovisita) $this->form_validation->set_rules('fechavto_vis', 'Fecha hasta para visitas ocasionales', 'required');
		if(!$ddevisita) $ddevisita=NULL;
		$fileauto=$fileart=$gte_foto="";

		if ($this->form_validation->run() === TRUE){
		    if(isset($_FILES)){
			if ($this->upload->do_upload('file_auto')) {
			    $upload_data = $this->upload->data();
			    $data_ary = array(
				'title'     => $upload_data['client_name'],
				'file'      => $upload_data['file_name'],
				'width'     => $upload_data['image_width'],
				'height'    => $upload_data['image_height'],
				'type'      => $upload_data['image_type'],
				'size'      => $upload_data['file_size'],
				'path'      => $upload_data['full_path'],
				'date'      => time(),
			    );
			    $data = array('upload_data' => $upload_data);
			    $fileauto=$data_ary['path'];
			}else{
			    if($_FILES['file_auto']['error'] != 4){
				$error = array('error' => $this->upload->display_errors());
				$new_data=array(
				    'pestania_activa'=>'visitas',
				    'message'=>$error
				);
				$this->session->set_flashdata($new_data);
				redirect('Autorizaciones', $this->data);
			    }
			}
			if ($this->upload->do_upload('file_art')) {
			    $upload_data1 = $this->upload->data();
			    $data_ary1 = array(
				'title'     => $upload_data1['client_name'],
				'file'      => $upload_data1['file_name'],
				'width'     => $upload_data1['image_width'],
				'height'    => $upload_data1['image_height'],
				'type'      => $upload_data1['image_type'],
				'size'      => $upload_data1['file_size'],
				'path'      => $upload_data1['full_path'],
				'date'      => time(),
			    );
			    $data1 = array('upload_data1' => $upload_data1);
			    $fileart=$data_ary1['path'];
			}else{
			    if($_FILES['file_art']['error'] != 4){
				$error = array('error' => $this->upload->display_errors());
				$new_data=array(
				    'pestania_activa'=>'visitas',
				    'message'=>$error
				);
				$this->session->set_flashdata($new_data);
				redirect('Autorizaciones', $this->data);
			    }
			}

			$this->upload->initialize($config2);
			if ($this->upload->do_upload('foto')) {
			    $upload_data2 = $this->upload->data();
			    $data_ary2 = array(
				'title'     => $upload_data2['client_name'],
				'file'      => $upload_data2['file_name'],
				'width'     => $upload_data2['image_width'],
				'height'    => $upload_data2['image_height'],
				'type'      => $upload_data2['image_type'],
				'size'      => $upload_data2['file_size'],
				'path'      => $upload_data2['full_path'],
				'date'      => time(),
			    );
			    $configer =  array(
            			'image_library'   => 'gd2',
            			'source_image'    =>  $upload_data2['full_path'],
            			'maintain_ratio'  =>  TRUE,
            			'width'           =>  250,
            			'height'          =>  250,
            		    );
            		    $this->image_lib->clear();
            		    $this->image_lib->initialize($configer);
            		    $this->image_lib->resize();

			    $data2 = array('upload_data2' => $upload_data2);
			    $gte_foto=$data_ary2['path'];
			}else{
			    if($_FILES['foto']['error'] != 4){
				$error = array('error' => $this->upload->display_errors());
				$new_data=array(
				    'pestania_activa'=>'visitas',
				    'message'=>$error
				);
				$this->session->set_flashdata($new_data);
				redirect('Autorizaciones', $this->data);
			    }
			}
		    }

		    $existe=NULL;
		    if($dni) $existe=$this->Autorizaciones_model->existe_gente_dni($dni);
		    if(!$existe){
			if($empresa) $existe=$this->Autorizaciones_model->existe_gente_empresa($empresa);
			else if($nombre) $existe=$this->Autorizaciones_model->existe_gente_nombre($nombre);
		    }

		    if($existe){
			//CHEQUEAR ESTADO GENTE, ESTA INHABILITADO??????
			$estaInhabilitado=$existe->gte_estado;
			if($estaInhabilitado==999){
				$error = array('error' => 'LA ADMINISTRACION DEL BARRIO HA INHABILITADO EL ACCESO Y/O REGISTRO DE ESTA PERSONA. NO SE PODRA PROCEDER CON EL ALTA.');
				$new_data=array(
				    'pestania_activa'=>'visitas',
				    'message'=>$error
				);
				$this->session->set_flashdata($new_data);
				redirect('Autorizaciones', $this->data);
			}
		    }



		    if(!$existe){
			//NO EXISTE EL DNI-EMPRESA
			$tabla1='gente';
			$datos1=array(
			    'gte_idptov'=> $elBarrio,
			    'gte_dni' => $dni,
			    'gte_nombre' => $nombre,
			    'gte_empresa' => $empresa,
			    'gte_foto' => $gte_foto,
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			}else{
			    $gte_id=$this->db->insert_id('gente_gte_id_seq');

			    if($patente){
				$patente=strtoupper(str_replace(" ","",$patente));
				$datos_lv=array(
				    'lv_patente' => $patente,
				    'lv_segauto' => $segauto,
				    'lv_vtoauto' => $vtoauto,
				    'lv_fileauto' => $fileauto,
				);
				$tabla_lv='livianos';

				$existe_liv=$this->Autorizaciones_model->existe_liviano_patente($patente);
				if(!$existe_liv){
				    if($this->Sec_model->insert($tabla_lv,$datos_lv) == FALSE){
					echo $this->db->last_query();
					exit;
				    }else{
					$lv_id=$this->db->insert_id('livianos_lv_id_seq');
					$tabla_rel='gtexliv';
					$datos_rel=array('gl_idgente' => $gte_id, 'gl_idliv' => $lv_id);
					$this->Sec_model->insert($tabla_rel,$datos_rel);
				    }
				}else{
				    $lv_id=$existe_liv->lv_id;
				    if($segauto && $vtoauto){
					if($segauto!=$existe_liv->lv_segauto || $vtoauto!=$existe_liv->lv_vtoauto){
					    $this->Sec_model->update_p($tabla_lv,'lv_id',$lv_id,$datos_lv);
					}
				    }
				    $existe_rel=$this->Autorizaciones_model->existe_rel_lv_gte($gte_id,$lv_id);
				    if(!$existe_rel){
					$tabla_rel='gtexliv';
					$datos_rel=array('gl_idgente' => $gte_id, 'gl_idliv' => $lv_id);
					$this->Sec_model->insert($tabla_rel,$datos_rel);
				    }
				}
			    }

			    $tabla2='gtexuf';
			    $es_admin=$this->Sec_model->es_admin($user->id);
			    $tipusu=$this->Sec_model->tipo_usuario($user->id);
			    if(!$es_admin){
				$cops=$this->Sec_model->usuario_barrio_unidad($user->id,$elBarrio);
				foreach($cops as $cop){
				    if($tipo==3) $estado=2; else $estado=1;
				    $datos2=array(
					'gxu_idgente' => $gte_id,
					'gxu_idcop' => $cop->cop_id,
					'gxu_llaves' => $llaves,
					'gxu_obsllaves' => $obsllaves,
					'gxu_tipo' => $tipo,
					'gxu_motivo' => $motivo,
					'gxu_llamada' => $llamada,
					'gxu_vtovisita' => $vtovisita,
					'gxu_desde' => $ddevisita,
					'gxu_segart' => $segart,
					'gxu_vtoart' => $vtoart,
					'gxu_fileart' => $fileart,
					'gxu_tipusu' => $tipusu,
					'gxu_estado' => $estado,
				    );
				    $tiene_rel=$this->Autorizaciones_model->existe_rel_gte_uf($gte_id,$cop->cop_id,$tipo,$motivo,$tipusu);
				    if($tiene_rel){
					$inactivo_arr=array('gxu_estado' => 9);
					$this->Sec_model->update_p($tabla2,'gxu_id',$tiene_rel->gxu_id,$inactivo_arr);
				    }
				    if($this->Sec_model->insert($tabla2,$datos2) == FALSE){
					echo $this->db->last_query();
					exit;
				    }
				}
			    }else{
				$estado=1;
				$datos2=array(
				    'gxu_idgente' => $gte_id,
				    'gxu_idcop' => -1,
				    'gxu_llaves' => $llaves,
				    'gxu_obsllaves' => $obsllaves,
				    'gxu_vtovisita' => $vtovisita,
				    'gxu_desde' => $ddevisita,
				    'gxu_tipo' => $tipo,
				    'gxu_motivo' => $motivo,
				    'gxu_llamada' => $llamada,
				    'gxu_segart' => $segart,
				    'gxu_vtoart' => $vtoart,
				    'gxu_fileart' => $fileart,
				    'gxu_tipusu' => $tipusu,
				    'gxu_estado' => $estado,
				);
				$tiene_rel=$this->Autorizaciones_model->existe_rel_gte_uf($gte_id,-1,$tipo,$motivo,$tipusu);
				if($tiene_rel){
				    $inactivo_arr=array('gxu_estado' => 9);
				    $this->Sec_model->update_p($tabla2,'gxu_id',$tiene_rel->gxu_id,$inactivo_arr);
				}
				if($this->Sec_model->insert($tabla2,$datos2) == FALSE){
				    echo $this->db->last_query();
				    exit;
				}
			    }
			}
		    }else{
			$gte_id=$existe->gte_id;
			$tabla1='gente';
			$datos1=array(
			    'gte_foto' => $gte_foto,
			);

			if($gte_foto){
			    $this->Sec_model->update_p($tabla1,'gte_id',$gte_id,$datos1);
			}


			if($patente){
			    $patente=strtoupper(str_replace(" ","",$patente));
			    $datos_lv=array(
				    'lv_patente' => $patente,
				    'lv_segauto' => $segauto,
				    'lv_vtoauto' => $vtoauto,
				    'lv_fileauto' => $fileauto,
			    );
			    $tabla_lv='livianos';

			    $existe_liv=$this->Autorizaciones_model->existe_liviano_patente($patente);
			    if(!$existe_liv){
				if($this->Sec_model->insert($tabla_lv,$datos_lv) == FALSE){
				    echo $this->db->last_query();
				    exit;
				}else{
				    $lv_id=$this->db->insert_id('livianos_lv_id_seq');
				    $tabla_rel='gtexliv';
				    $datos_rel=array('gl_idgente' => $gte_id, 'gl_idliv' => $lv_id);
				    $this->Sec_model->insert($tabla_rel,$datos_rel);
				}
			    }else{
				$lv_id=$existe_liv->lv_id;
				if($segauto && $vtoauto){
				    if($segauto!=$existe_liv->lv_segauto || $vtoauto!=$existe_liv->lv_vtoauto){
					$this->Sec_model->update_p($tabla_lv,'lv_id',$lv_id,$datos_lv);
				    }
				}
				$existe_rel=$this->Autorizaciones_model->existe_rel_lv_gte($gte_id,$lv_id);
				if(!$existe_rel){
				    $tabla_rel='gtexliv';
				    $datos_rel=array('gl_idgente' => $gte_id, 'gl_idliv' => $lv_id);
				    $this->Sec_model->insert($tabla_rel,$datos_rel);
				}
			    }
			}

			$tabla2='gtexuf';
			$es_admin=$this->Sec_model->es_admin($user->id);
			$tipusu=$this->Sec_model->tipo_usuario($user->id);
			if(!$es_admin){
			    $cops=$this->Sec_model->usuario_barrio_unidad($user->id,$elBarrio);
			    foreach($cops as $cop){
				if($tipo==3) $estado=2; else $estado=1;
				$datos2=array(
					'gxu_idgente' => $gte_id,
					'gxu_idcop' => $cop->cop_id,
					'gxu_llaves' => $llaves,
					'gxu_obsllaves' => $obsllaves,
					'gxu_tipo' => $tipo,
					'gxu_motivo' => $motivo,
					'gxu_llamada' => $llamada,
					'gxu_vtovisita' => $vtovisita,
					'gxu_desde' => $ddevisita,
					'gxu_segart' => $segart,
					'gxu_vtoart' => $vtoart,
					'gxu_fileart' => $fileart,
					'gxu_tipusu' => $tipusu,
					'gxu_estado' => $estado,
				);
				$tiene_rel=$this->Autorizaciones_model->existe_rel_gte_uf($gte_id,$cop->cop_id,$tipo,$motivo,$tipusu);
				if($tiene_rel){
				    $inactivo_arr=array('gxu_estado' => 9);
				    $this->Sec_model->update_p($tabla2,'gxu_id',$tiene_rel->gxu_id,$inactivo_arr);
				}
				if($this->Sec_model->insert($tabla2,$datos2) == FALSE){
				    echo $this->db->last_query();
				    exit;
				}
			    }
			}else{
			    $estado=1;
			    $datos2=array(
				'gxu_idgente' => $gte_id,
				'gxu_idcop' => -1,
				'gxu_llaves' => $llaves,
				'gxu_obsllaves' => $obsllaves,
				'gxu_vtovisita' => $vtovisita,
				'gxu_desde' => $ddevisita,
				'gxu_tipo' => $tipo,
				'gxu_motivo' => $motivo,
				'gxu_llamada' => $llamada,
				'gxu_segart' => $segart,
				'gxu_vtoart' => $vtoart,
				'gxu_fileart' => $fileart,
				'gxu_tipusu' => $tipusu,
				'gxu_estado' => $estado,
			    );
			    $tiene_rel=$this->Autorizaciones_model->existe_rel_gte_uf($gte_id,-1,$tipo,$motivo,$tipusu);
			    if($tiene_rel){
				$inactivo_arr=array('gxu_estado' => 9);
				$this->Sec_model->update_p($tabla2,'gxu_id',$tiene_rel->gxu_id,$inactivo_arr);
			    }
			    if($this->Sec_model->insert($tabla2,$datos2) == FALSE){
				echo $this->db->last_query();
				exit;
			    }
			}




		    }

		    if($tipo==1)
			$mensaje="Ud. ha cargado la visita correctamente";
		    else{
			if($motivo==1) $mensaje="Ud. ha cargado al proveedor correctamente";
			else if($motivo==2) $mensaje="Ud ha cargado al proveedor correctamente. Recuerde que al ingresar al country se le pedir&aacute; al proveedor la presentaci&oacute;n de los seguros correspondientes.";
		    }

		    $new_data=array(
			'message'=>$mensaje
		    );
		    $this->session->set_flashdata($new_data);
		    redirect('Autorizaciones', 'refresh');
		}else{
		    $new_data=array(
			'message'=>validation_errors()
		    );
		    $this->session->set_flashdata($new_data);
		    redirect('Autorizaciones', $this->data);
		}
	    }

	}






	function NotaProve(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{

		$gxu_id = $this->input->post('gxu_id');
		$desde = $this->input->post('desde');
		$hasta=$this->input->post('hasta');
		$nota=$this->input->post('nota');
		$ng_id=$this->input->post('ng_id');

		$this->form_validation->set_rules('gxu_id', 'Persona', 'required');
		$this->form_validation->set_rules('nota', 'Nota', 'required');

		if ($this->form_validation->run() === TRUE){

			if(!$desde) $desde=NULL;
			if(!$hasta) $hasta=NULL;
			$estado=1;

			$desde=str_replace("/","-",$desde);

			$hoy= new DateTime();
			$desde2= new DateTime($desde);

			if($desde2>$hoy) $estado=2;


			$tabla1='notaxgxu';
			$datos1=array(
			    'ng_idgxu'=> $gxu_id,
			    'ng_desde' => $desde,
			    'ng_hasta' => $hasta,
			    'ng_nota' => trim($nota),
			    'ng_estado' => $estado,
			);

			if(!$ng_id){
			    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			    }
			    $mensaje="Ud. ha cargado la nota correctamente";
			}else{
			    if($this->Sec_model->update_p($tabla1,"ng_id",$ng_id,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			    }
			    $mensaje="Ud. ha actualizado la nota correctamente";
			}

		    $new_data=array(
			'message'=>$mensaje
		    );
		    $this->session->set_flashdata($new_data);
		    redirect('Autorizaciones', 'refresh');
		}else{
		    $new_data=array(
			'message'=>validation_errors()
		    );
		    $this->session->set_flashdata($new_data);
		    redirect('Autorizaciones', $this->data);
		}
	    }
	}


	function DelNota(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{

		$ng_id=$this->input->post('ng_id');

		$this->form_validation->set_rules('ng_id', 'Nota', 'required');

		if ($this->form_validation->run() === TRUE){

			$tabla1='notaxgxu';
			$datos1=array(
			    'ng_estado' => 2,
			);

			    if($this->Sec_model->update_p($tabla1,"ng_id",$ng_id,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			    }
			    $mensaje="Ud. ha eliminado la nota correctamente";
		    $new_data=array(
			'message'=>$mensaje
		    );
		    $this->session->set_flashdata($new_data);
		    redirect('Autorizaciones', 'refresh');
		}else{
		    $new_data=array(
			'message'=>validation_errors()
		    );
		    $this->session->set_flashdata($new_data);
		    redirect('Autorizaciones', $this->data);
		}
	    }
	}








	function UpdateVisitas(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
                $config['upload_path']          = './uploads/visitas/';
                $config['allowed_types']        = 'gif|jpg|png|pdf|doc|docx|jpeg';
                $config['max_size']             = 5120;
                $this->load->library('upload', $config);
                $this->load->library('image_lib');

                $config2['upload_path']          = './uploads/visitas/';
                $config2['allowed_types']        = 'gif|jpg|png|jpeg';
                $config2['max_size']             = 10240;




		$idgxu=$this->input->post('gxu_id');
		$gxu=$this->Autorizaciones_model->get_gxu($idgxu);
		$gxu=$gxu[0];
		$lv=$this->Autorizaciones_model->get_last_lv($gxu->gte_id);
		if($lv) $lv=$lv[0];
		else $lv=NULL;

		$vieja_art=$gxu->gxu_fileart;
		if($lv) $vieja_seg=$lv->lv_fileauto;
		else $vieja_seg=NULL;
		$vieja_foto=$gxu->gte_foto;

		$tipo = $gxu->gxu_tipo;
		$motivo= $gxu->gxu_motivo;

		

		$dni = $this->input->post('dni');
		$nombre=$this->input->post('nombre');
		$empresa=$this->input->post('empresa');

		$patente=$this->input->post('patente');
		$segauto=$this->input->post('seguro_auto');
		$vtoauto=$this->input->post('fechavto_auto');
		$tempo_visita=$this->input->post('permanente');
		$ddevisita=$this->input->post('desde_vis');
		if($tempo_visita<=1){
		    $vtovisita="31/12/2500";
		    $ddevisita=NULL;
		}else $vtovisita=$this->input->post('fechavto_vis');
		$llamada=$this->input->post('llamada');
		$llaves=$this->input->post('llaves');
		$obsllaves=$this->input->post('tipo_llaves');
		$segart=$this->input->post('seguro_art');
		$vtoart=$this->input->post('fechavto_art');
		$cargavehi=$this->input->post('cargavehi');
		$elBarrio=$this->Sec_model->id_barrios_user($user->id)[0];

		if($tipo==1){
		    if(!$llaves) $llaves=1;
		}

		$dni=str_replace(" ","",$dni);
		$dni=str_replace("-","",$dni);
		$dni=str_replace(".","",$dni);
		$dni=trim($dni);
		$nombre=trim($nombre);
		$empresa=trim($empresa);
		if($cargavehi==1){
		    $this->form_validation->set_rules('patente', 'Patente', 'required');
		}

		if(!$empresa){
		    $this->form_validation->set_rules('dni', 'DNI', 'required');
		    $this->form_validation->set_rules('nombre', 'Nombre', 'required');
		}

		if($tipo>1){
		    $this->form_validation->set_rules('llaves', 'Entrega de Llaves', 'required');
		    $this->form_validation->set_rules('permanente', 'Temporalidad de Visita', 'required');
		}
		$this->form_validation->set_rules('llamada', 'Aviso de Guardia', 'required');

		if(!$dni) $dni=NULL;
		if(!$vtoart) $vtoart=NULL;
		if(!$vtoauto) $vtoauto=NULL;
		if($tempo_visita!=1 && !$vtovisita) $this->form_validation->set_rules('fechavto_vis', 'Fecha hasta para visitas ocasionales', 'required');
		if(!$ddevisita) $ddevisita=NULL;
		$fileauto=$fileart=$gte_foto="";

		if ($this->form_validation->run() === TRUE){
		    $gxuidecrypt=$this->Sec_model->ecrypt($gxu->gxu_id);
		    if(isset($_FILES)){
			if(isset($_FILES['file_auto'])){
			    if ($this->upload->do_upload('file_auto')) {
				$upload_data = $this->upload->data();
				$data_ary = array(
				    'title'     => $upload_data['client_name'],
				    'file'      => $upload_data['file_name'],
				    'width'     => $upload_data['image_width'],
				    'height'    => $upload_data['image_height'],
				    'type'      => $upload_data['image_type'],
				    'size'      => $upload_data['file_size'],
				    'path'      => $upload_data['full_path'],
				    'date'      => time(),
				);
				$data = array('upload_data' => $upload_data);
				$fileauto=$data_ary['path'];
			    }else{
				if($_FILES['file_auto']['error'] != 4){
				    $error = array('error' => $this->upload->display_errors());
				    $new_data=array(
					'pestania_activa'=>'visitas',
					'message'=>$error
				    );
				    $this->session->set_flashdata($new_data);
				    redirect('Autorizaciones/Editar/'.$gxuidecrypt, $this->data);
				}
			    }
			}


			if(isset($_FILES['file_art'])){
			    if ($this->upload->do_upload('file_art')) {
				$upload_data1 = $this->upload->data();
				$data_ary1 = array(
				    'title'     => $upload_data1['client_name'],
				    'file'      => $upload_data1['file_name'],
				    'width'     => $upload_data1['image_width'],
				    'height'    => $upload_data1['image_height'],
				    'type'      => $upload_data1['image_type'],
				    'size'      => $upload_data1['file_size'],
				    'path'      => $upload_data1['full_path'],
				    'date'      => time(),
				);
				$data1 = array('upload_data1' => $upload_data1);
				$fileart=$data_ary1['path'];
			    }else{
				if($_FILES['file_art']['error'] != 4){
				    $error = array('error' => $this->upload->display_errors());
				    $new_data=array(
					'pestania_activa'=>'visitas',
					'message'=>$error
				    );
				    $this->session->set_flashdata($new_data);
				    redirect('Autorizaciones/Editar/'.$gxuidecrypt, $this->data);
				}
			    }
			}


			if(isset($_FILES['foto'])){
			    $this->upload->initialize($config2);
			    if ($this->upload->do_upload('foto')) {
				$upload_data2 = $this->upload->data();
				$data_ary2 = array(
				    'title'     => $upload_data2['client_name'],
				    'file'      => $upload_data2['file_name'],
				    'width'     => $upload_data2['image_width'],
				    'height'    => $upload_data2['image_height'],
				    'type'      => $upload_data2['image_type'],
				    'size'      => $upload_data2['file_size'],
				    'path'      => $upload_data2['full_path'],
				    'date'      => time(),
				);
				$configer =  array(
            			    'image_library'   => 'gd2',
            			    'source_image'    =>  $upload_data2['full_path'],
            			    'maintain_ratio'  =>  TRUE,
            			    'width'           =>  250,
            			    'height'          =>  250,
            			);
            			$this->image_lib->clear();
            			$this->image_lib->initialize($configer);
            			$this->image_lib->resize();

				$data2 = array('upload_data2' => $upload_data2);
				$gte_foto=$data_ary2['path'];
			    }else{
				if($_FILES['foto']['error'] != 4){
				    $error = array('error' => $this->upload->display_errors());
				    $new_data=array(
					'pestania_activa'=>'visitas',
					'message'=>$error
				    );
				    $this->session->set_flashdata($new_data);
				    redirect('Autorizaciones/Editar/'.$gxuidecrypt, $this->data);
				}
			    }
			}
		    }

		    if(!$gte_foto && $vieja_foto) $gte_foto=$vieja_foto;
		    if(!$fileart && $vieja_art) $fileart=$vieja_art;
		    if(!$fileauto && $vieja_seg) $fileauto=$vieja_seg;



		    $tabla1='gente';
		    $gte_id=$gxu->gxu_idgente;
		    $datos1=array(
			'gte_idptov'=> $elBarrio,
			'gte_dni' => $dni,
			'gte_nombre' => $nombre,
			'gte_empresa' => $empresa,
			'gte_foto' => $gte_foto,
		    );
		    $this->Sec_model->update_p($tabla1,'gte_id',$gte_id,$datos1);


		    if($patente){
			$patente=strtoupper(str_replace(" ","",$patente));
			if(!$segauto) $segauto=NULL;
			if(!$vtoauto) $vtoauto=NULL;
			$datos_lv=array(
			    'lv_patente' => $patente,
			    'lv_segauto' => $segauto,
			    'lv_vtoauto' => $vtoauto,
			    'lv_fileauto' => $fileauto,
			);
			$tabla_lv='livianos';
			if($lv){
			    $existe_liv=$lv->lv_id;
			    $this->Sec_model->update_p($tabla_lv,'lv_id',$existe_liv,$datos_lv);
			}else{
			    $existe_liv=$this->Autorizaciones_model->existe_liviano_patente($patente);
			    if(!$existe_liv){
				if($this->Sec_model->insert($tabla_lv,$datos_lv) == FALSE){
				    echo $this->db->last_query();
				    exit;
				}else{
				    $lv_id=$this->db->insert_id('livianos_lv_id_seq');
				    $tabla_rel='gtexliv';
				    $datos_rel=array('gl_idgente' => $gte_id, 'gl_idliv' => $lv_id);
				    $this->Sec_model->insert($tabla_rel,$datos_rel);
				}
			    }else{
				$lv_id=$existe_liv->lv_id;
				if($segauto && $vtoauto){
				    if($segauto!=$existe_liv->lv_segauto || $vtoauto!=$existe_liv->lv_vtoauto){
					$this->Sec_model->update_p($tabla_lv,'lv_id',$lv_id,$datos_lv);
				    }
				}
				$existe_rel=$this->Autorizaciones_model->existe_rel_lv_gte($gte_id,$lv_id);
				if(!$existe_rel){
				    $tabla_rel='gtexliv';
				    $datos_rel=array('gl_idgente' => $gte_id, 'gl_idliv' => $lv_id);
				    $this->Sec_model->insert($tabla_rel,$datos_rel);
				}
			    }
			}
		    }

		    if(!$segart) $segart=NULL;

		    $tabla2='gtexuf';
		    $es_admin=$this->Sec_model->es_admin($user->id);
		    $tipusu=$this->Sec_model->tipo_usuario($user->id);
		    $datos2=array(
			'gxu_llaves' => $llaves,
			'gxu_obsllaves' => $obsllaves,
			'gxu_llamada' => $llamada,
			'gxu_vtovisita' => $vtovisita,
			'gxu_desde' => $ddevisita,
			'gxu_segart' => $segart,
			'gxu_vtoart' => $vtoart,
			'gxu_fileart' => $fileart,
		    );

		    $cops=$this->Sec_model->usuario_barrio_unidad($user->id,$elBarrio);
		    foreach($cops as $cop){
			$actualizo_rel=$this->Autorizaciones_model->existe_rel_gte_uf($gte_id,$cop->cop_id,$tipo,$motivo,$tipusu);
			if($actualizo_rel){
			    $this->Sec_model->update_p($tabla2,'gxu_id',$actualizo_rel->gxu_id,$datos2);
			}
		    }

		    if($tipo==1)
			$mensaje="Ud. ha actualizado la visita correctamente";
		    else{
			if($motivo==1) $mensaje="Ud. ha actualizado al proveedor correctamente";
			else if($motivo==2) $mensaje="Ud ha actualizado al proveedor correctamente. Recuerde que al ingresar al country se le pedir&aacute; al proveedor la presentaci&oacute;n de los seguros correspondientes.";
		    }

		    $new_data=array(
			'message'=>$mensaje
		    );
		    $this->session->set_flashdata($new_data);
//echo "todo ok";
//exit();
		    redirect('Autorizaciones', 'refresh');
		}else{
		    $new_data=array(
			'message'=>validation_errors()
		    );
		    $this->session->set_flashdata($new_data);
//echo "error";
//exit();
		    redirect('Autorizaciones', $this->data);
		}
	    }

	}










	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}