CREATE TABLE grupoam (
    gam_id integer NOT NULL,
    gam_nombre integer NOT NULL,
    gam_estado integer DEFAULT 1
);


ALTER TABLE public.grupoam OWNER TO sanjor;

CREATE SEQUENCE grupoam_gam_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.grupoam_gam_id_seq OWNER TO sanjor;
ALTER SEQUENCE grupoam_gam_id_seq OWNED BY grupoam.gam_id;

ALTER TABLE ONLY grupoam ALTER COLUMN gam_id SET DEFAULT nextval('grupoam_gam_id_seq'::regclass);

ALTER TABLE ONLY grupoam
    ADD CONSTRAINT grupoam_pkey PRIMARY KEY (gam_id);

REVOKE ALL ON TABLE grupoam FROM PUBLIC;
REVOKE ALL ON TABLE grupoam FROM sanjor;
GRANT ALL ON TABLE grupoam TO sanjor;
GRANT ALL ON TABLE grupoam TO nobody;

REVOKE ALL ON SEQUENCE grupoam_gam_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE grupoam_gam_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE grupoam_gam_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE grupoam_gam_id_seq TO nobody;


