CREATE TABLE calendario (
    id integer NOT NULL,
    fecha date NOT NULL,
    comentario character varying(200),
    estado character varying(10)
);


ALTER TABLE public.calendario OWNER TO sanjor;

CREATE SEQUENCE calendario_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.calendario_id_seq OWNER TO sanjor;
ALTER SEQUENCE calendario_id_seq OWNED BY calendario.id;

ALTER TABLE ONLY calendario ALTER COLUMN id SET DEFAULT nextval('calendario_id_seq'::regclass);

ALTER TABLE ONLY calendario
    ADD CONSTRAINT calendario_pkey PRIMARY KEY (id);


REVOKE ALL ON TABLE calendario FROM PUBLIC;
REVOKE ALL ON TABLE calendario FROM sanjor;
GRANT ALL ON TABLE calendario TO sanjor;
GRANT ALL ON TABLE calendario TO nobody;

REVOKE ALL ON SEQUENCE calendario_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE calendario_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE calendario_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE calendario_id_seq TO nobody;

