<?php

require('fpdf/fpdf.php');
require('cae.php');

class PDF extends FPDF
    {

//    include('funciones.php');

    function encabezado()
	{
	
	global $op_desccli,$op_domicilio,$op_codpost,$op_localidad,$op_provincia,$op_cuit,$op_fecha,$op_sucursal,$op_coniva,$op_ctacte;
	global $op_numero,$op_subtotalsd,$op_descuento,$op_subtotalcd,$op_iva,$op_ivani,$op_total,$op_codcomprob,$cae,$cae_fecvto,$fecvto_pago;
	//CONFIG
	global $zonaDir1,$zonaDir2,$zonaDir3,$zonatel,$zonafax,$zonaCUIT,$zonaIibb,$zonaInicio,$zonaCap,$zonaConiva;
	
	if(strcmp($op_coniva,"1")==0)
	    $coniva='RESPONSABLE INSCRIPTO';
	
	if(strcmp($op_codcomprob,'FA')==0 || strcmp($op_codcomprob,'CA')==0 || strcmp($op_codcomprob,'DA')==0){
	    $lecomp='A';
	}

/*	else
	    {
	    if(strcmp($op_codcomprob,'FB')==0 || strcmp($op_codcomprob,'CB')==0 || strcmp($op_codcomprob,'DB')==0)
		{
		$lecomp='B'
	        }
	    }
*/
	if(strcmp($op_codcomprob,'FA')==0)
	    {
	    $tipoFac='FACTURA';
	    }
	else
	    if(strcmp($op_codcomprob,'CA')==0)
		{
		$tipoFac='NOTA DE CREDITO';
		}
	    else
		{
		if(strcmp($op_codcomprob,'DA')==0)
		    {
		    $tipoFac='NOTA DE DEBITO';
		    }
		}
	
	$this->SetFont('Arial','',8);
	$this->Cell(90,7,'','LT',0);
	$this->Image('logoempresa.jpg',13,17,25);
//	$this->Ln(1);
	$this->Cell(10,7,$lecomp,1,0,'C');
	$this->Cell(90,7,'','TR',0,'C');
	$this->Ln(7);
	$this->Ln(-2);
	$this->SetFont('Arial','',4);
	$this->Cell(90,2);
	$str='Codigo N%B0 01';
	$this->Cell(10,2,urldecode($str),0,0,'C');
	$this->Cell(90,2);
	$this->Ln(2);
	$this->Cell(25,10,'','L',0);
	$this->SetFont('Arial','B',7);
	$this->Cell(70,5,$zonaCap,'R',0,'C');
	$this->SetFont('Arial','',7);
//	$this->Cell(25,10,'',0,0);
	$this->SetFont('Arial','B',10);
	$this->Cell(95,5,$tipoFac.'    '.$op_sucursal.'-'.$op_numero.'           ','R',0,'C');
	$this->SetFont('Arial','',7);
	$this->Ln(4);
	$this->Cell(25,4,'','L',0);
	$this->Cell(70,4,$zonaDir1,'R',0,'C');
	$this->Cell(25,4,'',0,0);
	$this->Cell(70,4,'','R',0);
	$this->Ln(4);
	$this->Cell(25,4,'','L',0);
	$this->Cell(70,4,$zonaDir2,'R',0,'C');
	$this->Cell(25,4,'',0,0);
	$this->RoundedRect(130,25,30,4,2,'D');
	$this->Cell(30,4,'Fecha: '.$op_fecha,0,0,'C');
	$this->Cell(40,4,'','R');
	$this->Ln(4);
	$this->Cell(25,4,'','L',0);
	$this->Cell(70,4,$zonaDir3,'R',0,'C');
	$this->Cell(25,4,'',0,0);
	$this->Cell(70,4,'','R',0);
	$this->Ln(4);
	$this->Cell(25,4,'','L',0);
	$this->Cell(70,4,'Tel: '.$zonatel,'R',0,'C');
	$this->Cell(25,4,'',0,0);
	$this->Cell(70,4,'CUIT: '.$zonaCUIT,'R',0);
	$this->Ln(4);
	$this->Cell(25,4,'','L',0);
	$this->Cell(70,4,'Fax: '.$zonafax,'R',0,'C');
	$this->Cell(25,4,'',0,0);
	$this->Cell(70,4,'Ing. Brutos: '.$zonaIibb,'R',0);
	$this->Ln(4);
	$this->Cell(25,4,'','L',0);
	$this->Cell(70,4,$zonaConiva,'R',0,'C');
	$this->Cell(25,4,'',0,0);
	$this->Cell(70,4,'Inicio Actividades: '.$zonaInicio,'R',0);
	$this->Ln(4);
	$this->Cell(95,4,'','LRB');
	$this->Cell(95,4,'','LRB');
	$this->Ln(4);

	//DATOS CLIENTE
	$this->SetFont('Arial','',8);
	$this->Cell(190,3,'','LR',0);
	$this->Ln(3);
	$this->Cell(100,5,'          '.$op_desccli,'L',0);
	$this->Cell(90,5,'Fecha Vto: '.$fecvto_pago,'R',0,'C');
	$this->Ln(5);
	$this->Cell(190,5,'          '.$op_domicilio.' - ('.$op_codpost.') - '.$op_localidad,'LR',0);
	$this->Ln(5);
	$this->Cell(100,5,'          '.$op_provincia,'L',0);
	$this->Cell(90,5,'CUIT: '.$op_cuit,'R',0,'C');
	$this->Ln(5);
	$this->Cell(100,5,'          I.V.A.: '.$coniva,'L',0);
	$this->Cell(90,5,'Cond. de Venta: '.$op_ctacte,'R',0,'C');
	$this->Ln(5);
	$this->Cell(190,3,'','LRB',0);
	$this->Ln(3);
	$this->Cell(20,2,'','LR',0);
	$this->Cell(100,2,'','LR',0);
	$this->Cell(35,2,'','LR',0);
	$this->Cell(35,2,'','LR',0);
	$this->Ln(2);
	$this->Cell(20,5,'Cantidad','LR',0,'C');
	$this->Cell(100,5,'Codigo - Articulo','LR',0,'C');
	$this->Cell(35,5,'P. Unitario','LR',0,'C');
	$this->Cell(35,5,'Importe','LR',0,'C');
	$this->Ln(5);
	$this->Cell(20,2,'','LRB',0);
	$this->Cell(100,2,'','LRB',0);
	$this->Cell(35,2,'','LRB',0);
	$this->Cell(35,2,'','LRB',0);
	$this->Ln(2);

	}

    function Detalle()
	{
	global $query,$total;
//	$total=3;
	$lineas=25;
	
	$this->SetFont('Arial','',8);
	for($i=0;$i<$total;$i++)
	    {
	    $dias=Resultado($query,$i,"dias",1);
	    $cantidad=Resultado($query,$i,"cantidad",1);
	    $detalle=Resultado($query,$i,"detalle",1);
	    $importe=Resultado($query,$i,"importe",1);

	    if($dias<0) $dias*=-1;
	    if($cantidad<0) $cantidad*=-1;
	    if($importe<0) $importe*=-1;
	    
//	    $dias=0;
//	    $cantidad=1;
//	    $detalle='ALQUILER DE NAVE';
//	    $importe=156123.22;
	    if($importe)
		$importe=@UserQuery("select $importe :: numeric(15,2);",0);
	    if($dias>1)
	        {
	        $preciouu=$importe/$dias;
	        $preciou=@UserQuery("select $preciouu :: numeric(15,2);",0);
	        $this->Cell(20,5,$dias,'LR',0,'C');
	        }
	    else
	        {
	        $preciouu=$importe/$cantidad;
	        $preciou=@UserQuery("select $preciouu :: numeric(15,2);",0);
	        $this->Cell(20,5,$cantidad,'LR',0,'C');
	        }
	    $this->Cell(100,5,'     '.$detalle,'LR',0);
	    $this->Cell(35,5,$preciou.'   ','LR',0,'R');
	    $this->Cell(35,5,$importe.'   ','LR',0,'R');
	    $this->Ln(5);
	    }

	if($total<$lineas){
	    for($j=0;$j<$lineas-$total;$j++){
		$this->Cell(20,5,'','LR',0);
		$this->Cell(100,5,'','LR',0);
		$this->Cell(35,5,'','LR',0);
		$this->Cell(35,5,'','LR',0);
		$this->Ln(5);
	    }
	}

	$this->Cell(20,5,'','LRB',0);
	$this->Cell(100,5,'','LRB',0);
	$this->Cell(35,5,'','LRB',0);
	$this->Cell(35,5,'','LRB',0);
	$this->Ln(5);
	}


//    function piedepagina()
    function Pie()
	{
	global $op_subtotalsd,$op_descuento,$op_subtotalcd,$op_iva,$op_ivani,$op_total,$op_sucursal,$op_numero,$cae,$cae_fecvto,$tipoCbe,$ptoVta;
	//CONFIG
	global $zonaDir1,$zonaDir2,$zonatel,$zonaCUIT,$zonaIibb,$zonaInicio,$zonaCap,$zonaConiva;



	$op_subtotalsd=@UserQuery("select $op_subtotalsd::numeric(15,2);",0);
//	$op_subtotalcd=@UserQuery("select $op_subtotalcd::numeric(15,2);",0);
	if($op_total)
	    $op_total=@UserQuery("select $op_total::numeric(15,2);",0);
	else
	    $op_total='0.00';
	if($op_iva)
	    $op_iva=@UserQuery("select $op_iva::numeric(15,2);",0);
	else
	    $op_iva='0.00';
	
	if(!$op_descuento){
	    $op_descuento='0.00';
	    $op_subtotalcd=$op_subtotalsd;
	}else{
	    $op_descuento=@UserQuery("select $op_descuento :: numeric(15,2);",0);
	}
	if(!$op_ivani)$op_ivani='0.00';

	$this->SetY(-83);
//	$this->Ln();
//	$this->SetFont('Arial','',8);
	$this->Cell(31,3,'','L',0,'C');
	$this->Cell(31,3,'',0,0,'C');
	$this->Cell(32,3,'',0,0,'C');
	$this->Cell(32,3,'',0,0,'C');
	$this->Cell(31,3,'',0,0,'C');
	$this->Cell(33,3,'','R',0,'C');
	$this->Ln(3);
	$this->Cell(5,5,'','L');
	$this->Cell(32,5,'Subtotal',1,0,'C');
	$this->Cell(5);
	$this->Cell(32,5,'Impuestos',1,0,'C');
	$this->Cell(5);
	$this->Cell(32,5,'Subtotal',1,0,'C');
	$this->Cell(5);
	$this->Cell(32,5,'IVA: 21.00%',1,0,'C');
	$this->Cell(5);
	$this->Cell(32,5,'Total',1,0,'C');
	$this->Cell(5,5,'','R');
	$this->Ln(5);
	$this->Cell(190,4,'','RL');
	$this->Ln(4);
	$this->Cell(5,5,'','L');
	$this->RoundedRect(15,225,32,6,2,'D');
	$this->Cell(32,5,$op_subtotalsd,0,0,'C');
	$this->Cell(5);
	$this->RoundedRect(52,225,32,6,2,'D');
	$this->Cell(32,5,$op_descuento,0,0,'C');
	$this->Cell(5);
	$this->RoundedRect(89,225,32,6,2,'D');
	$this->Cell(32,5,$op_subtotalcd,0,0,'C');
	$this->Cell(5);
	$this->RoundedRect(126,225,32,6,2,'D');
	$this->Cell(32,5,$op_iva,0,0,'C');
	$this->Cell(5);
	$this->RoundedRect(163,225,32,6,2,'D');
	$this->Cell(32,5,$op_total,0,0,'C');
	$this->Cell(5,5,'','R');
	$this->Ln(5);
	$this->Cell(190,4,'','RL');
	$this->Ln(4);
	$letras=@UserQuery("select numero_letras($op_total::numeric);",0);
//	$letras='123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890';
	if(strlen($letras)>107){
	    $letras1=substr($letras,0,107);
	    $letras2=substr($letras,107);
	}
	else{
	    $letras1=$letras;
	    $letras2='';
	}
	$this->Cell(5,4,'','L');
	$this->RoundedRect(15,235,180,8,2,'D');
	$this->Cell(180,4,'     Son Pesos: '.$letras1,0,0);
	$this->Cell(5,4,'','R');
	$this->Ln(4);
	$this->Cell(5,4,'','L');
	$this->Cell(180,4,'    '.$letras2,0,0);
	$this->Cell(5,4,'','R');
	$this->Ln(4);
	$this->Cell(190,4,'','RL',0);
	$this->Ln(4);
	$this->Cell(5,15,'','L');
	//ROUNDED
	$this->RoundedRect(15,247,180,15,2,'D');
	$this->Cell(180,15,'',0,0);
	$this->Cell(5,15,'','R');
	$this->Ln(15);
	$this->Cell(190,4,'','RL',0);
	$this->Ln(4);
	$this->SetFont('Arial','',6);
	$this->Cell(190,4,'     ORIENTACION AL CONSUMIDOR PROV. BS. AS. 0800-222-9042','LR',0,'C');
	$this->Ln(4);
	$this->Cell(190,15,'','RL',0);
	$this->Ln(15);
	$this->Cell(190,4,'','LBR',0);
//	$this->Cell(70,4,'     '.$caebar,'LR',0);
	$this->Ln(-10);
	$this->Cell(140,4,'',0,0);
	$this->Cell(50,4,'ORIGINAL',0,0,'C');

	
//	$this->Cell(190,4,$caebar,'LR',0);
	
	
       }

  function i25($xpos, $ypos, $code, $basewidth=1, $height=10){

      $wide = $basewidth;
      $narrow = $basewidth / 3 ;

      // wide/narrow codes for the digits
      $barChar['0'] = 'nnwwn';
      $barChar['1'] = 'wnnnw';
      $barChar['2'] = 'nwnnw';
      $barChar['3'] = 'wwnnn';
      $barChar['4'] = 'nnwnw';
      $barChar['5'] = 'wnwnn';
      $barChar['6'] = 'nwwnn';
      $barChar['7'] = 'nnnww';
      $barChar['8'] = 'wnnwn';
      $barChar['9'] = 'nwnwn';
      $barChar['A'] = 'nn';
      $barChar['Z'] = 'wn';

      // add leading zero if code-length is odd
      if(strlen($code) % 2 != 0){
          $code = '0' . $code;
      }

      // add start and stop codes
      $code = 'AA'.strtolower($code).'ZA';

      for($i=0; $i<strlen($code); $i=$i+2){
          // choose next pair of digits
          $charBar = $code[$i];
          $charSpace = $code[$i+1];
          // check whether it is a valid digit
          if(!isset($barChar[$charBar])){
              $this->Error('Invalid character in barcode: '.$charBar);
          }
          if(!isset($barChar[$charSpace])){
              $this->Error('Invalid character in barcode: '.$charSpace);
          }
          // create a wide/narrow-sequence (first digit=bars, second digit=spaces)
          $seq = '';
          for($s=0; $s<strlen($barChar[$charBar]); $s++){
              $seq .= $barChar[$charBar][$s] . $barChar[$charSpace][$s];
          }
          for($bar=0; $bar<strlen($seq); $bar++){
              // set lineWidth depending on value
              if($seq[$bar] == 'n'){
                  $lineWidth = $narrow;
              }else{
                  $lineWidth = $wide;
              }
              // draw every second value, because the second digit of the pair is represented by the spaces
              if($bar % 2 == 0){
                  $this->Rect($xpos, $ypos, $lineWidth, $height, 'F');
              }
              $xpos += $lineWidth;
          }
      }
      $this->barcodeRightX = $xpos;
  }

    function barcodeCaeAfip($xpos, $ypos, $code, $basewidth=0.8, $height=7){
      $this->i25($xpos, $ypos + 1, $code, $basewidth, $height);

      $this->SetFont('Arial','',8);
      $nroCAE = substr($code,17,14);
      $fechaVto = substr($code,-3,2).'/'.substr($code,-5,2).'/'.substr($code,-9,4);
      $txt = utf8_decode('CAE Nº ' . $nroCAE . '    Fecha Vto. CAE: ' . $fechaVto );
      $codeWidth = $this->barcodeRightX - $xpos;
      $strWidth = $this->GetStringWidth($txt);
      $space = ( $codeWidth - $strWidth ) / 2;    
      $this->Text($xpos + $space, $ypos, $txt );
      $this->SetFillColor(0);  

      $this->SetFont('Arial','',8);
      $codeWidth = $this->barcodeRightX - $xpos;
      $strWidth = $this->GetStringWidth($code);
      $space = ( $codeWidth - $strWidth ) / 2;    
      $this->Text($xpos + $space, $ypos + $height + 4, $code);
      $this->SetFillColor(0);
    }

 function RoundedRect($x, $y, $w, $h, $r, $style = '', $angle = '1234')
    {
        $k = $this->k;
        $hp = $this->h;
        if($style=='F')
            $op='f';
        elseif($style=='FD' or $style=='DF')
            $op='B';
        else
            $op='S';
        $MyArc = 4/3 * (sqrt(2) - 1);
        $this->_out(sprintf('%.2f %.2f m', ($x+$r)*$k, ($hp-$y)*$k ));
 
        $xc = $x+$w-$r;
        $yc = $y+$r;
        $this->_out(sprintf('%.2f %.2f l', $xc*$k, ($hp-$y)*$k ));
        if (strpos($angle, '2')===false)
            $this->_out(sprintf('%.2f %.2f l', ($x+$w)*$k, ($hp-$y)*$k ));
        else
            $this->_Arc($xc + $r*$MyArc, $yc - $r, $xc + $r, $yc - $r*$MyArc, $xc + $r, $yc);
 
        $xc = $x+$w-$r;
        $yc = $y+$h-$r;
        $this->_out(sprintf('%.2f %.2f l', ($x+$w)*$k, ($hp-$yc)*$k));
        if (strpos($angle, '3')===false)
            $this->_out(sprintf('%.2f %.2f l', ($x+$w)*$k, ($hp-($y+$h))*$k));
        else
            $this->_Arc($xc + $r, $yc + $r*$MyArc, $xc + $r*$MyArc, $yc + $r, $xc, $yc + $r);
 
        $xc = $x+$r;
        $yc = $y+$h-$r;
        $this->_out(sprintf('%.2f %.2f l', $xc*$k, ($hp-($y+$h))*$k));
        if (strpos($angle, '4')===false)
            $this->_out(sprintf('%.2f %.2f l', ($x)*$k, ($hp-($y+$h))*$k));
        else
            $this->_Arc($xc - $r*$MyArc, $yc + $r, $xc - $r, $yc + $r*$MyArc, $xc - $r, $yc);
 
        $xc = $x+$r ;
        $yc = $y+$r;
        $this->_out(sprintf('%.2f %.2f l', ($x)*$k, ($hp-$yc)*$k ));
        if (strpos($angle, '1')===false)
        {
            $this->_out(sprintf('%.2f %.2f l', ($x)*$k, ($hp-$y)*$k ));
            $this->_out(sprintf('%.2f %.2f l', ($x+$r)*$k, ($hp-$y)*$k ));
        }
        else
            $this->_Arc($xc - $r, $yc - $r*$MyArc, $xc - $r*$MyArc, $yc - $r, $xc, $yc - $r);
        $this->_out($op);
    }

    function _Arc($x1, $y1, $x2, $y2, $x3, $y3)
    {
        $h = $this->h;
        $this->_out(sprintf('%.2f %.2f %.2f %.2f %.2f %.2f c ', $x1*$this->k, ($h-$y1)*$this->k,
            $x2*$this->k, ($h-$y2)*$this->k, $x3*$this->k, ($h-$y3)*$this->k));
    }

}

?>