drop table amenity;
drop table eventos;
CREATE TABLE amenity (
    am_id integer NOT NULL,
    am_codemp integer NOT NULL,
    am_idptov integer NOT NULL,
    am_division integer NOT NULL,
    am_centro integer NOT NULL,
    am_codigo integer NOT NULL,
    am_nombre character varying(150) NOT NULL,
    am_cargo integer NOT NULL,
    am_descripcion text,
    am_duracion numeric,
    am_cantidad numeric,
    am_precio numeric(15,2),
    am_color character varying(7),
    am_img bytea,
    am_estado integer DEFAULT 1
);


ALTER TABLE public.amenity OWNER TO sanjor;

CREATE SEQUENCE amenity_am_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.amenity_am_id_seq OWNER TO sanjor;
ALTER SEQUENCE amenity_am_id_seq OWNED BY amenity.am_id;

ALTER TABLE ONLY amenity ALTER COLUMN am_id SET DEFAULT nextval('amenity_am_id_seq'::regclass);

ALTER TABLE ONLY amenity
    ADD CONSTRAINT amenity_pkey PRIMARY KEY (am_id);

ALTER TABLE ONLY amenity ADD CONSTRAINT "$1" FOREIGN KEY (am_idptov) REFERENCES ptovta(ptv_id);
ALTER TABLE ONLY amenity ADD CONSTRAINT "$2" FOREIGN KEY (am_division) REFERENCES division(div_id);
ALTER TABLE ONLY amenity ADD CONSTRAINT "$3" FOREIGN KEY (am_centro) REFERENCES centroc(cco_id);
ALTER TABLE ONLY amenity ADD CONSTRAINT "$4" FOREIGN KEY (am_cargo) REFERENCES cargos(car_id);
ALTER TABLE ONLY amenity ADD CONSTRAINT "$5" FOREIGN KEY (am_codemp) REFERENCES empresa(emp_codigo);


REVOKE ALL ON TABLE amenity FROM PUBLIC;
REVOKE ALL ON TABLE amenity FROM sanjor;
GRANT ALL ON TABLE amenity TO sanjor;
GRANT ALL ON TABLE amenity TO nobody;

REVOKE ALL ON SEQUENCE amenity_am_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE amenity_am_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE amenity_am_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE amenity_am_id_seq TO nobody;



CREATE TABLE eventos (
    evt_id integer NOT NULL,
    evt_codemp integer NOT NULL,
    evt_idptov integer NOT NULL,
    evt_division integer NOT NULL,
    evt_centro integer NOT NULL,
    evt_idcopr integer NOT NULL,
    evt_idamenity integer NOT NULL,
    evt_horad time without time zone,
    evt_horah time without time zone,
    evt_fecha date,
    evt_cantidad numeric,
    evt_estado integer DEFAULT -1
);


ALTER TABLE public.eventos OWNER TO sanjor;

CREATE SEQUENCE eventos_evt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.eventos_evt_id_seq OWNER TO sanjor;
ALTER SEQUENCE eventos_evt_id_seq OWNED BY eventos.evt_id;

ALTER TABLE ONLY eventos ALTER COLUMN evt_id SET DEFAULT nextval('eventos_evt_id_seq'::regclass);

ALTER TABLE ONLY eventos
    ADD CONSTRAINT eventos_pkey PRIMARY KEY (evt_id);

ALTER TABLE ONLY eventos ADD CONSTRAINT "$1" FOREIGN KEY (evt_idptov) REFERENCES ptovta(ptv_id);
ALTER TABLE ONLY eventos ADD CONSTRAINT "$2" FOREIGN KEY (evt_division) REFERENCES division(div_id);
ALTER TABLE ONLY eventos ADD CONSTRAINT "$3" FOREIGN KEY (evt_centro) REFERENCES centroc(cco_id);
ALTER TABLE ONLY eventos ADD CONSTRAINT "$4" FOREIGN KEY (evt_idcopr) REFERENCES coprop(cop_id);
ALTER TABLE ONLY eventos ADD CONSTRAINT "$5" FOREIGN KEY (evt_codemp) REFERENCES empresa(emp_codigo);
ALTER TABLE ONLY eventos ADD CONSTRAINT "$6" FOREIGN KEY (evt_idamenity) REFERENCES amenity(am_id);


REVOKE ALL ON TABLE eventos FROM PUBLIC;
REVOKE ALL ON TABLE eventos FROM sanjor;
GRANT ALL ON TABLE eventos TO sanjor;
GRANT ALL ON TABLE eventos TO nobody;

REVOKE ALL ON SEQUENCE eventos_evt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE eventos_evt_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE eventos_evt_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE eventos_evt_id_seq TO nobody;

