<?php

/*  
* SiZoFra - Sistema Informatico Zona Franca
* Propiedad Intelectual Exclusiva: CatWare Soluciones Informaticas de Fabian Gustavo Lopez    
*/

if(phpversion()>4.2)parse_str(apache_getenv("QUERY_STRING"));
session_start();
require("config.php");
require($INCLUDEBASE."library.php");
$user = CheckUserLogin($_SESSION['login'], $_SESSION['password']);
$gpo = $user["groupid"];
$codemp = $user["codemp"];
$ptovta = $user["ptovta"];
$cli = $user["cliente"];
$operador = $user["operador"];
$operador_id = $user["codigo"];
$printer=$_SESSION['printers'];
$login=$_SESSION['login'];
$password=$_SESSION['password'];

if($codemp) $astc_codemp=$codemp;

if($ptovta)
    $astc_idptov=$ptovta; 
  else
    if($codemp) 
	$astc_idptov=@UserQuery("select ptovdefault($codemp)",0);

if($astc_idptov)$ash_idptov=$astc_idptov;


$tipctadxv=@UserQuery("select valvaramb($codemp,$astc_idptov,'TIPCTADXV')",0);
$tipctadxc=@UserQuery("select valvaramb($codemp,$astc_idptov,'TIPCTADXC')",0);
$cta_deudxv=UserQuery("select idcbl($codemp,$astc_idptov,valvaramb($codemp,$astc_idptov,'DEUDXV')::integer)",0);
$cta_deudxc=UserQuery("select idcbl($codemp,$astc_idptov,valvaramb($codemp,$astc_idptov,'DEUDXC')::integer)",0);

function estaEnVector($numero,$vector){
    for($m=0;$vector[$m];$m++){
	$num=$vector[$m];
	if($num==$numero)
	    return true;
    }
    return false;
}


function columna_exc($numero){
    $res="";
    while($numero > -1){
	$lett = $numero % 26;
	$res = chr(65+$lett).$res;
	$numero=intval($numero/26)-1;
    }
    return $res;
}




switch($accion){


case 'EXCEL':

	if(!$codemp)
	    $existe=@UserQuery("select emp_codigo from empresa where emp_codigo=$astc_codemp",0);

	if(!$existe && !$codemp)
		$mensaje='La Empresa Definida no Existe Utilize la Busqueda';

	if($mensaje)
	    {
	    echo("<BR></BR>");
	    echo(" <CENTER><H3> <Caption class=\"text\">$mensaje</Caption></H3></CENTER>\n");
	    echo("<BR></BR>");
	    echo("<CENTER><A HREF=\"javascript:history.go(-1)\">Volver</A></CENTER>");
	    exit();
	    } 


	$fecha = date("d-m-Y");
	$nomemp=UserQuery("select nomemp($astc_codemp)",0);
	$nomptv=UserQuery("select descptv($elidptov)",0);
	$clq_comprob=@UserQuery("select idcomp($codemp,$elidptov,valvaramb($codemp,$elidptov,'CMPQL'));",0);

	$eg_codemp=$codemp;
	$eg_idptov=$elidptov;

	$cta_depsi=@UserQuery("select idcble($codemp,$elidptov,'CTADEPSI')",0);
	$cta_caja=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'CAJA')::smallint)",0);
	$cta_cheque=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'CHEQUE')::smallint)",0);
	$cta_deudxv=UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'DEUDXV')::smallint)",0);
	$cta_banco=@UserQuery("select idcble($codemp,$elidptov,'BANCO')",0);
	$tcta_banco=@UserQuery("select tipctacbl($cta_banco)",0);
	$cta_ff=@UserQuery("select idcble($codemp,$elidptov,'CTAFF')",0);
	$tcta_ff=@UserQuery("select tipctacbl($cta_ff)",0);
	$cta_monex=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'MONEX')::smallint)",0);
	$cta_ajuste=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'AJUSTE')::smallint)",0);
	$cta_1242=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'1242')::smallint)",0);
	$cta_1245=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'1245')::smallint)",0);
	$cargoCesped=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOCESPED')",0);
	$cargoEnergia=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOENERGIA')",0);
	$cargoFEventos=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOFEVENTOS')",0);
	$cargoFamiliar=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOFAMILIAR')",0);
	$cargoRedondeo=@UserQuery("select valvaramb($codemp,$elidptov,'REDONDEO')",0);
	$cargoIduf=@UserQuery("select valvaramb($codemp,$elidptov,'IDUF')",0);
	$cargoInteres=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOINT')",0);
	$cargoReserva=@UserQuery("select valvaramb($codemp,$elidptov,'CARGORESERVA')",0);
	$cargo80=80;
	$rubcarord=@UserQuery("select valvaramb($codemp,$astc_idptov,'RUBROORDINARIAS')");

	$qLiq=PgDoQuery("select l_id,l_comprob,l_numero,l_fecvto,l_feccie from liquidacion where l_idptov=$elidptov and l_feccie<='$fechah' and l_estado=2 order by 1 desc limit 1;");
	$rLiq=pg_numRows($qLiq);
	if($rLiq){
	    $idliq=Resultado($qLiq,0,"l_id",1);
	    $comprob=Resultado($qLiq,0,"l_comprob",1);
	    $numero=Resultado($qLiq,0,"l_numero",1);
	    $fecvto=Resultado($qLiq,0,"l_fecvto",1);
	    $feccie=Resultado($qLiq,0,"l_feccie",1);
	}
	$mes=@UserQuery("select date_part('month','$feccie'::date);",0);
	$anio=@UserQuery("select date_part('year','$feccie'::date);",0);

	$eg_mes=$mes;
	$eg_anio=$anio;
	$qCompliqCar=PgDoQuery("select distinct(cl_cargo) as cargo,cl_tipo from compliquid where cl_idliq=$idliq and cl_tipo not in (4) order by cl_tipo");
	$fCompliqCar=pg_numRows($qCompliqCar);
	for($jjj=0;$jjj<$fCompliqCar;$jjj++){
	    $cargoCompliquid=Resultado($qCompliqCar,$jjj,"cargo",1);
	    if($jjj==0)
		$cargosProrrata=$cargoCompliquid;
	    else
		$cargosProrrata.=",".$cargoCompliquid;
	}
	if(!$cargosProrrata) $cargosProrrata=-10;

	$columnas=9;
	$tieneDescuf=@UserQuery("select count(distinct(cop_descuf)) from coprop where cop_descuf!='NN' and cop_descuf!='1' and cop_descuf!=cop_unifun::varchar and cop_idptov=$elidptov;",0);
	$tieneCesped=@UserQuery("select sum(clq_importe) from compliq where clq_cargo=$cargoCesped and clq_idliq=$idliq",0);
	$tiene80=@UserQuery("select sum(clq_importe) from compliq where clq_cargo=$cargo80 and clq_idliq=$idliq",0);
	$tieneEnergia=@UserQuery("select sum(clq_importe) from compliq where clq_cargo=$cargoEnergia and clq_idliq=$idliq",0);
	$tieneEventos=@UserQuery("select sum(clq_importe) from compliq where clq_cargo=$cargoFEventos and clq_idliq=$idliq",0);
	$tieneFamiliar=@UserQuery("select sum(clq_importe) from compliq where clq_cargo=$cargoFamiliar and clq_idliq=$idliq",0);
	$tieneRedondeo=@UserQuery("select sum(clq_impngi) from compliq where (clq_cargo=$cargoRedondeo or clq_cargo=$cargoIduf) and clq_idliq=$idliq",0);
	$tieneReserva=@UserQuery("select sum(clq_importe) from compliq where clq_cargo=$cargoReserva and clq_idliq=$idliq",0);
	$tieneCargosDirectos=@UserQuery("select sum(clq_importe+clq_impngi+clq_interes) from compliq where clq_cargo not in ($cargoReserva,$cargoRedondeo,$cargoIduf,$cargo80,$cargoCesped,$cargoEnergia,$cargoFEventos,$cargoFamiliar,$cargoInteres,$cargosProrrata) and clq_rubcar!=7 and clq_idliq=$idliq",0);
	$aplicaDescuento=@UserQuery("select ptv_aplicadesc from ptovta where ptv_id=$elidptov;",0);

	if($tieneDescuf!=0)$columnas=$columnas+2;
	if($tieneEnergia!=0)$columnas=$columnas+2;
	if($tieneFamiliar!=0)$columnas=$columnas+2;
	if($tieneCargosDirectos!=0)$columnas=$columnas+2;
	if($aplicaDescuento==3)$columnas=$columnas+2; else $columnas++;
	if($tieneCesped!=0)$columnas++;
	if($tiene80!=0)$columnas++;
	if($tieneEventos!=0)$columnas++;
	if($tieneReserva!=0)$columnas++;
	if($tieneRedondeo)$columnas++;
	$qCompliquid=PgDoQuery("select distinct(trim(cl_leyen)) as leyen,cl_tipo from compliquid where cl_idliq=$idliq and cl_tipo not in (4) order by cl_tipo");
	$fCompliquid=pg_numRows($qCompliquid);
	for($iii=0;$iii<$fCompliquid;$iii++){
	    $columnas++;
	}

	$encabezadoBarrio=@UserQuery("select lpt_link from logosptv where lpt_idptov=$elidptov and lpt_tipo=2",0);

	$filename="Liq. $nomptv $mes-$anio.xls";
	header("Content-type: application/vnd.ms-excel");
	header("Content-Disposition: attachment; filename=$filename" );
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
	header("Pragma: public");

require_once "HTML/Entities.php";


	$workbook = new Workbook("-");
	$worksheet1 =& $workbook->add_worksheet("GRILLA");

	// letra 10, negrita, fondo azul
	$workbook->set_custom_color(12, 217, 217, 217);
	$encabezado =& $workbook->add_format();
	$encabezado->set_size(10);
	$encabezado->set_align('center');
	$encabezado->set_align('vcenter');
	$encabezado->set_bold();
	$encabezado->set_color('black');
	$encabezado->set_pattern();
	$encabezado->set_fg_color('white');
	$encabezado->set_border(2);
	$encabezado->set_text_wrap();

	$encabezado1 =& $workbook->add_format();
	$encabezado1->set_size(10);
	$encabezado1->set_align('center');
	$encabezado1->set_align('vcenter');
	$encabezado1->set_bold();
	$encabezado1->set_color('white');
	$encabezado1->set_pattern();
	$encabezado1->set_fg_color('black');
	$encabezado1->set_border(2);
	$encabezado1->set_right_color('white');
	$encabezado1->set_left_color('white');
	$encabezado1->set_text_wrap();

	$encabezado2 =& $workbook->add_format();
	$encabezado2->set_size(10);
	$encabezado2->set_align('left');
	$encabezado2->set_align('vcenter');
	$encabezado2->set_bold();
	$encabezado2->set_color('white');
	$encabezado2->set_pattern();
	$encabezado2->set_fg_color('black');
	$encabezado2->set_border(2);
//	$encabezado2->set_right_color('white');
//	$encabezado2->set_left_color('white');
	$encabezado2->set_text_wrap();

	$encabezado3 =& $workbook->add_format();
	$encabezado3->set_size(10);
	$encabezado3->set_align('left');
	$encabezado3->set_align('vcenter');
	$encabezado3->set_bold();
	$encabezado3->set_color('black');
	$encabezado3->set_pattern();
	$encabezado3->set_fg_color('white');
	$encabezado3->set_border(2);
	$encabezado3->set_text_wrap();

	$titulos =& $workbook->add_format();
	$titulos->set_size(12);
	$titulos->set_align('center');
	$titulos->set_bold();
	$titulos->set_border(2);
	$titulos->set_pattern();
	$titulos->set_fg_color('white');

	$numero5 =& $workbook->add_format();
	$numero5->set_size(10);
	$numero5->set_align('right');
	$numero5->set_pattern();
	$numero5->set_fg_color('white');
	$numero5->set_border(1);
//	$numero5->set_num_format('0.00000');

	$numero5c =& $workbook->add_format();
	$numero5c->set_size(10);
	$numero5c->set_align('right');
	$numero5c->set_pattern();
	$numero5c->set_fg_color(12);
	$numero5c->set_border(1);
//	$numero5c->set_num_format('0.00000');


	$numero =& $workbook->add_format();
	$numero->set_size(10);
	$numero->set_align('right');
	$numero->set_pattern();
	$numero->set_fg_color('white');
	$numero->set_border(1);
	$numero->set_num_format('0.00');

	$numerorb =& $workbook->add_format();
	$numerorb->set_size(10);
	$numerorb->set_align('right');
	$numerorb->set_pattern();
	$numerorb->set_fg_color('white');
	$numerorb->set_right(1);
	$numerorb->set_num_format('0.00');

	$numerorba =& $workbook->add_format();
	$numerorba->set_size(10);
	$numerorba->set_align('right');
	$numerorba->set_pattern();
	$numerorba->set_fg_color('white');
	$numerorba->set_right(1);
	$numerorba->set_bottom(1);
	$numerorba->set_num_format('0.00');


	$numeroc =& $workbook->add_format();
	$numeroc->set_size(10);
	$numeroc->set_align('right');
	$numeroc->set_pattern();
	$numeroc->set_fg_color(12);
	$numeroc->set_border(1);
	$numeroc->set_num_format('0.00');

	$cuerpo =& $workbook->add_format();
	$cuerpo->set_size(10);
	$cuerpo->set_align('left');
	$cuerpo->set_pattern();
	$cuerpo->set_fg_color('white');
	$cuerpo->set_border(1);

	$cuerpoc =& $workbook->add_format();
	$cuerpoc->set_size(10);
	$cuerpoc->set_align('left');
	$cuerpoc->set_pattern();
	$cuerpoc->set_fg_color(12);
	$cuerpoc->set_border(1);

	$cuerpoz =& $workbook->add_format();
	$cuerpoz->set_size(9);
	$cuerpoz->set_align('center');
	$cuerpoz->set_align('vcenter');
	$cuerpoz->set_fg_color('white');
	$cuerpoz->set_border(1);
	$cuerpoz->set_text_wrap();

	$cuerpocen =& $workbook->add_format();
	$cuerpocen->set_size(10);
	$cuerpocen->set_align('center');
	$cuerpocen->set_pattern();
	$cuerpocen->set_fg_color('white');
	$cuerpocen->set_border(1);

	$cuerpocenc =& $workbook->add_format();
	$cuerpocenc->set_size(10);
	$cuerpocenc->set_align('center');
	$cuerpocenc->set_pattern();
	$cuerpocenc->set_fg_color(12);
	$cuerpocenc->set_border(1);

	$cabez=1;
	$intro=5;
	$cuerpo1=9;

/*
	if($encabezadoBarrio){
//	    $lnk="https://siac.lopezmelnyk.com/web/subidas/".$encabezadoBarrio;
	    $lnk=$encabezadoBarrio;
	    $worksheet1->merge_cells($cabez,0,$cabez+5,15);
	    $worksheet1->insert_bitmap($cabez,0,"$lnk");
//	    $worksheet1->insert_image($cabez,0,"$lnk");
	}
*/
	$mes=@UserQuery("select lpad('$mes',2,'0');",0);
	$worksheet1->write_string($intro,0, "$nomptv Liquidacion del mes de $mes-$anio                       Fecha Vencimiento: $fecvto",$titulos);
	for($kk=1;$kk<$columnas;$kk++){
	    $worksheet1->write_blank($intro,$kk,$titulos);
	}
	$worksheet1->merge_cells($intro,0,$intro,$columnas-1);


	$nCol=0;
	$worksheet1->write_string($cuerpo1-2, $nCol,'UF',$encabezado1);
	$worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	$nCol++;
	if($tieneDescuf!=0){
	    $worksheet1->write_string($cuerpo1-2, $nCol,'Desc. UF',$encabezado1);
	    $worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	    $worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	}
	$worksheet1->write_string($cuerpo1-2, $nCol,'Propietario',$encabezado1);
	$worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	$nCol++;
	$worksheet1->write_string($cuerpo1-2, $nCol,'%',$encabezado1);
	$worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	$nCol++;

	$worksheet1->write_string($cuerpo1-2, $nCol,'SALDOS ANTERIORES',$encabezado1);
	$worksheet1->write_blank($cuerpo1-2,$nCol+1,$encabezado1);
	$worksheet1->write_blank($cuerpo1-2,$nCol+2,$encabezado1);
	$worksheet1->write_blank($cuerpo1-2,$nCol+3,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1-2,$nCol+3);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	$worksheet1->write_blank($cuerpo1,$nCol+1,$encabezado);
	$worksheet1->write_blank($cuerpo1,$nCol+2,$encabezado);
	$worksheet1->write_blank($cuerpo1,$nCol+3,$encabezado);

	$worksheet1->write_string($cuerpo1-1, $nCol,'Sal. Ant.',$encabezado);
	$worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	$nCol++;
	$worksheet1->write_string($cuerpo1-1, $nCol,'Ajustes',$encabezado);
	$worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	$nCol++;
	$worksheet1->write_string($cuerpo1-1, $nCol,'Pagos',$encabezado);
	$worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	$nCol++;
	$worksheet1->write_string($cuerpo1-1, $nCol,'Importe Mora',$encabezado);
	$worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	$nCol++;
	$nColInicial=$nCol;
	$worksheet1->write_string($cuerpo1-2, $nCol,'CARGOS DEL PERIODO',$encabezado1);
	$worksheet1->write_blank($cuerpo1, $nCol,$encabezado);
	$worksheet1->write_string($cuerpo1-1, $nCol,'Interes Mora',$encabezado);
	$worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	$nCol++;
	for($iii=0;$iii<$fCompliquid;$iii++){
	    $leyen=Resultado($qCompliquid,$iii,"leyen",1);
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,$leyen,$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	}
	if($tieneReserva!=0){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Fondo Reserva',$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	}
	if($tieneCesped!=0){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Manten. Cesped',$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	}
	if($tiene80!=0){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Dev. Edenor',$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	}
	if($tieneEnergia!=0){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1-2,$nCol+1,$encabezado1);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Energia Electrica',$encabezado);
	    $worksheet1->write_blank($cuerpo1-1,$nCol+1,$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1-1,$nCol+1);

	    $worksheet1->write_string($cuerpo1, $nCol,'Cantidad',$encabezado);
	    $nCol++;
	    $worksheet1->write_string($cuerpo1, $nCol,'Importe',$encabezado);
	    $nCol++;
	}
	if($tieneEventos!=0){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Fondo Eventos',$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	}
	if($tieneFamiliar!=0){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1-2,$nCol+1,$encabezado1);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Grupo Familiar',$encabezado);
	    $worksheet1->write_blank($cuerpo1-1,$nCol+1,$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1-1,$nCol+1);

	    $worksheet1->write_string($cuerpo1, $nCol,'Cantidad',$encabezado);
	    $nCol++;
	    $worksheet1->write_string($cuerpo1, $nCol,'Importe',$encabezado);
	    $nCol++;
	}
	if($tieneCargosDirectos!=0){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1-2,$nCol+1,$encabezado1);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Cargos Directos',$encabezado);
	    $worksheet1->write_blank($cuerpo1-1,$nCol+1,$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1-1,$nCol+1);

	    $worksheet1->write_string($cuerpo1, $nCol,'Codigo',$encabezado);
	    $nCol++;
	    $worksheet1->write_string($cuerpo1, $nCol,'Importe',$encabezado);
	    $nCol++;
	}
	if($tieneRedondeo){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Redondeo',$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	}
	$worksheet1->merge_cells($cuerpo1-2,$nColInicial,$cuerpo1-2,$nCol-1);
	if($aplicaDescuento==3){
	    $fecint=@UserQuery("select ptv_fecint from ptovta where ptv_id=$elidptov",0);
	    $worksheet1->write_string($cuerpo1-2, $nCol,'Total A Pagar Antes del '."$fecint",$encabezado1);
	    $worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	    $worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	    $worksheet1->write_string($cuerpo1-2, $nCol,'Total A Pagar Despues del '."$fecint",$encabezado1);
	    $worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	    $worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	}else{
	    $worksheet1->write_string($cuerpo1-2, $nCol,'Total',$encabezado1);
	    $worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	    $worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	}
	if($tieneDescuf!=0){
	    $worksheet1->write_string($cuerpo1-2, $nCol,'Desc. UF',$encabezado1);
	    $worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	    $worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	    $nCol++;
	}
	$worksheet1->write_string($cuerpo1-2, $nCol,'UF',$encabezado1);
	$worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	$nCol++;


	$fechaini=@UserQuery("select '01-'||lpad(date_part('month','$feccie'::date)::text,2,'0')||'-'||date_part('Y','$feccie'::date);",0);

	$tsalant=$tcobran=$tajus=$tsaldo=$tcargos=0;


	$query="select * from coprop 
			where cop_codemp=$codemp and cop_idptov=$elidptov and cop_estado!=3 order by cop_unifun;";
	$r=PgDoQuery($query);
	$rows=pg_NumRows($r);
	$leyenCargos=array();
	$indexCargos=0;
	$desde=$cuerpo1+1;
	for($i=0; $i < $rows ; $i++){
	    $nCol=0;
	    $salant=$cobran=$ajus=$saldo=$cargos=$totlinea=0;
	    $cop_id=Resultado($r,$i,"cop_id",1);
	    $cop_unifun=Resultado($r,$i,"cop_unifun",1);
	    $cop_descuf=Resultado($r,$i,"cop_descuf",1);
	    $cop_nombre=Resultado($r,$i,"cop_nombre",1);
	    $cop_porc=Resultado($r,$i,"cop_porc1",1);

	    $cero=@UserQuery("select 0::numeric(15,2);",0);
	    $salant=@UserQuery("select sum(astc_importe)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado=2 and astc_ctacble=$cta_deudxv and astc_tipcta=99 and astc_ctacte=$cop_id and date_lt(astc_fecval,'$fechaini'::date);",0);
	    if(!$salant)$salant=$cero;
	    $ajus=@UserQuery("select sum(astc_importe)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado=2 and astc_ctacble=$cta_ajuste and astc_ctacte=$cop_id and date_ge(astc_fecval,'$fechaini'::date) and date_le(astc_fecval,'$feccie'::date);",0);
	    $ajus+=@UserQuery("select sum(astc_importe)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado=2 and codcble(astc_ctacble)>2999 and codcble(astc_ctacble)<4000 and astc_ctacte=$cop_id and date_ge(astc_fecval,'$fechaini'::date) and date_le(astc_fecval,'$feccie'::date);",0);
	    if(!$ajus)$ajus=$cero;
	    $cobran=@UserQuery("select (sum(astc_importe*-1)-($ajus))::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado!=999 and astc_ctacte=$cop_id and astc_comprob!=10 and astc_ctacble=$cta_deudxv and date_ge(astc_fecval,'$fechaini'::date) and date_le(astc_fecval,'$feccie'::date);",0);
	    if(!$cobran)$cobran=$cero;
	    $saldo=$salant-$ajus-$cobran;
	    $saldo=@UserQuery("select $saldo::numeric(15,2);",0);

	    $intmora=@UserQuery("select sum(clq_interes)::numeric(15,2) from compliq where clq_idcopr=$cop_id and clq_idliq=$idliq and clq_estado=2",0);
	    if(!$intmora) $intmora=$cero;

	    if($ajus!=0)
		$ajus*=-1;

	    if($i%2==0){
		$fnum=$numeroc;
		$flet=$cuerpoc;
		$fletcent=$cuerpocenc;
		$fuf=$numero5c;
	    }else{
		$fnum=$numero;
		$flet=$cuerpo;
		$fletcent=$cuerpocen;
		$fuf=$numero5;
	    }

	    $tsalant+=$salant;
	    $tcobran+=$cobran;
	    $tajus+=$ajus;
	    $tsaldo+=$saldo;
	    $tintmora+=$intmora;

	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$cop_unifun",$fuf);
	    $nCol++;
	    if($tieneDescuf!=0){
		$worksheet1->write_string($cuerpo1+1+$i, $nCol,"$cop_descuf",$fletcent);
		$nCol++;
	    }
	    $cop_nombre=ereg_replace("","&Eacute;",$cop_nombre);
	    $cop_nombre=ereg_replace("","&Aacute;",$cop_nombre);
	    $cop_nombre=ereg_replace("","&Iacute;",$cop_nombre);
	    $cop_nombre=ereg_replace("","&Oacute;",$cop_nombre);
	    $cop_nombre=ereg_replace("","&Uacute;",$cop_nombre);
	    $cop_nombre=ereg_replace("","&Ntilde;",$cop_nombre);

	    $nombre=HTML_Entities::decode($cop_nombre, HTML_Entities::ALL, "latin1");
	    $worksheet1->write_string($cuerpo1+1+$i, $nCol,"$nombre",$flet);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$cop_porc",$fnum);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$salant",$fnum);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$ajus",$fnum);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$cobran",$fnum);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$saldo",$fnum);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$intmora",$fnum);
	    $nCol++;

	    $totlinea=$saldo+$intmora;
	    $totlineaAnt=$saldo+$intmora;

	    $totExpensas=0;
	    for($iii=0;$iii<$fCompliquid;$iii++){
		$leyen=Resultado($qCompliquid,$iii,"leyen",1);
		$importeCl=@UserQuery("select sum(clq_importe+clq_impngi+clq_interes)::numeric(15,2) from compliq where trim(clq_leyen)=trim('$leyen') and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		$cargoCl=@UserQuery("select clq_rubcar from compliq where trim(clq_leyen)=trim('$leyen') and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		if($cargoCl==$rubcarord){
		    $totExpensas+=$importeCl;
		}else{
		    $totlineaAnt+=$importeCl;
		}
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeCl",$fnum);
		$nCol++;
		$totlinea+=$importeCl;
	    }
	    if($tieneReserva!=0){
		$importeReserva=0;
		$importeReserva=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo=$cargoReserva and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeReserva",$fnum);
		$nCol++;
		$totlinea+=$importeReserva;
		$totlineaAnt+=$importeReserva;
	    }
	    if($tieneCesped!=0){
		$importeCesped=0;
		$importeCesped=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo=$cargoCesped and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeCesped",$fnum);
		$nCol++;
		$totlinea+=$importeCesped;
		$totlineaAnt+=$importeCesped;
	    }
	    if($tiene80!=0){
		$importe80=0;
		$importe80=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo=$cargo80 and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importe80",$fnum);
		$nCol++;
		$totlinea+=$importe80;
		$totlineaAnt+=$importe80;
	    }
	    if($tieneEnergia!=0){
		$cantEnergia=@UserQuery("select sum(clq_canti) from compliq where clq_cargo=$cargoEnergia and clq_idliq=$idliq and clq_idcopr=$cop_id",0);
		$importeEnergia=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo=$cargoEnergia and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$cantEnergia",$fnum);
		$nCol++;
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeEnergia",$fnum);
		$nCol++;
		$totlinea+=$importeEnergia;
		$totlineaAnt+=$importeEnergia;
	    }
	    if($tieneEventos!=0){
		$importeEventos=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo=$cargoFEventos and clq_idliq=$idliq and clq_estado=2 and clq_idcopr=$cop_id",0);
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,$importeEventos,$fnum);
		$nCol++;
		$totlinea+=$importeEventos;
		$totlineaAnt+=$importeEventos;
	    }
	    if($tieneFamiliar!=0){
		$cantiFamiliar=@UserQuery("select sum(clq_canti) from compliq where clq_cargo=$cargoFamiliar and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$importeFamiliar=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo=$cargoFamiliar and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$cantiFamiliar",$fnum);
		$nCol++;
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeFamiliar",$fnum);
		$nCol++;
		$totlinea+=$importeFamiliar;
		$totlineaAnt+=$importeFamiliar;
	    }

	    if($tieneCargosDirectos!=0){
		$importeCargosDirectos=@UserQuery("select sum(clq_importe+clq_impngi+clq_interes)::numeric(15,2) from compliq where clq_cargo not in ($cargoReserva,$cargoRedondeo,$cargoIduf,$cargo80,$cargoCesped,$cargoEnergia,$cargoFEventos,$cargoFamiliar,$cargoInteres,$cargosProrrata) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_rubcar!=7 and clq_estado=2",0);
		$qCargos=PgDoQuery("select distinct(clq_cargo) as cargo from compliq where clq_cargo not in ($cargoReserva,$cargoRedondeo,$cargoIduf,$cargo80,$cargoCesped,$cargoEnergia,$cargoFEventos,$cargoFamiliar,$cargoInteres,$cargosProrrata) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2 and clq_rubcar!=7");
		$rCargos=pg_numRows($qCargos);
		$str="";
		for($jji=0;$jji<$rCargos;$jji++){
		    $car_idmm=Resultado($qCargos,$jji,"cargo",1);
		    if(!estaEnVector($car_idmm,$leyenCargos)){
			$leyenCargos[$indexCargos]=$car_idmm;
			$indexCargos++;
		    }
		    $descCargommi=$car_idmm;
		    if($jji==0)
			$str=$descCargommi;
		    else
			$str.=" - ".$descCargommi;
		}
		$worksheet1->write_string($cuerpo1+1+$i, $nCol,"$str",$fletcent);
		$nCol++;
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeCargosDirectos",$fnum);
		$nCol++;
		$totlinea+=$importeCargosDirectos;
		$totlineaAnt+=$importeCargosDirectos;
	    }

	    if($tieneRedondeo){
		$importeRedondeo=@UserQuery("select sum(clq_impngi)::numeric(15,2) from compliq where (clq_cargo=$cargoRedondeo or clq_cargo=$cargoIduf) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$identificador=@UserQuery("select sum(clq_impngi)::numeric(15,2) from compliq where clq_cargo=$cargoIduf and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		if(!$identificador) $identificador=0;
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeRedondeo",$fnum);
		$nCol++;
		$totlinea+=$importeRedondeo;
	    }
	    if($aplicaDescuento==3){
		$tasaDescuento=@UserQuery("select int_valor from interes where int_idptov=$elidptov and int_tipo=2 order by int_fecha desc limit 1");
		if(!$tasaDescuento) $tasaDescuento=10;
		$importeExp=($totExpensas*((100-$tasaDescuento)/100))+$totlineaAnt;
		$importeFinalExpensas=round($importeExp)+$identificador;
		$totlineaAnt=$importeFinalExpensas;
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$totlineaAnt",$fnum);
		$nCol++;
	        $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$totlinea",$fnum);
		$nCol++;
	    }else{
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$totlinea",$fnum);
		$nCol++;
	    }
	    if($tieneDescuf!=0){
		$worksheet1->write_string($cuerpo1+1+$i, $nCol,"$cop_descuf",$fletcent);
		$nCol++;
	    }
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$cop_unifun",$fuf);
	    $nCol++;
	}
	$hasta=$cuerpo1+$rows+1;

	if($tieneDescuf!=0){
	    $empiezo=3;
	    $fin=$columnas-2;
	}else{
	    $empiezo=2;
	    $fin=$columnas-1;
	}
	for($l=$empiezo; $l < $fin ; $l++){
	    $ini=columna_exc($l);
	    $inicio=$ini.$desde;
	    $final=$ini.$hasta;
	    if($l<27)
		$worksheet1->write_formula($hasta, $l,  "= SUM($inicio:$final)",$numero);
	    else
		if($l==27)
		    $worksheet1->write_formula($hasta, $l,"=SUM(BA$desde:BA$hasta)",$numero);
		else
		    if($l==28)
			$worksheet1->write_formula($hasta, $l,  "= SUM(CA$desde:CA$hasta)",$numero);
		    else
			if($l==29)
			    $worksheet1->write_formula($hasta, $l,  "= SUM(DA$desde:DA$hasta)",$numero);
			else
			    if($l==30)
				$worksheet1->write_formula($hasta, $l,  "= SUM(EA$desde:EA$hasta)",$numero);
			    else
				if($l==31)
				    $worksheet1->write_formula($hasta, $l,  "= SUM(FA$desde:FA$hasta)",$numero);
				else
				    if($l==32)
					$worksheet1->write_formula($hasta, $l,  "= SUM(GA$desde:GA$hasta)",$numero);
	}

	array_multisort($leyenCargos);
	for($m=0;$leyenCargos[$m];$m++){
	    $descCargomm=@UserQuery("select car_nombre from cargos where car_id=$leyenCargos[$m]",0);
	    $descCargommi=$leyenCargos[$m].": ".$descCargomm;
	    if($m==0)
		$strf=$descCargommi;
	    else
		$strf.=" - ".$descCargommi;
	}

	$leyendasCargos=$hasta+3;
	$worksheet1->write_string($leyendasCargos, 0,"$strf",$cuerpoz);
	$worksheet1->write_blank($leyendasCargos+1,0,$cuerpoz);
	for($kk=1;$kk<$columnas;$kk++){
	    $worksheet1->write_blank($leyendasCargos,$kk,$cuerpoz);
	    $worksheet1->write_blank($leyendasCargos+1,$kk,$cuerpoz);
	}
	$worksheet1->merge_cells($leyendasCargos,0,$leyendasCargos+1,$columnas-1);


	//RESUMEN FINANCIERO


	if($eg_mes<10) $elmes='0'.$eg_mes; else $elmes=$eg_mes;
	$fechaini='01-'.$elmes.'-'.$eg_anio;
	if($eg_mes==12) {$elmesp=1; $elaniop=$eg_anio+1;} else {$elmesp=$eg_mes+1; $elaniop=$eg_anio;}
	if($elmesp<10) $elmesp='0'.$elmesp;
	$fechafin='01-'.$elmesp.'-'.$elaniop;


	$ash_idptov=$eg_idptov;
	$ash_codemp=$codemp;

	$eg_mes=@UserQuery("select lpad('$eg_mes',2,'0');",0);
	$cbte_ID=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPID'));",0);
	$cbte_OI=@UserQuery("select idcomp($codemp,$eg_idptov,'OI');",0);
	$cbte_OE=@UserQuery("select idcomp($codemp,$eg_idptov,'OE');",0);
	$cbte_RC=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPRC'));",0);

	$cta_depsi=@UserQuery("select idcble($codemp,$eg_idptov,'CTADEPSI')",0);
	$cta_caja=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'CAJA')::smallint)",0);
	$cta_cheque=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'CHEQUE')::smallint)",0);
	$cta_deudxv=UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'DEUDXV')::smallint)",0);
	$cta_banco=@UserQuery("select idcble($codemp,$ash_idptov,'BANCO')",0);
	$tcta_banco=@UserQuery("select tipctacbl($cta_banco)",0);
	$cta_ff=@UserQuery("select idcble($codemp,$ash_idptov,'CTAFF')",0);
	$tcta_ff=@UserQuery("select tipctacbl($cta_ff)",0);
	$cta_monex=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'MONEX')::smallint)",0);
	$cta_ajuste=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'AJUSTE')::smallint)",0);
	$cta_1242=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'1242')::smallint)",0);
	$cta_1245=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'1245')::smallint)",0);

	$salant=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and codcble(astc_ctacble)<3000 and astc_ctacble not in ($cta_deudxv,$cta_ajuste,$cta_depsi) and date_lt(astc_fecval,'$fechaini'::date);",0);
	if(!$salant)$salant=0;
	$salant=@UserQuery("select $salant::numeric(15,2);",0);

	$ingper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_RC,$cbte_ID) and astc_ctacble in ($cta_caja,$cta_cheque,$cta_banco,$cta_ff,$cta_monex,$cta_1242,$cta_1245,$cta_depsi) and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$ingper)$ingper=0;
	$ingper=@UserQuery("select $ingper::numeric(15,2);",0);

	$oingper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_OI) and astc_importe>0 and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$oingper)$oingper=0;
	$oingper=@UserQuery("select $oingper::numeric(15,2);",0);

	$suming=$ingper+$oingper;
	if(!$suming)$suming=0;
	$suming=@UserQuery("select $suming::numeric(15,2);",0);

	$depsia=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_ctacble=$cta_depsi and date_lt(astc_fecval,'$fechaini'::date);",0);
	if(!$depsia)$depsia=0;
	$depsia=@UserQuery("select $depsia::numeric(15,2);",0);

	$depsi=@UserQuery("select sum(astc_importe)*-1 from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_ctacble=$cta_depsi and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$depsi)$depsi=0;
	$depsi=@UserQuery("select $depsi::numeric(15,2);",0);

	$sumds=$depsia+$depsi;
	if(!$sumds)$sumds=0;
	$sumds=@UserQuery("select $sumds::numeric(15,2);",0);


	$gasper=@UserQuery("select sum(eg_importe)*-1 from liqegr where eg_codemp=$codemp and eg_idptov=$eg_idptov and eg_anio=$eg_anio and eg_mes=$eg_mes and eg_estado=2;",0);
	if(!$gasper)$gasper=0;
	$gasper=@UserQuery("select $gasper::numeric(15,2);",0);

	$oegper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_OE) and astc_importe<0 and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$oegper)$oegper=0;
	$oegper=@UserQuery("select $oegper::numeric(15,2);",0);

	$sumeg=$gasper+$oegper;
	if(!$sumeg)$sumeg=0;
	$sumeg=@UserQuery("select $sumeg::numeric(15,2);",0);

	$saldo=$salant+$ingper+$oingper+$depsia+$depsi+$gasper+$oegper;
	if(!$saldo)$saldo=0;
	$saldo=@UserQuery("select $saldo::numeric(15,2);",0);

	$worksheet2 =& $workbook->add_worksheet("Gastos");

	$numeroenc =& $workbook->add_format();
	$numeroenc->set_size(10);
	$numeroenc->set_align('right');
	$numeroenc->set_align('vcenter');
	$numeroenc->set_bold();
	$numeroenc->set_color('black');
	$numeroenc->set_pattern();
	$numeroenc->set_fg_color('white');
	$numeroenc->set_border(2);
	$numeroenc->set_num_format('0.00');

	$intro1=5;
	$cuerpods=7;

	$worksheet2->write_string($intro1,0, "$nomptv Resumen Financiero Periodo:  $eg_mes-$eg_anio",$titulos);
	$worksheet2->write_blank($intro1,1,$titulos);
	$worksheet2->write_blank($intro1,2,$titulos);
	$worksheet2->write_blank($intro1,3,$titulos);
	$worksheet2->write_blank($intro1,4,$titulos);
	$worksheet2->merge_cells($intro1,0,$intro1,4);

	$worksheet2->write_string($cuerpods, 0,'Determinacion de Saldos',$encabezado1);
	$worksheet2->write_blank($cuerpods,1,$encabezado1);
	$worksheet2->write_blank($cuerpods,2,$encabezado1);
	$worksheet2->merge_cells($cuerpods,0,$cuerpods,2);

	$worksheet2->write_string($cuerpods+1, 0,'Saldo mes anterior',$cuerpo);
	$worksheet2->write_number($cuerpods+1,1,"$salant",$numero);
	$worksheet2->write_blank($cuerpods+1,2,$numero);
	$worksheet2->merge_cells($cuerpods+1,1,$cuerpods+1,2);

	$worksheet2->write_string($cuerpods+2, 0,'Ingresos del Periodo',$encabezado3);
	$worksheet2->write_blank($cuerpods+2,1,$encabezado3);
	$worksheet2->write_blank($cuerpods+2,2,$encabezado3);
	$worksheet2->merge_cells($cuerpods+2,0,$cuerpods+2,2);

	$worksheet2->write_string($cuerpods+3, 0,'Ingresos por cobranzas',$cuerpo);
	$worksheet2->write_number($cuerpods+3,1,"$ingper",$numero);
	$worksheet2->write_blank($cuerpods+3,2,$numero);

	$worksheet2->write_string($cuerpods+4, 0,'Otros Ingresos',$cuerpo);
	$worksheet2->write_number($cuerpods+4,1,"$oingper",$numero);
	$worksheet2->write_blank($cuerpods+4,2,$numero);

	$worksheet2->write_blank($cuerpods+5,0,$numero);
	$worksheet2->write_blank($cuerpods+5,1,$numero);
	$worksheet2->write_number($cuerpods+5,2,"$suming",$numero);
	$worksheet2->merge_cells($cuerpods+5,0,$cuerpods+5,1);

	$worksheet2->write_string($cuerpods+6, 0,'Depositos Sin Identificar',$encabezado3);
	$worksheet2->write_blank($cuerpods+6,1,$encabezado3);
	$worksheet2->write_blank($cuerpods+6,2,$encabezado3);
	$worksheet2->merge_cells($cuerpods+6,0,$cuerpods+6,2);

	$worksheet2->write_string($cuerpods+7, 0,'Depositos sin identificar al cierre anterior',$cuerpo);
	$worksheet2->write_number($cuerpods+7,1,"$depsia",$numero);
	$worksheet2->write_blank($cuerpods+7,2,$numero);

	$worksheet2->write_string($cuerpods+8, 0,'Depositos sin identificar a la fecha',$cuerpo);
	$worksheet2->write_number($cuerpods+8,1,"$depsi",$numero);
	$worksheet2->write_blank($cuerpods+8,2,$numero);

	$worksheet2->write_blank($cuerpods+9,0,$numero);
	$worksheet2->write_blank($cuerpods+9,1,$numero);
	$worksheet2->write_number($cuerpods+9,2,"$sumds",$numero);
	$worksheet2->merge_cells($cuerpods+9,0,$cuerpods+9,1);

	$worksheet2->write_string($cuerpods+10, 0,'Egresos del Periodo',$encabezado3);
	$worksheet2->write_blank($cuerpods+10,1,$encabezado3);
	$worksheet2->write_blank($cuerpods+10,2,$encabezado3);
	$worksheet2->merge_cells($cuerpods+10,0,$cuerpods+10,2);

	$worksheet2->write_string($cuerpods+11, 0,'Total gastos del periodo',$cuerpo);
	$worksheet2->write_number($cuerpods+11,1,"$gasper",$numero);
	$worksheet2->write_blank($cuerpods+11,2,$numero);

	$worksheet2->write_string($cuerpods+12, 0,'Otros egresos del periodo',$cuerpo);
	$worksheet2->write_number($cuerpods+12,1,"$oegper",$numero);
	$worksheet2->write_blank($cuerpods+12,2,$numero);

	$worksheet2->write_blank($cuerpods+13,0,$numero);
	$worksheet2->write_blank($cuerpods+13,1,$numero);
	$worksheet2->write_number($cuerpods+13,2,"$sumeg",$numero);
	$worksheet2->merge_cells($cuerpods+13,0,$cuerpods+13,1);

	$worksheet2->write_string($cuerpods+14,0,'Saldo Actual',$encabezado3);
	$worksheet2->write_blank($cuerpods+14,1,$encabezado3);
	$worksheet2->write_number($cuerpods+14,2,"$saldo",$numeroenc);
	$worksheet2->merge_cells($cuerpods+14,0,$cuerpods+14,1);

	$cuerpocs=$cuerpods+16;

	$worksheet2->write_string($cuerpocs, 0,'Conformacion de Saldos',$encabezado1);
	$worksheet2->write_blank($cuerpocs,1,$encabezado1);
	$worksheet2->write_blank($cuerpocs,2,$encabezado1);
	$worksheet2->merge_cells($cuerpocs,0,$cuerpocs,2);

	$Query1="select astc_ctacble,nomcble(astc_ctacble) as lacuenta,astc_tipcta,astc_ctacte,sum(astc_importe)::numeric(15,2) as lasumaastc from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and codcble(astc_ctacble)<3000 and astc_ctacble not in ($cta_deudxv,$cta_ajuste,$cta_depsi) and date_lt(astc_fecval,'$fechafin'::date) group by 1,2,3,4 order by 2,3,4;";
	$descriptor1=PgDoQuery($Query1);
	$rows2=Pg_NumRows($descriptor1);

	$lacaja=0;
	$totalastc=0;
	$imp=$cuerpocs+1;
	if($rows2>0){
	    for($j=0; $j < $rows2 ; $j++){
		$astc_ctacble=Resultado($descriptor1,$j,"astc_ctacble",1);
		$lacuenta=Resultado($descriptor1,$j,"lacuenta",1);
		$lasumaastc=Resultado($descriptor1,$j,"lasumaastc",1);
		$astc_ctacte=Resultado($descriptor1,$j,"astc_ctacte",1);
		$astc_tipcta=Resultado($descriptor1,$j,"astc_tipcta",1);
		if($astc_tipcta && $astc_ctacte)
		    $lacuenta=UserQuery("select tct_nombre||' - '||cte_nombre from ctes,tipcta where tct_codigo=cte_tipcta and cte_id=$astc_ctacte;",0);
		$totalastc+=$lasumaastc;
		if($astc_ctacble==$cta_caja || $astc_ctacble==$cta_1242 || $astc_ctacble==$cta_1245){
		    $lacaja+=$lasumaastc;
		}else{
		    $worksheet2->write_string($imp, 0,"$lacuenta",$cuerpo);
		    $worksheet2->write_number($imp,1,"$lasumaastc",$numero);
		    $worksheet2->write_blank($imp,2,$numero);
		    $worksheet2->merge_cells($imp,1,$imp,2);
		    $imp++;
		}
	    }
	    $worksheet2->write_string($imp, 0,'CAJA ADMINISTRACION',$cuerpo);
	    $worksheet2->write_number($imp,1,"$lacaja",$numero);
	    $worksheet2->write_blank($imp,2,$numero);
	    $worksheet2->merge_cells($imp,1,$imp,2);
	    $imp++;
	}

	$worksheet2->write_string($imp,0,'Saldo Actual',$encabezado3);
	$worksheet2->write_blank($imp,1,$encabezado3);
	$worksheet2->write_number($imp,2,"$totalastc",$numeroenc);
	$worksheet2->merge_cells($imp,0,$imp,1);
	$imp++;

	$cuerpocf=$imp+1;

	$hay3000=@UserQuery("select sum(astc_importe)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and codcble(astc_ctacble)>=3000 and codcble(astc_ctacble)<4000 and date_lt(astc_fecval,'$fechafin'::date);",0);
	if($hay3000){
	    $worksheet2->write_string($cuerpocf, 0,'Conformacion de Fondos',$encabezado1);
	    $worksheet2->write_blank($cuerpocf,1,$encabezado1);
	    $worksheet2->write_blank($cuerpocf,2,$encabezado1);
	    $worksheet2->write_blank($cuerpocf,3,$encabezado1);
	    $worksheet2->write_blank($cuerpocf,4,$encabezado1);
	    $worksheet2->merge_cells($cuerpocf,0,$cuerpocf,4);

	    $worksheet2->write_string($cuerpocf+1, 0,'Tipo de Fondo',$encabezado);
	    $worksheet2->write_string($cuerpocf+1, 1,'Saldo Ant.',$encabezado);
	    $worksheet2->write_string($cuerpocf+1, 2,'Ingresos',$encabezado);
	    $worksheet2->write_string($cuerpocf+1, 3,'Egresos',$encabezado);
	    $worksheet2->write_string($cuerpocf+1, 4,'Saldo',$encabezado);

	    $salantf=0;
	    $ingref=0;
	    $egref=0;
	    $newsalf=0;

	    $sumsaantf+=$salantf;
	    $sumingf+=$ingref;
	    $sumegrf+=$egref;
	    $sumsalf+=$newsalf;

	    /*
		for($k=0;$k<$rooooooooooooooooooooo;$k++){
		    echo("<TR>\n");
		    echo("<td align=\"left\" class=\"textlow\"> &nbsp;&nbsp; $lacuentaf</td>\n");
		    echo("<td align=\"right\" class=\"input_numberg\">$salantf</td>\n");
		    echo("<td align=\"right\" class=\"input_numberg\">$ingref</td>\n");
		    echo("<td align=\"right\" class=\"input_numberg\">$egref</td>\n");
		    echo("<td align=\"right\" class=\"input_numberg\">$newsalf</td>\n");
		    echo("</TR>\n");
	    */

	$k=0;
		    $worksheet2->write_string($cuerpocf+2+$k, 0,'Depositos sin Identificar',$cuerpo);
		    $worksheet2->write_number($cuerpocf+2+$k, 1,"0",$numero);
		    $worksheet2->write_number($cuerpocf+2+$k, 2,"0",$numero);
		    $worksheet2->write_number($cuerpocf+2+$k, 3,"0",$numero);
		    $worksheet2->write_number($cuerpocf+2+$k, 4,"$depsi",$numero);

	    
		    $sumsalf+=$depsi;
		    $sumsalf=@UserQuery("select $sumsalf::numeric(15,2);",0);
		    $sumsaantf=@UserQuery("select $sumsaantf::numeric(15,2);",0);
		    $sumingf=@UserQuery("select $sumingf::numeric(15,2);",0);
		    $sumegrf=@UserQuery("select $sumegrf::numeric(15,2);",0);
//		}
	    

	$k=1;
	    $worksheet2->write_string($cuerpocf+2+$k, 0,'Totales',$encabezado);
	    $worksheet2->write_number($cuerpocf+2+$k, 1,"$sumsaantf",$numeroenc);
	    $worksheet2->write_number($cuerpocf+2+$k, 2,"$sumingf",$numeroenc);
	    $worksheet2->write_number($cuerpocf+2+$k, 3,"$sumegrf",$numeroenc);
	    $worksheet2->write_number($cuerpocf+2+$k, 4,"$sumsalf",$numeroenc);
	}

	$cuerpogs=$cuerpocf+2+$k+2;
	$imprimo=$cuerpogs;
	if(!$eg_centroc)
	    $eg_centroc=@UserQuery("select cco_id from centroc where cco_codemp=$codemp and cco_idptov=$eg_idptov limit 1;",0);
	if(!$eg_division)
	    $eg_division=@UserQuery("select cco_coddiv from centroc where cco_codemp=$codemp and cco_idptov=$eg_idptov limit 1;",0);

	$worksheet2->write_string($imprimo, 0,'Detalle de gastos del Periodo',$encabezado1);
	$worksheet2->write_blank($imprimo,1,$encabezado1);
	$worksheet2->write_blank($imprimo,2,$encabezado1);
	$worksheet2->write_blank($imprimo,3,$encabezado1);
	$worksheet2->write_blank($imprimo,4,$encabezado1);
	$worksheet2->merge_cells($imprimo,0,$imprimo,4);
	$imprimo+=2;

	$liquidagastos=@UserQuery("select ptv_liqgs from ptovta where ptv_id=$eg_idptov;",0);
	if($liquidagastos){
	    $cols=0;
	    $worksheet2->write_string($imprimo, $cols,'Concepto',$encabezado);
	    $cols++;
	    $cantTgs=PgDoQuery("select distinct eg_tipgto from liqegr where eg_codemp=$eg_codemp and eg_idptov=$eg_idptov and eg_anio=$eg_anio and eg_mes=$eg_mes and eg_centro=$eg_centroc and eg_division=$eg_division and eg_estado=2 order by 1;");
	    $filTgs=pg_numRows($cantTgs);
	    $dondeCada=array();
	    for($kk=0;$kk<$filTgs;$kk++){
		$idTg=Resultado($cantTgs,$kk,"eg_tipgto",1);
		$tgCol=array();
		$tgCol[0]=$idTg;
		$tgCol[1]=$cols;
		$tgCol[2]=0;
		$dondeCada[$kk]=$tgCol;
		$nomTg=@UserQuery("select tg_nombre from tipgto where tg_id=$idTg;",0);
		$worksheet2->write_string($imprimo,$cols,"$nomTg",$encabezado);
		$cols++;
	    }
	    $worksheet2->write_string($imprimo, $cols,'Total',$encabezado);
	    $totCol=$cols;
	    $cols++;
	    $worksheet2->write_string($imprimo, $cols+5,'Proveedor',$encabezado);
	    $cols++;
	    $worksheet2->write_string($imprimo, $cols+5,'Nro. Factura',$encabezado);
	    $cols++;
	    $imprimo++;
	}else{
	    $worksheet2->write_string($imprimo, 0,'Concepto',$encabezado);
	    $worksheet2->write_string($imprimo, 1,'Importe',$encabezado);
	    $worksheet2->write_string($imprimo, 2,'Total',$encabezado);
	    $worksheet2->write_string($imprimo, 3+5,'Proveedor',$encabezado);
	    $worksheet2->write_string($imprimo, 4+5,'Nro. Factura',$encabezado);
	    $imprimo++;
	}

	$sumeg*=-1;
	$Query="select eg_rubro,eg_subrub,eg_importe,eg_leyen,eg_id,eg_idastoh,eg_tipgto from liqegr where eg_codemp=$eg_codemp and eg_idptov=$eg_idptov and eg_anio=$eg_anio and eg_mes=$eg_mes and eg_centro=$eg_centroc and eg_division=$eg_division and eg_estado=2 order by 1,2;";
	$descriptor=PgDoQuery($Query);
	$rows1=Pg_NumRows($descriptor);
	if($rows1>0){
	    $sumaeg=0;
	    $rubroact=0;
	    $srubroact=0;
	    $totrub=0;
	    for($i=0; $i < $rows1 ; $i++){
		$noanul=0;
		$eg_id=Resultado($descriptor,$i,"eg_id",1);
		$eg_tipgto=Resultado($descriptor,$i,"eg_tipgto",1);
		$rubro=Resultado($descriptor,$i,"eg_rubro",1);
		$eg_rubro=@UserQuery("select rub_nombre from rubros where rub_id=$rubro",0);
		$subrub=Resultado($descriptor,$i,"eg_subrub",1);
		$eg_subrub=@UserQuery("select srb_nombre from subrub where srb_id=$subrub",0);
		$eg_importe=Resultado($descriptor,$i,"eg_importe",1);
		$eg_leyen=Resultado($descriptor,$i,"eg_leyen",1);
		$eg_idastoh=Resultado($descriptor,$i,"eg_idastoh",1);
		$quer="select * from gtoxliqe where gxl_liqegr=$eg_id order by gxl_gasto asc;";
		$desc=PgDoQuery($quer);
		$row=Pg_NumRows($desc);
		$noanul=$row;
		$sumaeg+=$eg_importe;

		if($rubro!=$rubroact){
		    if($totrub!=0){
			$totrub=@UserQuery("select $totrub::numeric(15,2);",0);
			if($liquidagastos){
			    $worksheet2->write_number($imprimo-1, $totCol,"$totrub",$numerorba);
			    $porc=$totrub/$sumeg*100;
			    $worksheet2->write_number($imprimo-1, $totCol+1,"$porc",$numerorba);
			}else{
			    $worksheet2->write_number($imprimo-1, 2,"$totrub",$numerorba);
			    $porc=$totrub/$sumeg*100;
			    $worksheet2->write_number($imprimo-1, 3,"$porc",$numerorba);
			}
			$totporc+=$porc;
//			$imprimo++;
		    }
		    $totrub=0;
		    if($liquidagastos){
			$cols=0;
			$worksheet2->write_string($imprimo, $cols,"Rubro: $eg_rubro",$encabezado2);
			$cols++;
			for($kk=0;$kk<$filTgs;$kk++){
			    $worksheet2->write_blank($imprimo,$cols,$encabezado2);
			    $cols++;
			}
			$worksheet2->write_blank($imprimo,$cols,$encabezado2);
			$cols++;
			$worksheet2->write_blank($imprimo,$cols,$encabezado2);
			$worksheet2->write_blank($imprimo,$cols+5,$encabezado2);
			$cols++;
			$worksheet2->write_blank($imprimo,$cols+5,$encabezado2);
			$worksheet2->merge_cells($imprimo,0,$imprimo,$totCol);
		    }else{
			$worksheet2->write_string($imprimo, 0,"Rubro: $eg_rubro",$encabezado2);
			$worksheet2->write_blank($imprimo,1,$encabezado2);
			$worksheet2->write_blank($imprimo,2,$encabezado2);
			$worksheet2->write_blank($imprimo,3,$encabezado2);
			$worksheet2->write_blank($imprimo,3+5,$encabezado2);
			$worksheet2->write_blank($imprimo,4+5,$encabezado2);
			$worksheet2->merge_cells($imprimo,0,$imprimo,2);
		    }
		    $imprimo++;
		}
		$totrub+=$eg_importe;
		for($p=0;$p<$row;$p++){
		    $gasto_id=Resultado($desc,$p,"gxl_gasto",1);
		    $gasto_estado=@UserQuery("select gto_estado from gastos where gto_id=$gasto_id",0);
		    if($gasto_estado==999)
			$noanul--;
		}
		if($noanul==1){
		    for($p=0;$p<$row;$p++){
			$gasto_id=Resultado($desc,$p,"gxl_gasto",1);
			$gasto_estado=@UserQuery("select gto_estado from gastos where gto_id=$gasto_id",0);
			if($gasto_estado!=999)
			    $gto_id=$gasto_id;
		    }
		    $lecomp=@UserQuery("select gto_lecomp from gastos where gto_id=$gto_id",0);
		    $sucomp=@UserQuery("select gto_sucomp from gastos where gto_id=$gto_id",0);
		    $nucomp=@UserQuery("select gto_nucomp from gastos where gto_id=$gto_id",0);
		    $nprove=@UserQuery("select gto_nprove from gastos where gto_id=$gto_id",0);
		    if(!$nprove) $nprove=' ';
		    $eg_factura='Factura '.$lecomp.' Nro: '.$sucomp.'-'.$nucomp;
		    $eg_prove=$nprove;
		}else{
		    if($noanul>1){
			$eg_factura='Facturas: ';
			$eg_prove='';
			$numfact=0;
			$numprov=0;
			$inicio=0;
			$proveedores=array();
			$gto_id=Resultado($desc,0,"gxl_gasto",1);
			$compbte=@UserQuery("select gto_comprob from gastos where gto_id=$gto_id",0);
			$compbte=@UserQuery("select comp_codigo from comprob where comp_id=$compbte",0);
			$eg_numero=@UserQuery("select gto_numero from gastos where gto_id=$gto_id",0);
			for($k=0;$k<$row;$k++){
			    $soniguales=0;
			    $gto_id=Resultado($desc,$k,"gxl_gasto",1);
			    $gto_estado=@UserQuery("select gto_estado from gastos where gto_id=$gto_id",0);
			    if($gto_estado!=999){
				$q="select * from gastos where gto_id=$gto_id;";
				$d=PgDoQuery($q);
				$lecomp=Resultado($d,0,"gto_lecomp",1);
				$sucomp=Resultado($d,0,"gto_sucomp",1);
				$nucomp=Resultado($d,0,"gto_nucomp",1);
				$nprove=Resultado($d,0,"gto_nprove",1);
				if(!$nprove) $nprove=' ';
				if($inicio==2)
				    $eg_factura.=' / ';
				$eg_factura.=$lecomp.' Nro: '.$sucomp.'-'.$nucomp;
				for($s=0;$s<sizeof($proveedores);$s++){
				    $proveed=$proveedores[$s];
				    if(strcmp($nprove,$proveed)==0){
					$soniguales=1;
					$numprov--;
					break;
				    }
				}
				if(!$soniguales)
				    $proveedores[]=$nprove;
				$inicio=2;
				$numfact++;
				$numprov++;
			    }
			}
			for($m=0;$m<sizeof($proveedores);$m++){
			    $proveed=$proveedores[$m];
			    if($m!=0)
				$eg_prove.=' / ';
			    $eg_prove.=$proveed;
			}
		    }
		}
		$eg_estado=@UserQuery("select eg_estado from liqegr where eg_id=$eg_id;",0);
		if($eg_estado!=999){
		    if($liquidagastos){
			$cols=0;
			$worksheet2->write_string($imprimo, $cols,"$eg_leyen",$cuerpo);
			$cols++;
			for($kk=0;$kk<$filTgs;$kk++){
			    $tgCol=array();
			    $tgCol=$dondeCada[$kk];
			    $idTg=$tgCol[0];
			    $columna=$tgCol[1];
			    $totTg=$tgCol[2];
			    if($eg_tipgto==$idTg){
				$worksheet2->write_number($imprimo, $columna,"$eg_importe",$numero);
				$totTg+=$eg_importe;
				$tgCol[2]=$totTg;
				$dondeCada[$kk]=$tgCol;
			    }else{
				$worksheet2->write_blank($imprimo, $columna,$numero);
			    }
			    $cols++;
			}
			$worksheet2->write_blank($imprimo, $cols,$numerorb);
			$cols++;
			$worksheet2->write_blank($imprimo, $cols,$numerorb);
			$worksheet2->write_string($imprimo, $cols+5,"$eg_prove",$cuerpo);
			$cols++;
			$worksheet2->write_string($imprimo, $cols+5,"$eg_factura",$cuerpo);
			$imprimo++;
			$rubroact=$rubro;
		    }else{
			$worksheet2->write_string($imprimo, 0,"$eg_leyen",$cuerpo);
			$worksheet2->write_number($imprimo, 1,"$eg_importe",$numero);
			$worksheet2->write_blank($imprimo, 2,$numerorb);
			$worksheet2->write_blank($imprimo, 3,$numerorb);
			$worksheet2->write_string($imprimo, 3+5,"$eg_prove",$cuerpo);
			$worksheet2->write_string($imprimo, 4+5,"$eg_factura",$cuerpo);
			$imprimo++;
			$rubroact=$rubro;
		    }
		}
	    }
	    if($totrub!=0){
		$totrub=@UserQuery("select $totrub::numeric(15,2);",0);
//		$worksheet2->write_string($imprimo, 0,"Total del rubro: ",$cuerpo);
		if($liquidagastos){
		    $worksheet2->write_number($imprimo-1, $totCol,"$totrub",$numerorba);
		    $porc=$totrub/$sumeg*100;
		    $worksheet2->write_number($imprimo-1, $totCol+1,"$porc",$numerorba);
		}else{
		    $worksheet2->write_number($imprimo-1, 2,"$totrub",$numerorba);
		    $porc=$totrub/$sumeg*100;
		    $worksheet2->write_number($imprimo-1, 3,"$porc",$numerorba);
		}
		$totporc+=$porc;
//		$imprimo++;
	    }

	    if($liquidagastos){
		$cols=0;
		$worksheet2->write_string($imprimo, $cols,"Total Gastos: ",$encabezado);
		$cols++;
		for($kk=0;$kk<$filTgs;$kk++){
		    $tgCol=$dondeCada[$kk];
		    $worksheet2->write_number($imprimo, $cols,"$tgCol[2]",$numeroenc);
		    $cols++;
		}
		$worksheet2->write_number($imprimo, $cols,"$sumaeg",$numeroenc);
		$cols++;
		$worksheet2->write_number($imprimo, $cols,"$totporc",$numeroenc);
		$worksheet2->write_blank($imprimo, $cols+5,$encabezado);
		$cols++;
		$worksheet2->write_blank($imprimo, $cols+5,$encabezado);
		$worksheet2->merge_cells($imprimo,$cols+5,$imprimo,$cols+5);
		$imprimo++;
	    }else{
		$worksheet2->write_string($imprimo, 0,"Total Gastos: ",$encabezado);
		$worksheet2->write_blank($imprimo, 1,$encabezado);
		$worksheet2->write_number($imprimo, 2,"$sumaeg",$numeroenc);
		$worksheet2->write_number($imprimo, 3,"$totporc",$numeroenc);
		$worksheet2->write_blank($imprimo, 3+5,$encabezado);
		$worksheet2->write_blank($imprimo, 4+5,$encabezado);
		$worksheet2->merge_cells($imprimo,3+5,$imprimo,4+5);
		$imprimo++;
	    }
	}

    $ash_idptov=$eg_idptov;
    $ash_centro=$eg_centroc;
    $ash_division=$eg_division;

    $comprobdi=@UserQuery("select valvaramb($ash_codemp,$ash_idptov,'CMPDI')",0);
    if(!$comprobdi)
	$comprobdi=@UserQuery("select valvaramb($ash_codemp,0,'CMPDI')",0);
    $compbtedi=@UserQuery("select idcomp($ash_codemp,$ash_idptov,'$comprobdi')",0);
    if(!$compbtedi)
	$compbtedi=@UserQuery("select idcomp($ash_codemp,0,'$comprobdi')",0);

    $comprobid=@UserQuery("select valvaramb($ash_codemp,$ash_idptov,'CMPID')",0);
    if(!$comprobid)
	$comprobid=@UserQuery("select valvaramb($ash_codemp,0,'CMPID')",0);
    $compbteid=@UserQuery("select idcomp($ash_codemp,$ash_idptov,'$comprobid')",0);
    if(!$compbteid)
	$compbteid=@UserQuery("select idcomp($ash_codemp,0,'$comprobid')",0);


	$worksheet3 =& $workbook->add_worksheet("Depsi");
	$worksheet3->set_column(0,0,25);
	$worksheet3->set_column(1,1,25);
	$worksheet3->set_column(2,2,25);

	$intro=5;
	$cuerpoexc=7;

	$worksheet3->write_string($intro,0, "$nomptv Depositos sin identificar:  $eg_mes-$eg_anio",$titulos);
	$worksheet3->write_blank($intro,1,$titulos);
	$worksheet3->write_blank($intro,2,$titulos);
	$worksheet3->merge_cells($intro,0,$intro,2);

	$bcos=PgDoQuery("select cte_id,cte_nombre from ctes where cte_codemp=$astc_codemp and cte_tipcta=1 and cte_idptov=$eg_idptov;",0);
	$fbcos=pg_numRows($bcos);
	$p=6;
	for($k=0;$k<$fbcos;$k++){
	    $astc_ctacte=Resultado($bcos,$k,"cte_id",1);
	    $nombco=Resultado($bcos,$k,"cte_nombre",1);
	    $Query="select * from astoctas a where not exists (select * from astoctas b where a.astc_numero=b.astc_numero and b.astc_comprob=$compbteid and astc_fecval<='$feccie') and astc_codemp=$ash_codemp and astc_comprob=$compbtedi and astc_idptov=$ash_idptov and astc_centro=$ash_centro and astc_division=$ash_division and astc_ctacte=$astc_ctacte and astc_estado=2 and astc_fecval<='$feccie'order by astc_fecvto;";
	    $descriptor=PgDoQuery($Query);
	    $rows1=Pg_NumRows($descriptor);
	    if($rows1){
		$worksheet3->write_string($p+1,0, "Banco: $nombco",$encabezado1);
		$worksheet3->write_blank($p+1,1,$encabezado1);
		$worksheet3->write_blank($p+1,2,$encabezado1);
		$worksheet3->merge_cells($p+1,0,$p+1,2);
		$p++;
		$worksheet3->write_string($p+1,0, "Fecha",$encabezado);
		$worksheet3->write_string($p+1,1, "Importe",$encabezado);
		$worksheet3->write_string($p+1,2, "Comprobante",$encabezado);
		$p++;
		for($m=0;$m<$rows1;$m++){
		    $id=Resultado($descriptor,$m,"astc_id",1);
		    $astc_numero=Resultado($descriptor,$m,"astc_numero",1);
		    $astc_fecvto=Resultado($descriptor,$m,"astc_fecvto",1);
		    $astc_importe=Resultado($descriptor,$m,"astc_importe",1);
		    $astc_fecvto=@UserQuery("select '$astc_fecvto'::date;",0);
		    $worksheet3->write_string($p+1,0, $astc_fecvto,$cuerpo);
		    $worksheet3->write_number($p+1,1, $astc_importe,$numero);
		    $worksheet3->write_string($p+1,2, $comprobdi." - ".$astc_numero,$cuerpo);
		    $p++;
		}
	    }
	}


	if($ash_idptov) $astc_idptov=$ash_idptov;
	$cta_banco=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'BANCO')::smallint",0);
	$cta_perib=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'CTAPERIB')::smallint",0);
	$cta_retib=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'SIRCREBB')::smallint",0);
	$cta_ivac=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'CTAIVAC')::smallint",0);
	$cta_impcheq=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'CTAIMPCHEQ')::smallint",0);
	$cta_gasban=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'GASBAN')::smallint",0);

	$ash_mes=$eg_mes;
	$ash_anio=$eg_anio;
	$codemp=$astc_codemp;

	$ash_comprob= @UserQuery("select idcomp($codemp,$ash_idptov,'AD');",0);

	$worksheet4 =& $workbook->add_worksheet("Concilia");
	$worksheet4->set_column(0,0,15);
	$worksheet4->set_column(1,1,60);
	$worksheet4->set_column(2,5,15);

	$intro=5;
	$cuerpoexc=7;

	$worksheet4->write_string($intro,0, "$nomptv Conciliacion Bancaria:  $eg_mes-$eg_anio",$titulos);
	$worksheet4->write_blank($intro,1,$titulos);
	$worksheet4->write_blank($intro,2,$titulos);
	$worksheet4->write_blank($intro,3,$titulos);
	$worksheet4->write_blank($intro,4,$titulos);
	$worksheet4->write_blank($intro,5,$titulos);
	$worksheet4->merge_cells($intro,0,$intro,5);


	$bcos=PgDoQuery("select cte_id,cte_nombre from ctes where cte_codemp=$astc_codemp and cte_tipcta=1 and cte_idptov=$eg_idptov;",0);
	$fbcos=pg_numRows($bcos);
	$p=6;
	for($k=0;$k<$fbcos;$k++){
	    $astc_ctacte=Resultado($bcos,$k,"cte_id",1);
	    $nombco=Resultado($bcos,$k,"cte_nombre",1);
	    $ash_id=NULL;
	    $ash_id=@UserQuery("select ash_id from astoh where ash_codemp=$codemp and ash_comprob=$ash_comprob and ash_anio=$ash_anio and ash_mes=$ash_mes and ash_titulo='$titulo'",0);
	    $grabado=$nograbado=$ivac=$retib=$perib=$impcheq=0;

	    $titulo='Gtos. Bancarios ' . $ash_mes . '-'. $ash_anio . '  ';
	    $titulo.=@UserQuery("select nomctes($astc_ctacte);",0);
	    if($ash_id)
		$ash_fecval= @UserQuery("select ash_fecval from astoh where ash_id=$ash_id;",0);
	    else{
		if($ash_mes==1){$mesant=12; $anioant=$ash_anio-1;} else {$mesant=$ash_mes-1; $anioant=$ash_anio;}
		$mesant=@UserQuery("select lpad($mesant::text,2,'0');",0);
		$titulo='Gtos. Bancarios ' . $mesant . '-'. $anioant . '&nbsp; ';
		$titulo.=@UserQuery("select trim(nomctes($astc_ctacte));",0);
		$lacuentac.=@UserQuery("select trim(nomctes($astc_ctacte));",0);

		$queryy=" select ash_id from astoh where ash_codemp=$codemp and ash_idptov=$ash_idptov and ash_comprob=$ash_comprob and ash_anio=$anioant and ash_mes=$mesant and ash_titulo like 'Gtos. Bancarios $mesant-$anioant  $lacuentac%' order by ash_id desc limit 1; ";

		$ash_ida=@UserQuery("$queryy",0);
		if($ash_ida)
		    $ash_fecval= @UserQuery("select ash_fecval from astoh where ash_id=$ash_ida;",0);
	    }

	    $query="select astc_id, trim(codcomp(astc_comprob)) as codcomp,astc_numero,titastoh(astc_idastoh)as titulo,astc_idastoh,
			astc_nucheq,astc_fecvto as astc_fecval,astc_importe,astc_leyen,astc_nucheq,astc_idastoh 
			    from astoctas where astc_codemp=$astc_codemp and astc_idptov=$astc_idptov and astc_tipcta=1 and astc_estado=2 
				and astc_ctacte=$astc_ctacte and astc_fecval<='$feccie' and 
				(astc_cierra=1 or 
				    (astc_cierra=2 and astc_id in 
					(select cxlia_idastc from conxclia where cxlia_idclia in 
					    (select clia_id from concilia where clia_cte=$astc_ctacte and date(clia_fecha)>'$feccie')
					)
				    )
				) 
				and astc_fecval<='$feccie' order by astc_fecvto, astc_id;";

	    $r=PgDoQuery($query);
	    $rows=pg_NumRows($r);

	    $query="select sum(astc_importe) from astoctas 
		  where astc_codemp=$astc_codemp 
			and astc_idptov=$astc_idptov 
			and astc_tipcta=1 and astc_estado=2 
			and astc_ctacte=$astc_ctacte 
			and astc_fecval<='$feccie' 
			and astc_cierra=2 
			and astc_id not in 
				    (select cxlia_idastc from conxclia where cxlia_idclia in 
					(select clia_id from concilia where clia_cte=$astc_ctacte and date(clia_fecha)>'$feccie'));";
	    $salant=@UserQuery($query,0);
	    if(!$salant) $salant=0;
	    if($rows || $salant){
		$worksheet4->write_string($p+1,0, "Banco: $nombco",$encabezado1);
		$worksheet4->write_blank($p+1,1,$encabezado1);
		$worksheet4->write_blank($p+1,2,$encabezado1);
		$worksheet4->write_blank($p+1,3,$encabezado1);
		$worksheet4->write_blank($p+1,4,$encabezado1);
		$worksheet4->write_blank($p+1,5,$encabezado1);
		$worksheet4->merge_cells($p+1,0,$p+1,5);
		$p++;
		$worksheet4->write_string($p+1,0, "Comprobante",$encabezado);
		$worksheet4->write_string($p+1,1, "Titulo",$encabezado);
		$worksheet4->write_string($p+1,2, "Fecha Vto.",$encabezado);
		$worksheet4->write_string($p+1,3, "Debe",$encabezado);
		$worksheet4->write_string($p+1,4, "Haber",$encabezado);
		$worksheet4->write_string($p+1,5, "Saldo",$encabezado);
		$p++;
		if($salant){
		    if($salant>0) 
			{$debe=$salant; $haber='&nbsp;';} 
		    else
			{$haber=$salant; $debe='&nbsp;';}
		    $totfab=$saldo=$salant;
		    $worksheet4->write_string($p+1,0, "",$cuerpo);
		    $worksheet4->write_string($p+1,1, "SALDO ANTERIOR CONCILIADO",$cuerpo);
		    $worksheet4->write_string($p+1,2, $ash_fecval,$cuerpoz);
		    $worksheet4->write_number($p+1,3, $debe,$numero);
		    $worksheet4->write_number($p+1,4, $haber,$numero);
		    $worksheet4->write_number($p+1,5, $totfab,$numero);
		    $p++;
		}
		else
		    $saldo=$salant=$totfab=0;
		for($m=0;$m<$rows;$m++){
		    $astc_fecha=Resultado($r,$m,"astc_fecval",1);
		    $astc_idastoh=Resultado($r,$m,"astc_idastoh",1);
		    $codcomp=Resultado($r,$m,"codcomp",1);
		    $titulo=Resultado($r,$m,"titulo",1);
		    $astc_numero=Resultado($r,$m,"astc_numero",1);
		    $astc_id=Resultado($r,$m,"astc_id",1);
		    $astc_idastoh=Resultado($r,$m,"astc_idastoh",1);
		    $astc_nucheq=Resultado($r,$m,"astc_nucheq",1);
		    $astc_leyen=Resultado($r,$m,"astc_leyen",1);
		    $astc_importe=Resultado($r,$m,"astc_importe",1);
		    $debe='';
		    $haber='';
		    $comprob= $codcomp . ' - ' .$astc_numero;
		    if($astc_importe>0)
			$debe=$astc_importe;
		    else
			$haber=$astc_importe;

		    $compbteID=@UserQuery("select trim(valvaramb($codemp,$astc_idptov,'CMPIG'));",0);
		    if($codcomp==$compbteID)
			$titulo=@UserQuery("select gto_leyen from gastos where gto_idastoh=$astc_idastoh",0);;
		    if($astc_nucheq)
			$titulo=$titulo . "  Cheque Nro: " . $astc_nucheq;
		    if($astc_leyen)
			$titulo=$titulo . "  -   " . $astc_leyen;

		    $saldo=$saldo+$astc_importe;
		    $saldo=@UserQuery("select $saldo::numeric(15,2);",0);

		    $worksheet4->write_string($p+1,0, $comprob,$cuerpo);
		    $worksheet4->write_string($p+1,1, $titulo,$cuerpo);
		    $worksheet4->write_string($p+1,2, $astc_fecha,$cuerpoz);
		    $worksheet4->write_number($p+1,3, $debe,$numero);
		    $worksheet4->write_number($p+1,4, $haber,$numero);
		    $worksheet4->write_number($p+1,5, $saldo,$numero);
		    $p++;

		    $debe='';
		    $haber='';
		}
	    }
	}


    $workbook->close();
break; 


/*
	$worksheet1->set_column(0,0,60);
	$worksheet1->set_column(1,1,15);
	$worksheet1->set_column(2,2,15);
	$worksheet1->set_column(3,3,15);
	$worksheet1->set_column(4,4,15);
	$worksheet1->set_column(5,5,15);
*/





/*
	$worksheet1->write_string($cuerpo1+1+$i+$resto, 0, "Totales",$formato4);
	$worksheet1->write_number($cuerpo1+1+$i+$resto, 1, "$tsalant",$numero);
	$worksheet1->write_number($cuerpo1+1+$i+$resto, 2, "$tajus",$numero);
	$worksheet1->write_number($cuerpo1+1+$i+$resto, 3, "$tcobran",$numero);
	$worksheet1->write_number($cuerpo1+1+$i+$resto, 4, "$tsaldo ",$numero);
	$worksheet1->write_number($cuerpo1+1+$i+$resto, 5, "$tcargo",$numero);
*/






default:
	echo("<HTML>\n");
	echo("<HEAD>\n");
	echo("	<TITLE>Consulta de Cuentas Corrientes</TITLE>\n");
	include("../js/style.php");

	echo("<script language=\"JavaScript1.2\" src=\"../js/date.js\"></script>");

	echo("<script language=\"JavaScript\"><!--\n");
	echo("function Validate(frm,boton){\n");
	echo("switch(boton){\n");
	echo("case 0:\n");
	if(!$codemp)
	    {
	    echo("    if(Blank(frm.astc_codemp)){\n");
	    echo("alert('Debe definir la Empresa');\n");
	    echo("frm.astc_ctacble.focus();\n");
	    echo("return(false);\n");
	    echo("}\n");
	    }
	echo("break;\n");
	echo("}\n");
	echo("}\n");
	echo("//-->\n");
	echo("</script>\n");

	echo("<SCRIPT language=\"JavaScript\"> ");
	echo("function Init(frm)\n");
	echo("{\n");
	echo("frm.puntoventa.focus();");
	echo("}");
	echo("</SCRIPT>");

	echo("<script type=\"text/javascript\" src=\"../js/jq.js\"></script>\n");
	echo("<script type=\"text/javascript\" src=\"https://siac.lopezmelnyk.com/implementaciones/divcco1.php?ash_idptov=ptovtaid&codempid=$codemp&ash_idptov1=ptovtaid1\"></script>");

	echo("</HEAD>\n");
	echo("<body bgcolor=\"#C0C0C0\" topmargin=\"30\" leftmargin=\"0\" onload=\"Init(document.consulta)\">\n");
$path=$_SERVER['DOCUMENT_ROOT'];
$path.="/menu.php";
include("$path");

//	echo("<script type=\"text/javascript\" src=\"../js/noloadpage.js\"></script>\n");

	echo("  <link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"../js/calendar/calendar-green.css\" title=\"win2k-cold-1\" />\n");
	echo("  <script type=\"text/javascript\" src=\"../js/calendar/calendar.js\"></script>\n");
	echo("  <script type=\"text/javascript\" src=\"../js/calendar/calendar-es.js\"></script>\n");
	echo("  <script type=\"text/javascript\" src=\"../js/calendar/calendar-setup.js\"></script>\n");

	echo("<FORM name=\"consulta\" ACTION=\"exportoliq.php\">\n");

	echo("<CENTER><H2>Reimpresion de Liquidaciones</H2></CENTER>\n");

	echo("<hr><br>");

	echo("<TABLE cellSpacing=0 cellPadding=0 align=center border=0 width=50%>\n");

	$astc_codemp=$codemp;
	if(!$ptovta)
	    {
	    echo("  <tr> \n");
	    echo("   <td class=\"textlow\" align=\"left\">Punto de Venta:</td>\n");
	    echo("   <td align=\"left\">\n");
	    echo("<input type=\"text\" class=\"input_text\" name=\"puntoventa\" size=\"4\" id=\"ptovtaid1\">\n");
	    ShowQueryAsComboActionId("select ptv_id,ptv_codigo||' - '||ptv_nombre from ptovta where ptv_codemp=$codemp and ptv_estado=1 order by ptv_codigo;","elidptov",1,1,1,"","ptovtaid");
	    echo("   </td>\n");
	    echo("  </tr>\n");
	    }	
	  else
	    $astc_idptov=$ptovta;

	$fecha = date("d-m-Y");
	echo("  <tr> \n");
	echo("   <td class=\"textlow\" align=\"left\">Fecha del Cierre:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\n");
	echo("   <td align=\"left\"><input type=\"text\" class=\"input_text\" name=\"fechah\" id=\"fecha1\"  size=\"10\" maxlength=\"10\"  value=$fecha  onFocus=\"javascript:vDateType='3'\" onKeyUp=\"DateFormat(this,this.value,event,false,'3')\" onBlur=\"DateFormat(this,this.value,event,true,'3')\"onFocus=\"javascript:vDateType='3'\" onKeyUp=\"DateFormat(this,this.value,event,false,'3')\" onBlur=\"DateFormat(this,this.value,event,true,'3')\">\n");
	echo("<input type=\"button\" id=\"lanzador\" value=\".\" class=\"input_text\">\n");
	echo("<!-- script que define y configura el calendario-->\n");
	echo("<script type=\"text/javascript\">\n");
	echo("    Calendar.setup({\n");
	echo("        inputField     :    \"fecha1\",      // id del campo de texto\n");
	echo("        ifFormat       :    \"%d-%m-%Y\",       // formato de la fecha, cuando se escriba en el campo de texto\n");
	echo("        button         :    \"lanzador\"	// el id del boton que lanzara el calendario\n");
	echo("    });\n");
	echo("</script>\n");
	echo("</td>\n");
	echo("  </tr>\n");

	echo("</TABLE>\n");

	echo("<br><hr><br>");

	echo("<TABLE cellSpacing=0 cellPadding=2 align=center border=0 Align=center>\n");
	echo("  <TR>\n");
//	echo("    <TD><INPUT class=botonazo type=\"SUBMIT\" value=\"CONSULTA\" name=\"accion\" onclick='return Validate(this.form,0);'></TD>\n");
//	echo("<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  </td>\n");
//	echo("<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  </td>\n");
	echo("    <TD><INPUT class=botonazo type=\"SUBMIT\" value=\"EXCEL\" name=\"accion\" onclick='return Validate(this.form,0);'></TD>\n");
	echo("  </TR>\n");
	echo("</TABLE>\n");
	echo("</FORM>\n");
	echo("</BODY>\n");
	echo("</HTML>\n");
break;
}
?>


