<?php
require('../fpdf.php');
if(phpversion()>4.2)parse_str(apache_getenv("QUERY_STRING"));

class PDF extends FPDF
    {
    function Header()
	{
	//Logo
	$this->Image('../../../bazflp.jpg',15,10,13);
	//Marca de Agua
	$this->Image('/home/zona/bazflp3.jpg',60,58,190);

	$cuantos=1;
	$hojas=1;
	global $archi;
	$data=$this->LoadData($archi);
	foreach($data as $row)
	    {
	    $nrorexp=$row[2];
	    $tipoper=$row[1];
	    $nrodir=$row[0];
	    $nomdir=$row[5];
	    $cuitdir=$row[10];
	    $nroind=$row[6];
	    $nomind=$row[7];
	    $cuitind=$row[11];
	    $linea1=$row[12];
	    $linea2=$row[13];
	    $consig=$row[9];
	    $nrocsg=$row[8];
	    $date=$row[3];
	    if($cuantos==30){$hojas++; $cuantos=0;}
	    $cuantos++;
	    }
	
	    
	$this->SetFont('Arial','B',15);
	$this->Cell(23);
	$this->SetFont('Arial','IB',12);
	$this->SetTextColor(25,25,155);
	$this->Write(5,'CatWare','http://www.catware.com.ar')	;
	$this->SetTextColor(0);
	$this->SetFont('Times','IB',17);
	$this->Cell(200,10,'REEXPEDICION ZONA FRANCA Nro: ' . $tipoper . ' -' . $nrorexp,0,0,'C');
	$this->SetFont('Arial','IB',10);
	$this->Cell(30,5,'Fecha:  '.$date,0,1,'L');

	$this->Cell(24);
	$this->SetFont('Arial','IB',10);
	$this->Cell(16,5,'RZFLP13',0,0,'L');
	$this->SetFont('Times','IB',17);
	$this->Cell(200,10,'',0,0,'C');
	$this->SetFont('Arial','IB',10);
	$this->Cell(30,5,'Pagina:      '.$this->PageNo().' / '.$hojas,0,1,'L');

	$this->Ln();

	$this->SetFont('courier','IB',10);
	$this->Cell(50,4,'Cliente:',0,0,'L');
	$this->Cell(15,4,$nrodir . '  -',0,0,'R');
	$this->Cell(80,4,$nomdir,0,0,'L');
	$this->Cell(50,4,'CUIT:' . $cuitdir,0,1,'L');

	$this->Cell(50,4,'Depositario:',0,0,'L');
	$this->Cell(15,4,$nroind . '  -',0,0,'R');
	$this->Cell(80,4,$nomind,0,0,'L');
	$this->Cell(50,4,'CUIT:' . $cuitind,0,1,'L');

	$this->Cell(50,4,'Consignatario:',0,0,'L');
	$this->Cell(15,4,$nrocsg . '  -',0,0,'R');
	$this->Cell(80,4,$consig,0,1,'L');

	$this->Cell(50,4,'Relacion Operativa:',0,0,'L');
	$this->SetFont('courier','IB',7);
	$this->Cell(220,4,$linea1,0,1,'L');
	$this->Cell(50);
	$this->Cell(220,4,$linea2,0,1,'L');

	$this->Ln();
	
	$this->SetLineWidth(0.6);
	$this->Rect(10,46,275,12,'D');
	$this->SetLineWidth(0);

	$this->SetFont('HELVETICA','B',9);
	$this->Cell(35,4,'TRANSITO',0,0,'C');
	$this->Cell(49,4,'DESCRIPCION',0,0,'L');
	$this->Cell(26,4,'MARCA',0,0,'L');
	$this->Cell(34,4,'ARTICULO',0,0,'L');
	$this->Cell(34,4,'DOCUMENTO',0,0,'C');
	$this->Cell(10,4,'U/M',0,0,'L');
	$this->Cell(32,4,'CANTIDAD',0,0,'C');
	$this->Cell(40,4,'DEPOSITO',0,1,'L');

	$this->Cell(35,4,'INGRESO',0,0,'C');
	$this->Cell(49,4,'',0,0,'L');
	$this->Cell(26,4,'',0,0,'L');
	$this->Cell(34,4,'',0,0,'L');
	$this->Cell(35,4,'INGRESO',0,1,'C');
	//Salto de linea
	$this->Ln(3);
	}

    function Footer()
	{
	//Posicion: a 1,5 cm del final
	$this->SetY(-25);
	//Arial italic 8
	$this->SetLineWidth(0.6);
	$this->Line(10,184,285,184);
	$this->SetFont('courier','',10);
	$this->Cell(250,4,'SEGUN DOCUMENTACION PRESENTADA POR EL USUARIO',0,1,'L');
	$this->SetFont('courier','',8);
	$this->Cell(260,3,'Observaciones:................................................................................................................................................',0,1,'L');
	$this->Cell(260,3,'..............................................................................................................................................................',0,1,'L');
	$this->Cell(260,4,'',0,1,'L');
	$this->Cell(260,3,'   ................................                              ...........................                                   .............................  ',0,1,'L');
	$this->Cell(260,3,'   Firma y Sello Funcionario aduana                                 Firma y Sello Usuario                                       Firma y Sello Concesionario   ',0,1,'L');
	}

    //Cargar los datos
    function LoadData($file)
	{
	//Leer las lineas del fichero
	$lines=file($file);
	$data=array();
	foreach($lines as $line)
		$data[]=explode('|',chop($line));
	return $data;
	}


    //Tabla Body
    function FancyTableR($data)
	{
	$this->SetFont('HELVETICA','B',8);
	$w=array(30,51,24,43,30,10,27,60);
	//Datos
	$fila=0;
	foreach($data as $row)
	    {
	    $fila++;
	    $this->Cell($w[0],4,$row[14],0,0,'C');
	    $this->Cell($w[1],4,$row[15],0,0,'L');
	    $this->Cell($w[2],4,$row[16],0,0,'L');
	    $this->Cell($w[3],4,$row[17],0,0,'L');
	    $this->Cell($w[4],4,$row[18],0,0,'L');
	    $this->Cell($w[5],4,$row[19],0,0,'L');
	    $this->Cell($w[6],4,number_format($row[20],3),0,0,'R');
	    $this->Cell($w[7],4,$row[21],0,0,'L');
	    $this->Ln();
	    $vamos+=$row[20];
	    if($fila==30)
		{
		$this->AddPage(); 
		$fila=0;
		}
	    }
	$this->SetFont('HELVETICA','B',10);
	$this->Cell(215,6,'Total Cantidad:       '.number_format($vamos,3),0,1,'R');
	}
    }



$pdf=new PDF('L','mm','A4');
$data=$pdf->LoadData($archi);
$pdf->SetAuthor('CatWare - Soluciones Informaticas');
$pdf->SetCreator('Reexpedicion');
$pdf->SetTitle('Reexpedicion');
$pdf->SetSubject('Reexpedicion');
$pdf->SetFont('Arial','',14);
$pdf->AddPage();
$pdf->FancyTableR($data);
$pdf->Output($name=$archi.'.pdf');
$dire='flopez@bazflp.com.ar';
$elarchi=$archi . '.pdf';
exec("./teborro.sh $archi");
exec("./mandomail.sh $elarchi $dire");

echo ("<meta http-equiv=\"refresh\" content=\"0;URL=../../bottomfr.html\">");

?>
