--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- Name: plpgsql; Type: PROCEDURAL LANGUAGE; Schema: -; Owner: sanjor
--

CREATE PROCEDURAL LANGUAGE plpgsql;


ALTER PROCEDURAL LANGUAGE plpgsql OWNER TO sanjor;

SET search_path = public, pg_catalog;

--
-- Name: calc_intliq(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION calc_intliq(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	operador	 integer;
	idultcie	 integer;
	impgia		 numeric(15,2);
	cobranz		 numeric(15,2);
	import		 numeric(15,2);
	tasaint		 numeric(15,5);
	interes		 numeric(15,2);

	rubro		 integer;
	cargo		 integer;
	leyenda		 character varying(240);

	importe		 numeric(15,2);
	retval 		 integer;
	registro	 record;
	regi		 record;
	regis		 record;
BEGIN

retval:=1;
importe:=0;

select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
    into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 

select l_id into idultcie from liquidacion where l_id!=idliq and l_estado=1 order by l_feccie desc limit 1;

select intercentro(centro) into tasaint;
if tasaint is null then
    tasaint:=0;
end if;

select vari_valor into cargo from varambi where int4eq(idptov,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq('CARGOINT',vari_codigo);
if found then
    select car_rubcar, car_leyen into rubro, leyenda from cargos where car_id=cargo;

    if idultcie is not null then
	for regi in select * from auxint where ai_idliq=idultcie
	    loop
		impgia:=regi.impgi;
		if impgia is null then
		    impgia:=0;
		end if;

		select sum(clq_importe) into cobranz from compliq where clq_importe<0 and clq_anio=anio and clq_mes=mes and clq_estado=1 and cargocint(clq_cargo)=1 and clq_idcopr=regi.ai_idcopr;
		if cobranz is null then
		    cobranz:=0;
		end if;

		import:= impgia - cobranz ;

		if numeric_gt(import,0) then
		    interes:=import * tasaint / 100;
		end if;

		if numeric_gt(interes,0) then
		    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_cargo,clq_leyen,clq_canti,clq_interes,clq_precio,clq_importe,clq_idcopr)
			values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,rubro,cargo,leyenda,1,interes,1,interes,regi.ai_idcopr);
		end if;

	    interes:=0;
	    end loop;
    end if;
end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.calc_intliq(integer) OWNER TO sanjor;

--
-- Name: cargocint(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION cargocint(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select car_genint from cargos where car_id= $1 ;$_$;


ALTER FUNCTION public.cargocint(integer) OWNER TO sanjor;

--
-- Name: codcble(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION codcble(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_codigo::int2 from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.codcble(integer) OWNER TO sanjor;

--
-- Name: codcomp(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION codcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.codcomp(integer) OWNER TO sanjor;

--
-- Name: codctes(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION codctes(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cte_codigo from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.codctes(integer) OWNER TO sanjor;

--
-- Name: codptv(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION codptv(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_codigo from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.codptv(integer) OWNER TO sanjor;

--
-- Name: compnro(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION compnro(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.comp_codigo::character varying||'  -  '||b.ash_numero from comprob a, astoh  b where b.ash_id= $1 and b.ash_comprob=a.comp_id;$_$;


ALTER FUNCTION public.compnro(integer) OWNER TO sanjor;

--
-- Name: compnrodeastoctas(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION compnrodeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||' - '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.compnrodeastoctas(integer) OWNER TO sanjor;

--
-- Name: conchequsado(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION conchequsado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from cheques,astoctas where chq_idastoc=astc_id and astc_idastoh= $1 and chq_idastoce is not null ;$_$;


ALTER FUNCTION public.conchequsado(integer) OWNER TO sanjor;

--
-- Name: condocusado(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION condocusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from docum,astoctas where doc_idastoc=astc_id and astc_idastoh= $1 and doc_idastoce is not null ;$_$;


ALTER FUNCTION public.condocusado(integer) OWNER TO sanjor;

--
-- Name: condolusado(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION condolusado(integer) RETURNS bigint
    LANGUAGE sql
    AS $_$select count(*) from monex,astoctas where mne_idastoc=astc_id and astc_idastoh= $1 and mne_idastoce is not null ;$_$;


ALTER FUNCTION public.condolusado(integer) OWNER TO sanjor;

--
-- Name: conivaprov(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION conivaprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select prov_coniva from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.conivaprov(integer) OWNER TO sanjor;

--
-- Name: cuitprov(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION cuitprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nrcuit from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.cuitprov(integer) OWNER TO sanjor;

--
-- Name: desccble(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION desccble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_codigo||'  -  '||cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.desccble(integer) OWNER TO sanjor;

--
-- Name: descchq(smallint); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION descchq(smallint) RETURNS character
    LANGUAGE sql
    AS $_$select bco_codigo||'  -  '||bco_nombre from bancos where bco_codigo= $1 ;$_$;


ALTER FUNCTION public.descchq(smallint) OWNER TO sanjor;

--
-- Name: desccomp(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION desccomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.desccomp(integer) OWNER TO sanjor;

--
-- Name: desccompdeastoctas(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION desccompdeastoctas(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select comp_codigo::character varying||'  -  '||comp_nombre||'  Nro:  '||astc_numero 
    from comprob,astoctas where comp_id=astc_comprob and astc_id= $1 ;$_$;


ALTER FUNCTION public.desccompdeastoctas(integer) OWNER TO sanjor;

--
-- Name: descemp(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION descemp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select emp_codigo||'  -  '||emp_nombre from empresa where emp_codigo= $1 ;$_$;


ALTER FUNCTION public.descemp(integer) OWNER TO sanjor;

--
-- Name: descemp(integer, integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION descemp(integer, integer) RETURNS character
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empres		ALIAS FOR $1; 
	ptovt		ALIAS FOR $2; 
	cuantos		integer;
	nomemp 		varchar;
	nomptov		varchar;
	retval 		varchar;
    BEGIN
    
    select count(*) into cuantos from
    	 ptovta where int4eq(empres,ptv_codemp);
    
	 if int4eq(cuantos,1) then
		select emp_nombre into retval from empresa where int4eq(empres,emp_codigo);
	    else
		select emp_nombre into nomemp from empresa where int4eq(empres,emp_codigo);
		select ptv_nombre into nomptov from ptovta where int4eq(ptovt,ptv_id) and int4eq(empres,ptv_codemp);
		retval:= nomemp ||'  -  '|| nomptov;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.descemp(integer, integer) OWNER TO sanjor;

--
-- Name: descempptv(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION descempptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select a.emp_nombre||'  -  '||b.ptv_nombre from ptovta b, empresa a where a.emp_codigo=b.ptv_codemp and ptv_id= $1 ;$_$;


ALTER FUNCTION public.descempptv(integer) OWNER TO sanjor;

--
-- Name: descptv(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION descptv(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ptv_codigo||'  -  '||ptv_nombre from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.descptv(integer) OWNER TO sanjor;

--
-- Name: elgrupo(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: zona
--

CREATE FUNCTION elgrupo(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	tipcta		ALIAS FOR $1; 
	codigo		ALIAS FOR $2; 
	modo		ALIAS FOR $3; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN

    retval:=1;
    if int4eq(tipcta,valvaramb(0,0,'TIPCTADXV')::int4) then
	select cop_grupo into retval from coprop where int4eq(codigo,cop_id);
	if found then
	    if int4eq(modo,1) then
		update coprop set cop_grupo=cop_grupo+1 where int4eq(codigo,cop_id);
	    end if;
	end if;
    end if;

    if int4eq(tipcta,valvaramb(0,0,'TIPCTADXC')::int4) then
	select prov_grupo into retval from prove where int4eq(codigo,prov_id);
	if found then
	    if int4eq(modo,1) then
		update prove set prov_grupo=prov_grupo+1 where int4eq(codigo,prov_id);
	    end if;
	end if;
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.elgrupo(integer, integer, integer) OWNER TO zona;

--
-- Name: emp_ptv(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION emp_ptv(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select 'Empresa: '||lpad(ptv_codemp::text,4,'0')||'  Emprendimiento '||lpad(ptv_codigo::text,4,'0') from ptovta where ptv_id= $1 ;$_$;


ALTER FUNCTION public.emp_ptv(integer) OWNER TO sanjor;

--
-- Name: f_ad_coprop(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_ad_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
    BEGIN
	select valvaramb(OLD.cop_codemp,OLD.cop_idptov,'TIPCTADXV') into tipcta;
	delete from ctes where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_coprop() OWNER TO sanjor;

--
-- Name: f_ad_gastos(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_ad_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    BEGIN
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=OLD.gto_id;
	select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;
	if int4eq(cuantos,1) THEN 
	    delete from liqegr where eg_id=cualliqegr;
	    delete from gtoxliqe where gxl_gasto=OLD.gto_id;
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_gastos() OWNER TO sanjor;

--
-- Name: f_ad_prove(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_ad_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
    BEGIN
	select valvaramb(OLD.prov_codemp,OLD.prov_idptov,'TIPCTADXC') into tipcta;
	delete from ctes where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_ad_prove() OWNER TO sanjor;

--
-- Name: f_ai_astoctas(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_ai_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	ctabco		integer;
	tctabco		integer;
    BEGIN
    select idcble(NEW.astc_codemp,NEW.astc_idptov,'BANCO') into ctabco;
    select valvaramb(NEW.astc_codemp,NEW.astc_idptov,'TCTBANCO') into tctabco;
    if(int4eq(NEW.astc_ctacble,ctabco))  THEN
	if(NEW.astc_fecvto is null)  THEN 
	    update astoctas set astc_fecvto=NEW.astc_fecval where astc_id=NEW.astc_id;
	END IF;
	if (NEW.astc_tipcta is null) then 
	    update astoctas set astc_tipcta=tctabco where astc_id=NEW.astc_id;
	END IF;
    END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_astoctas() OWNER TO sanjor;

--
-- Name: f_ai_convenios(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_ai_convenios() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	unifun		integer;
	centro		integer;
	newunif		integer;
	existe		integer;
	idastoh		integer;
	cuentadxv	integer;
	rubro		integer;
	cargo		integer;
    BEGIN

	select cop_unifun,cop_centro into unifun,centro from coprop where cop_id=NEW.con_idcopr;
	newunif:=unifun + 90000;

	select cop_id into existe from coprop where cop_centro=centro and cop_unifun=newunif;
	if not found then
	    insert into coprop (cop_codemp,cop_idptov,cop_unifun,cop_nombre,cop_codaso,cop_porc1,cop_porc2,cop_porc3,cop_porc4,cop_porc5,cop_direcc,cop_locali,cop_codpos,cop_provin,cop_descuf,cop_tipuf,cop_coniva,cop_nrcuit,cop_tipdoc,cop_nrodoc,cop_grupo,cop_estado,cop_mail,cop_inter,cop_recib,cop_centro,cop_division) 
		select cop_codemp,cop_idptov,newunif,cop_nombre,cop_codaso,0,0,0,0,0,cop_direcc,cop_locali,cop_codpos,cop_provin,cop_descuf,cop_tipuf,cop_coniva,cop_nrcuit,cop_tipdoc,cop_nrodoc,cop_grupo,1,cop_mail,cop_inter,cop_recib,cop_centro,cop_division from coprop where cop_id=NEW.con_idcopr;
	  else
	    update coprop set cop_estado=1 where cop_id=existe;
	end if;


	insert into astoh (ash_codemp,ash_idptov,ash_anio,ash_mes,ash_comprob,ash_numero,ash_titulo,ash_fecomp,ash_fecval,ash_leyen,ash_nro2,ash_estado) 
	    values (NEW.con_codemp,NEW.con_idptov,date_part('year',NEW.con_fechai)::int2,date_part('month',NEW.con_fechai)::int2,NEW.con_comprob,NEW.con_numero,'Convenio de Pago',NEW.con_fechai,NEW.con_fechai,'Convenio de Pago',0,-1);

	select ash_id into idastoh from astoh where ash_codemp=NEW.con_codemp and ash_idptov=NEW.con_idptov and ash_comprob=NEW.con_comprob and ash_numero=NEW.con_numero;

	select idcbl(NEW.con_codemp,valvaramb(NEW.con_codemp,0,'DEUDXV')::integer)  into cuentadxv;


	insert into astoctas (astc_tipcta,astc_ctacte,astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro) 
	     values (tipctacbl(cuentadxv),NEW.con_idcopr,idastoh,cuentadxv,NEW.con_monto*-1,NEW.con_codemp,NEW.con_idptov,NEW.con_comprob,NEW.con_numero,NEW.con_fechai,-1,NEW.con_division,NEW.con_centro);

	insert into astoctas (astc_tipcta,astc_ctacte,astc_idastoh,astc_ctacble,astc_importe,astc_codemp,astc_idptov,astc_comprob,astc_numero,astc_fecval,astc_estado,astc_division,astc_centro) 
	     values (tipctacbl(cuentadxv),existe,idastoh,cuentadxv,NEW.con_monto,NEW.con_codemp,NEW.con_idptov,NEW.con_comprob,NEW.con_numero,NEW.con_fechai,-1,NEW.con_division,NEW.con_centro);


	select valvaramb(NEW.con_codemp,0,'CODCARCONV') into cargo;

	select car_rubcar into rubro from cargos where car_id=cargo;

	insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_cargo,clq_leyen,clq_canti,clq_interes,clq_precio,clq_importe,clq_idcopr)
	    values (NEW.con_codemp,NEW.con_idptov,NEW.con_centro,NEW.con_division,date_part('year',NEW.con_fechai)::int2,date_part('month',NEW.con_fechai)::int2,NEW.con_fechai,NEW.con_fechai,NEW.con_comprob,NEW.con_numero,NEW.con_operador,rubro,cargo,NEW.con_leyen,1,0,NEW.con_monto,NEW.con_monto,NEW.con__idcopr);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_convenios() OWNER TO sanjor;

--
-- Name: f_ai_coprop(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_ai_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    newunif		int4;
    tipcta		int4;
    BEGIN

    if(int4gt(NEW.cop_unifun,90000)) then
	newunif:=NEW.cop_unifun + 90000 ;
	insert into coprop (cop_codemp,cop_idptov,cop_unifun,cop_nombre,cop_codaso,cop_porc1,cop_porc2,cop_porc3,cop_porc4,cop_porc5,cop_direc,cop_locali,cop_codpos,cop_provin,cop_descuf,cop_tipuf,cop_coniva,cop_nrcuit,cop_tipdoc,cop_nrodoc,cop_grupo,cop_estado,cop_mail,cop_inter,cop_recib,cop_centro,cop_division) 
	    values (NEW.cop_codemp,NEW.cop_idptov,newunif,NEW.cop_nombre,NEW.cop_codaso,NEW.cop_porc1,NEW.cop_porc2,NEW.cop_porc3,NEW.cop_porc4,NEW.cop_porc5,NEW.cop_direc,NEW.cop_locali,NEW.cop_codpos,NEW.cop_provin,NEW.cop_descuf,NEW.cop_tipuf,NEW.cop_coniva,NEW.cop_nrcuit,NEW.cop_tipdoc,NEW.cop_nrodoc,NEW.cop_grupo,5,NEW.cop_mail,NEW.cop_inter,NEW.cop_recib,NEW.cop_centro,NEW.cop_division);
    end if;

    select valvaramb(NEW.cop_codemp,NEW.cop_idptov,'TIPCTADXV') into tipcta;
    insert into ctes (cte_codemp,cte_idptov,cte_tipcta,cte_codigo,cte_nombre,cte_idtal,cte_idtabla) values (NEW.cop_codemp,NEW.cop_idptov,tipcta,NEW.cop_unifun,NEW.cop_nombre,0,NEW.cop_id);

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_coprop() OWNER TO sanjor;

--
-- Name: f_ai_empresa(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_ai_empresa() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	unifun		integer;
	regis		record;
    BEGIN

    for regis in select * from varambi where vari_codemp=1 and vari_idptov=0 
	loop
	    insert into varambi values (NEW.emp_codigo,0,regis.vari_codigo,regis.vari_nombre,regis.vari_valor,regis.vari_tipo);
	end loop;

    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_empresa() OWNER TO sanjor;

--
-- Name: f_ai_gastos(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_ai_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    idliqegr		integer;
    BEGIN
--	insert into liqegr 
--	    (eg_idastoh,eg_codemp,eg_idptov,eg_centro,eg_rubro,eg_subrub,eg_hayfac,eg_fecreg,eg_prove,eg_nprove,eg_cuitprov,eg_factur,eg_anio,eg_mes,eg_estado,eg_impag,eg_importe,eg_operador,eg_leyen)
--	    values 
--	    (NEW.gto_idastoh,NEW.gto_codemp,NEW.gto_idptov,NEW.gto_centro,NEW.gto_rubro,NEW.gto_subrub,NEW.gto_hayfac,NEW.gto_fecreg,NEW.gto_prove,NEW.gto_nprove,NEW.gto_cuitprov,NEW.gto_factur,NEW.gto_anio,NEW.gto_mes,NEW.gto_estado,NEW.gto_impag,NEW.gto_importe,NEW.gto_operador,NEW.gto_leyen);
--	select max(eg_id) into idliqegr from liqegr;
--	insert into gtoxliqe (gxl_liqegr,gxl_gasto,gxl_operador,eg_leyen) values (idliqegr, NEW.gto_id, NEW.gto_operador, NEW.gto_leyen);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_gastos() OWNER TO sanjor;

--
-- Name: f_ai_prove(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_ai_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
    BEGIN
	select valvaramb(NEW.prov_codemp,NEW.prov_idptov,'TIPCTADXC') into tipcta;
	insert into ctes (cte_codemp,cte_idptov,cte_tipcta,cte_codigo,cte_nombre,cte_idtal,cte_idtabla) values (NEW.prov_codemp,NEW.prov_idptov,tipcta,NEW.prov_codigo,NEW.prov_nombre,0,NEW.prov_id);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_prove() OWNER TO sanjor;

--
-- Name: f_ai_ptovta(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_ai_ptovta() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	registro	 record;
	divis		 int4;
    BEGIN

    for registro in select * from comprob where comp_codemp=NEW.ptv_codemp and comp_idptov=0 
	loop
	    insert into talon (tal_codemp,tal_idptov,tal_comprob,tal_valor,tal_fecha,tal_nombre) values (NEW.ptv_codemp,NEW.ptv_id,registro.comp_id,1,date(now()),registro.comp_nombre);
	end loop;
    insert into division (div_codemp, div_idptov, div_codigo, div_nombre) values (NEW.ptv_codemp, NEW.ptv_id, 1, NEW.ptv_nombre);
    select div_id into divis from division order by div_id desc limit 1;
    insert into centroc (cco_codemp,cco_idptov,cco_coddiv,cco_codigo,cco_nombre) values (NEW.ptv_codemp, NEW.ptv_id, divis, 1, NEW.ptv_nombre);
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_ai_ptovta() OWNER TO sanjor;

--
-- Name: f_au_astoctas(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_au_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	total	numeric;
	dias	numeric;
BEGIN
    if int4ne(NEW.astc_estado,OLD.astc_estado) THEN 
	update cheques set chq_estado=NEW.astc_estado where chq_idastoc=NEW.astc_id;
	update monex set mne_estado=NEW.astc_estado where mne_idastoc=NEW.astc_id;
	update docum set doc_estado=NEW.astc_estado where doc_idastoc=NEW.astc_id;
	END IF;
    if int4ne(NEW.astc_ctacte,OLD.astc_ctacte) THEN 
	if int4eq(OLD.astc_ctacble,18) THEN 
	    update emiti set emi_codcli=NEW.astc_ctacte where emi_idastoh=NEW.astc_idastoh;
	END IF;
	if int4eq(OLD.astc_ctacble,134) THEN 
		update compra set cpra_prove=NEW.astc_ctacte where cpra_idastoh=NEW.astc_idastoh;
	END IF;
    END IF;
    if (int4ne(NEW.astc_estado,OLD.astc_estado) and int4eq(NEW.astc_estado,2)) THEN 
	select sum(astc_importe) into total from astoctas where astc_idastoh=NEW.astc_idastoh and astc_importe>0;
	update compra set cpra_total=total where cpra_idastoh=OLD.astc_idastoh;
    END IF;

    if (int4eq(NEW.astc_estado,999) and int2eq(NEW.astc_cierra,2::int2) and (int4eq(NEW.astc_ctacble,idcble(NEW.astc_codemp,NEW.astc_idptov,'DEUDXV')::integer) or int4eq(NEW.astc_ctacble,idcble(NEW.astc_codemp,NEW.astc_idptov,'DEUDXC')::integer))) THEN
	update astoctas set astc_cierra=1 where astc_ctacble=NEW.astc_ctacble and astc_tipcta=NEW.astc_tipcta and astc_ctacte=NEW.astc_ctacte and astc_grupo=NEW.astc_grupo and astc_idastoh!=NEW.astc_idastoh;
    END IF;

    if (int4ne(NEW.astc_estado,OLD.astc_estado)  and int2eq(NEW.astc_cierra,2::int2) and int4eq(NEW.astc_ctacble,idcble(NEW.astc_codemp,NEW.astc_idptov,'DEUDXV')::integer)) THEN
	select diasconpag(emi_conpag) into dias from emiti where emi_idastoh=NEW.astc_idastoh;
	    if found then
		update astoctas set astc_fecvto=astc_fecval+dias::integer where astc_id=NEW.astc_id;
	    end if;
    END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_astoctas() OWNER TO sanjor;

--
-- Name: f_au_astoh(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_au_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if int4ne(NEW.ash_estado,OLD.ash_estado) THEN 
	update astoctas set astc_estado=NEW.ash_estado where astc_idastoh=OLD.ash_id;
	update compra set cpra_estado=NEW.ash_estado where cpra_idastoh=OLD.ash_id;
	update emiti set emi_estado=NEW.ash_estado where emi_idastoh=OLD.ash_id;
	update gastos set gto_estado=NEW.ash_estado where gto_idastoh=OLD.ash_id;
	update liqegr set eg_estado=NEW.ash_estado where eg_idastoh=OLD.ash_id;
	delete from astoctas where astc_importe=0 and astc_idastoh=OLD.ash_id;
	END IF;
    if (int4ne(NEW.ash_estado,OLD.ash_estado) and int4eq(NEW.ash_estado,999))  THEN 
	update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idastoh=OLD.ash_id;
	END IF;
    if date_ne(NEW.ash_fecval,OLD.ash_fecval) THEN 
	update astoctas set astc_fecval=NEW.ash_fecval where astc_idastoh=OLD.ash_id;
	update compra set cpra_fecval=NEW.ash_fecval where cpra_idastoh=OLD.ash_id;
	update emiti set emi_fecval=NEW.ash_fecval where emi_idastoh=OLD.ash_id;
	update astoh set ash_anio=date_part('year',NEW.ash_fecval),ash_mes=date_part('month',NEW.ash_fecval) where ash_id=OLD.ash_id;
	END IF;
    if date_ne(NEW.ash_fecomp,OLD.ash_fecomp) THEN 
	update compra set cpra_fecori=NEW.ash_fecomp where cpra_idastoh=OLD.ash_id;
	END IF;
    if int4ne(NEW.ash_comprob,OLD.ash_comprob) THEN 
	update astoctas set astc_comprob=NEW.ash_comprob where astc_idastoh=OLD.ash_id;
	update compra set cpra_comprob=NEW.ash_comprob where cpra_idastoh=OLD.ash_id;
	update emiti set emi_comprob=NEW.ash_comprob where emi_idastoh=OLD.ash_id;
	update gastos set gto_comprob=NEW.ash_comprob where gto_idastoh=OLD.ash_id;
	END IF;
    if int4ne(NEW.ash_numero,OLD.ash_numero) THEN 
	update astoctas set astc_numero=NEW.ash_numero where astc_idastoh=OLD.ash_id;
	update compra set cpra_numero=NEW.ash_numero where cpra_idastoh=OLD.ash_id;
	update emiti set emi_numero=NEW.ash_numero where emi_idastoh=OLD.ash_id;
	update gastos set gto_numero=NEW.ash_numero where gto_idastoh=OLD.ash_id;
	END IF;
    if int4ne(NEW.ash_codemp,OLD.ash_codemp) THEN 
	update astoctas set astc_codemp=NEW.ash_codemp where astc_idastoh=OLD.ash_id;
	update compra set cpra_codemp=NEW.ash_codemp where cpra_idastoh=OLD.ash_id;
	update emiti set emi_codemp=NEW.ash_codemp where emi_idastoh=OLD.ash_id;
	update gastos set gto_codemp=NEW.ash_codemp where gto_idastoh=OLD.ash_id;
	update liqegr set eg_codemp=NEW.ash_codemp where eg_idastoh=OLD.ash_id;
	END IF;
    if int4ne(NEW.ash_idptov,OLD.ash_idptov) THEN 
	update astoctas set astc_idptov=NEW.ash_idptov where astc_idastoh=OLD.ash_id;
	update compra set cpra_idptov=NEW.ash_idptov where cpra_idastoh=OLD.ash_id;
	update emiti set emi_idptov=NEW.ash_idptov where emi_idastoh=OLD.ash_id;
	update gastos set gto_idptov=NEW.ash_idptov where gto_idastoh=OLD.ash_id;
	update liqegr set eg_idptov=NEW.ash_idptov where eg_idastoh=OLD.ash_id;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_astoh() OWNER TO sanjor;

--
-- Name: f_au_compra(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_au_compra() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if(int4ne(NEW.cpra_prove,OLD.cpra_prove)) THEN 
	update compra set cpra_nomprov=nomprove(NEW.cpra_prove), cpra_nrcuit=cuitprov(NEW.cpra_prove),cpra_coniva=conivaprov(NEW.cpra_prove) where cpra_id=OLD.cpra_id;
    END IF;
RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_compra() OWNER TO sanjor;

--
-- Name: f_au_coprop(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_au_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	tipcta		integer;
	telefono	character varying;
	mail		character varying;
BEGIN
	select valvaramb(NEW.cop_codemp,NEW.cop_idptov,'TIPCTADXV') into tipcta;
	if int4ne(NEW.cop_unifun,OLD.cop_unifun) THEN 
	    update ctes set cte_codigo=NEW.cop_unifun where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	END IF;
	if int4ne(NEW.cop_estado,OLD.cop_estado) THEN 
	    update ctes set cte_estado=NEW.cop_estado where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	END IF;
	if bpcharne(NEW.cop_nombre,OLD.cop_nombre) THEN 
	    update ctes set cte_nombre=NEW.cop_nombre where cte_codemp=OLD.cop_codemp and cte_idptov=OLD.cop_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.cop_id;
	    if OLD.cop_nombre is not null THEN 
		telefono:=' ';
		mail:=' ';
		select tel_dato into telefono from telefon where tel_tipent=tipcta and tel_codigo=OLD.cop_id and tel_tiptel not in (6,7) order by tel_codigo desc limit 1;
		select tel_dato into mail from telefon where tel_tipent=tipcta and tel_codigo=OLD.cop_id and tel_tiptel=7 limit 1;
		insert into cambtitu (cbt_codemp,cbt_idptov,cbt_division,cbt_centro,cbt_unifun,cbt_idcopr,cbt_nombre,cbt_direcc,cbt_locali,cbt_codpos,cbt_provin,cbt_tipdoc,cbt_nrodoc,cbt_nrcuit,cbt_telefono,cbt_mail) values (OLD.cop_codemp,OLD.cop_idptov,OLD.cop_division,OLD.cop_centro,OLD.cop_unifun,OLD.cop_id,OLD.cop_nombre,OLD.cop_direcc,OLD.cop_locali,OLD.cop_codpos,OLD.cop_provin,OLD.cop_tipdoc,OLD.cop_nrodoc,OLD.cop_nrcuit,telefono,mail);
	    END IF;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_coprop() OWNER TO sanjor;

--
-- Name: f_au_emiti(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_au_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
BEGIN
    if int4ne(NEW.emi_estado,OLD.emi_estado) THEN 
	update movsto set movs_estado=NEW.emi_estado where movs_idemiti=OLD.emi_id;
	if int4eq(NEW.emi_estado,2) THEN 
	    update astoctas set astc_fecvto=astc_fecval+diasconpag(NEW.emi_conpag) where astc_idastoh=OLD.emi_idastoh and astc_ctacble=idcble(astc_codemp,astc_idptov,'DEUDXV');
	    END IF;
	END IF;
    if int4ne(NEW.emi_codcli,OLD.emi_codcli) THEN 
	update emiti set emi_nomcli=nomcli(NEW.emi_codcli),emi_nrocuit=cuitcli(NEW.emi_codcli),emi_conivac=conivacli(NEW.emi_codcli) where emi_id=OLD.emi_id;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_emiti() OWNER TO sanjor;

--
-- Name: f_au_gastos(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_au_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    BEGIN
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=NEW.gto_id;
	select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;
	if int4eq(cuantos,1) THEN 
	    update liqegr set
		eg_codemp=NEW.gto_codemp,
		eg_idptov=NEW.gto_idptov,
		eg_centro=NEW.gto_centro,
		eg_rubro=NEW.gto_rubro,
		eg_subrub=NEW.gto_subrub,
		eg_hayfac=NEW.gto_hayfac,
		eg_prove=NEW.gto_prove,
		eg_nprove=NEW.gto_nprove,
		eg_cuitprov=NEW.gto_cuitprov,
		eg_factur=NEW.gto_factur,
		eg_anio=NEW.gto_anio,
		eg_mes=NEW.gto_mes,
		eg_estado=NEW.gto_estado,
		eg_impag=NEW.gto_impag,
		eg_importe=NEW.gto_importe,
		eg_operador=NEW.gto_operador,
		eg_leyen=NEW.gto_leyen where eg_id=cualliqegr;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_gastos() OWNER TO sanjor;

--
-- Name: f_au_liquidacion(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_au_liquidacion() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	total	numeric;
	dias	numeric;
BEGIN
    if int4ne(NEW.l_estado,OLD.l_estado) THEN 
	if int4ne(NEW.l_estado,999) THEN 
	    update compliquid set cl_estado=NEW.l_estado where cl_idliq=NEW.l_id;
	    delete from liqui where lq_idliq=NEW.l_id;
	    delete from compliq where clq_idliq=NEW.l_id;
	    delete from auxint where ai_idliq=NEW.l_id;
	END IF;

      else

	update compliquid set cl_estado=NEW.l_estado where cl_idliq=NEW.l_id;
	update liqui set lq_estado=NEW.l_estado where lq_idliq=NEW.l_id;
	update compliq set clq_estado=NEW.l_estado where clq_idliq=NEW.l_id;
    END IF;

RETURN NEW;
END;$$;


ALTER FUNCTION public.f_au_liquidacion() OWNER TO sanjor;

--
-- Name: f_au_prove(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_au_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
	tipcta		integer;
BEGIN
	select valvaramb(NEW.prov_codemp,NEW.prov_idptov,'TIPCTADXC') into tipcta;
	if int4ne(NEW.prov_codigo,OLD.prov_codigo) THEN 
	    update ctes set cte_codigo=NEW.prov_codigo where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
	END IF;
	if int4ne(NEW.prov_estado,OLD.prov_estado) THEN 
	    update ctes set cte_estado=NEW.prov_estado where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
	END IF;
	if bpcharne(NEW.prov_nombre,OLD.prov_nombre) THEN 
	    update ctes set cte_nombre=NEW.prov_nombre where cte_codemp=OLD.prov_codemp and cte_idptov=OLD.prov_idptov and cte_tipcta=tipcta and cte_idtabla=OLD.prov_id;
	END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_au_prove() OWNER TO sanjor;

--
-- Name: f_bd_astoctas(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bd_astoctas() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN
----------------------------  CHEQUES ---------------------------------------    
    select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from cheques where int4eq(chq_idastoc,OLD.astc_id) and chq_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN CHEQUE ASIGNADO ANTERIORMENTE';
	    else
		delete from cheques where int4eq(chq_idastoc,OLD.astc_id);
	END IF;
    END IF;
    select count(*) into cuantos from cheques where int4eq(chq_idastoce,OLD.astc_id);
    if found then
	update cheques set chq_estado=2,chq_idastoce=NULL where int4eq(chq_idastoce,OLD.astc_id);
    END IF;
----------------------------  MONEX ---------------------------------------    
    select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from monex where int4eq(mne_idastoc,OLD.astc_id) and mne_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from monex where int4eq(mne_idastoc,OLD.astc_id);
	END IF;
    END IF;
    select count(*) into cuantos from monex where int4eq(mne_idastoce,OLD.astc_id);
    if found then
	update monex set mne_estado=2,mne_idastoce=NULL where int4eq(mne_idastoce,OLD.astc_id);
    END IF;
----------------------------  DOCUM ---------------------------------------    
    select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id);
    if int4ne(cuantos,0) then
	select count(*) into cuantos from docum where int4eq(doc_idastoc,OLD.astc_id) and doc_idastoce is not null;
	if int4ne(cuantos,0) then
		RAISE EXCEPTION  'NO SE PUEDE BORRAR UN BILLETE ASIGNADO ANTERIORMENTE';
	    else
		delete from docum where int4eq(doc_idastoc,OLD.astc_id);
	END IF;
    END IF;
    select count(*) into cuantos from docum where int4eq(doc_idastoce,OLD.astc_id);
    if found then
	update docum set doc_estado=2,doc_idastoce=NULL where int4eq(doc_idastoce,OLD.astc_id);
    END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_astoctas() OWNER TO sanjor;

--
-- Name: f_bd_astoh(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bd_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN
    delete from emiti where int4eq(emi_idastoh,OLD.ash_id);
--    delete from compliq where int4eq(cliq_idastoh,OLD.ash_id);
    delete from compra where int4eq(cpra_idastoh,OLD.ash_id);
    delete from astoctas where int4eq(astc_idastoh,OLD.ash_id);
    update astoctas set astc_cierra=1,astc_idashce=NULL where astc_idastoh=OLD.ash_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_astoh() OWNER TO sanjor;

--
-- Name: f_bd_coprop(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bd_coprop() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
	cuantos		int4;
    BEGIN
	cuantos:=0;
	select valvaramb(OLD.cop_codemp,OLD.cop_idptov,'TIPCTADXV') into tipcta;
	select count(*) into cuantos from astoctas where astc_codemp=OLD.cop_codemp and astc_idptov=OLD.cop_idptov and astc_tipcta=tipcta and astc_ctacte=OLD.cop_id;
	if int4ne(cuantos,0) then
	    RAISE EXCEPTION  'NO SE PUEDE BORRAR UN COPROPIETARIO CON REGISTROS CARGADOS';
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_coprop() OWNER TO sanjor;

--
-- Name: f_bd_emiti(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bd_emiti() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos		int4;
    BEGIN
    delete from movsto where int4eq(movs_idemiti,OLD.emi_id);
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_emiti() OWNER TO sanjor;

--
-- Name: f_bd_gastos(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bd_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    BEGIN
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=OLD.gto_id;
	select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;
	if int4gt(cuantos,1) THEN 
	RAISE EXCEPTION  'NO SE PUEDE BORRAR EL GASTO YA QUE ESTA AGRUPADO, PRIMERO DESAGUPAR LUEGO BORRAR';
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_gastos() OWNER TO sanjor;

--
-- Name: f_bd_liquidacion(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bd_liquidacion() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cuantos	int4;
    BEGIN
	delete from compliquid where cl_idliq=OLD.l_id;
	delete from liqui where lq_idliq=OLD.l_id;
	delete from compliq where clq_idliq=OLD.l_id;
	delete from auxint where ai_idliq=OLD.l_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_liquidacion() OWNER TO sanjor;

--
-- Name: f_bd_prove(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bd_prove() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	tipcta		integer;
	cuantos		int4;
    BEGIN
	cuantos:=0;
	select valvaramb(OLD.prov_codemp,OLD.prov_idptov,'TIPCTADXC') into tipcta;
	select count(*) into cuantos from astoctas where astc_codemp=OLD.prov_codemp and astc_idptov=OLD.prov_idptov and astc_tipcta=tipcta and astc_ctacte=OLD.prov_id;
	if int4ne(cuantos,0) then
	    RAISE EXCEPTION  'NO SE PUEDE BORRAR UN proveIETARIO CON REGISTROS CARGADOS';
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_prove() OWNER TO sanjor;

--
-- Name: f_bd_ptovta(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bd_ptovta() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
	registro	 record;
    BEGIN

    for registro in select * from comprob where comp_codemp=OLD.ptv_codemp and comp_idptov=0 
	loop
	    delete from talon where tal_codemp=OLD.ptv_codemp and tal_idptov=OLD.ptv_id and tal_comprob=registro.comp_id;
	end loop;
    delete from centroc where cco_codemp=OLD.ptv_codemp and cco_idptov=OLD.ptv_id;
    delete from division where div_codemp=OLD.ptv_codemp and div_idptov=OLD.ptv_id;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bd_ptovta() OWNER TO sanjor;

--
-- Name: f_bu_astoh(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bu_astoh() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN
if(int4eq(NEW.ash_estado,2) and int4eq(OLD.ash_estado,-1)) THEN 
------------------ PARTIDA DOBLE -----------------------------------
    select sum(astc_importe) into saldo from astoctas where astc_idastoh=NEW.ash_id;
    if numeric_ne(saldo,0) then
	RAISE EXCEPTION  'NO SE PUEDE FINALIZAR EL ASIENTO YA QUE EL SALDO ES DISTINTO DE CERO';
    end if;
------------------ CASO CHEQUES -----------------------------------
END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_astoh() OWNER TO sanjor;

--
-- Name: f_bu_cheques(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bu_cheques() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
saldo	numeric;
BEGIN
if(int4eq(NEW.chq_estado,2) and int4ne(OLD.chq_estado,2)) THEN 
    select astc_importe into saldo from astoctas where astc_id=NEW.chq_idastoce;
    if found then
	RAISE EXCEPTION  'NO SE PUEDE CAMBIAR DE ESTADO UN CHEQUE UTILIZADO';
    end if;
END IF;
    RETURN NEW;
    END;$$;


ALTER FUNCTION public.f_bu_cheques() OWNER TO sanjor;

--
-- Name: f_bu_gastos(); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION f_bu_gastos() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
    DECLARE
    cualliqegr		integer;
    cuantos		integer;
    BEGIN
	select gxl_liqegr into cualliqegr from gtoxliqe where gxl_gasto=OLD.gto_id;
	select count(*) into cuantos from gtoxliqe where gxl_liqegr=cualliqegr;
	if(int4gt(cuantos,1) and numeric_ne(OLD.gto_impag,NEW.gto_impag)) THEN 
	RAISE EXCEPTION  'NO SE PUEDE MODIFICAR YA QUE ESTA AGRUPADO, PRIMERO DESAGUPAR LUEGO MODIFICAR';
	END IF;
    RETURN OLD;
    END;$$;


ALTER FUNCTION public.f_bu_gastos() OWNER TO sanjor;

--
-- Name: grupocli(integer, integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION grupocli(integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	cliente		ALIAS FOR $1; 
	modo		ALIAS FOR $2; -- 1:graba  2:consulta
	otro 		integer;
	retval 		integer;
    BEGIN
    select cop_grupo into retval from
    	 coprop where int4eq(cliente,cop_id);

    if found then
	if int4eq(modo,1) then
	    update coprop set cop_grupo=cop_grupo+1 where int4eq(cliente,cop_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.grupocli(integer, integer) OWNER TO sanjor;

--
-- Name: idcbl(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION idcbl(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1; 
    ptovta		ALIAS FOR $2; 
    codcble		ALIAS FOR $3; 
    retval 		varchar;
    BEGIN

    select cbl_id into retval from ctacble where cbl_codemp=codemp and cbl_idptov=ptovta and int4eq(cbl_codigo,codcble);
    if not found then
	select cbl_id into retval from ctacble where cbl_codemp=codemp and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble);
	if not found then
	    select cbl_id into retval from ctacble where int4eq(0,cbl_codemp) and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble);
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.idcbl(integer, integer, integer) OWNER TO sanjor;

--
-- Name: idcble(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION idcble(integer, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1; 
    ptovta		ALIAS FOR $2; 
    codigo		ALIAS FOR $3; 
    codcble		integer;
    retval 		varchar;
    BEGIN

    select vari_valor into codcble from varambi where int4eq(ptovta,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
    if not found then
	select vari_valor into codcble from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	if not found then
	    select vari_valor into codcble from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq(codigo,vari_codigo);
	end if;
    end if;

    select cbl_id into retval from ctacble where cbl_codemp=codemp and cbl_idptov=ptovta and int4eq(cbl_codigo,codcble::int4) ;
    if not found then
	select cbl_id into retval from ctacble where cbl_codemp=codemp and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble::int4) ;
	if not found then
	    select cbl_id into retval from ctacble where int4eq(0,cbl_codemp) and int4eq(0,cbl_idptov) and int4eq(cbl_codigo,codcble::int4) ;
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.idcble(integer, integer, character varying) OWNER TO sanjor;

--
-- Name: idcli(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION idcli(integer, integer, integer, integer, integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cop_id from coprop where cop_codemp=$1 and cop_idptov=$2 and cop_centro=$3 and cop_division=$4 and cop_unifun=$5;$_$;


ALTER FUNCTION public.idcli(integer, integer, integer, integer, integer) OWNER TO sanjor;

--
-- Name: idcomp(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION idcomp(integer, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	comproba	ALIAS FOR $3; 
	retval 		integer;
    BEGIN
    select comp_id into retval from comprob where int4eq(ptovta,comp_idptov) and bpchareq(comproba,comp_codigo);
    if not found then
	select comp_id into retval from comprob where int4eq(codemp,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	if not found then
	    select comp_id into retval from comprob where int4eq(0,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	end if;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.idcomp(integer, integer, character varying) OWNER TO sanjor;

--
-- Name: idcte(integer, integer, integer, integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION idcte(integer, integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1;
    ptovta		ALIAS FOR $2;
    tipcta		ALIAS FOR $3;
    codcte		ALIAS FOR $4;
    retval 		varchar;
    BEGIN

    select cte_id into retval from ctes where cte_codemp=codemp and cte_idptov=ptovta and cte_tipcta=tipcta and int4eq(cte_codigo,codcte);
    if not found then
	select cte_id into retval from ctes where cte_codemp=codemp and int4eq(0,cte_idptov) and cte_tipcta=tipcta and int4eq(cte_codigo,codcte);
	if not found then
	    select cte_id into retval from ctes where int4eq(0,cte_codemp) and int4eq(0,cte_idptov) and cte_tipcta=tipcta and int4eq(cte_codigo,codcte);
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.idcte(integer, integer, integer, integer) OWNER TO sanjor;

--
-- Name: intercentro(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION intercentro(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select int_valor from interes where int_centro= $1 order by int_fecha desc limit 1;$_$;


ALTER FUNCTION public.intercentro(integer) OWNER TO sanjor;

--
-- Name: liquido(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION liquido(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	idliq		 ALIAS FOR $1; 
	codemp		 integer;
	idptov		 integer;
	centro		 integer;
	division	 integer;
	anio		 integer;
	mes		 integer;
	feccie		 date;
	fecvto		 date;
	comprob		 integer;
	numero		 integer;
	srubcar		 integer;
	operador	 integer;
	idcopr		 integer;
	importe		 numeric(15,2);
	retval 		 integer;
	registro	 record;
	regi		 record;
	regis		 record;
    BEGIN

    retval:=0;

    select l_codemp,l_idptov,l_centro,l_division,l_anio,l_mes,l_feccie,l_fecvto,l_comprob,l_numero,l_operador 
	into codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador from liquidacion where l_id=idliq; 


    for regis in select * from comprop where cmpr_centro=centro and cmpr_estado=1 
	loop
	    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_interes,clq_precio,clq_importe,clq_idcopr,clq_idliq)
		values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,regis.cmpr_rubcar,regis.cmpr_srubcar,regis.cmpr_cargo,regis.cmpr_leyen,regis.cmpr_canti,0,regis.cmpr_precio,regis.cmpr_importe,regis.cmpr_idcopr,idliq);
	end loop;


    for registro in select * from compliquid where cl_idliq=idliq
	loop
	select car_srubcar into srubcar from cargos where car_id=registro.cl_cargo;
	for regi in select * from coprop where cop_centro=centro and cop_estado=1
	    loop
		if int4eq(registro.cl_porc,1) then
		    importe:=registro.cl_importe * regi.cop_porc1 / 100;
		  else
		    if int4eq(registro.cl_porc,2) then
			importe:=registro.cl_importe * regi.cop_porc2 / 100;
		      else
			if int4eq(registro.cl_porc,3) then
			    importe:=registro.cl_importe * regi.cop_porc3 / 100;
			  else
			    if int4eq(registro.cl_porc,4) then
				importe:=registro.cl_importe * regi.cop_porc4 / 100;
			      else
				if int4eq(registro.cl_porc,5) then
				    importe:=registro.cl_importe * regi.cop_porc5 / 100;
				end if;
			    end if;
			end if;
		    end if;
		end if;

		if numeric_ne(importe,0) then
		    insert into compliq (clq_codemp,clq_idptov,clq_centro,clq_division,clq_anio,clq_mes,clq_fecha,clq_fecvto,clq_comprob,clq_numero,clq_operad,clq_rubcar,clq_srubcar,clq_cargo,clq_leyen,clq_canti,clq_interes,clq_precio,clq_importe,clq_idcopr,clq_idliq)
			values (codemp,idptov,centro,division,anio,mes,feccie,fecvto,comprob,numero,operador,registro.cl_rubcar,srubcar,registro.cl_cargo,registro.cl_leyen,1,0,importe,importe,regi.cop_id,idliq);
		end if;

	    importe:=0;
	    end loop;
	end loop;

    select calc_intliq(idliq) into retval;

    RETURN retval;
    END;$_$;


ALTER FUNCTION public.liquido(integer) OWNER TO sanjor;

--
-- Name: monedacbl(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION monedacbl(integer) RETURNS smallint
    LANGUAGE sql
    AS $_$select cbl_moneda from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.monedacbl(integer) OWNER TO sanjor;

--
-- Name: nomartic(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION nomartic(integer) RETURNS character
    LANGUAGE sql
    AS $_$select art_nombre from articvta where art_id= $1 ;$_$;


ALTER FUNCTION public.nomartic(integer) OWNER TO sanjor;

--
-- Name: nomcble(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION nomcble(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cbl_nombre from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.nomcble(integer) OWNER TO sanjor;

--
-- Name: nomcomp(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION nomcomp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select comp_nombre from comprob where comp_id= $1 ;$_$;


ALTER FUNCTION public.nomcomp(integer) OWNER TO sanjor;

--
-- Name: nomctes(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION nomctes(integer) RETURNS character
    LANGUAGE sql
    AS $_$select cte_nombre from ctes where cte_id= $1 ;$_$;


ALTER FUNCTION public.nomctes(integer) OWNER TO sanjor;

--
-- Name: nomemp(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION nomemp(integer) RETURNS character
    LANGUAGE sql
    AS $_$select emp_nombre from empresa where emp_codigo= $1 ;$_$;


ALTER FUNCTION public.nomemp(integer) OWNER TO sanjor;

--
-- Name: nomiva(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION nomiva(integer) RETURNS character
    LANGUAGE sql
    AS $_$select iva_nombre from coniva where iva_codigo= $1 ;$_$;


ALTER FUNCTION public.nomiva(integer) OWNER TO sanjor;

--
-- Name: nomprov(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION nomprov(integer) RETURNS character
    LANGUAGE sql
    AS $_$select pro_nombre from provin where pro_codigo= $1 ;$_$;


ALTER FUNCTION public.nomprov(integer) OWNER TO sanjor;

--
-- Name: nomprove(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION nomprove(integer) RETURNS character
    LANGUAGE sql
    AS $_$select prov_nombre from prove where prov_id= $1 ;$_$;


ALTER FUNCTION public.nomprove(integer) OWNER TO sanjor;

--
-- Name: nomtipcta(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION nomtipcta(integer) RETURNS character varying
    LANGUAGE sql
    AS $_$select tct_nombre from tipcta where tct_codigo = $1;$_$;


ALTER FUNCTION public.nomtipcta(integer) OWNER TO sanjor;

--
-- Name: nrotalon(integer, integer, character varying, integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION nrotalon(integer, integer, character varying, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	comproba	ALIAS FOR $3; 
	modo		ALIAS FOR $4; -- 1:graba  2:consulta
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN
    talonario:=0;
    select comp_talon into talonario from comprob where int4eq(ptovta,comp_idptov) and bpchareq(comproba,comp_codigo);
    if not found then
	select comp_talon into talonario from comprob where int4eq(codemp,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	if not found then
	    select comp_talon into talonario from comprob where int4eq(0,comp_codemp) and int4eq(0,comp_idptov) and bpchareq(comproba,comp_codigo);
	end if;
    end if;

    if int4ne(talonario,0) then
	select tal_valor into retval from talon where int4eq(talonario,tal_id);
	if int4eq(modo,1) then
	    update talon set tal_valor=tal_valor+1 where int4eq(talonario,tal_id);
	end if;
    end if;
RETURN retval;
END;$_$;


ALTER FUNCTION public.nrotalon(integer, integer, character varying, integer) OWNER TO sanjor;

--
-- Name: numtalon(integer, integer, integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION numtalon(integer, integer, integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	ptovta		ALIAS FOR $1; 
	comproba	ALIAS FOR $2; 
	modo		ALIAS FOR $3; -- 1:graba  2:consulta
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN

    select comp_talon into talonario from
    	 comprob where int4eq(comproba,comp_id);

    select tal_valor into retval from
    	 talon where int4eq(talonario,tal_id);

    if found then
	if int4eq(modo,1) then
	    update talon set tal_valor=tal_valor+1 where int4eq(talonario,tal_id);
	end if;		
    end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.numtalon(integer, integer, integer) OWNER TO sanjor;

--
-- Name: proxcodprov(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION proxcodprov(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select max(prov_codigo)+1 from prove where prov_codemp= $1 ;$_$;


ALTER FUNCTION public.proxcodprov(integer) OWNER TO sanjor;

--
-- Name: proxnumptv(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION proxnumptv(integer, integer, character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
DECLARE
	codemp		ALIAS FOR $1; 
	ptovta		ALIAS FOR $2; 
	comproba	ALIAS FOR $3; 
	otro 		integer;
	talonario	integer;
	retval 		integer;
    BEGIN
	if int4ne(ptovta,0) then
	    select idcomp(codemp,ptovta,comproba) into otro;
	    select max(ash_numptv)+1 into retval from astoh where int4eq(codemp,ash_codemp) and int4eq(ptovta,ash_idptov) and int4eq(otro,ash_comprob);
	  else
	    retval:= -100;
	end if;
	if(retval is null) then
	retval:= 1;
	end if;
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.proxnumptv(integer, integer, character varying) OWNER TO sanjor;

--
-- Name: ptovdefault(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION ptovdefault(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select ptv_id from ptovta where ptv_codemp= $1 order by ptv_id limit 1;$_$;


ALTER FUNCTION public.ptovdefault(integer) OWNER TO sanjor;

--
-- Name: ptovemp(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION ptovemp(integer) RETURNS integer
    LANGUAGE plpgsql
    AS $_$
    DECLARE
	empresa		ALIAS FOR $1; 
	retval 		integer;
	cuantos		integer;
    BEGIN
    select count(*) into cuantos from
    	 ptovta where int4eq(empresa,ptv_codemp);

	 if int4eq(cuantos,1) then
		select ptv_id into retval from
    		ptovta where int4eq(empresa,ptv_codemp);
	    else
		retval:=-1;
	 end if;		
    RETURN retval;
    END;$_$;


ALTER FUNCTION public.ptovemp(integer) OWNER TO sanjor;

--
-- Name: tipctacbl(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION tipctacbl(integer) RETURNS integer
    LANGUAGE sql
    AS $_$select cbl_tipcta from ctacble where cbl_id= $1 ;$_$;


ALTER FUNCTION public.tipctacbl(integer) OWNER TO sanjor;

--
-- Name: titastoh(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION titastoh(integer) RETURNS character
    LANGUAGE sql
    AS $_$select ash_titulo from astoh where ash_id= $1 ;$_$;


ALTER FUNCTION public.titastoh(integer) OWNER TO sanjor;

--
-- Name: totenchq(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION totenchq(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select sum(chq_importe)::numeric(15,2) 
    from cheques where chq_idastoc= $1 ;$_$;


ALTER FUNCTION public.totenchq(integer) OWNER TO sanjor;

--
-- Name: ult_cotiz(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION ult_cotiz(integer) RETURNS numeric
    LANGUAGE sql
    AS $_$select cot_cotiz  from cotiza where cot_moneda = $1  order by cot_fecha desc limit 1;$_$;


ALTER FUNCTION public.ult_cotiz(integer) OWNER TO sanjor;

--
-- Name: ultcie(integer); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION ultcie(integer) RETURNS date
    LANGUAGE sql
    AS $_$select l_feccie from liquidacion where l_estado=1 and l_centro= $1 order by 1 desc limit 1;$_$;


ALTER FUNCTION public.ultcie(integer) OWNER TO sanjor;

--
-- Name: valvaramb(integer, integer, character varying); Type: FUNCTION; Schema: public; Owner: sanjor
--

CREATE FUNCTION valvaramb(integer, integer, character varying) RETURNS character
    LANGUAGE plpgsql
    AS $_$
DECLARE
    codemp		ALIAS FOR $1; 
    ptovta		ALIAS FOR $2; 
    codigo		ALIAS FOR $3; 
    retval 		varchar;
    BEGIN

    select vari_valor into retval from varambi where int4eq(ptovta,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
    if not found then
	select vari_valor into retval from varambi where int4eq(0,vari_idptov) and int4eq(codemp,vari_codemp) and bpchareq(codigo,vari_codigo);
	if not found then
	    select vari_valor into retval from varambi where int4eq(0,vari_idptov) and int4eq(0,vari_codemp) and bpchareq(codigo,vari_codigo);
	end if;
    end if;

RETURN retval;
END;$_$;


ALTER FUNCTION public.valvaramb(integer, integer, character varying) OWNER TO sanjor;

SET default_tablespace = '';

SET default_with_oids = true;

--
-- Name: articvta; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE articvta (
    art_id integer NOT NULL,
    art_codigo smallint,
    art_tasa numeric(15,5) DEFAULT 0.21,
    art_stock numeric(15,5),
    art_nivrep numeric(15,5),
    art_unimed smallint,
    art_present numeric(15,5),
    art_peso numeric(15,5),
    art_estado smallint DEFAULT 1,
    art_codrub smallint,
    art_automatoper character varying(100),
    art_tipoper integer,
    art_idptov integer DEFAULT 0 NOT NULL,
    art_precio_unique numeric(15,5),
    art_codemp integer DEFAULT 0 NOT NULL,
    art_codi character varying(20),
    art_nombre character varying(140),
    art_leyen text,
    art_siste smallint DEFAULT 1,
    art_tipo smallint DEFAULT 1,
    art_codsrb integer,
    art_codcbl integer,
    art_funcion text,
    art_precio numeric(15,5) DEFAULT 0,
    art_idcbl integer
);


ALTER TABLE public.articvta OWNER TO sanjor;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE articvta_art_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.articvta_art_id_seq OWNER TO sanjor;

--
-- Name: articvta_art_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE articvta_art_id_seq OWNED BY articvta.art_id;


--
-- Name: astoctas; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE astoctas (
    astc_id integer NOT NULL,
    astc_idastoh integer NOT NULL,
    astc_codemp integer NOT NULL,
    astc_idptov integer NOT NULL,
    astc_division integer,
    astc_centro integer,
    astc_comprob integer NOT NULL,
    astc_numero integer NOT NULL,
    astc_fecval date NOT NULL,
    astc_ctacble integer NOT NULL,
    astc_moneda smallint DEFAULT 1 NOT NULL,
    astc_valor numeric(15,2) DEFAULT 0,
    astc_cotiza numeric(15,5) DEFAULT 0,
    astc_importe numeric(15,2) DEFAULT 0 NOT NULL,
    astc_tipcta integer,
    astc_ctacte integer,
    astc_nucheq integer DEFAULT 0,
    astc_fecvto date,
    astc_estado smallint DEFAULT 1 NOT NULL,
    astc_cierra smallint DEFAULT 1 NOT NULL,
    astc_grupo integer DEFAULT 1 NOT NULL,
    astc_tasa numeric(15,5),
    astc_leyen character varying(100),
    astc_idashce integer
);


ALTER TABLE public.astoctas OWNER TO sanjor;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE astoctas_astc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.astoctas_astc_id_seq OWNER TO sanjor;

--
-- Name: astoctas_astc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE astoctas_astc_id_seq OWNED BY astoctas.astc_id;


--
-- Name: astoh; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE astoh (
    ash_id integer NOT NULL,
    ash_codemp integer NOT NULL,
    ash_idptov integer NOT NULL,
    ash_division integer,
    ash_centro integer,
    ash_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    ash_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    ash_comprob integer NOT NULL,
    ash_numero integer,
    ash_numptv integer,
    ash_fecomp date NOT NULL,
    ash_fecval date,
    ash_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    ash_estado smallint DEFAULT 1,
    ash_idcpra integer,
    ash_idemiti integer,
    ash_leyen text,
    ash_operad integer,
    ash_date date,
    ash_titulo character varying(200),
    ash_idasoc integer,
    ash_pseudogrupo integer
);


ALTER TABLE public.astoh OWNER TO sanjor;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE astoh_ash_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.astoh_ash_id_seq OWNER TO sanjor;

--
-- Name: astoh_ash_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE astoh_ash_id_seq OWNED BY astoh.ash_id;


--
-- Name: auxint; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE auxint (
    ai_id integer NOT NULL,
    ai_idliq integer NOT NULL,
    ai_idcopr integer NOT NULL,
    ai_impgi numeric(15,2) DEFAULT 0,
    ai_impngi numeric(15,2) DEFAULT 0,
    ai_intacu numeric(15,2) DEFAULT 0
);


ALTER TABLE public.auxint OWNER TO sanjor;

--
-- Name: auxint_ai_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE auxint_ai_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.auxint_ai_id_seq OWNER TO sanjor;

--
-- Name: auxint_ai_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE auxint_ai_id_seq OWNED BY auxint.ai_id;


--
-- Name: bancos; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE bancos (
    bco_codigo smallint NOT NULL,
    bco_nombre character varying(140) NOT NULL,
    bco_estado smallint DEFAULT 1
);


ALTER TABLE public.bancos OWNER TO sanjor;

--
-- Name: cambtitu; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE cambtitu (
    cbt_id integer NOT NULL,
    cbt_codemp integer NOT NULL,
    cbt_idptov integer NOT NULL,
    cbt_division integer,
    cbt_centro integer,
    cbt_unifun integer,
    cbt_idcopr integer NOT NULL,
    cbt_nombre character varying(240) NOT NULL,
    cbt_direcc character varying(240),
    cbt_locali character varying(240),
    cbt_codpos character varying(10),
    cbt_provin integer,
    cbt_telefono character varying(20),
    cbt_mail character varying(20),
    cbt_fecha date DEFAULT date(now()),
    cbt_tipdoc character varying(10),
    cbt_nrodoc integer,
    cbt_nrcuit character varying(20),
    cbt_leyen text,
    cbt_operador integer
);


ALTER TABLE public.cambtitu OWNER TO sanjor;

--
-- Name: cambtitu_cbt_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE cambtitu_cbt_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.cambtitu_cbt_id_seq OWNER TO sanjor;

--
-- Name: cambtitu_cbt_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE cambtitu_cbt_id_seq OWNED BY cambtitu.cbt_id;


--
-- Name: cargos; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE cargos (
    car_id integer NOT NULL,
    car_codemp integer DEFAULT 0 NOT NULL,
    car_idptov integer,
    car_division integer,
    car_centro integer,
    car_codigo integer,
    car_nombre character varying(340),
    car_rubcar integer,
    car_srubcar integer,
    car_genint integer DEFAULT 1 NOT NULL,
    car_interes numeric(15,5) DEFAULT 1,
    car_precio numeric(15,5) DEFAULT 0,
    car_tasa numeric(15,5) DEFAULT 0,
    car_estado integer DEFAULT 1,
    car_funcion text,
    car_leyen text
);


ALTER TABLE public.cargos OWNER TO sanjor;

--
-- Name: cargos_car_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE cargos_car_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.cargos_car_id_seq OWNER TO sanjor;

--
-- Name: cargos_car_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE cargos_car_id_seq OWNED BY cargos.car_id;


--
-- Name: catego; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE catego (
    cat_codigo integer NOT NULL,
    cat_nombre character varying(140) NOT NULL
);


ALTER TABLE public.catego OWNER TO sanjor;

--
-- Name: centroc; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE centroc (
    cco_id integer NOT NULL,
    cco_codemp integer NOT NULL,
    cco_idptov integer NOT NULL,
    cco_coddiv integer,
    cco_codigo smallint NOT NULL,
    cco_nombre character varying(140)
);


ALTER TABLE public.centroc OWNER TO sanjor;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE centroc_cco_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.centroc_cco_id_seq OWNER TO sanjor;

--
-- Name: centroc_cco_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE centroc_cco_id_seq OWNED BY centroc.cco_id;


--
-- Name: cheques; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE cheques (
    chq_id integer NOT NULL,
    chq_codbco smallint NOT NULL,
    chq_nucheq integer NOT NULL,
    chq_codemp integer NOT NULL,
    chq_idptov integer DEFAULT 0 NOT NULL,
    chq_idastoc integer NOT NULL,
    chq_fechaem date,
    chq_fecheq date NOT NULL,
    chq_moneda smallint DEFAULT 1 NOT NULL,
    chq_importe numeric(15,2) DEFAULT 0 NOT NULL,
    chq_estado smallint DEFAULT 1 NOT NULL,
    chq_nrcuit character varying(20),
    chq_ctacte integer,
    chq_idastoce integer,
    chq_observ text
);


ALTER TABLE public.cheques OWNER TO sanjor;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE cheques_chq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.cheques_chq_id_seq OWNER TO sanjor;

--
-- Name: cheques_chq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE cheques_chq_id_seq OWNED BY cheques.chq_id;


--
-- Name: chqrech; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE chqrech (
    chqr_id integer NOT NULL,
    chqr_cliente integer DEFAULT 1,
    chqr_idchq integer,
    chqr_idastoh integer,
    chqr_idastohc integer,
    chqr_texto text,
    chqr_estado smallint DEFAULT 1
);


ALTER TABLE public.chqrech OWNER TO sanjor;

--
-- Name: chqrech_chqr_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE chqrech_chqr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.chqrech_chqr_id_seq OWNER TO sanjor;

--
-- Name: chqrech_chqr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE chqrech_chqr_id_seq OWNED BY chqrech.chqr_id;


--
-- Name: compliq; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE compliq (
    clq_id integer NOT NULL,
    clq_codemp integer NOT NULL,
    clq_idptov integer NOT NULL,
    clq_division integer,
    clq_centro integer,
    clq_idcopr integer NOT NULL,
    clq_fecha date DEFAULT date(now()),
    clq_fecvto date DEFAULT date(now()),
    clq_anio integer DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    clq_mes integer DEFAULT date_part('month'::text, date(now())) NOT NULL,
    clq_comprob integer,
    clq_numero integer,
    clq_idliq integer,
    clq_rubcar integer NOT NULL,
    clq_cargo integer NOT NULL,
    clq_canti numeric(15,5) DEFAULT 1,
    clq_precio numeric(15,5) DEFAULT 0,
    clq_importe numeric(15,2) DEFAULT 0,
    clq_interes numeric(15,5) DEFAULT 1,
    clq_estado integer DEFAULT 1,
    clq_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    clq_operad integer,
    clq_leyen text,
    clq_pseudogrupo integer,
    clq_srubcar integer NOT NULL
);


ALTER TABLE public.compliq OWNER TO sanjor;

--
-- Name: compliq_clq_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE compliq_clq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.compliq_clq_id_seq OWNER TO sanjor;

--
-- Name: compliq_clq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE compliq_clq_id_seq OWNED BY compliq.clq_id;


--
-- Name: compliquid; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE compliquid (
    cl_id integer NOT NULL,
    cl_idliq integer NOT NULL,
    cl_rubcar integer,
    cl_cargo integer,
    cl_porc integer DEFAULT 1 NOT NULL,
    cl_leyen character varying(240),
    cl_importe numeric(15,2) DEFAULT 0,
    cl_estado integer DEFAULT 1 NOT NULL
);


ALTER TABLE public.compliquid OWNER TO sanjor;

--
-- Name: compliquid_cl_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE compliquid_cl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.compliquid_cl_id_seq OWNER TO sanjor;

--
-- Name: compliquid_cl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE compliquid_cl_id_seq OWNED BY compliquid.cl_id;


--
-- Name: compra; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE compra (
    cpra_id integer NOT NULL,
    cpra_idastoh integer NOT NULL,
    cpra_codemp integer NOT NULL,
    cpra_idptov integer DEFAULT 0 NOT NULL,
    cpra_comprob integer NOT NULL,
    cpra_numero integer NOT NULL,
    cpra_prove integer,
    cpra_lecomp character varying(2),
    cpra_sucomp smallint,
    cpra_nucomp integer,
    cpra_fecori date,
    cpra_fecval date,
    cpra_fecvto date,
    cpra_estado smallint DEFAULT 1 NOT NULL,
    cpra_nomprov character varying(140),
    cpra_nrcuit character varying(20),
    cpra_coniva smallint,
    cpra_total numeric(15,2) DEFAULT 0
);


ALTER TABLE public.compra OWNER TO sanjor;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE compra_cpra_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.compra_cpra_id_seq OWNER TO sanjor;

--
-- Name: compra_cpra_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE compra_cpra_id_seq OWNED BY compra.cpra_id;


--
-- Name: comprob; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE comprob (
    comp_id integer NOT NULL,
    comp_codigo character(3) NOT NULL,
    comp_nombre character varying(140) NOT NULL,
    comp_codemp integer DEFAULT 0 NOT NULL,
    comp_idptov integer DEFAULT 0 NOT NULL,
    comp_sistem smallint DEFAULT 1,
    comp_siste smallint DEFAULT 4,
    comp_credeb smallint DEFAULT 1,
    comp_stcksn smallint DEFAULT 1,
    comp_tipo smallint DEFAULT 1,
    comp_intext smallint DEFAULT 1,
    comp_cuenta integer,
    comp_talon integer,
    comp_copias integer,
    comp_letra character varying(3),
    comp_leyen text
);


ALTER TABLE public.comprob OWNER TO sanjor;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE comprob_comp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.comprob_comp_id_seq OWNER TO sanjor;

--
-- Name: comprob_comp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE comprob_comp_id_seq OWNED BY comprob.comp_id;


--
-- Name: comprop; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE comprop (
    cmpr_id integer NOT NULL,
    cmpr_codemp integer NOT NULL,
    cmpr_idptov integer NOT NULL,
    cmpr_division integer,
    cmpr_centro integer,
    cmpr_idcopr integer NOT NULL,
    cmpr_rubcar integer NOT NULL,
    cmpr_cargo integer NOT NULL,
    cmpr_canti numeric(15,5) DEFAULT 1,
    cmpr_precio numeric(15,5) DEFAULT 0,
    cmpr_importe numeric(15,2) DEFAULT 0,
    cmpr_estado integer DEFAULT 1,
    cmpr_fecalt date DEFAULT date(now()) NOT NULL,
    cmpr_fecbaj date,
    clq_leyen text,
    cmpr_srubcar integer NOT NULL
);


ALTER TABLE public.comprop OWNER TO sanjor;

--
-- Name: comprop_cmpr_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE comprop_cmpr_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.comprop_cmpr_id_seq OWNER TO sanjor;

--
-- Name: comprop_cmpr_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE comprop_cmpr_id_seq OWNED BY comprop.cmpr_id;


--
-- Name: coniva; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE coniva (
    iva_codigo smallint NOT NULL,
    iva_nombre character varying(140) NOT NULL,
    iva_tasa numeric(15,5),
    iva_stasa numeric(15,5),
    iva_discrim smallint DEFAULT 1
);


ALTER TABLE public.coniva OWNER TO sanjor;

--
-- Name: conpag; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE conpag (
    cdp_codigo integer NOT NULL,
    cdp_nombre character varying(140) NOT NULL,
    cdp_dias smallint
);


ALTER TABLE public.conpag OWNER TO sanjor;

--
-- Name: convenios; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE convenios (
    con_id integer NOT NULL,
    con_codemp integer DEFAULT 0 NOT NULL,
    con_idptov integer NOT NULL,
    con_division integer NOT NULL,
    con_centro integer NOT NULL,
    con_idcopr integer NOT NULL,
    con_comprob integer NOT NULL,
    con_numero integer,
    con_monto numeric(15,5) DEFAULT 0,
    con_fechai date DEFAULT date(now()),
    con_fechaf date DEFAULT date(now()),
    con_cuotas integer DEFAULT 1,
    con_operador integer,
    con_leyen text
);


ALTER TABLE public.convenios OWNER TO sanjor;

--
-- Name: convenios_con_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE convenios_con_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.convenios_con_id_seq OWNER TO sanjor;

--
-- Name: convenios_con_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE convenios_con_id_seq OWNED BY convenios.con_id;


--
-- Name: coprop; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE coprop (
    cop_id integer NOT NULL,
    cop_codemp integer NOT NULL,
    cop_idptov integer NOT NULL,
    cop_unifun integer NOT NULL,
    cop_nombre character varying(140),
    cop_codaso integer,
    cop_porc1 numeric(15,6),
    cop_porc2 numeric(15,6),
    cop_porc3 numeric(15,6),
    cop_porc4 numeric(15,6),
    cop_porc5 numeric(15,6),
    cop_direcc character varying(160),
    cop_locali character varying(160),
    cop_codpos character varying(10),
    cop_provin integer,
    cop_descuf character varying(160),
    cop_tipuf integer,
    cop_coniva integer,
    cop_nrcuit character varying(20),
    cop_tipdoc character varying(10),
    cop_nrodoc integer,
    cop_grupo integer DEFAULT 1,
    cop_estado integer DEFAULT 1 NOT NULL,
    cop_mail integer DEFAULT 1,
    cop_inter numeric(15,5) DEFAULT 0,
    cop_recib integer DEFAULT 1,
    cop_centro integer,
    cop_division integer,
    cop_supert numeric(15,5) DEFAULT 0,
    cop_superc numeric(15,5) DEFAULT 0,
    cop_supersc numeric(15,5) DEFAULT 0
);


ALTER TABLE public.coprop OWNER TO sanjor;

--
-- Name: coprop_cop_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE coprop_cop_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.coprop_cop_id_seq OWNER TO sanjor;

--
-- Name: coprop_cop_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE coprop_cop_id_seq OWNED BY coprop.cop_id;


--
-- Name: cotiza; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE cotiza (
    cot_moneda smallint NOT NULL,
    cot_fecha date NOT NULL,
    cot_cotiz numeric(15,6) DEFAULT 1 NOT NULL
);


ALTER TABLE public.cotiza OWNER TO sanjor;

--
-- Name: ctacble; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE ctacble (
    cbl_id integer NOT NULL,
    cbl_codemp integer DEFAULT 0 NOT NULL,
    cbl_idptov integer DEFAULT 0 NOT NULL,
    cbl_divis integer,
    cbl_centro integer,
    cbl_codigo smallint NOT NULL,
    cbl_nombre character varying(140) NOT NULL,
    cbl_moneda smallint NOT NULL,
    cbl_tipcta integer,
    cbl_ajuste smallint DEFAULT 1 NOT NULL,
    cbl_indice smallint,
    cbl_present character varying(100)
);


ALTER TABLE public.ctacble OWNER TO sanjor;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE ctacble_cbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ctacble_cbl_id_seq OWNER TO sanjor;

--
-- Name: ctacble_cbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE ctacble_cbl_id_seq OWNED BY ctacble.cbl_id;


--
-- Name: ctasconv; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE ctasconv (
    ctc_id integer NOT NULL,
    ctc_idconv integer NOT NULL,
    ctc_cuota integer DEFAULT 1,
    ctc_fecha date DEFAULT date(now()),
    ctc_importe numeric(15,5) DEFAULT 0,
    ctc_leyen text
);


ALTER TABLE public.ctasconv OWNER TO sanjor;

--
-- Name: ctasconv_ctc_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE ctasconv_ctc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ctasconv_ctc_id_seq OWNER TO sanjor;

--
-- Name: ctasconv_ctc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE ctasconv_ctc_id_seq OWNED BY ctasconv.ctc_id;


--
-- Name: ctes; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE ctes (
    cte_id integer NOT NULL,
    cte_codemp integer DEFAULT 0 NOT NULL,
    cte_idptov integer DEFAULT 0 NOT NULL,
    cte_centro integer DEFAULT 0,
    cte_tipcta integer NOT NULL,
    cte_tipct smallint,
    cte_codigo integer NOT NULL,
    cte_nombre character varying(140),
    cte_idtal integer,
    cte_estado smallint DEFAULT 1,
    cte_idtabla integer
);


ALTER TABLE public.ctes OWNER TO sanjor;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE ctes_cte_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ctes_cte_id_seq OWNER TO sanjor;

--
-- Name: ctes_cte_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE ctes_cte_id_seq OWNED BY ctes.cte_id;


--
-- Name: division; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE division (
    div_id integer NOT NULL,
    div_codemp integer NOT NULL,
    div_idptov integer NOT NULL,
    div_codigo smallint NOT NULL,
    div_nombre character varying(140)
);


ALTER TABLE public.division OWNER TO sanjor;

--
-- Name: division_div_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE division_div_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.division_div_id_seq OWNER TO sanjor;

--
-- Name: division_div_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE division_div_id_seq OWNED BY division.div_id;


--
-- Name: docum; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE docum (
    doc_id integer NOT NULL,
    doc_codemp integer DEFAULT 0 NOT NULL,
    doc_idptov integer DEFAULT 0 NOT NULL,
    doc_idastoc integer NOT NULL,
    doc_numero integer NOT NULL,
    doc_fechaem date,
    doc_fecdoc date NOT NULL,
    doc_moneda smallint DEFAULT 1 NOT NULL,
    doc_importe numeric(15,2) DEFAULT 0 NOT NULL,
    doc_estado smallint DEFAULT 1 NOT NULL,
    doc_nrcuit character varying(20),
    doc_ctacte integer,
    doc_idastoce integer,
    doc_observ text
);


ALTER TABLE public.docum OWNER TO sanjor;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE docum_doc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.docum_doc_id_seq OWNER TO sanjor;

--
-- Name: docum_doc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE docum_doc_id_seq OWNED BY docum.doc_id;


--
-- Name: emiti; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE emiti (
    emi_id integer NOT NULL,
    emi_idastoh integer NOT NULL,
    emi_codemp integer NOT NULL,
    emi_idptov integer,
    emi_comprob integer NOT NULL,
    emi_numero integer NOT NULL,
    emi_fecval date,
    emi_grupo integer,
    emi_conpag integer,
    emi_codcop integer,
    emi_succli integer,
    emi_nomcli character varying(140),
    emi_conivac smallint,
    emi_nrocuit character varying(20),
    emi_vended integer,
    emi_provin integer,
    emi_zona integer,
    emi_desre numeric(15,2) DEFAULT 0,
    emi_total numeric(15,2) DEFAULT 0,
    emi_retiro integer,
    emi_estado smallint DEFAULT 1,
    emi_leyen text
);


ALTER TABLE public.emiti OWNER TO sanjor;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE emiti_emi_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.emiti_emi_id_seq OWNER TO sanjor;

--
-- Name: emiti_emi_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE emiti_emi_id_seq OWNED BY emiti.emi_id;


--
-- Name: empresa; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE empresa (
    emp_codigo integer NOT NULL,
    emp_nombre character varying(140) NOT NULL,
    emp_direcc character varying(160),
    emp_locali character varying(160),
    emp_codpos character varying(10),
    emp_provin integer DEFAULT 1,
    emp_pais smallint DEFAULT 200,
    emp_nrcuit character varying(20),
    emp_estado smallint DEFAULT 1,
    emp_tipo smallint DEFAULT 1,
    emp_coniva smallint DEFAULT 1,
    emp_anti date DEFAULT date(now()),
    emp_fecint date,
    emp_grupo integer DEFAULT 1,
    emp_redond smallint DEFAULT 1,
    emp_nomabr character varying(70)
);


ALTER TABLE public.empresa OWNER TO sanjor;

--
-- Name: entidad; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE entidad (
    ent_id integer NOT NULL,
    ent_niv1 smallint DEFAULT 0 NOT NULL,
    ent_niv2 smallint DEFAULT 0 NOT NULL,
    ent_niv3 smallint DEFAULT 0 NOT NULL,
    ent_niv4 smallint DEFAULT 0 NOT NULL,
    ent_niv5 smallint DEFAULT 0 NOT NULL,
    ent_nombre character varying(140)
);


ALTER TABLE public.entidad OWNER TO sanjor;

--
-- Name: entidad_ent_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE entidad_ent_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.entidad_ent_id_seq OWNER TO sanjor;

--
-- Name: entidad_ent_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE entidad_ent_id_seq OWNED BY entidad.ent_id;


--
-- Name: esclisp; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE esclisp (
    elp_idart integer NOT NULL,
    elp_orden smallint DEFAULT 1 NOT NULL,
    elp_nombre character varying(140) DEFAULT '1'::character varying,
    elp_precio numeric(15,2) NOT NULL
);


ALTER TABLE public.esclisp OWNER TO sanjor;

--
-- Name: estjud; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE estjud (
    etj_codigo integer NOT NULL,
    etj_nombre character varying(240) NOT NULL
);


ALTER TABLE public.estjud OWNER TO sanjor;

--
-- Name: estjurid; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE estjurid (
    est_codigo integer NOT NULL,
    est_nombre character varying(240) NOT NULL
);


ALTER TABLE public.estjurid OWNER TO sanjor;

--
-- Name: factpend; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE factpend (
    fap_id integer NOT NULL,
    fap_codemp integer DEFAULT 0 NOT NULL,
    fap_idptov integer DEFAULT 0 NOT NULL,
    fap_division integer DEFAULT 0 NOT NULL,
    fap_centro integer DEFAULT 0 NOT NULL,
    fap_rubro integer NOT NULL,
    fap_subrub integer NOT NULL,
    fap_lecomp character varying(30),
    fap_sucomp integer,
    fap_nucomp integer,
    fap_hayfac integer DEFAULT 1,
    fap_factur character varying(100),
    fap_prove integer,
    fap_nprove character varying(100),
    fap_cuitprov character varying(20),
    fap_coniva integer,
    fap_importe numeric(15,2) DEFAULT 0,
    fap_impag numeric(15,2) DEFAULT 0,
    fap_fecori date,
    fap_fecval date NOT NULL,
    fap_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    fap_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    fap_vencim date,
    fap_proxv date,
    fap_leyen text,
    fap_estado integer DEFAULT 1,
    fap_idgto integer,
    fap_operador integer,
    fap_fecreg timestamp without time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.factpend OWNER TO sanjor;

--
-- Name: factpend_fap_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE factpend_fap_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.factpend_fap_id_seq OWNER TO sanjor;

--
-- Name: factpend_fap_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE factpend_fap_id_seq OWNED BY factpend.fap_id;


--
-- Name: firman; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE firman (
    fir_id integer NOT NULL,
    fir_nrcuit character varying(20) NOT NULL,
    fir_nombre character varying(140) NOT NULL,
    fir_direcc character varying(160),
    fir_locali character varying(160),
    fir_codpos character varying(10),
    fir_provin integer,
    fir_pais smallint,
    fir_estado smallint DEFAULT 1,
    fir_observ text
);


ALTER TABLE public.firman OWNER TO sanjor;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE firman_fir_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.firman_fir_id_seq OWNER TO sanjor;

--
-- Name: firman_fir_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE firman_fir_id_seq OWNED BY firman.fir_id;


--
-- Name: gastos; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE gastos (
    gto_id integer NOT NULL,
    gto_idastoh integer NOT NULL,
    gto_codemp integer DEFAULT 0 NOT NULL,
    gto_idptov integer DEFAULT 0 NOT NULL,
    gto_comprob integer NOT NULL,
    gto_numero integer,
    gto_centro integer DEFAULT 0 NOT NULL,
    gto_rubro integer NOT NULL,
    gto_subrub integer NOT NULL,
    gto_lecomp character varying(30),
    gto_sucomp integer,
    gto_nucomp integer,
    gto_fecori date,
    gto_fecval date NOT NULL,
    gto_hayfac integer DEFAULT 1,
    gto_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    gto_prove integer,
    gto_nprove character varying(100),
    gto_cuitprov character varying(20),
    gto_coniva integer,
    gto_factur character varying(100),
    gto_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    gto_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    gto_estado integer DEFAULT 1,
    gto_impag numeric(15,2) DEFAULT 0,
    gto_importe numeric(15,2) DEFAULT 0,
    gto_operador integer,
    gto_proxv date,
    gto_leyen text,
    gto_division integer NOT NULL
);


ALTER TABLE public.gastos OWNER TO sanjor;

--
-- Name: gastos_gto_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE gastos_gto_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.gastos_gto_id_seq OWNER TO sanjor;

--
-- Name: gastos_gto_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE gastos_gto_id_seq OWNED BY gastos.gto_id;


--
-- Name: grupos; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE grupos (
    gpo_id integer NOT NULL,
    gpo_nombre character varying(140) NOT NULL
);


ALTER TABLE public.grupos OWNER TO sanjor;

--
-- Name: gtoxliqe; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE gtoxliqe (
    gxl_liqegr integer NOT NULL,
    gxl_gasto integer NOT NULL,
    gxl_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    gxl_operador integer,
    eg_leyena text,
    eg_leyen text
);


ALTER TABLE public.gtoxliqe OWNER TO sanjor;

--
-- Name: honorarios; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE honorarios (
    hon_id integer NOT NULL,
    hon_codemp integer DEFAULT 1 NOT NULL,
    hon_idptov integer DEFAULT 0 NOT NULL,
    hon_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    hon_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    hon_rubro integer,
    hon_subrub integer,
    hon_centroc integer DEFAULT 1 NOT NULL,
    hon_importe numeric(15,5) DEFAULT 0,
    hon_estado integer DEFAULT 1,
    hon_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    hon_fecgrab timestamp without time zone,
    hon_comprob integer,
    hon_sucu integer,
    hon_ccadm integer NOT NULL,
    hon_division integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.honorarios OWNER TO sanjor;

--
-- Name: honorarios_hon_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE honorarios_hon_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.honorarios_hon_id_seq OWNER TO sanjor;

--
-- Name: honorarios_hon_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE honorarios_hon_id_seq OWNED BY honorarios.hon_id;


--
-- Name: impresiones; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE impresiones (
    imp_codigo smallint NOT NULL,
    imp_name text,
    imp_query text,
    imp_enscript text,
    imp_filter text,
    imp_shell text
);


ALTER TABLE public.impresiones OWNER TO sanjor;

--
-- Name: interes; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE interes (
    int_codemp integer DEFAULT 0 NOT NULL,
    int_idptov integer DEFAULT 0 NOT NULL,
    int_centro integer,
    int_division integer,
    int_fecha date NOT NULL,
    int_valor numeric(15,5) DEFAULT 0
);


ALTER TABLE public.interes OWNER TO sanjor;

--
-- Name: judicial; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE judicial (
    jud_id integer NOT NULL,
    jud_codemp integer NOT NULL,
    jud_idptov integer NOT NULL,
    jud_division integer,
    jud_centro integer,
    jud_idcopr integer NOT NULL,
    jud_ejcod integer,
    jud_fecha date DEFAULT date(now()),
    jud_deuda numeric(15,2) DEFAULT 0,
    jud_gasto numeric(15,2) DEFAULT 0,
    jud_reintg integer DEFAULT 1,
    jud_estado integer DEFAULT 1,
    jud_estudio integer,
    jud_leyen text,
    jud_operador integer
);


ALTER TABLE public.judicial OWNER TO sanjor;

--
-- Name: judicial_jud_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE judicial_jud_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.judicial_jud_id_seq OWNER TO sanjor;

--
-- Name: judicial_jud_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE judicial_jud_id_seq OWNED BY judicial.jud_id;


--
-- Name: liqegr; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE liqegr (
    eg_id integer NOT NULL,
    eg_idastoh integer NOT NULL,
    eg_codemp integer DEFAULT 0 NOT NULL,
    eg_idptov integer DEFAULT 0 NOT NULL,
    eg_centro integer DEFAULT 0 NOT NULL,
    eg_rubro integer NOT NULL,
    eg_subrub integer NOT NULL,
    eg_hayfac integer DEFAULT 1,
    eg_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    eg_prove integer,
    eg_nprove character varying(100),
    eg_cuitprov character varying(20),
    eg_factur character varying(100),
    eg_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    eg_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    eg_estado integer DEFAULT 1,
    eg_impag numeric(15,2) DEFAULT 0,
    eg_importe numeric(15,2) DEFAULT 0,
    eg_operador integer,
    eg_leyen text,
    eg_division integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.liqegr OWNER TO sanjor;

--
-- Name: liqegr_eg_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE liqegr_eg_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.liqegr_eg_id_seq OWNER TO sanjor;

--
-- Name: liqegr_eg_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE liqegr_eg_id_seq OWNED BY liqegr.eg_id;


SET default_with_oids = false;

--
-- Name: liqpdf; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE liqpdf (
    lqp_id integer NOT NULL,
    lqp_codemp integer NOT NULL,
    lqp_idptov integer DEFAULT 0 NOT NULL,
    lqp_anio integer,
    lqp_mes integer,
    lqp_tipo integer,
    lqp_nombre character varying(140),
    lqp_observ character varying(140)
);


ALTER TABLE public.liqpdf OWNER TO sanjor;

--
-- Name: liqpdf_lqp_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE liqpdf_lqp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.liqpdf_lqp_id_seq OWNER TO sanjor;

--
-- Name: liqpdf_lqp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE liqpdf_lqp_id_seq OWNED BY liqpdf.lqp_id;


SET default_with_oids = true;

--
-- Name: liqui; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE liqui (
    lq_id integer NOT NULL,
    lq_idliq integer NOT NULL,
    lq_idcopr integer NOT NULL,
    lq_rubcar integer,
    lq_cargo integer,
    lq_canti numeric(15,5) DEFAULT 1,
    lq_precio numeric(15,5) DEFAULT 1,
    lq_importe numeric(15,2) DEFAULT 0,
    lq_leyen text
);


ALTER TABLE public.liqui OWNER TO sanjor;

--
-- Name: liqui_lq_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE liqui_lq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.liqui_lq_id_seq OWNER TO sanjor;

--
-- Name: liqui_lq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE liqui_lq_id_seq OWNED BY liqui.lq_id;


--
-- Name: liquid; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE liquid (
    lq_codemp integer NOT NULL,
    lq_idptov integer DEFAULT 0 NOT NULL,
    lq_anio integer NOT NULL,
    lq_mes integer NOT NULL,
    lq_anioc integer NOT NULL,
    lq_mesc integer NOT NULL,
    lq_feccie date NOT NULL,
    lq_fecvto date NOT NULL,
    lq_ingord numeric(15,2) DEFAULT 0,
    lq_ingfon numeric(15,2) DEFAULT 0,
    lq_ingext numeric(15,2) DEFAULT 0,
    lq_ingjud numeric(15,2) DEFAULT 0,
    lq_ingotr numeric(15,2) DEFAULT 0,
    lq_ingdepsi numeric(15,2) DEFAULT 0,
    lq_egrord numeric(15,2) DEFAULT 0,
    lq_egrfon numeric(15,2) DEFAULT 0,
    lq_egrext numeric(15,2) DEFAULT 0,
    lq_egrjud numeric(15,2) DEFAULT 0,
    lq_egrotr numeric(15,2) DEFAULT 0,
    lq_caja numeric(15,2) DEFAULT 0,
    lq_cheque numeric(15,2) DEFAULT 0,
    lq_banco numeric(15,2) DEFAULT 0,
    lq_dolar numeric(15,2) DEFAULT 0,
    lq_depsi numeric(15,2) DEFAULT 0,
    lq_invers numeric(15,2) DEFAULT 0,
    lq_otros numeric(15,2) DEFAULT 0,
    lq_saldo numeric(15,2) DEFAULT 0,
    lq_salant numeric(15,2) DEFAULT 0,
    lq_ordin numeric(15,2) DEFAULT 0,
    lq_extrao numeric(15,2) DEFAULT 0,
    lq_porc1 numeric(15,2) DEFAULT 0,
    lq_porc2 numeric(15,2) DEFAULT 0,
    lq_porc3 numeric(15,2) DEFAULT 0,
    lq_porc4 numeric(15,2) DEFAULT 0,
    lq_porc5 numeric(15,2) DEFAULT 0,
    lq_prop1 numeric(15,2) DEFAULT 0,
    lq_prop2 numeric(15,2) DEFAULT 0,
    lq_prop3 numeric(15,2) DEFAULT 0,
    lq_prop4 numeric(15,2) DEFAULT 0
);


ALTER TABLE public.liquid OWNER TO sanjor;

--
-- Name: liquidacion; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE liquidacion (
    l_id integer NOT NULL,
    l_codemp integer NOT NULL,
    l_idptov integer DEFAULT 0 NOT NULL,
    l_division integer,
    l_centro integer DEFAULT 0 NOT NULL,
    l_anio integer NOT NULL,
    l_mes integer NOT NULL,
    l_perim integer NOT NULL,
    l_peria integer NOT NULL,
    l_feccie date NOT NULL,
    l_fecvto date NOT NULL,
    l_comprob integer NOT NULL,
    l_numero integer NOT NULL,
    l_estado integer DEFAULT 1 NOT NULL,
    l_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    l_operador integer NOT NULL
);


ALTER TABLE public.liquidacion OWNER TO sanjor;

--
-- Name: liquidacion_l_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE liquidacion_l_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.liquidacion_l_id_seq OWNER TO sanjor;

--
-- Name: liquidacion_l_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE liquidacion_l_id_seq OWNED BY liquidacion.l_id;


--
-- Name: listpre; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE listpre (
    ltp_id integer NOT NULL,
    ltp_idcli integer,
    ltp_idart integer NOT NULL,
    ltp_orden integer,
    ltp_precio numeric(15,5) DEFAULT 0
);


ALTER TABLE public.listpre OWNER TO sanjor;

--
-- Name: listpre_ltp_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE listpre_ltp_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.listpre_ltp_id_seq OWNER TO sanjor;

--
-- Name: listpre_ltp_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE listpre_ltp_id_seq OWNED BY listpre.ltp_id;


--
-- Name: moneda; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE moneda (
    mon_codigo smallint NOT NULL,
    mon_nombre character varying(140) NOT NULL,
    mon_simbol character varying(5)
);


ALTER TABLE public.moneda OWNER TO sanjor;

--
-- Name: monex; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE monex (
    mne_id integer NOT NULL,
    mne_idastoc integer NOT NULL,
    mne_moneda smallint NOT NULL,
    mne_numero character varying(130),
    mne_valor numeric(15,2),
    mne_estado smallint DEFAULT 1,
    mne_idastoce integer
);


ALTER TABLE public.monex OWNER TO sanjor;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE monex_mne_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.monex_mne_id_seq OWNER TO sanjor;

--
-- Name: monex_mne_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE monex_mne_id_seq OWNED BY monex.mne_id;


--
-- Name: movsto; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE movsto (
    movs_id integer NOT NULL,
    movs_idastoh integer NOT NULL,
    movs_idemiti integer NOT NULL,
    movs_codemp integer NOT NULL,
    movs_idptov integer DEFAULT 0 NOT NULL,
    movs_fecval date,
    movs_artic integer,
    movs_canti numeric(15,5) DEFAULT 0,
    movs_dias numeric(15,2) DEFAULT 0,
    movs_precio numeric(15,2) DEFAULT 0,
    movs_importe numeric(15,2) DEFAULT 0,
    movs_tasa numeric(15,5) DEFAULT 0,
    movs_peso numeric(15,2) DEFAULT 0,
    movs_volum numeric(15,2) DEFAULT 0,
    movs_entreg numeric(15,2) DEFAULT 0,
    movs_fecrep date,
    movs_estado smallint DEFAULT 1,
    movs_codcop integer,
    movs_indir integer,
    movs_clireal integer,
    movs_idoper integer,
    movs_ticket integer,
    movs_leyen text,
    movs_origen integer,
    movs_destino integer,
    movs_compbte character varying(16)
);


ALTER TABLE public.movsto OWNER TO sanjor;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE movsto_movs_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.movsto_movs_id_seq OWNER TO sanjor;

--
-- Name: movsto_movs_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE movsto_movs_id_seq OWNED BY movsto.movs_id;


--
-- Name: movstoc; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE movstoc (
    movc_id integer NOT NULL,
    movc_idastoh integer NOT NULL,
    movc_idcompra integer NOT NULL,
    movc_codemp integer NOT NULL,
    movc_idptov integer,
    movc_fecval date,
    movc_artic integer,
    movc_canti numeric(15,5) DEFAULT 0,
    movc_precio numeric(15,2) DEFAULT 0,
    movc_importe numeric(15,2) DEFAULT 0,
    movc_tasa numeric(15,5) DEFAULT 0,
    movc_peso numeric(15,2) DEFAULT 0,
    movc_volum numeric(15,2) DEFAULT 0,
    movc_entreg numeric(15,2) DEFAULT 0,
    movc_fecrep date,
    movc_estado smallint DEFAULT 1,
    movc_codpro integer,
    movc_leyen text
);


ALTER TABLE public.movstoc OWNER TO sanjor;

--
-- Name: movstoc_movc_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE movstoc_movc_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.movstoc_movc_id_seq OWNER TO sanjor;

--
-- Name: movstoc_movc_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE movstoc_movc_id_seq OWNED BY movstoc.movc_id;


--
-- Name: notdeb; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE notdeb (
    nd_id integer NOT NULL,
    nd_idasho integer NOT NULL,
    nd_codemp integer NOT NULL,
    nd_idptov integer,
    nd_fecval date,
    nd_grupo integer,
    nd_codcop integer,
    nd_estado integer DEFAULT 1,
    nd_tpago numeric(15,2) DEFAULT 0,
    nd_tnd numeric(15,2) DEFAULT 0,
    nd_interes numeric(15,2) DEFAULT 0,
    nd_operadb integer
);


ALTER TABLE public.notdeb OWNER TO sanjor;

--
-- Name: notdeb_nd_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE notdeb_nd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.notdeb_nd_id_seq OWNER TO sanjor;

--
-- Name: notdeb_nd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE notdeb_nd_id_seq OWNED BY notdeb.nd_id;


--
-- Name: noticias; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE noticias (
    not_id integer NOT NULL,
    not_codemp integer DEFAULT 1 NOT NULL,
    not_idptov integer NOT NULL,
    not_titulo character varying(300),
    not_tipo integer,
    not_mes integer,
    not_anio integer,
    not_fechad date,
    not_fechah date,
    not_archivo character varying(300),
    not_estado integer
);


ALTER TABLE public.noticias OWNER TO sanjor;

--
-- Name: noticias_not_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE noticias_not_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.noticias_not_id_seq OWNER TO sanjor;

--
-- Name: noticias_not_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE noticias_not_id_seq OWNED BY noticias.not_id;


--
-- Name: operadores; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE operadores (
    operad_id integer NOT NULL,
    operad_nombre character varying(140) NOT NULL,
    operad_pass character varying(40) NOT NULL,
    operad_sector character varying(140),
    operad_estado smallint DEFAULT 1 NOT NULL,
    operad_nivaut1 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_nivaut2 character(2) DEFAULT 'NO'::bpchar NOT NULL,
    operad_count smallint DEFAULT 1 NOT NULL,
    operad_grupo smallint,
    operad_cliente smallint,
    operad_login character varying(40) NOT NULL,
    operad_last date DEFAULT date(now()),
    operad_contacto character varying(290),
    operad_telefono character varying(190),
    operad_codemp integer,
    operad_ptovta integer
);


ALTER TABLE public.operadores OWNER TO sanjor;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE operadores_operad_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.operadores_operad_id_seq OWNER TO sanjor;

--
-- Name: operadores_operad_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE operadores_operad_id_seq OWNED BY operadores.operad_id;


--
-- Name: pais; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE pais (
    pai_codigo smallint NOT NULL,
    pai_nombre character varying(140) NOT NULL
);


ALTER TABLE public.pais OWNER TO sanjor;

--
-- Name: posliq; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE posliq (
    plq_id integer NOT NULL,
    plq_codemp integer NOT NULL,
    plq_idptov integer NOT NULL,
    plq_division integer,
    plq_centro integer,
    plq_idcopr integer NOT NULL,
    plq_fecha date DEFAULT date(now()),
    plq_anio smallint DEFAULT date_part('Y'::text, date(now())) NOT NULL,
    plq_mes smallint DEFAULT date_part('month'::text, date(now())) NOT NULL,
    plq_comprob integer,
    plq_numero integer,
    plq_rubcar integer NOT NULL,
    plq_cargo integer NOT NULL,
    plq_importe numeric(15,2) DEFAULT 0,
    plq_estado integer DEFAULT 1,
    plq_fecreg timestamp without time zone DEFAULT now() NOT NULL,
    plq_operad integer,
    plq_leyen text
);


ALTER TABLE public.posliq OWNER TO sanjor;

--
-- Name: posliq_plq_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE posliq_plq_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.posliq_plq_id_seq OWNER TO sanjor;

--
-- Name: posliq_plq_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE posliq_plq_id_seq OWNED BY posliq.plq_id;


--
-- Name: prove; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE prove (
    prov_id integer NOT NULL,
    prov_nrcuit character varying(20),
    prov_codemp integer DEFAULT 0 NOT NULL,
    prov_idptov integer DEFAULT 0 NOT NULL,
    prov_codigo integer,
    prov_nombre character varying(140),
    prov_direcc character varying(160),
    prov_locali character varying(160),
    prov_provin integer DEFAULT 1 NOT NULL,
    prov_pais smallint DEFAULT 200 NOT NULL,
    prov_estado smallint DEFAULT 1 NOT NULL,
    prov_direce character varying(160),
    prov_observ text,
    prov_grupo integer DEFAULT 1,
    prov_tipo integer DEFAULT 1,
    prov_coniva integer DEFAULT 1,
    prov_retig integer DEFAULT 1,
    prov_codpos character varying
);


ALTER TABLE public.prove OWNER TO sanjor;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE prove_prov_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.prove_prov_id_seq OWNER TO sanjor;

--
-- Name: prove_prov_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE prove_prov_id_seq OWNED BY prove.prov_id;


--
-- Name: provin; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE provin (
    pro_codigo integer NOT NULL,
    pro_nombre character varying(140) NOT NULL,
    pro_tasa numeric(15,5),
    pro_coef numeric(15,5),
    pro_valor numeric(15,2) DEFAULT 0
);


ALTER TABLE public.provin OWNER TO sanjor;

--
-- Name: ptovta; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE ptovta (
    ptv_id integer NOT NULL,
    ptv_codemp integer NOT NULL,
    ptv_codigo integer NOT NULL,
    ptv_nombre character varying(140) NOT NULL,
    ptv_direcc character varying(160),
    ptv_locali character varying(160),
    ptv_codpos character varying(10),
    ptv_provin integer DEFAULT 1,
    ptv_pais smallint DEFAULT 200,
    ptv_nrcuit character varying(20),
    ptv_tipo integer DEFAULT 1,
    ptv_anti date DEFAULT date(now()),
    ptv_fecint integer DEFAULT 15,
    ptv_grupo integer DEFAULT 1,
    ptv_redond integer DEFAULT 1,
    ptv_nomabre character varying(140),
    ptv_estado smallint DEFAULT 1,
    ptv_aplicadesc integer DEFAULT 1
);


ALTER TABLE public.ptovta OWNER TO sanjor;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE ptovta_ptv_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.ptovta_ptv_id_seq OWNER TO sanjor;

--
-- Name: ptovta_ptv_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE ptovta_ptv_id_seq OWNED BY ptovta.ptv_id;


--
-- Name: rubcar; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE rubcar (
    rubl_id integer NOT NULL,
    rubl_codemp integer DEFAULT 0 NOT NULL,
    rubl_tipo integer DEFAULT 1,
    rubl_codigo integer,
    rubl_nombre character varying(340) NOT NULL
);


ALTER TABLE public.rubcar OWNER TO sanjor;

--
-- Name: rubcar_rubl_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE rubcar_rubl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.rubcar_rubl_id_seq OWNER TO sanjor;

--
-- Name: rubcar_rubl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE rubcar_rubl_id_seq OWNED BY rubcar.rubl_id;


--
-- Name: rubros; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE rubros (
    rub_id integer NOT NULL,
    rub_codemp integer DEFAULT 0 NOT NULL,
    rub_idptov integer DEFAULT 0 NOT NULL,
    rub_tipo integer DEFAULT 1,
    rub_codigo integer,
    rub_nombre character varying(140) NOT NULL
);


ALTER TABLE public.rubros OWNER TO sanjor;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE rubros_rub_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.rubros_rub_id_seq OWNER TO sanjor;

--
-- Name: rubros_rub_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE rubros_rub_id_seq OWNED BY rubros.rub_id;


--
-- Name: seccion; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE seccion (
    sec_codigo smallint NOT NULL,
    sec_nombre character varying(140) NOT NULL
);


ALTER TABLE public.seccion OWNER TO sanjor;

--
-- Name: srubcar; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE srubcar (
    srbl_id integer NOT NULL,
    srbl_rubro integer NOT NULL,
    srbl_codigo integer NOT NULL,
    srbl_nombre character varying(340) NOT NULL,
    srbl_precio numeric(15,5) DEFAULT 0,
    srbl_leyen text,
    srbl_codemp integer DEFAULT 1 NOT NULL,
    srbl_idptov integer DEFAULT 0 NOT NULL,
    srbl_genint integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.srubcar OWNER TO sanjor;

--
-- Name: srubcar_srbl_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE srubcar_srbl_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.srubcar_srbl_id_seq OWNER TO sanjor;

--
-- Name: srubcar_srbl_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE srubcar_srbl_id_seq OWNED BY srubcar.srbl_id;


--
-- Name: subd; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE subd (
    subd_id integer NOT NULL,
    subd_codemp integer DEFAULT 0 NOT NULL,
    subd_idptov integer DEFAULT 0 NOT NULL,
    subd_nombre character varying(140),
    subd_titulo character varying(140),
    subd_fecd date,
    subd_fech date,
    subd_estado smallint DEFAULT 1 NOT NULL,
    subd_proxnum integer
);


ALTER TABLE public.subd OWNER TO sanjor;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE subd_subd_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.subd_subd_id_seq OWNER TO sanjor;

--
-- Name: subd_subd_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE subd_subd_id_seq OWNED BY subd.subd_id;


--
-- Name: subrub; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE subrub (
    srb_id integer NOT NULL,
    srb_rubro integer NOT NULL,
    srb_codemp integer DEFAULT 0 NOT NULL,
    srb_idptov integer DEFAULT 0 NOT NULL,
    srb_codigo smallint NOT NULL,
    srb_nombre character varying(140) NOT NULL,
    srb_precio numeric(15,2) DEFAULT 0,
    srb_leyen text,
    srb_codtg smallint DEFAULT 1,
    srb_conper smallint DEFAULT 1,
    srb_tiprub integer,
    srb_cuenta integer
);


ALTER TABLE public.subrub OWNER TO sanjor;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE subrub_srb_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.subrub_srb_id_seq OWNER TO sanjor;

--
-- Name: subrub_srb_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE subrub_srb_id_seq OWNED BY subrub.srb_id;


--
-- Name: subxcomp; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE subxcomp (
    subxc_idsub integer NOT NULL,
    subxc_comprob integer NOT NULL
);


ALTER TABLE public.subxcomp OWNER TO sanjor;

--
-- Name: sucursal; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE sucursal (
    sucu_cliente integer NOT NULL,
    sucu_codigo smallint DEFAULT 1 NOT NULL,
    sucu_nombre character varying(140) NOT NULL,
    sucu_direcc character varying(160),
    sucu_locali character varying(160),
    sucu_codpos character varying(10),
    sucu_provin integer,
    sucu_pais smallint,
    sucu_repres character varying(240),
    sucu_contacto character varying(240),
    sucu_observ text,
    sucu_direccl character varying(160),
    sucu_localil character varying(160),
    sucu_codposl character varying(10),
    sucu_codprovl integer,
    sucu_paisl smallint
);


ALTER TABLE public.sucursal OWNER TO sanjor;

--
-- Name: talon; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE talon (
    tal_id integer NOT NULL,
    tal_idptov integer DEFAULT 0 NOT NULL,
    tal_comprob integer,
    tal_nombre character varying(140) NOT NULL,
    tal_valor integer,
    tal_fecha date,
    tal_estado smallint DEFAULT 1,
    tal_vald integer DEFAULT 1,
    tal_valh integer DEFAULT 100000,
    tal_fecvto date DEFAULT '2028-12-31'::date,
    tal_codemp integer DEFAULT 0 NOT NULL
);


ALTER TABLE public.talon OWNER TO sanjor;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE talon_tal_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.talon_tal_id_seq OWNER TO sanjor;

--
-- Name: talon_tal_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE talon_tal_id_seq OWNED BY talon.tal_id;


--
-- Name: telefon; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE telefon (
    tel_id integer NOT NULL,
    tel_tipent integer NOT NULL,
    tel_codigo integer NOT NULL,
    tel_tiptel integer NOT NULL,
    tel_contact character varying(60) NOT NULL,
    tel_leyen text,
    tel_dato character varying(300)
);


ALTER TABLE public.telefon OWNER TO sanjor;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE telefon_tel_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.telefon_tel_id_seq OWNER TO sanjor;

--
-- Name: telefon_tel_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE telefon_tel_id_seq OWNED BY telefon.tel_id;


--
-- Name: tipcta; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE tipcta (
    tct_codigo integer NOT NULL,
    tct_nombre character varying(140) NOT NULL
);


ALTER TABLE public.tipcta OWNER TO sanjor;

--
-- Name: tipdocu; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE tipdocu (
    td_codigo character varying(5) NOT NULL,
    td_nombre character varying(140) NOT NULL
);


ALTER TABLE public.tipdocu OWNER TO sanjor;

--
-- Name: tipemp; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE tipemp (
    tem_codigo smallint NOT NULL,
    tem_nombre character varying(140) NOT NULL
);


ALTER TABLE public.tipemp OWNER TO sanjor;

--
-- Name: tipempr; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE tipempr (
    ter_codigo integer NOT NULL,
    ter_nombre character varying(140) NOT NULL
);


ALTER TABLE public.tipempr OWNER TO sanjor;

--
-- Name: tipentid; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE tipentid (
    tet_codigo integer NOT NULL,
    tet_nombre character varying(140) NOT NULL
);


ALTER TABLE public.tipentid OWNER TO sanjor;

SET default_with_oids = false;

--
-- Name: tipnot; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE tipnot (
    tnot_codigo integer NOT NULL,
    tnot_codemp integer DEFAULT 1 NOT NULL,
    tnot_nombre character varying(300)
);


ALTER TABLE public.tipnot OWNER TO sanjor;

SET default_with_oids = true;

--
-- Name: tiptel; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE tiptel (
    ttl_codigo integer NOT NULL,
    ttl_nombre character varying(140) NOT NULL
);


ALTER TABLE public.tiptel OWNER TO sanjor;

--
-- Name: tipuf; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE tipuf (
    tuf_codigo integer NOT NULL,
    tuf_nombre character varying(140) NOT NULL
);


ALTER TABLE public.tipuf OWNER TO sanjor;

--
-- Name: unimed; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE unimed (
    uni_codigo smallint NOT NULL,
    uni_nombre character varying(140) NOT NULL,
    uni_coef numeric(15,5),
    uni_simbolo character(3)
);


ALTER TABLE public.unimed OWNER TO sanjor;

--
-- Name: varamb; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE varamb (
    var_codigo character varying(140) NOT NULL,
    var_nombre character varying(140) NOT NULL,
    var_valor character varying(140)
);


ALTER TABLE public.varamb OWNER TO sanjor;

--
-- Name: varambi; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE varambi (
    vari_codemp integer DEFAULT 0 NOT NULL,
    vari_idptov integer DEFAULT 0 NOT NULL,
    vari_codigo character varying(140) NOT NULL,
    vari_nombre character varying(140) NOT NULL,
    vari_valor character varying(140),
    vari_tipo integer DEFAULT 1
);


ALTER TABLE public.varambi OWNER TO sanjor;

--
-- Name: vendedor; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE vendedor (
    ven_id integer NOT NULL,
    ven_codemp integer DEFAULT 0 NOT NULL,
    ven_nombre character varying(140) NOT NULL,
    ven_direcc character varying(160),
    ven_locali character varying(160),
    ven_codpos character varying(10),
    ven_provin integer,
    ven_pais smallint,
    ven_nrcuit character varying(20),
    ven_estado smallint DEFAULT 1,
    ven_comis numeric(15,5) DEFAULT 0
);


ALTER TABLE public.vendedor OWNER TO sanjor;

--
-- Name: vendedor_ven_id_seq; Type: SEQUENCE; Schema: public; Owner: sanjor
--

CREATE SEQUENCE vendedor_ven_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.vendedor_ven_id_seq OWNER TO sanjor;

--
-- Name: vendedor_ven_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: sanjor
--

ALTER SEQUENCE vendedor_ven_id_seq OWNED BY vendedor.ven_id;


--
-- Name: zona; Type: TABLE; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE TABLE zona (
    zon_codigo integer NOT NULL,
    zon_pais integer,
    zon_provin smallint,
    zon_ciudad integer,
    zon_barrio integer,
    zon_nombre character varying(140) NOT NULL
);


ALTER TABLE public.zona OWNER TO sanjor;

--
-- Name: art_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY articvta ALTER COLUMN art_id SET DEFAULT nextval('articvta_art_id_seq'::regclass);


--
-- Name: astc_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY astoctas ALTER COLUMN astc_id SET DEFAULT nextval('astoctas_astc_id_seq'::regclass);


--
-- Name: ash_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY astoh ALTER COLUMN ash_id SET DEFAULT nextval('astoh_ash_id_seq'::regclass);


--
-- Name: ai_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY auxint ALTER COLUMN ai_id SET DEFAULT nextval('auxint_ai_id_seq'::regclass);


--
-- Name: cbt_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cambtitu ALTER COLUMN cbt_id SET DEFAULT nextval('cambtitu_cbt_id_seq'::regclass);


--
-- Name: car_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cargos ALTER COLUMN car_id SET DEFAULT nextval('cargos_car_id_seq'::regclass);


--
-- Name: cco_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY centroc ALTER COLUMN cco_id SET DEFAULT nextval('centroc_cco_id_seq'::regclass);


--
-- Name: chq_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cheques ALTER COLUMN chq_id SET DEFAULT nextval('cheques_chq_id_seq'::regclass);


--
-- Name: chqr_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY chqrech ALTER COLUMN chqr_id SET DEFAULT nextval('chqrech_chqr_id_seq'::regclass);


--
-- Name: clq_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliq ALTER COLUMN clq_id SET DEFAULT nextval('compliq_clq_id_seq'::regclass);


--
-- Name: cl_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliquid ALTER COLUMN cl_id SET DEFAULT nextval('compliquid_cl_id_seq'::regclass);


--
-- Name: cpra_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compra ALTER COLUMN cpra_id SET DEFAULT nextval('compra_cpra_id_seq'::regclass);


--
-- Name: comp_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY comprob ALTER COLUMN comp_id SET DEFAULT nextval('comprob_comp_id_seq'::regclass);


--
-- Name: cmpr_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY comprop ALTER COLUMN cmpr_id SET DEFAULT nextval('comprop_cmpr_id_seq'::regclass);


--
-- Name: con_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY convenios ALTER COLUMN con_id SET DEFAULT nextval('convenios_con_id_seq'::regclass);


--
-- Name: cop_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY coprop ALTER COLUMN cop_id SET DEFAULT nextval('coprop_cop_id_seq'::regclass);


--
-- Name: cbl_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY ctacble ALTER COLUMN cbl_id SET DEFAULT nextval('ctacble_cbl_id_seq'::regclass);


--
-- Name: ctc_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY ctasconv ALTER COLUMN ctc_id SET DEFAULT nextval('ctasconv_ctc_id_seq'::regclass);


--
-- Name: cte_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY ctes ALTER COLUMN cte_id SET DEFAULT nextval('ctes_cte_id_seq'::regclass);


--
-- Name: div_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY division ALTER COLUMN div_id SET DEFAULT nextval('division_div_id_seq'::regclass);


--
-- Name: doc_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY docum ALTER COLUMN doc_id SET DEFAULT nextval('docum_doc_id_seq'::regclass);


--
-- Name: emi_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY emiti ALTER COLUMN emi_id SET DEFAULT nextval('emiti_emi_id_seq'::regclass);


--
-- Name: ent_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY entidad ALTER COLUMN ent_id SET DEFAULT nextval('entidad_ent_id_seq'::regclass);


--
-- Name: fap_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY factpend ALTER COLUMN fap_id SET DEFAULT nextval('factpend_fap_id_seq'::regclass);


--
-- Name: fir_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY firman ALTER COLUMN fir_id SET DEFAULT nextval('firman_fir_id_seq'::regclass);


--
-- Name: gto_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY gastos ALTER COLUMN gto_id SET DEFAULT nextval('gastos_gto_id_seq'::regclass);


--
-- Name: hon_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY honorarios ALTER COLUMN hon_id SET DEFAULT nextval('honorarios_hon_id_seq'::regclass);


--
-- Name: jud_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY judicial ALTER COLUMN jud_id SET DEFAULT nextval('judicial_jud_id_seq'::regclass);


--
-- Name: eg_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqegr ALTER COLUMN eg_id SET DEFAULT nextval('liqegr_eg_id_seq'::regclass);


--
-- Name: lqp_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqpdf ALTER COLUMN lqp_id SET DEFAULT nextval('liqpdf_lqp_id_seq'::regclass);


--
-- Name: lq_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqui ALTER COLUMN lq_id SET DEFAULT nextval('liqui_lq_id_seq'::regclass);


--
-- Name: l_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liquidacion ALTER COLUMN l_id SET DEFAULT nextval('liquidacion_l_id_seq'::regclass);


--
-- Name: ltp_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY listpre ALTER COLUMN ltp_id SET DEFAULT nextval('listpre_ltp_id_seq'::regclass);


--
-- Name: mne_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY monex ALTER COLUMN mne_id SET DEFAULT nextval('monex_mne_id_seq'::regclass);


--
-- Name: movs_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY movsto ALTER COLUMN movs_id SET DEFAULT nextval('movsto_movs_id_seq'::regclass);


--
-- Name: movc_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY movstoc ALTER COLUMN movc_id SET DEFAULT nextval('movstoc_movc_id_seq'::regclass);


--
-- Name: nd_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY notdeb ALTER COLUMN nd_id SET DEFAULT nextval('notdeb_nd_id_seq'::regclass);


--
-- Name: not_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY noticias ALTER COLUMN not_id SET DEFAULT nextval('noticias_not_id_seq'::regclass);


--
-- Name: operad_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY operadores ALTER COLUMN operad_id SET DEFAULT nextval('operadores_operad_id_seq'::regclass);


--
-- Name: plq_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY posliq ALTER COLUMN plq_id SET DEFAULT nextval('posliq_plq_id_seq'::regclass);


--
-- Name: prov_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY prove ALTER COLUMN prov_id SET DEFAULT nextval('prove_prov_id_seq'::regclass);


--
-- Name: ptv_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY ptovta ALTER COLUMN ptv_id SET DEFAULT nextval('ptovta_ptv_id_seq'::regclass);


--
-- Name: rubl_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY rubcar ALTER COLUMN rubl_id SET DEFAULT nextval('rubcar_rubl_id_seq'::regclass);


--
-- Name: rub_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY rubros ALTER COLUMN rub_id SET DEFAULT nextval('rubros_rub_id_seq'::regclass);


--
-- Name: srbl_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY srubcar ALTER COLUMN srbl_id SET DEFAULT nextval('srubcar_srbl_id_seq'::regclass);


--
-- Name: subd_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY subd ALTER COLUMN subd_id SET DEFAULT nextval('subd_subd_id_seq'::regclass);


--
-- Name: srb_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY subrub ALTER COLUMN srb_id SET DEFAULT nextval('subrub_srb_id_seq'::regclass);


--
-- Name: tal_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY talon ALTER COLUMN tal_id SET DEFAULT nextval('talon_tal_id_seq'::regclass);


--
-- Name: tel_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY telefon ALTER COLUMN tel_id SET DEFAULT nextval('telefon_tel_id_seq'::regclass);


--
-- Name: ven_id; Type: DEFAULT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY vendedor ALTER COLUMN ven_id SET DEFAULT nextval('vendedor_ven_id_seq'::regclass);


--
-- Name: articvta_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY articvta
    ADD CONSTRAINT articvta_pkey PRIMARY KEY (art_id);


--
-- Name: astoctas_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_pkey PRIMARY KEY (astc_id);


--
-- Name: astoh_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_pkey PRIMARY KEY (ash_id);


--
-- Name: bancos_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY bancos
    ADD CONSTRAINT bancos_pkey PRIMARY KEY (bco_codigo);


--
-- Name: cambtitu_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT cambtitu_pkey PRIMARY KEY (cbt_id);


--
-- Name: cargos_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY cargos
    ADD CONSTRAINT cargos_pkey PRIMARY KEY (car_id);


--
-- Name: catego_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY catego
    ADD CONSTRAINT catego_pkey PRIMARY KEY (cat_codigo);


--
-- Name: centroc_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_pkey PRIMARY KEY (cco_id);


--
-- Name: cheques_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_pkey PRIMARY KEY (chq_id);


--
-- Name: compliq_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT compliq_pkey PRIMARY KEY (clq_id);


--
-- Name: compra_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_pkey PRIMARY KEY (cpra_id);


--
-- Name: comprob_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY comprob
    ADD CONSTRAINT comprob_pkey PRIMARY KEY (comp_id);


--
-- Name: comprop_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT comprop_pkey PRIMARY KEY (cmpr_id);


--
-- Name: coniva_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY coniva
    ADD CONSTRAINT coniva_pkey PRIMARY KEY (iva_codigo);


--
-- Name: conpag_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY conpag
    ADD CONSTRAINT conpag_pkey PRIMARY KEY (cdp_codigo);


--
-- Name: convenios_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT convenios_pkey PRIMARY KEY (con_id);


--
-- Name: coprop_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY coprop
    ADD CONSTRAINT coprop_pkey PRIMARY KEY (cop_id);


--
-- Name: cotiza_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY cotiza
    ADD CONSTRAINT cotiza_pkey PRIMARY KEY (cot_moneda, cot_fecha);


--
-- Name: ctacble_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY ctacble
    ADD CONSTRAINT ctacble_pkey PRIMARY KEY (cbl_id);


--
-- Name: ctasconv_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY ctasconv
    ADD CONSTRAINT ctasconv_pkey PRIMARY KEY (ctc_id);


--
-- Name: ctes_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY ctes
    ADD CONSTRAINT ctes_pkey PRIMARY KEY (cte_id);


--
-- Name: division_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_pkey PRIMARY KEY (div_id);


--
-- Name: docum_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_pkey PRIMARY KEY (doc_id);


--
-- Name: emiti_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_pkey PRIMARY KEY (emi_id);


--
-- Name: empresa_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY empresa
    ADD CONSTRAINT empresa_pkey PRIMARY KEY (emp_codigo);


--
-- Name: entidad_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY entidad
    ADD CONSTRAINT entidad_pkey PRIMARY KEY (ent_id);


--
-- Name: estjud_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY estjud
    ADD CONSTRAINT estjud_pkey PRIMARY KEY (etj_codigo);


--
-- Name: estjurid_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY estjurid
    ADD CONSTRAINT estjurid_pkey PRIMARY KEY (est_codigo);


--
-- Name: factpend_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_pkey PRIMARY KEY (fap_id);


--
-- Name: firman_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY firman
    ADD CONSTRAINT firman_pkey PRIMARY KEY (fir_id);


--
-- Name: gastos_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_pkey PRIMARY KEY (gto_id);


--
-- Name: grupos_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY grupos
    ADD CONSTRAINT grupos_pkey PRIMARY KEY (gpo_id);


--
-- Name: honorarios_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY honorarios
    ADD CONSTRAINT honorarios_pkey PRIMARY KEY (hon_id);


--
-- Name: impresiones_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY impresiones
    ADD CONSTRAINT impresiones_pkey PRIMARY KEY (imp_codigo);


--
-- Name: interes_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_pkey PRIMARY KEY (int_codemp, int_fecha);


--
-- Name: judicial_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT judicial_pkey PRIMARY KEY (jud_id);


--
-- Name: liqegr_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_pkey PRIMARY KEY (eg_id);


--
-- Name: liqpdf_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY liqpdf
    ADD CONSTRAINT liqpdf_pkey PRIMARY KEY (lqp_id);


--
-- Name: liquid_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY liquid
    ADD CONSTRAINT liquid_pkey PRIMARY KEY (lq_codemp, lq_idptov, lq_anio, lq_mes);


--
-- Name: liquidacion_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT liquidacion_pkey PRIMARY KEY (l_id);


--
-- Name: listpre_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY listpre
    ADD CONSTRAINT listpre_pkey PRIMARY KEY (ltp_id);


--
-- Name: moneda_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY moneda
    ADD CONSTRAINT moneda_pkey PRIMARY KEY (mon_codigo);


--
-- Name: monex_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY monex
    ADD CONSTRAINT monex_pkey PRIMARY KEY (mne_id);


--
-- Name: movsto_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_pkey PRIMARY KEY (movs_id);


--
-- Name: movstoc_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY movstoc
    ADD CONSTRAINT movstoc_pkey PRIMARY KEY (movc_id);


--
-- Name: noticias_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY noticias
    ADD CONSTRAINT noticias_pkey PRIMARY KEY (not_id);


--
-- Name: operadores_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY operadores
    ADD CONSTRAINT operadores_pkey PRIMARY KEY (operad_id);


--
-- Name: pais_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY pais
    ADD CONSTRAINT pais_pkey PRIMARY KEY (pai_codigo);


--
-- Name: posliq_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY posliq
    ADD CONSTRAINT posliq_pkey PRIMARY KEY (plq_id);


--
-- Name: prove_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY prove
    ADD CONSTRAINT prove_pkey PRIMARY KEY (prov_id);


--
-- Name: provin_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY provin
    ADD CONSTRAINT provin_pkey PRIMARY KEY (pro_codigo);


--
-- Name: ptovta_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT ptovta_pkey PRIMARY KEY (ptv_id);


--
-- Name: rubcar_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY rubcar
    ADD CONSTRAINT rubcar_pkey PRIMARY KEY (rubl_id);


--
-- Name: rubros_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY rubros
    ADD CONSTRAINT rubros_pkey PRIMARY KEY (rub_id);


--
-- Name: seccion_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY seccion
    ADD CONSTRAINT seccion_pkey PRIMARY KEY (sec_codigo);


--
-- Name: srubcar_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY srubcar
    ADD CONSTRAINT srubcar_pkey PRIMARY KEY (srbl_id);


--
-- Name: subd_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY subd
    ADD CONSTRAINT subd_pkey PRIMARY KEY (subd_id);


--
-- Name: subrub_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY subrub
    ADD CONSTRAINT subrub_pkey PRIMARY KEY (srb_id);


--
-- Name: sucursal_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY sucursal
    ADD CONSTRAINT sucursal_pkey PRIMARY KEY (sucu_cliente, sucu_codigo);


--
-- Name: talon_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY talon
    ADD CONSTRAINT talon_pkey PRIMARY KEY (tal_id);


--
-- Name: telefon_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY telefon
    ADD CONSTRAINT telefon_pkey PRIMARY KEY (tel_id);


--
-- Name: tipcta_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY tipcta
    ADD CONSTRAINT tipcta_pkey PRIMARY KEY (tct_codigo);


--
-- Name: tipdocu_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY tipdocu
    ADD CONSTRAINT tipdocu_pkey PRIMARY KEY (td_codigo);


--
-- Name: tipemp_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY tipemp
    ADD CONSTRAINT tipemp_pkey PRIMARY KEY (tem_codigo);


--
-- Name: tipempr_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY tipempr
    ADD CONSTRAINT tipempr_pkey PRIMARY KEY (ter_codigo);


--
-- Name: tipentid_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY tipentid
    ADD CONSTRAINT tipentid_pkey PRIMARY KEY (tet_codigo);


--
-- Name: tipnot_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY tipnot
    ADD CONSTRAINT tipnot_pkey PRIMARY KEY (tnot_codigo);


--
-- Name: tiptel_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY tiptel
    ADD CONSTRAINT tiptel_pkey PRIMARY KEY (ttl_codigo);


--
-- Name: tipuf_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY tipuf
    ADD CONSTRAINT tipuf_pkey PRIMARY KEY (tuf_codigo);


--
-- Name: unimed_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY unimed
    ADD CONSTRAINT unimed_pkey PRIMARY KEY (uni_codigo);


--
-- Name: varamb_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY varamb
    ADD CONSTRAINT varamb_pkey PRIMARY KEY (var_codigo);


--
-- Name: varambi_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY varambi
    ADD CONSTRAINT varambi_pkey PRIMARY KEY (vari_codemp, vari_idptov, vari_codigo);


--
-- Name: vendedor_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY vendedor
    ADD CONSTRAINT vendedor_pkey PRIMARY KEY (ven_id);


--
-- Name: zona_pkey; Type: CONSTRAINT; Schema: public; Owner: sanjor; Tablespace: 
--

ALTER TABLE ONLY zona
    ADD CONSTRAINT zona_pkey PRIMARY KEY (zon_codigo);


--
-- Name: idx_articvta_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_1 ON articvta USING btree (art_tipoper, art_codigo);


--
-- Name: idx_articvta_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_articvta_2 ON articvta USING btree (art_idptov, art_codi);


--
-- Name: idx_astoctas_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_1 ON astoctas USING btree (astc_idastoh);


--
-- Name: idx_astoctas_10; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_10 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_11; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_11 ON astoctas USING btree (astc_codemp, astc_idptov, astc_tipcta, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_12; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_12 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_moneda);


--
-- Name: idx_astoctas_13; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_13 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_14; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_14 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_estado, astc_fecval);


--
-- Name: idx_astoctas_15; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_15 ON astoctas USING btree (astc_codemp, astc_estado, astc_tipcta, astc_ctacte);


--
-- Name: idx_astoctas_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_2 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_3 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_4; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_4 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_fecval);


--
-- Name: idx_astoctas_5; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_5 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecval);


--
-- Name: idx_astoctas_6; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_6 ON astoctas USING btree (astc_codemp, astc_ctacble, astc_ctacte, astc_cierra, astc_fecvto);


--
-- Name: idx_astoctas_7; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_7 ON astoctas USING btree (astc_ctacble, astc_fecval);


--
-- Name: idx_astoctas_8; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_8 ON astoctas USING btree (astc_codemp, astc_idptov, astc_ctacble, astc_ctacte, astc_grupo);


--
-- Name: idx_astoctas_9; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoctas_9 ON astoctas USING btree (astc_codemp, astc_idptov, astc_comprob, astc_numero);


--
-- Name: idx_astoh_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_astoh_1 ON astoh USING btree (ash_codemp, ash_idptov, ash_comprob, ash_numero);


--
-- Name: idx_astoh_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoh_2 ON astoh USING btree (ash_codemp, ash_anio, ash_mes, ash_fecomp);


--
-- Name: idx_astoh_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoh_3 ON astoh USING btree (ash_codemp, ash_anio, ash_mes, ash_fecval);


--
-- Name: idx_astoh_4; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoh_4 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_fecomp);


--
-- Name: idx_astoh_5; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoh_5 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_fecval);


--
-- Name: idx_astoh_6; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoh_6 ON astoh USING btree (ash_codemp, ash_idptov, ash_anio, ash_mes, ash_fecval);


--
-- Name: idx_astoh_7; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoh_7 ON astoh USING btree (ash_anio, ash_mes, ash_codemp, ash_idptov, ash_fecval);


--
-- Name: idx_astoh_8; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_astoh_8 ON astoh USING btree (ash_codemp, ash_idptov, ash_titulo);


--
-- Name: idx_auxint_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_auxint_1 ON auxint USING btree (ai_idliq, ai_idcopr);


--
-- Name: idx_cambtitu_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cambtitu_1 ON cambtitu USING btree (cbt_codemp, cbt_idptov, cbt_idcopr);


--
-- Name: idx_cambtitu_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cambtitu_2 ON cambtitu USING btree (cbt_idcopr);


--
-- Name: idx_cargos_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cargos_1 ON cargos USING btree (car_codemp, car_idptov, car_division, car_centro, car_codigo);


--
-- Name: idx_cargos_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cargos_2 ON cargos USING btree (car_codemp, car_idptov, car_codigo);


--
-- Name: idx_cargos_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cargos_3 ON cargos USING btree (car_codemp, car_idptov, car_rubcar, car_srubcar);


--
-- Name: idx_centroc_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_centroc_1 ON centroc USING btree (cco_codemp, cco_idptov, cco_coddiv, cco_codigo);


--
-- Name: idx_cheques_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cheques_1 ON cheques USING btree (chq_codemp, chq_estado);


--
-- Name: idx_cheques_10; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cheques_10 ON cheques USING btree (chq_moneda, chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cheques_2 ON cheques USING btree (chq_codemp, chq_idptov, chq_estado);


--
-- Name: idx_cheques_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cheques_3 ON cheques USING btree (chq_codbco, chq_nucheq);


--
-- Name: idx_cheques_4; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cheques_4 ON cheques USING btree (chq_idastoc);


--
-- Name: idx_cheques_5; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cheques_5 ON cheques USING btree (chq_idastoce);


--
-- Name: idx_cheques_6; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cheques_6 ON cheques USING btree (chq_estado);


--
-- Name: idx_cheques_7; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cheques_7 ON cheques USING btree (chq_codemp, chq_estado, chq_fecheq);


--
-- Name: idx_cheques_8; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cheques_8 ON cheques USING btree (chq_estado, chq_fecheq);


--
-- Name: idx_cheques_9; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_cheques_9 ON cheques USING btree (chq_moneda);


--
-- Name: idx_compliq_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_compliq_2 ON compliq USING btree (clq_codemp, clq_idptov, clq_comprob, clq_numero);


--
-- Name: idx_compliq_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_compliq_3 ON compliq USING btree (clq_codemp, clq_idptov, clq_anio, clq_mes);


--
-- Name: idx_compliq_4; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_compliq_4 ON compliq USING btree (clq_codemp, clq_idptov, clq_anio, clq_mes, clq_rubcar, clq_cargo);


--
-- Name: idx_compliquid_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_compliquid_1 ON compliquid USING btree (cl_idliq);


--
-- Name: idx_compra_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_compra_1 ON compra USING btree (cpra_codemp, cpra_idptov, cpra_comprob, cpra_numero);


--
-- Name: idx_compra_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_compra_2 ON compra USING btree (cpra_codemp, cpra_fecval);


--
-- Name: idx_compra_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_compra_3 ON compra USING btree (cpra_idastoh);


--
-- Name: idx_comprob_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_comprob_1 ON comprob USING btree (comp_idptov, comp_codigo);


--
-- Name: idx_comprob_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_comprob_2 ON comprob USING btree (comp_codemp, comp_idptov, comp_codigo);


--
-- Name: idx_comprop_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_comprop_1 ON comprop USING btree (cmpr_centro, cmpr_idcopr);


--
-- Name: idx_comprop_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_comprop_2 ON comprop USING btree (cmpr_codemp, cmpr_idptov, cmpr_idcopr);


--
-- Name: idx_comprop_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_comprop_3 ON comprop USING btree (cmpr_codemp, cmpr_idptov, cmpr_idcopr, cmpr_rubcar, cmpr_cargo);


--
-- Name: idx_convenios_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_convenios_1 ON convenios USING btree (con_codemp, con_idptov, con_division, con_centro, con_idcopr);


--
-- Name: idx_coprop_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_coprop_1 ON coprop USING btree (cop_codemp, cop_idptov, cop_unifun);


--
-- Name: idx_coprop_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_coprop_2 ON coprop USING btree (cop_codemp, cop_idptov, cop_codaso);


--
-- Name: idx_ctacble_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctacble_1 ON ctacble USING btree (cbl_codemp, cbl_idptov, cbl_codigo);


--
-- Name: idx_ctacble_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_ctacble_2 ON ctacble USING btree (cbl_idptov, cbl_codigo);


--
-- Name: idx_ctacble_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_ctacble_3 ON ctacble USING btree (cbl_codemp, cbl_idptov, cbl_nombre);


--
-- Name: idx_ctes_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_ctes_1 ON ctes USING btree (cte_codemp, cte_tipcta, cte_tipct, cte_codigo);


--
-- Name: idx_division_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_division_1 ON division USING btree (div_codemp, div_idptov, div_codigo);


--
-- Name: idx_docum_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_docum_1 ON docum USING btree (doc_nrcuit);


--
-- Name: idx_docum_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_docum_2 ON docum USING btree (doc_estado, doc_nrcuit);


--
-- Name: idx_docum_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_docum_3 ON docum USING btree (doc_codemp, doc_idptov, doc_estado);


--
-- Name: idx_docum_4; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_docum_4 ON docum USING btree (doc_idastoc);


--
-- Name: idx_docum_5; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_docum_5 ON docum USING btree (doc_idastoce);


--
-- Name: idx_docum_6; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_docum_6 ON docum USING btree (doc_estado);


--
-- Name: idx_emiti_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_emiti_1 ON emiti USING btree (emi_codemp, emi_idptov, emi_comprob, emi_numero);


--
-- Name: idx_emiti_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_emiti_2 ON emiti USING btree (emi_codemp, emi_fecval);


--
-- Name: idx_emiti_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_emiti_3 ON emiti USING btree (emi_idastoh);


--
-- Name: idx_empresa_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_empresa_1 ON empresa USING btree (emp_nrcuit);


--
-- Name: idx_factpend_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_factpend_2 ON factpend USING btree (fap_codemp, fap_idptov, fap_centro);


--
-- Name: idx_firman_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_firman_1 ON firman USING btree (fir_nrcuit);


--
-- Name: idx_gastos_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_gastos_1 ON gastos USING btree (gto_idastoh);


--
-- Name: idx_gastos_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_gastos_2 ON gastos USING btree (gto_codemp, gto_idptov, gto_centro);


--
-- Name: idx_gtoxliqe_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_gtoxliqe_1 ON gtoxliqe USING btree (gxl_liqegr, gxl_gasto);


--
-- Name: idx_gtoxliqe_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_gtoxliqe_2 ON gtoxliqe USING btree (gxl_liqegr);


--
-- Name: idx_gtoxliqe_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_gtoxliqe_3 ON gtoxliqe USING btree (gxl_gasto);


--
-- Name: idx_honorarios_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_honorarios_2 ON honorarios USING btree (hon_codemp, hon_idptov, hon_rubro, hon_subrub);


--
-- Name: idx_judicial_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_judicial_1 ON judicial USING btree (jud_codemp, jud_idptov, jud_idcopr);


--
-- Name: idx_judicial_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_judicial_2 ON judicial USING btree (jud_idcopr);


--
-- Name: idx_liqegr_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_liqegr_1 ON liqegr USING btree (eg_idastoh);


--
-- Name: idx_liqegr_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_liqegr_2 ON liqegr USING btree (eg_codemp, eg_idptov, eg_centro);


--
-- Name: idx_liqpdf_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_liqpdf_1 ON liqpdf USING btree (lqp_idptov, lqp_anio, lqp_mes);


--
-- Name: idx_liqui_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_liqui_1 ON liqui USING btree (lq_idliq, lq_idcopr);


--
-- Name: idx_liquidacion_0; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_liquidacion_0 ON liquidacion USING btree (l_codemp, l_idptov, l_centro, l_division, l_anio, l_mes);


--
-- Name: idx_liquidacion_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_liquidacion_1 ON liquidacion USING btree (l_codemp, l_idptov, l_anio, l_mes);


--
-- Name: idx_liquidacion_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_liquidacion_2 ON liquidacion USING btree (l_idptov, l_anio, l_mes);


--
-- Name: idx_movsto_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_movsto_1 ON movsto USING btree (movs_idemiti);


--
-- Name: idx_movsto_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_movsto_2 ON movsto USING btree (movs_idastoh);


--
-- Name: idx_movsto_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_movsto_3 ON movsto USING btree (movs_artic);


--
-- Name: idx_movsto_4; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_movsto_4 ON movsto USING btree (movs_codemp, movs_idptov, movs_artic);


--
-- Name: idx_movsto_5; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_movsto_5 ON movsto USING btree (movs_idastoh, movs_artic);


--
-- Name: idx_movstoc_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_movstoc_1 ON movstoc USING btree (movc_idcompra);


--
-- Name: idx_movstoc_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_movstoc_2 ON movstoc USING btree (movc_idastoh);


--
-- Name: idx_movstoc_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_movstoc_3 ON movstoc USING btree (movc_artic);


--
-- Name: idx_movstoc_4; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_movstoc_4 ON movstoc USING btree (movc_codemp, movc_idptov, movc_artic);


--
-- Name: idx_movstoc_5; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_movstoc_5 ON movstoc USING btree (movc_idastoh, movc_artic);


--
-- Name: idx_noticias_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_noticias_1 ON noticias USING btree (not_idptov, not_tipo, not_titulo);


--
-- Name: idx_noticias_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_noticias_2 ON noticias USING btree (not_idptov, not_tipo, not_anio, not_mes);


--
-- Name: idx_noticias_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_noticias_3 ON noticias USING btree (not_idptov, not_anio, not_mes);


--
-- Name: idx_operadores_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_operadores_2 ON operadores USING btree (operad_login);


--
-- Name: idx_posliq_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_posliq_2 ON posliq USING btree (plq_codemp, plq_centro, plq_comprob, plq_numero);


--
-- Name: idx_posliq_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_posliq_3 ON posliq USING btree (plq_codemp, plq_centro, plq_anio, plq_mes);


--
-- Name: idx_posliq_4; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_posliq_4 ON posliq USING btree (plq_codemp, plq_idptov, plq_anio, plq_mes, plq_rubcar, plq_cargo);


--
-- Name: idx_prove_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_prove_1 ON prove USING btree (prov_nrcuit);


--
-- Name: idx_prove_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_prove_2 ON prove USING btree (prov_codemp, prov_codigo);


--
-- Name: idx_ptovta_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_ptovta_1 ON ptovta USING btree (ptv_codemp, ptv_codigo);


--
-- Name: idx_rubros_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_rubros_1 ON rubros USING btree (rub_tipo, rub_codigo);


--
-- Name: idx_subd_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_subd_1 ON subd USING btree (subd_codemp, subd_idptov);


--
-- Name: idx_subrub_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_subrub_1 ON subrub USING btree (srb_rubro, srb_codigo);


--
-- Name: idx_talon_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE UNIQUE INDEX idx_talon_1 ON talon USING btree (tal_idptov, tal_comprob);


--
-- Name: idx_telefon_1; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_telefon_1 ON telefon USING btree (tel_tipent, tel_codigo, tel_tiptel);


--
-- Name: idx_telefon_2; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_telefon_2 ON telefon USING btree (tel_dato);


--
-- Name: idx_telefon_3; Type: INDEX; Schema: public; Owner: sanjor; Tablespace: 
--

CREATE INDEX idx_telefon_3 ON telefon USING btree (tel_contact);


--
-- Name: ad_coprop; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER ad_coprop
    AFTER DELETE ON coprop
    FOR EACH ROW
    EXECUTE PROCEDURE f_ad_coprop();


--
-- Name: ad_gastos; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER ad_gastos
    AFTER DELETE ON gastos
    FOR EACH ROW
    EXECUTE PROCEDURE f_ad_gastos();


--
-- Name: ad_prove; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER ad_prove
    AFTER DELETE ON prove
    FOR EACH ROW
    EXECUTE PROCEDURE f_ad_prove();


--
-- Name: ai_astoctas; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER ai_astoctas
    AFTER INSERT ON astoctas
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_astoctas();


--
-- Name: ai_coprop; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER ai_coprop
    AFTER INSERT ON coprop
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_coprop();


--
-- Name: ai_empresa; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER ai_empresa
    AFTER INSERT ON empresa
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_empresa();


--
-- Name: ai_gastos; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER ai_gastos
    AFTER INSERT ON gastos
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_gastos();


--
-- Name: ai_prove; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER ai_prove
    AFTER INSERT ON prove
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_prove();


--
-- Name: ai_ptovta; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER ai_ptovta
    AFTER INSERT ON ptovta
    FOR EACH ROW
    EXECUTE PROCEDURE f_ai_ptovta();


--
-- Name: au_astoctas; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER au_astoctas
    AFTER UPDATE ON astoctas
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_astoctas();


--
-- Name: au_astoh; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER au_astoh
    AFTER UPDATE ON astoh
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_astoh();


--
-- Name: au_compra; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER au_compra
    AFTER UPDATE ON compra
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_compra();


--
-- Name: au_coprop; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER au_coprop
    AFTER UPDATE ON coprop
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_coprop();


--
-- Name: au_emiti; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER au_emiti
    AFTER UPDATE ON emiti
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_emiti();


--
-- Name: au_gastos; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER au_gastos
    AFTER UPDATE ON gastos
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_gastos();


--
-- Name: au_liquidacion; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER au_liquidacion
    AFTER UPDATE ON liquidacion
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_liquidacion();


--
-- Name: au_prove; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER au_prove
    AFTER UPDATE ON prove
    FOR EACH ROW
    EXECUTE PROCEDURE f_au_prove();


--
-- Name: bd_astoctas; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bd_astoctas
    BEFORE DELETE ON astoctas
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_astoctas();


--
-- Name: bd_astoh; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bd_astoh
    BEFORE DELETE ON astoh
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_astoh();


--
-- Name: bd_coprop; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bd_coprop
    BEFORE DELETE ON coprop
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_coprop();


--
-- Name: bd_emiti; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bd_emiti
    BEFORE DELETE ON emiti
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_emiti();


--
-- Name: bd_gastos; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bd_gastos
    BEFORE DELETE ON gastos
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_gastos();


--
-- Name: bd_liquidacion; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bd_liquidacion
    BEFORE DELETE ON liquidacion
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_liquidacion();


--
-- Name: bd_prove; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bd_prove
    BEFORE DELETE ON prove
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_prove();


--
-- Name: bd_ptovta; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bd_ptovta
    BEFORE DELETE ON ptovta
    FOR EACH ROW
    EXECUTE PROCEDURE f_bd_ptovta();


--
-- Name: bu_astoh; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bu_astoh
    BEFORE UPDATE ON astoh
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_astoh();


--
-- Name: bu_cheques; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bu_cheques
    BEFORE UPDATE ON cheques
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_cheques();


--
-- Name: bu_gastos; Type: TRIGGER; Schema: public; Owner: sanjor
--

CREATE TRIGGER bu_gastos
    AFTER UPDATE ON gastos
    FOR EACH ROW
    EXECUTE PROCEDURE f_bu_gastos();


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cargos
    ADD CONSTRAINT "$1" FOREIGN KEY (car_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$1" FOREIGN KEY (l_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliquid
    ADD CONSTRAINT "$1" FOREIGN KEY (cl_idliq) REFERENCES liquidacion(l_id) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqui
    ADD CONSTRAINT "$1" FOREIGN KEY (lq_idliq) REFERENCES liquidacion(l_id) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$1" FOREIGN KEY (clq_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$1" FOREIGN KEY (cmpr_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY posliq
    ADD CONSTRAINT "$1" FOREIGN KEY (plq_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY auxint
    ADD CONSTRAINT "$1" FOREIGN KEY (ai_idliq) REFERENCES liquidacion(l_id) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$1" FOREIGN KEY (con_codemp) REFERENCES empresa(emp_codigo);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY ctasconv
    ADD CONSTRAINT "$1" FOREIGN KEY (ctc_idconv) REFERENCES convenios(con_id);


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$1" FOREIGN KEY (cbt_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: $1; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$1" FOREIGN KEY (jud_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$2" FOREIGN KEY (l_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqui
    ADD CONSTRAINT "$2" FOREIGN KEY (lq_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$2" FOREIGN KEY (clq_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$2" FOREIGN KEY (cmpr_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY posliq
    ADD CONSTRAINT "$2" FOREIGN KEY (plq_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY auxint
    ADD CONSTRAINT "$2" FOREIGN KEY (ai_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$2" FOREIGN KEY (con_idptov) REFERENCES ptovta(ptv_id);


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$2" FOREIGN KEY (cbt_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: $2; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$2" FOREIGN KEY (jud_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$3" FOREIGN KEY (l_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqui
    ADD CONSTRAINT "$3" FOREIGN KEY (lq_cargo) REFERENCES cargos(car_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$3" FOREIGN KEY (clq_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$3" FOREIGN KEY (cmpr_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY posliq
    ADD CONSTRAINT "$3" FOREIGN KEY (plq_comprob) REFERENCES comprob(comp_id);


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$3" FOREIGN KEY (con_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$3" FOREIGN KEY (cbt_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $3; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$3" FOREIGN KEY (jud_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liquidacion
    ADD CONSTRAINT "$4" FOREIGN KEY (l_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$4" FOREIGN KEY (clq_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$4" FOREIGN KEY (cmpr_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY posliq
    ADD CONSTRAINT "$4" FOREIGN KEY (plq_cargo) REFERENCES cargos(car_id);


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$4" FOREIGN KEY (con_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$4" FOREIGN KEY (cbt_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $4; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$4" FOREIGN KEY (jud_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$5" FOREIGN KEY (clq_comprob) REFERENCES comprob(comp_id);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY comprop
    ADD CONSTRAINT "$5" FOREIGN KEY (cmpr_cargo) REFERENCES cargos(car_id);


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY posliq
    ADD CONSTRAINT "$5" FOREIGN KEY (plq_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$5" FOREIGN KEY (con_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cambtitu
    ADD CONSTRAINT "$5" FOREIGN KEY (cbt_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $5; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$5" FOREIGN KEY (jud_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$6" FOREIGN KEY (clq_cargo) REFERENCES cargos(car_id);


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY convenios
    ADD CONSTRAINT "$6" FOREIGN KEY (con_comprob) REFERENCES comprob(comp_id);


--
-- Name: $6; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$6" FOREIGN KEY (jud_ejcod) REFERENCES estjud(etj_codigo) MATCH FULL;


--
-- Name: $7; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$7" FOREIGN KEY (clq_idcopr) REFERENCES coprop(cop_id) MATCH FULL;


--
-- Name: $7; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY judicial
    ADD CONSTRAINT "$7" FOREIGN KEY (jud_estudio) REFERENCES estjurid(est_codigo) MATCH FULL;


--
-- Name: $8; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compliq
    ADD CONSTRAINT "$8" FOREIGN KEY (clq_cargo) REFERENCES cargos(car_id);


--
-- Name: astoctas_astc_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_astc_codemp_fkey FOREIGN KEY (astc_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: astoctas_astc_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_astc_idastoh_fkey FOREIGN KEY (astc_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: astoctas_astc_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY astoctas
    ADD CONSTRAINT astoctas_astc_idptov_fkey FOREIGN KEY (astc_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: astoh_ash_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_ash_codemp_fkey FOREIGN KEY (ash_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: astoh_ash_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY astoh
    ADD CONSTRAINT astoh_ash_idptov_fkey FOREIGN KEY (ash_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: centroc_cco_coddiv_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_cco_coddiv_fkey FOREIGN KEY (cco_coddiv) REFERENCES division(div_id) MATCH FULL;


--
-- Name: centroc_cco_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_cco_codemp_fkey FOREIGN KEY (cco_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: centroc_cco_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY centroc
    ADD CONSTRAINT centroc_cco_idptov_fkey FOREIGN KEY (cco_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: cheques_chq_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_chq_codemp_fkey FOREIGN KEY (chq_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: cheques_chq_idastoc_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_chq_idastoc_fkey FOREIGN KEY (chq_idastoc) REFERENCES astoctas(astc_id) MATCH FULL;


--
-- Name: cheques_chq_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cheques
    ADD CONSTRAINT cheques_chq_idptov_fkey FOREIGN KEY (chq_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: compra_cpra_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_cpra_codemp_fkey FOREIGN KEY (cpra_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: compra_cpra_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_cpra_idastoh_fkey FOREIGN KEY (cpra_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: compra_cpra_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY compra
    ADD CONSTRAINT compra_cpra_idptov_fkey FOREIGN KEY (cpra_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: coprop_cop_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY coprop
    ADD CONSTRAINT coprop_cop_codemp_fkey FOREIGN KEY (cop_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: coprop_cop_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY coprop
    ADD CONSTRAINT coprop_cop_idptov_fkey FOREIGN KEY (cop_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: cotiza_cot_moneda_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY cotiza
    ADD CONSTRAINT cotiza_cot_moneda_fkey FOREIGN KEY (cot_moneda) REFERENCES moneda(mon_codigo) MATCH FULL;


--
-- Name: division_div_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_div_codemp_fkey FOREIGN KEY (div_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: division_div_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY division
    ADD CONSTRAINT division_div_idptov_fkey FOREIGN KEY (div_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: docum_doc_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_doc_codemp_fkey FOREIGN KEY (doc_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: docum_doc_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY docum
    ADD CONSTRAINT docum_doc_idptov_fkey FOREIGN KEY (doc_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: emiti_emi_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_codemp_fkey FOREIGN KEY (emi_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: emiti_emi_comprob_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_comprob_fkey FOREIGN KEY (emi_comprob) REFERENCES comprob(comp_id) MATCH FULL;


--
-- Name: emiti_emi_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_idastoh_fkey FOREIGN KEY (emi_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: emiti_emi_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY emiti
    ADD CONSTRAINT emiti_emi_idptov_fkey FOREIGN KEY (emi_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: factpend_fap_centro_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_centro_fkey FOREIGN KEY (fap_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: factpend_fap_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_codemp_fkey FOREIGN KEY (fap_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: factpend_fap_division_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_division_fkey FOREIGN KEY (fap_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: factpend_fap_idgto_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_idgto_fkey FOREIGN KEY (fap_idgto) REFERENCES gastos(gto_id) MATCH FULL;


--
-- Name: factpend_fap_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY factpend
    ADD CONSTRAINT factpend_fap_idptov_fkey FOREIGN KEY (fap_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: gastos_gto_centro_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_centro_fkey FOREIGN KEY (gto_centro) REFERENCES centroc(cco_id) MATCH FULL;


--
-- Name: gastos_gto_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_codemp_fkey FOREIGN KEY (gto_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: gastos_gto_division_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_division_fkey FOREIGN KEY (gto_division) REFERENCES division(div_id) MATCH FULL;


--
-- Name: gastos_gto_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_idastoh_fkey FOREIGN KEY (gto_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: gastos_gto_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY gastos
    ADD CONSTRAINT gastos_gto_idptov_fkey FOREIGN KEY (gto_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: gtoxliqe_gxl_gasto_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY gtoxliqe
    ADD CONSTRAINT gtoxliqe_gxl_gasto_fkey FOREIGN KEY (gxl_gasto) REFERENCES gastos(gto_id) MATCH FULL;


--
-- Name: gtoxliqe_gxl_liqegr_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY gtoxliqe
    ADD CONSTRAINT gtoxliqe_gxl_liqegr_fkey FOREIGN KEY (gxl_liqegr) REFERENCES liqegr(eg_id) MATCH FULL;


--
-- Name: interes_int_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_int_codemp_fkey FOREIGN KEY (int_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: interes_int_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY interes
    ADD CONSTRAINT interes_int_idptov_fkey FOREIGN KEY (int_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: liqegr_eg_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_codemp_fkey FOREIGN KEY (eg_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: liqegr_eg_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_idastoh_fkey FOREIGN KEY (eg_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: liqegr_eg_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqegr
    ADD CONSTRAINT liqegr_eg_idptov_fkey FOREIGN KEY (eg_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: liqpdf_lqp_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqpdf
    ADD CONSTRAINT liqpdf_lqp_codemp_fkey FOREIGN KEY (lqp_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: liqpdf_lqp_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liqpdf
    ADD CONSTRAINT liqpdf_lqp_idptov_fkey FOREIGN KEY (lqp_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: liquid_lq_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liquid
    ADD CONSTRAINT liquid_lq_codemp_fkey FOREIGN KEY (lq_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: liquid_lq_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY liquid
    ADD CONSTRAINT liquid_lq_idptov_fkey FOREIGN KEY (lq_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: movsto_movs_artic_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_artic_fkey FOREIGN KEY (movs_artic) REFERENCES articvta(art_id) MATCH FULL;


--
-- Name: movsto_movs_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_codemp_fkey FOREIGN KEY (movs_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: movsto_movs_idastoh_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_idastoh_fkey FOREIGN KEY (movs_idastoh) REFERENCES astoh(ash_id) MATCH FULL;


--
-- Name: movsto_movs_idemiti_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_idemiti_fkey FOREIGN KEY (movs_idemiti) REFERENCES emiti(emi_id) MATCH FULL;


--
-- Name: movsto_movs_idptov_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY movsto
    ADD CONSTRAINT movsto_movs_idptov_fkey FOREIGN KEY (movs_idptov) REFERENCES ptovta(ptv_id) MATCH FULL;


--
-- Name: ptovta_ptv_codemp_fkey; Type: FK CONSTRAINT; Schema: public; Owner: sanjor
--

ALTER TABLE ONLY ptovta
    ADD CONSTRAINT ptovta_ptv_codemp_fkey FOREIGN KEY (ptv_codemp) REFERENCES empresa(emp_codigo) MATCH FULL;


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: articvta; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE articvta FROM PUBLIC;
REVOKE ALL ON TABLE articvta FROM sanjor;
GRANT ALL ON TABLE articvta TO sanjor;
GRANT ALL ON TABLE articvta TO nobody;


--
-- Name: articvta_art_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE articvta_art_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE articvta_art_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE articvta_art_id_seq TO nobody;


--
-- Name: astoctas; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE astoctas FROM PUBLIC;
REVOKE ALL ON TABLE astoctas FROM sanjor;
GRANT ALL ON TABLE astoctas TO sanjor;
GRANT ALL ON TABLE astoctas TO nobody;


--
-- Name: astoctas_astc_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoctas_astc_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE astoctas_astc_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE astoctas_astc_id_seq TO nobody;


--
-- Name: astoh; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE astoh FROM PUBLIC;
REVOKE ALL ON TABLE astoh FROM sanjor;
GRANT ALL ON TABLE astoh TO sanjor;
GRANT ALL ON TABLE astoh TO nobody;


--
-- Name: astoh_ash_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE astoh_ash_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE astoh_ash_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE astoh_ash_id_seq TO nobody;


--
-- Name: auxint; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE auxint FROM PUBLIC;
REVOKE ALL ON TABLE auxint FROM sanjor;
GRANT ALL ON TABLE auxint TO sanjor;
GRANT ALL ON TABLE auxint TO nobody;


--
-- Name: bancos; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE bancos FROM PUBLIC;
REVOKE ALL ON TABLE bancos FROM sanjor;
GRANT ALL ON TABLE bancos TO sanjor;
GRANT ALL ON TABLE bancos TO nobody;


--
-- Name: cambtitu; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE cambtitu FROM PUBLIC;
REVOKE ALL ON TABLE cambtitu FROM sanjor;
GRANT ALL ON TABLE cambtitu TO sanjor;
GRANT ALL ON TABLE cambtitu TO nobody;


--
-- Name: cambtitu_cbt_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE cambtitu_cbt_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cambtitu_cbt_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE cambtitu_cbt_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE cambtitu_cbt_id_seq TO nobody;


--
-- Name: cargos; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE cargos FROM PUBLIC;
REVOKE ALL ON TABLE cargos FROM sanjor;
GRANT ALL ON TABLE cargos TO sanjor;
GRANT ALL ON TABLE cargos TO nobody;


--
-- Name: cargos_car_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE cargos_car_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cargos_car_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE cargos_car_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE cargos_car_id_seq TO nobody;


--
-- Name: catego; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE catego FROM PUBLIC;
REVOKE ALL ON TABLE catego FROM sanjor;
GRANT ALL ON TABLE catego TO sanjor;
GRANT ALL ON TABLE catego TO nobody;


--
-- Name: centroc; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE centroc FROM PUBLIC;
REVOKE ALL ON TABLE centroc FROM sanjor;
GRANT ALL ON TABLE centroc TO sanjor;
GRANT ALL ON TABLE centroc TO nobody;


--
-- Name: centroc_cco_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE centroc_cco_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE centroc_cco_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE centroc_cco_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE centroc_cco_id_seq TO nobody;


--
-- Name: cheques; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE cheques FROM PUBLIC;
REVOKE ALL ON TABLE cheques FROM sanjor;
GRANT ALL ON TABLE cheques TO sanjor;
GRANT ALL ON TABLE cheques TO nobody;


--
-- Name: cheques_chq_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE cheques_chq_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE cheques_chq_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE cheques_chq_id_seq TO nobody;


--
-- Name: chqrech; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE chqrech FROM PUBLIC;
REVOKE ALL ON TABLE chqrech FROM sanjor;
GRANT ALL ON TABLE chqrech TO sanjor;
GRANT ALL ON TABLE chqrech TO nobody;


--
-- Name: chqrech_chqr_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE chqrech_chqr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE chqrech_chqr_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE chqrech_chqr_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE chqrech_chqr_id_seq TO nobody;


--
-- Name: compliq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE compliq FROM PUBLIC;
REVOKE ALL ON TABLE compliq FROM sanjor;
GRANT ALL ON TABLE compliq TO sanjor;
GRANT ALL ON TABLE compliq TO nobody;


--
-- Name: compliq_clq_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE compliq_clq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compliq_clq_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE compliq_clq_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE compliq_clq_id_seq TO nobody;


--
-- Name: compliquid; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE compliquid FROM PUBLIC;
REVOKE ALL ON TABLE compliquid FROM sanjor;
GRANT ALL ON TABLE compliquid TO sanjor;
GRANT ALL ON TABLE compliquid TO nobody;


--
-- Name: compliquid_cl_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE compliquid_cl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compliquid_cl_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE compliquid_cl_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE compliquid_cl_id_seq TO nobody;


--
-- Name: compra; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE compra FROM PUBLIC;
REVOKE ALL ON TABLE compra FROM sanjor;
GRANT ALL ON TABLE compra TO sanjor;
GRANT ALL ON TABLE compra TO nobody;


--
-- Name: compra_cpra_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE compra_cpra_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE compra_cpra_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE compra_cpra_id_seq TO nobody;


--
-- Name: comprob; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE comprob FROM PUBLIC;
REVOKE ALL ON TABLE comprob FROM sanjor;
GRANT ALL ON TABLE comprob TO sanjor;
GRANT ALL ON TABLE comprob TO nobody;


--
-- Name: comprob_comp_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE comprob_comp_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE comprob_comp_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE comprob_comp_id_seq TO nobody;


--
-- Name: comprop; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE comprop FROM PUBLIC;
REVOKE ALL ON TABLE comprop FROM sanjor;
GRANT ALL ON TABLE comprop TO sanjor;
GRANT ALL ON TABLE comprop TO nobody;


--
-- Name: comprop_cmpr_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE comprop_cmpr_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE comprop_cmpr_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE comprop_cmpr_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE comprop_cmpr_id_seq TO nobody;


--
-- Name: coniva; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE coniva FROM PUBLIC;
REVOKE ALL ON TABLE coniva FROM sanjor;
GRANT ALL ON TABLE coniva TO sanjor;
GRANT ALL ON TABLE coniva TO nobody;


--
-- Name: conpag; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE conpag FROM PUBLIC;
REVOKE ALL ON TABLE conpag FROM sanjor;
GRANT ALL ON TABLE conpag TO sanjor;
GRANT ALL ON TABLE conpag TO nobody;


--
-- Name: convenios; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE convenios FROM PUBLIC;
REVOKE ALL ON TABLE convenios FROM sanjor;
GRANT ALL ON TABLE convenios TO sanjor;
GRANT ALL ON TABLE convenios TO nobody;


--
-- Name: convenios_con_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE convenios_con_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE convenios_con_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE convenios_con_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE convenios_con_id_seq TO nobody;


--
-- Name: coprop; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE coprop FROM PUBLIC;
REVOKE ALL ON TABLE coprop FROM sanjor;
GRANT ALL ON TABLE coprop TO sanjor;
GRANT ALL ON TABLE coprop TO nobody;


--
-- Name: coprop_cop_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE coprop_cop_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE coprop_cop_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE coprop_cop_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE coprop_cop_id_seq TO nobody;


--
-- Name: cotiza; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE cotiza FROM PUBLIC;
REVOKE ALL ON TABLE cotiza FROM sanjor;
GRANT ALL ON TABLE cotiza TO sanjor;
GRANT ALL ON TABLE cotiza TO nobody;


--
-- Name: ctacble; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE ctacble FROM PUBLIC;
REVOKE ALL ON TABLE ctacble FROM sanjor;
GRANT ALL ON TABLE ctacble TO sanjor;
GRANT ALL ON TABLE ctacble TO nobody;


--
-- Name: ctacble_cbl_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctacble_cbl_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE ctacble_cbl_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE ctacble_cbl_id_seq TO nobody;


--
-- Name: ctasconv; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE ctasconv FROM PUBLIC;
REVOKE ALL ON TABLE ctasconv FROM sanjor;
GRANT ALL ON TABLE ctasconv TO sanjor;
GRANT ALL ON TABLE ctasconv TO nobody;


--
-- Name: ctasconv_ctc_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE ctasconv_ctc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctasconv_ctc_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE ctasconv_ctc_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE ctasconv_ctc_id_seq TO nobody;


--
-- Name: ctes; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE ctes FROM PUBLIC;
REVOKE ALL ON TABLE ctes FROM sanjor;
GRANT ALL ON TABLE ctes TO sanjor;
GRANT ALL ON TABLE ctes TO nobody;


--
-- Name: ctes_cte_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ctes_cte_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE ctes_cte_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE ctes_cte_id_seq TO nobody;


--
-- Name: division; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE division FROM PUBLIC;
REVOKE ALL ON TABLE division FROM sanjor;
GRANT ALL ON TABLE division TO sanjor;
GRANT ALL ON TABLE division TO nobody;


--
-- Name: division_div_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE division_div_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE division_div_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE division_div_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE division_div_id_seq TO nobody;


--
-- Name: docum; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE docum FROM PUBLIC;
REVOKE ALL ON TABLE docum FROM sanjor;
GRANT ALL ON TABLE docum TO sanjor;
GRANT ALL ON TABLE docum TO nobody;


--
-- Name: docum_doc_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE docum_doc_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE docum_doc_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE docum_doc_id_seq TO nobody;


--
-- Name: emiti; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE emiti FROM PUBLIC;
REVOKE ALL ON TABLE emiti FROM sanjor;
GRANT ALL ON TABLE emiti TO sanjor;
GRANT ALL ON TABLE emiti TO nobody;


--
-- Name: emiti_emi_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE emiti_emi_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE emiti_emi_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE emiti_emi_id_seq TO nobody;


--
-- Name: empresa; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE empresa FROM PUBLIC;
REVOKE ALL ON TABLE empresa FROM sanjor;
GRANT ALL ON TABLE empresa TO sanjor;
GRANT ALL ON TABLE empresa TO nobody;


--
-- Name: entidad; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE entidad FROM PUBLIC;
REVOKE ALL ON TABLE entidad FROM sanjor;
GRANT ALL ON TABLE entidad TO sanjor;
GRANT ALL ON TABLE entidad TO nobody;


--
-- Name: entidad_ent_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE entidad_ent_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE entidad_ent_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE entidad_ent_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE entidad_ent_id_seq TO nobody;


--
-- Name: estjud; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE estjud FROM PUBLIC;
REVOKE ALL ON TABLE estjud FROM sanjor;
GRANT ALL ON TABLE estjud TO sanjor;
GRANT ALL ON TABLE estjud TO nobody;


--
-- Name: estjurid; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE estjurid FROM PUBLIC;
REVOKE ALL ON TABLE estjurid FROM sanjor;
GRANT ALL ON TABLE estjurid TO sanjor;
GRANT ALL ON TABLE estjurid TO nobody;


--
-- Name: factpend; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE factpend FROM PUBLIC;
REVOKE ALL ON TABLE factpend FROM sanjor;
GRANT ALL ON TABLE factpend TO sanjor;
GRANT ALL ON TABLE factpend TO nobody;


--
-- Name: factpend_fap_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE factpend_fap_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE factpend_fap_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE factpend_fap_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE factpend_fap_id_seq TO nobody;


--
-- Name: firman; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE firman FROM PUBLIC;
REVOKE ALL ON TABLE firman FROM sanjor;
GRANT ALL ON TABLE firman TO sanjor;
GRANT ALL ON TABLE firman TO nobody;


--
-- Name: firman_fir_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE firman_fir_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE firman_fir_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE firman_fir_id_seq TO nobody;


--
-- Name: gastos; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE gastos FROM PUBLIC;
REVOKE ALL ON TABLE gastos FROM sanjor;
GRANT ALL ON TABLE gastos TO sanjor;
GRANT ALL ON TABLE gastos TO nobody;


--
-- Name: gastos_gto_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE gastos_gto_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE gastos_gto_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE gastos_gto_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE gastos_gto_id_seq TO nobody;


--
-- Name: grupos; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE grupos FROM PUBLIC;
REVOKE ALL ON TABLE grupos FROM sanjor;
GRANT ALL ON TABLE grupos TO sanjor;
GRANT ALL ON TABLE grupos TO nobody;


--
-- Name: gtoxliqe; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE gtoxliqe FROM PUBLIC;
REVOKE ALL ON TABLE gtoxliqe FROM sanjor;
GRANT ALL ON TABLE gtoxliqe TO sanjor;
GRANT ALL ON TABLE gtoxliqe TO nobody;


--
-- Name: honorarios; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE honorarios FROM PUBLIC;
REVOKE ALL ON TABLE honorarios FROM sanjor;
GRANT ALL ON TABLE honorarios TO sanjor;
GRANT ALL ON TABLE honorarios TO nobody;


--
-- Name: honorarios_hon_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE honorarios_hon_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE honorarios_hon_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE honorarios_hon_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE honorarios_hon_id_seq TO nobody;


--
-- Name: impresiones; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE impresiones FROM PUBLIC;
REVOKE ALL ON TABLE impresiones FROM sanjor;
GRANT ALL ON TABLE impresiones TO sanjor;
GRANT ALL ON TABLE impresiones TO nobody;


--
-- Name: interes; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE interes FROM PUBLIC;
REVOKE ALL ON TABLE interes FROM sanjor;
GRANT ALL ON TABLE interes TO sanjor;
GRANT ALL ON TABLE interes TO nobody;


--
-- Name: judicial; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE judicial FROM PUBLIC;
REVOKE ALL ON TABLE judicial FROM sanjor;
GRANT ALL ON TABLE judicial TO sanjor;
GRANT ALL ON TABLE judicial TO nobody;


--
-- Name: judicial_jud_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE judicial_jud_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE judicial_jud_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE judicial_jud_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE judicial_jud_id_seq TO nobody;


--
-- Name: liqegr; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE liqegr FROM PUBLIC;
REVOKE ALL ON TABLE liqegr FROM sanjor;
GRANT ALL ON TABLE liqegr TO sanjor;
GRANT ALL ON TABLE liqegr TO nobody;


--
-- Name: liqegr_eg_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE liqegr_eg_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE liqegr_eg_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE liqegr_eg_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE liqegr_eg_id_seq TO nobody;


--
-- Name: liqpdf; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE liqpdf FROM PUBLIC;
REVOKE ALL ON TABLE liqpdf FROM sanjor;
GRANT ALL ON TABLE liqpdf TO sanjor;
GRANT ALL ON TABLE liqpdf TO nobody;


--
-- Name: liqpdf_lqp_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE liqpdf_lqp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE liqpdf_lqp_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE liqpdf_lqp_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE liqpdf_lqp_id_seq TO nobody;


--
-- Name: liqui; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE liqui FROM PUBLIC;
REVOKE ALL ON TABLE liqui FROM sanjor;
GRANT ALL ON TABLE liqui TO sanjor;
GRANT ALL ON TABLE liqui TO nobody;


--
-- Name: liquid; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE liquid FROM PUBLIC;
REVOKE ALL ON TABLE liquid FROM sanjor;
GRANT ALL ON TABLE liquid TO sanjor;
GRANT ALL ON TABLE liquid TO nobody;


--
-- Name: liquidacion; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE liquidacion FROM PUBLIC;
REVOKE ALL ON TABLE liquidacion FROM sanjor;
GRANT ALL ON TABLE liquidacion TO sanjor;
GRANT ALL ON TABLE liquidacion TO nobody;


--
-- Name: liquidacion_l_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE liquidacion_l_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE liquidacion_l_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE liquidacion_l_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE liquidacion_l_id_seq TO nobody;


--
-- Name: listpre; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE listpre FROM PUBLIC;
REVOKE ALL ON TABLE listpre FROM sanjor;
GRANT ALL ON TABLE listpre TO sanjor;
GRANT ALL ON TABLE listpre TO nobody;


--
-- Name: listpre_ltp_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE listpre_ltp_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE listpre_ltp_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE listpre_ltp_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE listpre_ltp_id_seq TO nobody;


--
-- Name: moneda; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE moneda FROM PUBLIC;
REVOKE ALL ON TABLE moneda FROM sanjor;
GRANT ALL ON TABLE moneda TO sanjor;
GRANT ALL ON TABLE moneda TO nobody;


--
-- Name: monex; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE monex FROM PUBLIC;
REVOKE ALL ON TABLE monex FROM sanjor;
GRANT ALL ON TABLE monex TO sanjor;
GRANT ALL ON TABLE monex TO nobody;


--
-- Name: monex_mne_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE monex_mne_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE monex_mne_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE monex_mne_id_seq TO nobody;


--
-- Name: movsto; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE movsto FROM PUBLIC;
REVOKE ALL ON TABLE movsto FROM sanjor;
GRANT ALL ON TABLE movsto TO sanjor;
GRANT ALL ON TABLE movsto TO nobody;


--
-- Name: movsto_movs_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movsto_movs_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE movsto_movs_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE movsto_movs_id_seq TO nobody;


--
-- Name: movstoc; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE movstoc FROM PUBLIC;
REVOKE ALL ON TABLE movstoc FROM sanjor;
GRANT ALL ON TABLE movstoc TO sanjor;
GRANT ALL ON TABLE movstoc TO nobody;


--
-- Name: movstoc_movc_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE movstoc_movc_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE movstoc_movc_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE movstoc_movc_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE movstoc_movc_id_seq TO nobody;


--
-- Name: notdeb; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE notdeb FROM PUBLIC;
REVOKE ALL ON TABLE notdeb FROM sanjor;
GRANT ALL ON TABLE notdeb TO sanjor;
GRANT ALL ON TABLE notdeb TO nobody;


--
-- Name: notdeb_nd_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE notdeb_nd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE notdeb_nd_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE notdeb_nd_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE notdeb_nd_id_seq TO nobody;


--
-- Name: noticias; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE noticias FROM PUBLIC;
REVOKE ALL ON TABLE noticias FROM sanjor;
GRANT ALL ON TABLE noticias TO sanjor;
GRANT ALL ON TABLE noticias TO nobody;


--
-- Name: noticias_not_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE noticias_not_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE noticias_not_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE noticias_not_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE noticias_not_id_seq TO nobody;


--
-- Name: operadores; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE operadores FROM PUBLIC;
REVOKE ALL ON TABLE operadores FROM sanjor;
GRANT ALL ON TABLE operadores TO sanjor;
GRANT ALL ON TABLE operadores TO nobody;


--
-- Name: operadores_operad_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE operadores_operad_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE operadores_operad_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE operadores_operad_id_seq TO nobody;


--
-- Name: pais; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE pais FROM PUBLIC;
REVOKE ALL ON TABLE pais FROM sanjor;
GRANT ALL ON TABLE pais TO sanjor;
GRANT ALL ON TABLE pais TO nobody;


--
-- Name: posliq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE posliq FROM PUBLIC;
REVOKE ALL ON TABLE posliq FROM sanjor;
GRANT ALL ON TABLE posliq TO sanjor;
GRANT ALL ON TABLE posliq TO nobody;


--
-- Name: posliq_plq_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE posliq_plq_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE posliq_plq_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE posliq_plq_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE posliq_plq_id_seq TO nobody;


--
-- Name: prove; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE prove FROM PUBLIC;
REVOKE ALL ON TABLE prove FROM sanjor;
GRANT ALL ON TABLE prove TO sanjor;
GRANT ALL ON TABLE prove TO nobody;


--
-- Name: prove_prov_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE prove_prov_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE prove_prov_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE prove_prov_id_seq TO nobody;


--
-- Name: provin; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE provin FROM PUBLIC;
REVOKE ALL ON TABLE provin FROM sanjor;
GRANT ALL ON TABLE provin TO sanjor;
GRANT ALL ON TABLE provin TO nobody;


--
-- Name: ptovta; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE ptovta FROM PUBLIC;
REVOKE ALL ON TABLE ptovta FROM sanjor;
GRANT ALL ON TABLE ptovta TO sanjor;
GRANT ALL ON TABLE ptovta TO nobody;


--
-- Name: ptovta_ptv_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE ptovta_ptv_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE ptovta_ptv_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE ptovta_ptv_id_seq TO nobody;


--
-- Name: rubcar; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE rubcar FROM PUBLIC;
REVOKE ALL ON TABLE rubcar FROM sanjor;
GRANT ALL ON TABLE rubcar TO sanjor;
GRANT ALL ON TABLE rubcar TO nobody;


--
-- Name: rubcar_rubl_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE rubcar_rubl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rubcar_rubl_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE rubcar_rubl_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE rubcar_rubl_id_seq TO nobody;


--
-- Name: rubros; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE rubros FROM PUBLIC;
REVOKE ALL ON TABLE rubros FROM sanjor;
GRANT ALL ON TABLE rubros TO sanjor;
GRANT ALL ON TABLE rubros TO nobody;


--
-- Name: rubros_rub_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE rubros_rub_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE rubros_rub_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE rubros_rub_id_seq TO nobody;


--
-- Name: seccion; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE seccion FROM PUBLIC;
REVOKE ALL ON TABLE seccion FROM sanjor;
GRANT ALL ON TABLE seccion TO sanjor;
GRANT ALL ON TABLE seccion TO nobody;


--
-- Name: srubcar; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE srubcar FROM PUBLIC;
REVOKE ALL ON TABLE srubcar FROM sanjor;
GRANT ALL ON TABLE srubcar TO sanjor;
GRANT ALL ON TABLE srubcar TO nobody;


--
-- Name: srubcar_srbl_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE srubcar_srbl_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE srubcar_srbl_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE srubcar_srbl_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE srubcar_srbl_id_seq TO nobody;


--
-- Name: subd; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE subd FROM PUBLIC;
REVOKE ALL ON TABLE subd FROM sanjor;
GRANT ALL ON TABLE subd TO sanjor;
GRANT ALL ON TABLE subd TO nobody;


--
-- Name: subd_subd_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subd_subd_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE subd_subd_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE subd_subd_id_seq TO nobody;


--
-- Name: subrub; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE subrub FROM PUBLIC;
REVOKE ALL ON TABLE subrub FROM sanjor;
GRANT ALL ON TABLE subrub TO sanjor;
GRANT ALL ON TABLE subrub TO nobody;


--
-- Name: subrub_srb_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE subrub_srb_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE subrub_srb_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE subrub_srb_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE subrub_srb_id_seq TO nobody;


--
-- Name: sucursal; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE sucursal FROM PUBLIC;
REVOKE ALL ON TABLE sucursal FROM sanjor;
GRANT ALL ON TABLE sucursal TO sanjor;
GRANT ALL ON TABLE sucursal TO nobody;


--
-- Name: talon; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE talon FROM PUBLIC;
REVOKE ALL ON TABLE talon FROM sanjor;
GRANT ALL ON TABLE talon TO sanjor;
GRANT ALL ON TABLE talon TO nobody;


--
-- Name: talon_tal_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE talon_tal_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE talon_tal_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE talon_tal_id_seq TO nobody;


--
-- Name: telefon; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE telefon FROM PUBLIC;
REVOKE ALL ON TABLE telefon FROM sanjor;
GRANT ALL ON TABLE telefon TO sanjor;
GRANT ALL ON TABLE telefon TO nobody;


--
-- Name: telefon_tel_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE telefon_tel_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE telefon_tel_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE telefon_tel_id_seq TO nobody;


--
-- Name: tipcta; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE tipcta FROM PUBLIC;
REVOKE ALL ON TABLE tipcta FROM sanjor;
GRANT ALL ON TABLE tipcta TO sanjor;
GRANT ALL ON TABLE tipcta TO nobody;


--
-- Name: tipdocu; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE tipdocu FROM PUBLIC;
REVOKE ALL ON TABLE tipdocu FROM sanjor;
GRANT ALL ON TABLE tipdocu TO sanjor;
GRANT ALL ON TABLE tipdocu TO nobody;


--
-- Name: tipemp; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE tipemp FROM PUBLIC;
REVOKE ALL ON TABLE tipemp FROM sanjor;
GRANT ALL ON TABLE tipemp TO sanjor;
GRANT ALL ON TABLE tipemp TO nobody;


--
-- Name: tipempr; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE tipempr FROM PUBLIC;
REVOKE ALL ON TABLE tipempr FROM sanjor;
GRANT ALL ON TABLE tipempr TO sanjor;
GRANT ALL ON TABLE tipempr TO nobody;


--
-- Name: tipentid; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE tipentid FROM PUBLIC;
REVOKE ALL ON TABLE tipentid FROM sanjor;
GRANT ALL ON TABLE tipentid TO sanjor;
GRANT ALL ON TABLE tipentid TO nobody;


--
-- Name: tipnot; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE tipnot FROM PUBLIC;
REVOKE ALL ON TABLE tipnot FROM sanjor;
GRANT ALL ON TABLE tipnot TO sanjor;
GRANT ALL ON TABLE tipnot TO nobody;


--
-- Name: tiptel; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE tiptel FROM PUBLIC;
REVOKE ALL ON TABLE tiptel FROM sanjor;
GRANT ALL ON TABLE tiptel TO sanjor;
GRANT ALL ON TABLE tiptel TO nobody;


--
-- Name: tipuf; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE tipuf FROM PUBLIC;
REVOKE ALL ON TABLE tipuf FROM sanjor;
GRANT ALL ON TABLE tipuf TO sanjor;
GRANT ALL ON TABLE tipuf TO nobody;


--
-- Name: varamb; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE varamb FROM PUBLIC;
REVOKE ALL ON TABLE varamb FROM sanjor;
GRANT ALL ON TABLE varamb TO sanjor;
GRANT ALL ON TABLE varamb TO nobody;


--
-- Name: varambi; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE varambi FROM PUBLIC;
REVOKE ALL ON TABLE varambi FROM sanjor;
GRANT ALL ON TABLE varambi TO sanjor;
GRANT ALL ON TABLE varambi TO nobody;


--
-- Name: vendedor; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE vendedor FROM PUBLIC;
REVOKE ALL ON TABLE vendedor FROM sanjor;
GRANT ALL ON TABLE vendedor TO sanjor;
GRANT ALL ON TABLE vendedor TO nobody;


--
-- Name: vendedor_ven_id_seq; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON SEQUENCE vendedor_ven_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE vendedor_ven_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE vendedor_ven_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE vendedor_ven_id_seq TO nobody;


--
-- Name: zona; Type: ACL; Schema: public; Owner: sanjor
--

REVOKE ALL ON TABLE zona FROM PUBLIC;
REVOKE ALL ON TABLE zona FROM sanjor;
GRANT ALL ON TABLE zona TO sanjor;
GRANT ALL ON TABLE zona TO nobody;


--
-- PostgreSQL database dump complete
--

