<?php

/**DOC:results.php
   ---------------------------------------------------------------------- 

    HTMLPrintPreamble()
	Imprime la cabecera, hasta el <body> inclusive
	Usa $config_HTMLTITLE y $config_HTMLBACKGROUND
    HTMLPrintHeader()
	Imprime una cabecera visible, con datos de la sesion,
	etc.
    HTMLPrintFooter($displaycounter)
	Imprime un pie de pagina
    _echo($string)
	Imprime $string si la variable global OUTPUT es
	distinto de "quiet" (para que HTMLPrint... no perturbe
	la salida CSV, entre otras)
    PrintMenu($menuid)
	Lee un menu de la tabla menus 

*/

class Encoding {

  const ICONV_TRANSLIT = "TRANSLIT";
  const ICONV_IGNORE = "IGNORE";
  const WITHOUT_ICONV = "";

  protected static $win1252ToUtf8 = array(
        128 => "\xe2\x82\xac",

        130 => "\xe2\x80\x9a",
        131 => "\xc6\x92",
        132 => "\xe2\x80\x9e",
        133 => "\xe2\x80\xa6",
        134 => "\xe2\x80\xa0",
        135 => "\xe2\x80\xa1",
        136 => "\xcb\x86",
        137 => "\xe2\x80\xb0",
        138 => "\xc5\xa0",
        139 => "\xe2\x80\xb9",
        140 => "\xc5\x92",

        142 => "\xc5\xbd",


        145 => "\xe2\x80\x98",
        146 => "\xe2\x80\x99",
        147 => "\xe2\x80\x9c",
        148 => "\xe2\x80\x9d",
        149 => "\xe2\x80\xa2",
        150 => "\xe2\x80\x93",
        151 => "\xe2\x80\x94",
        152 => "\xcb\x9c",
        153 => "\xe2\x84\xa2",
        154 => "\xc5\xa1",
        155 => "\xe2\x80\xba",
        156 => "\xc5\x93",

        158 => "\xc5\xbe",
        159 => "\xc5\xb8"
  );

    protected static $brokenUtf8ToUtf8 = array(
        "\xc2\x80" => "\xe2\x82\xac",

        "\xc2\x82" => "\xe2\x80\x9a",
        "\xc2\x83" => "\xc6\x92",
        "\xc2\x84" => "\xe2\x80\x9e",
        "\xc2\x85" => "\xe2\x80\xa6",
        "\xc2\x86" => "\xe2\x80\xa0",
        "\xc2\x87" => "\xe2\x80\xa1",
        "\xc2\x88" => "\xcb\x86",
        "\xc2\x89" => "\xe2\x80\xb0",
        "\xc2\x8a" => "\xc5\xa0",
        "\xc2\x8b" => "\xe2\x80\xb9",
        "\xc2\x8c" => "\xc5\x92",

        "\xc2\x8e" => "\xc5\xbd",


        "\xc2\x91" => "\xe2\x80\x98",
        "\xc2\x92" => "\xe2\x80\x99",
        "\xc2\x93" => "\xe2\x80\x9c",
        "\xc2\x94" => "\xe2\x80\x9d",
        "\xc2\x95" => "\xe2\x80\xa2",
        "\xc2\x96" => "\xe2\x80\x93",
        "\xc2\x97" => "\xe2\x80\x94",
        "\xc2\x98" => "\xcb\x9c",
        "\xc2\x99" => "\xe2\x84\xa2",
        "\xc2\x9a" => "\xc5\xa1",
        "\xc2\x9b" => "\xe2\x80\xba",
        "\xc2\x9c" => "\xc5\x93",

        "\xc2\x9e" => "\xc5\xbe",
        "\xc2\x9f" => "\xc5\xb8"
  );

  protected static $utf8ToWin1252 = array(
       "\xe2\x82\xac" => "\x80",

       "\xe2\x80\x9a" => "\x82",
       "\xc6\x92"     => "\x83",
       "\xe2\x80\x9e" => "\x84",
       "\xe2\x80\xa6" => "\x85",
       "\xe2\x80\xa0" => "\x86",
       "\xe2\x80\xa1" => "\x87",
       "\xcb\x86"     => "\x88",
       "\xe2\x80\xb0" => "\x89",
       "\xc5\xa0"     => "\x8a",
       "\xe2\x80\xb9" => "\x8b",
       "\xc5\x92"     => "\x8c",

       "\xc5\xbd"     => "\x8e",


       "\xe2\x80\x98" => "\x91",
       "\xe2\x80\x99" => "\x92",
       "\xe2\x80\x9c" => "\x93",
       "\xe2\x80\x9d" => "\x94",
       "\xe2\x80\xa2" => "\x95",
       "\xe2\x80\x93" => "\x96",
       "\xe2\x80\x94" => "\x97",
       "\xcb\x9c"     => "\x98",
       "\xe2\x84\xa2" => "\x99",
       "\xc5\xa1"     => "\x9a",
       "\xe2\x80\xba" => "\x9b",
       "\xc5\x93"     => "\x9c",

       "\xc5\xbe"     => "\x9e",
       "\xc5\xb8"     => "\x9f"
    );

  /**
   * Function \ForceUTF8\Encoding::toUTF8
   *
   * This function leaves UTF8 characters alone, while converting almost all non-UTF8 to UTF8.
   *
   * It assumes that the encoding of the original string is either Windows-1252 or ISO 8859-1.
   *
   * It may fail to convert characters to UTF-8 if they fall into one of these scenarios:
   *
   * 1) when any of these characters:   
   *    are followed by any of these:  ("group B")
   *                                    ¡¢£¤¥¦§¨©ª«¬­®¯°±²³´µ¶¸¹º»¼½¾¿
   * For example:   %ABREPRESENT%C9%BB. «REPRESENT»
   * The "«" (%AB) character will be converted, but the "" followed by "»" (%C9%BB)
   * is also a valid unicode character, and will be left unchanged.
   *
   * 2) when any of these: àáâãäåæçèéêëìíîï  are followed by TWO chars from group B,
   * 3) when any of these: ðñòó  are followed by THREE chars from group B.
   *
   * @param string|array $text  Any string.
   * @return string|array  The same string, UTF8 encoded
   *
   */
  public static function toUTF8($text)
  {

    if(is_array($text))
    {
      foreach($text as $k => $v)
      {
        $text[$k] = self::toUTF8($v);
      }
      return $text;
    }

    if(!is_string($text)) {
      return $text;
    }

    $max = self::strlen($text);

    $buf = "";
    for($i = 0; $i < $max; $i++){
        $c1 = $text[$i];
        if($c1>="\xc0"){ //Should be converted to UTF8, if it's not UTF8 already
          $c2 = $i+1 >= $max? "\x00" : $text[$i+1];
          $c3 = $i+2 >= $max? "\x00" : $text[$i+2];
          $c4 = $i+3 >= $max? "\x00" : $text[$i+3];
            if($c1 >= "\xc0" & $c1 <= "\xdf"){ //looks like 2 bytes UTF8
                if($c2 >= "\x80" && $c2 <= "\xbf"){ //yeah, almost sure it's UTF8 already
                    $buf .= $c1 . $c2;
                    $i++;
                } else { //not valid UTF8.  Convert it.
                    $cc1 = (chr(intdiv(ord($c1), 64)) | "\xc0");
                    $cc2 = ($c1 & "\x3f") | "\x80";
                    $buf .= $cc1 . $cc2;
                }
            } elseif($c1 >= "\xe0" & $c1 <= "\xef"){ //looks like 3 bytes UTF8
                if($c2 >= "\x80" && $c2 <= "\xbf" && $c3 >= "\x80" && $c3 <= "\xbf"){ //yeah, almost sure it's UTF8 already
                    $buf .= $c1 . $c2 . $c3;
                    $i = $i + 2;
                } else { //not valid UTF8.  Convert it.
                    $cc1 = (chr(intdiv(ord($c1), 64)) | "\xc0");
                    $cc2 = ($c1 & "\x3f") | "\x80";
                    $buf .= $cc1 . $cc2;
                }
            } elseif($c1 >= "\xf0" & $c1 <= "\xf7"){ //looks like 4 bytes UTF8
                if($c2 >= "\x80" && $c2 <= "\xbf" && $c3 >= "\x80" && $c3 <= "\xbf" && $c4 >= "\x80" && $c4 <= "\xbf"){ //yeah, almost sure it's UTF8 already
                    $buf .= $c1 . $c2 . $c3 . $c4;
                    $i = $i + 3;
                } else { //not valid UTF8.  Convert it.
                    $cc1 = (chr(intdiv(ord($c1), 64)) | "\xc0");
                    $cc2 = ($c1 & "\x3f") | "\x80";
                    $buf .= $cc1 . $cc2;
                }
            } else { //doesn't look like UTF8, but should be converted
                    $cc1 = (chr(intdiv(ord($c1), 64)) | "\xc0");
                    $cc2 = (($c1 & "\x3f") | "\x80");
                    $buf .= $cc1 . $cc2;
            }
        } elseif(($c1 & "\xc0") === "\x80"){ // needs conversion
              if(isset(self::$win1252ToUtf8[ord($c1)])) { //found in Windows-1252 special cases
                  $buf .= self::$win1252ToUtf8[ord($c1)];
              } else {
                $cc1 = (chr(intdiv(ord($c1), 64)) | "\xc0");
                $cc2 = (($c1 & "\x3f") | "\x80");
                $buf .= $cc1 . $cc2;
              }
        } else { // it doesn't need conversion
            $buf .= $c1;
        }
    }
    return $buf;
  }

  public static function toWin1252($text, $option = self::WITHOUT_ICONV) {
    if(is_array($text)) {
      foreach($text as $k => $v) {
        $text[$k] = self::toWin1252($v, $option);
      }
      return $text;
    } elseif(is_string($text)) {
      return static::utf8_decode($text, $option);
    } else {
      return $text;
    }
  }

  public static function toISO8859($text, $option = self::WITHOUT_ICONV) {
    return self::toWin1252($text, $option);
  }

  public static function toLatin1($text, $option = self::WITHOUT_ICONV) {
    return self::toWin1252($text, $option);
  }

  public static function fixUTF8($text, $option = self::WITHOUT_ICONV){
    if(is_array($text)) {
      foreach($text as $k => $v) {
        $text[$k] = self::fixUTF8($v, $option);
      }
      return $text;
    }

    if(!is_string($text)) {
      return $text;
    }

    $last = "";
    while($last <> $text){
      $last = $text;
      $text = self::toUTF8(static::utf8_decode($text, $option));
    }
    return self::toUTF8(static::utf8_decode($text, $option));
  }

  public static function UTF8FixWin1252Chars($text){
    // If you received an UTF-8 string that was converted from Windows-1252 as it was ISO8859-1
    // (ignoring Windows-1252 chars from 80 to 9F) use this function to fix it.
    // See: http://en.wikipedia.org/wiki/Windows-1252

    return str_replace(array_keys(self::$brokenUtf8ToUtf8), array_values(self::$brokenUtf8ToUtf8), $text);
  }

  public static function removeBOM($str=""){
    if(substr($str, 0,3) === pack("CCC",0xef,0xbb,0xbf)) {
      $str=substr($str, 3);
    }
    return $str;
  }

  protected static function strlen($text){
    return (function_exists('mb_strlen') && ((int) ini_get('mbstring.func_overload')) & 2) ?
           mb_strlen($text,'8bit') : strlen($text);
  }

  public static function normalizeEncoding($encodingLabel): string
  {
    $encoding = strtoupper($encodingLabel);
    $encoding = preg_replace('/[^a-zA-Z0-9\s]/', '', $encoding);
    $equivalences = array(
        'ISO88591' => 'ISO-8859-1',
        'ISO8859'  => 'ISO-8859-1',
        'ISO'      => 'ISO-8859-1',
        'LATIN1'   => 'ISO-8859-1',
        'LATIN'    => 'ISO-8859-1',
        'UTF8'     => 'UTF-8',
        'UTF'      => 'UTF-8',
        'WIN1252'  => 'ISO-8859-1',
        'WINDOWS1252' => 'ISO-8859-1'
    );

    if(empty($equivalences[$encoding])){
      return 'UTF-8';
    }

    return $equivalences[$encoding];
  }

  public static function encode($encodingLabel, $text)
  {
    $encodingLabel = self::normalizeEncoding($encodingLabel);
    if($encodingLabel === 'ISO-8859-1') return self::toLatin1($text);
    return self::toUTF8($text);
  }

  protected static function utf8_decode($text, $option = self::WITHOUT_ICONV)
  {
    if ($option == self::WITHOUT_ICONV || !function_exists('iconv')) {
      $utf8 = str_replace(array_keys(self::$utf8ToWin1252), array_values(self::$utf8ToWin1252), self::toUTF8($text));
      if (function_exists('mb_convert_encoding')) {
        $o = mb_convert_encoding($utf8, 'Windows-1252', 'UTF-8');
      } else {
        $o = utf8_decode($utf8);
      }
    } else {
      $o = iconv("UTF-8", "Windows-1252" . ($option === self::ICONV_TRANSLIT ? '//TRANSLIT' : ($option === self::ICONV_IGNORE ? '//IGNORE' : '')), $text);
    }
    return $o;
  }
}


Function Decode($string)
{

    $string=Encoding::toLatin1($string);
    $string=Encoding::fixUTF8($string);
    return $string;
}


Function Inicio()
{
    _echo ("<HTML>");
    _echo ("<head>");
    _echo ("<link rel=\"stylesheet\" href=\"../estilo.inc\"></link>");
}    

Function Title()
{
global $config_HTMLTITLE;
_echo ("<title> $config_HTMLTITLE </title>");
}    



Function JavaScript()
{
    _echo("<SCRIPT LANGUAGE=\"JavaScript\">");
    _echo("function AbrirVentana(loop) { ");
    _echo("window.open(loop,\"\",'scrollbars=no,location=no,directories=no,resizable=no,toolbar=no,menubar=no,width=300,height=250,left=80,top=80');");
    _echo("}");
    _echo("</SCRIPT>");
}    




Function CloseHead()
{
_echo ("</head>");
}    

Function Body()
{
    global $config_HTMLBACKGROUND;
    _echo ("<body $config_HTMLBACKGROUND>");
}    


Function BodyJava($j)
{
    global $config_HTMLBACKGROUND;
    _echo ("<body $j $config_HTMLBACKGROUND>");
}    

Function CloseHtml()
{
    echo "</body></html>";
}

Function HTMLPrintPreamble($java)
{
global $config_HTMLTITLE,$config_JAVATITLE,$config_HTMLBACKGROUND,$config_HTMLTOP;
Inicio();
Title();
/* aca va el javascript*/
CloseHead();
Body();
}    

Function PasoMensaje($str){
    _echo("<HTML>\n");
    _echo("<HEAD>\n");
    include("/opt/www/html/www.admsanjorge.com/sanjor/CS/js/style.php");
    _echo("</HEAD>\n");
    _echo("<body topmargin=\"5\" leftmargin=\"0\">\n");
    _echo("<TITLE>Error</TITLE>");
    _echo("<BR></BR>");
    _echo(" <CENTER><H3> <Caption class=\"text\">$str</Caption></H3></CENTER>\n");
    _echo("<BR></BR>");
    _echo("<CENTER><A HREF=\"javascript:window.history.back();\">Volver</A></CENTER>");
    _echo("</BODY>\n");
    _echo("</HTML>\n");
    exit();
}

Function PasoMensaje1($str){
    _echo("<HTML>\n");
    _echo("<HEAD>\n");
    include("/opt/www/html/www.admsanjorge.com/sanjor/CS/js/style.php");
    _echo("</HEAD>\n");
    _echo("<body topmargin=\"5\" leftmargin=\"0\">\n");
    _echo("<TITLE>Error</TITLE>");
    _echo("<BR></BR>");
    _echo(" <CENTER><H3> <Caption class=\"text\">$str</Caption></H3></CENTER>\n");
    _echo("<BR></BR>");
    _echo("</BODY>\n");
    _echo("</HTML>\n");
    exit();
}




Function ListarHTML($formulario_id, $hojacss, $titulo, $cabecera, $tabla, $prefijo, $filtros, $campos, $editar, $complejo, $sinhtml = NULL, $onclose = NULL, $qEsp = NULL, $quieroTot = NULL){

    if(!$sinhtml){
	_echo("<HTML>\n");
	_echo("<HEAD>\n");
	_echo("<TITLE>$titulo</TITLE>\n");
	if($hojacss) include("$hojacss");

	_echo("</HEAD>\n");

	_echo("<body bgcolor=\"#C0C0C0\" topmargin=\"15\" leftmargin=\"0\">\n");

	if($formulario_id && $formulario_id>0){
	    $qForm=PgDoQuery("select * from formulario where fm_id=$formulario_id");
	    $revision=Resultado($qForm,0,"fm_revision",1);
	    $fechaAlta=Resultado($qForm,0,"fm_fecap",1);
	    $descripcion=Resultado($qForm,0,"fm_descrip",1);
	    $proceso=Resultado($qForm,0,"fm_proceso",1);
	    $modulo=Resultado($qForm,0,"fm_modulo",1);
	    $codProc=@UserQuery("select ps_codigo from proceso where ps_id=$proceso",0);
	    $ordProc=@UserQuery("select lpad(ps_orden::text,2,'0') from proceso where ps_id=$proceso",0);
	    $codMod=@UserQuery("select msc_codint from modsgc where msc_codigo=$modulo",0);
	    $orden=@UserQuery("select ps_orden from proceso where ps_id=$proceso",0);
	    if($orden>0) $codigo=$codProc."-".$codMod."-".$ordProc;
	    else $codigo=$codProc."-".$codMod;

	    _echo("<TABLE cellSpacing=\"0\" cellPadding=\"2\" align=\"center\" border=\"3\" bordercolor=\"#CCCCCC\" width=\"75%\">\n");
	    _echo("<TR>\n");
	    _echo("<td class=\"textlow\" style=\"width: 15%\" ALIGN=\"center\" VALIGN=\"center\" rowspan=\"3\">\n");
	    _echo("<img src=\"../../../bazflp.jpg\" width=\"80px\" heigth=\"80px\">");
	    _echo("</td>\n");
	    _echo("<td class=\"textlow\" style=\"width: 65%\" ALIGN=\"center\" VALIGN=\"center\" rowspan=\"3\">\n");
	    _echo("<H3> $descripcion </H3>");
	    _echo("</td>\n");
	    _echo("<td class=\"textlow\" style=\"width: 20%\" ALIGN=\"center\">&nbsp; C&Oacute;DIGO:  $codigo &nbsp;</td>\n");
	    _echo("</TR>\n");
	    _echo("<TR>\n");
	    _echo("<td class=\"textlow\" ALIGN=\"center\">&nbsp; FECHA: $fechaAlta&nbsp;</td>\n");
	    _echo("</TR>\n");
	    _echo("<TR>\n");
	    _echo("<td class=\"textlow\" ALIGN=\"center\">&nbsp; REVISI&Oacute;N: $revision &nbsp;</td>\n");
	    _echo("</TR>\n");
	    _echo("</TABLE>\n");
	}else{
	    _echo("<CENTER><H4>$titulo</H4></CENTER>\n");
	}
    }


    _echo("<BR>");
    _echo("<HR>");
    _echo("<BR>");

    if($qEsp) $qGenerico=$qEsp;
    else $qGenerico="select * from $tabla $filtros";
    $rGenerico=PgDoQuery($qGenerico);
    $fGenerico=pg_numRows($rGenerico);
    if($fGenerico){
	    _echo("<TABLE cellSpacing=\"2\" cellPadding=\"2\" align=\"center\" border=\"1\" width=\"80%\">\n");
	    _echo("<THEAD>\n");
	    _echo("<TR>\n");
	    for($m=0;$cabecera[$m];$m++){
		_echo("<td class=\"titulof\" ALIGN=\"LEFT\"> $cabecera[$m] </td>\n");
	    }
	    _echo("</TR>\n");
	    _echo("</THEAD>\n");
	    _echo("<TBODY>\n");
	    $totales=1;
	    for($a=0;$a<$fGenerico;$a++){
		${$prefijo.'id'}=Resultado($rGenerico,$a,$prefijo."id",1);
		if($editar) $editar2=str_replace("idReemplazo","${$prefijo.'id'}",$editar);
		_echo("<TR>\n");
		if($campos){
		    for($m=0;$campos[$m];$m++){
			${'v'.$m}=Resultado($rGenerico,$a,"$campos[$m]",1);
			$tipoCampo=@UserQuery("select pg_typeof(\"$campos[$m]\") from $tabla limit 1",0);
			if($tipoCampo=="numeric") {$alineo="RIGHT"; ${'tot'.$m}+=${'v'.$m}; $totales=2;} else if($tipoCampo=="date") $alineo="CENTER"; else{ $alineo="LEFT"; ${'v'.$m}=Decode(${'v'.$m});}
			if($m==0 && $editar2) echo("<td class=\"textlown\" ALIGN=\"$alineo\"> <a href=\"$editar2\"> ${'v'.$m} </a> </td>\n");
			else _echo("<td class=\"textlown\" ALIGN=\"$alineo\"> ${'v'.$m} </td>\n");
		    }
		}else{
		    if($complejo){
			for($m=0;$complejo[$m];$m++){
			    if($complejo[$m]->Campo){
				$qField=$complejo[$m]->Campo;
				${'v'.$m}=Resultado($rGenerico,$a,"$qField",1);
				if(!$qEsp) $tipoCampo=@UserQuery("select pg_typeof(\"$qField\") from $tabla limit 1",0);
				else $tipoCampo=$complejo[$m]->TipoCampo;
				if($tipoCampo=="numeric"){
				    ${'v'.$m}=@UserQuery("select ".${'v'.$m}."::numeric",0);
				    $alineo="RIGHT"; ${'tot'.$m}+=${'v'.$m};
				    $totales=2;
				} else if($tipoCampo=="date") $alineo="CENTER"; 
				else if($tipoCampo=="timestamp" || $tipoCampo=="timestamp without time zone"){
				    $alineo="CENTER"; ${'v'.$m}=@UserQuery("select ".${'v'.$m}."::date",0);
				}else{
				    $alineo="LEFT"; ${'v'.$m}=Decode(${'v'.$m});
				}
			    }else if($complejo[$m]->Query){
				$qQuery=$complejo[$m]->Query;
				$qQuery=str_replace("idReemplazo","${$prefijo.'id'}",$qQuery);
				$qCons=$qQuery;
				${'v'.$m}=@UserQuery("$qCons",0);
				if($complejo[$m]->Decode==1) ${'v'.$m}=Decode(${'v'.$m});
				if($complejo[$m]->Alineo) $alineo=$complejo[$m]->Alineo; else $alineo="LEFT";
			    }else if($complejo[$m]->Acum){
				$qAcum=$complejo[$m]->Acum;
				${'v'.$m}+=${'v'.$qAcum};
				${'v'.$m}=@UserQuery("select ${'v'.$m}::numeric(15,2)",0);
			    }else if($complejo[$m]->Link){
				$link=$complejo[$m]->Link;
				$link=str_replace("idReemplazo","${$prefijo.'id'}",$link);
				$texto=$complejo[$m]->Label;
				if(!$texto){
				    $campoLink=$complejo[$m]->CampoLink;
				    if($campoLink) $texto=Resultado($rGenerico,$a,"$campoLink",1);
				}
				_echo("<td class=\"textlown\" ALIGN=\"$alineo\"> <a href=\"#!\" onClick=\"window.open('".$link."','w20','width=500px,height=400px,scrollable=yes,resizable=yes');\"> $texto </a> </td>\n");
			    }else if($complejo[$m]->LabelValue){
				${'v'.$m}=$complejo[$m]->LabelValue;
//				_echo("<td class=\"textlown\" ALIGN=\"$alineo\"> $link </td>\n");
			    }else if($complejo[$m]->ClaveValor){
				$qField=$complejo[$m]->ClaveValor;
				$elBuscado=Resultado($rGenerico,$a,"$qField",1);
				foreach ($complejo[$m]->Opciones as $opc){
				    if($elBuscado==$opc->Valor)
					${'v'.$m}=$opc->Nombre;
				}
//				_echo("<td class=\"textlown\" ALIGN=\"$alineo\"> $link </td>\n");
			    }else if($complejo[$m]->Calculo){
				$operacion=$complejo[$m]->Calculo;
				$result=NULL;
				foreach ($complejo[$m]->Opciones as $opc){
				    $elBuscado=Resultado($rGenerico,$a,"$opc",1);
				    if($result){
					if($operacion=="resta") $result=$result-$elBuscado;
					else if($operacion=="suma") $result=$result+$elBuscado;
					else if($operacion=="division") $result=$result/$elBuscado;
					else if($operacion=="multiplicacion") $result=$result*$elBuscado;
				    }
				    else $result=$elBuscado;
				}
				${'v'.$m}=$result;
//				_echo("<td class=\"textlown\" ALIGN=\"$alineo\"> $link </td>\n");
			    }
			if(!$complejo[$m]->Link){
			    if($m==0 && $editar2) _echo("<td class=\"textlown\" ALIGN=\"$alineo\"> <a href=\"$editar2\"> ${'v'.$m} </a> </td>\n");
			    else _echo("<td class=\"textlown\" ALIGN=\"$alineo\"> ${'v'.$m} </td>\n");
			}
			}
		    }
		}
		_echo("</TR>\n");
	    }
	    if($totales==2 && $quieroTot==NULL){
		if($campos){
		    _echo("<TR>\n");
		    for($m=0;$campos[$m];$m++){
			$alineo="RIGHT";
			if(!${'tot'.$m}) _echo("<td class=\"textlown\" ALIGN=\"$alineo\"> &nbsp; </td>\n");
			else{
			    ${'tot'.$m}=@UserQuery("select ${'tot'.$m}::numeric(15,2)",0);
			    _echo("<td class=\"textlown\" ALIGN=\"$alineo\"> ${'tot'.$m} </td>\n");
			}
		    }
		    _echo("</TR>\n");
		}else{
		    if($complejo){
			_echo("<TR>\n");
			for($m=0;$complejo[$m];$m++){
			    $alineo="RIGHT";
			    if(!${'tot'.$m}) _echo("<td class=\"textlown\" ALIGN=\"$alineo\"> &nbsp; </td>\n");
			    else{
				${'tot'.$m}=@UserQuery("select ${'tot'.$m}::numeric(15,2)",0);
				_echo("<td class=\"textlown\" ALIGN=\"$alineo\"> ${'tot'.$m} </td>\n");
			    }
			}
			_echo("</TR>\n");
		    }
		}
	    }
	    _echo("</TBODY>\n");
	    _echo("</table>\n");

	    _echo("<BR />\n");
	    _echo("<HR>\n");
	    _echo("<BR />\n");

	    if(!$sinhtml){
		if(!$onclose) _echo("<CENTER><A HREF=\"javascript:window.history.back();\" class=\"botonazo\">&nbsp;&nbsp;&nbsp;&nbsp;VOLVER&nbsp;&nbsp;&nbsp;&nbsp;</A></CENTER>");
		else _echo("<CENTER><A HREF=\"javascript:window.close();\" class=\"botonazo\">&nbsp;&nbsp;&nbsp;&nbsp;CERRAR&nbsp;&nbsp;&nbsp;&nbsp;</A></CENTER>");
	    }
	}else{
	    if(!$sinhtml)
		PasoMensaje("No hay ningun registro cargado.");
	    else
		PasoMensaje1("No hay ningun registro cargado.");
	}


	_echo("</BODY>\n");
	_echo("</HTML>\n");

}


Function AltaHTML($formulario_id, $hojacss, $java, $titulo, $hidden, $cabecera, $campos, $acciones, $nomProg, $sinbody = NULL){

    _echo("<HTML>\n");
    _echo("<HEAD>\n");
    _echo("<TITLE>$titulo</TITLE>\n");
    if($hojacss) include("$hojacss");

    _echo($java);

    _echo("</HEAD>\n");

    _echo("<body bgcolor=\"#C0C0C0\" topmargin=\"15\" leftmargin=\"0\">\n");

    if($formulario_id && $formulario_id>0){
	$qForm=PgDoQuery("select * from formulario where fm_id=$formulario_id");
	$revision=Resultado($qForm,0,"fm_revision",1);
	$fechaAlta=Resultado($qForm,0,"fm_fecap",1);
	$descripcion=Resultado($qForm,0,"fm_descrip",1);
	$proceso=Resultado($qForm,0,"fm_proceso",1);
	$modulo=Resultado($qForm,0,"fm_modulo",1);
	$codProc=@UserQuery("select ps_codigo from proceso where ps_id=$proceso",0);
	$ordProc=@UserQuery("select lpad(ps_orden::text,2,'0') from proceso where ps_id=$proceso",0);
	$codMod=@UserQuery("select msc_codint from modsgc where msc_codigo=$modulo",0);
	$orden=@UserQuery("select ps_orden from proceso where ps_id=$proceso",0);
	if($orden>0) $codigo=$codProc."-".$codMod."-".$ordProc;
	else $codigo=$codProc."-".$codMod;

	_echo("<TABLE cellSpacing=\"0\" cellPadding=\"2\" align=\"center\" border=\"3\" bordercolor=\"#CCCCCC\" width=\"75%\">\n");
	_echo("<TR>\n");
	_echo("<td class=\"textlow\" style=\"width: 15%\" ALIGN=\"center\" VALIGN=\"center\" rowspan=\"3\">\n");
	_echo("<img src=\"../../../bazflp.jpg\" width=\"80px\" heigth=\"80px\">");
	_echo("</td>\n");
	_echo("<td class=\"textlow\" style=\"width: 65%\" ALIGN=\"center\" VALIGN=\"center\" rowspan=\"3\">\n");
	_echo("<H3> $descripcion </H3>");
	_echo("</td>\n");
	_echo("<td class=\"textlow\" style=\"width: 20%\" ALIGN=\"center\">&nbsp; C&Oacute;DIGO:  $codigo &nbsp;</td>\n");
	_echo("</TR>\n");
	_echo("<TR>\n");
	_echo("<td class=\"textlow\" ALIGN=\"center\">&nbsp; FECHA: $fechaAlta&nbsp;</td>\n");
	_echo("</TR>\n");
	_echo("<TR>\n");
	_echo("<td class=\"textlow\" ALIGN=\"center\">&nbsp; REVISI&Oacute;N: $revision &nbsp;</td>\n");
	_echo("</TR>\n");
	_echo("</TABLE>\n");
    }else{
	_echo("<CENTER><H4>$titulo</H4></CENTER>\n");
    }


    _echo("<BR>");
    _echo("<HR>");
    _echo("<BR>");

    _echo("<FORM NAME=\"formulario\" ACTION=\"$nomProg\">\n");
    if($hidden){
	for($m=0;$hidden[$m];$m++){
	    $nom=$hidden[$m]->Nombre;
	    $val=$hidden[$m]->Valor;
	    if(!$val) $val=0;
	    $id=$hidden[$m]->Id;
	    if($id) $agrego="id=\"$id\" "; else $agrego=" ";
	    _echo("<input type=\"hidden\" name=\"$nom\" $agrego value=\"$val\">");
	}
    }


    _echo("<TABLE cellSpacing=\"0\" cellPadding=\"0\" align=\"center\" border=\"1\" width=\"60%\">\n");

    for($m=0;$cabecera[$m];$m++){
	$titu=$cabecera[$m];
	_echo("<TR>");
	if($titu && $titu!=" ")
	    _echo("<TD CLASS=\"titulos\" align=\"left\"> $titu : </TD>");
	if(!$titu || $titu==" ") $cs="colspan=\"2\" "; else $cs="";
	_echo("<TD CLASS=\"textlow\" $cs align=\"left\">");
	$tipoCampo=$campos[$m]->Tipo;
	if(!$tipoCampo || $tipoCampo=="texto"){
	    $nombre=$campos[$m]->Nombre;
	    $valor=$campos[$m]->Valor;
	    $tam=$campos[$m]->Size;
	    $idField=$campos[$m]->Id;
	    if($idField) $idInput="id=\"$idField\" "; else $idInput="";
	    _echo("<input type=\"text\" class=\"input_text\" $idInput name=\"$nombre\" value=\"$valor\" size=\"$tam\">");
	}else{
	    if($tipoCampo=="showq"){
		$nombre=$campos[$m]->Nombre;
		$valor=$campos[$m]->Valor;
		$query=$campos[$m]->Query;
		ShowQueryAsCombo("$query","$nombre",1,$valor,1);
	    }else{
		if($tipoCampo=="fecha"){
		    $nombre=$campos[$m]->Nombre;
		    $valor=$campos[$m]->Valor;
		    _echo("<input type=\"text\" class=\"input_center\" name=\"$nombre\" id=\"fecha$m\" value=\"$valor\"  size=\"10\" maxlength=\"10\" onFocus=\"javascript:vDateType='3'\" onKeyUp=\"DateFormat(this,this.value,event,false,'3')\" onBlur=\"DateFormat(this,this.value,event,true,'3')\"onFocus=\"javascript:vDateType='3'\" onKeyUp=\"DateFormat(this,this.value,event,false,'3')\" onBlur=\"DateFormat(this,this.value,event,true,'3')\">\n");
		    _echo("<input type=\"button\" id=\"lanzador$m\" value=\"C\" class=\"input_text\">\n");
		    _echo("<!-- script que define y configura el calendario-->\n");
		    _echo("<script type=\"text/javascript\">\n");
		    _echo("    Calendar.setup({\n");
		    _echo("        inputField     :    \"fecha$m\",      // id del campo de texto\n");
		    _echo("        ifFormat       :    \"%d-%m-%Y\",       // formato de la fecha, cuando se escriba en el campo de texto\n");
		    _echo("        button         :    \"lanzador$m\"	// el id del boton que lanzara el calendario\n");
		    _echo("    });\n");
		    _echo("</script>\n");
		}else{
		    if($tipoCampo=="select"){
			$nombre=$campos[$m]->Nombre;
			$sel=$campos[$m]->Selected;
			$opciones=$campos[$m]->Opciones;
			$properties=$campos[$m]->Prop;
			$idCampo=$campos[$m]->Id;
			if($idCampo) $idInput="id=\"$idCampo\""; else $idInput="";
			if($properties)
			    _echo("<select name=\"$nombre\" $idInput class=\"input_text\" $properties>");
			else
			    _echo("<select name=\"$nombre\" $idInput size=\"1\" class=\"input_text\">");
			for($k=0;$opciones[$k];$k++){
			    $nombre=$opciones[$k]->Nombre;
			    $valor=$opciones[$k]->Valor;
			    if($sel && $sel==$valor)
				_echo("<option selected value=\"$valor\">&nbsp; $nombre</option>");
			    else
				_echo("<option value=\"$valor\">&nbsp; $nombre</option>");
			}
			_echo("</select>");
		    }else{
			if($tipoCampo=="numero"){
			    $nombre=$campos[$m]->Nombre;
			    $valor=$campos[$m]->Valor;
			    $tam=$campos[$m]->Size;
			    $idField=$campos[$m]->Id;
			    if($idField) $idInput="id=\"$idField\" "; else $idInput="";
			    _echo("<input type=\"text\" class=\"input_number\" $idInput name=\"$nombre\" value=\"$valor\" size=\"$tam\" onKeyPress=\"return maskDecimal(event);\">");
			}else{
			    if($tipoCampo=="textarea"){
				$nombre=$campos[$m]->Nombre;
				$valor=$campos[$m]->Valor;
				$tam=$campos[$m]->Size;
				_echo("<textarea name=\"$nombre\" rows=\"3\" cols=\"$tam\">$valor</textarea>");
			    }else{
				if($tipoCampo=="valor"){
				    $valor=$campos[$m]->Valor;
				    $id=$campos[$m]->Id;
				    if(!$id) _echo("&nbsp; $valor"); else _echo("<div id=\"$id\"> &nbsp; </div>");
				}else{
				    if($tipoCampo=="auxiliar"){
					$nombre_codigo=$campos[$m]->NombreCodigo;
					$id=$campos[$m]->IdCodigo;
					$valor_codigo=$campos[$m]->ValorCodigo;
					$prop_codigo=$campos[$m]->PropCodigo;
					$nombre_nombre=$campos[$m]->NombreNombre;
					$id_nombre=$campos[$m]->IdNombre;
					$valor_nombre=$campos[$m]->ValorNombre;
					$query_aux=$campos[$m]->Query;
					$cantAtras=$campos[$m]->Atras;
					if($id) $agrego=" id=\"$id\""; else $agrego="";
					if($id_nombre) $agrego2=" id=\"$id_nombre\""; else $agrego2="";
					echo("<input type=\"text\" class=\"input_number\" $prop_codigo $agrego name=\"$nombre_codigo\" value=\"$valor_codigo\" size=\"4\" onkeypress=\"return maskKeyPress(event)\">");
					echo("<input type=\"button\" class=\"input_text\" value=\"?\" onClick=\"newWindow('$cantAtras/auxiliar/search.php?formulario=formulario&campo=$nombre_codigo&campo_nombre=$nombre_nombre&query=$query_aux','window2');\">");  
					echo("<input type=\"text\" class=\"input_text\" $agrego2 name=\"$nombre_nombre\" value=\"$valor_nombre\" size=\"25\">");
				    }else{
					if($tipoCampo=="checkbox"){
					    $nombre=$campos[$m]->Nombre;
					    $valor=$campos[$m]->Valor;
					    $valorAct=$campos[$m]->ValorActual;
					    if($valor==$valorAct) $chk="checked=\"checked\""; else $chk="";
					    _echo("<input type=\"checkbox\" class=\"input_text\" name=\"$nombre\" value=\"$valor\" $chk>");
					}else{
					    if($tipoCampo=="archivo"){
						$eliminar=$campos[$m]->Eliminar;
						$mostrar=$campos[$m]->Mostrar;
						$cargar=$campos[$m]->Cargar;
						if($cargar){
						    _echo("<a href=\"#!\" onClick=\"window.open('".$cargar."','w100','width=400px,height=300px,scrollable=yes,resizable=yes');\">CARGAR</a>");
						}else{
						    _echo("<a href=\"#!\" onClick=\"window.open('".$mostrar."','w100','width=400px,height=300px,scrollable=yes,resizable=yes');\">MOSTRAR</a>");
						    _echo("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
						    _echo("<a href=\"#!\" onClick=\"window.open('".$eliminar."','w100','width=400px,height=300px,scrollable=yes,resizable=yes');\">ELIMINAR</a>");
						}
					    }else{
						if($tipoCampo=="radio"){
						    $nombre=$campos[$m]->Nombre;
						    $sel=$campos[$m]->ValorActual;
						    $val=$campos[$m]->Valor;
						    if($sel==$val) $chk="checked"; else $chk="";
						    _echo("<input type=\"radio\" name=\"$nombre\" value=\"$val\" $chk class=\"input_text\">");
						}else{
						    if($tipoCampo=="codnom"){
							$nombre_codigo=$campos[$m]->NombreCodigo;
							$id=$campos[$m]->IdCodigo;
							$valor_codigo=$campos[$m]->ValorCodigo;
							$prop_codigo=$campos[$m]->PropCodigo;
							$nombre_nombre=$campos[$m]->NombreNombre;
							$id_nombre=$campos[$m]->IdNombre;
							$valor_nombre=$campos[$m]->ValorNombre;
							if($id) $agrego=" id=\"$id\""; else $agrego="";
							if($id_nombre) $agrego2=" id=\"$id_nombre\""; else $agrego2="";
							echo("<input type=\"text\" class=\"input_number\" $prop_codigo $agrego name=\"$nombre_codigo\" value=\"$valor_codigo\" size=\"8\" onkeypress=\"return maskKeyPress(event)\">");
							echo("<input type=\"text\" class=\"input_text\" $agrego2 name=\"$nombre_nombre\" value=\"$valor_nombre\" size=\"35\">");
						    }
						}
					    }
					}
				    }
				}
			    }
			}
		    }
		}
	    }
	}

	_echo("</TD>");
	_echo("</TR>\n");
    }

    _echo("</TABLE>\n");

    _echo("<BR>");
    _echo("<BR>");

    _echo("<TABLE cellSpacing=\"10\" cellPadding=\"0\" align=\"center\" border=\"0\" width=\"40%\">\n");
    _echo("<TR>\n");
    for($m=0;$acciones[$m];$m++){
	$titulo=$acciones[$m];
	$tit=explode("\"",$titulo);
	$tit=$tit[0];
	$largo=strlen($tit);
	if($largo>10) $class="botonazo1"; else $class="botonazo";
	_echo("<TD ALIGN=\"CENTER\"><INPUT type=\"SUBMIT\" class=\"$class\" value=\"$titulo\" name=\"accion\"> </TD>");
    }
    _echo("</TR>\n");

    _echo("</TABLE>\n");
    _echo("</FORM>\n");

    if(!$sinbody){
	_echo("</BODY>\n");
	_echo("</HTML>\n");
    }

}







Function ObtengoIIBB($archivo,$cuit){
    $content = file_get_contents($archivo);
    if(!$content) PasoMensaje("No se puede localizar el archivo de alicuotas");
    $needle=$cuit;
    $line=strstr($content,$needle);
    $line=substr($line,0,25);
    $atr=explode(";",$line);
    $alic=$atr[4];
    $alic=str_replace(",",".",$alic);
    return $alic;
}

Function ObtengoGrupoIIBB($archivo,$cuit){
    $content = file_get_contents($archivo);
    if(!$content) PasoMensaje("No se puede localizar el archivo de alicuotas");
    $needle=$cuit;
    $line=strstr($content,$needle);
    $line=substr($line,0,35);
    $atr=explode(";",$line);
    $alic=$atr[5];
    $alic=str_replace(",",".",$alic);
    return $alic;

}

Function _echo($string)
{
    if($GLOBALS["output"]=="quiet")return;
    echo($string);
}

Function HTMLPrintHeader()
{
    global $USUARIO,$REMOTE_USER,$user, $config_HTMLLOGO,$config_COLOR2,$config_COLOR1,$config_HTMLTITLE,$config_JAVATITLE,$config_DATABASE,$config_HTMLBACKGROUND,$config_HTMLTOP;

    if($GLOBALS["output"]=="quiet") return;
    $res=DoQuery2("select lname||fname as nombre from emp_ca_table where card_num = '".$REMOTE_USER."'");
    $x=ifx_fetch_row($res,"next");    
    $USUARIO=$x["nombre"];
    $estilot="cellpadding=\"1\" style=\"background-color:silver;font-family:Arial;\"";
    echo("<table  BORDER=\"1\" WIDTH=\"100%\"".$estilot ."  >");
    echo("<tr>");
    echo ("<td width=10%  align=\"center\" bgcolor=\"#80cc77\" ><img SRC=\"" . $config_HTMLLOGO . "\" WIDTH=\"80\"  border=\"0\"></td>");
    echo("<td valign=\"center\" width=\"10%\">");
    echo("<center><B>Usuario</B></TD><TD width=\"25%\" bgcolor=\"#80cc77\"  >");
    echo("<FONT COLOR=$config_COLOR1><center><B><I>".$x["nombre"]."</I></B></center></FONT></TD>");
    echo("<TD valign=\"center\" width=\"10%\">");
    echo("<center><B>Servidor</B></TD><TD width=\"25%\" bgcolor=\"#80cc77\"  >");
    echo("<FONT COLOR=$config_COLOR1><center><B><I>$config_DATABASE </I></B></center></FONT></TD></tr>");
    echo( "</table>");

/*
    echo("<table  BORDER=\"1\" WIDTH=\"100%\">");
//    echo("<tr><td  rowspan=\"2\" width=\"220\" align=\"center\"  ><img SRC=\"" . $config_HTMLLOGO . "\" WIDTH=\"140\"  border=\"1\"></td>");
    echo("<TD valign=\"center\" width=\"10%\">");
    echo("<B>Modulo:</B></TD><TD width=\"25%\">");
    echo("<FONT COLOR=$config_COLOR1><B><I> Interface Red Autopistas </I></B></FONT></TD>");
    echo("<TD valign=\"center\" width=\"10%\">");
    echo("<B>Servidor:</B></TD><TD width=\"25%\">");
    echo("<FONT COLOR=$config_COLOR1><B><I>$config_DATABASE </I></B></FONT></TD></tr>");

    echo("<TR><TD><B>Operador:</B></TD><TD>");
    echo("<B><I><FONT COLOR=$config_COLOR1><font size=\"-1\">");
    echo($user["operador"]); 
    echo("</font></I></B></TD>");
    echo("<TD><B>Grupo:</B></TD><TD>");
    echo( "<B><I><FONT COLOR=$config_COLOR1><font size=\"-2\">");
    echo($user["group"]); 
    echo( "</font></I></B></TD></tr>");
    echo( "</table><hr color=\"#0000FF\">");
*/
}




Function PrintMenu($menuid)
{
    global $user;
    $result = DoQuery("SELECT menus.*, colores.html FROM menus WHERE parentid = $menuid AND menus.bgcolor = colores.id");
    echo "<center><TABLE align=\"center\" BORDER=\"10\" CELLSPACING=\"8\" CELLPADING=\"15\" BGCOLOR=\"#000000\" BORDERCOLOR=\"#a0a0a0\">";
    for($row=0; $row < pg_NumRows($result); $row++) {
	$data = pg_Fetch_Object($result, $row);

/*SI EL GRUPO DEL MENU COINCIDE CON EL DEL USUARIO o =0 THEN DISPLAY*/
//echo ($user["groupid"]);        
if($data->groupid==$user["groupid"]) {
	    print "<tr><td align=\"center\"  bgcolor=\"$data->html\">";
  //	    echo "<font size=\"3\"><a href=\"$data->url\">$data->title</a><p></td>";
	    echo "<td><a href=\"$data->url\"><img SRC=\"$data->image\" WIDTH=\"50\" border=\"1\"></td></tr>";
	}
    }
    print "</table></center>";
}


Function HTMLPrintFooter($displaycounter)
{
    global $user,$config_HOME;    
    echo "<hr>";
    echo "<table border=0 width=\"100%\"><tr>";
    echo("<td align=\"left\"  ><a href=\"index.html\"  class=\"link\" >Menu Principal</a></center></td>");
//    $x = strtok(getenv("HTTP_REFERER"),"?");
//    echo "<td align=\"left\">";
//    echo "<A HREF=\"" . $x . "\" target=\"_top\">";
//    echo "Volver</a>";

//    el_mismo= getenv("$PHP_SELF");
//    echo "<a href=" . $el_mismo . " target=\"_top\">Home</a></td>";
    
//    echo "<td align=\"right\"><a href=\"chau.php\"  target=\"_top\">Cerrar Sesi&oacute;n</a>";
    echo("<td align=\"right\" ><a href=\"javascript:window.close()\"  class=\"link\"  >Cerrar Sesi&oacute;n</a></center></td>");
    echo "</tr></table>";
    if($displaycounter) {
	echo "<center><width=\"100%\">";
	counter_gif($user["count"], 4);
	echo "</center>";
    }    
    
    echo "</body></html>";
}


Function HTMLPrintOnHelpIn($fieldname, $tablename)
{
    echo "<a href=\"popup.php3?table=$tablename&fld=p_clieno&fieldname=$fieldname&pattern\" ";
    echo " border=0 onClick=\"doPopUp('popup.php3?table=$tablename&fld=p_clieno&fieldname=$fieldname)'; return false;\">";
    echo "<img alt=\"*\&gt;\" border=0 onClick=\"doPopUp('popup.php3?table=$tablename&fld=p_clieno&fieldname=$fieldname)';\""; 
    echo " src=\"/images/extras/tick-blue.gif\"></a> ";
}


Function HTMLPrintHeaderTurnos()
{
    global $user, $config_HTMLLOGO;
    if($GLOBALS["output"]=="quiet")		return;
    $azul="#6633ff";
    $amarillo="#FFCC00";
    _echo("<table BORDER=\"0\" WIDTH=\"100%\">");
    _echo("<tr><td rowspan=\"2\" width=\"120\"><img SRC=\"" . $config_HTMLLOGO . "\" WIDTH=\"60\" border=\"2\"></td>");
//    _echo("<tr><td rowspan=\"2\" width=\"120\"><img SRC=\"/jpg/logo_megatom.jpg\" WIDTH=\"120\" border=\"2\"></td>");
    _echo("<TD valign=\"center\" width=\"20%\">");
    _echo("<B>Modulo:</B></TD><TD width=\"40%\">");
    _echo("<FONT SIZE=5><FONT COLOR=$azul><B><I>Solicitud de Turnos</I></B></FONT></TD>");
    echo "</TR></table><hr color=\"#0000FF\">";

}



Function HTMLPrintFooterTurnos($displaycounter)
{
    global $user;
echo("<center><a href=\"x.php3?text_default=". urlencode($text). "\">INICIO</a></center>");	    

//    echo "<hr>";
//    echo "<table width=\"100%\"><tr>";

//    $x = strtok(getenv("HTTP_REFERER"),"?");
//    echo "<td align=\"left\"><A HREF=\"" . $x . "\" target=\"_top\">";
//    echo "Volver";
//    echo "</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href=\"x.php3\" target=\"_top\">Home</a></td>";

//    echo "<td align=\"right\"><a href=\"x.php3?action=logout\"  target=\"_top\">Home</a>";
//    echo "</td></tr></table>";
//    if($displaycounter) {
//	echo "<center><width=\"100%\">";
//	counter_gif($user["count"], 4);
//	echo "</center>";
//    }    
    
//    echo "</body></html>";
}




Function PrintMenuInicio($menuid)
{
    global $user;
    $result = DoQuery("SELECT menus.*, colores.html FROM menus WHERE parentid = $menuid AND menus.bgcolor = colores.id");
    echo "<center><table border=\"0\" cellspacing=\"0\" width=\"100%\" cellpadding=\"2\"><TR>";
    for($row=0; $row < pg_NumRows($result); $row++) {
	$data = pg_Fetch_Object($result, $row);

/*SI EL GRUPO DEL MENU COINCIDE CON EL DEL USUARIO o =0 THEN DISPLAY*/
        if($data->groupid==$user["groupid"]) {
// esto 
	    print "<td align=\"center\" width=\"25%\" valign=\"baseline\" bgcolor=\"$data->html\">";
//    	    echo "<font size=\"3\"><a href=\"$data->url\" class=\"link\" Target=\"inferior\">$data->title</a><p></td>";
    	    echo "<font size=\"3\"><a href=\"template_down.php3?pagina=$data->url\" class=\"link\"  Target=\"inferior\">$data->title</a><p></td>";
// o esto
//	    echo "<td><a href=\"$data->url\" Target=\"inferior\"><img SRC=\"$data->image\" WIDTH=\"20\" border=\"1\"></td>";
	}
    }
    print "</table></center>";
}


Function PrintMenuAle($menuid)
{
    global $user;
    $result = DoQuery("SELECT menus.*, colores.html FROM menus WHERE parentid = $menuid AND menus.bgcolor = colores.id");
    echo "<center><TABLE align=\"center\" BORDER=\"10\" CELLSPACING=\"8\" CELLPADING=\"15\" BGCOLOR=\"#000000\" BORDERCOLOR=\"#a0a0a0\">";
    for($row=0; $row < pg_NumRows($result); $row++) {

	$data = pg_Fetch_Object($result, $row);

/*SI EL GRUPO DEL MENU COINCIDE CON EL DEL USUARIO o =0 THEN DISPLAY*/
        if($data->groupid==$user["groupid"]) {
	    print "<tr><td align=\"center\"  bgcolor=\"$data->html\">";
   	    echo "<font size=\"3\"><a href=\"$data->url\" Target=\"principal\">$data->title</a><p></td>";
	    echo "<td><a href=\"$data->url\"><img SRC=\"$data->image\" WIDTH=\"50\" border=\"1\"></td></tr>";
	}
    }
    print "</table></center>";
}





Function PrintMenuInicio2($menuid)
{
global $user;
global $config_HTMLTITLE,$config_JAVATITLE,$config_HTMLBACKGROUND,$config_HTMLTOP;
echo("<html>");
echo("<head>");
echo("<title>Titulo</title>");
echo("<script>");
echo("var menublock=new Array() // no need to change this");
echo("var plus_i=0 // no need to change this");
$q="SELECT menus.* FROM menus WHERE  menus.parentid = 0 and groupid= " . $user["groupid"] .  ";";  

$result = DoQuery($q);

for($row=0; $row < pg_NumRows($result); $row++)
 {
    $data = pg_Fetch_Object($result, $row);
    $cual=$row + 1 ;
    $q1="SELECT menus.* FROM menus WHERE  menus.parentid = $cual and groupid= " . $user["groupid"] .  ";";
    $result_hijo = DoQuery($q1);
    $last=pg_NumRows($result_hijo);
    if($last > 0)		  /*hijos>0*/	
	{	
        $last=pg_NumRows($result_hijo) - 1;
	padre($row,$data->title);
	for($row1=0; $row1 <= $last ; $row1++)  
	    {
	    $data1 = pg_Fetch_Object($result_hijo, $row1);
	    if($row1<$last)
		 hijo($data1->title,$data1->url);		
	    else
	    	{
		    $x=$data1->title . "|" . $data1->url . "|main;\"";
		    echo("\"$x");
		}
	    }
	}
    else
	{
	echo("menublock[$row]=\"Arial;\"+ ");
	echo("			 \"2;\"+				// fontsize mainlink");
	echo("			 \"000000;\"+			// fontcolor mainlink");
	echo("			 \"1;\"+				// fontweight mainlink, 1 means bold, 0 means normal");
	echo("			 \";;;;\"+ 		// font sublinks");
	$x=$data->title . "|" . $data->url . "|main;\"";
	echo("\"$x");
	}
    }
//    final();
}



 function encriptar($session_id) {
    $key = 'maxilopez';
    $ivlen = openssl_cipher_iv_length('aes-128-cbc');
    $iv = substr(md5($key), 0, $ivlen);
    $ciphertext = openssl_encrypt($session_id, 'aes-128-cbc', $key, $options=OPENSSL_RAW_DATA, $iv);
    $encryptedSessionId = base64_encode($ciphertext);
    $encryptedSessionId = str_replace("=","_EQU_",$encryptedSessionId);
    $encryptedSessionId = str_replace("+","_MAS_",$encryptedSessionId);
    $encryptedSessionId = str_replace("/","_BARRA_",$encryptedSessionId);
    return $encryptedSessionId;
  }



  function desencriptar($encryptedSessionId) {
    $encryptedSessionId=str_replace("_EQU_","=",$encryptedSessionId);
    $encryptedSessionId=str_replace("_MAS_","+",$encryptedSessionId);
    $encryptedSessionId=str_replace("_BARRA_","/",$encryptedSessionId);
    $key = 'maxilopez';
    $ivlen = openssl_cipher_iv_length('aes-128-cbc');
    $iv = substr(md5($key), 0, $ivlen);
    $decoded = base64_decode($encryptedSessionId,TRUE);
    $decryptedSessionId = openssl_decrypt($decoded, 'aes-128-cbc', $key, $options=OPENSSL_RAW_DATA, $iv);
    $session_id = $decryptedSessionId;
    return $session_id;
  }






function padre($nivel,$title){
echo("menublock[$nivel]=\"Arial;\"+ ");
echo("			 \"2;\"+			// fontsize mainlink");
echo("			 \"000000;\"+			// fontcolor mainlink");
echo("			 \"1;\"+			// fontweight mainlink, 1 means bold, 0 means normal");
echo("			 \"Verdana;\"+ 		// font sublinks");
echo("			 \"1;\"+			// fontsize sublinks");
echo("			 \"000000;\"+			// fontcolor sublinks");
echo("			 \"0;\"+			// fontweight sublinks, 1 means bold, 0 means normal");
$x=$title . "|#|;\"+";
echo ("\"$x");
}

function hijo($nombre,$vinculo){
$x=$nombre . "|" . $vinculo . "|main;\"+";
echo("\"$x");
}

/*
function final(){
echo("// No need to change anything below	 ");
echo("//  **********************************************************************************");
echo("	 ");
echo("var menusplit");
echo("var urlsplit");
echo("var font_weight_main");
echo("var font_weight_sub");
echo("var font_weight_sub");

echo("var minusimg=new Image()");
echo("minusimg.src=\"/gif/arrow.gif\"");

echo("var plusimg=new Image()");
echo("plusimg.src=\"/gif/arrow1.gif\"");

echo("var showsubmenus=new Array()");
echo("for (i=0;i<=menublock.length-1;i++) {");
echo("	showsubmenus[i]=-1");
echo("}");
echo("var plusminusimg=new Array()");
echo("for (i=0;i<=menublock.length-1;i++) {");
echo("	plusminusimg[i]=plusimg.src");
echo("}");

echo("function openandclose(visi) {");
echo("	showsubmenus[visi]=(-1)*showsubmenus[visi]");
echo("    var menucontent=\"\"");
echo("    if (showsubmenus[visi]==1) {plusminusimg[visi]=minusimg.src}");
echo("    if (showsubmenus[visi]==-1) {plusminusimg[visi]=plusimg.src}");
echo("    menucontent+=\"<table border=0 CEllSPACING=5>\"");
echo("	for (i=0;i<=menublock.length-1;i++) {");
echo("		menusplit=menublock[i].split(\";\")");
echo("		urlsplit=menusplit[8].split(\"|\")");
echo("		if (menusplit[3]==1) {font_weight_main=\"<b>\"}");
echo("		if (menusplit[3]==0) {font_weight_main=\"\"}");
echo("		if (menusplit[7]==1) {font_weight_sub=\"<b>\"}");
echo("		if (menusplit[7]==0) {font_weight_sub=\"\"} ");
echo("		menucontent+=\"<tr><td>\"");
echo("        ");

echo("       if (menusplit[9].length==0) {");
echo("            menucontent+=\"</td>\"");
echo("            menucontent+=\"<td bgcolor=#669966 align=CENTER>\"");
echo("            menucontent+=font_weight_main");
echo("            menucontent+=\"<a href=\"+urlsplit[1]+\" target=\"+urlsplit[2]+\">\"");
echo("            menucontent+=\"<font face=\"+menusplit[0]+\" color=\"+menusplit[2]+\" size=\"+menusplit[1]+\">\"");
echo("            menucontent+=urlsplit[0]");
echo("            menucontent+=\"</font></a></td></tr>\"");
echo("            plus_i++ ");
echo("        }");
echo("        ");
echo("        if (menusplit[9].length!=0) {");
echo("            var thismainmenu=i+plus_i");
echo("            menucontent+=\"<a href='javascript:openandclose(\"+i+\")'>\"");
echo("            menucontent+=\"<img src='\"+plusminusimg[i]+\"' border=0></a></td>\"");
echo("            menucontent+=\"<td bgcolor=#669966>\"");
echo("            menucontent+=font_weight_main");
echo("            menucontent+=\"<a href='javascript:openandclose(\"+i+\")'>\"");
echo("            menucontent+=\"<font face=\"+menusplit[0]+\" color=\"+menusplit[2]+\" size=\"+menusplit[1]+\">\"");
echo("            menucontent+=urlsplit[0]");
echo("            menucontent+=\"</font></a></td></tr>\"");
echo("   ");
echo("		    if (showsubmenus[i]==1) {");
echo("			    for (ii=9;ii<=menusplit.length-1;ii++) {");
echo("				    urlsplit=menusplit[ii].split(\"|\")");
echo("                    menucontent+=\"<tr><td></td><td bgcolor=#669966>\"");
echo("    			    menucontent+=font_weight_sub");
echo("                    menucontent+=\"<a href=\"+urlsplit[1]+\" target=\"+urlsplit[2]+\">\"");
echo("                    menucontent+=\"<font face=\"+menusplit[4]+\" color=\"+menusplit[6]+\" size=\"+menusplit[5]+\">\"");
echo("                    menucontent+=urlsplit[0]");
echo("                    menucontent+=\"</font></a></td></tr>\"");
echo("			    }");
echo("		    }");
echo("        }    ");
echo("	}");
echo("    menucontent+=\"</table>\"");
echo("	if (document.all) {");
echo("		menu.innerHTML=menucontent");
echo("	}");
echo("	if (document.layers) {");
echo("		document.menu.document.write(menucontent)");
echo("		document.menu.document.close()");
echo("	}");
echo("}");
echo("");
echo("");
echo("// - End of JavaScript - -->");
echo("</script>");
echo("");
echo("<style TYPE=\"text/css\">");
echo("  A.link { text-decoration: none; color: white; font-family: Verdana, Arial, Helvetica, sans-serif; font-size:8pt;}");
echo("  A:hover.link { text-decoration: underline; color: red; font-family: Verdana, Arial, Helvetica, sans-serif; font-size:10pt;}");
echo("</style>");
echo("</head>");
echo("<body bgcolor=#669966 link=\"#11FFFF\" vlink=\"#FFFFFF\" alink=\"#00FF00\" topmargin=\"1\" onLoad=\"openandclose(1000)\"");
echo("<div id=\"menu\" style=\"position:absolute;top:30px;left:1px\"></div>");
echo("</body>");
echo("</html>");
}
*/
?>