<div class="table-responsive">
    <table id="tabla_usuarios" class="table table-vcenter table-condensed table-bordered tablabase">
        <thead>
            <tr>
                <th>ID</th>
                <th><?php echo lang('index_fname_th');?></th>
                <th><?php echo lang('index_lname_th');?></th>
                <th><?php echo lang('index_email_th');?></th>
                <?php if($this->ion_auth->is_admin()){?>
                    <th><?php echo lang('index_status_th');?></th>
                    <th><?php echo lang('index_action_th');?></th>
                <?php } ?>
                <th><span class="badge">Barrio</span> <span class="label label-success">Unidades adjudicada</label> </th>
                
            </tr>
        </thead>
        <tbody>
        <?php foreach ($users as $user):?>
            <tr>
                <td><?php echo htmlspecialchars($user->id,ENT_QUOTES,'UTF-8');?></td>
                <td><?php echo htmlspecialchars($user->first_name,ENT_QUOTES,'UTF-8');?></td>
                <td><?php echo htmlspecialchars($user->last_name,ENT_QUOTES,'UTF-8');?></td>
                <td><?php echo htmlspecialchars($user->email,ENT_QUOTES,'UTF-8');?></td>
                <?php if($this->ion_auth->is_admin()){?>
                    <td><?php echo ($user->active) ? anchor("auth/deactivate/".$user->id, lang('index_active_link')) : anchor("auth/activate/". $user->id, lang('index_inactive_link'));?></td>
                    <td><?php $atrib=array('class'=>'btn btn-primary btn-block');echo anchor("auth/edit_user/".$user->id,'<i class="fa fa-pencil"></i>',$atrib) ;?></td>
                <?php } ?>
                <td><?php 
		    $barrios_user= $this->Sec_model->losBarriosDelUsuario($user->id);
                    if($barrios_user){
                	foreach ($barrios_user as $barrioDelUser){
                    	    echo "<span class=\"badge\">Admin ".$barrioDelUser->ptv_nombre." </span>";
                	    $unidades = $this->Sec_model->usuario_barrio_unidad($user->id,$barrioDelUser->ptv_id);
                	    if($unidades == false){ echo "Sin asignaciones";}else{
                    		foreach($unidades as $unidad){echo " <span class=\"label label-success\">".$unidad->cop_unifun."</label> </span>";}
                	    }
                	}
                    }
		    ?>
                </td>
            </tr>
        <?php endforeach;?>
        </tbody>
    </table>
</div>
<p><?php echo anchor('auth/create_user', lang('index_create_user_link'))?></p>