<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');


class Sec_model extends CI_Model
{

const SESS_CIPHER = 'aes-128-cbc';
	
	function getBarrio(){
	    return 42;
	}

	function insert($tabla,$datos){
		$this->db->insert($tabla, $datos);
		if($this->db->affected_rows()>0){
			return true;
		}else{
			return false;
		}
	}


	function update($tabla,$id,$datos){
	
		$this->db->where('id', $id);
		$this->db->update($tabla, $datos);
		if($this->db->affected_rows()>0){
			return true;
		}else{
			return false;
		}
	}

	function update_p($tabla,$nid,$id,$datos){
	
		$this->db->where($nid, $id);
		$this->db->update($tabla, $datos);
		if($this->db->affected_rows()>0){
			return true;
		}else{
			return false;
		}
	}


	function delete($tabla,$id){
	
		$this->db->where('id', $id);
		$this->db->delete($tabla);
		if($this->db->affected_rows()>0){
			return true;
		}else{
			return false;
		}
	}

	public function update_user($id, $data)
	{
        	$table=$this->config->item('tables','ion_auth')['users'];
			$this->db->where('id', $id);
			$this->db->update($table, $data); 
			return TRUE;
		
	}

	function ver_barrios($ptv_id = NULL){
		$this->db->where('ptv_id', $this->getBarrio());
		$this->db->select('ptv_id,ptv_nombre');
		$this->db->order_by('ptv_nombre', 'asc');
		$q=$this->db->get('ptovta');
		if($ptv_id){
			$q=$q->row();
		}
		else{
			$q=$q->result();
		}
		return 	$q;	
	}

	function ver_unidades($id = null){
		if($id){
			$this->db->where('cop_id', $id);
		}
		$q=$this->db->get('coprop');
			if($id){
				$q=$q->row();
			}
			else{
				$q=$q->result();
			}
			return 	$q;
	}

	function ver_unidades_de_barrio($id = null){
		if($id){
			$this->db->where('cop_idptov', $id);
		}
		$this->db->order_by('cop_unifun');
		$q=$this->db->get('coprop');
		$q=$q->result();
		return 	$q;
	}


	function es_admin($id){
	    $this->db->where('user_id', $id);
	    $this->db->where('group_id', 1);
	    $q=$this->db->get('users_groups');
	    if($q) return $q->row();
	    return false;
	}


	function unidades_barrio($barrio){
		$exist=array();
/*		$this->db->select('ufd');
		$this->db->where('estado','1');
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){			
			$q=$q->result();
			foreach($q as $exi){
				$exist[]=$exi->ufd;
			}
			$unidades = implode(",",$exist);
			$unidad = explode(",",$unidades);
		}
*/
		$estado = array('1', '2');
//		$this->db->where_not_in('cop_id', $unidad);
		$this->db->where_in('cop_estado', $estado);
		$this->db->where('cop_idptov', $barrio);		
		$this->db->order_by('cop_unifun','asc');
		$q=$this->db->get('coprop');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return FALSE;
		}
	}

	function unidades_barrio_tot($barrio){
/*		$exist=array();
		$this->db->select('ufd');
		$this->db->where('estado','1');
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){			
			$q=$q->result();
			foreach($q as $exi){
				$exist[]=$exi->ufd;
			}
			$unidades = implode(",",$exist);
			$unidad = explode(",",$unidades);
		}
*/
		$estado = array('1', '2');
//		$this->db->where_not_in('cop_id', $unidad);
		$this->db->where_in('cop_estado', $estado);
		$this->db->where('cop_idptov', $barrio);		
		$this->db->order_by('cop_unifun','asc');
		$q=$this->db->get('coprop');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return FALSE;
		}
	}


	function unidades_barrio_prop($user_id,$barrio){
		$exist=array();
		$unidad=NULL;
		$this->db->select('ufd');
		$this->db->join('ptovta','ptovta.ptv_id = user_rel_ptovta_rel_ufs.ptv_id');
		$this->db->where('id_user', $user_id);
		$this->db->where('user_rel_ptovta_rel_ufs.ptv_id', $barrio);
		$this->db->where('ptovta.ptv_estado', 1);
		$this->db->where('user_rel_ptovta_rel_ufs.estado', 1);
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){			
			$q=$q->result();
			foreach($q as $exi){
				$exist[]=$exi->ufd;
			}
			if($exist) $unidades = implode(",",$exist);
			if($unidades) $unidad = explode(",",$unidades);
		}
		if(!$unidad) $unidad=array('-1');
		$this->db->where_in('cop_id', $unidad);
		$this->db->order_by('cop_unifun','asc');
		$q=$this->db->get('coprop');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return FALSE;
		}
	}

	function unidades_barrio_prop_inact($user_id,$barrio){
		$exist=array();
		$unidad=NULL;
		$this->db->select('ufd');
		$this->db->join('ptovta','ptovta.ptv_id = user_rel_ptovta_rel_ufs.ptv_id');
		$this->db->where('id_user', $user_id);
		$this->db->where('user_rel_ptovta_rel_ufs.ptv_id', $barrio);
		$this->db->where('ptovta.ptv_estado', 1);
		$this->db->where('user_rel_ptovta_rel_ufs.estado', 2);
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){			
			$q=$q->result();
			foreach($q as $exi){
				$exist[]=$exi->ufd;
			}
			if($exist) $unidades = implode(",",$exist);
			if($unidades) $unidad = explode(",",$unidades);
		}
		if(!$unidad) $unidad=array('-1');
		$this->db->where_in('cop_id', $unidad);
		$this->db->order_by('cop_unifun','asc');
		$q=$this->db->get('coprop');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return FALSE;
		}
	}

	function unidades_user($user_id){
		$exist=array();
		$this->db->select('ufd');
		$this->db->join('ptovta','ptovta.ptv_id = user_rel_ptovta_rel_ufs.ptv_id');
		$this->db->where('id_user', $user_id);
		$this->db->where('ptovta.ptv_estado', 1);
		$this->db->where('user_rel_ptovta_rel_ufs.estado', 1);
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){
			$q=$q->result();
			foreach($q as $exi){
				$exist[]=$exi->ufd;
			}
			$unidades = implode(",",$exist);
			$unidad = explode(",",$unidades);
		}

		$this->db->where_in('cop_id', $unidad);
		$this->db->order_by('cop_unifun','asc');
		$q=$this->db->get('coprop');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return FALSE;
		}
	}


	function bancos_barrio($barrio){
		$exist=array();
		$this->db->select('cte_id,cte_nombre');
		$this->db->where('cte_tipcta', 1);
		$this->db->where('cte_idptov', $barrio);
		$this->db->where('cte_estado', 1);
		$this->db->where('cte_id !=', 2926);
		$q=$this->db->get('ctes');
		if($q->num_rows() >0){			
			$q=$q->result();
			return $q;
		}else{
			return FALSE;
		}
	}


	function barrios_user($id){
		$this->db->distinct();
		$this->db->select('user_rel_ptovta_rel_ufs.ptv_id,ufd,ptovta.ptv_nombre');
		$this->db->join('ptovta','ptovta.ptv_id = user_rel_ptovta_rel_ufs.ptv_id');
		$this->db->where('id_user', $id);
		$this->db->where('estado', '1');
		$this->db->where('ufd !=', '0');
		$this->db->where('ptovta.ptv_estado', 1);
		$this->db->where('ptovta.ptv_id', $this->getBarrio());
		$this->db->order_by('ptv_id asc,ufd asc');
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}
	}

	function losBarriosDelUsuario($id){
		$this->db->distinct();
		$this->db->select('user_rel_ptovta_rel_ufs.ptv_id,ptovta.ptv_nombre');
		$this->db->join('ptovta','ptovta.ptv_id = user_rel_ptovta_rel_ufs.ptv_id');
		$this->db->where('id_user', $id);
		$this->db->where('estado', '1');
		$this->db->where('ptovta.ptv_id', $this->getBarrio());
		$this->db->where('ptovta.ptv_estado', 1);
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}
	}




	function id_barrios_user($id){
		$this->db->where('id_user', $id);
		$this->db->where('estado', 1);
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){			
			$q=$q->result();
			//Limpiar dupliacados
			$barrio_id=array();
			foreach($q as $barrio){
				if (in_array($barrio->ptv_id, $barrio_id)) { }//si ya esxiste no hace nada
				else{ $barrio_id[]=$barrio->ptv_id; } //SI NO EXISTE; SE AÑADE AL ARRAY				
			}

			return $barrio_id;
		}else{
			return false;
		}
	}

	function id_user_barrio($ptv_id){
		$this->db->join('ptovta','ptovta.ptv_id = user_rel_ptovta_rel_ufs.ptv_id');
		$this->db->where('ptovta.ptv_estado', 1);
		$this->db->where('user_rel_ptovta_rel_ufsptv_id', $ptv_id);
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){			
			$q=$q->result();
			//Limpiar dupliacados
			$user_id_barrio=array();
			foreach($q as $barrio){
				if (in_array($barrio->id_user, $user_id_barrio)) { }//si ya esxiste no hace nada
				else{ $user_id_barrio[]=$barrio->id_user; } //SI NO EXISTE; SE AÑADE AL ARRAY				
			}

			return $user_id_barrio;
		}else{
			return false;
		}
	}

	function get_ufs($uf){
		$exist=array();
		$this->db->select('ptv_id');
		$this->db->where('estado','1');
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){
			$q=$q->row();
			$barrio=$q->ptv_id;
		    $estado = array('1', '2');
		    $this->db->where_not_in('cop_id', $uf);
		    $this->db->where_in('cop_estado', $estado);
		    $this->db->where('cop_idptov', $barrio);
		    $this->db->order_by('cop_unifun','asc');
		    $q=$this->db->get('coprop');
		    if($q->num_rows() >0){
			    $q=$q->result();
			    return $q;
		    }else{
			return FALSE;
		    }
		}
	}

	function usuario_barrio_unidad($user,$barrio){
		$this->db->select('ufd');
		$this->db->join('ptovta','ptovta.ptv_id = user_rel_ptovta_rel_ufs.ptv_id');
		$this->db->where('id_user', $user);
		$this->db->where('user_rel_ptovta_rel_ufs.ptv_id', $barrio);
		$this->db->where('user_rel_ptovta_rel_ufs.estado', 1);
		$this->db->where('ptovta.ptv_estado', 1);
//		$this->db->order_by('ufd asc');
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){
			$q=$q->result();
			$p=array();
			foreach($q as $unidad){
				$this->db->where('cop_id', $unidad->ufd);
				$s=$this->db->get('coprop');
				if($s->num_rows()>0) $p[]=$s->row();
			}
			return $p;
		}else{
			return false;
		}
	}


	function usuario_barrio_unidad_vista($user,$barrio){
		$this->db->select('ufd');
		$this->db->where('id_user', $user);
		$this->db->where('ptv_id', $barrio);
		$this->db->where('estado', 1);
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){
			$q=$q->row();
			return $q;
		}else{
			return false;
		}
	}






	function buscar_estados_cero($id=null){
		$this->db->join('ptovta','ptovta.ptv_id = user_rel_ptovta_rel_ufs.ptv_id');
		if(!$id==null){
			$this->db->where('id_user',$id);
		}
		$this->db->where('estado','0');
		$this->db->where('ptovta.ptv_estado', 1);
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}
	}

	function buscar_estados($id){
		$this->db->join('ptovta','ptovta.ptv_id = user_rel_ptovta_rel_ufs.ptv_id');
		$this->db->where('id_user',$id);
		$this->db->where('estado =','0');
		$this->db->where('ptovta.ptv_estado', 1);
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}
	}

	function user_rel_ptovta_rel_ufs($array = null){
		$this->db->join('ptovta','ptovta.ptv_id = user_rel_ptovta_rel_ufs.ptv_id');
		if(isset($array)){
			$this->db->where_in('ptv_id', $array);
		}
		$this->db->where('ptovta.ptv_estado', 1);
		$this->db->where('estado', 1);
		$this->db->order_by('user_rel_ptovta_rel_ufs.ptv_id asc,id_user asc');
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}
	}

	function recuperar_last_id($email){
		$this->db->select('id');
		$this->db->where('email', $email);
		$q=$this->db->get('users');
		$q=$q->row();
		$id=$q->id;
		return $id;
	}


	function recuperar_email_user($id){
		$this->db->select('email');
		$this->db->where('id', $id);
		$q=$this->db->get('users');
		if($q->num_rows() >0){
		    $q=$q->row();
		    $id=$q->email;
		    return $id;
		}
	}

	function get_ptv_nombre($id){
		$this->db->select('ptv_nombre');
		$this->db->where('ptv_id', $id);
		$q=$this->db->get('ptovta');
		$q=$q->row();
		$id=$q->ptv_nombre;
		return $id;
	}

	function get_cop_unifun($id){
		$this->db->select('cop_unifun');
		$this->db->where('cop_id', $id);
		$q=$this->db->get('coprop');
		$q=$q->row();
		$id=$q->cop_unifun;
		return $id;
	}



	function get_cte_nombre($id){
		$this->db->select('cte_nombre');
		$this->db->where('cte_id', $id);
		$q=$this->db->get('ctes');
		$q=$q->row();
		$id=$q->cte_nombre;
		return $id;
	}



	function get_codemp($id){
		$this->db->select('ptv_codemp');
		$this->db->where('ptv_id', $id);
		$q=$this->db->get('ptovta');
		$q=$q->row();
		$id=$q->ptv_codemp;
		return $id;
	}



	function cop_id($user_id){
		$barrio=$this->getBarrio();
		$this->db->where('estado', '1');
		$this->db->where('ptv_id', $barrio);
		$this->db->where('id_user', $user_id);
		$q=$this->db->get('user_rel_ptovta_rel_ufs');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}

	}



	function get_registro($cop_id,$tipusu){
		$q="select users.id as uid from users,user_rel_ptovta_rel_ufs where tipo=$tipusu and ufd=$cop_id and users.id=id_user and user_rel_ptovta_rel_ufs.estado=1;";
		$q=$this->db->query($q);
		$q=$q->result();
		return $q;
	}



	function tipo_usuario($user_id){
		$this->db->select('tipo');
		$this->db->where('id', $user_id);
		$q=$this->db->get('users');
		if($q->num_rows() >0){
			$q=$q->row()->tipo;
			return $q;
		}else{
			return false;
		}
	}

	function get_users(){
		$q=$this->db->get('users');
		if($q->num_rows() >0){
			$q=$q->result();
			return $q;
		}else{
			return false;
		}
	}




	function grupo_familiar_mayor($cops,$user_id){
		$tipusu=$this->Sec_model->tipo_usuario($user_id);

		if($tipusu==1) $q="select * from grupof_d where gf_idcopr=$cops and gf_mayor=1 and gf_estado=1 order by gf_nrodoc;";
		else $q="select * from grupof_inq where gf_idcopr=$cops and gf_mayor=1 and gf_estado=1 order by gf_nrodoc;";
		$q=$this->db->query($q);
		return $q;
	}

	function grupo_familiar_menor($cops,$user_id){
		$tipusu=$this->Sec_model->tipo_usuario($user_id);

		if($tipusu==1) $q="select *,'grupof_d' as tabla from grupof_d where gf_idcopr=$cops and (gf_menor=1 or (gf_menor is null and gf_mayor is null)) and gf_estado=1 order by gf_nrodoc;";
		else $q="select *,'grupof_inq' as tabla from grupof_inq where gf_idcopr=$cops and (gf_menor=1 or (gf_menor is null and gf_mayor is null)) and gf_estado=1 order by gf_nrodoc;";
		$q=$this->db->query($q);
		return $q;
	}

	function actualizo_gf($user_id){
		$tipusu=$this->Sec_model->tipo_usuario($user_id);
		$elBarrio=$this->Sec_model->id_barrios_user($user_id)[0];
		$cop=$this->Sec_model->usuario_barrio_unidad($user_id,$elBarrio);
		$cops="";
		if($cop){
		    foreach($cop as $c){
			$cc=$c->cop_id;
			if(!$cops) $cops="($cc"; else $cops.=",$cc";
		    }
		    $cops.=")";
		
		    if($tipusu==1) $q="select * from grupof_d where gf_idcopr in $cops and (gf_nombre='' or gf_nrodoc='') and gf_estado=1;";
		    else $q="select * from grupof_inq where gf_idcopr in $cops and (gf_nombre='' or gf_nrodoc='') and gf_estado=1;";
		    $q=$this->db->query($q);
		    if($q->num_rows()>0){ 
    			$q=$q->result();
			return false;
		    }
		}

		return true;
	}


	function inh_grupof($cop,$user_id){
		$tipusu=$this->Sec_model->tipo_usuario($user_id);

		if($tipusu==1) $q="update grupof_d set gf_estado=999,gf_userid=$user_id where gf_idcopr=$cop and gf_estado=1;";
		else $q="update grupof_inq set gf_estado=999,gf_userid=$user_id where gf_idcopr=$cop and gf_estado=1;";
		$q=$this->db->query($q);
	}

	function cant_grupof($cop,$user_id,$may){
		$tipusu=$this->Sec_model->tipo_usuario($user_id);
		if($may==1){
		    $campo="gf_mayor";
		    if($tipusu==1) $q="select count(*) as canti from grupof_d where $campo=1 and gf_idcopr=$cop and gf_estado=1;";
		    else $q="select count(*) as canti from grupof_inq where $campo=1 and gf_idcopr=$cop and gf_estado=1;";
		}else{
		    $campo="gf_menor";
		    if($tipusu==1) $q="select count(*) as canti from grupof_d where ($campo=1 or (gf_mayor is null and gf_menor is null)) and gf_idcopr=$cop and gf_estado=1;";
		    else $q="select count(*) as canti from grupof_inq where ($campo=1 or (gf_mayor is null and gf_menor is null)) and gf_idcopr=$cop and gf_estado=1;";
		}
		$q=$this->db->query($q);
		return $q;
	}



	function get_idcontr($idcopr){
		$this->db->where('ct_idcopr', $idcopr);
		$this->db->where('ct_estado', '1');
		$q=$this->db->get('contratos');
		if($q->num_rows() >0){
			$q=$q->row()->ct_id;
			return $q;
		}else{
			return false;
		}
	}



	function edad_gf($fecha){
		if($fecha){
		    $q="select extract(year from age('$fecha'::date)) as edad;";
		    $q=$this->db->query($q);
		    if($q->num_rows() >0){
			$q=$q->row()->edad;
			return $q;
		    }else{
			return false;
		    }
		}else{
		    return false;
		}
	}


	function get_telmail($cop_id,$telmail){
		if($telmail==1) $tiptel="5"; else $tiptel="1,2,4,7";

		$q="select string_agg(tel_dato::text,' / ') as telmail from telefon where tel_codigo=$cop_id and tel_tipent=99 and tel_tiptel in ($tiptel);";
		$q=$this->db->query($q);
		$q=$q->row();
		return $q->telmail;
	}



	function deuda($cop_id){
		$q="select sum(astc_importe) as deuda from astoctas where astc_codemp=1 and astc_estado=2 and astc_tipcta=99 and astc_ctacble=1230 and astc_ctacte=$cop_id;";
		$q=$this->db->query($q);
		$q=$q->row();
		return $q->deuda;
	}

	function ultimalq($cop_id){
		$q="select sum(astc_importe) as deuda from astoctas where astc_idastoh in (select astc_idastoh from astoctas where astc_fecval<=now()::date and astc_ctacble=1230 and astc_ctacte=$cop_id and codcomp(astc_comprob)='LQ' order by astc_fecval desc limit 1) and  astc_codemp=1 and astc_estado=2 and astc_tipcta=99 and astc_ctacble=1230 and astc_ctacte=$cop_id;";
		$q=$this->db->query($q);
		$q=$q->row();
		if($q->deuda>0 && $cop_id!=2925) return $q->deuda;
		else return 1000000000;
	}






public function encriptar($session_id) {
    $key = 'maxilopez';
    $iv = $this->_getIv();
    $ciphertext = openssl_encrypt($session_id, self::SESS_CIPHER, $key, $options=OPENSSL_RAW_DATA, $iv);
    $encryptedSessionId = base64_encode($ciphertext);
    $encryptedSessionId = str_replace("=","_EQU_",$encryptedSessionId);
    $encryptedSessionId = str_replace("+","_MAS_",$encryptedSessionId);
    $encryptedSessionId = str_replace("/","_BARRA_",$encryptedSessionId);
    return $encryptedSessionId;
  }

public function ecrypt($session_id) {
    $key = 'maxilopez';
    $iv = $this->_getIv();
    $ciphertext = openssl_encrypt($session_id, self::SESS_CIPHER, $key, $options=OPENSSL_RAW_DATA, $iv);
    $encryptedSessionId = base64_encode($ciphertext);
    $encryptedSessionId = str_replace("=","_EQU_",$encryptedSessionId);
    $encryptedSessionId = str_replace("+","_MAS_",$encryptedSessionId);
    $encryptedSessionId = str_replace("/","_BARRA_",$encryptedSessionId);
    return $encryptedSessionId;
  }

  public function desencriptar($encryptedSessionId) {
    $encryptedSessionId=str_replace("_EQU_","=",$encryptedSessionId);
    $encryptedSessionId=str_replace("_MAS_","+",$encryptedSessionId);
    $encryptedSessionId=str_replace("_BARRA_","/",$encryptedSessionId);
    $key = 'maxilopez';
    $ivlen = openssl_cipher_iv_length('aes-128-cbc');
    $iv = substr(md5($key), 0, $ivlen);
    $decoded = base64_decode($encryptedSessionId,TRUE);
    $decryptedSessionId = openssl_decrypt($decoded, 'aes-128-cbc', $key, $options=OPENSSL_RAW_DATA, $iv);
    $session_id = $decryptedSessionId;
    return $session_id;
  }

  public function decrypt($encryptedSessionId) {
    $encryptedSessionId=str_replace("_EQU_","=",$encryptedSessionId);
    $encryptedSessionId=str_replace("_MAS_","+",$encryptedSessionId);
    $encryptedSessionId=str_replace("_BARRA_","/",$encryptedSessionId);
    $key = 'maxilopez';
    $ivlen = openssl_cipher_iv_length('aes-128-cbc');
    $iv = substr(md5($key), 0, $ivlen);
    $decoded = base64_decode($encryptedSessionId,TRUE);
    $decryptedSessionId = openssl_decrypt($decoded, 'aes-128-cbc', $key, $options=OPENSSL_RAW_DATA, $iv);
    $session_id = $decryptedSessionId;
    return $session_id;
  }


  public function _getIv() {
    $ivlen = openssl_cipher_iv_length(self::SESS_CIPHER);
    return substr(md5('maxilopez'), 0, $ivlen);
  }



function get_tiny_url($url)  {  
    $ch = curl_init();
    $timeout = 5;
    curl_setopt($ch,CURLOPT_URL,'http://tinyurl.com/api-create.php?url='.$url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
    curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);
    $data = curl_exec($ch);
    curl_close($ch);
    return $data;
}



	function get_user_prefs($id_user){
		$this->db->where('up_iduser', $id_user);
		$q=$this->db->get('user_prefs');
		if($q->num_rows() >0){
		    $q=$q->row();
		    return $q;
		}else{
		    return false;
		}
	}


	function Decode($string){
	    $tmp = $string;
	    $count = 0;
	    while (mb_detect_encoding($tmp)=="UTF-8"){
		$tmp = utf8_decode($tmp);
		$count++;
	    }

	    for ($i = 0; $i < $count-1 ; $i++){
		$string = utf8_decode($string);
	    }

//	    if(mb_detect_encoding($string)=="UTF-8") $string=utf8_decode($string);


	    return utf8_encode($string);
	}





}
    