<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Buscar extends CI_Controller {

	/**
	 * Index Page for this controller.
	 *
	 * Maps to the following URL
	 * 		http://example.com/index.php/welcome
	 *	- or -
	 * 		http://example.com/index.php/welcome/index
	 *	- or -
	 * Since this controller is set as the default controller in
	 * config/routes.php, it's displayed at http://example.com/
	 *
	 * So any other public methods not prefixed with an underscore will
	 * map to /index.php/welcome/<method_name>
	 * @see http://codeigniter.com/user_guide/general/urls.html
	 */

	public function __construct(){
		
		parent::__construct();
		$this->load->database();
	    $this->load->library(array('form_validation','email','secore'));
	    $this->load->helper(array('url','language','path','date'));
	    $this->load->model(array('Buscar_model'));
		if(!$this->secore->in_group(get_class())== TRUE){
	    	$this->session->set_flashdata('message','No tienes persisos para acceder a esta página');
	    	redirect('','refresh');
	    }
	    $id=api_get_user_id();
		$this->data['menu'] = $this->secore->menu();
	}

	public function index(){	
			
			$this->data['buscar_titulo'] = "Busqueda de registros en base de datos";

			$this->data['Campos_user_extra'] = $this->Buscar_model->select_Ext_('user')->result();
			
			$this->load->view('buscar/buscador',$this->data);
	}

	function buscador(){// vista miembros

			$this->data['buscar_titulo'] = "Busqueda de registros en base de datos";
			$this->data['cursos']=$this->Buscar_model->buscar('course');
			$this->data['sesiones']=$this->Buscar_model->buscar('session');
			$this->load->view('buscar/buscador',$this->data);
	}

	function buscar(){
			//para usuarios;
			$cursos=array();
			$sesiones=array();
			$ausente=array();
			$unlog=array();
			//filtros de cursos y sesiones
			$mas_alumnos=array();
			$menos_alumnos=array();
			$mas_certificados=array();
			$menos_certificados=array();
			$mas_finalizados=array();
			$menos_finalizados=array();
			$mas_lecciones=array();
			$menos_lecciones=array();

			//condicionales y valores usuarios
			if((!$this->input->post('curso')==NULL) && (!$this->input->post('code_course')==NULL)){
				$cursos=array($this->input->post('curso') => $this->input->post('code_course'));
			}
			if((!$this->input->post('sesion')==NULL) && (!$this->input->post('name_sesion')==NULL)){
				$sesiones=array($this->input->post('sesion') => $this->input->post('name_sesion'));
			}
			if((!$this->input->post('dias_sin_log')==NULL) && (!$this->input->post('dias_sin')==NULL)){
				$ausente=array($this->input->post('dias_sin_log') => $this->input->post('dias_sin'));
			}
			if((!$this->input->post('sin_log')==NULL) && (!$this->input->post('sin_log')==NULL)){
				$unlog=array($this->input->post('sin_log') => $this->input->post('sin_log'));
			}

			//condicionales y valores CURSOS y SESIONES
			if((!$this->input->post('mas_alumnos')==NULL) && (!$this->input->post('value_mas_alumnos')==NULL)){
				$mas_alumnos=array($this->input->post('mas_alumnos') => $this->input->post('value_mas_alumnos'));
			}
			if((!$this->input->post('menos_alumnos')==NULL) && (!$this->input->post('value_menos_alumnos')==NULL)){
				$menos_alumnos=array($this->input->post('menos_alumnos') => $this->input->post('value_menos_alumnos'));
			}
			if((!$this->input->post('mas_certificados')==NULL) && (!$this->input->post('value_mas_certificados')==NULL)){
				$mas_certificados=array($this->input->post('mas_certificados') => $this->input->post('value_mas_certificados'));
			}
			if((!$this->input->post('menos_certificados')==NULL) && (!$this->input->post('value_menos_certificados')==NULL)){
				$menos_certificados=array($this->input->post('menos_certificados') => $this->input->post('value_menos_certificados'));
			}
			if((!$this->input->post('mas_finalizados')==NULL) && (!$this->input->post('value_mas_finalizados')==NULL)){
				$mas_finalizados=array($this->input->post('mas_finalizados') => $this->input->post('value_mas_finalizados'));
			}
			if((!$this->input->post('menos_finalizados')==NULL) && (!$this->input->post('value_menos_finalizados')==NULL)){
				$menos_finalizados=array($this->input->post('menos_finalizados') => $this->input->post('value_menos_finalizados'));
			}
			if((!$this->input->post('mas_lecciones')==NULL) && (!$this->input->post('value_mas_lecciones')==NULL)){
				$mas_lecciones=array($this->input->post('mas_lecciones') => $this->input->post('value_mas_lecciones'));
			}
			if((!$this->input->post('menos_lecciones')==NULL) && (!$this->input->post('value_menos_lecciones')==NULL)){
				$menos_lecciones=array($this->input->post('menos_lecciones') => $this->input->post('value_menos_lecciones'));
			}

			
			$this->load->helper('date');
			$table=$this->input->post('tipo');
			$tipo_busqueda=$this->input->post('tipo_busqueda');

			if($table=='user'){
				$condiciones=array_merge($cursos,$sesiones,$ausente,$unlog);
				$this->buscar_usuarios($tipo_busqueda,$condiciones);
				
			}else if($table=='course'){
				$condiciones=array_merge($mas_alumnos,$menos_alumnos,$mas_certificados,$menos_certificados,$mas_finalizados,$menos_finalizados,$mas_lecciones,$menos_lecciones);
				$this->buscar_cursos($tipo_busqueda,$condiciones);
					
			}else if($table=='session'){
				$condiciones=array_merge($mas_alumnos,$menos_alumnos,$mas_certificados,$menos_certificados,$mas_finalizados,$menos_finalizados,$mas_lecciones,$menos_lecciones);
				$this->buscar_sesiones($tipo_busqueda,$condiciones);					
			}	
	}

	function buscar_usuarios($tipo_busqueda,$condiciones){ //revisar para que los campos extra se agreguen solo si existen
		$table='user';
		$extra=$this->Buscar_model->buscar_campos_extra('1');
		if($extra->num_rows() > 0){
			foreach($extra->result() as $campos_extra){
			$campo[]=$campos_extra->display_text;
			}
		}else{
			$campo=array();
		}
		
		
				
		if($tipo_busqueda=='uno'){
			$identificador=$this->input->post('official_code');
			$this->data['tabla']=$this->Buscar_model->buscar_por_identificador($table,$identificador);
			if($this->data['tabla']->num_rows() == 0){
				$this->session->set_flashdata('message', 'El usuario indicado no existe.');
				redirect('Buscar/buscador',$this->data);
			}
			foreach($this->data['tabla']->result() as $usuario){
				$nombre=$usuario->firstname;
				$apellido=$usuario->lastname;
			}				
			$this->data['buscar_titulo']='Mostrando información de <b>'.$nombre.' '.$apellido.'</b>.';

			//definimos grupos para thead y tfooter
			$general_set = array('ID','Codigo Of','Nombre','Apellido','Telefono','Email','Idioma','Fecha de registro','Último acceso','Rol','Estado');
			$general= array_merge($general_set,$campo);
			$cursos_set  = array('Cursos ','Cursos(F)','Certificados','Asistencia');
			$sesiones_set  = array('Sesiones','Sesiones(F)');
			$suma_set=array_merge($general,$cursos_set, $sesiones_set);
		}

		if($tipo_busqueda=='grupo'){
			$buscar_titulo="Resultado de la búsqueda de <b>Usuarios</b>";
			if(!empty($condiciones)){				
				$u=$this->Buscar_model->buscar('user')->result();
				foreach ($u as $us){
								$user_id[]=$us->user_id; //array de id's de cursos
							}
				//creamos los arrays de los filtros			
				$filtros_course=array();
				$filtros_session=array();
				$filtros_fecha=array();
				$filtros_unloged=array();

				//condicionamos a si está vacio o no
				if(isset($condiciones['course'])){
					$course=$condiciones['course'];
					$course_id=$this->Buscar_model->buscar_por_identificador('course',$course)->row();
					if(!$course_id==NULL){
						$c_id = $course_id->id;
					}else{
						$this->session->set_flashdata('message', 'El curso indicado no existe.');
						redirect('Buscar/buscador',$this->data);
					}
				}

				if(isset($condiciones['session'])){
					$session=$condiciones['session'];
					$sesion_id=$this->Buscar_model->buscar_por_identificador('session',$session)->row();
					if(!$sesion_id==NULL){
						$session_id = $sesion_id->id;
					}else{
						$this->session->set_flashdata('message', 'El sesión indicada no existe.');
						redirect('Buscar/buscador',$this->data);
					}
				}

				if(isset($condiciones['dias_sin_log'])){
					$dias_sin=$condiciones['dias_sin_log'];
					$fecha=$this->calcular_fecha($dias_sin);
				}

				//para filtro por CURSO solo
				if((isset($condiciones['course'])) AND (!isset($condiciones['session']))){
					foreach ($u as $us){
						$n=$this->Buscar_model->un_usuarios_en_curso($us->user_id,$c_id);
						if($n == TRUE){
							$filtros[]= $us->user_id;
						}							
					}						
				}
				//para filtro por SESION solo				
				if((isset($condiciones['session'])) AND (!isset($condiciones['course']))){
					unset($filtros);
					foreach ($u as $us){
						$n=$this->Buscar_model->un_usuarios_en_sesion($us->user_id,$session_id);
						if($n == TRUE){
							$filtros[]= $us->user_id;
						}							
					}		    					                						
				}
				//para filtro por SESION y CURSO
				if((isset($condiciones['session'])) AND (isset($condiciones['course']))){
					foreach ($u as $us){
						$n=$this->Buscar_model->usuario_en_sesiones_y_curso($c_id,$session_id);
						if($n->num_rows() > 0){
							foreach($n->result() as $us){
								$filtros[]= $us->user_id;
							}
						}else{
							unset($filtros);
						}							
					}		    					                						
				}


				//para filtro por DIAS_SIN_LOG
				if(isset($filtros)){$u=$this->Buscar_model->buscar($table,$filtros)->result();}
				if(isset($condiciones['dias_sin_log'])){
					unset($filtros);
					foreach ($u as $us){
						$n=$this->Buscar_model->dias_sin_log($us->user_id,$fecha);
						$nu=$this->Buscar_model->unloged($us->user_id);
						if(($n == TRUE) or ($nu == TRUE)) {
							$filtros[]= $us->user_id;
						}							
					}           					                						
				}

				$buscar_titulo='Resultado de la busqueda de usuarios';
				if(isset($condiciones['course'])){
					$buscar_titulo.=' en el curso <b>'.$course.'</b>';
				}
				if(isset($condiciones['session'])){
					$buscar_titulo.=' de la sesión <b>'.$session.'</b>';
				}
				if(isset($condiciones['dias_sin_log'])){
					$buscar_titulo.=' sin conectarse durante los últimos <b>'.$condiciones['dias_sin_log'].' días</b>';
				}
				$buscar_titulo.=':';
				
				if(!empty($filtros)){
					$this->data['tabla']=$this->Buscar_model->buscar($table,$filtros);
				}else{
					$buscar_titulo='<h2 class="tect-center" style="background-color:red;">No se han encontrado registros</h2>';

					$this->data['tabla']=$this->Buscar_model->buscar($table);
				}	
				$this->data['buscar_titulo']=$buscar_titulo;
				$general_set = array('ID','Codigo Of','Nombre','Apellido','Telefono','Email','Idioma','Fecha de registro','Último acceso','Rol','Grupos Panel','Estado');
				$general= array_merge($general_set,$campo);
				
				if((isset($condiciones['course']))AND(empty($condiciones['session']))){
					$cursos_set   = array('Primer acceso(C)','Último acceso(C)','Progreso Lecciones','Certificado','Asistencia(C)');
				}else{$cursos_set   = array('Cursos ','Cursos(F)','Certificados','Asistencia');}
				if(isset($condiciones['session'])){
					$sesiones_set = array('Primer acceso(S)','Último acceso(S)','Progreso(S)','Certificados(S)','Asistencia(S)');
				}else{$sesiones_set  = array('Sesiones','Sesiones(F)');}
				
				$suma_set=array_merge($general,$cursos_set, $sesiones_set);					
			}else{
				$this->data['buscar_titulo']=$buscar_titulo;
				$general_set = array('ID','Codigo Of','Nombre','Apellido','Telefono','Email','Idioma','Fecha de registro','Último acceso','Rol','Grupos Panel','Estado');
				$general= array_merge($general_set,$campo);
				$cursos_set   = array('Cursos ','Cursos(F)','Certificados','Asistencia');
				$sesiones_set  = array('Sesiones','Sesiones(F)');
				
				$suma_set=array_merge($general,$cursos_set, $sesiones_set);						
				$this->data['tabla']=$this->Buscar_model->buscar($table);
			}							
		}	

		//comenzamos a crear la tabla

		$template = array(
						'table_open' => '<table id="example" class="display table table-striped table-bordered text-center" cellspacing="0" width="100%">',
					);
		$this->load->library('table');
		$this->table->set_template($template);				
		$this->table->set_heading($suma_set); 
		$this->table->set_footer($suma_set);
		//pasamos los datos obtenidos
		foreach($this->data['tabla']->result() as $row) {
			//funciones para datos de cada registro encontrado
			$id     	 =anchor('Informes/usuario/'.$row->official_code, $row->user_id, 'class=""');//$row->user_id;
			$codigo 	 =$row->official_code;
			$nombre 	 =$row->firstname;
			$apellido 	 =$row->lastname;
			$telefono 	 =$row->phone;
			$email 		 =$row->email;
			$idioma      =$row->language;
			if($row->registration_date==NULL){$registro='-';}else{$registro=nice_date($row->registration_date, 'd-m-Y');}
			if($row->last_login==NULL){$ultimo_login='-';}else{$ultimo_login=nice_date($row->last_login, 'd-m-Y');}
			$status  	 =$this->secore->status($row->status);
			$panel  	 =$row->panel;
			$estado 	 =$this->secore->estado($row->active);
			//cursos
		    $cursos_t 	 =$this->Buscar_model->tot_item_num($row->user_id,'cursos')->num_rows();
		    $cursos_fin  =$this->secore->item_fin($row->user_id,'cursos');
			$certificados=$this->Buscar_model->certificados_user($row->user_id)->num_rows();
		    $asist 		 =$this->secore->asistencia($row->user_id,'0','0');
		    //sesiones
		    $sesiones 	 =$this->Buscar_model->tot_item_num($row->user_id,'sesiones')->num_rows();
			$sesion_fin  =$this->secore->item_fin($row->user_id,'sesiones');	  							  	
			//definimos los grupos de datos
			if($extra->num_rows() > 0){
				foreach($extra->result() as $campos_extra){
				$campo_val[]=$this->Buscar_model->buscar_valores_extra($campos_extra->id,$row->user_id)->value;
				}
				$campo_value=array_merge($campo_val);
				unset($campo_val);
			}else{
				$campo_value=array();
			}

		    if((isset($condiciones['course']))AND(empty($condiciones['session']))){
			    $first_acces_course  =$this->secore->first_acces_course($id,$c_id);
			    $last_acces_course=$this->secore->last_acces_course($id,$c_id);
		    	$progreso   =$this->secore->calc_progreso_user_curso($id, $c_id);
			    $certificados=$this->Buscar_model->certificados_user_course($row->user_id,$course_id->code);
			    $asist 		 =$this->secore->asistencia($row->user_id,$c_id,'0');
			}
			if(isset($condiciones['session'])){
			    $first_acces_course  =$this->secore->first_acces_session($id,$session_id);
			    $last_acces_course=$this->secore->last_acces_session($id,$session_id);
			    $progreso   =$this->secore->calc_progreso_user_session($id, $session_id);
			    $certificados=$this->Buscar_model->certificados_user_session($row->user_id,$session_id);
			    if(isset($condiciones['course'])){
			    	$asist 		 =$this->secore->asistencia($row->user_id,$c_id,$session_id);
			    }else{
			    	$asist 		 =$this->secore->asistencia($row->user_id,'0',$session_id);
			    }
			}		  								  	
			//definimos los grupos de datos
			$datos=array();
			$d_cursos=array();
			$d_sesiones=array();
			$datos=array(
				$id,
				$codigo,
				$nombre,
				$apellido,
				$telefono,
				$email,
				$idioma,
				$registro,
				$ultimo_login,
				$status,
				$panel,
				$estado,
			);
			$datos=array_merge($datos,$campo_value);
			
			if((isset($condiciones['course']))AND(empty($condiciones['session']))){
				$d_cursos=array(
					$first_acces_course,
					$last_acces_course,
					$progreso,
					$certificados,
					$asist
				);
			}else{
				$d_cursos=array(
					$cursos_t,
			  		$cursos_fin,
			  		$certificados,
			  		$asist
			  	);
			}
			if(isset($condiciones['session'])){
				$d_sesiones=array(
					$first_acces_course,
					$last_acces_course,
					$progreso,
					$certificados,
					$asist
				);
			}else{
				$d_sesiones=array(
			  		$sesiones,
			  		$sesion_fin
			  	);
			}		
			//unimos los grupos en un array
			$suma_row=array_merge(
				$datos,
				$d_cursos,
				$d_sesiones
			);
			//creamos las filas de la tabla con los datos de $suma_row
			$this->table->add_row($suma_row);
		}

		$this->data['collapse']="collapse";
		$this->load->view('buscar/tabla',$this->data);			
	}


	function buscar_cursos($tipo_busqueda,$condiciones){//revisar para que los campos extra se agreguen solo si existen
		$table='course';
		$extra=$this->Buscar_model->buscar_campos_extra('2');
		if($extra->num_rows() > 0){
			foreach($extra->result() as $campos_extra){
			$campo[]=$campos_extra->display_text;
			}
		}else{
			$campo=array();
		}
		
		//definimos grupos para thead y tfooter
		$general_set = array('ID','Codigo','Título','Categoría','Idioma','Creación','Expiración','Estado','Última modificación','Último acceso','Facultad','Lecciones','Alumnos','Profesores','Finalizado','% Fin','Certificados','Media de certificados','% Cert','Evaluaciones','Media de ejercicios','Asist. media','Sesiones');
		$general=array_merge($general_set,$campo);
		$suma_set=$general;
		$template = array( 
						'table_open'            => '<table id="example" class="display table table-striped table-bordered text-center" cellspacing="0" width="100%">',
					);
					
		if($tipo_busqueda=='uno'){
			$identificador=$this->input->post('code');
			$this->data['tabla']=$this->Buscar_model->buscar_por_identificador($table,$identificador);
			if($this->data['tabla']->num_rows() == 0){
				$this->session->set_flashdata('message', 'El curso indicado no existe.');
				redirect('Buscar/buscador',$this->data);
			}
			$nombre_curso=$this->data['tabla']->row();
			$this->data['buscar_titulo'] = "Resultado de la búsqueda del curso <b>".$nombre_curso->title."</b>.";
		}

		if($tipo_busqueda=='grupo'){

			$buscar_titulo="Resultado de la búsqueda de <b>Cursos</b>";
			if(!empty($condiciones)){

				$c=$this->Buscar_model->buscar('course')->result();//buscar los cursos
				foreach ($c as $cu){
					$c_id[]=$cu->id; //array de id's de cursos
					$code[]=$cu->code; //array de id's de cursos
				}
				//creamos los arrays de los filtros
				$mas_alumnos_f=array();
				$menos_alumnos=array();
				$mas_certificados=array();
				$menos_certificados=array();
				$mas_finalizados=array();
				$menos_finalizados=array();
				$mas_lecciones=array();
				$menos_lecciones=array();

				//condicionamos a si está vacio o no
				if(isset($condiciones['mas_alumnos'])){
					$mas_usuarios=$condiciones['mas_alumnos'];										
					$buscar_titulo.=" con al menos ".$mas_usuarios." alumnos";
				}

				if(isset($condiciones['menos_alumnos'])){
					$menos_usuarios=$condiciones['menos_alumnos'];										
					$buscar_titulo.=" con un máximo de ".$menos_usuarios." alumnos";
				}

				if(isset($condiciones['mas_certificados'])){
					$mas_certificados=$condiciones['mas_certificados'];										
					$buscar_titulo.=" con al menos ".$mas_certificados." certificados emitidos";
				}

				if(isset($condiciones['menos_certificados'])){
					$menos_certificados=$condiciones['menos_certificados'];										
					$buscar_titulo.=" con un máximo de ".$menos_certificados." certificados emitidos";
				}

				if(isset($condiciones['mas_finalizados'])){
					$mas_finalizados=$condiciones['mas_finalizados'];										
					$buscar_titulo.=" que hayan sido al menos ".$mas_finalizados." veces finalizado";
				}

				if(isset($condiciones['menos_finalizados'])){
					$menos_finalizados=$condiciones['menos_finalizados'];										
					$buscar_titulo.=" que hayan sido como máximo ".$menos_finalizados." veces finalizados";
				}

				if(isset($condiciones['mas_lecciones'])){
					$mas_lecciones=$condiciones['mas_lecciones'];										
					$buscar_titulo.=" con al menos ".$mas_lecciones." lecciones";
				}

				if(isset($condiciones['menos_lecciones'])){
					$menos_lecciones=$condiciones['menos_lecciones'];										
					$buscar_titulo.=" con un máximo de ".$menos_lecciones." lecciones";
				}

				//numero de alumnos
				if((isset($condiciones['mas_alumnos'])) AND (!isset($condiciones['menos_alumnos']))){
					foreach ($c_id as $c){
						$n=$this->Buscar_model->alumnos_en_curso($c)->num_rows();
						if($n >= $mas_usuarios){
							$filtros[]= $c;
						}
					}
				}else if((isset($condiciones['mas_alumnos'])) AND (isset($condiciones['menos_alumnos']))){
					foreach ($c_id as $c){
						$n=$this->Buscar_model->alumnos_en_curso($c)->num_rows();
						if(($n >= $mas_usuarios) AND ($n <= $menos_usuarios)){
							$filtros[]= $c;
						}
					}
				}else if((!isset($condiciones['mas_alumnos'])) AND (isset($condiciones['menos_alumnos']))){
					foreach ($c_id as $c){
						$n=$this->Buscar_model->alumnos_en_curso($c)->num_rows();
						if($n <= $menos_usuarios){
							$filtros[]= $c;
						}
					}
				}
				
				//numero de certifiacdos
				//si existen filtros, $c toma el valor de los id de los curson ya filtrados.
				if(isset($filtros)){$c=$this->Buscar_model->buscar($table,$filtros)->result();}
				if((isset($condiciones['mas_certificados'])) AND (!isset($condiciones['menos_certificados']))){
					foreach ($c as $cu){
						$n=$this->secore->certificados_del_curso($cu->id,$cu->code);
						if($n >= $mas_certificados){
							$filtros[]= $cu->id;
						}
					}
				}else if((isset($condiciones['mas_certificados'])) AND (isset($condiciones['menos_certificados']))){
					foreach ($c_id as $c){
						$n=$this->secore->certificados_del_curso($cu->id,$cu->code);
						if(($n >= $mas_certificados) AND ($n <= $menos_certificados)){
							$filtros[]= $cu->id;
						}
					}
				}else if((!isset($condiciones['mas_certificados'])) AND (isset($condiciones['menos_certificados']))){
					foreach ($c_id as $c){
						$n=$this->secore->certificados_del_curso($cu->id,$cu->code);
						if($n <= $menos_certificados){
							$filtros[]= $cu->id;
						}
					}
				}

				//numero de finalizados
				//si existen filtros, $c toma el valor de los id de los curson ya filtrados.
				if(isset($filtros)){$c=$this->Buscar_model->buscar($table,$filtros)->result();}
				if((isset($condiciones['mas_finalizados'])) AND (!isset($condiciones['menos_finalizados']))){
					foreach ($c as $cu){
						$n=$this->curso_veces_finalizado($cu->id);
						if($n >= $mas_finalizados){
							$filtros[]= $cu->id;
						}
					}
				}else if((isset($condiciones['mas_finalizados'])) AND (isset($condiciones['menos_finalizados']))){
					foreach ($c_id as $c){
						$n=$this->secore->curso_veces_finalizado($cu->id);
						if(($n >= $mas_finalizados) AND ($n <= $menos_finalizados)){
							$filtros[]= $cu->id;
						}
					}
				}else if((!isset($condiciones['mas_finalizados'])) AND (isset($condiciones['menos_finalizados']))){
					foreach ($c_id as $c){
						$n=$this->secore->curso_veces_finalizado($cu->id);
						if($n <= $menos_finalizados){
							$filtros[]= $cu->id;
						}
					}
				}


				//numero de lecciones
				//si existen filtros, $c toma el valor de los id de los curson ya filtrados.
				if(isset($filtros)){$c=$this->Buscar_model->buscar($table,$filtros)->result();}
				if((isset($condiciones['mas_lecciones'])) AND (!isset($condiciones['menos_lecciones']))){
					foreach ($c as $cu){
						$n=$this->Buscar_model->lecciones_en_curso($cu->id)->num_rows();
						if($n >= $mas_lecciones){
							$filtros[]= $cu->id;
						}
					}
				}else if((isset($condiciones['mas_lecciones'])) AND (isset($condiciones['menos_lecciones']))){
					foreach ($c_id as $c){
						$n=$this->Buscar_model->lecciones_en_curso($cu->id)->num_rows();
						if(($n >= $mas_lecciones) AND ($n <= $menos_lecciones)){
							$filtros[]= $cu->id;
						}
					}
				}else if((!isset($condiciones['mas_lecciones'])) AND (isset($condiciones['menos_lecciones']))){
					foreach ($c_id as $c){
						$n=$this->Buscar_model->lecciones_en_curso($cu->id)->num_rows();
						if($n <= $menos_lecciones){
							$filtros[]= $cu->id;
						}
					}
				}

				$buscar_titulo .=".";
				if(!empty($filtros)){
					$this->data['tabla']=$this->Buscar_model->buscar($table,$filtros);
				}else{
					$buscar_titulo='<h2 class="tect-center" style="background-color:red;">No se han encontrado registros</h2>';
					$this->data['tabla']=$this->Buscar_model->buscar($table);
				}
				
				$this->data['buscar_titulo'] = $buscar_titulo;

			}else{
				$this->data['tabla']=$this->Buscar_model->buscar('course');
				$this->data['buscar_titulo'] = "Resultado de la búsqueda de <b>Cursos</b>";
			}			
		}

		$this->load->library('table');
		$this->table->set_template($template);				
		$this->table->set_heading($suma_set); //set your headings
		$this->table->set_footer($suma_set);				
		foreach($this->data['tabla']->result() as $row) { 
			$id=$row->id;
			$codigo=$row->code;
			$titulo=$row->title;
			$categoria=$row->category_code;
			$idioma=$row->course_language;
			if($row->creation_date==NULL){$f_creacion='-';}else{$f_creacion=nice_date($row->creation_date, 'd-m-Y');}
			if($row->expiration_date==NULL){$f_expiracion='-';}else{$f_expiracion=nice_date($row->expiration_date, 'd-m-Y');}
			$estado=$this->secore->estado_curso($row->visibility);
			if($row->last_edit==NULL){$last_mod='-';}else{$last_mod=nice_date($row->last_edit, 'd-m-Y');}
			if($row->last_visit==NULL){$last_visit='-';}else{$last_visit=nice_date($row->last_visit, 'd-m-Y');}
			if(!$row->department_name==NULL){
				if(!$row->department_url==NULL){
					$facultad=anchor($row->department_url, $row->department_name);
				}else{
					$facultad=$row->department_name;;
				}
			}else{								
				$facultad='-';	
			}
						
			$lecciones=$this->Buscar_model->lecciones_en_curso($row->id)->num_rows();
			$data = array(
			        'name'          => 'alumnos',
			        'id'            => $row->code,
			        'class'			=> 'btn btn-link value_input_curso',
			        'value'         => $row->code,
			        'type'          => 'button',
			        'content'       => $this->Buscar_model->alumnos_en_curso($row->id)->num_rows()
			);
			$alumnos=form_button($data);
			$profes= $this->Buscar_model->profesores_en_curso($row->id)->num_rows();
			$finalizados=$this->secore->curso_veces_finalizado($row->id);
			$fin100=$this->secore->por_100_finalizado($row->id);
			$certificados=$this->secore->certificados_del_curso($row->id,$row->code);
			$media_cert=$this->secore->media_certificados_curso($certificados,$row->id,$row->code);
			$cert100=$this->secore->por_100_certificado($row->id,$row->code);
			$evaluaciones=$this->secore->evaluaciones($row->id,$row->code);
			$score_media=$this->secore->score_media($row->id);
			$asist_media=$this->secore->asistencia_media($row->id);
			$sesiones=$this->Buscar_model->sesiones_del_curso($row->id)->num_rows();
			//definivos valores de campos extra, si existen
			if($extra->num_rows() > 0){
				foreach($extra->result() as $campos_extra){
				$campo_val[]=$this->Buscar_model->buscar_valores_extra($campos_extra->id,$row->id)->value;
				}
				$campo_value=array_merge($campo_val);
				unset($campo_val);
			}else{
				$campo_value=array();
			}

			$datos=array(
				$id,
				$codigo,
				$titulo,
				$categoria,
				$idioma,
				$f_creacion,
				$f_expiracion,
				$estado,
				$last_mod,
				$last_visit,
				$facultad,
				$lecciones,
				$alumnos,
				$profes,
				$finalizados,
				$fin100,
				$certificados,
				$media_cert,
				$cert100,
				$evaluaciones,
				$score_media,
				$asist_media,
				$sesiones,
			);

			$datos=array_merge($datos,$campo_value);				
						  	
			//unimos los grupos en un array
			$suma_row=array_merge($datos);

			//creamos las filas de la tabla con los datos de $suma_row
			$this->table->add_row($suma_row);
		}
		//pasamos a la vista
		$this->data['collapse']="collapse";
		$this->load->view('buscar/tabla',$this->data);
	}

	function buscar_sesiones($tipo_busqueda,$condiciones){
		$table='session';
		$extra=$this->Buscar_model->buscar_campos_extra('3');
		if($extra->num_rows() > 0){
			foreach($extra->result() as $campos_extra){
			$campo[]=$campos_extra->display_text;
			}
		}else{
			$campo=array();
		}
		//definimos grupos para thead y tfooter
		$general_set = array('ID','Nombre','Categoría','Creador','Tutor','Nº Cursos','Nº Lecciones','Nº Alumnos','Inicio','Finalización','Estado tras finalización','Duración','Accesible DESDE:','Accesible HASTA:','Acceso de tutores DESDE:','Acceso de tutores HASTA:','Veces finalizada','% Fin','Certificados emitidos','Media de certificados','% Cert','Asistencia Total','Asist. media');
		$suma_set=array_merge($general_set,$campo);

					$this->data['buscar_titulo'] = "Resultado de la búsqueda de Sesiones";
					if($tipo_busqueda=='uno'){
						$identificador=$this->input->post('code');
						$this->data['tabla']=$this->Buscar_model->buscar_por_identificador($table,$identificador);
						if($this->data['tabla']->num_rows() == 0){
							$this->session->set_flashdata('message', 'La sesión indicada no existe.');
							redirect('Buscar/buscador',$this->data);
						}
					}

					if($tipo_busqueda=='grupo'){
						$buscar_titulo="Resultado de la búsqueda de <b>Sesiones</b>";
						if(!empty($condiciones)){

							$s=$this->Buscar_model->buscar('session')->result();//buscar los cursos
							foreach ($s as $se){
								$session_id[]=$se->id; //array de id's de cursos
							}
							//creamos los arrays de los filtros
							$mas_alumnos_f=array();
							$menos_alumnos=array();
							$mas_certificados=array();
							$menos_certificados=array();
							$mas_finalizados=array();
							$menos_finalizados=array();
							$mas_lecciones=array();
							$menos_lecciones=array();

							//condicionamos a si está vacio o no
							if(isset($condiciones['mas_alumnos'])){
								$mas_usuarios=$condiciones['mas_alumnos'];										
								$buscar_titulo.=" con al menos ".$mas_usuarios." alumnos";
							}

							if(isset($condiciones['menos_alumnos'])){
								$menos_usuarios=$condiciones['menos_alumnos'];										
								$buscar_titulo.=" con un máximo de ".$menos_usuarios." alumnos";
							}

							if(isset($condiciones['mas_certificados'])){
								$mas_certificados=$condiciones['mas_certificados'];										
								$buscar_titulo.=" con al menos ".$mas_certificados." certificados emitidos";
							}

							if(isset($condiciones['menos_certificados'])){
								$menos_certificados=$condiciones['menos_certificados'];										
								$buscar_titulo.=" con un máximo de ".$menos_certificados." certificados emitidos";
							}

							if(isset($condiciones['mas_finalizados'])){
								$mas_finalizados=$condiciones['mas_finalizados'];										
								$buscar_titulo.=" que hayan sido al menos ".$mas_finalizados." veces finalizado";
							}

							if(isset($condiciones['menos_finalizados'])){
								$menos_finalizados=$condiciones['menos_finalizados'];										
								$buscar_titulo.=" que hayan sido como máximo ".$menos_finalizados." veces finalizados";
							}

							if(isset($condiciones['mas_lecciones'])){
								$mas_lecciones=$condiciones['mas_lecciones'];										
								$buscar_titulo.=" con al menos ".$mas_lecciones." lecciones";
							}

							if(isset($condiciones['menos_lecciones'])){
								$menos_lecciones=$condiciones['menos_lecciones'];										
								$buscar_titulo.=" con un máximo de ".$menos_lecciones." lecciones";
							}

							//numero de alumnos
							if((isset($condiciones['mas_alumnos'])) AND (!isset($condiciones['menos_alumnos']))){
								foreach ($session_id as $s){
									$n=$this->Buscar_model->usuarios_en_sesion($s)->num_rows();
									if($n >= $mas_usuarios){
										$filtros[]= $s;
									}
								}
							}else if((isset($condiciones['mas_alumnos'])) AND (isset($condiciones['menos_alumnos']))){
								foreach ($session_id as $s){
									$n=$this->Buscar_model->usuarios_en_sesion($s)->num_rows();
									if(($n >= $mas_usuarios) AND ($n <= $menos_usuarios)){
										$filtros[]= $s;
									}
								}
							}else if((!isset($condiciones['mas_alumnos'])) AND (isset($condiciones['menos_alumnos']))){
								foreach ($session_id as $s){
									$n=$this->Buscar_model->usuarios_en_sesion($s)->num_rows();
									if($n <= $menos_usuarios){
										$filtros[]= $s;
									}
								}
							}
							
							//numero de certifiacdos
							//si existen filtros, $c toma el valor de los id de los curson ya filtrados.
							if(isset($filtros)){$s=$this->Buscar_model->buscar($table,$filtros)->result();}
							if((isset($condiciones['mas_certificados'])) AND (!isset($condiciones['menos_certificados']))){
								unset($filtros);$filtros[]='';
								foreach ($s as $se){
									$n=$this->secore->certificados_en_sesion($se->id);
									if($n >= $mas_certificados){
										$filtros[]= $se->id;
									}
								}
							}else if((isset($condiciones['mas_certificados'])) AND (isset($condiciones['menos_certificados']))){
								unset($filtros);$filtros[]='';
								foreach ($s as $se){
									$n=$this->secore->certificados_en_sesion($se->id);
									if(($n >= $mas_certificados) AND ($n <= $menos_certificados)){
										$filtros[]= $se->id;
									}
								}
							}else if((!isset($condiciones['mas_certificados'])) AND (isset($condiciones['menos_certificados']))){
								unset($filtros);$filtros[]='';
								foreach ($s as $se){
									$n=$this->secore->certificados_en_sesion($se->id);
									if($n <= $menos_certificados){
										$filtros[]= $se->id;
									}
								}
							}

							//numero de finalizados
							//si existen filtros, $c toma el valor de los id de los curson ya filtrados.
							if(isset($filtros)){$s=$this->Buscar_model->buscar($table,$filtros)->result();}
							if((isset($condiciones['mas_finalizados'])) AND (!isset($condiciones['menos_finalizados']))){
								unset($filtros);$filtros[]='';
								foreach ($s as $se){
									$n=$this->secore->finalizadas($se->id);
									if($n >= $mas_finalizados){
										$filtros[]= $se->id;
									}
								}
							}else if((isset($condiciones['mas_finalizados'])) AND (isset($condiciones['menos_finalizados']))){
								unset($filtros);$filtros[]='';
								foreach ($s as $se){
									$n=$this->secore->finalizadas($se->id);
									if(($n >= $mas_finalizados) AND ($n <= $menos_finalizados)){
										$filtros[]= $se->id;
									}
								}
							}else if((!isset($condiciones['mas_finalizados'])) AND (isset($condiciones['menos_finalizados']))){
								unset($filtros);$filtros[]='';
								foreach ($s as $se){
									$n=$this->secore->finalizadas($se->id);
									if($n <= $menos_finalizados){
										$filtros[]= $se->id;
									}
								}
							}


							//numero de lecciones
							//si existen filtros, $c toma el valor de los id de los curson ya filtrados.
							if(isset($filtros)){$s=$this->Buscar_model->buscar($table,$filtros)->result();}
							if((isset($condiciones['mas_lecciones'])) AND (!isset($condiciones['menos_lecciones']))){
								unset($filtros);$filtros[]='';
								foreach ($s as $se){
									$n=$this->secore->lecciones_en_sesion($se->id);
									if($n >= $mas_lecciones){
										$filtros[]= $se->id;
									}
								}
							}else if((isset($condiciones['mas_lecciones'])) AND (isset($condiciones['menos_lecciones']))){
								unset($filtros);$filtros[]='';
								foreach ($s as $se){
									$n=$this->secore->lecciones_en_sesion($se->id);
									if(($n >= $mas_lecciones) AND ($n <= $menos_lecciones)){
										$filtros[]= $se->id;
									}
								}
							}else if((!isset($condiciones['mas_lecciones'])) AND (isset($condiciones['menos_lecciones']))){
								unset($filtros);$filtros[]='';
								foreach ($s as $se){
									$n=$this->secore->lecciones_en_sesion($se->id);
									if($n <= $menos_lecciones){
										$filtros[]= $se->id;
									}
								}
							}

							$buscar_titulo .=".";
							if(!empty($filtros)){
								$this->data['tabla']=$this->Buscar_model->buscar($table,$filtros);
							}else{
								$buscar_titulo='<h2 class="tect-center" style="background-color:red;">No se han encontrado registros</h2>';
								$this->data['tabla']=$this->Buscar_model->buscar($table);
							}
							$this->data['buscar_titulo'] = $buscar_titulo;

						}else{
							$this->data['tabla']=$this->Buscar_model->buscar($table);
						}
					}
					
					$template = array( 
								'table_open'            => '<table id="example" class="display table table-striped table-bordered" cellspacing="0" width="100%">',
								'th' =>'<th style="width:auto;">'
						);

						$this->load->library('table');
						$this->table->set_template($template);				
						$this->table->set_heading($suma_set); //set your headings
						$this->table->set_footer($suma_set);
								
						foreach($this->data['tabla']->result() as $row) { //set your rows here
							$data = array(
							        'name'          => 'alumnos',
							        'id'            => $row->id,
							        'class'			=> 'btn btn-link value_input_sesion',
							        'value'         => $row->name,
							        'type'          => 'button',
							        'content'       => $row->nbr_users
							);
							$id=$row->id;
							$nombre=$row->name;
							$categoria=$row->session_category_id;								
							$admin=$this->secore->nombre_usuario($row->session_admin_id);
							$coach=$this->secore->nombre_usuario($row->id_coach);
							$cursos=$row->nbr_courses;
							$lecciones=$this->Buscar_model->lecciones_en_sesion($row->id)->num_rows();
							$alumnos=form_button($data);	
							if($row->display_start_date==NULL){$inicio='-';}else{$inicio=nice_date($row->display_start_date, 'd-m-Y');}
							if($row->display_end_date==NULL){$final='-';}else{$final=nice_date($row->display_end_date, 'd-m-Y');}
							$visibilidad=$this->secore->visibilidad_sesion($row->visibility);
							$duracion=$row->duration;
							if($row->access_start_date==NULL){$first_acces='-';}else{$first_acces=nice_date($row->access_start_date, 'd-m-Y');}
							if($row->access_end_date==NULL){$last_acces='-';}else{$last_acces=nice_date($row->access_end_date, 'd-m-Y');}
							if($row->coach_access_start_date==NULL){$first_admin_acces='-';}else{$first_admin_acces=nice_date($row->coach_access_start_date, 'd-m-Y');}
							if($row->coach_access_end_date==NULL){$last_admin_acces='-';}else{$last_admin_acces=nice_date($row->coach_access_end_date, 'd-m-Y');}

							$finalizadas	=	$this->secore->finalizadas($row->id);
							$fin100			=	$this->secore->sesion_por_100_finalizada($row->id);
							$certificados 	=	$this->secore->certificados_en_sesion($row->id);
							$media_cert 	=	$this->secore->media_certificados_sesion($row->id);
							$cert100 		=	$this->secore->por_100_certificado_session($row->id,$certificados);
							$asistencia 	=  	$this->secore->asistencia_total_sesion($row->id);
							$asist_media 	=	$this->secore->asistencia_media_sesion($row->id);
							

							if($extra->num_rows() > 0){
								foreach($extra->result() as $campos_extra){
								$campo_val[]=$this->Buscar_model->buscar_valores_extra($campos_extra->id,$row->id)->value;
								}
								$campo_value=array_merge($campo_val);
								unset($campo_val);
							}else{
								$campo_value=array();
							}
							$datos=array(
								$id,
								$nombre,
								$categoria,								
								$admin,
								$coach,
								$cursos,
								$lecciones,
								$alumnos,
								$inicio,
								$final,
								$visibilidad,
								$duracion,
								$first_acces,
								$last_acces,
								$first_admin_acces,
								$last_admin_acces,
								//
								$finalizadas,
								$fin100,
								$certificados,
								$media_cert,
								$cert100,
								$asistencia,
								$asist_media,
								
							);

							$datos=array_merge($datos,$campo_value);				
						  	
						  	//unimos los grupos en un array
						  	$suma_row=array_merge(
						  		$datos
						  	);


						  	//creamos las filas de la tabla con los datos de $suma_row
						    $this->table->add_row($suma_row);
						}
			$this->data['collapse']="collapse";
			$this->load->view('buscar/tabla',$this->data);
	}

	


	//Ayuda Programación BD
	function ver_tabs_rel(){
		$this->data['buscar_titulo'] = "Relación entre tablas de Usuarios-Cursos_sesiones.";
		$this->load->view('admin/tab_rel_user',$this->data);	
	}
    //tablas 
	function buscar_tablas($tabla,$campos=NULL){
			if($campos=='si'){
				$this->data['ver_campos']='si';
			}else{
				$this->data['ver_campos']='no';
			}
			$q=$this->Buscar_model->select_campos($tabla);
			$this->data['q']=$q;
			$this->data['buscar_titulo'] = "Tablas relacionadas con <b>".$tabla."</b>.";
			$this->load->view('buscar/tabla_campos',$this->data);           			            	
	}

	
	
}