<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Vehiculos extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Sec_model','Vehiculos_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));



		$admins = array(1);
		$this->data['admins'] = $admins;
		$this->data['barrio'] = $this->Vehiculos_model->getBarrio();
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list


	public function view(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Vehiculos_model->getBarrio();
		$this->data['barrio'] = $barrio;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barriox){	//descomponemos para usar valores
			    $this->data['barr_user'][$barriox->ptv_id]= $this->Sec_model->ver_barrios($barriox->ptv_id);
			    $this->data['unidades_user'][$barriox->ptv_id][]= $this->Sec_model->ver_unidades($barriox->ufd);
			}
		    }
		}


		$cops=$this->Vehiculos_model->get_livianos($user->id);
		$this->data['vehiculos']=$cops;
		$this->_render_page('vehiculos/list', $this->data);
	    }

	}




	public function nuevo($idVehi = NULL){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Vehiculos_model->getBarrio();
		$this->data['barrio'] = $barrio;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barriox){	//descomponemos para usar valores
			    $this->data['barr_user'][$barriox->ptv_id]= $this->Sec_model->ver_barrios($barriox->ptv_id);
			    $this->data['unidades_user'][$barriox->ptv_id][]= $this->Sec_model->ver_unidades($barriox->ufd);
			}
		    }
		}

		$this->data['segauto'] = NULL;
		$this->data['vtoauto'] = NULL;

		if($idVehi){
		    $lv_id=$this->Vehiculos_model->get_lv($idVehi);
		    if($lv_id){
			$this->data['fm'] = $lv_id;
			$this->data['segauto'] = $lv_id[0]->lv_segauto;
			$this->data['vtoauto'] = $lv_id[0]->lv_vtoauto;
		    }
		}

		$this->_render_page('vehiculos/new', $this->data);
	    }

	}





	function GrabarNuevo(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{

                $config['upload_path']          = './uploads/visitas/';
                $config['allowed_types']        = 'gif|jpg|png|pdf|doc|docx|jpeg';
                $config['max_size']             = 1024;
                $this->load->library('upload', $config);


		$tables = $this->config->item('tables','ion_auth');
		$this->form_validation->set_rules('marca', 'Marca', 'required');
		$this->form_validation->set_rules('modelo', 'Modelo', 'required');
		$this->form_validation->set_rules('patente', 'Patente', 'required');
		$this->form_validation->set_rules('segauto', 'Empresa Aseguradora', 'required');
		$this->form_validation->set_rules('vtoauto', 'Vencimiento Seguro', 'required');


		if ($this->form_validation->run() === TRUE){
		    $fileauto="";
		    if(isset($_FILES)){
			if ($this->upload->do_upload('file_auto')) {
			    $upload_data = $this->upload->data();
			    $data_ary = array(
				'title'     => $upload_data['client_name'],
				'file'      => $upload_data['file_name'],
				'width'     => $upload_data['image_width'],
				'height'    => $upload_data['image_height'],
				'type'      => $upload_data['image_type'],
				'size'      => $upload_data['file_size'],
				'path'      => $upload_data['full_path'],
				'date'      => time(),
			    );
			    $data = array('upload_data' => $upload_data);
			    $fileauto=$data_ary['path'];
			}else{
			    if($_FILES['file_auto']['error'] != 4){
				$error = array('error' => $this->upload->display_errors());
				$new_data=array(
				    'pestania_activa'=>'visitas',
				    'message'=>$error
				);
				$this->session->set_flashdata($new_data);
				redirect('Vehiculos/nuevo', $this->data);
			    }
			}
		    }



		    $tipusu=$this->Sec_model->tipo_usuario($user->id);
		    $elBarrio = $this->Vehiculos_model->getBarrio();
		    $cops=$this->Sec_model->usuario_barrio_unidad($user->id,$elBarrio);
		    $cop=$cops[0];
		    $idcopr=$cop->cop_id;

		    $marca = $this->input->post('marca');
		    $modelo = $this->input->post('modelo');
		    $patente = $this->input->post('patente');
		    $color = $this->input->post('color');
		    $patente = $this->input->post('patente');
		    $segauto = $this->input->post('segauto');
		    $vtoauto = $this->input->post('vtoauto');
		    $obs = $this->input->post('obs');

		    $tabla1='livianos';
		    $datos1=array(
			'lv_iduser'=> $user->id,
			'lv_tipusu'=> $tipusu,
			'lv_idcopr'=> $idcopr,
			'lv_marca'=> $marca,
			'lv_modelo'=> $modelo,
			'lv_color'=> $color,
			'lv_patente' => $patente,
			'lv_segauto'    => $segauto,
			'lv_vtoauto'    => $vtoauto,
			'lv_fileauto'    => $fileauto,
			'lv_obs' => $obs,
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }

		    redirect('Vehiculos/view', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Vehiculos/nuevo', $this->data);
	        }
	    }
	}


	function EditLv(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{

                $config['upload_path']          = './uploads/visitas/';
                $config['allowed_types']        = 'gif|jpg|png|pdf|doc|docx|jpeg';
                $config['max_size']             = 1024;
                $this->load->library('upload', $config);


		$tables = $this->config->item('tables','ion_auth');
		$this->form_validation->set_rules('lv_id', 'Vehiculo', 'required');
		$this->form_validation->set_rules('marca', 'Marca', 'required');
		$this->form_validation->set_rules('modelo', 'Modelo', 'required');
		$this->form_validation->set_rules('patente', 'Patente', 'required');
		$this->form_validation->set_rules('segauto', 'Empresa Aseguradora', 'required');
		$this->form_validation->set_rules('vtoauto', 'Vencimiento Seguro', 'required');


		if ($this->form_validation->run() === TRUE){
		    $fileauto="";
		    if(isset($_FILES)){
			if ($this->upload->do_upload('file_auto')) {
			    $upload_data = $this->upload->data();
			    $data_ary = array(
				'title'     => $upload_data['client_name'],
				'file'      => $upload_data['file_name'],
				'width'     => $upload_data['image_width'],
				'height'    => $upload_data['image_height'],
				'type'      => $upload_data['image_type'],
				'size'      => $upload_data['file_size'],
				'path'      => $upload_data['full_path'],
				'date'      => time(),
			    );
			    $data = array('upload_data' => $upload_data);
			    $fileauto=$data_ary['path'];
			}else{
			    if($_FILES['file_auto']['error'] != 4){
				$error = array('error' => $this->upload->display_errors());
				$new_data=array(
				    'pestania_activa'=>'visitas',
				    'message'=>$error
				);
				$this->session->set_flashdata($new_data);
				redirect('Vehiculos/nuevo', $this->data);
			    }
			}
		    }



		    $tipusu=$this->Sec_model->tipo_usuario($user->id);
		    $elBarrio = $this->Vehiculos_model->getBarrio();
		    $cops=$this->Sec_model->usuario_barrio_unidad($user->id,$elBarrio);
		    $cop=$cops[0];
		    $idcopr=$cop->cop_id;

		    $lv_id = $this->input->post('lv_id');
		    $marca = $this->input->post('marca');
		    $modelo = $this->input->post('modelo');
		    $patente = $this->input->post('patente');
		    $color = $this->input->post('color');
		    $patente = $this->input->post('patente');
		    $segauto = $this->input->post('segauto');
		    $vtoauto = $this->input->post('vtoauto');
		    $obs = $this->input->post('obs');

		    $tabla1='livianos';
		    $datos1=array(
			'lv_iduser'=> $user->id,
			'lv_tipusu'=> $tipusu,
			'lv_idcopr'=> $idcopr,
			'lv_marca'=> $marca,
			'lv_modelo'=> $modelo,
			'lv_color'=> $color,
			'lv_patente' => $patente,
			'lv_segauto'    => $segauto,
			'lv_vtoauto'    => $vtoauto,
			'lv_fileauto'    => $fileauto,
			'lv_obs' => $obs,
		    );
		    if($this->Sec_model->update_p($tabla1,'lv_id',$lv_id,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }

		    redirect('Vehiculos/view', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Vehiculos/nuevo', $this->data);
	        }
	    }
	}







	function del($lv_id){

	    $user=$this->ion_auth->user()->row();
	    $user_id=$user->id;
	    $barrio=$this->Sec_model->getBarrio();
	    $ufs = $this->Sec_model->unidades_barrio_prop($user_id,$barrio);

	    $data = array(
		    "lv_estado" => 999,
	    );

	    $this->Sec_model->update_p('livianos','lv_id',$lv_id,$data);

	    redirect('Vehiculos/view', $this->data);

	}




	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}