<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Tennis extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Tennis_model','Reservas_model','Sec_model','calendario_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));



		$admins = array(1,3);
		$this->data['admins'] =array(1,3);
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
			    $this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
			    $this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
			}
		    }
		}


		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list
	function errores(){

	    $user=$this->ion_auth->user()->row();
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$this->data['error']=$this->session->flashdata('message');
		$this->load->view('body/errores', $this->data);
	    }
	}


	function index($amenity = NULL, $horadef = NULL){

	    $user=$this->ion_auth->user()->row();
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$this->Tennis_model->confirmoReservas();
		$barrio=$this->Sec_model->getBarrio();
		$grupo=$this->Reservas_model->getTennis($barrio);

    		if(!$amenity) $canchas = $this->Reservas_model->get_actividades($grupo[0]->gam_id);
		else $amid=$this->Tennis_model->get_amenity($amenity);
		$user_id=$user->id;
		$year=date('Y');
		$month=date('m');
//		$csrf=$this->input->post($this->security->get_csrf_token_name());
        	$ufs = $this->Sec_model->unidades_barrio_prop($user_id,$barrio);

		$errores=array();
		foreach($ufs as $ufd){
		    $deuda = $this->Sec_model->deuda($ufd->cop_id);
		    $ultimalq = $this->Sec_model->ultimalq($ufd->cop_id);
		    if($deuda>=($ultimalq*3)) $errores[]="No puede reservar dado que la UF $ufd->cop_unifun debe m&aacute;s de 3 expensas.";

		    $estaInHabilitado = $this->Reservas_model->estaInHabilitado($ufd->cop_id);
		    if($estaInHabilitado) $errores[]=$estaInHabilitado;
//		    $tieneCancelaciones=$this->Tennis_model->tieneCancelaciones($ufd->cop_id);
//		    if($tieneCancelaciones) $errores[]="El copropietario no puede anotarse ya que la UF $uf->cop_unifun presenta cancelaciones de canchas. Debera esperar hasta 1 hora posterior al evento cancelado para anotarse.";
		}

//		$dow=date("w");
//		if($dow==0 || $dow==6) $errores[]="El sistema no permite reservas para sabado y domingo.";


		if($errores){
		    $this->session->set_flashdata('message', $errores);
		    redirect('Tennis/errores', $this->data);
		    exit();
		}else{
		    $quienjuega="";
		    foreach($ufs as $u){
			$grmay=$this->Sec_model->grupo_familiar_mayor($u->cop_id,$user_id);
			$grmay=$grmay->result();
            		foreach($grmay as $gmy){
			    $tieneReserva=$this->Tennis_model->tieneReserva($gmy->gf_id,$user_id);
			    if($tieneReserva==2) $quienjuega.="<option value='$gmy->gf_id'> $gmy->gf_nombre </option>";
			    else $quienjuega.="<option value='$gmy->gf_id' disabled> $gmy->gf_nombre - Con reserva activa </option>";
			}

			$grmen=$this->Sec_model->grupo_familiar_menor($u->cop_id,$user_id);
			$grmen=$grmen->result();
            		foreach($grmen as $gmy){
			    if($gmy->gf_menor==1){
				$tieneReserva=$this->Tennis_model->tieneReserva($gmy->gf_id,$user_id);
				if($tieneReserva==2) $quienjuega.="<option value='$gmy->gf_id'> $gmy->gf_nombre </option>";
				else $quienjuega.="<option value='$gmy->gf_id' disabled> $gmy->gf_nombre - Con reserva activa</option>";
			    }
			}
		    }

		    $todasUfs="";
        	    $unidades = $this->Sec_model->unidades_barrio_tot($barrio);
            	    foreach($unidades as $unidad){
			$todasUfs.="<option value='$unidad->cop_id'>$unidad->cop_unifun - $unidad->cop_nombre </option>";
        	    }			

		    if(!$amenity){
			$cualcancha="";
			foreach($canchas as $cc){
			    $am=$cc;
			    $day=date("d");
			    $month=date("m");
			    $year=date("Y");
			    $queHora=date("H:i");

			    $qLastDay1="select ('$queHora'::time)::time as lastDay;";
			    $rLastDay1=$this->db->query($qLastDay1);
			    $queHora=$rLastDay1->row()->lastday;
			    $timestamp = strtotime($queHora) + 60*60;
			    $time = date('H:i', $timestamp);
			    $queHora=date('H', strtotime($time));
			    $queHora.=":00:00";

			    $comienzo=$am->am_comienzo;
			    $fin=$am->am_fin;
			    $duracion=$am->am_duracion;

			    $termino=1;
			    if(strtotime($queHora)<=strtotime($comienzo)){
				$queHora=$comienzo;
			    }else if(strtotime($queHora)>=strtotime($fin)){
				$termino=2;
			    }

			    if($termino==1){
				$timestamp = strtotime($queHora) + 2*60*60;
			        $time = date('H:i', $timestamp);
				$finalizo=date('H', strtotime($time));
				$finalizo.=":00:00";
				if(strtotime($finalizo)>=strtotime($fin)){
				    $finalizo=$fin;
				}
			    }

			    $imprimi=2;
			    if($termino==1) ${'hora'.$cc->am_id}="<option value=-1> Seleccione un horario </option>";
			    else ${'hora'.$cc->am_id}="<option value=-1> Hoy ya no se pueden efectuar reservas. </option>";
			    while($termino==1){
    				$this->db->where('evt_fecha', $day . "-" . $month . "-" . $year);
    				$this->db->where('evt_idamenity', $am->am_id);
    				$this->db->where('evt_horad', $queHora);
    				$this->db->where('evt_estado', 2);
    				$query = $this->db->get('eventos');
    				if ($query -> num_rows() > 0){
				    $evt=$query->row();
				    $quien=$evt->evt_idcopr;
				    if($quien>0) $quien_n=$this->Tennis_model->get_uf($quien)->cop_nombre;
				    else $quien_n="El Barrio";
				    ${'hora'.$cc->am_id}.="<option value='$queHora' disabled> $queHora - Ocupada por: $quien_n </option>";
				}else{
				    ${'hora'.$cc->am_id}.="<option value='$queHora'> $queHora </option>";
				    $imprimi=1;
				}

				$qLastDay="select ('$queHora'::time + interval '$duracion minutes')::time as lastDay;";
				$rLastDay=$this->db->query($qLastDay);
				$queHora=$rLastDay->row()->lastday;
				if($queHora==$finalizo) $termino=2;
			    }

			    if($imprimi==2){
				$termino=1;
				$finalizo=$fin;
				if($queHora>=$finalizo) $termino=2;
				while($termino==1){
    				    $this->db->where('evt_fecha', $day . "-" . $month . "-" . $year);
    				    $this->db->where('evt_idamenity', $am->am_id);
    				    $this->db->where('evt_horad', $queHora);
    				    $this->db->where('evt_estado', 2);
    				    $query = $this->db->get('eventos');
    				    if ($query -> num_rows() > 0){
					$evt=$query->row();
					$quien=$evt->evt_idcopr;
					if($quien>0) $quien_n=$this->Tennis_model->get_uf($quien)->cop_nombre;
					else $quien_n="El Barrio";
					${'hora'.$cc->am_id}.="<option value='$queHora' disabled> $queHora - Ocupada por: $quien_n </option>";
				    }else{
					${'hora'.$cc->am_id}.="<option value='$queHora'> $queHora </option>";
					$termino=2;
				    }

				    $qLastDay="select ('$queHora'::time + interval '$duracion minutes')::time as lastDay;";
				    $rLastDay=$this->db->query($qLastDay);
				    $queHora=$rLastDay->row()->lastday;
				    if($queHora==$finalizo) $termino=2;
				}
			    }

			    $this->data['hora'.$cc->am_id]=${'hora'.$cc->am_id};
			    $cualcancha.="<option value='$am->am_id'> $am->am_nombre </option>";
			}
			$this->data['cualcancha']=$cualcancha;
			$this->data['canchas']=$canchas;
			$this->data['amenity']=NULL;
			$this->data['horadef']=NULL;
		    }else{
			$this->data['amenity']=$amenity;
			$this->data['horadef']=$horadef.':00';
			$this->data['cualcancha']=$amid->am_nombre;
			$this->data['conluz']=$amid->am_conluz;
		    }



		    $this->data['quienjuega']=$quienjuega;
		    $this->data['todasUfs']=$todasUfs;
		    $this->data['barrio']=$barrio;
			

		    $this->load->view('body/tennis', $this->data);

		}
	    }
	}



	function del(){

	    $user=$this->ion_auth->user()->row();
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$this->Tennis_model->confirmoReservas();
		$barrio=$this->Sec_model->getBarrio();
		$grupo=$this->Reservas_model->getTennis($barrio);
    		$canchas = $this->Reservas_model->get_actividades($grupo[0]->gam_id);
		$user_id=$user->id;
		$year=date('Y');
		$month=date('m');

		$this->load->view('body/deltennis', $this->data);

	    }
	}







	function calendario(){

	    $user=$this->ion_auth->user()->row();
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$this->Tennis_model->confirmoReservas();
		$barrio=$this->Sec_model->getBarrio();
		$grupo=$this->Reservas_model->getTennis($barrio);
    		$canchas = $this->Reservas_model->get_actividades($grupo[0]->gam_id);
		$user_id=$user->id;
		$year=date('Y');
		$month=date('m');


		$dow=date("w");
		$hPandemia=array();

/*
		$cancha3h=array(4,5,7,8,9);
		$cancha3o=array(6);
		$cancha1h=array(6,5,7,8,9);
		$cancha1o=array(4);
		$cancha13h=array(5,7,8,9);
		$cancha13o=array(4,6);
		$cancha345h=array(4,5,9);
		$cancha345o=array(6,7,8);


		if($dow==1){
		    $hPandemia[]=array("13:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("14:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("15:00:00",$cancha3h,$cancha3o);
		}else if($dow==3){
		    $hPandemia[]=array("12:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("15:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("16:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("17:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("18:00:00",$cancha3h,$cancha3o);
		}else if($dow==4){
		    $hPandemia[]=array("14:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("15:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("16:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("17:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("18:00:00",$cancha13h,$cancha13o);
		    $hPandemia[]=array("19:00:00",$cancha1h,$cancha1o);
		}else if($dow==5){
		    $hPandemia[]=array("14:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("15:00:00",$cancha13h,$cancha13o);
		    $hPandemia[]=array("16:00:00",$cancha13h,$cancha13o);
		    $hPandemia[]=array("17:00:00",$cancha13h,$cancha13o);
		    $hPandemia[]=array("18:00:00",$cancha13h,$cancha13o);
		    $hPandemia[]=array("19:00:00",$cancha1h,$cancha1o);
		    $hPandemia[]=array("20:00:00",$cancha1h,$cancha1o);
		}else if($dow==6){
		    $hPandemia[]=array("09:00:00",$cancha345h,$cancha345o);
		    $hPandemia[]=array("10:00:00",$cancha345h,$cancha345o);
		    $hPandemia[]=array("11:00:00",$cancha345h,$cancha345o);
		    $hPandemia[]=array("12:00:00",$cancha345h,$cancha345o);
		}

*/

		$tengoHora=array();
		foreach($hPandemia as $hp){
		    $tengoHora[]=$hp[0];
		}








		$cualcancha="";
		foreach($canchas as $cc){
		    $am=$cc;
		    $day=date("d");
		    $month=date("m");
		    $year=date("Y");

		    $comienzo=$am->am_comienzo;
		    $fin=$am->am_fin;
		    $duracion=$am->am_duracion;
		    $queHora=$comienzo;

		    $termino=1;
		    ${'hora'.$cc->am_id}=array();

		    while($termino==1){
			if(in_array($queHora,$tengoHora)){
			    foreach($hPandemia as $pand){
				if($pand[0]==$queHora){
				    if(in_array($am->am_id,$pand[1])){
    					$this->db->where('evt_fecha', $day . "-" . $month . "-" . $year);
    					$this->db->where('evt_idamenity', $am->am_id);
    					$this->db->where('evt_horad', $queHora);
    					$this->db->where_in('evt_estado', array(2,101));
    					$query = $this->db->get('eventos');
    					if ($query -> num_rows() > 0){
					    $evt=$query->row();
					    $quien=$evt->evt_idcopr;
					    $luz=$evt->evt_luz;
					    $ues="Profesor - Administracion";
					    if($quien>0){
						$quienes=$evt->evt_id;
						$ues = $this->Tennis_model->getParticipantes($quienes);
						if(!isset($ues)) $ues="Profesor - Administracion";
					    }else $quien_n="El Barrio";
					    ${'hora'.$cc->am_id}[]=array($queHora,"Ocupada por: $ues",$luz);
					}else{
					    ${'hora'.$cc->am_id}[]=array($queHora,"Libre",0,$am->am_id);
					}
				    }else{
					if(is_array($pand[2])){
					    if(in_array($am->am_id,$pand[2])){
						${'hora'.$cc->am_id}[]=array($queHora,"Utilizada por PROFESOR",0);
					    }else{
						${'hora'.$cc->am_id}[]=array($queHora,"Inhabilitada por AUSENCIA de PROFESOR",0);
					    }
					}else{
					    if($am->am_id==$pand[2]){
						${'hora'.$cc->am_id}[]=array($queHora,"Utilizada por PROFESOR",0);
					    }else{
						${'hora'.$cc->am_id}[]=array($queHora,"Inhabilitada por AUSENCIA de PROFESOR",0);
					    }
					}
				    }
				}
			    }
			}else{
//			    ${'hora'.$cc->am_id}[]=array($queHora,"Inhabilitada por AUSENCIA de PROFESOR",0);
			    $this->db->where('evt_fecha', $day . "-" . $month . "-" . $year);
			    $this->db->where('evt_idamenity', $am->am_id);
			    $this->db->where('evt_horad', $queHora);
			    $this->db->where_in('evt_estado', array(2,101));
			    $query = $this->db->get('eventos');
			    if ($query -> num_rows() > 0){
				$evt=$query->row();
				$quien=$evt->evt_idcopr;
				$luz=$evt->evt_luz;
				$ues="Profesor - Administracion";
				if($quien>0){
				    $quienes=$evt->evt_id;
				    $ues = $this->Tennis_model->getParticipantes($quienes);
				    if(!$ues) $ues="Profesor - Administracion";
				}else $quien_n="El Barrio";
				${'hora'.$cc->am_id}[]=array($queHora,"Ocupada por: $ues",$luz);
			    }else{
				${'hora'.$cc->am_id}[]=array($queHora,"Libre",0,$am->am_id);
			    }
			}

			$qLastDay="select ('$queHora'::time + interval '$duracion minutes')::time as lastDay;";
			$rLastDay=$this->db->query($qLastDay);
			$queHora=$rLastDay->row()->lastday;
			if($queHora==$fin) $termino=2;
		    }
		    $this->data['hora'.$cc->am_id]=${'hora'.$cc->am_id};






/*
		    while($termino==1){
    			$this->db->where('evt_fecha', $day . "-" . $month . "-" . $year);
    			$this->db->where('evt_idamenity', $am->am_id);
    			$this->db->where('evt_horad', $queHora);
    			$this->db->where_in('evt_estado', array(2,101));
    			$query = $this->db->get('eventos');
    			if ($query -> num_rows() > 0){
			    $evt=$query->row();
			    $quien=$evt->evt_idcopr;
			    $luz=$evt->evt_luz;
			    if($quien>0){
				$quienes=$evt->evt_id;
				$ues = $this->Tennis_model->getParticipantes($quienes);
			    }else $quien_n="El Barrio";
			    ${'hora'.$cc->am_id}[]=array($queHora,"Ocupada por: $ues",$luz);
			}else{
			    ${'hora'.$cc->am_id}[]=array($queHora,"Libre");
			}

			$qLastDay="select ('$queHora'::time + interval '$duracion minutes')::time as lastDay;";
			$rLastDay=$this->db->query($qLastDay);
			$queHora=$rLastDay->row()->lastday;
			if($queHora==$fin) $termino=2;
		    }
		    $this->data['hora'.$cc->am_id]=${'hora'.$cc->am_id};
*/

		    $cualcancha.="<option value='$am->am_id'> $am->am_nombre </option>";


		}


		$this->data['barrio']=$barrio;
		$this->data['canchas']=$canchas;
		$this->data['cualcancha']=$cualcancha;
			

		$this->load->view('body/crtennis', $this->data);

	    }
	}









	function calendarioh(){

	    $user=$this->ion_auth->user()->row();
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$this->Tennis_model->confirmoReservas();
		$barrio=$this->Sec_model->getBarrio();
		$grupo=$this->Reservas_model->getTennis($barrio);
    		$canchas = $this->Reservas_model->get_actividades($grupo[0]->gam_id);
		$user_id=$user->id;
		$year=date('Y');
		$month=date('m');

		$cualcancha="";
		$day=date("d");
		$month=date("m");
		$year=date("Y");

		$comienzo='09:00:00';
		$fin='22:00:00';
		$duracion=60;
		$queHora=$comienzo;
		$hh=substr($queHora,0,2);

		$horarios=array();


		$dow=date("w");
		$hPandemia=array();
/*
		$cancha3h=array(4,5,7,8,9);
		$cancha3o=array(6);
		$cancha1h=array(6,5,7,8,9);
		$cancha1o=array(4);
		$cancha13h=array(5,7,8,9);
		$cancha13o=array(4,6);
		$cancha345h=array(4,5,9);
		$cancha345o=array(6,7,8);

		if($dow==1){
		    $hPandemia[]=array("13:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("14:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("15:00:00",$cancha3h,$cancha3o);
		}else if($dow==3){
		    $hPandemia[]=array("12:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("15:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("16:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("17:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("18:00:00",$cancha3h,$cancha3o);
		}else if($dow==4){
		    $hPandemia[]=array("14:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("15:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("16:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("17:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("18:00:00",$cancha13h,$cancha13o);
		    $hPandemia[]=array("19:00:00",$cancha1h,$cancha1o);
		}else if($dow==5){
		    $hPandemia[]=array("14:00:00",$cancha3h,$cancha3o);
		    $hPandemia[]=array("15:00:00",$cancha13h,$cancha13o);
		    $hPandemia[]=array("16:00:00",$cancha13h,$cancha13o);
		    $hPandemia[]=array("17:00:00",$cancha13h,$cancha13o);
		    $hPandemia[]=array("18:00:00",$cancha13h,$cancha13o);
		    $hPandemia[]=array("19:00:00",$cancha1h,$cancha1o);
		    $hPandemia[]=array("20:00:00",$cancha1h,$cancha1o);
		}else if($dow==6){
		    $hPandemia[]=array("09:00:00",$cancha345h,$cancha345o);
		    $hPandemia[]=array("10:00:00",$cancha345h,$cancha345o);
		    $hPandemia[]=array("11:00:00",$cancha345h,$cancha345o);
		    $hPandemia[]=array("12:00:00",$cancha345h,$cancha345o);
		}

*/

		$termino=1;
		${'hora'.$hh}=array();

		$tengoHora=array();
		foreach($hPandemia as $hp){
		    $tengoHora[]=$hp[0];
		}


		while($termino==1){
		    $hh=substr($queHora,0,2);
		    $horarios[]=$hh;
		    $cualcancha.="<option value='$hh'> $queHora </option>";

		    foreach($canchas as $cc){
			$am=$cc;

			if(in_array($queHora,$tengoHora)){
			    foreach($hPandemia as $pand){
				if($pand[0]==$queHora){
				    if(in_array($am->am_id,$pand[1])){
					$this->db->where('evt_fecha', $day . "-" . $month . "-" . $year);
					$this->db->where('evt_idamenity', $am->am_id);
					$this->db->where('evt_horad', $queHora);
					$this->db->where_in('evt_estado', array(2,101));
					$query = $this->db->get('eventos');
					if ($query -> num_rows() > 0){
					    $evt=$query->row();
					    $quien=$evt->evt_idcopr;
					    $luz=$evt->evt_luz;
					    $ues="Profesor - Administracion";
					    if($quien>0){
						$quienes=$evt->evt_id;
						$ues = $this->Tennis_model->getParticipantes($quienes);
					    }else $quien_n="El Barrio";
					    ${'hora'.$hh}[]=array($cc->am_nombre,"Ocupada por: $ues",$luz);
					}else{
					    ${'hora'.$hh}[]=array($cc->am_nombre,"Libre",0,$am->am_id);
					}
				    }else{
					if(is_array($pand[2])){
					    if(in_array($am->am_id,$pand[2])){
						${'hora'.$hh}[]=array($cc->am_nombre,"Utilizada por PROFESOR",0);
					    }else{
						${'hora'.$hh}[]=array($cc->am_nombre,"Inhabilitada por AUSENCIA de PROFESOR",0);
					    }
					}else{
					    if($am->am_id==$pand[2]){
						${'hora'.$hh}[]=array($cc->am_nombre,"Utilizada por PROFESOR",0);
					    }else{
						${'hora'.$hh}[]=array($cc->am_nombre,"Inhabilitada por AUSENCIA de PROFESOR",0);
					    }
					}
				    }
				}
			    }
			}else{
			    $this->db->where('evt_fecha', $day . "-" . $month . "-" . $year);
			    $this->db->where('evt_idamenity', $am->am_id);
			    $this->db->where('evt_horad', $queHora);
			    $this->db->where_in('evt_estado', array(2,101));
			    $query = $this->db->get('eventos');
			    if ($query -> num_rows() > 0){
				$evt=$query->row();
				$quien=$evt->evt_idcopr;
				$luz=$evt->evt_luz;
				$ues="Profesor - Administracion";
				if($quien>0){
				    $quienes=$evt->evt_id;
				    $ues = $this->Tennis_model->getParticipantes($quienes);
				}else $quien_n="El Barrio";
				${'hora'.$hh}[]=array($cc->am_nombre,"Ocupada por: $ues",$luz);
			    }else{
				${'hora'.$hh}[]=array($cc->am_nombre,"Libre",0,$am->am_id);
			    }
			}
		    }
		    $this->data['hora'.$hh]=${'hora'.$hh};

		    $qLastDay="select ('$queHora'::time + interval '$duracion minutes')::time as lastDay;";
		    $rLastDay=$this->db->query($qLastDay);
		    $queHora=$rLastDay->row()->lastday;
		    if($queHora==$fin) $termino=2;
		}


		$this->data['barrio']=$barrio;
		$this->data['canchas']=$horarios;
		$this->data['cualcancha']=$cualcancha;
			

		$this->load->view('body/chtennis', $this->data);

	    }
	}







	function Grabar(){

	    $user=$this->ion_auth->user()->row();
	    $user_id=$user->id;
	    $user_id2=$this->input->post('id');
	    if (!$this->ion_auth->logged_in() || $user_id != $user_id2){
		redirect('auth/login', 'refresh');
	    }else{
		$barrio=$this->Sec_model->getBarrio();
		$grupo=$this->Reservas_model->getTennis($barrio);
	
        	$ufs = $this->Sec_model->unidades_barrio_prop($user_id,$barrio);
		$cantUf=count($ufs);

		$actividad=$this->input->post('cualcancha');
		if($actividad<0){
		    $errores[]="Debe definir la cancha";
		}
		$hora=$this->input->post("horario".$actividad);
		if(!$hora || $hora==-1){
		    $errores[]="Debe definir el horario de la cancha";
		}

		if($actividad>0 && $hora>0){
		    $hayEvento=$this->Tennis_model->hayEvento($actividad,$hora);
		    if($hayEvento==1){
			$errores[]="Ya existe una reserva en el horario seleccionado.";
		    }
		}

		$gf_id=$this->input->post('gf');
		if(!$gf_id || $gf_id==-1 || $gf_id==-2){
		    $errores[]="Debe definir el miembro de su grupo familiar que jugara";
		}else{
		    $ufd=NULL;
		    foreach($ufs as $u){
			$grmay=$this->Sec_model->grupo_familiar_mayor($u->cop_id,$user_id);
			$grmay=$grmay->result();
            		foreach($grmay as $gmy){
			    if($gmy->gf_id==$gf_id){
				$ufd=$u->cop_id;
				$unidad=$u;
			    }
			}
			$grmen=$this->Sec_model->grupo_familiar_menor($u->cop_id,$user_id);
			$grmen=$grmen->result();
            		foreach($grmen as $gmy){
			    if($gmy->gf_id==$gf_id){
				$ufd=$u->cop_id;
				$unidad=$u;
			    }
			}
		    }
		    $codemp=$unidad->cop_codemp;
		    $idptov=$unidad->cop_idptov;
		    $division=$unidad->cop_division;
		    $centro=$unidad->cop_centro;
		}

		$tipusu=$this->Sec_model->tipo_usuario($user_id);
		if($tipusu==1) $campo="ue_idgfd"; else $campo="ue_idgfi";

		$activ=$this->Tennis_model->get_amenity($actividad);
		$duracion=$activ->am_duracion;
		$reqaut=$activ->am_reqaut;
		$conluz=$activ->am_conluz;

		if($conluz==1){
		    $luz=$this->input->post("luz".$actividad);
		    if(!$luz){
			$errores[]="Debe definir si desea o no la luz de la cancha";
		    }
		}else $luz=2;




		$miembros=array();
		$miembros[]=$gf_id;

		$campo1=$this->input->post('campo1');
		$campo2=$this->input->post('campo2');
		$campo3=$this->input->post('campo3');
		$miembro1=$miembro2=$miembro3=NULL;
		$modalidad=$this->input->post('modalidad');
		$idcopr1=$this->input->post('ufd1');
		if($idcopr1){
		    $campo1=$this->input->post('campo1');
		    $miembro1=$this->input->post('miembro1');

		    if($miembro1>0 && $campo1){
			if($campo1=="ue_idgfd") $uf1=$this->Tennis_model->copGf($miembro1,1);
			else $uf1=$this->Tennis_model->copGf($miembro1,2);

			$lauf1=$this->Tennis_model->get_uf($uf1);
			$deuda = $this->Sec_model->deuda($uf1);
			$ultimalq = $this->Sec_model->ultimalq($uf1);
			if($deuda>=($ultimalq*3) && $lauf1->cop_unifun != 169) $errores[]="No puede reservar la actividad con un miembro de la UF $lauf1->cop_unifun dado que la UF en cuestion debe m&aacute;s de 3 expensas.";

			if(!in_array($miembro1,$miembros)) $miembros[]=$miembro1;
			else $errores[]="No se puede seleccionar a la misma persona para ocupar 2 roles.";
		    }else{
			$uf1=$miembro1;
			$campo1="ue_idgfd";
		    }
		}else{
		    $uf1=NULL;
		    $campo1="ue_idgfd";
		    $miembro1=NULL;
		}
		if($modalidad==2){

		    $idcopr2=$this->input->post('ufd2');
		    if($idcopr2){
			$campo2=$this->input->post('campo2');
			$miembro2=$this->input->post('miembro2');

			if($miembro2>0 && $campo2){
			    if($campo2=="ue_idgfd") $uf2=$this->Tennis_model->copGf($miembro2,1);
			    else $uf2=$this->Tennis_model->copGf($miembro2,2);

			    $lauf2=$this->Tennis_model->get_uf($uf2);
			    $deuda = $this->Sec_model->deuda($uf2);
			    $ultimalq = $this->Sec_model->ultimalq($uf2);
			    if($deuda>=($ultimalq*3)) $errores[]="No puede reservar la actividad con un miembro de la UF $lauf2->cop_unifun dado que la UF en cuestion debe m&aacute;s de 3 expensas.";

			    if(!in_array($miembro2,$miembros)) $miembros[]=$miembro2;
			    else $errores[]="No se puede seleccionar a la misma persona para ocupar 2 roles.";
			}else{
			    $uf2=$miembro2;
			    $campo2="ue_idgfd";
			}
		    }else{
			$uf2=NULL;
			$campo2="ue_idgfd";
			$miembro2=NULL;
		    }

		    $idcopr3=$this->input->post('ufd3');
		    if($idcopr3){
			$campo3=$this->input->post('campo3');
			$miembro3=$this->input->post('miembro3');

			if($miembro3>0 && $campo3){
			    if($campo3=="ue_idgfd") $uf3=$this->Tennis_model->copGf($miembro3,1);
			    else $uf3=$this->Tennis_model->copGf($miembro3,2);

			    $lauf3=$this->Tennis_model->get_uf($uf3);
			    $deuda = $this->Sec_model->deuda($uf3);
			    $ultimalq = $this->Sec_model->ultimalq($uf3);
			    if($deuda>=($ultimalq*3)) $errores[]="No puede reservar la actividad con un miembro de la UF $lauf3->cop_unifun dado que la UF en cuestion debe m&aacute;s de 3 expensas.";

			    if(!in_array($miembro3,$miembros)) $miembros[]=$miembro3;
			    else $errores[]="No se puede seleccionar a la misma persona para ocupar 2 roles.";
			}else{
			    $campo3="ue_idgfd";
			    $uf3=$miembro3;
			}
		    }else{
			$uf3=NULL;
			$campo3="ue_idgfd";
			$miembro3=NULL;
		    }

		}



		if(!$uf1)
		    $errores[]="Debe seleccionar con quien jugara. Si es invitado, debe seleccionar la opcion invitado/visita.";


		//1 INVITADO POR SOCIO HORARIOS LUNES A VIERNES , SABADO DE 9 A 13 , DOMINGO DE 13 A 22
		$dow=date("w");
		if($uf1==-1){
		    //tengo reserva activa con invitado?

//		    $errores[]="Actualmente no se permiten reservas con invitados.";
		    $adds[]="El invitado tiene un costo de $250 que se cargar&aacute; por expensas..";

		    $tengoInvitado=$this->Tennis_model->tengoInvitado($ufd);
		    if($tengoInvitado) $errores[]="Solo se permite 1 unico invitado por socio";
		    if($dow==6){
			$desde="09:00:00";
			$hasta="13:00:00";
			if(strtotime($hora)>strtotime($hasta)) $errores[]="Los invitados los dias sabados pueden jugar hasta las 13hs.";
		    }
		    if($dow==0){
			$desde="13:00:00";
			$hasta="22:00:00";
			if(strtotime($hora)<strtotime($desde)) $errores[]="Los invitados los dias domingos pueden jugar desde las 13hs.";
		    }

		}

		if($modalidad==2){

		    if(!$uf2)
			$errores[]="Debe seleccionar con quien jugara. Si es invitado, debe seleccionar la opcion invitado/visita.";
		    if(!$uf3)
			$errores[]="Debe seleccionar con quien jugara. Si es invitado, debe seleccionar la opcion invitado/visita.";


		    if($uf2==-1){
			//tengo reserva activa con invitado?
			$adds[]="El invitado tiene un costo de $250 que se cargar&aacute; por expensas..";
			$tengoInvitado=$this->Tennis_model->tengoInvitado($ufd);
			if($tengoInvitado) $errores[]="Solo se permite 1 unico invitado por socio";
			if($uf1==-1) $errores[]="Solo se permite 1 unico invitado por socio";
			if($dow==6){
			    $desde="09:00:00";
			    $hasta="13:00:00";
			    if(strtotime($hora)>strtotime($hasta)) $errores[]="Los invitados los dias sabados pueden jugar hasta las 13hs.";
			}
			if($dow==0){
			    $desde="13:00:00";
			    $hasta="22:00:00";
			    if(strtotime($hora)<strtotime($desde)) $errores[]="Los invitados los dias domingos pueden jugar desde las 13hs.";
			}
		    }

		    if($uf3==-1){
			//tengo reserva activa con invitado?
			$adds[]="El invitado tiene un costo de $250 que se cargar&aacute; por expensas..";
			$tengoInvitado=$this->Tennis_model->tengoInvitado($ufd);
			if($tengoInvitado) $errores[]="Solo se permite 1 unico invitado por socio";
			if($uf1==-1) $errores[]="Solo se permite 1 unico invitado por socio";
			if($uf2==-1) $errores[]="Solo se permite 1 unico invitado por socio";
			if($dow==6){
			    $desde="09:00:00";
			    $hasta="13:00:00";
			    if(strtotime($hora)>strtotime($hasta)) $errores[]="Los invitados los dias sabados pueden jugar hasta las 13hs.";
			}
			if($dow==0){
			    $desde="13:00:00";
			    $hasta="22:00:00";
			    if(strtotime($hora)<strtotime($desde)) $errores[]="Los invitados los dias domingos pueden jugar desde las 13hs.";
			}
		    }


		}



		if(isset($errores)){
		    $this->session->set_flashdata('message', $errores);
		    redirect('Tennis/index/'.$actividad.'/'.substr($hora,0,2), $this->data);
		    exit();
		}



		$qLastDay1="select ('$hora'::time + interval '$duracion minutes')::time as lastDay;";
		$rLastDay1=$this->db->query($qLastDay1);
		$horah=$rLastDay1->row()->lastday;

		if($reqaut==2){
		    $estado=2;
		}else{
		    $estado=1;
		}


		$data = array(
		    "evt_codemp" => $codemp,
		    "evt_idptov" => $idptov,
		    "evt_division" => $division,
		    "evt_centro" => $centro,
		    "evt_idcopr" => $ufd,
		    "evt_idamenity" => $actividad,
		    "evt_horad" => $hora,
		    "evt_horah" => $horah,
		    "evt_estado" => $estado,
		    "evt_luz" => $luz,
		    "evt_fecha" => date("d-m-Y"),
		);
		$query = $this->db->insert("eventos",$data);
		$evt_id= $this->db->insert_id('eventos_evt_id_seq');

		if ($evt_id) {
		    $data2 = array(
			"ue_idevt" => $evt_id,
			"ue_idcopr" => $ufd,
			$campo => $gf_id
		    );
		    $query2 = $this->db->insert("ufsxevt",$data2);

		    $data2 = array(
			"ue_idevt" => $evt_id,
			"ue_idcopr" => $uf1,
			$campo1 => $miembro1
		    );
		    $query2 = $this->db->insert("ufsxevt",$data2);

		    if($modalidad==2){
			$data2 = array(
			    "ue_idevt" => $evt_id,
			    "ue_idcopr" => $uf2,
			    $campo2 => $miembro2
			);
			$query2 = $this->db->insert("ufsxevt",$data2);

			$data2 = array(
			    "ue_idevt" => $evt_id,
			    "ue_idcopr" => $uf3,
			    $campo3 => $miembro3
			);
			$query2 = $this->db->insert("ufsxevt",$data2);
		    }


		}

		$sms="Su reserva se encuentra confirmada.";
		if($adds){
		    foreach($adds as $ad){
			$sms.="<BR />".$ad;
		    }
		}
		$this->session->set_flashdata('message', $sms);
		redirect('Tennis', $this->data);

	    }
	}




	function cancelarReserva($evt_id){

	    $user=$this->ion_auth->user()->row();
	    $user_id=$user->id;
	    $barrio=$this->Sec_model->getBarrio();
	    $ufs = $this->Sec_model->unidades_barrio_prop($user_id,$barrio);
	    $evento= $this->Tennis_model->get_evento($evt_id);
	    $esMio=2;
	    foreach($ufs as $uf){
		if($uf->cop_id==$evento->evt_idcopr) $esMio=1;
	    }
	    
	    if($esMio==2){
		$this->session->set_flashdata('message', 'No puede cancelar una reserva que no es suya.');
		redirect('Tennis', $this->data);
	    }else{
		$data = array(
		    "evt_estado" => 999,
		);

		$this->Sec_model->update_p('eventos','evt_id',$evt_id,$data);

		$data2 = array(
		    "ue_estado" => 999,
		);

		$this->Sec_model->update_p('ufsxevt','ue_idevt',$evt_id,$data2);

		$this->session->set_flashdata('message', 'Reserva cancelada.');
		redirect('Tennis', $this->data);
	    }

	}








	function queMiembro(){
	    $options = "";
    	    if ($this->input->post('ptv_id') && $this->input->post('ufd')) {
        	$ptv_id = $this->input->post('ptv_id');
        	$ufd = $this->input->post('ufd');
		$quienjuega="";
		$tieneContr=$this->Sec_model->get_idcontr($ufd);
		if($tieneContr){
		    $usu=$this->Sec_model->get_registro($ufd,2);
		}else{
		    $usu=$this->Sec_model->get_registro($ufd,1);
		}
		if($usu){
		    $user_id=$usu[0]->uid;
		    $grmay=$this->Sec_model->grupo_familiar_mayor($ufd,$user_id);
		    $grmay=$grmay->result();
            	    foreach($grmay as $gmy){
			$tieneReserva=$this->Tennis_model->tieneReserva($gmy->gf_id,$user_id);
			if($tieneReserva==2) $quienjuega.="<option value='$gmy->gf_id'> $gmy->gf_nombre </option>";
			else $quienjuega.="<option value='$gmy->gf_id' disabled> $gmy->gf_nombre - Con reserva activa</option>";
		    }

		    $grmen=$this->Sec_model->grupo_familiar_menor($ufd,$user_id);
		    $grmen=$grmen->result();
            	    foreach($grmen as $gmy){
			if($gmy->gf_menor==1){
			    $tieneReserva=$this->Tennis_model->tieneReserva($gmy->gf_id,$user_id);
			    if($tieneReserva==2) $quienjuega.="<option value='$gmy->gf_id'> $gmy->gf_nombre </option>";
			    else $quienjuega.="<option value='$gmy->gf_id' disabled> $gmy->gf_nombre - Con reserva activa</option>";
			}
		    }
		}else{
		    $quienjuega.="<option value='999' disabled> La UF no tiene grupo familiar asignado al sistema, no se le permite jugar hasta regularizar su situacion. </option>";
		}
	    }else{
		$quienjuega.="<option value='999' disabled> Error del aplicativo, seleccione otra UF. </option>";
	    }
	    if($quienjuega=="") $quienjuega.="<option value='999' disabled> La UF no tiene grupo familiar asignado al sistema, no se le permite jugar hasta regularizar su situacion. </option>";
	    echo $quienjuega;
	}





    function volver(){
	redirect('tennis','refresh');
    }














	function buscogf(){

	    $term=$_POST['term'];
	    $elBarrio=$_POST['ash_idptov'];

	    $alumnos=$this->Tennis_model->get_gf($term,$elBarrio);

	    if($alumnos){
		$respuesta=array();
		$add=array();
		$name="Invitado - Visita (Costo $250 a abonar por expensas)";
		$add=array("name"=>$name,"value"=>-1,"tabla"=>-1);
		$respuesta[]=$add;
		foreach($alumnos as $g){
		    $add=array();
		    $gf_id=$g->gf_id;
		    $gf_nombre=$this->Sec_model->Decode($g->gf_nombre);
		    $tabla=$g->tabla;
		    $gf_dni=$g->gf_nrodoc;
		    $gf_uf=$g->uf;


		    $tieneReserva=$this->Tennis_model->tieneReservaT($gf_id,$tabla);
		    if($tieneReserva==2){
			$name="$gf_nombre - UF: $gf_uf";
			$add=array("name"=>$name,"value"=>$gf_id,"tabla"=>$tabla);
			$respuesta[]=$add;
		    }else{
			$name="$gf_nombre - UF: $gf_uf - Con reserva activa, no puede seleccionarse";
			$add=array("name"=>$name,"value"=>-10,"tabla"=>$tabla);
			$respuesta[]=$add;
		    }
		}
		echo $_GET['callback']."(".json_encode($respuesta).")";
	    }else{
		$name="Invitado - Visita (Costo $250 a abonar por expensas)";
		$add=array("name"=>$name,"value"=>-1,"tabla"=>-1);
		$respuesta[]=$add;
		$name="Alamos";
		$add=array("name"=>$name,"value"=>-2,"tabla"=>-2);
		$respuesta[]=$add;
		echo $_GET['callback']."(".json_encode($respuesta).")";
	    }


	}




















	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}






/*
		    $uf2=$this->input->post('ufd2');
		    if($uf2>0){
			$lauf2=$this->Tennis_model->get_uf($uf2);
			$deuda = $this->Sec_model->deuda($uf2);
			$ultimalq = $this->Sec_model->ultimalq($uf2);
			if($deuda>=($ultimalq*3)) $errores[]="No puede reservar la actividad con un miembro de la UF $lauf2->cop_unifun dado que la UF en cuestion debe m&aacute;s de 3 expensas.";

			$tieneContr2=$this->Sec_model->get_idcontr($uf2);
			if($tieneContr2) $campo2="ue_idgfi";
			$miembro2=$this->input->post('miembro2');
			if(!$miembro2) $errores[]="Debe definir el miembro del grupo familiar de la UF que participara con usted.";
			else{
			    if(!in_array($miembro2,$miembros)) $miembros[]=$miembro2;
			    else $errores[]="No se puede seleccionar a la misma persona para ocupar 2 roles.";
			}
		    }
		    $uf3=$this->input->post('ufd3');
		    if($uf3>0){
			$lauf3=$this->Tennis_model->get_uf($uf3);
			$deuda = $this->Sec_model->deuda($uf3);
			$ultimalq = $this->Sec_model->ultimalq($uf3);
			if($deuda>=($ultimalq*3)) $errores[]="No puede reservar la actividad con un miembro de la UF $lauf3->cop_unifun dado que la UF en cuestion debe m&aacute;s de 3 expensas.";

			$tieneContr3=$this->Sec_model->get_idcontr($uf3);
			if($tieneContr3) $campo3="ue_idgfi";
			$miembro3=$this->input->post('miembro3');
			if(!$miembro3) $errores[]="Debe definir el miembro del grupo familiar de la UF que participara con usted.";
			else{
			    if(!in_array($miembro3,$miembros)) $miembros[]=$miembro3;
			    else $errores[]="No se puede seleccionar a la misma persona para ocupar 2 roles.";
			}
		    }
*/



	function calendariof_old(){

	    $user=$this->ion_auth->user()->row();
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$this->Tennis_model->confirmoReservas();
		$barrio=$this->Sec_model->getBarrio();
		$grupo=$this->Reservas_model->getTennis($barrio);
    		$canchas = $this->Reservas_model->get_actividades($grupo[0]->gam_id);
		$user_id=$user->id;
		$year=date('Y');
		$month=date('m');


		$dow=date("w");
		$cualcancha="";

		$calendario=array();
		$horas=array();
		foreach($canchas as $cc){
		    $am=$cc;
		    $day=date("d");
		    $month=date("m");
		    $year=date("Y");

		    $canchaActual=$cc->am_id;

		    $comienzo=$am->am_comienzo;
		    $fin=$am->am_fin;
		    $duracion=$am->am_duracion;
		    $queHora=$comienzo;

		    $termino=1;
		    while($termino==1){
			    $avz=30;
			    if(!in_array($queHora,$horas)) $horas[]=$queHora;

			    $this->db->where('evt_fecha', $day . "-" . $month . "-" . $year);
			    $this->db->where('evt_idamenity', $am->am_id);
			    $this->db->where('evt_horad', $queHora);
			    $this->db->where_in('evt_estado', array(2,101));
			    $query = $this->db->get('eventos');
			    if ($query -> num_rows() > 0){
				$evt=$query->row();
				$quien=$evt->evt_idcopr;
				$luz=$evt->evt_luz;
				$ues="Profesor - Administracion";
				if($quien>0){
				    $quienes=$evt->evt_id;
				    $ues = $this->Tennis_model->getParticipantes($quienes);
				    if(!$ues) $ues="Profesor - Administracion";
				}else $quien_n="El Barrio";

				$cuantosJuegan=substr_count($ues,"/");
				$calendario[$canchaActual][$queHora]=array(9,"Ocupada por: $ues",$luz);
				if($cuantosJuegan==1){
				    $qLastDay="select ('$queHora'::time + interval '30 minutes')::time as lastDay;";
				    $rLastDay=$this->db->query($qLastDay);
				    $queHoram30=$rLastDay->row()->lastday;
				    $calendario[$canchaActual][$queHoram30]=array(9,"Ocupada por: $ues",$luz);
				    $avz=60;
				}else if($cuantosJuegan==3){
				    $qLastDay="select ('$queHora'::time + interval '30 minutes')::time as lastDay;";
				    $rLastDay=$this->db->query($qLastDay);
				    $queHoram30=$rLastDay->row()->lastday;
				    $calendario[$canchaActual][$queHoram30]=array(9,"Ocupada por: $ues",$luz);
				    $qLastDay="select ('$queHora'::time + interval '60 minutes')::time as lastDay;";
				    $rLastDay=$this->db->query($qLastDay);
				    $queHoram60=$rLastDay->row()->lastday;
				    $calendario[$canchaActual][$queHoram60]=array(9,"Ocupada por: $ues",$luz);
				    $avz=90;
				}
			    }else{
				$qLastDay="select ('$queHora'::time + interval '30 minutes')::time as lastDay;";
				$rLastDay=$this->db->query($qLastDay);
				$queHoraPosterior=$rLastDay->row()->lastday;
				$this->db->where('evt_fecha', $day . "-" . $month . "-" . $year);
				$this->db->where('evt_idamenity', $am->am_id);
				$this->db->where('evt_horad', $queHoraPosterior);
				$this->db->where_in('evt_estado', array(2,101));
				$query = $this->db->get('eventos');
				if ($query -> num_rows() > 0){
				    $evt=$query->row();
				    $quien=$evt->evt_idcopr;
				    $luz=$evt->evt_luz;
				    $ues="Profesor - Administracion";
				    if($quien>0){
					$quienes=$evt->evt_id;
					$ues = $this->Tennis_model->getParticipantes($quienes);
					if(!$ues) $ues="Profesor - Administracion";
				    }else $quien_n="El Barrio";
				    $calendario[$canchaActual][$queHora]=array(9,"Horario inhabilitado por reserva posterior",$luz);
				}else{
				    $calendario[$canchaActual][$queHora]=array(1);
				}
			    }

			$qLastDay="select ('$queHora'::time + interval '$avz minutes')::time as lastDay;";
			$rLastDay=$this->db->query($qLastDay);
			$queHora=$rLastDay->row()->lastday;
			if($queHora==$fin) $termino=2;
		    }
		}


		$this->data['barrio']=$barrio;
		$this->data['canchas']=$canchas;
		$this->data['cualcancha']=$cualcancha;
		$this->data['calendario']=$calendario;
		$this->data['horas']=$horas;

		$this->load->view('body/cftennis', $this->data);

	    }
	}





	function calendariof(){

	    $user=$this->ion_auth->user()->row();
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$this->Tennis_model->confirmoReservas();
		$barrio=$this->Sec_model->getBarrio();
		$grupo=$this->Reservas_model->getTennis($barrio);
    		$canchas = $this->Reservas_model->get_actividades($grupo[0]->gam_id);
		$user_id=$user->id;
		$year=date('Y');
		$month=date('m');


		$dow=date("w");
		$cualcancha="";

		$calendario=array();
		$horas=array();
		foreach($canchas as $cc){
		    $am=$cc;
		    $day=date("d");
		    $month=date("m");
		    $year=date("Y");
		    $fechaAct="$day-$month-$year";

		    $canchaActual=$cc->am_id;

		    $comienzo=$am->am_comienzo;
		    $fin=$am->am_fin;
		    $duracion=$am->am_duracion;
		    $queHora=$comienzo;

		    $termino=1;
		    while($termino==1){
			    $avz=30;
			    if(!in_array($queHora,$horas)) $horas[]=$queHora;

			    $arrReserva=$this->Tennis_model->hayReserva($fechaAct,$am->am_id,$queHora);
			    if($arrReserva){
				$ues=$arrReserva[0];
				$luz=$arrReserva[1];
				$horaq=$arrReserva[2];

				if($queHora==$horaq){
				    $cuantosJuegan=substr_count($ues,"/");
				    $calendario[$canchaActual][$queHora]=array(9,"Ocupada por: $ues",$luz);
				    if($cuantosJuegan<=1){
					$qLastDay="select ('$queHora'::time + interval '30 minutes')::time as lastDay;";
					$rLastDay=$this->db->query($qLastDay);
					$queHoram30=$rLastDay->row()->lastday;
					$calendario[$canchaActual][$queHoram30]=array(9,"Ocupada por: $ues",$luz);
					if(!in_array($queHoram30,$horas)) $horas[]=$queHoram30;
					$avz=60;
				    }else if($cuantosJuegan==3){
					$qLastDay="select ('$queHora'::time + interval '30 minutes')::time as lastDay;";
					$rLastDay=$this->db->query($qLastDay);
					$queHoram30=$rLastDay->row()->lastday;
					$calendario[$canchaActual][$queHoram30]=array(9,"Ocupada por: $ues",$luz);
					if(!in_array($queHoram30,$horas)) $horas[]=$queHoram30;
					$qLastDay="select ('$queHora'::time + interval '60 minutes')::time as lastDay;";
					$rLastDay=$this->db->query($qLastDay);
					$queHoram60=$rLastDay->row()->lastday;
					$calendario[$canchaActual][$queHoram60]=array(9,"Ocupada por: $ues",$luz);
					if(!in_array($queHoram60,$horas)) $horas[]=$queHoram60;
					$avz=90;
				    }
				}else{
				    $calendario[$canchaActual][$queHora]=array(9,"Horario inhabilitado por reserva posterior",$luz);
				}
			    }else{
				$calendario[$canchaActual][$queHora]=array(1);
			    }

			$qLastDay="select ('$queHora'::time + interval '$avz minutes')::time as lastDay;";
			$rLastDay=$this->db->query($qLastDay);
			$queHora=$rLastDay->row()->lastday;
			if($queHora==$fin) $termino=2;
		    }
		}

//print_r($calendario[6]);exit();
		$this->data['barrio']=$barrio;
		$this->data['canchas']=$canchas;
		$this->data['cualcancha']=$cualcancha;
		$this->data['calendario']=$calendario;
		$this->data['horas']=$horas;

		$this->load->view('body/cftennis', $this->data);

	    }
	}













}