<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Pileta extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Pileta_model','Sec_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));

		$admins = array(1,3);
		$this->data['admins'] =array(1,3);
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
			    $this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
			    $this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
			}
		    }
		}

		$elBarrio=$this->Sec_model->id_barrios_user($user->id)[0];
		if($elBarrio) $cops=$this->Sec_model->unidades_barrio_prop($user->id,$elBarrio);
		else $cops=array();

		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list
	public function index(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{

		$user=$this->ion_auth->user()->row();

		$elBarrio=$this->Sec_model->id_barrios_user($user->id)[0];
		if($elBarrio) $cops=$this->Sec_model->unidades_barrio_prop($user->id,$elBarrio);
		else $cops=array();

		$cuposMay = $this->Pileta_model->get_cupos($user->id,1);
		$cuposMayf = $this->Pileta_model->get_cupos($user->id,3);
		$cuposMen = $this->Pileta_model->get_cupos($user->id,2);
		$this->data['cuposMay'] = $cuposMay;
		$this->data['cuposMayf'] = $cuposMayf;
		$this->data['cuposMen'] = $cuposMen;

        	$this->_render_page('body/pileta', $this->data);
	    }

	}

	public function invitados(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{

		$user=$this->ion_auth->user()->row();
		$hoy=date("d-m-Y");
		$this->data['hoy']=$hoy;

        	$this->_render_page('body/invpileta', $this->data);
	    }

	}


	public function invitados_hist(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{

		$user=$this->ion_auth->user()->row();

        	$this->_render_page('body/busqueda', $this->data);
	    }

	}

	public function buscoInvitados(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{

		$user=$this->ion_auth->user()->row();
		$this->data['mes'] = $this->input->post('mes');
		$this->data['anio'] = $this->input->post('anio');

        	$this->_render_page('body/busqueda2', $this->data);
	    }

	}




	function nuevoInvitado(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
			$this->session->set_flashdata('message', 'Accion no permitida');
			redirect('Auth', 'refresh');
		}else{


		    $elBarrio=$this->Sec_model->id_barrios_user($user->id)[0];

		    $hoy=date("d-m-Y");
		    $docs = $this->Pileta_model->get_invitados_dia($hoy,$user->id);
		    if($docs->num_rows()>3){ 
			$this->session->set_flashdata('message', 'Se pueden tener como maximo 4 invitados por grupo familiar.');
			redirect('Pileta', 'refresh');
		    }



		    $cuposMay = $this->Pileta_model->get_cupos($user->id,1);
		    $cuposMen = $this->Pileta_model->get_cupos($user->id,2);
		    $cuposFam = $this->Pileta_model->get_cupos($user->id,3);
		    $this->form_validation->set_rules('nombre', 'Nombre', 'required');
		    $this->form_validation->set_rules('edad', 'Edad', 'required');

		    if ($this->form_validation->run() === TRUE){

			$nombre = $this->input->post('nombre');
			$edad = $this->input->post('edad');

			if ($this->form_validation->run() === TRUE){

			    $desconto=$cupon=$cupon0=$cupon1=$cupon2=NULL;
			    if($cuposMay>0 && $edad==1){
				$cupon = $this->input->post('cmay');
				if($cupon==1) $desconto=1;
			    }
			    if($edad==3){
				if($cuposFam>0) $cupon1 = $this->input->post('cmayf');
				if($cuposMay>0) $cupon2 = $this->input->post('cmay');
				if($cupon1==1){
				    $cupon=1;
				    $desconto=3;
				}else if($cupon2==1){
				    $cupon=1;
				    $desconto=1;
				}
			    }
			    if($edad==2){
				if($cuposMen>0) $cupon0 = $this->input->post('cmen');
				if($cuposFam>0) $cupon1 = $this->input->post('cmayf');
				if($cuposMay>0) $cupon2 = $this->input->post('cmay');
				if($cupon0==1){
				    $cupon=1;
				    $desconto=2;
				}else if($cupon2==1){
				    $cupon=1;
				    $desconto=1;
				}else if($cupon1==1){
				    $cupon=1;
				    $desconto=3;
				}
			    }
			    if(!isset($cupon)) $cupon=2;

			    $tabla1='invitados';
			    $datos1=array(
				'i_edad'=> $edad,
				'i_iduser' => $user->id,
				'i_cupon' => $cupon,
				'i_desconto' => $desconto,
				'i_nombre'    => $nombre,
			    );
			    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			    }else{
				$this->session->set_flashdata('message', 'Usted ha cargado al invitado correctamente.');
				redirect('Pileta', 'refresh');
			    }
			}else{
			    $this->session->set_flashdata('message', validation_errors());
			    redirect('Pileta', $this->data);
			}
		    }else{
			$this->session->set_flashdata('message', validation_errors());
			redirect('Pileta', $this->data);
		    }
		}
	}


	function nuevaCuponera(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
			$this->session->set_flashdata('message', 'Accion no permitida');
			redirect('Auth', 'refresh');
		}else{


		    $elBarrio=$this->Sec_model->id_barrios_user($user->id)[0];

		    $this->form_validation->set_rules('edad', 'Edad', 'required');

		    if ($this->form_validation->run() === TRUE){

			$edad = $this->input->post('edad');
			if($edad==3){
			    $canti=20;
			    $edad=1;
			}else $canti=10;

			$tabla1='cupos';
			$datos1=array(
				'c_edad'=> $edad,
				'c_iduser' => $user->id,
				'c_canti' => $canti,
			);

			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			}else{
			    $this->session->set_flashdata('message', 'Usted ha comprado la cuponera correctamente.');
			    redirect('Pileta', 'refresh');
			}
		    }else{
			$this->session->set_flashdata('message', validation_errors());
			redirect('Pileta', $this->data);
		    }
		}
	}



	function delInvitado($id){

		$id=$this->Sec_model->decrypt($id);

		$data = array(
			'i_estado' => 2,
		);
		if($this->Sec_model->update_p('invitados','i_id',$id,$data)==true){
		    redirect('Pileta', 'refresh');
		}else{
		    $this->session->set_flashdata('message', 'ERROR');
		    redirect('Pileta', 'refresh');
		}



	}



	public function cuposActivos(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{

		$users = $this->Sec_model->get_users();
		echo("id,username,cuposMay,cuposMayf,cuposMen <BR />");

		foreach($users as $user){

		    $cuposMay = $this->Pileta_model->get_cupos($user->id,1);
		    $cuposMayf = $this->Pileta_model->get_cupos($user->id,3);
		    $cuposMen = $this->Pileta_model->get_cupos($user->id,2);

		    if($cuposMay>0 || $cuposMayf>0 || $cuposMen>0){
			echo("$user->id,$user->username,$cuposMay,$cuposMayf,$cuposMen <BR />");
		    }
		}
exit();

        	$this->_render_page('body/pileta', $this->data);
	    }

	}







	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}