<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Llave extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Llave_model','Sec_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));

		$admins = array(1,3);
		$this->data['admins'] =array(1,3);
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
			    $this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
			    $this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
			}
		    }
		}

		$elBarrio=$this->Sec_model->getBarrio();
		if($elBarrio) $cops=$this->Sec_model->unidades_barrio_prop($user->id,$elBarrio);
		else $cops=array();

		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list
	public function index(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{

		$user=$this->ion_auth->user()->row();

		$elBarrio=$this->Sec_model->getBarrio();

		$sePuede=$this->Llave_model->puedoLlave($elBarrio);
		if($sePuede==1){
		    $this->data['yaHay'] = 1;
		}else
		    $this->data['yaHay'] = 2;


		$grupof=$this->getGrupof($user);
		$autoriza="<select name='autoriza' class='form-control' size='1'>\n";
		foreach($grupof as $g){
		    $autoriza.="<option value='".$g->gf_nombre."'> $g->gf_nombre </option>\n";
		}
		$autoriza.="</select>\n";

		$this->data['auto'] = $autoriza;


        	$this->_render_page('body/llave', $this->data);
	    }

	}

	public function getGrupof($user){
	    $elBarrio=$this->Sec_model->getBarrio();
	    if($elBarrio) $cops=$this->Sec_model->unidades_barrio_prop($user->id,$elBarrio);

	    $user_id=$user->id;

	    $gf=array();
	    foreach($cops as $c){
		$mayores=$this->Sec_model->grupo_familiar_mayor($c->cop_id,$user_id);
		if($mayores->num_rows() >0){
		    $q=$mayores->result();
		    foreach($q as $m){
			$gf[]=$m;
		    }
		}

		$menores=$this->Sec_model->grupo_familiar_menor($c->cop_id,$user_id);
		if($menores->num_rows() >0){
		    $q=$menores->result();
		    foreach($q as $m){
			$gf[]=$m;
		    }
		}
	    }
	    return $gf;
	}



	function nuevaLlave(){
		
		$user=$this->ion_auth->user()->row();

		if(!$this->input->post('id') == $user->id){
			$this->session->set_flashdata('message', 'Accion no permitida');
			redirect('Auth', 'refresh');
		}else{


		    $elBarrio=$this->Sec_model->getBarrio();
		    if($elBarrio) $cops=$this->Sec_model->unidades_barrio_prop($user->id,$elBarrio);
		    $idcopr=$cops[0]->cop_id;

		    $sePuede=$this->Llave_model->puedoLlave($elBarrio);
		    if($sePuede==1){
			$this->session->set_flashdata('message', 'Ya existe una solicitud de llave activa, no puede pedirla');
			redirect('Llave', $this->data);
		    }

		    $hoy=date("d-m-Y");
		    $this->form_validation->set_rules('autoriza', 'Nombre del Autorizado', 'required');

		    if ($this->form_validation->run() === TRUE){

			$nombre = $this->input->post('autoriza');

			    $tabla1='llave';
			    $datos1=array(
				'l_idptov'=> $elBarrio,
				'l_idcopr'=> $idcopr,
				'l_iduser' => $user->id,
				'l_autoriza' => $nombre,
			    );
			    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			    }else{
				$this->session->set_flashdata('message', 'Usted ha solicitado la llave para '.$nombre.'.');
				redirect('Llave', 'refresh');
			    }
		    }else{
			$this->session->set_flashdata('message', validation_errors());
			redirect('Llave', $this->data);
		    }
		}
	}

	function delLlave($id){

		$id=$this->Sec_model->decrypt($id);

		$data = array(
			'l_estado' => 999,
		);
		if($this->Sec_model->update_p('llave','l_id',$id,$data)==true){
		    redirect('Llave', 'refresh');
		}else{
		    $this->session->set_flashdata('message', 'ERROR');
		    redirect('Llave', 'refresh');
		}



	}


	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}