<?php defined('BASEPATH') OR exit('No direct script access allowed');

class FichaMedica extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Director_model','Sec_model','Fichamedica_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));



		$admins = array(1);
		$this->data['admins'] = $admins;
		$this->data['barrio'] = $this->Director_model->getBarrio();
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list




	public function FM_Director($id, $tv = NULL){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$id=$this->Sec_model->decrypt($id);
		$alumno=$this->Director_model->get_alumno_id($id);
		if($alumno) $this->data['alumno'] = $alumno;

		$fm_id=$this->Fichamedica_model->get_fichamedica($id);
		if($fm_id) $this->data['fm'] = $fm_id;

		if(!$tv) $this->data['dondevoy'] = "Director/idxtodos";
		else{
		    $tv=$this->Sec_model->decrypt($tv);
		    $this->data['dondevoy'] = $tv;
		}

		$this->_render_page('fichamedica/fichamed_director', $this->data);
	    }

	}


	public function FM_Profesor($id, $tv = NULL){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$id=$this->Sec_model->decrypt($id);
		$alumno=$this->Director_model->get_alumno_id($id);
		if($alumno) $this->data['alumno'] = $alumno;

		$fm_id=$this->Fichamedica_model->get_fichamedica($id);
		if($fm_id) $this->data['fm'] = $fm_id;

		$this->_render_page('fichamedica/fichamed_profesor', $this->data);
	    }

	}




	public function FM_User($id, $tv = NULL){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$id=$this->Sec_model->decrypt($id);
		$alumno=$this->Director_model->get_alumno_id($id);
		if($alumno) $this->data['alumno'] = $alumno;

		$fm_id=$this->Fichamedica_model->get_fichamedica($id);
		if($fm_id) $this->data['fm'] = $fm_id;

		if(!$tv) $this->data['dondevoy'] = "Director/idxtodos";
		else{
		    $tv=$this->Sec_model->decrypt($tv);
		    $this->data['dondevoy'] = $tv;
		}

		$this->_render_page('fichamedica/fichamed_user', $this->data);
	    }

	}






	public function Grupo_fm(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barriox){	//descomponemos para usar valores
			    $this->data['barr_user'][$barriox->ptv_id]= $this->Sec_model->ver_barrios($barriox->ptv_id);
			    $this->data['unidades_user'][$barriox->ptv_id][]= $this->Sec_model->ver_unidades($barriox->ufd);
			}
		    }
		}



		$this->data['dondevoy'] = "FichaMedica/Grupo_fm";


		$cops=$this->Sec_model->unidades_barrio_prop($user->id,$barrio);
		if($cops) foreach($cops as $cop){
		    $gf_men = $this->Sec_model->grupo_familiar_menor($cop->cop_id,$user->id);
		    if($gf_men->num_rows()>0){ 
    			$gf_men=$gf_men->result();
			$cf_men=count($gf_men);
		    }else $cf_men=0;
		}

		if($gf_men){
		    $this->data['menores']=$gf_men;
		    $this->_render_page('fichamedica/list_user', $this->data);
		}else{
		    $this->session->set_flashdata('message', 'No tiene menores registrados.');
		    redirect('', 'refresh');
		}
	    }

	}





	function NuevaFicha(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$tables = $this->config->item('tables','ion_auth');
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('enfermedad', 'Enfermedad/es', 'required');
		$this->form_validation->set_rules('medicacion', 'Medicacion', 'required');
		$this->form_validation->set_rules('alergia', 'Alergia', 'required');
		$this->form_validation->set_rules('tratamiento', 'Tratamiento', 'required');
		$this->form_validation->set_rules('emergencia', 'Contacto de Emergencia', 'required');


		if ($this->form_validation->run() === TRUE){


		    $al_id = $this->input->post('al_id');
		    $dondevoy = $this->input->post('dondevoy');

		    $colegio = $this->input->post('colegio');
		    $grado = $this->input->post('grado');
		    $vacuna = $this->input->post('vacuna');
		    $gruposang = $this->input->post('gruposang');
		    $enfermedad = $this->input->post('enfermedad');
		    $medicacion = $this->input->post('medicacion');
		    $alergia = $this->input->post('alergia');
		    $tratamiento = $this->input->post('tratamiento');
		    $obrasocial = $this->input->post('obrasocial');
		    $fichamed = $this->input->post('fichamed');
		    $nro=$this->input->post('nro');
		    $pediatra=$this->input->post('pediatra');
		    $telefono=$this->input->post('telefono');
		    $emergencia=$this->input->post('emergencia');
		    $aptomed=$this->input->post('aptomed');
		    $autoriza=$this->input->post('autoriza');

		    $tabla1='fichamedica';
		    $datos1=array(
			'fm_idalumno'=> $al_id,
			'fm_colegio'=> $colegio,
			'fm_grado'=> $grado,
			'fm_vacuna' => $vacuna,
			'fm_gruposang'    => $gruposang,
			'fm_enfermedad'    => $enfermedad,
			'fm_medicacion' => $medicacion,
			'fm_alergia'    => $alergia,
			'fm_tratamiento'    => $tratamiento,
			'fm_obrasocial'    => $obrasocial,
			'fm_nro'    => $nro,
			'fm_telefono'    => $telefono,
			'fm_pediatra'    => $pediatra,
			'fm_emergencia'    => $emergencia,
			'fm_aptomed'    => $aptomed,
			'fm_autoriza'    => $autoriza
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }

		    $this->session->set_flashdata('message', 'Usted ha actualizado la ficha medica del alumno.');
		    redirect($dondevoy, 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect($dondevoy, $this->data);
	        }
	    }
	}


	function EditFicha(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$tables = $this->config->item('tables','ion_auth');
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('enfermedad', 'Enfermedad/es', 'required');
		$this->form_validation->set_rules('medicacion', 'Medicacion', 'required');
		$this->form_validation->set_rules('alergia', 'Alergia', 'required');
		$this->form_validation->set_rules('tratamiento', 'Tratamiento', 'required');
		$this->form_validation->set_rules('emergencia', 'Contacto de Emergencia', 'required');


		if ($this->form_validation->run() === TRUE){


		    $al_id = $this->input->post('al_id');
		    $fm_id = $this->input->post('fm_id');
		    $dondevoy = $this->input->post('dondevoy');

		    $colegio = $this->input->post('colegio');
		    $grado = $this->input->post('grado');
		    $vacuna = $this->input->post('vacuna');
		    $gruposang = $this->input->post('gruposang');
		    $enfermedad = $this->input->post('enfermedad');
		    $medicacion = $this->input->post('medicacion');
		    $alergia = $this->input->post('alergia');
		    $tratamiento = $this->input->post('tratamiento');
		    $obrasocial = $this->input->post('obrasocial');
		    $fichamed = $this->input->post('fichamed');
		    $nro=$this->input->post('nro');
		    $pediatra=$this->input->post('pediatra');
		    $telefono=$this->input->post('telefono');
		    $emergencia=$this->input->post('emergencia');
		    $aptomed=$this->input->post('aptomed');
		    $autoriza=$this->input->post('autoriza');

		    $tabla1='fichamedica';
		    $datos1=array(
			'fm_idalumno'=> $al_id,
			'fm_colegio'=> $colegio,
			'fm_grado'=> $grado,
			'fm_vacuna' => $vacuna,
			'fm_gruposang'    => $gruposang,
			'fm_enfermedad'    => $enfermedad,
			'fm_medicacion' => $medicacion,
			'fm_alergia'    => $alergia,
			'fm_tratamiento'    => $tratamiento,
			'fm_obrasocial'    => $obrasocial,
			'fm_nro'    => $nro,
			'fm_telefono'    => $telefono,
			'fm_pediatra'    => $pediatra,
			'fm_emergencia'    => $emergencia,
			'fm_aptomed'    => $aptomed,
			'fm_autoriza'    => $autoriza
		    );

		    if($this->Sec_model->update_p($tabla1,"fm_id",$fm_id,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }


		    $this->session->set_flashdata('message', 'Usted ha actualizado la ficha medica del alumno.');
		    redirect($dondevoy, 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect($dondevoy, $this->data);
	        }
	    }
	}






	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}