<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Director extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language','directory'));
		$this->load->model(array('Director_model','Sec_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));



		$admins = array(1);
		$this->data['admins'] = $admins;
		$this->data['barrio'] = $this->Director_model->getBarrio();
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list






/************************************* ABM GRUPOS ****************************************************/


	public function index($id = NULL){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$profesores = $this->Director_model->get_profes($barrio);
		$this->data['profesores'] =$profesores;

		if($id){
		    $id = $this->Sec_model->decrypt($id);
		    $grupoActual=$this->Director_model->get_gruposActivi($barrio,$id);
		    if($grupoActual){
			$this->data['grupoActual'] = $grupoActual[0];
			$profesDeGrupo = $this->Director_model->profes_por_grupo($grupoActual[0]->ga_id);
			if($profesDeGrupo){
			    $this->data['profesDeGrupo'] = $profesDeGrupo;
			    $this->data['cantProfes'] = count($profesDeGrupo);
			}
		    }
		}

		$this->_render_page('director/ngrupo', $this->data);
	    }

	}


	function NuevoGrupo(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('nombre', 'Nombre del Grupo', 'required');
		$this->form_validation->set_rules('profe0', 'Profesor Asignado', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();

		    $nombre = $this->input->post('nombre');
		    $dias = $this->input->post('dias');
		    $horarios = $this->input->post('horario');
		    $tipo = $this->input->post('tipo');
		    $actividades = $this->input->post('actividades');

		    $tabla1='gruposactivi';
		    $datos1=array(
			'ga_idptov'=> $barrio,
			'ga_nombre'=> $nombre,
			'ga_dias'=> $dias,
			'ga_tipo'=> $tipo,
			'ga_horarios'=> $horarios,
			'ga_actividades'=> $actividades
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }else{

			$ga_id=$this->db->insert_id('gruposactivi_ga_id_seq');
			for($m=0;$m<4;$m++){
			    $pfe= $this->input->post('profe'.$m);
			    if($pfe){
				$tabla2="pfxgpo";
				$datos2=array(
				    'pg_idgrupo' => $ga_id,
				    'pg_idprofe' => $pfe
				);

				$existe=$this->Director_model->profes_por_grupo($ga_id,$pfe);
				if(!$existe) $this->Sec_model->insert($tabla2,$datos2);
			    }
			}

		    }
		    $this->session->set_flashdata('message', 'Usted ha cargado el grupo correctamente.');
		    redirect('Director', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director', $this->data);
		}
	    }
	}



	function EditarGrupo(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('nombre', 'Nombre del Grupo', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();

		    $nombre = $this->input->post('nombre');
		    $dias = $this->input->post('dias');
		    $horarios = $this->input->post('horario');
		    $actividades = $this->input->post('actividades');
		    $tipo = $this->input->post('tipo');

		    $idGrupo = $this->input->post('ga_id');

		    $tabla1='gruposactivi';
		    $datos1=array(
			'ga_idptov'=> $barrio,
			'ga_nombre'=> $nombre,
			'ga_dias'=> $dias,
			'ga_tipo'=> $tipo,
			'ga_horarios'=> $horarios,
			'ga_actividades'=> $actividades
		    );
		    if($this->db->update($tabla1,$datos1,array('ga_id' => $idGrupo)) == FALSE){
			echo $this->db->last_query();
			exit;
		    }else{

			$ga_id=$idGrupo;
			for($m=0;$m<4;$m++){
			    $pfe= $this->input->post('profe'.$m);
			    if($pfe){
				$tabla2="pfxgpo";
				$datos2=array(
				    'pg_idgrupo' => $ga_id,
				    'pg_idprofe' => $pfe
				);

				$existe=$this->Director_model->profes_por_grupo($ga_id,$pfe);
				if(!$existe) $this->Sec_model->insert($tabla2,$datos2);
			    }
			}

		    }
		    $this->session->set_flashdata('message', 'Usted ha cargado el grupo correctamente.');
		    redirect('Director', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director', $this->data);
		}
	    }
	}











	function delProfeDeGrupo($idGrupo, $idProfe){

	    $profesDeGrupo = $this->Director_model->profes_por_grupo($idGrupo);
	    $cantProfes = count($profesDeGrupo);
	    if($cantProfes==1){
		$id=$this->Sec_model->ecrypt($idGrupo);
		$this->session->set_flashdata('message', 'No es posible dejar el grupo sin profesores. Si desea eliminarlo, antes grabe uno nuevo.');
		redirect('Director/index/'.$id, $this->data);
		exit();
	    }



	    $data = array(
		'pg_estado' => '999',
	    );
	    $this->db->where('pg_idprofe' ,$idProfe);
	    $this->db->where('pg_idgrupo' ,$idGrupo);
	    $this->db->update('pfxgpo' , $data);

	    $id=$this->Sec_model->ecrypt($idGrupo);

	    redirect('Director/index/'.$id, $this->data);

	}


	function delGrupo($idGrupo){

	    $idGrupo=$this->Sec_model->decrypt($idGrupo);

	    $data = array(
		'ga_estado' => '999',
	    );
	    $this->db->where('ga_id' ,$idGrupo);
	    $this->db->update('gruposactivi' , $data);


	    redirect('Director', $this->data);

	}


/************************************* FIN ABM GRUPOS ****************************************************/


/************************************* CONFORMACION DE GRUPOS ****************************************************/


	public function ConformGA($id){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;

		//Actualizo tabla Alumnos
		$this->Director_model->cargoalumnos($barrio);


//			$this->Director_model->sumarAlumnoActivi(22,30);


		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		if($id){

		    $id = $this->Sec_model->decrypt($id);
		    $grupoActual=$this->Director_model->get_gruposActivi($barrio,$id);
		    if($grupoActual){
			$this->data['grupoActual'] = $grupoActual[0];
			$profesDeGrupo = $this->Director_model->profes_por_grupo($grupoActual[0]->ga_id);
			if($profesDeGrupo){
			    $this->data['profesDeGrupo'] = $profesDeGrupo;
			    $this->data['cantProfes'] = count($profesDeGrupo);
			}
		    }

		}


		$this->_render_page('director/conformga', $this->data);
	    }

	}






	function ConformGrupo(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{

		    $barrio=$this->Director_model->getBarrio();

		    $idgf = $this->input->post('idgf');
		    $idext = $this->input->post('idext');

		    $idGrupo = $this->input->post('ga_id');
		    $idGrupoc = $this->Sec_model->ecrypt($idGrupo);

		    if(!$idgf && !$idext){
			$this->session->set_flashdata('message', 'Debe definir al menos un alumno (o propietario o externo).');
			redirect('Director/ConformGA/'.$idGrupoc, 'refresh');
		    }


		    if($idgf){
			$tabla1='aluxgpo';
			$datos1=array(
			    'ag_idalumno'=> $idgf,
			    'ag_idgrupo'=> $idGrupo,
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}

//			$this->Director_model->sumarAlumnoActivi($idgf,$idGrupo);


		    }

		    if($idext){
			$tabla1='aluxgpo';
			$datos1=array(
			    'ag_idalumno'=> $idext,
			    'ag_idgrupo'=> $idGrupo,
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}
		    }
		    redirect('Director/ConformGA/'.$idGrupoc, 'refresh');
	    }
	}



	function delAlumnoDeGrupo($idGrupo, $idAlumno){

	    $data = array(
		'ag_estado' => '999',
	    );
	    $this->db->where('ag_idalumno' ,$idAlumno);
	    $this->db->where('ag_idgrupo' ,$idGrupo);
	    $this->db->update('aluxgpo' , $data);


	    $this->Director_model->delAsistenciaGrupo($idGrupo,$idAlumno);

	    $id=$this->Sec_model->ecrypt($idGrupo);

	    redirect('Director/ConformGA/'.$id, 'refresh');

	}



















	function buscogf(){

	    $term=$_POST['term'];
	    $elBarrio=$_POST['ash_idptov'];

	    $alumnos=$this->Director_model->get_gf($term,$elBarrio);

	    if($alumnos){
		$respuesta=array();
		foreach($alumnos as $g){
		    $add=array();
		    $gf_id=$g->gf_id;
		    $gf_nombre=$this->Sec_model->Decode($g->gf_nombre);
		    $tabla=$g->tabla;
		    $gf_dni=$g->gf_nrodoc;
		    $gf_uf=$g->uf;

		    $al=$this->Director_model->get_alumno($elBarrio,$tabla,$gf_id);
		    if($al){
			$al_id=$al->al_id;
		    }else{
			$al_id=NULL;
		    }

		    $name="Nombre: $gf_nombre - DNI: $gf_dni - UF: $gf_uf";

		    $add=array("name"=>$name,"value"=>$al_id);
		    $respuesta[]=$add;
		}
		echo $_GET['callback']."(".json_encode($respuesta).")";
	    }else echo $_GET['callback']."()";


	}


	function buscoext(){

	    $term=$_POST['term'];
	    $elBarrio=$_POST['ash_idptov'];

	    $alumnos=$this->Director_model->get_ext($term,$elBarrio);

	    if($alumnos){
		$respuesta=array();
		foreach($alumnos as $g){
		    $add=array();
		    $ae_id=$g->ae_id;
		    $ae_nombre=$this->Sec_model->Decode($g->ae_nombre);
		    $tabla=$g->tabla;
		    $ae_dni=$g->ae_nrodoc;
		    $gf_uf=$g->uf;

		    $al=$this->Director_model->get_alumno($elBarrio,$tabla,$ae_id);
		    if($al){
			$al_id=$al->al_id;
		    }else{
			$al_id=NULL;
		    }
		    $name="Nombre: $ae_nombre - DNI: $ae_dni - Invitado x UF: $gf_uf";
		    $add=array("name"=>$name,"value"=>$al_id);
		    $respuesta[]=$add;
		}
		echo $_GET['callback']."(".json_encode($respuesta).")";
	    }else echo $_GET['callback']."()";


	}





/************************************* FIN CONFORMACION DE GRUPOS ****************************************************/




/* ************************ INICIO PROFESORES ******************* */


	public function idxprofesores($id = NULL){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		if($id){

		    $profe=$this->Director_model->get_profe($id);
		    if($profe) $this->data['profe'] = $profe;

		}


		$this->_render_page('director/nprofe', $this->data);
	    }

	}




	function NuevoProfe(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$tables = $this->config->item('tables','ion_auth');
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('nombre', 'Nombre', 'required');
		$this->form_validation->set_rules('mail', $this->lang->line('create_user_validation_email_label'), 'required|valid_email|is_unique[' . $tables['users'] . '.email]');
		$this->form_validation->set_rules('telefono', 'Telefono', 'required');
		$this->form_validation->set_rules('pass', 'Contrase&ntilde;a', 'required');


		if ($this->form_validation->run() === TRUE){

		    $barrio = $this->Director_model->getBarrio();
	            $email    = strtolower($this->input->post('mail'));
	            $identity = $email;
	            $password = $this->input->post('pass');

		    $existe=$this->Director_model->get_profes($barrio,$email);

		    if($existe){
			$this->session->set_flashdata('message', 'El profesor que intenta cargar ya existe en la base de datos');
			redirect('Director/idxprofesores', $this->data);
			exit();
		    }


		    $nombre = $this->input->post('nombre');
		    $tel = $this->input->post('telefono');
		    $nom=explode(" ",$nombre);

		    $first=$nom[0];
		    $last=end($nom);


	            $additional_data = array(
	                'first_name' => $first,
	                'last_name'  => $last,
	                'tipo'      => 1,
	                'phone'      => $tel,
	            );

//		    $grupo=$this->ion_auth->group(3)->result()[0];
		    $grupo=array(3);

		    $new_user = $this->ion_auth->register($identity, $password, $email, $additional_data, $grupo);
		    if($new_user){
			$barrio=$this->Director_model->getBarrio();
			$tabla1='profesores';
			$datos1=array(
			    'pf_idptov'=> $barrio,
			    'pf_nombre'=> $nombre,
			    'pf_iduser' => $new_user,
			    'pf_tel'    => $tel,
			    'pf_mail'    => $email
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}
			$this->session->set_flashdata('message', 'Usted ha cargado al nuevo profesor en el sistema.');
			redirect('Director/idxprofesores', 'refresh');
		    }else{
			$this->session->set_flashdata('message', 'Error al registrar el usuario');
			redirect('Director/idxprofesores', $this->data);
		    }
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director/idxprofesores', $this->data);
	        }
	    }
	}







	function EditProfe(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$tables = $this->config->item('tables','ion_auth');
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('nombre', 'Nombre', 'required');
		$this->form_validation->set_rules('telefono', 'Telefono', 'required');
		$this->form_validation->set_rules('pass', 'Contrase&ntilde;a', 'required');


		if ($this->form_validation->run() === TRUE){

	            $password = $this->input->post('pass');
	            $user_id = $this->input->post('pf_userid');
	            $pf_id = $this->input->post('pf_id');


		    $nombre = $this->input->post('nombre');
		    $tel = $this->input->post('telefono');

		    if($password){
			$query = $this->db->select('id, password, salt')
		                  ->where('id', $user_id)
		                  ->limit(1)
		    			  ->order_by('id', 'desc')
		                  ->get('users');

			$pfuser = $query->row();
			$hashed_new_password  = $this->ion_auth->hash_password($password, $pfuser->salt);
			$data = array(
			    'password' => $hashed_new_password,
			    'remember_code' => NULL,
			);
			$successfully_changed_password_in_db = $this->db->update('users', $data, array('id' => $user_id));
		    }

		    $tabla1='profesores';
		    $datos1=array(
			'pf_nombre'=> $nombre,
			'pf_tel'    => $tel,
		    );
		    if($this->db->update($tabla1,$datos1,array('pf_id' => $pf_id)) == FALSE){
			echo $this->db->last_query();
			exit;
		    }
		    $this->session->set_flashdata('message', 'Usted ha modificado al profesor en el sistema.');
		    redirect('Director/idxprofesores', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director/idxprofesores', $this->data);
	        }
	    }
	}



	function delProfe($id){
		
		$id = $this->Sec_model->decrypt($id);

		$existe=$this->Director_model->get_profe($id);
		$tabla='users';
		$datos=array(
		    'active' => 0,
		);
		if($this->Sec_model->update_p($tabla,"id",$existe->pf_iduser,$datos) == FALSE){
		    echo $this->db->last_query();
		    exit;
		}


		$tabla1='profesores';
		$datos1=array(
		    'pf_estado'=> 9,
		);
		if($this->Sec_model->update_p($tabla1,"pf_id",$id,$datos1) == FALSE){
		    echo $this->db->last_query();
		    exit;
		}
		redirect('Director/idxprofesores', 'refresh');
	}




/* ************************ FIN PROFESORES ******************* */





/* ************************ INICIO ALUMNOS ******************* */


	public function idxalumnos($id = NULL){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$procedExt=$this->Director_model->get_proced();
		if($procedExt) $this->data['procedext'] = $procedExt;

		$coprop=$this->Sec_model->ver_unidades_de_barrio($barrio);
		if($coprop) $this->data['coprop'] = $coprop;


		if($id){
		    $id=$this->Sec_model->decrypt($id);
		    $alumno=$this->Director_model->get_alumno_externo_id($id);
		    if($alumno) $this->data['alumno'] = $alumno;
		}

		$this->_render_page('director/nalumno', $this->data);
	    }

	}


	public function idxtodos(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$this->Director_model->cargoalumnos($barrio);

		$this->_render_page('director/totalumno', $this->data);
	    }

	}


	public function datos(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;

		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$this->_render_page('director/datos', $this->data);
	    }

	}




	function NuevoAlumno(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$tables = $this->config->item('tables','ion_auth');
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('nombre', 'Nombre', 'required');
		$this->form_validation->set_rules('nrodoc', 'Numero de Documento', 'required');
		$this->form_validation->set_rules('fecnac', 'Fecha de Nacimiento', 'required');
		$this->form_validation->set_rules('telp', 'Telefono del Padre', 'required');
		$this->form_validation->set_rules('telm', 'Telefono de la Madre', 'required');


		if ($this->form_validation->run() === TRUE){

	            $nrodoc    = $this->input->post('nrodoc');
		    $barrio = $this->Director_model->getBarrio();
		    $existe=$this->Director_model->get_alumno_externo($barrio,$nrodoc);

		    if($existe){
			$this->session->set_flashdata('message', 'El alumno que intenta cargar ya existe en la base de datos');
			redirect('Director/idxalumnos', $this->data);
			exit();
		    }


		    $nombre = $this->input->post('nombre');
		    $fecnac = $this->input->post('fecnac');
		    $padre = $this->input->post('padre');
		    $telp = $this->input->post('telp');
		    $mailp = $this->input->post('mailp');
		    $madre = $this->input->post('madre');
		    $telm = $this->input->post('telm');
		    $mailm = $this->input->post('mailm');
		    $proced = $this->input->post('proced');
		    $fichamed = $this->input->post('fichamed');
		    if($proced==1) $invitadopor=$this->input->post('invitadopor');
		    else $invitadopor=NULL;

		    $tabla1='alexternos';
		    $datos1=array(
			'ae_idptov'=> $barrio,
			'ae_nombre'=> $nombre,
			'ae_nrodoc'=> $nrodoc,
			'ae_fecnac'=> $fecnac,
			'ae_padre' => $padre,
			'ae_telp'    => $telp,
			'ae_mailp'    => $mailp,
			'ae_madre' => $madre,
			'ae_telm'    => $telm,
			'ae_mailm'    => $mailm,
			'ae_proced'    => $proced,
			'ae_invitadopor'    => $invitadopor
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }

		    $edad=1;
		    if($fecnac){
			$anios=$this->Director_model->get_edad($fecnac);
			if($anios>=16) $edad=2;
		    }

		    $ae_id=$this->db->insert_id('alexternos_ae_id_seq');
		    $tabla2='alumnos';
		    $datos2=array(
			'al_idptov' => $barrio,
			'al_edad' => $edad,
			'al_ext' => $ae_id
		    );
		    if($this->Sec_model->insert($tabla2,$datos2) == FALSE){
			echo $this->db->last_query();
			exit;
		    }
		    $al_id=$this->db->insert_id('alumnos_al_id_seq');
		    $al_id=$this->Sec_model->ecrypt($al_id);

		    $this->session->set_flashdata('message', 'Usted ha cargado al nuevo alumno en el sistema.');
		    if($fichamed==1){
			redirect('FichaMedica/FM_Director/'.$al_id, 'refresh');
		    }else{
			redirect('Director/idxalumnos', 'refresh');
		    }
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director/idxalumnos', $this->data);
	        }
	    }
	}







	function EditAlumno(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$tables = $this->config->item('tables','ion_auth');
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('nombre', 'Nombre', 'required');
		$this->form_validation->set_rules('fecnac', 'Fecha de Nacimiento', 'required');
		$this->form_validation->set_rules('telp', 'Telefono del Padre', 'required');
		$this->form_validation->set_rules('telm', 'Telefono de la Madre', 'required');

		$ae_id = $this->input->post('ae_id');

		if ($this->form_validation->run() === TRUE){
		    $barrio = $this->Director_model->getBarrio();
		    $nombre = $this->input->post('nombre');
		    $nrodoc = $this->input->post('nrodoc');
		    $fecnac = $this->input->post('fecnac');
		    $padre = $this->input->post('padre');
		    $telp = $this->input->post('telp');
		    $mailp = $this->input->post('mailp');
		    $madre = $this->input->post('madre');
		    $telm = $this->input->post('telm');
		    $mailm = $this->input->post('mailm');
		    $proced = $this->input->post('proced');
		    $fichamed = $this->input->post('fichamed');
		    if($proced==1) $invitadopor=$this->input->post('invitadopor');
		    else $invitadopor=NULL;

		    $tabla1='alexternos';
		    $datos1=array(
			'ae_idptov'=> $barrio,
			'ae_nombre'=> $nombre,
			'ae_fecnac'=> $fecnac,
			'ae_padre' => $padre,
			'ae_telp'    => $telp,
			'ae_mailp'    => $mailp,
			'ae_madre' => $madre,
			'ae_telm'    => $telm,
			'ae_mailm'    => $mailm,
			'ae_proced'    => $proced,
			'ae_invitadopor'    => $invitadopor
		    );
		    if($nrodoc) $datos1['ae_nrodoc'] = $nrodoc;

		    if($this->db->update($tabla1,$datos1,array('ae_id' => $ae_id)) == FALSE){
			echo $this->db->last_query();
			exit;
		    }
		    $this->session->set_flashdata('message', 'Usted ha modificado al alumno en el sistema.');
		    redirect('Director/idxalumnos', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director/idxalumnos/'.$this->Sec_model->ecrypt($ae_id), $this->data);
	        }
	    }
	}



	function delAlumno($id){
		
		$id = $this->Sec_model->decrypt($id);

		$tabla1='alexternos';
		$datos1=array(
		    'ae_estado'=> 9,
		);
		if($this->Sec_model->update_p($tabla1,"ae_id",$id,$datos1) == FALSE){
		    echo $this->db->last_query();
		    exit;
		}

		$al_id=$this->Director_model->dato_alumno('alumnos','al_id','al_ext',$id)->al_id;
		$tabla1='alumnos';
		$datos1=array(
		    'al_estado'=> 9,
		);
		if($this->Sec_model->update_p($tabla1,"al_ext",$id,$datos1) == FALSE){
		    echo $this->db->last_query();
		    exit;
		}


		$data = array(
		    'ag_estado' => '999',
		);
		$this->db->where('ag_idalumno' ,$al_id);
		$this->db->update('aluxgpo' , $data);


		redirect('Director/idxalumnos', 'refresh');
	}




/* ************************ FIN ALUMNOS ******************* */







/************************************* ABM ACTIVIDADES ****************************************************/


	public function idxactivi($id = NULL){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$profesores = $this->Director_model->get_profes($barrio);
		$this->data['profesores'] =$profesores;

		if($id){
		    $id = $this->Sec_model->decrypt($id);
		    $activiActual=$this->Director_model->get_activi($barrio,$id);
		    if($activiActual){
			$this->data['activiActual'] = $activiActual[0];
		    }
		}

		$map = $this->Director_model->iterate();
		$this->data['map'] = $map;

		$dir = $this->Director_model->dirit();
		$dir=base_url().$dir;
		$this->data['dir'] = $dir;

		$this->_render_page('director/nactivi', $this->data);
	    }

	}


	public function planillas(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$this->_render_page('director/planillas', $this->data);
	    }

	}



	public function gmg($id){
	    $mails=$this->Director_model->get_mails_grupo($id);
	    $mails[]="mako.lm@gmail.com";
	    echo json_encode($mails);
	}




/*
	function NuevaActivi(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('dias', 'Dia de la Actividad', 'required');
		$this->form_validation->set_rules('horario', 'Hora de la Actividad', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();

		    $nombre = $this->input->post('grupo');
		    $dias = $this->input->post('dias');
		    $horarios = $this->input->post('horario');

		    $tabla1='activi';
		    $datos1=array(
			'ac_idptov'=> $barrio,
			'ac_idgpo'=> $nombre,
			'ac_fecha'=> $dias,
			'ac_iduser'=> $user->id,
			'ac_hora'=> $horarios
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }

		    $this->session->set_flashdata('message', 'Usted ha cargado la actividad correctamente. Preceda a la brevedad a tomar lista.');
		    redirect('Director/idxactivi', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director/idxactivi', $this->data);
		}
	    }
	}

*/


	function NuevaActivi(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('dias', 'Dia de la Actividad', 'required');
		$this->form_validation->set_rules('horario', 'Hora de la Actividad', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();

		    $nombre = $this->input->post('grupo');

		    $nomGr=$this->Director_model->get_gruposActivi($barrio, $nombre);
		    $nomGr=$nomGr[0]->ga_nombre;


		    $dias = $this->input->post('dias');
		    $horarios = $this->input->post('horario');
		    $imagen = $this->input->post('imagen');
		    $informa = $this->input->post('informa');
		    $activi = $this->input->post('activi');



		    $tabla1='activi';
		    $datos1=array(
			'ac_idptov'=> $barrio,
			'ac_idgpo'=> $nombre,
			'ac_fecha'=> $dias,
			'ac_activi'=> $activi,
			'ac_img'=> $imagen,
			'ac_fecha'=> $dias,
			'ac_iduser'=> $user->id,
			'ac_hora'=> $horarios
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;

		    }

		    if($informa){

			$act_id = $this->db->insert_id('activi_ac_id_seq');

			$config['upload_path']          = './uploads/crimg/';
			$config['allowed_types']        = 'jpg|jpeg|gif|png|pdf';
			$config['max_size']             = 10240;
			$this->load->library('upload', $config);
			$this->load->library('image_lib');
			$dirgrab="";

			//var_dump($this->input->post());exit;
			if(isset($_FILES)){
			    if ($this->upload->do_upload('file_flyer')) {
				$upload_data = $this->upload->data();
				$data_ary = array(
				    'title'     => $upload_data['client_name'],
				    'file'      => $upload_data['file_name'],
				    'width'     => $upload_data['image_width'],
				    'height'    => $upload_data['image_height'],
				    'type'      => $upload_data['image_type'],
				    'size'      => $upload_data['file_size'],
				    'path'      => $upload_data['full_path'],
				    'date'      => time(),
				);

				$ext=pathinfo($data_ary['path'], PATHINFO_EXTENSION);
				$data = array('upload_data' => $upload_data);
				$dirgrab=$data_ary['path'];
			    }else{
				if($_FILES['file_flyer']['error'] != 4){
				    $error = array('error' => $this->upload->display_errors());
				    $new_data=array(
					'message'=>$error
				    );
				    $this->session->set_flashdata($new_data);
				    redirect('Director/idxactivi', $this->data);
				}
			    }
			}else{
			    $dirgrab=$this->GenerImg($imagen,$nomGr,$horarios,$dias,$activi,$act_id);
			}

			if($dirgrab){
			    $datos2=array(
				'ac_dirgrab' => $dirgrab
			    );
			}else{
			    $new_data=array(
				'message'=>'Error al subir o generar la imagen, intente nuevamente'
			    );
			    $this->session->set_flashdata($new_data);
			    redirect('Director/idxactivi', $this->data);
			    exit();
			}




			if($this->db->update($tabla1,$datos2,array('ac_id' => $act_id)) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}

		    }


		    $this->session->set_flashdata('message', 'Usted ha cargado la actividad correctamente. Preceda a la brevedad a tomar lista.');
		    redirect('Director/idxactivi', 'refresh');



		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director/idxactivi', $this->data);
		}
	    }
	}


	function DuplicoActivi($ac_id){
	    $barrio=$this->Director_model->getBarrio();

	    $nomGr=$this->Director_model->get_activi($barrio, $ac_id);
	    $dias = $nomGr[0]->ac_fecha;
	    $horarios = $nomGr[0]->ac_hora;
	    $imagen = $nomGr[0]->ac_dirgrab;
	    $img = $nomGr[0]->ac_img;
	    $activi = $nomGr[0]->ac_activi;
	    $grupo = $nomGr[0]->ac_idgpo;

	    $gactiv=$this->Director_model->get_gruposActivi($barrio, $grupo);
	    $grupo_n=$gactiv[0]->ga_nombre;

	    $anio=2020;
	    $fechad=strtotime($dias);

	    while($anio==2020){
		$fechad=date("d-m-Y",strtotime('+1 day',$fechad));
		$fechad=strtotime($fechad);
		$dow=date('w',$fechad);

		if($dow==0 || $dow==6){
		    $dia=date("d-m-Y",$fechad);
		    $tabla1='activi';
		    $datos1=array(
			'ac_idptov'=> $barrio,
			'ac_idgpo'=> $grupo,
			'ac_fecha'=> $dia,
			'ac_activi'=> $activi,
			'ac_img'=> $img,
			'ac_iduser'=> 23,
			'ac_hora'=> $horarios
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;

		    }

		    $act_id = $this->db->insert_id('activi_ac_id_seq');
		    $dirgrab=$this->GenerImg($img,$grupo_n,$horarios,$dia,$activi,$act_id);

		    if($dirgrab){
			$datos2=array(
			    'ac_dirgrab' => $dirgrab
			);
			if($this->db->update($tabla1,$datos2,array('ac_id' => $act_id)) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}

		    }
		}

		$anio=date('Y',$fechad);

	    }
	}






	function sendmail_adj($usermail,$subject,$sms,$file){
	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'No Responder');
	    $this->email->bcc($usermail); 
	    $this->email->subject($subject);
	    $this->email->message($sms);
	    $this->email->attach($file);
	    if ($this->email->send())
		$this->session->set_flashdata('message', 'Se ha enviado el e-mail.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }
	}




	function GenerImg($imagen,$nomGr,$horarios,$dias,$activi,$id){
	    $dir = $this->Director_model->dirit();
	    $dir=base_url().$dir;
	    $imgx=$dir.$imagen;

	    $nombre_archivo = $imgx;
	    $im = ImageCreateTruecolor(640, 480);
	    $im1 = ImageCreateFromJpeg($nombre_archivo);
	    list($ancho, $alto) = GetImageSize($nombre_archivo);
	    ImageCopyResized  ( $im, $im1, 0, 0, 0, 0, 640, 480, $ancho, $alto ); 
	    ImageDestroy($im1);

	    $color = ImageColorAllocateAlpha($im, 0, 0, 0, 0);
	    $rojo     = imagecolorallocatealpha($im, 255, 255, 255, 75);
	    $fuente = realpath('/opt/www/html/lostroncoscc.com.ar/ci/assets/css/raleway.ttf');

	    $txt1="Grupo: $nomGr";
	    $txt2="Da: $dias";
	    $txt3="Horario: $horarios";
	    $txt4="Actividad: $activi";
	    $largo1=imagettfbbox(28,0,$fuente,$txt1)[4];
	    $largo2=imagettfbbox(22,0,$fuente,$txt2)[4];
	    $largo3=imagettfbbox(22,0,$fuente,$txt3)[4];
	    $corte=53;
	    $strlen=strlen($txt4);
	    if($strlen>=$corte){
		$split=explode(" ",$txt4);
		$ag=array();
		$m=0;
		$res=$res1="";
		foreach($split as $st){
		    if(!$res1) $res1=$st; else $res1.=" $st";
		    if(strlen($res1)>$corte){
			$ag[$m]=$res;
			$m++;
			$res=$res1="$st";
		    }else
			if(!$res) $res=$st; else $res.=" $st";
		}
		$ag[$m]=$res;
		$j=4;
		foreach($ag as $a){
		    ${'txt'.$j}=$a;
		    $j++;
		}
		$alto=30*$m;
	    }else{
		$alto=0;
		$txt5=$ag=NULL;
	    }
	    if(strlen($txt4)>strlen($txt5)) $largo4=imagettfbbox(16,0,$fuente,$txt4)[4];
	    else $largo4=imagettfbbox(16,0,$fuente,$txt5)[4];

	    ImageFilledRectangle($im, 50, 40, 50+$largo1, 85, $rojo);
	    ImageFilledRectangle($im, 50, 95, 50+$largo2, 130, $rojo);
	    ImageFilledRectangle($im, 50, 140, 50+$largo3, 175, $rojo);
	    ImageFilledRectangle($im, 50, 185, 50+$largo4, 225+$alto, $rojo);
	    ImageTtfText($im, 28, 0, 50, 80, $color, $fuente, $txt1);
	    ImageTtfText($im, 22, 0, 50, 125, $color, $fuente, $txt2);
	    ImageTtfText($im, 22, 0, 50, 170, $color, $fuente, $txt3);
	    ImageTtfText($im, 16, 0, 50, 215, $color, $fuente, $txt4);
	    if($ag){
		$k=30;
		for($a=1;$a<=$m;$a++){
		    $s=$a+4;
		    ImageTtfText($im, 16, 0, 50, 215+$k, $color, $fuente, ${'txt'.$s});
		    $k+=30;
		}
	    }
	    $dirgrab = '/opt/www/html/lostroncoscc.com.ar/ci/uploads/crimg/m'.$id.'.jpg';
	    ImageJpeg($im,$dirgrab);
	    ImageDestroy($im);
	    return $dirgrab;
	}





	function EditarActivi(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		$this->form_validation->set_rules('dias', 'Dia de la Actividad', 'required');
		$this->form_validation->set_rules('horario', 'Hora de la Actividad', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();

		    $dias = $this->input->post('dias');
		    $horarios = $this->input->post('horario');

		    $idActivi = $this->input->post('ac_id');

		    $tabla1='activi';
		    $datos1=array(
			'ac_fecha'=> $dias,
			'ac_hora'=> $horarios,
		    );
		    if($this->db->update($tabla1,$datos1,array('ac_id' => $idActivi)) == FALSE){
			echo $this->db->last_query();
			exit;
		    }

		    $this->session->set_flashdata('message', 'Usted ha actualizado la actividad correctamente.');
		    redirect('Director/idxactivi', 'refresh');
		}else{
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director/idxactivi', $this->data);
		}
	    }
	}




	function delActivi($idActivi){

	    $idActivi=$this->Sec_model->decrypt($idActivi);

	    $data = array(
		'ac_estado' => '999',
	    );
	    $this->db->where('ac_id' ,$idActivi);
	    $this->db->update('activi' , $data);


	    redirect('Director/idxactivi', $this->data);

	}


/************************************* FIN ABM ACTIVIDADES ****************************************************/








/************************************* ABM ASISTENCIA ****************************************************/


	public function Asistencia($idActivi){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		if($idActivi){
		    $id = $this->Sec_model->decrypt($idActivi);
		    $activiActual=$this->Director_model->get_activi($barrio,$id);
		    if($activiActual){
			$grupo= $this->Director_model->tipo_grupo($activiActual[0]->ac_idgpo);
			$this->data['grupoActivi'] = $grupo;
			$this->data['activiActual'] = $activiActual[0];

			$faltantes = $this->Director_model->asistentes_faltantes($id);
			if($faltantes){
			    foreach($faltantes as $ff){
				$idalu = $ff->al_id;

				$tabla1='asistxactivi';
				$datos1=array(
				    'aa_idalu'=> $idalu,
				    'aa_idact'=> $id,
				    'aa_asistio'=> 2,
				    'aa_iduser'=> $user->id
				);
				if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
				    echo $this->db->last_query();
				    exit;
				}
			    }
			}

			$alumnosGrupo = $this->Director_model->asistencia_por_grupo($id,2);
			if($alumnosGrupo){
			    $this->data['alumnosGrupo'] = $alumnosGrupo;
			    $alumnosGrupos = $this->Director_model->asistencia_por_grupo($id,1);
			    if($alumnosGrupos){
				$cantPresentes=count($alumnosGrupos);
				$this->data['cantPresentes'] = $cantPresentes;
			    }
			}else{
			    $alumnosGrupo = $this->Director_model->asistencia_por_grupo($id,1);
			    if(!$alumnosGrupo){
				$alumnosGrupo = $this->Director_model->alumnos_por_grupo($activiActual[0]->ga_id);
				if($alumnosGrupo) $this->data['alumnosGrupo'] = $alumnosGrupo;
			    }else{
				$cantPresentes=count($alumnosGrupo);
				$this->data['cantPresentes'] = $cantPresentes;
			    }
			}
		    }
		}

		$procedExt=$this->Director_model->get_proced();
		if($procedExt) $this->data['procedext'] = $procedExt;

		$coprop=$this->Sec_model->ver_unidades_de_barrio($barrio);
		if($coprop) $this->data['coprop'] = $coprop;

		$this->_render_page('director/asistencia', $this->data);
	    }

	}


	public function presentismo(){
	    if ( ! $this->ion_auth->logged_in()){
		redirect('auth/login', 'refresh');
	    }else{
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;
		$barrio = $this->Director_model->getBarrio();
		$this->data['barrio'] = $barrio;
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		if($gruposActivi) $this->data['gruposActivi']=$gruposActivi;

		$this->_render_page('director/presentismo', $this->data);
	    }

	}





	function TomarAsistencia(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();
		    $id = $this->input->post('ac_id');
		    $activiActual=$this->Director_model->get_activi($barrio,$id);

		    $alumnosGrupo = $this->Director_model->asistencia_por_grupo($id,2);
		    if($alumnosGrupo) $this->data['alumnosGrupo'] = $alumnosGrupo;
		    else{
			$alumnosGrupo = $this->Director_model->alumnos_por_grupo($activiActual[0]->ga_id);
			if($alumnosGrupo) $this->data['alumnosGrupo'] = $alumnosGrupo;
		    }

		    $this->Director_model->delAlumnosAusentes($id);

		    foreach($alumnosGrupo as $dato){
			$idalu = $dato->al_id;
			$asistio=2;
			if($this->input->post($idalu)) $asistio=1;

			$tabla1='asistxactivi';
			$datos1=array(
			    'aa_idalu'=> $idalu,
			    'aa_idact'=> $id,
			    'aa_asistio'=> $asistio,
			    'aa_iduser'=> $user->id
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}
		    }

		    $eId=$this->Sec_model->ecrypt($id);
//		    $this->session->set_flashdata('message', 'Usted ha cargado la actividad correctamente. Preceda a la brevedad a tomar lista.');
		    redirect('Director/Asistencia/'.$eId, 'refresh');
		}else{
		    $eId=$this->Sec_model->ecrypt($id);
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director/Asistencia/'.$eId, 'refresh');
		}
	    }
	}


	function TomarAsistencia1(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');
		if ($this->form_validation->run() === TRUE){
		    $barrio=$this->Director_model->getBarrio();
		    $id = $this->input->post('ac_id');
		    $eId=$this->Sec_model->ecrypt($id);
		    $activiActual=$this->Director_model->get_activi($barrio,$id);

		    $idgf = $this->input->post('idgf');
		    if(!$idgf){
			$this->session->set_flashdata('message', 'Debe definir al menos un alumno (o propietario o inquilino).');
			redirect('Director/Asistencia/'.$eId, 'refresh');
		    }

		    if($idgf){
			$tabla1='asistxactivi';
			$datos1=array(
			    'aa_idalu'=> $idgf,
			    'aa_idact'=> $id,
			    'aa_asistio'=> 1,
			    'aa_iduser'=> $user->id
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}
		    }
		    redirect('Director/Asistencia/'.$eId, 'refresh');
		}else{
		    $eId=$this->Sec_model->ecrypt($id);
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director/Asistencia/'.$eId, 'refresh');
		}
	    }
	}






	function Foreign(){
	    $user=$this->ion_auth->user()->row();
	    if(!$this->input->post('id') == $user->id){
		$this->session->set_flashdata('message', 'Accion no permitida');
		redirect('Auth', 'refresh');
	    }else{
		$this->form_validation->set_rules('id', 'Usuario', 'required');

		if ($this->form_validation->run() === TRUE){

		    $barrio=$this->Director_model->getBarrio();
		    $id = $this->input->post('ac_id');
		    $activiActual=$this->Director_model->get_activi($barrio,$id);

		    $asistio=1;


		    $nombre = $this->input->post('externo');
		    $proced = $this->input->post('proced');
		    $idext = $this->input->post('idext');

		    if(!$idext){
			if($proced==1) $invitadopor=$this->input->post('invitadopor');
			else $invitadopor=NULL;

			$tabla1='alexternos';
			$datos1=array(
			    'ae_idptov'=> $barrio,
			    'ae_nombre'=> $nombre,
			    'ae_proced'    => $proced,
			    'ae_invitadopor'    => $invitadopor
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}

			$ae_id=$this->db->insert_id('alexternos_ae_id_seq');
			$tabla2='alumnos';
			$datos2=array(
			    'al_idptov' => $barrio,
			    'al_ext' => $ae_id
			);
			if($this->Sec_model->insert($tabla2,$datos2) == FALSE){
			    echo $this->db->last_query();
			    exit;
			}
			$idalu=$this->db->insert_id('alumnos_al_id_seq');
		    }else{
			$idalu=$idext;
		    }



		    $tabla1='asistxactivi';
		    $datos1=array(
			'aa_idalu'=> $idalu,
			'aa_idact'=> $id,
			'aa_asistio'=> $asistio,
			'aa_iduser'=> $user->id
		    );
		    if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
			echo $this->db->last_query();
			exit;
		    }

		    $eId=$this->Sec_model->ecrypt($id);
//		    $this->session->set_flashdata('message', 'Usted ha cargado la actividad correctamente. Preceda a la brevedad a tomar lista.');
		    redirect('Director/Asistencia/'.$eId, 'refresh');
		}else{
		    $eId=$this->Sec_model->ecrypt($id);
		    $this->session->set_flashdata('message', validation_errors());
		    redirect('Director/Asistencia/'.$eId, 'refresh');
		}
	    }
	}


	function delAlumnodeAsist($idActivi, $idAlumno){

	    $barrio=$this->Director_model->getBarrio();
	    $activiActual=$this->Director_model->get_activi($barrio,$idActivi);
	    $pertenece=$this->Director_model->alumnos_por_grupo($activiActual[0]->ac_idgpo,$idAlumno);

	    if($pertenece){
		$data = array(
		    'aa_asistio' => '2',
		);
		$this->db->where('aa_idalu' ,$idAlumno);
		$this->db->where('aa_idact' ,$idActivi);
		$this->db->update('asistxactivi' , $data);
	    }else{
		$this->db->where('aa_idalu' ,$idAlumno);
		$this->db->where('aa_idact' ,$idActivi);
		$this->db->delete('asistxactivi');
	    }

	    $id=$this->Sec_model->ecrypt($idActivi);
	    redirect('Director/Asistencia/'.$id, 'refresh');

	}



/************************************* FIN ABM ACTIVIDADES ****************************************************/




	function Print(){

	    $this->load->helper('directory');
	    $this->load->library('image_lib');
	    $this->load->library('TPDF');
	    $pdf = $this->tpdf->getInstance('L');
	    $pdf->AliasNbPages();
	    $pdf->AddPage();
	    $pdf->SetAutoPageBreak(false);
	    $base="/opt/www/html/lostroncoscc.com.ar/ci/";


	    $grupo = $this->input->post('grupo');
	    $mes = $this->input->post('mes');
	    $anio = $this->input->post('anio');
	    $barrio=$this->Director_model->getBarrio();

	    switch($mes){
		case '01': $nmes="Enero"; break;
		case '02': $nmes="Febrero"; break;
		case '03': $nmes="Marzo"; break;
		case '04': $nmes="Abril"; break;
		case '05': $nmes="Mayo"; break;
		case '06': $nmes="Junio"; break;
		case '07': $nmes="Julio"; break;
		case '08': $nmes="Agosto"; break;
		case '09': $nmes="Septiembre"; break;
		case '10': $nmes="Octubre"; break;
		case '11': $nmes="Noviembre"; break;
		case '12': $nmes="Diciembre"; break;
	    }
	    $nmes=strtoupper($nmes);

	    $grupoActual=$this->Director_model->get_gruposActivi($barrio,$grupo);
	    if($grupoActual){
		$profes="";
		$grupoActual = $grupoActual[0];
		$profesDeGrupo = $this->Director_model->profes_por_grupo($grupoActual->ga_id);
		foreach($profesDeGrupo as $pf){
		    if(!$profes) $profes=utf8_decode($pf->pf_nombre); else $profes.=" / ".utf8_decode($pf->pf_nombre);
		}
		$nomGp=utf8_decode($grupoActual->ga_nombre);
	    }



	    $portada=$base.'assets/img/lt.jpg';
	    if(file_exists($portada)){
		$pdf->Image($portada,5,6,55,25);
	    }
	    $pdf->SetFont('Arial','',8);
	    $pdf->Cell(60);
	    $pdf->Cell(0,4,'Fecha: '.date("d/m/Y G:i").'hs',0,0,'R');
	    $pdf->Ln(3);
	    $pdf->SetFont('Arial','B',14);
	    $pdf->Cell(60);
	    $pdf->Cell(0,7,'Reporte de Asistencia '.$nmes.' '.$anio,0,0);
	    $pdf->Ln(6);
	    $pdf->SetFont('Arial','',10);
	    $pdf->Cell(60);
	    $pdf->Cell(0,5,'Grupo: '.$nomGp,0,0);
	    $pdf->Ln(4);
	    $pdf->Cell(60);
	    $pdf->Cell(0,5,'Profesores: '.$profes,0,0);
	    $pdf->Ln(12);


	    $dias = cal_days_in_month(CAL_GREGORIAN, $mes, $anio);

	    $pdf->Cell(60);
	    for($i=1;$i<=$dias;$i++){
		$fecha="$i-$mes-$anio";
		$fechan=strtotime($fecha);
		$dow=date("w",$fechan);
		$pdf->Cell(6,5,$i,1,0,'C');
	    }
	    $pdf->Cell(20,5,'TOTALES',1,0);

	    $pdf->Ln(5);
	    $pdf->Cell(60);
	    for($i=1;$i<=$dias;$i++){
		$fecha="$i-$mes-$anio";
		$fechan=strtotime($fecha);
		$dow=date("w",$fechan);
		switch($dow){
		    case '0': $dow="D"; break;
		    case '1': $dow="L"; break;
		    case '2': $dow="M"; break;
		    case '3': $dow="M"; break;
		    case '4': $dow="J"; break;
		    case '5': $dow="V"; break;
		    case '6': $dow="S"; break;
		}
		$pdf->Cell(6,5,$dow,1,0,'C');
	    }
	    $pdf->Cell(10,5,'AUS',1,0,'C');
	    $pdf->Cell(10,5,'PRE',1,0,'C');
	    $pdf->Ln(5);


	    $tipo_grupo=$grupoActual->ga_tipo;
	    if($tipo_grupo==1){
		$alumnos=$this->Director_model->alumnos_por_grupo($grupoActual->ga_id);
		foreach($alumnos as $dato){
		    $tp=$ta=0;
		    $alumno = $dato->al_id;
		    $idgfd = $dato->al_idgfd;
		    $idgfi = $dato->al_idgfi;
		    $ext = $dato->al_ext;
		    $pdf->SetFillColor(255,255,255);

		    if($idgfd){
			$nombre=$this->Director_model->dato_alumno('grupof_d','gf_nombre','gf_id',$idgfd)->gf_nombre;
		    }else if($idgfi){
			$nombre=$this->Director_model->dato_alumno('grupof_inq','gf_nombre','gf_id',$idgfi)->gf_nombre;
		    }else if($ext){
			$nombre=$this->Director_model->dato_alumno('alexternos','ae_nombre','ae_id',$ext)->ae_nombre;
			$proced=$this->Director_model->dato_alumno('alexternos','ae_proced','ae_id',$ext)->ae_proced;
			if($proced==1){
			    $invitadopor=$this->Director_model->dato_alumno('alexternos','ae_invitadopor','ae_id',$ext)->ae_invitadopor;
			    if($invitadopor) $uf=$this->Sec_model->get_cop_unifun($invitadopor);
			    if($uf) $nombre.=" ($uf)";
			    $pdf->SetFillColor(240,230,140);
			}else if($proced==2){
			    $nombre.=" (AL)";
			    $pdf->SetFillColor(173,255,47);
			}else if($proced==3){
			    $nombre.=" (OB)";
			    $pdf->SetFillColor(135,206,235);
			}
		    }
		    $nombre=utf8_decode($nombre);

		    $pdf->CellFitScale(60,5,$nombre,1,0,'L',true);

		    $pdf->SetFillColor(255,255,255);

		    for($i=1;$i<=$dias;$i++){
			$fecha="$i-$mes-$anio";

			$ac_id=$this->Director_model->hayActivi($grupoActual->ga_id,$fecha);
			if($ac_id==-1){
			    $pdf->SetFillColor(215,215,215);
			    $pdf->Cell(6,5,'',1,0,'C',true);
			}else{
			    $asistio=$this->Director_model->asistencia_por_alumno($ac_id[0]->ac_id,$alumno);
			    if($asistio==1){
				$pdf->SetFillColor(255,255,255);
				$pdf->Cell(6,5,'P',1,0,'C',true);
				$tp++;
			    }else{
				$pdf->SetFillColor(255,0,0);
				$pdf->Cell(6,5,'A',1,0,'C',true);
				$ta++;
			    }
			}

		    }


		    $pdf->Cell(10,5,$ta,1,0,'C');
		    $pdf->Cell(10,5,$tp,1,0,'C');
		    $pdf->Ln(5);
		}
	    }else{
		$pdf->Cell(0,7,'Planilla para grupo abierto no disponible.',0,0);
		$pdf->Ln(6);
	    }

	    $pdf->Output('D','Planilla.pdf'); 

	}






	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}