<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Denuncias extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Reclamos_model','Sec_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter'), $this->config->item('error_end_delimiter'));
		$this->lang->load('auth');
	}

	// redirect if needed, otherwise display the user list
	public function index(){
		$this->data['barrio']=$this->Sec_model->getBarrio();
        	$this->_render_page('body/denuncias', $this->data);
	}


	function categ_incid(){
	    $options = "";
            $unidades = $this->Reclamos_model->categorias_reclamo();
            if($unidades == FALSE){
				echo "<option>--</option>";
            }else{
            	foreach($unidades as $unidad){?>
		    <option value="<?php echo $unidad->cat_codigo;?>"><?php echo $unidad->cat_nombre;?></option>
		<?php }
            }			
	}





	function prior_incid(){
		$options = "";
            $unidades = $this->Reclamos_model->prioridades_reclamo();
            if($unidades == FALSE){
		echo "<option>--</option>";
            }else{
            	foreach($unidades as $unidad){?>
			<option value="<?php echo $unidad->pri_codigo;?>"><?php echo $unidad->pri_nombre;?></option>
		<?php }
            }			
	}





	function Reclamo(){
		
	    $this->form_validation->set_rules('categoria', 'Categoria', 'required');
	    $this->form_validation->set_rules('prioridad', 'Prioridad', 'required');
	    $this->form_validation->set_rules('asunto', 'Asunto', 'required');
	    $this->form_validation->set_rules('descripcion', 'Descripcion', 'required');

    	    $config['upload_path']          = './uploads/reclamos/';
            $config['allowed_types']        = 'jpg|jpeg|gif|png';
            $config['max_size']             = 10240;
            $this->load->library('upload', $config);
            $this->load->library('image_lib');
	    $inf_file="";

	    $file="";
	    if ($this->form_validation->run() === TRUE){
			if(isset($_FILES)){
			    if ($this->upload->do_upload('file_reclamo')) {
				$upload_data = $this->upload->data();
				$data_ary = array(
				    'title'     => $upload_data['client_name'],
				    'file'      => $upload_data['file_name'],
				    'width'     => $upload_data['image_width'],
				    'height'    => $upload_data['image_height'],
				    'type'      => $upload_data['image_type'],
				    'size'      => $upload_data['file_size'],
				    'path'      => $upload_data['full_path'],
				    'date'      => time(),
				);
				$configer =  array(
            			    'image_library'   => 'gd2',
            			    'source_image'    =>  $upload_data['full_path'],
            			    'maintain_ratio'  =>  TRUE,
            			    'width'           =>  600,
            			    'height'          =>  480,
            			);
            			$this->image_lib->clear();
            			$this->image_lib->initialize($configer);
            			$this->image_lib->resize();
				$data = array('upload_data' => $upload_data);
				$file=$data_ary['path'];
			    }else{
				if($_FILES['file_reclamo']['error'] != 4){
				    $error = array('error' => $this->upload->display_errors());
				    $new_data=array(
					'pestania_activa'=>'reclamo',
					'message'=>$error
				    );
				    $this->session->set_flashdata($new_data);
				    redirect('reclamos', $this->data);
				}
			    }
			}
			$barrio=$this->Sec_model->getBarrio();
			$categoria = $this->input->post('categoria');
			$prioridad = $this->input->post('prioridad');
			$asunto = $this->input->post('asunto');
			$descripcion = $this->input->post('descripcion');

			$descripcion=str_replace("“","\"",$descripcion);
			$descripcion=str_replace("”","\"",$descripcion);
			$descripcion=str_replace("‘","\'",$descripcion);
			$descripcion=str_replace("’","\'",$descripcion);
			$descripcion=utf8_encode($descripcion);


			$asunto=str_replace("“","\"",$asunto);
			$asunto=str_replace("”","\"",$asunto);
			$asunto=str_replace("‘","\'",$asunto);
			$asunto=str_replace("’","\'",$asunto);
			$asunto=utf8_encode($asunto);


			$anio=date("Y");
			$in_codemp=$this->Sec_model->get_codemp($barrio);
			$codigo=$this->Reclamos_model->get_codigo_incidencia($anio);

			$destinatario = $this->Reclamos_model->destinRecl();
			$destinatario = $destinatario[0]->vari_valor;

			if(!empty($_SERVER['HTTP_CLIENT_IP'])){
			    $ipp = $_SERVER['HTTP_CLIENT_IP']; 
			}elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
			    $ipp = $_SERVER['HTTP_X_FORWARDED_FOR']; 
			}else{
			    $ipp = $_SERVER['REMOTE_ADDR']; 
			}

			$tabla1='incidencias';
			$datos1=array(
				'in_codemp'=> $in_codemp,
				'in_idptov'=> $barrio,
				'in_idcopr' => 4805,
				'in_mail'    => 'consejo@lostroncoscc.com.ar',
				'in_asunto'    => $asunto,
				'in_estado'    => 1,
				'in_visibilidad'    => 1,
				'in_categoria'    => $categoria,
				'in_anio'    => $anio,
				'in_ip'    => $ipp,
				'in_codigo'    => $codigo,
			);
			if($this->Sec_model->insert($tabla1,$datos1) == FALSE){
				echo $this->db->last_query();
				exit;
			}else{
			    $in_id=$this->db->insert_id('incidencias_in_id_seq');
			    $tabla2='operincid';
			    $datos2=array(
				'oi_idinc'=> $in_id,
				'oi_operal'=> $destinatario,
				'oi_operasign' => $destinatario,
				'oi_prioridad'    => $prioridad,
				'oi_observ'    => $descripcion,
				'oi_userweb'    => -1,
				'oi_estado'    => 1,
			    );
			    if($this->Sec_model->insert($tabla2,$datos2) == FALSE){
				echo $this->db->last_query();
				exit;
			    }
			    if($file){
				$tabla3='imgincid';
				$datos3=array(
				    'img_idinc'=> $in_id,
				    'img_file'    => $file,
				);
				if($this->Sec_model->insert($tabla3,$datos3) == FALSE){
				    echo $this->db->last_query();
				    exit;
				}
			    }
			}
			$this->session->set_flashdata('message', 'Usted ha cargado el reclamo n&uacute;mero '.$codigo.'/'.$anio.'. Recuerde que al ser un reclamo anonimo, no obtendra respuesta sobre su denuncia.');

			$barrio_n=$this->Sec_model->ver_barrios($barrio)->ptv_nombre;
			$asunto="Denuncia Anonima - $asunto";
			$descripcion=utf8_decode($descripcion);
			$mensaje = "Un usuario anonimo denuncia: <BR /> $descripcion";
			$to_mail=array("consejo@lostroncoscc.com.ar","intendencia@lostroncoscc.com.ar","ado.lostroncos@gmail.com","administracion@lostroncoscc.com.ar");
			if($file) $this->sendmail_adj($to_mail,$asunto,$mensaje,$file);
			else $this->sendmail($to_mail,$asunto,$mensaje);
			redirect('Denuncias', 'refresh');
	    }else{
			$this->session->set_flashdata('message', validation_errors());
			redirect('Denuncias', $this->data);
	    }
	}



	function sendmail($usermail,$subject,$sms){
	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'No Responder');
	    $this->email->to($usermail);
//	    $this->email->bcc('fl.catware@gmail.com'); 
	    $this->email->subject($subject);
	    $this->email->message($sms);
	    if ($this->email->send())
		$ok=1;
//		$this->session->set_flashdata('message', 'Se ha enviado el e-mail.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }
	}


	function sendmail_reply($usermail,$subject,$sms,$replyto,$nombre){

	    $reply=explode(" ; ",$replyto);

	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'Los Troncos CC.');
	    $this->email->reply_to($reply[0], $nombre);
	    $this->email->to($usermail);
//	    $this->email->bcc('fl.catware@gmail.com'); 
	    $subject=utf8_decode($subject);
	    $this->email->subject($subject);
	    $sms=utf8_decode($sms);
	    $this->email->message($sms);
	    if ($this->email->send())
		$this->session->set_flashdata('message', 'Se ha contactado correctamente.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }

	}




	function sendmail_adj($usermail,$subject,$sms,$file){
	    $this->load->library('email'); // load email library
	    $this->email->from('noreply@lostroncoscc.com.ar', 'No Responder');
	    $this->email->to($usermail);
//	    $this->email->bcc('fl.catware@gmail.com'); 
	    $this->email->subject($subject);
	    $this->email->message($sms);
	    $this->email->attach($file);
	    if ($this->email->send())
		$ok=1;
//		$this->session->set_flashdata('message', 'Se ha enviado el e-mail.');
	    else{
		$this->session->set_flashdata('message', 'No se ha enviado el e-mail.');
	    }
	}








	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}



}