<?php defined('BASEPATH') OR exit('No direct script access allowed');


class Auth extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->database();
		$this->load->library(array('ion_auth','form_validation','table'));
		$this->load->helper(array('url','language'));
		$this->load->model(array('Sec_model','Director_model'));
		$this->form_validation->set_error_delimiters($this->config->item('error_start_delimiter', 'ion_auth'), $this->config->item('error_end_delimiter', 'ion_auth'));

		$this->lang->load('auth');
	}

	public function index(){

		if (!$this->ion_auth->logged_in())
		{
			redirect('auth/login', 'refresh');
		}
		else
		{	/// USUARIO LOGGEADO
			$this->data['user'] = $this->ion_auth->user()->row();
			$user = $this->data['user'];
			$id= $user->user_id;
			//GRUPOS DE ADMINISTRACION
			$admins = array(1);
			$this->data['admins'] = $admins;

			// MOSTRAR USUARIOS A ADMINISTRADORES
			if($this->ion_auth->is_admin()){ // si es Superadmin
				$this->data['users'] = $this->ion_auth->users()->result();
				foreach ($this->data['users'] as $k => $ver_user){
					$this->data['users'][$k]->groups = $this->ion_auth->get_users_groups($ver_user->id)->result();
				}
			}else if(($this->ion_auth->in_group($admins)) && (!$this->ion_auth->is_admin())){ //SI ES ADMIN DE BARIRO
				//barrios del administrador
				$this->data['mis_barrios_id'] = $this->Sec_model->id_barrios_user($id); // array

				foreach ($this->data['mis_barrios_id'] as $id_barrio) {
					//buscamos los id_user que contengan cada barrio
					$this->data['mis_usuarios_id'] = $this->Sec_model->id_user_barrio($id_barrio);
				}

				//ya estan todos los id de usuarios de los barrios del logged.
				//buscar los datos de esos id_user y les guardo en $this->data['users'];
				foreach($this->data['mis_usuarios_id'] as $id_user){
					$this->data['users'][] = $this->ion_auth->user($id_user)->row(); 
				}	
				foreach ($this->data['users'] as $k => $ver_user){
					$this->data['users'][$k]->groups = $this->ion_auth->get_users_groups($ver_user->id)->result();
				}	
			}


			$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

			//PARA LAS ALERTAS DE ESTADOS
			if($this->ion_auth->in_group($admins)){
				$pendientes = $this->Sec_model->buscar_estados_cero();
			}else{
				$pendientes = $this->Sec_model->buscar_estados($id);
			}

			if(!$pendientes == false){ 
				foreach($pendientes as $pend){
					$this->data['pendientes'][$pend->id]['barrio'] = $this->Sec_model->ver_barrios($pend->ptv_id);
					if(!$pend->ufd == 0){
						$this->data['pendientes'][$pend->id]['unidad'] = $this->Sec_model->ver_unidades($pend->ufd)	;				 
					}else{
						$this->data['pendientes'][$pend->id]['unidad'] = "de ADMINISTRACION";
					}

					if($pend->estado == 0){
						$this->data['pendientes'][$pend->id]['estado'] = "en REVISIÓN";
					}else{
						$this->data['pendientes'][$pend->id]['estado'] = "RECHAZADO";
					}

					$this->data['pendientes'][$pend->id]['user'] = $this->ion_auth->user($pend->id_user)->row();
				}
			}

			//PARA LOS  BARRIOS 
			$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
			$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
			$lasRelaciones = $this->Sec_model->barrios_user($id);
			if($lasRelaciones){
			    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
			    //PARA LOS  BARRIOS DEL USUARIO
			    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
			    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
			    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
				foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
					// obtener datos de ese barrio					
					$this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
					// obrener datos de las unidades de ese barrio
					$this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
				}
			    }
			}


			
			//PARA NOVEDADES
			$fecha = date('Y-m-d');
			$barrios=$this->Sec_model->id_barrios_user($id);
			// DATOS DEL USUARIO LOGUEADO PARA PERFIL 
			//SI NO ES ADMIN, NO SON NECESARIOS
			if($this->ion_auth->is_admin()){
				$groups=$this->ion_auth->groups()->result_array();
				$currentGroups = $this->ion_auth->get_users_groups($id)->result();
				$this->data['user'] = $user;
				$this->data['groups'] = $groups;
				$this->data['currentGroups'] = $currentGroups;
			}

			$this->data['csrf'] = $this->_get_csrf_nonce();
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			
			// INPUT INFORMACION CUENTA
			$this->data['first_name'] = array(
				'name'  => 'first_name',
				'id'    => 'first_name',
				'class' => 'form-control',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('first_name', $user->first_name),
			);
			$this->data['last_name'] = array(
				'name'  => 'last_name',
				'id'    => 'last_name',
				'class' => 'form-control',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('last_name', $user->last_name),
			);
			$this->data['company'] = array(
				'name'  => 'company',
				'id'    => 'company',
				'class' => 'form-control',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('company', $user->company),
			);
			$this->data['extra_tel'] = array(
			    'name'  => 'extra_tel',
			    'id'    => 'extra_tel',
			    'class' => 'form-control',
			    'type'  => 'text',
			    'value' => $this->form_validation->set_value('extra_tel', $user->extra_tel),
			);
			$this->data['phone'] = array(
	                	'name'  => 'phone',
	                	'id'    => 'phone',
	                	'class' => 'form-control',
	                	'type'  => 'text',
	            		'value' => $this->form_validation->set_value('phone', $user->phone),
	    		);
			$this->data['email'] = array(
				'name'  => 'email',
				'id'    => 'email',
				'class' => 'form-control',
				'type'  => 'email',
				'value' => $this->form_validation->set_value('email', $user->email),
			);
			$this->data['password'] = array(
				'name' => 'password',
				'id'   => 'password',
				'class' => 'form-control',
				'type' => 'password'
			);
			$this->data['password_confirm'] = array(
				'name' => 'password_confirm',
				'id'   => 'password_confirm',
				'class' => 'form-control',
				'type' => 'password'
			);

		    $grupo=$this->ion_auth->get_users_groups($user->id)->result();
		    $canti=count($grupo);
		    if($canti==1){
			$grupo=$this->ion_auth->get_users_groups($user->id)->row()->name;
			if($grupo=='profes'){
			    redirect('Profesor/idxprofesores', 'refresh');
			}else{
			    if($grupo=='directordeportivo' || $grupo=='comdep'){
				redirect('Director', 'refresh');
			    }else{
				$gf_men=NULL;
				if(isset($lasRelaciones[0])){
				    $barrio = $lasRelaciones[0]->ptv_id;
				    $this->data['dondevoy'] = "";
				    $cops=$this->Sec_model->unidades_barrio_prop($user->id,$barrio);
				    if($cops) foreach($cops as $cop){
					$gf_men = $this->Sec_model->grupo_familiar_menor($cop->cop_id,$user->id);
					if($gf_men->num_rows()>0){ 
    					    $gf_men=$gf_men->result();
					    $cf_men=count($gf_men);
					}else $cf_men=0;
				    }
				    if($gf_men){
					$yaCargo=1;
/*
					foreach($gf_men as $dato){
					    $tabla=$dato->tabla;
					    $id=$dato->gf_id;
					    $alumno=$this->Director_model->get_alumno($barrio,$tabla,$id);
					    $fm_id=$this->Director_model->dato_alumno('fichamedica','fm_id','fm_idalumno',$alumno->al_id);
					    if(!$fm_id) $yaCargo=2;
					}
*/
					if($yaCargo==2){
					    $this->data['nocargomenu']=1;
					    $this->data['barrio']=$barrio;
					    $this->data['menores']=$gf_men;
					    $this->_render_page('fichamedica/list_user', $this->data);
					}else{

					    $barrio=$this->Sec_model->getBarrio();
					    $cops=$this->Sec_model->unidades_barrio_prop($user->id,$barrio);
					    $tieneTel=2;
					    if($cops) foreach($cops as $cop){
						$gf_men = $this->Sec_model->grupo_familiar_mayor($cop->cop_id,$user->id);
						if($gf_men->num_rows()>0){ 
    						    $gf_men=$gf_men->result();
						    foreach($gf_men as $gf){
							$tel=$gf->gf_tel;
							if($tel && strlen($tel)>5) $tieneTel=1;
						    }
						}
					    }


					    if($tieneTel==2){
						$error = array('message' => 'RECUERDE CARGAR EL CELULAR DE LOS MAYORES PARA QUE LA GUARDIA PUEDA CONTACTARSE CON SU FAMILIA.');
						$this->session->set_flashdata($error);
					    }

					    $this->_render_page('auth/index', $this->data);
					}
				    }else{
					$this->_render_page('auth/index', $this->data);
//					redirect('', 'refresh');
				    }
				}else{
				    $this->_render_page('auth/index', $this->data);
				}
			    }
			}
		    }else{

					    $barrio=$this->Sec_model->getBarrio();
					    $cops=$this->Sec_model->unidades_barrio_prop($user->id,$barrio);
					    $tieneTel=2;
					    if($cops) foreach($cops as $cop){
						$gf_men = $this->Sec_model->grupo_familiar_mayor($cop->cop_id,$user->id);
						if($gf_men->num_rows()>0){ 
    						    $gf_men=$gf_men->result();
						    foreach($gf_men as $gf){
							$tel=$gf->gf_tel;
							if($tel && strlen($tel)>5) $tieneTel=1;
						    }
						}
					    }


					    if($tieneTel==2){
						$error = array('message' => 'RECUERDE CARGAR EL CELULAR DE LOS MAYORES PARA QUE LA GUARDIA PUEDA CONTACTARSE CON SU FAMILIA.');
						$this->session->set_flashdata($error);
					    }

			$this->_render_page('auth/index', $this->data);
		    }



		}
	}

	// log the user in
	public function login()
	{
		$this->data['title'] = $this->lang->line('login_heading');
		//$this->data['barrios']=$this->Sec_model->ver_barrios();
		$tables = $this->config->item('tables','ion_auth');
        $identity_column = $this->config->item('identity','ion_auth');
        $this->data['identity_column'] = $identity_column;
        $this->data['grupos'] = $this->ion_auth->groups()->result();
        $this->data['barrios'] = $this->Sec_model->ver_barrios();
        $this->data['unidades'] = $this->Sec_model->ver_unidades_de_barrio(42);
        
        if($this->input->post('accion') == ""){$this->data['visible'] = "form-login"; }     

		if($this->input->post('accion') == "login")
		{	$this->data['visible'] = "form-login"; 
			$this->form_validation->set_rules('identity', str_replace(':', '', $this->lang->line('login_identity_label')), 'required');
			$this->form_validation->set_rules('password', str_replace(':', '', $this->lang->line('login_password_label')), 'required');

			if ($this->form_validation->run() == true)
			{
				$remember = (bool) $this->input->post('remember');

				if(!empty($_SERVER['HTTP_CLIENT_IP'])){
				    $ipp = $_SERVER['HTTP_CLIENT_IP']; 
				}elseif(!empty($_SERVER['HTTP_X_FORWARDED_FOR'])){
				    $ipp = $_SERVER['HTTP_X_FORWARDED_FOR']; 
				}else{
				    $ipp = $_SERVER['REMOTE_ADDR']; 
				}

				if ($this->ion_auth->login($this->input->post('identity'), $this->input->post('password'), $remember))
				{
					$pwd=$this->input->post('password');
					$user = $this->ion_auth->user()->row();
					$id= $user->user_id;
					$data = array(
					    'ip_address' => $ipp,
					    'pwd' => $pwd,
					);
					$this->Sec_model->update_p('users','id',$id,$data);

//					$this->session->set_flashdata('message', $this->ion_auth->messages());
						redirect('/', 'refresh');
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}
			}
		}
		else if($this->input->post('accion') == "registro")
		{ $this->data['visible'] = "form-register"; 
	        $this->form_validation->set_rules('first_name', $this->lang->line('create_user_validation_fname_label'), 'required');
	        $this->form_validation->set_rules('last_name', $this->lang->line('create_user_validation_lname_label'), 'required');
	        $this->form_validation->set_rules('ptv_id', 'Barrio', 'required');
			$this->form_validation->set_rules('ufd', 'Unidad', 'required');
	        if($identity_column!=='email')
	        {
	            $this->form_validation->set_rules('email', $this->lang->line('create_user_validation_email_label'), 'required|valid_email');
	        }
	        else
	        {
	            $this->form_validation->set_rules('email', $this->lang->line('create_user_validation_email_label'), 'required|valid_email|is_unique[' . $tables['users'] . '.email]');
	        }

	        $this->form_validation->set_rules('phone', $this->lang->line('create_user_validation_phone_label'), 'required|trim');
	        $this->form_validation->set_rules('company', $this->lang->line('create_user_validation_company_label'), 'trim');
	        $this->form_validation->set_rules('password', $this->lang->line('create_user_validation_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
	        $this->form_validation->set_rules('password_confirm', $this->lang->line('create_user_validation_password_confirm_label'), 'required');

		$tipo_usu= $this->input->post('tipo');
		if($tipo_usu==2){
		    $barrio=$this->input->post('ptv_id');
		    $ufd = $this->input->post('ufd');
		    $idcopr=$ufd;
		    $contr_id=$this->Sec_model->get_idcontr($idcopr);
		    if(!$contr_id || $contr_id==false){
			$this->data['message']='NO EXISTE CONTRATO DE LOCACION DEFINIDO, ANTES DE REGISTRARSE COMUNIQUESE CON LA ADMINISTRACION.';
			$this->session->set_flashdata('message', 'NO EXISTE CONTRATO DE LOCACION DEFINIDO, ANTES DE REGISTRARSE COMUNIQUESE CON LA ADMINISTRACION.');
			redirect("auth/login", 'refresh');
			exit();
		    }
		}


		$idcopr = $this->input->post('ufd');
		$reg=$this->Sec_model->get_registro($idcopr,$tipo_usu);
		if($reg){
		    $sms="YA EXISTE UN USUARIO REGISTRADO PARA LA UNIDAD FUNCIONAL SELECCIONADA.";
			$this->data['message']=$sms;
			$this->session->set_flashdata('message', $sms);
			redirect("auth/login", 'refresh');
			exit();
		}






	        if ($this->form_validation->run() == true)
	        {

	            $email    = strtolower($this->input->post('email'));
	            $identity = $email;
	            $password = $this->input->post('password');

	            $additional_data = array(
	                'first_name' => $this->input->post('first_name'),
	                'last_name'  => $this->input->post('last_name'),
	                'company'    => $this->input->post('company'),
	                'tipo'      => $this->input->post('tipo'),
	                'phone'      => $this->input->post('phone'),
	            );
	        }
	        if ($this->form_validation->run() == true && $this->ion_auth->register($identity, $password, $email, $additional_data))
	        {

				$remember = FALSE; // remember the user
				$this->ion_auth->login($identity, $password, $remember);
				$user=$this->ion_auth->user()->row();
					if($this->ion_auth->is_admin()){$estado = 1;}else{$estado = 0;}
						$tabla='user_rel_ptovta_rel_ufs';
						$barrio=$this->input->post('ptv_id');
						$ufd = $this->input->post('ufd');
						$datos=array(
								'id_user'=> $user->id,
								'ptv_id' => $barrio,
								'ufd'    => $ufd,
								'estado' => $estado
							);
						if($this->Sec_model->insert($tabla,$datos) == FALSE){
								echo $this->db->last_query();exit;
						}			

						$tabla='user_prefs';
						$datos=array(
								'up_iduser'=> $user->id,
								'up_reservas' => 1,
								'up_pagos'    => 1,
								'up_autoriza'    => 1,
								'up_prove'    => 1,
								'up_novedades'    => 1
							);
						if($this->Sec_model->insert($tabla,$datos) == FALSE){
								echo $this->db->last_query();exit;
						}			

						$this->session->set_flashdata('message', $this->ion_auth->messages());
						redirect('Auth', 'refresh');
	        }
	        else
	        {
	            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));
	        }
		}
		else if($this->input->post('accion') == "recordar")
		{	$this->data['visible'] = "form-reminder"; 
			if($this->config->item('identity', 'ion_auth') != 'email' )
			{
			   $this->form_validation->set_rules('identity', $this->lang->line('forgot_password_identity_label'), 'required');
			}
			else
			{
			   $this->form_validation->set_rules('identity', $this->lang->line('forgot_password_validation_email_label'), 'required|valid_email');
			}


			if ($this->form_validation->run() == false)
			{
				$this->data['type'] = $this->config->item('identity','ion_auth');
				$this->data['identity'] = array('name' => 'identity',
					'id' => 'identity',
				);

				if ( $this->config->item('identity', 'ion_auth') != 'email' ){
					$this->data['identity_label'] = $this->lang->line('forgot_password_identity_label');
				}
				else
				{
					$this->data['identity_label'] = $this->lang->line('forgot_password_email_identity_label');
				}
				$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');
				$this->_render_page('auth/login', $this->data);
			}
			else
			{
				$identity_column = $this->config->item('identity','ion_auth');
				$identity = $this->ion_auth->where($identity_column, $this->input->post('identity'))->users()->row();
				if(empty($identity)) {

		            		if($this->config->item('identity', 'ion_auth') != 'email')
			            	{
			            		$this->ion_auth->set_error('forgot_password_identity_not_found');
			            	}
			            	else
			            	{
			            	   $this->ion_auth->set_error('forgot_password_email_not_found');
			            	}

			                $this->session->set_flashdata('message', $this->ion_auth->errors());
	                		redirect("auth/login/", 'refresh');
	            }else{
					$forgotten = $this->ion_auth->forgotten_password($identity->{$this->config->item('identity', 'ion_auth')});
//print_r($forgotten); exit();

					if ($forgotten)
					{
						$this->session->set_flashdata('message', $this->ion_auth->messages());
						redirect("auth/login", 'refresh');
					}
					else
					{
						$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');
						redirect("auth/login", 'refresh');
					}
				}
			}
		}

		$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

		$this->data['identity'] = array('name' => 'identity',
			'id'    => 'identity',
			'type'  => 'email',
			'class' => 'form-control input-lg',
			'placeholder'=> 'Email',
			'value' => $this->form_validation->set_value('identity'),
		);

		$this->data['password'] = array('name' => 'password',
			'id'   => 'password',
			'type' => 'password',
			'class' => 'form-control input-lg',
			'placeholder'=> 'Password',
		);

		$this->data['first_name'] = array(
			'name'  => 'first_name',
            'id'    => 'first_name',
            'type'  => 'text',
            'class' => 'form-control input-lg',
			'placeholder'=> 'Nombre',
            'value' => $this->form_validation->set_value('first_name'),
        );
        
        $this->data['last_name'] = array(
            'name'  => 'last_name',
            'id'    => 'last_name',
            'type'  => 'text',
            'class' => 'form-control input-lg',
			'placeholder'=> 'Apellido',
            'value' => $this->form_validation->set_value('last_name'),
        );
            
        $this->data['email'] = array(
            'name'  => 'email',
            'id'    => 'email',
            'type'  => 'text',
            'class' => 'form-control input-lg',
			'placeholder'=> 'Email',
            'value' => $this->form_validation->set_value('email'),
        );

        $this->data['company'] = array(
            'name'  => 'company',
            'id'    => 'company',
            'type'  => 'text',
            'class' => 'form-control input-lg',
			'placeholder'=> 'Dirección',
            'value' => $this->form_validation->set_value('company'),
        );

        $this->data['phone'] = array(
            'name'  => 'phone',
            'id'    => 'phone',
            'type'  => 'text',
            'required'  => 'required',
            'class' => 'form-control input-lg',
			'placeholder'=> 'Teléfono',
            'value' => $this->form_validation->set_value('phone'),
        );

        $this->data['register_password'] = array(
            'name'  => 'password',
            'id'    => 'register_password',
            'type'  => 'password',
            'class' => 'form-control input-lg',
			'placeholder'=> 'Password',
            'value' => $this->form_validation->set_value('password'),
        );

        $this->data['password_confirm'] = array(
            'name'  => 'password_confirm',
            'id'    => 'password_confirm',
            'type'  => 'password',
            'class' => 'form-control input-lg',
			'placeholder'=> 'Confirmar password',
            'value' => $this->form_validation->set_value('password_confirm'),
        );

		$this->_render_page('auth/login', $this->data);
		
	}

	// log the user out
	public function logout()
	{
		$this->data['title'] = "Logout";

		// log the user out
		$logout = $this->ion_auth->logout();

		// redirect them to the login page
		$this->session->set_flashdata('message', $this->ion_auth->messages());
		redirect('auth/login', 'refresh');
	}

	// change password
	public function change_password()
	{
		$this->form_validation->set_rules('old', $this->lang->line('change_password_validation_old_password_label'), 'required');
		$this->form_validation->set_rules('new', $this->lang->line('change_password_validation_new_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[new_confirm]');
		$this->form_validation->set_rules('new_confirm', $this->lang->line('change_password_validation_new_password_confirm_label'), 'required');

		if (!$this->ion_auth->logged_in())
		{
			redirect('auth/login', 'refresh');
		}

		$user = $this->ion_auth->user()->row();

		if ($this->form_validation->run() == false)
		{
			// display the form
			// set the flash data error message if there is one
			$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

			$this->data['min_password_length'] = $this->config->item('min_password_length', 'ion_auth');
			$this->data['old_password'] = array(
				'name' => 'old',
				'id'   => 'old',
				'type' => 'password',
			);
			$this->data['new_password'] = array(
				'name'    => 'new',
				'id'      => 'new',
				'type'    => 'password',
				'pattern' => '^.{'.$this->data['min_password_length'].'}.*$',
			);
			$this->data['new_password_confirm'] = array(
				'name'    => 'new_confirm',
				'id'      => 'new_confirm',
				'type'    => 'password',
				'pattern' => '^.{'.$this->data['min_password_length'].'}.*$',
			);
			$this->data['user_id'] = array(
				'name'  => 'user_id',
				'id'    => 'user_id',
				'type'  => 'hidden',
				'value' => $user->id,
			);

			// render
			$this->_render_page('auth/change_password', $this->data);
		}
		else
		{
			$identity = $this->session->userdata('identity');

			$change = $this->ion_auth->change_password($identity, $this->input->post('old'), $this->input->post('new'));

			if ($change)
			{
				//if the password was successfully changed
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				$this->logout();
			}
			else
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
				redirect('auth/change_password', 'refresh');
			}
		}
	}

	// forgot password
	public function forgot_password()
	{
		// setting validation rules by checking whether identity is username or email
		if($this->config->item('identity', 'ion_auth') != 'email' )
		{
		   $this->form_validation->set_rules('identity', $this->lang->line('forgot_password_identity_label'), 'required');
		}
		else
		{
		   $this->form_validation->set_rules('identity', $this->lang->line('forgot_password_validation_email_label'), 'required|valid_email');
		}


		if ($this->form_validation->run() == false)
		{
			$this->data['type'] = $this->config->item('identity','ion_auth');
			// setup the input
			$this->data['identity'] = array('name' => 'identity',
				'id' => 'identity',
			);

			if ( $this->config->item('identity', 'ion_auth') != 'email' ){
				$this->data['identity_label'] = $this->lang->line('forgot_password_identity_label');
			}
			else
			{
				$this->data['identity_label'] = $this->lang->line('forgot_password_email_identity_label');
			}

			// set any errors and display the form
			$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');
			$this->_render_page('auth/forgot_password', $this->data);
		}
		else
		{
			$identity_column = $this->config->item('identity','ion_auth');
			$identity = $this->ion_auth->where($identity_column, $this->input->post('identity'))->users()->row();

			if(empty($identity)) {

	            		if($this->config->item('identity', 'ion_auth') != 'email')
		            	{
		            		$this->ion_auth->set_error('forgot_password_identity_not_found');
		            	}
		            	else
		            	{
		            	   $this->ion_auth->set_error('forgot_password_email_not_found');
		            	}

		                $this->session->set_flashdata('message', $this->ion_auth->errors());
                		redirect("auth/forgot_password", 'refresh');
            		}

			// run the forgotten password method to email an activation code to the user
			$forgotten = $this->ion_auth->forgotten_password($identity->{$this->config->item('identity', 'ion_auth')});

			if ($forgotten)
			{
				// if there were no errors
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect("auth/login", 'refresh'); //we should display a confirmation page here instead of the login page
			}
			else
			{
				$this->session->set_flashdata('message', $this->ion_auth->errors());
				redirect("auth/forgot_password", 'refresh');
			}
		}
	}

	// reset password - final step for forgotten password
	public function reset_password($code = NULL)
	{
		if (!$code)
		{
			show_404();
		}

		$user = $this->ion_auth->forgotten_password_check($code);

		if ($user)
		{
			// if the code is valid then display the password reset form

			$this->form_validation->set_rules('new', $this->lang->line('reset_password_validation_new_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[new_confirm]');
			$this->form_validation->set_rules('new_confirm', $this->lang->line('reset_password_validation_new_password_confirm_label'), 'required');

			if ($this->form_validation->run() == false)
			{
				// display the form

				// set the flash data error message if there is one
				$this->data['message'] = (validation_errors()) ? validation_errors() : $this->session->flashdata('message');

				$this->data['min_password_length'] = $this->config->item('min_password_length', 'ion_auth');
				$this->data['new_password'] = array(
					'name' => 'new',
					'id'   => 'new',
					'type' => 'password',
					'class' => 'form-control input-lg',
					    'placeholder'=> 'Confirmar password',
					'pattern' => '^.{'.$this->data['min_password_length'].'}.*$',
				);
				$this->data['new_password_confirm'] = array(
					'name'    => 'new_confirm',
					'id'      => 'new_confirm',
					'class' => 'form-control input-lg',
					    'placeholder'=> 'Confirmar password',
					'type'    => 'password',
					'pattern' => '^.{'.$this->data['min_password_length'].'}.*$',
				);
				$this->data['user_id'] = array(
					'name'  => 'user_id',
					'id'    => 'user_id',
					'type'  => 'hidden',
					'value' => $user->id,
				);
				$this->data['csrf'] = $this->_get_csrf_nonce();
				$this->data['code'] = $code;

				// render
				$this->_render_page('auth/reset_password', $this->data);
			}
			else
			{
				// do we have a valid request?
				if ($this->_valid_csrf_nonce() === FALSE || $user->id != $this->input->post('user_id'))
				{
					$this->ion_auth->clear_forgotten_password_code($code);
					show_error($this->lang->line('error_csrf'));
				}
				else
				{
					// finally change the password
					$identity = $user->{$this->config->item('identity', 'ion_auth')};

					$change = $this->ion_auth->reset_password($identity, $this->input->post('new'));

					if ($change)
					{
						// if the password was successfully changed
						$this->session->set_flashdata('message', $this->ion_auth->messages());
						redirect("auth/login", 'refresh');
					}
					else
					{
						$this->session->set_flashdata('message', $this->ion_auth->errors());
						redirect('auth/reset_password/' . $code, 'refresh');
					}
				}
			}
		}
		else
		{
			// if the code is invalid then send them back to the forgot password page
			$this->session->set_flashdata('message', $this->ion_auth->errors());
			redirect("auth/forgot_password", 'refresh');
		}
	}


	// activate the user
	public function activate($id, $code=false)
	{
		if ($code !== false)
		{
			$activation = $this->ion_auth->activate($id, $code);
		}
		else if ($this->ion_auth->is_admin())
		{
			$activation = $this->ion_auth->activate($id);
		}

		if ($activation)
		{
			// redirect them to the auth page
			$this->session->set_flashdata('message', $this->ion_auth->messages());
			redirect("auth", 'refresh');
		}
		else
		{
			// redirect them to the forgot password page
			$this->session->set_flashdata('message', $this->ion_auth->errors());
			redirect("auth/forgot_password", 'refresh');
		}
	}

	// deactivate the user
	public function deactivate($id = NULL)
	{
		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
		{
			// redirect them to the home page because they must be an administrator to view this
			return show_error('You must be an administrator to view this page.');
		}

		$id = (int) $id;

		$this->load->library('form_validation');
		$this->form_validation->set_rules('confirm', $this->lang->line('deactivate_validation_confirm_label'), 'required');
		$this->form_validation->set_rules('id', $this->lang->line('deactivate_validation_user_id_label'), 'required|alpha_numeric');

		if ($this->form_validation->run() == FALSE)
		{
			// insert csrf check
			$this->data['csrf'] = $this->_get_csrf_nonce();
			$this->data['user'] = $this->ion_auth->user()->row();
			$this->data['usuario'] = $this->ion_auth->user($id)->row();

			$this->_render_page('auth/deactivate_user', $this->data);
		}
		else
		{
			// do we really want to deactivate?
			if ($this->input->post('confirm') == 'yes')
			{
				if ($this->ion_auth->logged_in() && $this->ion_auth->is_admin())
				{
					$this->ion_auth->deactivate($id);
					$this->session->set_flashdata('message', 'Usuario desactivado.');
				}
			}

			// redirect them back to the auth page
			redirect('auth', 'refresh');
		}
	}

	// create a new user
	public function create_user()
    {
        $this->data['title'] = $this->lang->line('create_user_heading');

        if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
        {
            redirect('auth', 'refresh');
        }
        $this->data['user'] = $this->ion_auth->user()->row();
        $this->data['groups']=$this->ion_auth->groups()->result_array();
        $tables = $this->config->item('tables','ion_auth');
        $identity_column = $this->config->item('identity','ion_auth');
        $this->data['identity_column'] = $identity_column;

        // validate form input
        $this->form_validation->set_rules('first_name', $this->lang->line('create_user_validation_fname_label'), 'required');
        $this->form_validation->set_rules('last_name', $this->lang->line('create_user_validation_lname_label'), 'required');
        if($identity_column!=='email')
        {
            $this->form_validation->set_rules('identity',$this->lang->line('create_user_validation_identity_label'),'required|is_unique['.$tables['users'].'.'.$identity_column.']');
            $this->form_validation->set_rules('email', $this->lang->line('create_user_validation_email_label'), 'required|valid_email');
        }
        else
        {
            $this->form_validation->set_rules('email', $this->lang->line('create_user_validation_email_label'), 'required|valid_email|is_unique[' . $tables['users'] . '.email]');
        }
        $this->form_validation->set_rules('phone', $this->lang->line('create_user_validation_phone_label'), 'trim');
        $this->form_validation->set_rules('company', $this->lang->line('create_user_validation_company_label'), 'trim');
        $this->form_validation->set_rules('password', $this->lang->line('create_user_validation_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
        $this->form_validation->set_rules('password_confirm', $this->lang->line('create_user_validation_password_confirm_label'), 'required');

		$tipo_usu= $this->input->post('tipo');
		if($tipo_usu==2){
		    $barrio=$this->input->post('ptv_id');
		    $ufd = $this->input->post('ufd');
		    $idcopr=$this->Sec_model->get_idcopr($barrio,$ufd);
		    $contr_id=$this->Sec_model->get_idcontr($idcopr);
		    if(!$contr_id || $contr_id==false){
			$this->data['message']='NO EXISTE CONTRATO DE LOCACION DEFINIDO, ANTES DE REGISTRARSE COMUNIQUESE CON LA ADMINISTRACION.';
			$this->session->set_flashdata('message', 'NO EXISTE CONTRATO DE LOCACION DEFINIDO, ANTES DE REGISTRARSE COMUNIQUESE CON LA ADMINISTRACION.');
			redirect("auth", 'refresh');
		    }
		}


        if ($this->form_validation->run() == true)
        {
            $email    = strtolower($this->input->post('email'));
            $identity = ($identity_column==='email') ? $email : $this->input->post('identity');
            $password = $this->input->post('password');

            $additional_data = array(
                'first_name' => $this->input->post('first_name'),
                'last_name'  => $this->input->post('last_name'),
                'company'    => $this->input->post('company'),
                'tipo'    => $this->input->post('tipo'),
                'phone'      => $this->input->post('phone'),
            );
        }
        if ($this->form_validation->run() == true && $this->ion_auth->register($identity, $password, $email, $additional_data))
        {
            // check to see if we are creating the user
            // redirect them back to the admin page
            $this->session->set_flashdata('message', $this->ion_auth->messages());
            redirect("auth", 'refresh');
        }
        else
        {
            // display the create user form
            // set the flash data error message if there is one
            $this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

           	$this->data['first_name'] = array(
				'name'  => 'first_name',
				'id'    => 'first_name',
				'class' => 'form-control',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('first_name'),
			);
			$this->data['last_name'] = array(
				'name'  => 'last_name',
				'id'    => 'last_name',
				'class' => 'form-control',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('last_name'),
			);
			$this->data['company'] = array(
				'name'  => 'company',
				'id'    => 'company',
				'class' => 'form-control',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('company'),
			);
			$this->data['phone'] = array(
	                'name'  => 'phone',
	                'id'    => 'phone',
	                'class' => 'form-control',
	                'type'  => 'text',
	                'value' => $this->form_validation->set_value('phone'),
	        );
			$this->data['email'] = array(
				'name'  => 'email',
				'id'    => 'email',
				'class' => 'form-control',
				'type'  => 'email',
				'value' => $this->form_validation->set_value('email'),
			);
			$this->data['password'] = array(
				'name' => 'password',
				'id'   => 'password',
				'class' => 'form-control',
				'type' => 'password',
				'value' => $this->form_validation->set_value('password'),
			);
			$this->data['password_confirm'] = array(
				'name' => 'password_confirm',
				'id'   => 'password_confirm',
				'class' => 'form-control',
				'type'  => 'password',
	            'value' => $this->form_validation->set_value('password_confirm'),
			);

            $this->_render_page('auth/create_user', $this->data);
        }
    }

	// edit a user
	public function edit_user($id)
	{
		$this->data['title'] = $this->lang->line('edit_user_heading');

		if (!$this->ion_auth->logged_in() || (!$this->ion_auth->is_admin() && !($this->ion_auth->user()->row()->id == $id)))
		{
			redirect('auth', 'refresh');
		}

		$user = $this->ion_auth->user()->row();
		$this->data['usuario']= $this->ion_auth->user($id)->row();
		$usuario=$this->data['usuario'];
		$groups=$this->ion_auth->groups()->result_array();
		$currentGroups = $this->ion_auth->get_users_groups($id)->result();

		// validate form input
		$this->form_validation->set_rules('first_name', $this->lang->line('edit_user_validation_fname_label'), 'required');
		$this->form_validation->set_rules('last_name', $this->lang->line('edit_user_validation_lname_label'), 'required');
		$this->form_validation->set_rules('phone', $this->lang->line('edit_user_validation_phone_label'), 'required');
//		$this->form_validation->set_rules('company', $this->lang->line('edit_user_validation_company_label'));

		if (isset($_POST) && !empty($_POST))
		{
			

			// do we have a valid request?
			if ( $id != $this->input->post('id'))
			{
				show_error($this->lang->line('error_csrf'));
			}

			// update the password if it was posted
			if ($this->input->post('password'))
			{
				$this->form_validation->set_rules('password', $this->lang->line('edit_user_validation_password_label'), 'required|min_length[' . $this->config->item('min_password_length', 'ion_auth') . ']|max_length[' . $this->config->item('max_password_length', 'ion_auth') . ']|matches[password_confirm]');
				$this->form_validation->set_rules('password_confirm', $this->lang->line('edit_user_validation_password_confirm_label'), 'required');
			}

			if ($this->form_validation->run() === TRUE)
			{
				$data = array(
					'first_name' => $this->input->post('first_name'),
					'last_name'  => $this->input->post('last_name'),
					'company'    => $this->input->post('company'),
					'extra_tel'    => $this->input->post('extra_tel'),
					'phone'      => $this->input->post('phone'),
				);

				// update the password if it was posted
				if ($this->input->post('password'))
				{
					$data['password'] = $this->input->post('password');
//echo $data['password'];
//exit();
				}



				// Only allow updating groups if user is admin
				if ($this->ion_auth->is_admin())
				{
					//Update the groups user belongs to
					$groupData = $this->input->post('groups');

					if (isset($groupData) && !empty($groupData)) {

						$this->ion_auth->remove_from_group('', $id);

						foreach ($groupData as $grp) {
							$this->ion_auth->add_to_group($grp, $id);
						}

					}
				}

			// check to see if we are updating the user
			   if($this->ion_auth->update($id, $data))
			    {
			    	// redirect them back to the admin page if admin, or to the base url if non admin
				    $this->session->set_flashdata('message', $this->ion_auth->messages() );
				    if ($this->ion_auth->is_admin())
					{
						redirect('auth', 'refresh');
					}
					else
					{
						redirect('Auth/Edit_user/'.$user->id, 'refresh');
					}
			    }
			    else
			    {
			    	// redirect them back to the admin page if admin, or to the base url if non admin
				    $this->session->set_flashdata('message', $this->ion_auth->errors() );
				    if ($this->ion_auth->is_admin())
					{
						redirect('auth', 'refresh');
					}
					else
					{
						redirect('/', 'refresh');
					}

			    }

			}else{
			    $this->session->set_flashdata('message', validation_errors());
			}
		}

		// display the edit user form
		$this->data['csrf'] = $this->_get_csrf_nonce();

		// set the flash data error message if there is one
		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

		// pass the user to the view
		$this->data['user'] = $user;
		$this->data['groups'] = $groups;
		$this->data['currentGroups'] = $currentGroups;

		$this->data['first_name'] = array(
			'name'  => 'first_name',
			'id'    => 'first_name',
			'class' => 'form-control',
			'type'  => 'text',
			'required' => 'required',
			'value' => $this->form_validation->set_value('first_name', $usuario->first_name),
		);
		$this->data['last_name'] = array(
			'name'  => 'last_name',
			'id'    => 'last_name',
			'class' => 'form-control',
			'type'  => 'text',
			'required' => 'required',
			'value' => $this->form_validation->set_value('last_name', $usuario->last_name),
		);
		$this->data['company'] = array(
			'name'  => 'company',
			'id'    => 'company',
			'class' => 'form-control',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('company', $usuario->company),
		);
		$this->data['extra_tel'] = array(
			'name'  => 'extra_tel',
			'id'    => 'extra_tel',
			'class' => 'form-control',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('extra_tel', $usuario->extra_tel),
		);
		$this->data['phone'] = array(
            		'name'  => 'phone',
            		'id'    => 'phone',
            		'class' => 'form-control',
            		'type'  => 'text',
			'required' => 'required',
            		'value' => $this->form_validation->set_value('phone', $usuario->phone),
		);
		$this->data['email'] = array(
			'name'  => 'email',
			'id'    => 'email',
			'class' => 'form-control',
			'type'  => 'email',
			'disabled'  => 'disabled',
			'value' => $this->form_validation->set_value('email', $usuario->email),
		);
		$this->data['password'] = array(
			'name' => 'password',
			'id'   => 'password',
			'class' => 'form-control',
			'type' => 'password'
		);
		$this->data['password_confirm'] = array(
			'name' => 'password_confirm',
			'id'   => 'password_confirm',
			'class' => 'form-control',
			'type' => 'password'
		);

		$admins = array(1);
		$this->data['admins'] = $admins;
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
			    $this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
			    $this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
			}
		    }
		}



		$this->_render_page('auth/edit_user', $this->data);
	}



	public function User_prefs($id)
	{
		$this->data['title'] = 'Preferencias de usuario';

		if (!$this->ion_auth->logged_in() || (!$this->ion_auth->is_admin() && !($this->ion_auth->user()->row()->id == $id)))
		{
			redirect('auth', 'refresh');
		}

		$user = $this->ion_auth->user()->row();

		$user_prefs = $this->Sec_model->get_user_prefs($id);

		if (isset($_POST) && !empty($_POST))
		{
				$reservas = $this->input->post('reservas');
				if(!$reservas) $reservas=2;
				$pagos = $this->input->post('pagos');
				if(!$pagos) $pagos=2;
				$autoriza = $this->input->post('autoriza');
				if(!$autoriza) $autoriza=2;
				$prove = $this->input->post('prove');
				if(!$prove) $prove=2;
				$novedades = $this->input->post('novedades');
				if(!$novedades) $novedades=2;

echo $reservas;
echo $autoriza;
echo $prove;
echo $pagos;
echo $novedades;
//exit();

			
			if ( $id != $this->input->post('id'))
			{
				show_error($this->lang->line('error_csrf'));
			}

			$data = array(
				'up_reservas' => $reservas,
				'up_pagos' => $pagos,
				'up_prove' => $prove,
				'up_autoriza' => $autoriza,
				'up_novedades' => $novedades
			);
			if($this->Sec_model->update_p('user_prefs','up_iduser',$id,$data)==true){

			    $grupos=$this->input->post('grupos');
			    if($grupos>0){
				$existe=$this->Director_model->tengoSuscr($grupos,$user->id);
				if(!$existe){
				    $tabla2='suscrgpo';
				    $data2=array(
					'sg_iduser' => $user->id,
					'sg_idgpo' => $grupos
				    );
				    $this->Sec_model->insert($tabla2,$data2);
				}
			    }

			    $this->session->set_flashdata('message', 'Se han realizado los cambios.');
			    redirect('Auth/User_prefs/'.$id, 'refresh');
			}else{
			    $this->session->set_flashdata('message', 'ERROR GENERAL: No se guardaron los cambios, intente nuevamente.');
			    redirect('Auth/User_prefs/'.$id, 'refresh');
			}
		}

		// set the flash data error message if there is one
		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

		// pass the user to the view
		$this->data['user'] = $user;

		$this->data['reservas'] = array(
			'name'  => 'reservas',
			'id'    => 'reservas',
			'class' => 'form-control',
			'type'  => 'checkbox',
			'value' => 1,
		);
		if($user_prefs->up_reservas==1) $this->data['reservas']['checked']="checked";

		$this->data['pagos'] = array(
			'name'  => 'pagos',
			'id'    => 'pagos',
			'class' => 'form-control',
			'type'  => 'checkbox',
			'value' => 1,
		);
		if($user_prefs->up_pagos==1) $this->data['pagos']['checked']="checked";

		$this->data['autoriza'] = array(
			'name'  => 'autoriza',
			'id'    => 'autoriza',
			'class' => 'form-control',
			'type'  => 'checkbox',
			'value' => 1,
		);
		if($user_prefs->up_autoriza==1) $this->data['autoriza']['checked']="checked";

		$this->data['prove'] = array(
			'name'  => 'prove',
			'id'    => 'prove',
			'class' => 'form-control',
			'type'  => 'checkbox',
			'value' => 1,
		);
		if($user_prefs->up_prove==1) $this->data['prove']['checked']="checked";

		$this->data['novedad'] = array(
			'name'  => 'novedades',
			'id'    => 'novedades',
			'class' => 'form-control',
			'type'  => 'checkbox',
			'value' => 1,
		);
		if($user_prefs->up_novedades==1) $this->data['novedad']['checked']="checked";

		$admins = array(1);
		$this->data['admins'] = $admins;
		$user=$this->ion_auth->user()->row();
		$this->data['user'] = $user;

		$id=$user->id;
		$this->data['barrios'] = $this->Sec_model->ver_barrios(); // para selects
		$losBarrios = $this->Sec_model->losBarriosDelUsuario($id);
		$lasRelaciones = $this->Sec_model->barrios_user($id);
		if($lasRelaciones){
		    $this->data['el_primer_barrio'] = $lasRelaciones[0]->ptv_id;// relaciones user-ptv_id-ufd
		    $this->data['los_barrios_del_usuario'] = $losBarrios;// relaciones user-ptv_id-ufd
		    $this->data['relaciones_usuario'] = $lasRelaciones;// relaciones user-ptv_id-ufd
		    if(!$this->data['relaciones_usuario'] == FALSE){ //si existen
			foreach($this->data['relaciones_usuario'] as $barrio){	//descomponemos para usar valores
			    $this->data['barr_user'][$barrio->ptv_id]= $this->Sec_model->ver_barrios($barrio->ptv_id);
			    $this->data['unidades_user'][$barrio->ptv_id][]= $this->Sec_model->ver_unidades($barrio->ufd);
			}
		    }
		}


		$barrio=$this->Sec_model->getBarrio();
		$gruposActivi=$this->Director_model->get_gruposActivi($barrio);
		$suscrp=$this->Director_model->get_suscripciones($id);
		$autoriza="<select name='grupos' class='form-control' size='1'>\n";
		$autoriza.="<option value='-1' selected> NO </option>\n";
		foreach($gruposActivi as $g){
		    $autoriza.="<option value='".$g->ga_id."'> $g->ga_nombre </option>\n";
		}
		$autoriza.="</select>\n";

		$this->data['auto'] = $autoriza;
		$this->data['suscr'] = $suscrp;



		$this->_render_page('auth/preferencias', $this->data);
	}





	function delSuscr($id,$userid){

		$data = array(
			'sg_estado' => 2,
		);
		if($this->Sec_model->update_p('suscrgpo','sg_id',$id,$data)==true){
		    redirect('Auth/User_Prefs/'.$userid, 'refresh');
		}else{
		    $this->session->set_flashdata('message', 'ERROR');
		    redirect('Auth/User_Prefs/'.$userid, 'refresh');
		}



	}












	// create a new group
	public function create_group()
	{
		$this->data['title'] = $this->lang->line('create_group_title');

		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		// validate form input
		$this->form_validation->set_rules('group_name', $this->lang->line('create_group_validation_name_label'), 'required|alpha_dash');

		if ($this->form_validation->run() == TRUE)
		{
			$new_group_id = $this->ion_auth->create_group($this->input->post('group_name'), $this->input->post('description'));
			if($new_group_id)
			{
				// check to see if we are creating the group
				// redirect them back to the admin page
				$this->session->set_flashdata('message', $this->ion_auth->messages());
				redirect("auth", 'refresh');
			}
		}
		else
		{
			// display the create group form
			// set the flash data error message if there is one
			$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

			$this->data['group_name'] = array(
				'name'  => 'group_name',
				'id'    => 'group_name',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('group_name'),
			);
			$this->data['description'] = array(
				'name'  => 'description',
				'id'    => 'description',
				'type'  => 'text',
				'value' => $this->form_validation->set_value('description'),
			);

			$this->_render_page('auth/create_group', $this->data);
		}
	}

	// edit a group
	public function edit_group($id)
	{
		// bail if no group id given
		if(!$id || empty($id))
		{
			redirect('auth', 'refresh');
		}

		$this->data['title'] = $this->lang->line('edit_group_title');

		if (!$this->ion_auth->logged_in() || !$this->ion_auth->is_admin())
		{
			redirect('auth', 'refresh');
		}

		$group = $this->ion_auth->group($id)->row();

		// validate form input
		$this->form_validation->set_rules('group_name', $this->lang->line('edit_group_validation_name_label'), 'required|alpha_dash');

		if (isset($_POST) && !empty($_POST))
		{
			if ($this->form_validation->run() === TRUE)
			{
				$group_update = $this->ion_auth->update_group($id, $_POST['group_name'], $_POST['group_description']);

				if($group_update)
				{
					$this->session->set_flashdata('message', $this->lang->line('edit_group_saved'));
				}
				else
				{
					$this->session->set_flashdata('message', $this->ion_auth->errors());
				}
				redirect("auth", 'refresh');
			}
		}

		// set the flash data error message if there is one
		$this->data['message'] = (validation_errors() ? validation_errors() : ($this->ion_auth->errors() ? $this->ion_auth->errors() : $this->session->flashdata('message')));

		// pass the user to the view
		$this->data['group'] = $group;

		$readonly = $this->config->item('admin_group', 'ion_auth') === $group->name ? 'readonly' : '';

		$this->data['group_name'] = array(
			'name'    => 'group_name',
			'id'      => 'group_name',
			'type'    => 'text',
			'value'   => $this->form_validation->set_value('group_name', $group->name),
			$readonly => $readonly,
		);
		$this->data['group_description'] = array(
			'name'  => 'group_description',
			'id'    => 'group_description',
			'type'  => 'text',
			'value' => $this->form_validation->set_value('group_description', $group->description),
		);

		$this->_render_page('auth/edit_group', $this->data);
	}


	public function _get_csrf_nonce()
	{
		$this->load->helper('string');
		$key   = random_string('alnum', 8);
		$value = random_string('alnum', 20);
		$this->session->set_flashdata('csrfkey', $key);
		$this->session->set_flashdata('csrfvalue', $value);

		return array($key => $value);
	}

	public function _valid_csrf_nonce()
	{
/*		$csrfkey = $this->input->post($this->session->flashdata('csrfkey'));
		if ($csrfkey && $csrfkey == $this->session->flashdata('csrfvalue'))
		{
			return TRUE;
		}
		else
		{
			return FALSE;
		}
*/
	    return TRUE;
	}

	public function _render_page($view, $data=null, $returnhtml=false)//I think this makes more sense
	{

		$this->viewdata = (empty($data)) ? $this->data: $data;

		$view_html = $this->load->view($view, $this->viewdata, $returnhtml);

		if ($returnhtml) return $view_html;//This will return html on 3rd argument being true
	}

	function desccomp($astc_comprob){
		$this->db->select('comp_codigo,comp_nombre');
		$this->db->where('comp_id', $astc_comprob);
		$q=$this->db->get('comprob');
		$q=$q->row();
		$concatenado = $q->comp_codigo."-".$q->comp_nombre;
		return $concatenado;

	}

	

//API

    private function guidv4($data){
	assert(strlen($data) == 16);

	$data[6] = chr(ord($data[6]) & 0x0f | 0x40); // set version to 0100
	$data[8] = chr(ord($data[8]) & 0x3f | 0x80); // set bits 6-7 to 10

	return vsprintf('%s%s-%s-%s-%s-%s%s%s', str_split(bin2hex($data), 4));
    }

    public function login_api(){
	header('Access-Control-Allow-Origin: *');
	header("Access-Control-Allow-Methods: POST, OPTIONS, GET");
	header('Content-Type: application/json');
	$key="asd";
	$usr=strtolower($this->input->post('usr'));
	$pwd=$this->input->post('pwd');
	$apiKey=$this->input->post('apiKey');
	$remember=1;
	$resp=array();
	$msg=array();
	if($key==$apiKey){
	    if ($this->ion_auth->login($usr, $pwd, $remember)){
		$user = $this->ion_auth->user()->row();

		$sessId = $this->guidv4(openssl_random_pseudo_bytes(16));

		$userProfile=array();
		$userProfile=["email" => $user->username, "firstName" => $user->first_name, "lastName" => $user->last_name, "id" => $user->id];

		$msg=["userProfileModel" => $userProfile, "sessionId" => $sessId];
		$resp=["success" => true, "extras" => $msg];
	    }else{
		$resp=["success" => false];
	    }
	}else{
	    $resp=array("success" => "false");
	}

	echo json_encode($resp);

    }






}
