CREATE TABLE inhcop (
    inh_id integer NOT NULL,
    inh_idcopr integer NOT NULL,
    inh_fecha timestamp without time zone default now() NOT NULL,
    inh_motivo text,
    inh_estado integer DEFAULT 1
);


ALTER TABLE public.inhcop OWNER TO sanjor;

CREATE SEQUENCE inhcop_inh_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


ALTER TABLE public.inhcop_inh_id_seq OWNER TO sanjor;
ALTER SEQUENCE inhcop_inh_id_seq OWNED BY inhcop.inh_id;

ALTER TABLE ONLY inhcop ALTER COLUMN inh_id SET DEFAULT nextval('inhcop_inh_id_seq'::regclass);

ALTER TABLE ONLY inhcop
    ADD CONSTRAINT inhcop_pkey PRIMARY KEY (inh_id);

ALTER TABLE ONLY inhcop ADD CONSTRAINT "$1" FOREIGN KEY (inh_idcopr) REFERENCES coprop(cop_id);


REVOKE ALL ON TABLE inhcop FROM PUBLIC;
REVOKE ALL ON TABLE inhcop FROM sanjor;
GRANT ALL ON TABLE inhcop TO sanjor;
GRANT ALL ON TABLE inhcop TO nobody;

REVOKE ALL ON SEQUENCE inhcop_inh_id_seq FROM PUBLIC;
REVOKE ALL ON SEQUENCE inhcop_inh_id_seq FROM sanjor;
GRANT ALL ON SEQUENCE inhcop_inh_id_seq TO sanjor;
GRANT UPDATE ON SEQUENCE inhcop_inh_id_seq TO nobody;


