<?php

/*  
* SiZoFra - Sistema Informatico Zona Franca
* Propiedad Intelectual Exclusiva: CatWare Soluciones Informaticas de Fabian Gustavo Lopez    
*/

if(phpversion()>4.2)parse_str(apache_getenv("QUERY_STRING"));
session_start();
require("config.php");
require($INCLUDEBASE."library.php");
$user = CheckUserLogin($_SESSION['login'], $_SESSION['password']);
$gpo = $user["groupid"];
$codemp = $user["codemp"];
$ptovta = $user["ptovta"];
$cli = $user["cliente"];
$operador = $user["operador"];
$operador_id = $user["codigo"];
$printer=$_SESSION['printers'];
$login=$_SESSION['login'];
$password=$_SESSION['password'];

if($codemp) $astc_codemp=$codemp;

if($ptovta)
    $astc_idptov=$ptovta; 
  else
    if($codemp) 
	$astc_idptov=@UserQuery("select ptovdefault($codemp)",0);

if($astc_idptov)$ash_idptov=$astc_idptov;


$tipctadxv=@UserQuery("select valvaramb($codemp,$astc_idptov,'TIPCTADXV')",0);
$tipctadxc=@UserQuery("select valvaramb($codemp,$astc_idptov,'TIPCTADXC')",0);
$cta_deudxv=UserQuery("select idcbl($codemp,$astc_idptov,valvaramb($codemp,$astc_idptov,'DEUDXV')::integer)",0);
$cta_deudxc=UserQuery("select idcbl($codemp,$astc_idptov,valvaramb($codemp,$astc_idptov,'DEUDXC')::integer)",0);

function estaEnVector($numero,$vector){
    for($m=0;$vector[$m];$m++){
	$num=$vector[$m];
	if($num==$numero)
	    return true;
    }
    return false;
}


function columna_exc($numero){
    $res="";
    while($numero > -1){
	$lett = $numero % 26;
	$res = chr(65+$lett).$res;
	$numero=intval($numero/26)-1;
    }
    return $res;
}




switch($accion){


case 'PDF'	:


	if(!$codemp)
	    $existe=@UserQuery("select emp_codigo from empresa where emp_codigo=$astc_codemp",0);

	if(!$existe && !$codemp)
		$mensaje='La Empresa Definida no Existe Utilize la Busqueda';

	if($mensaje)
	    {
	    echo("<BR></BR>");
	    echo(" <CENTER><H3> <Caption class=\"text\">$mensaje</Caption></H3></CENTER>\n");
	    echo("<BR></BR>");
	    echo("<CENTER><A HREF=\"javascript:history.go(-1)\">Volver</A></CENTER>");
	    exit();
	    } 

	$fecha = date("d-m-Y");
	$nomemp=UserQuery("select nomemp($astc_codemp)",0);
	$nomptv=UserQuery("select nomptv($elidptov)",0);
	$clq_comprob=@UserQuery("select idcomp($codemp,$elidptov,valvaramb($codemp,$elidptov,'CMPQL'));",0);

	$eg_codemp=$codemp;
	$eg_idptov=$elidptov;

	$cta_depsi=@UserQuery("select idcble($codemp,$elidptov,'CTADEPSI')",0);
	$cta_caja=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'CAJA')::smallint)",0);
	$cta_cheque=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'CHEQUE')::smallint)",0);
	$cta_deudxv=UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'DEUDXV')::smallint)",0);
	$cta_banco=@UserQuery("select idcble($codemp,$elidptov,'BANCO')",0);
	$tcta_banco=@UserQuery("select tipctacbl($cta_banco)",0);
	$cta_ff=@UserQuery("select idcble($codemp,$elidptov,'CTAFF')",0);
	$tcta_ff=@UserQuery("select tipctacbl($cta_ff)",0);
	$cta_monex=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'MONEX')::smallint)",0);
	$cta_ajuste=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'AJUSTE')::smallint)",0);
	$cta_1242=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'1242')::smallint)",0);
	$cta_1245=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'1245')::smallint)",0);
	$cargoCesped=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOCESPED')",0);
	$cargoEnergia=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOENERGIA')",0);
	$cargoFEventos=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOFEVENTOS')",0);
	$cargoFamiliar=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOFAMILIAR')",0);
	$cargoRedondeo=@UserQuery("select valvaramb($codemp,$elidptov,'REDONDEO')",0);
	$cargoIduf=@UserQuery("select valvaramb($codemp,$elidptov,'IDUF')",0);
	$cargoInteres=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOINT')",0);
	$cargoQuincho=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOHOUSE')",0);
	$cargoReserva=@UserQuery("select valvaramb($codemp,$elidptov,'CARGORESERVA')",0);
	$cargoMant=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOMANT')",0);
	$cargoVol=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOVOLUNTARIOS')",0);
	$rubcarord=@UserQuery("select valvaramb($codemp,$astc_idptov,'RUBROORDINARIAS')");

	$qLiq=PgDoQuery("select l_id,l_comprob,l_numero,l_fecvto,l_feccie from liquidacion where l_idptov=$elidptov and l_feccie<='$fechah' and l_estado=2 order by 1 desc limit 1;");
	$rLiq=pg_numRows($qLiq);
	if($rLiq){
	    $idliq=Resultado($qLiq,0,"l_id",1);
	    $comprob=Resultado($qLiq,0,"l_comprob",1);
	    $numero=Resultado($qLiq,0,"l_numero",1);
	    $fecvto=Resultado($qLiq,0,"l_fecvto",1);
	    $feccie=Resultado($qLiq,0,"l_feccie",1);
	}
	$mes=@UserQuery("select date_part('month','$feccie'::date);",0);
	$anio=@UserQuery("select date_part('year','$feccie'::date);",0);

	$eg_mes=$mes;
	$eg_anio=$anio;
	$qCompliqCar=PgDoQuery("select distinct(cl_cargo) as cargo,cl_tipo from compliquid where cl_idliq=$idliq and cl_tipo not in (4) order by cl_tipo");
	$fCompliqCar=pg_numRows($qCompliqCar);
	for($jjj=0;$jjj<$fCompliqCar;$jjj++){
	    $cargoCompliquid=Resultado($qCompliqCar,$jjj,"cargo",1);
	    if($jjj==0)
		$cargosProrrata=$cargoCompliquid;
	    else
		$cargosProrrata.=",".$cargoCompliquid;
	}
	if(!$cargosProrrata) $cargosProrrata=-10;

	$tieneDescuf=@UserQuery("select count(distinct(cop_descuf)) from coprop where cop_descuf!='NN' and cop_descuf!='1' and cop_descuf!=cop_unifun::varchar and cop_idptov=$elidptov;",0);
	$aplicaDescuento=@UserQuery("select ptv_aplicadesc from ptovta where ptv_id=$elidptov;",0);
	$tieneRedondeo=@UserQuery("select sum(clq_impngi) from compliq where (clq_cargo=$cargoRedondeo or clq_cargo=$cargoIduf) and clq_idliq=$idliq",0);
	$tieneQuincho=@UserQuery("select sum(clq_importe) from compliq where clq_cargo in ($cargoQuincho) and clq_idliq=$idliq",0);
	$tieneMant=@UserQuery("select sum(clq_importe) from compliq where clq_cargo in ($cargoMant) and clq_idliq=$idliq",0);
	$tieneVol=@UserQuery("select sum(clq_importe) from compliq where clq_cargo in ($cargoVol) and clq_idliq=$idliq",0);

	$qCompliquid=PgDoQuery("select distinct(trim(cl_leyen)) as leyen,cl_tipo from compliquid where cl_idliq=$idliq and cl_tipo not in (4) order by leyen asc");
	$fCompliquid=pg_numRows($qCompliquid);
	$qCompliq=PgDoQuery("select distinct clq_cargo,car_orden from compliq,cargos where clq_idliq=$idliq and clq_cargo=car_id and clq_cargo not in ($cargoQuincho,$cargosProrrata,$cargoRedondeo,$cargoIduf) and (clq_importe!=0 or clq_impngi!=0) order by 2,1;");
	$fCompliq=pg_numRows($qCompliq);

	$fecint=@UserQuery("select date_part('day',l_fecvto) from liquidacion where l_id=$idliq",0);


	$columnas=0;
	if($tieneRedondeo)$columnas++;
	if($tieneQuincho)$columnas++;
	if($tieneMant)$columnas++;
	if($tieneVol)$columnas++;
	for($iii=0;$iii<$fCompliquid;$iii++){
	    $columnas++;
	}
	$qCompliq1=PgDoQuery("select distinct clq_cargo,car_orden from compliq,cargos where clq_idliq=$idliq and clq_cargo=car_id and clq_cargo not in ($cargoMant,$cargoQuincho,$cargosProrrata,$cargoRedondeo,$cargoIduf) and (clq_importe!=0 or clq_impngi!=0) order by 2,1;");
	$fCompliq1=pg_numRows($qCompliq1);
	for($kk=0;$kk<$fCompliq1;$kk++){
	    $columnas++;
	}








require('fpdf/fpdf.php');

class PDF extends FPDF{

    function head_simp(){

	global $mes,$anio,$nomptv,$fecint;

	$this->SetY(0);
	$this->Ln(1);
	$this->SetFillColor(198,224,180);
	$this->SetLineWidth(0.5);
	$this->SetFont('Arial','B',12);
	$this->SetX(4);
	$this->Cell(290,32,'',1,0,'C',true);
	$this->Ln(22);
	$this->Ln(-22);
	$this->Ln(1);
	$this->Cell(10);
	$this->Cell(0,6,'BANCO SANTANDER',0);
	$this->Ln(6);
	$this->Cell(10);
	$this->Cell(100,6,'CTA. CTE. 454-006029/7',0);
	$this->SetFont('Arial','BU',12);
	$this->Cell(0,6,'ESTA PROHIBIDO EL PAGO DE LAS EXPENSAS EN EFECTIVO',0,0,'C');
	$this->SetFont('Arial','B',12);
	$this->Ln(6);
	$this->Cell(10);
	$this->Cell(100,6,'Nro. CBU: 0720454220000000602972',0);
	$this->SetFont('Arial','BU',12);
	$this->Cell(0,6,'SOLO DEPOSITAR EN CTA CTE DEL CONSORCIO DEL BANCO SANTANDER',0,0,'C');
	$this->SetFont('Arial','B',12);
	$this->Ln(6);
	$this->Cell(10);
	$this->Cell(0,6,'CUIT 33-57627577-9',0);
	$this->Ln(6);
	$this->Ln(1);
	$this->SetX(4);
	$this->SetFillColor(255,255,255);
	$this->Cell(290,6,"$nomptv Liquidacion del mes de $mes-$anio",1,0,'C',true);
	$this->Ln(6);

	$this->SetX(4);
	$this->SetFont('Arial','B',8);
	$this->SetFillColor(50,50,50);
	$this->Cell(8,1,'','LTR',0,'C',true);
	$this->Cell(109,1,'','LTR',0,'C',true);
	$this->Cell(8,1,'','LTR',0,'C',true);
	$this->SetFillColor(255,255,255);
	$this->Cell(20,1,'','LTR',0,'C',true);
	$this->Cell(20,1,'','LTR',0,'C',true);
	$this->Cell(20,1,'','LTR',0,'C',true);
	$this->Cell(20,1,'','LTR',0,'C',true);
	$this->Cell(20,1,'','LTR',0,'C',true);
	$this->Cell(20,1,'','LTR',0,'C',true);
	$this->Cell(20,1,'','LTR',0,'C',true);
	$this->SetFillColor(237,50,19);
	$this->Cell(25,1,'','LTR',0,'C',true);
	$this->Ln(1);

	$this->SetX(4);
	$this->SetFillColor(50,50,50);
	$this->SetTextColor(255,255,255);
	$this->Cell(8,8,'UF','LR',0,'C',true);
	$this->Cell(109,8,'Propietario','LR',0,'C',true);
	$this->Cell(8,8,'%','LR',0,'C',true);
	$this->SetTextColor(0,0,0);
	$this->SetFillColor(255,255,255);
	$this->Cell(20,8,'Sal. Ant.','LR',0,'C',true);
	$this->Cell(20,8,'Ajustes','LR',0,'C',true);
	$this->Cell(20,8,'Pagos','LR',0,'C',true);
	$this->CellFitScale(20,4,'Interes Pago','LR',0,'C',true);
	$this->Cell(20,4,'Importe','LR',0,'C',true);
	$this->Cell(20,4,'Interes','LR',0,'C',true);
	$this->Cell(20,4,'Expensa del','LR',0,'C',true);
	$this->SetFillColor(237,50,19);
	$this->Cell(25,4,'Total A Pagar','LR',0,'C',true);
	$this->Ln(4);

	$this->SetX(4);
	$this->SetFillColor(255,255,255);
	$this->Cell(185);
	$this->CellFitScale(20,4,'Fuera de Termino','LR',0,'C',true);
	$this->Cell(20,4,'Mora','LR',0,'C',true);
	$this->Cell(20,4,'Mora','LR',0,'C',true);
	$this->Cell(20,4,'Mes','LR',0,'C',true);
	$this->SetFillColor(237,50,19);
	$this->Cell(25,4,'hasta el '.$fecint,'LR',0,'C',true);
	$this->Ln(4);

	$this->SetX(4);
	$this->SetFillColor(50,50,50);
	$this->Cell(8,1,'','LBR',0,'C',true);
	$this->Cell(109,1,'','LBR',0,'C',true);
	$this->Cell(8,1,'','LBR',0,'C',true);
	$this->SetFillColor(255,255,255);
	$this->Cell(20,1,'','LBR',0,'C',true);
	$this->Cell(20,1,'','LBR',0,'C',true);
	$this->Cell(20,1,'','LBR',0,'C',true);
	$this->Cell(20,1,'','LBR',0,'C',true);
	$this->Cell(20,1,'','LBR',0,'C',true);
	$this->Cell(20,1,'','LBR',0,'C',true);
	$this->Cell(20,1,'','LBR',0,'C',true);
	$this->SetFillColor(237,50,19);
	$this->Cell(25,1,'','LBR',0,'C',true);
	$this->Ln(1);



    }


    function body_simp(){
	global $feccie,$codemp,$elidptov,$cta_deudxv,$cta_ajuste,$qCompliquid,$fCompliquid,$qCompliq,$fCompliq,$tieneQuincho,$cargoQuincho,$tieneRedondeo,$cargoRedondeo,$cargoIduf,$idliq;

	$fechaini=@UserQuery("select '01-'||lpad(date_part('month','$feccie'::date)::text,2,'0')||'-'||date_part('Y','$feccie'::date);",0);
	$lineas=40;
	$altoLn=4;

	$this->SetFont('Arial','',8);
	$this->SetLineWidth(0.2);

	$tsalant=$tcobran=$tajus=$tsaldo=$tcargos=$prt=$ttot=$texp=0;
	$query="select * from coprop 
			where cop_codemp=$codemp and cop_idptov=$elidptov and cop_estado!=3 order by cop_unifun;";
	$r=PgDoQuery($query);
	$rows=pg_NumRows($r);
	$leyenCargos=array();
	$indexCargos=0;
	$desde=$cuerpo1+1;
	for($i=0; $i < $rows ; $i++){
	    $nCol=0;
	    $salant=$cobran=$ajus2=$ajus=$saldo=$cargos=$totlinea=$intft=0;
	    $cop_id=Resultado($r,$i,"cop_id",1);
	    $cop_unifun=Resultado($r,$i,"cop_unifun",1);
	    $cop_descuf=Resultado($r,$i,"cop_descuf",1);
	    $cop_nombre=Resultado($r,$i,"cop_nombre",1);
	    $cop_porc=Resultado($r,$i,"cop_porc1",1);

//	    $cop_nombre=utf8_decode($cop_nombre);

	    $cero=@UserQuery("select 0::numeric(15,2);",0);
	    $salant=@UserQuery("select sum(astc_importe)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado=2 and astc_ctacble=$cta_deudxv and astc_tipcta=99 and astc_ctacte=$cop_id and date_lt(astc_fecval,'$fechaini'::date);",0);
	    if(!$salant)$salant=$cero;
	    $ajus=@UserQuery("select sum(astc_importe)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado=2 and astc_ctacble=$cta_ajuste and astc_ctacte=$cop_id and date_ge(astc_fecval,'$fechaini'::date) and date_le(astc_fecval,'$feccie'::date);",0);
	    $ajus2=@UserQuery("select sum(astc_importe)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado=2 and codcble(astc_ctacble)>2999 and codcble(astc_ctacble)<4000 and codcble(astc_ctacble)!=3701 and astc_ctacte=$cop_id and date_ge(astc_fecval,'$fechaini'::date) and date_le(astc_fecval,'$feccie'::date);",0);
	    if(!$ajus)$ajus=$cero;
	    if(!$ajus2)$ajus2=$cero;
	    $ajus=$ajus+$ajus2;
	    $intft=@UserQuery("select sum(astc_importe*-1)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado=2 and codcble(astc_ctacble)=3701 and astc_ctacte=$cop_id and date_ge(astc_fecval,'$fechaini'::date) and date_le(astc_fecval,'$feccie'::date);",0);
	    if(!$intft) $intft=$cero;
	    $cobran=@UserQuery("select (sum(astc_importe*-1)-($ajus)-($intft*-1))::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado!=999 and astc_ctacte=$cop_id and astc_comprob!=10 and astc_ctacble=$cta_deudxv and date_ge(astc_fecval,'$fechaini'::date) and date_le(astc_fecval,'$feccie'::date);",0);
	    if(!$cobran)$cobran=$cero;
	    $saldo=$salant-$ajus-$cobran+$intft;
	    $saldo=@UserQuery("select $saldo::numeric(15,2);",0);

	    $intmora=@UserQuery("select sum(clq_interes)::numeric(15,2) from compliq where clq_idcopr=$cop_id and clq_idliq=$idliq and clq_estado=2 and date_ge(clq_fecha,'$fechaini'::date) and date_le(clq_fecha,'$feccie'::date);",0);
	    if(!$intmora) $intmora=$cero;

	    if($ajus!=0)
		$ajus*=-1;

	    if($i%2==0){
		$this->SetFillColor(255,255,255);
	    }else{
		$this->SetFillColor(174,170,170);
	    }

	    $tsalant+=$salant;
	    $tcobran+=$cobran;
	    $tajus+=$ajus;
	    $tsaldo+=$saldo;
	    $tintft+=$intft;
	    $tintmora+=$intmora;
	    $totlinea=$saldo+$intmora;
	    $totlineaAnt=$saldo+$intmora;

	    $totExpensas=$totExpensas2=0;
	    for($iii=0;$iii<$fCompliquid;$iii++){
		$leyen=Resultado($qCompliquid,$iii,"leyen",1);
		$importeCl=@UserQuery("select sum(clq_importe+clq_impngi+clq_interes)::numeric(15,2) from compliq where trim(clq_leyen)=trim('$leyen') and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		$cargoCl=@UserQuery("select clq_rubcar from compliq where trim(clq_leyen)=trim('$leyen') and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		$totExpensas+=$importeCl;
		if($cargoCl==$rubcarord){
		    $totExpensas2+=$importeCl;
		}else{
		    $totlineaAnt+=$importeCl;
		}
		$totlinea+=$importeCl;
	    }
	    for($kk=0;$kk<$fCompliq;$kk++){
		$cargo=Resultado($qCompliq,$kk,"clq_cargo",1);
		$importeCl=@UserQuery("select sum(clq_importe+clq_impngi+clq_interes)::numeric(15,2) from compliq where clq_cargo=$cargo and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		$totExpensas+=$importeCl;
		$totlinea+=$importeCl;
		$totlineaAnt+=$importeCl;
	    }
	    if($tieneQuincho){
		$importeQuincho=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo in ($cargoQuincho) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$totExpensas+=$importeQuincho;
		$totlinea+=$importeQuincho;
		$totlineaAnt+=$importeQuincho;
	    }
	    if($tieneRedondeo){
		$importeRedondeo=@UserQuery("select sum(clq_impngi)::numeric(15,2) from compliq where (clq_cargo=$cargoRedondeo or clq_cargo=$cargoIduf) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$identificador=@UserQuery("select sum(clq_impngi)::numeric(15,2) from compliq where clq_cargo=$cargoIduf and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		if(!$identificador) $identificador=0;
		$totExpensas+=$importeRedondeo;
		$totlinea+=$importeRedondeo;
	    }

	    $texp+=$totExpensas;
	    $ttot+=$totlinea;
	    $tporc+=$cop_porc;


	    $cop_porc=number_format($cop_porc,2,',','.');
	    $salant=number_format($salant,2,',','.');
	    $intft=number_format($intft,2,',','.');
	    $ajus=number_format($ajus,2,',','.');
	    $cobran=number_format($cobran,2,',','.');
	    $saldo=number_format($saldo,2,',','.');
	    $intmora=number_format($intmora,2,',','.');
	    $totExpensas=number_format($totExpensas,2,',','.');
	    $totlinea=number_format($totlinea,2,',','.');

	    $nombre=utf8_decode(html_entity_decode(Decode($cop_nombre)));

	    $this->SetX(4);
	    $this->CellFitScale(8,$altoLn,$cop_unifun,1,0,'C',true);
	    $this->CellFitScale(109,$altoLn,$nombre,1,0,'L',true);
	    $this->CellFitScale(8,$altoLn,$cop_porc,1,0,'C',true);
	    $this->CellFitScale(20,$altoLn,$salant,1,0,'R',true);
	    $this->CellFitScale(20,$altoLn,$ajus,1,0,'R',true);
	    $this->CellFitScale(20,$altoLn,$cobran,1,0,'R',true);
	    $this->CellFitScale(20,$altoLn,$intft,1,0,'R',true);
	    $this->CellFitScale(20,$altoLn,$saldo,1,0,'R',true);
	    $this->CellFitScale(20,$altoLn,$intmora,1,0,'R',true);
	    $this->CellFitScale(20,$altoLn,$totExpensas,1,0,'R',true);
	    $this->CellFitScale(25,$altoLn,$totlinea,1,0,'R',true);
	    $this->Ln($altoLn);

	    $prt++;
	    if($prt>$lineas){
		$prt=0;
		$this->AddPage();
		$this->head_simp();
		$this->SetFont('Arial','',8);
	    }

	}

	$tporc=number_format($tporc,2,',','.');
	$tsalant=number_format($tsalant,2,',','.');
	$tajus=number_format($tajus,2,',','.');
	$tintft=number_format($tintft,2,',','.');
	$tcobran=number_format($tcobran,2,',','.');
	$tsaldo=number_format($tsaldo,2,',','.');
	$tintmora=number_format($tintmora,2,',','.');
	$texp=number_format($texp,2,',','.');
	$ttot=number_format($ttot,2,',','.');

	$this->SetFont('Arial','B',8);
	$this->SetX(4);
	$this->SetFillColor(50,50,50);
	$this->SetTextColor(250,250,250);
	$this->Cell(117,7,'Totales',1,0,'C',true);
	$this->CellFitScale(8,7,$tporc,1,0,'R',true);
	$this->CellFitScale(20,7,$tsalant,1,0,'R',true);
	$this->CellFitScale(20,7,$tajus,1,0,'R',true);
	$this->CellFitScale(20,7,$tcobran,1,0,'R',true);
	$this->CellFitScale(20,7,$tintft,1,0,'R',true);
	$this->CellFitScale(20,7,$tsaldo,1,0,'R',true);
	$this->CellFitScale(20,7,$tintmora,1,0,'R',true);
	$this->CellFitScale(20,7,$texp,1,0,'R',true);
	$this->CellFitScale(25,7,$ttot,1,0,'R',true);
	$this->Ln(7);



	$this->Ln(5);
    }




    function head_det(){

	global $mes,$anio,$nomptv,$fecint,$columnas,$tieneVol,$qCompliquid,$fCompliquid,$qCompliq1,$fCompliq1,$tieneMant,$tieneQuincho,$tieneRedondeo;

	$this->SetY(0);
	$this->Ln(1);
	$this->SetFillColor(255,255,153);
	$this->SetTextColor(0,0,0);
	$this->SetLineWidth(0.5);
	$this->SetFont('Arial','B',8);
	$this->SetX(4);
//	$this->Image('lt.jpg',$this->GetX()+10,$this->GetY()+2,40,20);
	$this->Cell(290,32,'',1,0,'C',true);
	$this->Ln(22);
	$this->Ln(-22);
	$this->Ln(1);
	$this->Cell(50);
	$this->Cell(0,6,utf8_decode(html_entity_decode('Administraci&oacute;n del Oeste')),0);
	$this->Ln(6);
	$this->Cell(50);
	$this->Cell(30,6,utf8_decode(html_entity_decode('Tel&eacute;fono: 113 059 6961')),0);
	$this->SetFont('Arial','BU',8);
	$this->Cell(0,6,'ESTA PROHIBIDO EL PAGO DE LAS EXPENSAS EN EFECTIVO',0,0,'C');
	$this->SetFont('Arial','B',8);
	$this->Ln(6);
	$this->Cell(50);
	$this->Cell(30,6,'Email: ado.lostroncos@gmail.com',0);
	$this->SetFont('Arial','BU',8);
	$this->Cell(0,6,'SOLO DEPOSITAR EN CTA CTE DEL CONSORCIO DEL BANCO SANTANDER',0,0,'C');
	$this->SetFont('Arial','B',8);
	$this->Ln(6);
	$this->Cell(50);
	$this->Cell(0,6,'Lunes a Viernes de 10 a 17hs',0);
	$this->Ln(6);
	$this->Ln(1);
	$this->SetX(4);
	$this->SetFillColor(255,255,255);
	$this->Cell(290,6,"$nomptv Liquidacion del mes de $mes-$anio",1,0,'C',true);
	$this->Ln(6);

	$this->Image('lt.jpg',6,4,40,20);
	$this->Image('logo_adm.jpg',252,4,40,20);


	$this->SetX(4);
	$this->SetFont('Arial','B',5);
	$this->SetFillColor(50,50,50);
	$this->SetTextColor(255,255,255);
	$this->MultiCell(8,15,'UF',1,'C',true);
	$this->Ln(-15);
	$this->SetX(4);
	$this->Cell(8);
	$this->MultiCell(50,15,'Propietario',1,'C',true);
	$this->Ln(-15);

	$this->SetX(4);
	$this->Cell(58);
	$this->Cell(10,2.5,'','LTR',1,'C',true);
	$this->SetX(4);
	$this->Cell(58);
	$this->CellFitScale(10,5,'Socios','LR',1,'C',true);
	$this->SetX(4);
	$this->Cell(58);
	$this->CellFitScale(10,5,'Mayores','LR',1,'C',true);
	$this->SetX(4);
	$this->Cell(58);
	$this->Cell(10,2.5,'','LBR',1,'C',true);
	$this->Ln(-15);

	$this->SetX(4);
	$this->Cell(68);
	$this->Cell(10,2.5,'','LTR',1,'C',true);
	$this->SetX(4);
	$this->Cell(68);
	$this->CellFitScale(10,5,'Socios','LR',1,'C',true);
	$this->SetX(4);
	$this->Cell(68);
	$this->CellFitScale(10,5,'Menores','LR',1,'C',true);
	$this->SetX(4);
	$this->Cell(68);
	$this->Cell(10,2.5,'','LBR',1,'C',true);
	$this->Ln(-15);


	$quedaCols=184;
	$estoyEn=78;

	if($tieneVol){
	    $this->SetX(4);
	    $this->Cell($estoyEn);
	    $this->Cell(10,2.5,'','LTR',1,'C',true);
	    $this->SetX(4);
	    $this->Cell($estoyEn);
	    $this->CellFitScale(10,5,'Socios','LR',1,'C',true);
	    $this->SetX(4);
	    $this->Cell($estoyEn);
	    $this->CellFitScale(10,5,'Voluntarios','LR',1,'C',true);
	    $this->SetX(4);
	    $this->Cell($estoyEn);
	    $this->Cell(10,2.5,'','LBR',1,'C',true);
	    $this->Ln(-15);
	    $quedaCols-=10;
	    $estoyEn+=10;
	}


	$this->SetX(4);
	$this->Cell($estoyEn);
	$this->Cell($quedaCols,5,'CARGOS DEL PERIODO',1,0,'C',true);
	$this->MultiCell(20,15,'Total',1,'C',true);
	$this->Ln(-15);
	$this->SetX(4);
	$this->Cell(282);
	$this->MultiCell(8,15,'UF',1,'C',true);
	$this->Ln(-10);
	$this->SetFillColor(255,255,255);
	$this->SetTextColor(0,0,0);
	$this->SetX(4);
	$this->Cell($estoyEn);
	$ancho=$quedaCols/$columnas;


	for($iii=0;$iii<$fCompliquid;$iii++){
	    $leyen=ucwords(strtolower(Resultado($qCompliquid,$iii,"leyen",1)));
	    $alto=$this->GetMultiCellHeight($ancho, 5, $leyen, 1, 'C');
	    $this->MultiCell($ancho,(10/$alto)*5,$leyen,1,'C',true);
	    $estoyEn+=$ancho;
	    $this->Ln(-10);
	    $this->SetX(4);
	    $this->Cell($estoyEn);
	}

	for($kk=0;$kk<$fCompliq1;$kk++){
	    $carn=Resultado($qCompliq1,$kk,"clq_cargo",1);
	    $leyen=ucwords(strtolower(@UserQuery("select car_leyen from cargos where car_id=$carn",0)));
	    $alto=$this->GetMultiCellHeight($ancho, 5, $leyen, 1, 'C');
	    $this->MultiCell($ancho,(10/$alto)*5,$leyen,1,'C',true);
	    $estoyEn+=$ancho;
	    $this->Ln(-10);
	    $this->SetX(4);
	    $this->Cell($estoyEn);
	}

	if($tieneMant){
	    $leyen='Mant x Lote / Trab. Tarifado / Tarj. Acceso';
	    $alto=$this->GetMultiCellHeight($ancho, 5, $leyen, 1, 'C');
	    $this->MultiCell($ancho,(10/$alto)*5,$leyen,1,'C',true);
	    $estoyEn+=$ancho;
	    $this->Ln(-10);
	    $this->SetX(4);
	    $this->Cell($estoyEn);
	}
	if($tieneQuincho){
	    $leyen='Alquiler SUM / Quincho';
	    $alto=$this->GetMultiCellHeight($ancho, 5, $leyen, 1, 'C');
	    $this->MultiCell($ancho,(10/$alto)*5,$leyen,1,'C',true);
	    $estoyEn+=$ancho;
	    $this->Ln(-10);
	    $this->SetX(4);
	    $this->Cell($estoyEn);
	}
	if($tieneRedondeo){
	    $leyen='Redondeo';
	    $alto=$this->GetMultiCellHeight($ancho, 5, $leyen, 1, 'C');
	    $this->MultiCell($ancho,(10/$alto)*5,$leyen,1,'C',true);
	    $estoyEn+=$ancho;
	    $this->Ln(-10);
	    $this->SetX(4);
	    $this->Cell($estoyEn);
	}
	$this->Ln(10);

    }


    function body_det(){
	global $feccie,$codemp,$elidptov,$cta_deudxv,$cta_ajuste,$qCompliquid,$fCompliquid,$qCompliq1,$fCompliq1,$tieneQuincho,$cargoQuincho,$tieneRedondeo,$cargoRedondeo,$cargoIduf,$idliq,$tieneMant,$cargoMant,$tieneVol,$cargoVol,$columnas;

	$fechaini=@UserQuery("select '01-'||lpad(date_part('month','$feccie'::date)::text,2,'0')||'-'||date_part('Y','$feccie'::date);",0);
	$lineas=52;
	$altoLn=3;

	$this->SetFont('Arial','',5);
	$this->SetLineWidth(0.2);


	$tMay=$tMen=$tVol=$tMant=$tQuin=$tRed=$ttot=0;
	$aClq=$aCliq=array();

	$query="select * from coprop 
			where cop_codemp=$codemp and cop_idptov=$elidptov and cop_estado!=3 order by cop_unifun;";
	$r=PgDoQuery($query);
	$rows=pg_NumRows($r);
	$leyenCargos=array();
	$indexCargos=0;
	$desde=$cuerpo1+1;
	for($i=0; $i < $rows ; $i++){
	    $nCol=0;
	    $salant=$cobran=$ajus=$saldo=$cargos=$totlinea=0;
	    $cop_id=Resultado($r,$i,"cop_id",1);
	    $cop_unifun=Resultado($r,$i,"cop_unifun",1);
	    $cop_descuf=Resultado($r,$i,"cop_descuf",1);
	    $cop_nombre=Resultado($r,$i,"cop_nombre",1);

	    $cero=@UserQuery("select 0::numeric(15,2);",0);

	    if($i%2==0){
		$this->SetFillColor(255,255,255);
	    }else{
		$this->SetFillColor(174,170,170);
	    }


	    $contr_id=@UserQuery("select ct_id from contratos where ct_idcopr=$cop_id and ct_estado=1 and date_le(ct_inicio,'$feccie'::date)",0);
	    if($contr_id){
		$may=@UserQuery("select sum(gf_mayor) from grupof_inq where gf_idcopr=$cop_id and gf_idcontr=$contr_id and gf_estado=1",0);
		$men=@UserQuery("select sum(gf_menor) from grupof_inq where gf_idcopr=$cop_id and gf_idcontr=$contr_id and gf_estado=1",0);
	    }else{
		$may=@UserQuery("select sum(gf_mayor) from grupof_d where gf_idcopr=$cop_id and gf_estado=1",0);
		$men=@UserQuery("select sum(gf_menor) from grupof_d where gf_idcopr=$cop_id and gf_estado=1",0);
	    }

	    $tMay+=$may;
	    $tMen+=$men;

	    $nombre=utf8_decode(html_entity_decode(Decode($cop_nombre)));
	    $totExpensas=0;

	    $this->SetX(4);
	    $this->CellFitScale(8,$altoLn,$cop_unifun,1,0,'C',true);
	    $this->CellFitScale(50,$altoLn,$nombre,1,0,'L',true);
	    $this->CellFitScale(10,$altoLn,$may,1,0,'C',true);
	    $this->CellFitScale(10,$altoLn,$men,1,0,'C',true);

	    $quedaCols=184;
	    $estoyEn=78;

	    if($tieneVol){
		$importeVol=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo in ($cargoVol) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$quedaCols-=10;
		$estoyEn+=10;
		$totExpensas+=$importeVol;
		$tVol+=$importeVol;
		$importeVol=number_format($importeVol,2,',','.');
		$this->CellFitScale(10,$altoLn,$importeVol,1,0,'R',true);
	    }
	    $ancho=$quedaCols/$columnas;


	    for($iii=0;$iii<$fCompliquid;$iii++){
		$leyen=Resultado($qCompliquid,$iii,"leyen",1);
		$importeCl=@UserQuery("select sum(clq_importe+clq_impngi+clq_interes)::numeric(15,2) from compliq where trim(clq_leyen)=trim('$leyen') and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		$cargoCl=@UserQuery("select clq_rubcar from compliq where trim(clq_leyen)=trim('$leyen') and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		$totExpensas+=$importeCl;
		$aCliq[$iii]+=$importeCl;
		$importeCl=number_format($importeCl,2,',','.');
		$this->CellFitScale($ancho,$altoLn,$importeCl,1,0,'R',true);
	    }
	    for($kk=0;$kk<$fCompliq1;$kk++){
		$cargo=Resultado($qCompliq1,$kk,"clq_cargo",1);
		$importeCl=@UserQuery("select sum(clq_importe+clq_impngi+clq_interes)::numeric(15,2) from compliq where clq_cargo=$cargo and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		$totExpensas+=$importeCl;
		$aClq[$kk]+=$importeCl;
		$importeCl=number_format($importeCl,2,',','.');
		$this->CellFitScale($ancho,$altoLn,$importeCl,1,0,'R',true);
	    }
	    if($tieneMant){
		$importeMant=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo in ($cargoMant) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$totExpensas+=$importeMant;
		$tMant+=$importeMant;
		$importeMant=number_format($importeMant,2,',','.');
		$this->CellFitScale($ancho,$altoLn,$importeMant,1,0,'R',true);
	    }
	    if($tieneQuincho){
		$importeQuincho=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo in ($cargoQuincho) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$totExpensas+=$importeQuincho;
		$tQuin+=$importeQuincho;
		$importeQuincho=number_format($importeQuincho,2,',','.');
		$this->CellFitScale($ancho,$altoLn,$importeQuincho,1,0,'R',true);
	    }
	    if($tieneRedondeo){
		$importeRedondeo=@UserQuery("select sum(clq_impngi)::numeric(15,2) from compliq where (clq_cargo=$cargoRedondeo or clq_cargo=$cargoIduf) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$identificador=@UserQuery("select sum(clq_impngi)::numeric(15,2) from compliq where clq_cargo=$cargoIduf and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		if(!$identificador) $identificador=0;
		$totExpensas+=$importeRedondeo;
		$tRed+=$importeRedondeo;
		$importeRedondeo=number_format($importeRedondeo,2,',','.');
		$this->CellFitScale($ancho,$altoLn,$importeRedondeo,1,0,'R',true);

	    }

	    $ttot+=$totExpensas;
	    $totExpensas=number_format($totExpensas,2,',','.');
	    $this->CellFitScale(20,$altoLn,$totExpensas,1,0,'R',true);
	    $this->CellFitScale(8,$altoLn,$cop_unifun,1,0,'C',true);
	    $this->Ln($altoLn);

	    $prt++;
	    if($prt>$lineas){
		$prt=0;
		$this->AddPage();
		$this->head_det();
		$this->SetFont('Arial','',5);
	    }
	}


	$this->SetFont('Arial','B',5);
	$this->SetX(4);
	$this->SetFillColor(50,50,50);
	$this->SetTextColor(250,250,250);
	$this->Cell(58,7,'Totales',1,0,'C',true);
	$this->CellFitScale(10,7,$tMay,1,0,'C',true);
	$this->CellFitScale(10,7,$tMen,1,0,'C',true);
	if($tieneVol){
	    $tVol=number_format($tVol,2,',','.');
	    $this->CellFitScale(10,7,$tVol,1,0,'R',true);
	}
	for($iii=0;$iii<$fCompliquid;$iii++){
	    $importeCl=$aCliq[$iii];
	    $importeCl=number_format($importeCl,2,',','.');
	    $this->CellFitScale($ancho,7,$importeCl,1,0,'R',true);
	}
	for($kk=0;$kk<$fCompliq1;$kk++){
	    $importeCl=$aClq[$kk];
	    $importeCl=number_format($importeCl,2,',','.');
	    $this->CellFitScale($ancho,7,$importeCl,1,0,'R',true);
	}
	if($tieneMant){
	    $importeMant=$tMant;
	    $importeMant=number_format($importeMant,2,',','.');
	    $this->CellFitScale($ancho,7,$importeMant,1,0,'R',true);
	}
	if($tieneQuincho){
	    $importeQuincho=$tQuin;
	    $importeQuincho=number_format($importeQuincho,2,',','.');
	    $this->CellFitScale($ancho,7,$importeQuincho,1,0,'R',true);
	}
	if($tieneRedondeo){
	    $importeRedondeo=$tRed;
	    $importeRedondeo=number_format($importeRedondeo,2,',','.');
	    $this->CellFitScale($ancho,7,$importeRedondeo,1,0,'R',true);
	}

	$totExpensas=$ttot;
	$totExpensas=number_format($totExpensas,2,',','.');
	$this->CellFitScale(20,7,$totExpensas,1,0,'R',true);
	$this->Ln(7);



    }



    function res_fin(){

	global $eg_mes,$eg_anio,$eg_idptov,$codemp,$nomptv;


	if($eg_mes<10) $elmes='0'.$eg_mes; else $elmes=$eg_mes;
	$fechaini='01-'.$elmes.'-'.$eg_anio;
	if($eg_mes==12) {$elmesp=1; $elaniop=$eg_anio+1;} else {$elmesp=$eg_mes+1; $elaniop=$eg_anio;}
	if($elmesp<10) $elmesp='0'.$elmesp;
	$fechafin='01-'.$elmesp.'-'.$elaniop;


	$ash_idptov=$eg_idptov;
	$ash_codemp=$codemp;

	$eg_mes=@UserQuery("select lpad('$eg_mes',2,'0');",0);
	$cbte_ID=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPID'));",0);
	$cbte_OI=@UserQuery("select idcomp($codemp,$eg_idptov,'OI');",0);
	$cbte_OE=@UserQuery("select idcomp($codemp,$eg_idptov,'OE');",0);
	$cbte_RC=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPRC'));",0);
	$cbte_RN=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPRN'));",0);

	$cta_depsi=@UserQuery("select idcble($codemp,$eg_idptov,'CTADEPSI')",0);
	$cta_caja=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'CAJA')::smallint)",0);
	$cta_cheque=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'CHEQUE')::smallint)",0);
	$cta_deudxv=UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'DEUDXV')::smallint)",0);
	$cta_banco=@UserQuery("select idcble($codemp,$ash_idptov,'BANCO')",0);
	$tcta_banco=@UserQuery("select tipctacbl($cta_banco)",0);
	$cta_ff=@UserQuery("select idcble($codemp,$ash_idptov,'CTAFF')",0);
	$tcta_ff=@UserQuery("select tipctacbl($cta_ff)",0);
	$cta_monex=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'MONEX')::smallint)",0);
	$cta_ajuste=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'AJUSTE')::smallint)",0);
	$cta_1242=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'1242')::smallint)",0);
	$cta_1245=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'1245')::smallint)",0);

	$salant=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and codcble(astc_ctacble)<3000 and codcble(astc_ctacble)!=1500 and astc_ctacble not in ($cta_deudxv,$cta_ajuste,$cta_depsi) and date_lt(astc_fecval,'$fechaini'::date);",0);
	if(!$salant)$salant=0;
	$salant=@UserQuery("select $salant::numeric(15,2);",0);

	$ingper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_RN,$cbte_RC,$cbte_ID) and astc_ctacble in ($cta_caja,$cta_cheque,$cta_banco,$cta_ff,$cta_monex,$cta_1242,$cta_1245,$cta_depsi) and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$ingper)$ingper=0;
	$ingper=@UserQuery("select $ingper::numeric(15,2);",0);

	$oingper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_OI) and astc_importe>0 and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$oingper)$oingper=0;
	$oingper=@UserQuery("select $oingper::numeric(15,2);",0);

	$suming=$ingper+$oingper;
	if(!$suming)$suming=0;
	$suming=@UserQuery("select $suming::numeric(15,2);",0);

	$depsia=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_ctacble=$cta_depsi and date_lt(astc_fecval,'$fechaini'::date);",0);
	if(!$depsia)$depsia=0;
	$depsia=@UserQuery("select $depsia::numeric(15,2);",0);

	$depsi=@UserQuery("select sum(astc_importe)*-1 from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_ctacble=$cta_depsi and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$depsi)$depsi=0;
	$depsi=@UserQuery("select $depsi::numeric(15,2);",0);

	$sumds=$depsia+$depsi;
	if(!$sumds)$sumds=0;
	$sumds=@UserQuery("select $sumds::numeric(15,2);",0);


	$gasper=@UserQuery("select sum(eg_importe)*-1 from liqegr where eg_codemp=$codemp and eg_idptov=$eg_idptov and eg_anio=$eg_anio and eg_mes=$eg_mes and eg_estado=2;",0);
	if(!$gasper)$gasper=0;
	$gasper=@UserQuery("select $gasper::numeric(15,2);",0);

	$oegper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_OE) and astc_importe<0 and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$oegper)$oegper=0;
	$oegper=@UserQuery("select $oegper::numeric(15,2);",0);

	$sumeg=$gasper+$oegper;
	if(!$sumeg)$sumeg=0;
	$sumeg=@UserQuery("select $sumeg::numeric(15,2);",0);

	$saldo=$salant+$ingper+$oingper+$depsia+$depsi+$gasper+$oegper;
	if(!$saldo)$saldo=0;
	$saldo=@UserQuery("select $saldo::numeric(15,2);",0);


	$this->SetY(0);
	$this->Ln(1);
	$this->SetFillColor(136,174,195);
	$this->SetTextColor(0,0,0);
	$this->SetLineWidth(0.5);
	$this->SetFont('Arial','B',8);
	$this->SetX(4);
//	$this->Image('lt.jpg',$this->GetX()+10,$this->GetY()+2,40,20);
	$this->Cell(290,32,'',1,0,'C',true);
	$this->Ln(22);
	$this->Ln(-22);
	$this->Ln(1);
	$this->Cell(50);
	$this->Cell(0,6,utf8_decode(html_entity_decode('Administraci&oacute;n del Oeste')),0);
	$this->Ln(6);
	$this->Cell(50);
	$this->Cell(30,6,utf8_decode(html_entity_decode('Tel&eacute;fono: 113 059 6961')),0);
	$this->SetFont('Arial','BU',8);
	$this->Cell(0,6,'ESTA PROHIBIDO EL PAGO DE LAS EXPENSAS EN EFECTIVO',0,0,'C');
	$this->SetFont('Arial','B',8);
	$this->Ln(6);
	$this->Cell(50);
	$this->Cell(30,6,'Email: ado.lostroncos@gmail.com',0);
	$this->SetFont('Arial','BU',8);
	$this->Cell(0,6,'SOLO DEPOSITAR EN CTA CTE DEL CONSORCIO DEL BANCO SANTANDER',0,0,'C');
	$this->SetFont('Arial','B',8);
	$this->Ln(6);
	$this->Cell(50);
	$this->Cell(0,6,'Lunes a Viernes de 10 a 17hs',0);
	$this->Ln(6);
	$this->Ln(1);
	$this->SetX(4);
	$this->SetFillColor(255,255,255);
	$this->Cell(290,6,"Resumen Financiero Periodo: $eg_mes-$eg_anio",1,0,'C',true);
	$this->Ln(6);
	$this->Ln(6);

	$this->Image('lt.jpg',6,4,40,20);
	$this->Image('logo_adm.jpg',252,4,40,20);




	$salant=number_format($salant,2,',','.');
	$ingper=number_format($ingper,2,',','.');
	$oingper=number_format($oingper,2,',','.');
	$suming=number_format($suming,2,',','.');
	$depsia=number_format($depsia,2,',','.');
	$depsi=number_format($depsi,2,',','.');
	$sumds=number_format($sumds,2,',','.');
	$gasper=number_format($gasper,2,',','.');
	$oegper=number_format($oegper,2,',','.');
	$sumeg=number_format($sumeg,2,',','.');
	$saldo=number_format($saldo,2,',','.');

	$this->SetFillColor(136,174,195);
	$this->SetLineWidth(0.2);
	$this->SetFont('Arial','B',8);
	$this->Ln(8);
	$this->Cell(50);
	$this->Cell(170,7,utf8_decode(html_entity_decode('Determinaci&oacute;n de Saldos')),1,0,'C',true);
	$this->Ln(7);
	$this->SetFont('Arial','',8);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('Saldo del mes anterior')),1,0,'L');
	$this->Cell(70,5,$salant,1,0,'R');
	$this->Ln(5);
	$this->SetFont('Arial','B',8);
	$this->Cell(50);
	$this->Cell(170,5,utf8_decode(html_entity_decode('Ingresos del Per&iacute;odo')),1,0,'C',true);
	$this->Ln(5);
	$this->SetFont('Arial','',8);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('Ingresos por cobranzas')),1,0,'L');
	$this->Cell(35,5,$ingper,1,0,'R');
	$this->Cell(35,5,'',1,0,'R');
	$this->Ln(5);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('Otros Ingresos')),1,0,'L');
	$this->Cell(35,5,$oingper,1,0,'R');
	$this->Cell(35,5,'',1,0,'R');
	$this->Ln(5);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('')),1,0,'L');
	$this->Cell(35,5,'',1,0,'R');
	$this->Cell(35,5,$suming,1,0,'R');
	$this->Ln(5);
	$this->SetFont('Arial','B',8);
	$this->Cell(50);
	$this->Cell(170,5,utf8_decode(html_entity_decode('Dep&oacute;sitos sin Identificar')),1,0,'C',true);
	$this->Ln(5);
	$this->SetFont('Arial','',8);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('Dep&oacute;sitos sin identificar al cierre anterior')),1,0,'L');
	$this->Cell(35,5,$depsia,1,0,'R');
	$this->Cell(35,5,'',1,0,'R');
	$this->Ln(5);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('Dep&oacute;sitos sin identificar a la fecha')),1,0,'L');
	$this->Cell(35,5,$depsi,1,0,'R');
	$this->Cell(35,5,'',1,0,'R');
	$this->Ln(5);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('')),1,0,'L');
	$this->Cell(35,5,'',1,0,'R');
	$this->Cell(35,5,$sumds,1,0,'R');
	$this->Ln(5);
	$this->SetFont('Arial','B',8);
	$this->Cell(50);
	$this->Cell(170,5,utf8_decode(html_entity_decode('Egresos del Per&iacute;odo')),1,0,'C',true);
	$this->Ln(5);
	$this->SetFont('Arial','',8);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('Total gastos del per&iacute;odo')),1,0,'L');
	$this->Cell(35,5,$gasper,1,0,'R');
	$this->Cell(35,5,'',1,0,'R');
	$this->Ln(5);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('Otros Egresos')),1,0,'L');
	$this->Cell(35,5,$oegper,1,0,'R');
	$this->Cell(35,5,'',1,0,'R');
	$this->Ln(5);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('')),1,0,'L');
	$this->Cell(35,5,'',1,0,'R');
	$this->Cell(35,5,$sumeg,1,0,'R');
	$this->Ln(5);
	$this->SetFont('Arial','B',8);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('Saldo Actual')),1,0,'L');
	$this->Cell(70,5,$saldo,1,0,'R');
	$this->Ln(5);

	$this->SetFillColor(136,174,195);
	$this->SetLineWidth(0.2);
	$this->SetFont('Arial','B',8);
	$this->Ln(8);
	$this->Cell(50);
	$this->Cell(170,7,utf8_decode(html_entity_decode('Conformaci&oacute;n de Saldos')),1,0,'C',true);
	$this->Ln(7);
	$this->SetFont('Arial','',8);


	$Query1="select astc_ctacble,nomcble(astc_ctacble) as lacuenta,astc_tipcta,astc_ctacte,sum(astc_importe)::numeric(15,2) as lasumaastc from astoctas where 
			astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and 
			codcble(astc_ctacble)<3000 and codcble(astc_ctacble)!=1500 and astc_ctacble not in ($cta_deudxv,$cta_ajuste,$cta_depsi) and date_lt(astc_fecval,'$fechafin'::date) group by 1,2,3,4 having sum(astc_importe)!=0 order by 2,3,4;";
	$descriptor1=PgDoQuery($Query1);
	$rows2=Pg_NumRows($descriptor1);

	$lacaja=0;
	$totalastc=0;
	$imp=$cuerpocs+1;
	if($rows2>0){
	    for($j=0; $j < $rows2 ; $j++){
		$astc_ctacble=Resultado($descriptor1,$j,"astc_ctacble",1);
		$lacuenta=Resultado($descriptor1,$j,"lacuenta",1);
		$codcbl=@UserQuery("select cbl_codigo from ctacble where cbl_id=$astc_ctacble",0);
		$lasumaastc=Resultado($descriptor1,$j,"lasumaastc",1);
		$astc_ctacte=Resultado($descriptor1,$j,"astc_ctacte",1);
		$astc_tipcta=Resultado($descriptor1,$j,"astc_tipcta",1);
		if($astc_tipcta && $astc_ctacte)
		    $lacuenta=UserQuery("select tct_nombre||' - '||cte_nombre from ctes,tipcta where tct_codigo=cte_tipcta and cte_id=$astc_ctacte;",0);
		$totalastc+=$lasumaastc;
		if($astc_ctacble==$cta_caja || $astc_ctacble==$cta_1242 || $astc_ctacble==$cta_1245){
		    $lacaja+=$lasumaastc;
		}else{
		    $lasumaastc=number_format($lasumaastc,2,',','.');
		    $this->Cell(50);
		    $this->Cell(100,5,utf8_decode(html_entity_decode($lacuenta)),1,0,'L');
		    $this->Cell(70,5,$lasumaastc,1,0,'R');
		    $this->Ln(5);
		}
	    }
	    $lacaja=number_format($lacaja,2,',','.');
	    $this->Cell(50);
	    $this->Cell(100,5,utf8_decode(html_entity_decode('CAJA ADMINISTRACI&Oacute;N')),1,0,'L');
	    $this->Cell(70,5,$lacaja,1,0,'R');
	    $this->Ln(5);
	}

	$totalastc=number_format($totalastc,2,',','.');
	$this->SetFont('Arial','B',8);
	$this->Cell(50);
	$this->Cell(100,5,utf8_decode(html_entity_decode('Saldo Actual')),1,0,'L');
	$this->Cell(70,5,$totalastc,1,0,'R');
	$this->Ln(5);



    }

    function gastos(){

	global $eg_mes,$eg_anio,$eg_idptov,$codemp,$nomptv;


	if($eg_mes<10) $elmes='0'.$eg_mes; else $elmes=$eg_mes;
	$fechaini='01-'.$elmes.'-'.$eg_anio;
	if($eg_mes==12) {$elmesp=1; $elaniop=$eg_anio+1;} else {$elmesp=$eg_mes+1; $elaniop=$eg_anio;}
	if($elmesp<10) $elmesp='0'.$elmesp;
	$fechafin='01-'.$elmesp.'-'.$elaniop;


	$ash_idptov=$eg_idptov;
	$ash_codemp=$codemp;
	if(!$eg_centroc)
	    $eg_centroc=@UserQuery("select cco_id from centroc where cco_codemp=$codemp and cco_idptov=$eg_idptov limit 1;",0);
	if(!$eg_division)
	    $eg_division=@UserQuery("select cco_coddiv from centroc where cco_codemp=$codemp and cco_idptov=$eg_idptov limit 1;",0);


	$eg_mes=@UserQuery("select lpad('$eg_mes',2,'0');",0);
	$cbte_ID=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPID'));",0);
	$cbte_OI=@UserQuery("select idcomp($codemp,$eg_idptov,'OI');",0);
	$cbte_OE=@UserQuery("select idcomp($codemp,$eg_idptov,'OE');",0);
	$cbte_RC=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPRC'));",0);
	$cbte_RN=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPRN'));",0);

	$cta_depsi=@UserQuery("select idcble($codemp,$eg_idptov,'CTADEPSI')",0);
	$cta_caja=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'CAJA')::smallint)",0);
	$cta_cheque=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'CHEQUE')::smallint)",0);
	$cta_deudxv=UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'DEUDXV')::smallint)",0);
	$cta_banco=@UserQuery("select idcble($codemp,$ash_idptov,'BANCO')",0);
	$tcta_banco=@UserQuery("select tipctacbl($cta_banco)",0);
	$cta_ff=@UserQuery("select idcble($codemp,$ash_idptov,'CTAFF')",0);
	$tcta_ff=@UserQuery("select tipctacbl($cta_ff)",0);
	$cta_monex=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'MONEX')::smallint)",0);
	$cta_ajuste=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'AJUSTE')::smallint)",0);
	$cta_1242=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'1242')::smallint)",0);
	$cta_1245=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'1245')::smallint)",0);

	$salant=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and codcble(astc_ctacble)<3000 and codcble(astc_ctacble)!=1500 and astc_ctacble not in ($cta_deudxv,$cta_ajuste,$cta_depsi) and date_lt(astc_fecval,'$fechaini'::date);",0);
	if(!$salant)$salant=0;
	$salant=@UserQuery("select $salant::numeric(15,2);",0);

	$ingper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_RN,$cbte_RC,$cbte_ID) and astc_ctacble in ($cta_caja,$cta_cheque,$cta_banco,$cta_ff,$cta_monex,$cta_1242,$cta_1245,$cta_depsi) and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$ingper)$ingper=0;
	$ingper=@UserQuery("select $ingper::numeric(15,2);",0);

	$oingper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_OI) and astc_importe>0 and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$oingper)$oingper=0;
	$oingper=@UserQuery("select $oingper::numeric(15,2);",0);

	$suming=$ingper+$oingper;
	if(!$suming)$suming=0;
	$suming=@UserQuery("select $suming::numeric(15,2);",0);

	$depsia=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_ctacble=$cta_depsi and date_lt(astc_fecval,'$fechaini'::date);",0);
	if(!$depsia)$depsia=0;
	$depsia=@UserQuery("select $depsia::numeric(15,2);",0);

	$depsi=@UserQuery("select sum(astc_importe)*-1 from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_ctacble=$cta_depsi and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$depsi)$depsi=0;
	$depsi=@UserQuery("select $depsi::numeric(15,2);",0);

	$sumds=$depsia+$depsi;
	if(!$sumds)$sumds=0;
	$sumds=@UserQuery("select $sumds::numeric(15,2);",0);


	$gasper=@UserQuery("select sum(eg_importe)*-1 from liqegr where eg_codemp=$codemp and eg_idptov=$eg_idptov and eg_anio=$eg_anio and eg_mes=$eg_mes and eg_estado=2;",0);
	if(!$gasper)$gasper=0;
	$gasper=@UserQuery("select $gasper::numeric(15,2);",0);

	$oegper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_OE) and astc_importe<0 and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$oegper)$oegper=0;
	$oegper=@UserQuery("select $oegper::numeric(15,2);",0);

	$sumeg=$gasper+$oegper;
	if(!$sumeg)$sumeg=0;
	$sumeg=@UserQuery("select $sumeg::numeric(15,2);",0);

	$saldo=$salant+$ingper+$oingper+$depsia+$depsi+$gasper+$oegper;
	if(!$saldo)$saldo=0;
	$saldo=@UserQuery("select $saldo::numeric(15,2);",0);


	$this->SetFont('Arial','',8);
	$this->SetFillColor(136,174,195);
	$this->SetLineWidth(0.2);

	$Query="select eg_rubro,eg_subrub,eg_importe,eg_leyen,eg_tipgto,eg_id,eg_idastoh from liqegr where eg_codemp=$codemp and eg_idptov=$eg_idptov and eg_anio=$eg_anio and eg_mes=$eg_mes and eg_centro=$eg_centroc and eg_division=$eg_division and eg_estado=2 order by 1,2;";
	$descriptor=PgDoQuery($Query);
	$rows1=Pg_NumRows($descriptor);

	$liquidagastos=@UserQuery("select ptv_liqgs from ptovta where ptv_id=$eg_idptov;",0);
	$cantTgs=PgDoQuery("select distinct eg_tipgto from liqegr where eg_codemp=$codemp and eg_idptov=$eg_idptov and eg_anio=$eg_anio and eg_mes=$eg_mes and eg_centro=$eg_centroc and eg_division=$eg_division and eg_estado=2 order by 1;");
	$filTgs=pg_numRows($cantTgs);

	$lineas=55;
	$altoLn=4;
	$prt=0;
	
	$sumeg*=-1;
	if($rows1>0){
	    $sumaeg=0;
	    $rubroact=0;
	    $srubroact=0;
	    $totrub=0;
	    for($i=0; $i < $rows1 ; $i++){
		$noanul=0;
		$eg_id=Resultado($descriptor,$i,"eg_id",1);
		$tipgto=Resultado($descriptor,$i,"eg_tipgto",1);
		$rubro=Resultado($descriptor,$i,"eg_rubro",1);
		$eg_rubro=@UserQuery("select rub_nombre from rubros where rub_id=$rubro",0);
		$subrub=Resultado($descriptor,$i,"eg_subrub",1);
		$eg_subrub=@UserQuery("select srb_nombre from subrub where srb_id=$subrub",0);
		$eg_importe=Resultado($descriptor,$i,"eg_importe",1);
		$eg_leyen=(Resultado($descriptor,$i,"eg_leyen",1));
		$eg_idastoh=Resultado($descriptor,$i,"eg_idastoh",1);
		$quer="select * from gtoxliqe where gxl_liqegr=$eg_id order by gxl_gasto asc;";
		$desc=PgDoQuery($quer);
		$row=Pg_NumRows($desc);
		$noanul=$row;
		$sumaeg+=$eg_importe;
		if($rubro!=$rubroact){
		    if($totrub!=0){
			$totrub=@UserQuery("select $totrub::numeric(15,2);",0);
			$porc=$totrub/$sumeg*100;
			$tporc+=$porc;
			$totrub=number_format($totrub,2,',','.');
			$porc=number_format($porc,2,',','.');
			$this->SetFont('Arial','B',8);
			$this->Cell(20,$altoLn,$totrub,1,0,'R');
			$this->Cell(20,$altoLn,$porc,1,0,'R');
			$this->Ln($altoLn);
			$this->SetFont('Arial','',8);
			$prt++;
		    }
		    $totrub=0;
		    $this->SetFont('Arial','B',8);
		    $this->Cell(190,7,utf8_decode(html_entity_decode($eg_rubro)),1,0,'L',true);
		    $this->SetFont('Arial','',8);
		    $this->Ln(7);
		    $prt++;
		    $this->Cell(20,$altoLn,utf8_decode(html_entity_decode('Fecha')),1,0,'L',true);
		    $this->Cell(110,$altoLn,utf8_decode(html_entity_decode('Concepto')),1,0,'L',true);
		    $this->Cell(20,$altoLn,utf8_decode(html_entity_decode('Importe')),1,0,'L',true);
		    $this->Cell(20,$altoLn,utf8_decode(html_entity_decode('Total')),1,0,'L',true);
		    $this->Cell(20,$altoLn,utf8_decode(html_entity_decode('%')),1,0,'L',true);
		    $this->Ln($altoLn);
		    $prt++;
		}else{
		    $this->Cell(20,$altoLn,utf8_decode(html_entity_decode('')),1,0,'L');
		    $this->Cell(20,$altoLn,utf8_decode(html_entity_decode('')),1,0,'L');
		    $this->Ln($altoLn);
		    $prt++;
		    if($prt>$lineas){
			$prt=0;
			$this->AddPage('P');
			$this->h_gastos();
			$this->SetFont('Arial','',8);
			$this->SetFillColor(136,174,195);
			$this->SetLineWidth(0.2);

			$this->SetFont('Arial','B',8);
			$this->Cell(190,7,utf8_decode(html_entity_decode($eg_rubro)),1,0,'L',true);
			$this->SetFont('Arial','',8);
			$this->Ln(7);
			$prt++;
			$this->Cell(20,$altoLn,utf8_decode(html_entity_decode('Fecha')),1,0,'L',true);
			$this->Cell(110,$altoLn,utf8_decode(html_entity_decode('Concepto')),1,0,'L',true);
			$this->Cell(20,$altoLn,utf8_decode(html_entity_decode('Importe')),1,0,'L',true);
			$this->Cell(20,$altoLn,utf8_decode(html_entity_decode('Total')),1,0,'L',true);
			$this->Cell(20,$altoLn,utf8_decode(html_entity_decode('%')),1,0,'L',true);
			$this->Ln($altoLn);
			$prt++;
		    }
		}
		$totrub+=$eg_importe;

		for($p=0;$p<$row;$p++){
		    $gasto_id=Resultado($desc,$p,"gxl_gasto",1);
		    $gasto_estado=@UserQuery("select gto_estado from gastos where gto_id=$gasto_id",0);
		    if($gasto_estado==999)
			$noanul--;
		}
		if($noanul==1){
		    for($p=0;$p<$row;$p++){
			$gasto_id=Resultado($desc,$p,"gxl_gasto",1);
			$gasto_estado=@UserQuery("select gto_estado from gastos where gto_id=$gasto_id",0);
			if($gasto_estado!=999)
			    $gto_id=$gasto_id;
		    }
		    $eg_fecval=@UserQuery("select gto_fecval from gastos where gto_id=$gto_id",0);
		}else if($noanul>1){
		    $gto_id=Resultado($desc,0,"gxl_gasto",1);
		    $eg_fecval=@UserQuery("select gto_fecval from gastos where gto_id=$gto_id",0);
		}
		$eg_estado=@UserQuery("select eg_estado from liqegr where eg_id=$eg_id;",0);
		$ley=($eg_leyen);
		if($eg_estado!=999){
		    $eg_importe=number_format($eg_importe,2,',','.');
		    $this->Cell(20,$altoLn,utf8_decode(html_entity_decode($eg_fecval)),1,0,'C');
		    $this->CellFitScale(110,$altoLn,utf8_decode(html_entity_decode($ley)),1,0,'L');
		    $this->Cell(20,$altoLn,utf8_decode(html_entity_decode($eg_importe)),1,0,'R');
		    $rubroact=$rubro;
		}
	    }

	    if($totrub!=0){
		$totrub=@UserQuery("select $totrub::numeric(15,2);",0);
		$porc=$totrub/$sumeg*100;
		$tporc+=$porc;
		$totrub=number_format($totrub,2,',','.');
		$porc=number_format($porc,2,',','.');
		$this->SetFont('Arial','B',8);
		$this->Cell(20,$altoLn,$totrub,1,0,'R');
		$this->Cell(20,$altoLn,$porc,1,0,'R');
		$this->Ln($altoLn);
		$this->SetFont('Arial','',8);
	    }
	    $this->SetFillColor(62,102,123);
	    $this->SetTextColor(255,255,255);
	    $sumaeg=number_format($sumaeg,2,',','.');
	    $tporc=number_format($tporc,2,',','.');
	    $this->SetFont('Arial','B',8);
	    $this->Cell(150,7,utf8_decode(html_entity_decode('Total Gastos')),1,0,'L',true);
	    $this->Cell(20,7,$sumaeg,1,0,'R',true);
	    $this->Cell(20,7,$tporc,1,0,'R',true);
	    $this->SetFont('Arial','',8);
	    $this->Ln(7);
	}

    }


    function h_gastos(){

	global $eg_mes,$eg_anio,$eg_idptov,$codemp,$nomptv;


	if($eg_mes<10) $elmes='0'.$eg_mes; else $elmes=$eg_mes;
	$fechaini='01-'.$elmes.'-'.$eg_anio;
	if($eg_mes==12) {$elmesp=1; $elaniop=$eg_anio+1;} else {$elmesp=$eg_mes+1; $elaniop=$eg_anio;}
	if($elmesp<10) $elmesp='0'.$elmesp;
	$fechafin='01-'.$elmesp.'-'.$elaniop;


	$ash_idptov=$eg_idptov;
	$ash_codemp=$codemp;

	$eg_mes=@UserQuery("select lpad('$eg_mes',2,'0');",0);

	$this->SetY(0);
	$this->Ln(1);
	$this->SetFillColor(136,174,195);
	$this->SetTextColor(0,0,0);
	$this->SetLineWidth(0.5);
	$this->SetFont('Arial','B',8);
	$this->SetX(4);
//	$this->Image('lt.jpg',$this->GetX()+10,$this->GetY()+2,40,20);
	$this->Cell(203,32,'',1,0,'C',true);
	$this->Ln(22);
	$this->Ln(-22);
	$this->Ln(1);
	$this->Cell(80);
	$this->Cell(0,6,utf8_decode(html_entity_decode('Administraci&oacute;n del Oeste')),0);
	$this->Ln(6);
	$this->Cell(80);
	$this->Cell(30,6,utf8_decode(html_entity_decode('Tel&eacute;fono: 113 059 6961')),0);
	$this->SetFont('Arial','BU',8);
//	$this->Cell(0,6,'ESTA PROHIBIDO EL PAGO DE LAS EXPENSAS EN EFECTIVO',0,0,'C');
	$this->SetFont('Arial','B',8);
	$this->Ln(6);
	$this->Cell(80);
	$this->Cell(30,6,'Email: ado.lostroncos@gmail.com',0);
	$this->SetFont('Arial','BU',8);
//	$this->Cell(0,6,'SOLO DEPOSITAR EN CTA CTE DEL CONSORCIO DEL BANCO SANTANDER',0,0,'C');
	$this->SetFont('Arial','B',8);
	$this->Ln(6);
	$this->Cell(80);
	$this->Cell(0,6,'Lunes a Viernes de 10 a 17hs',0);
	$this->Ln(6);
	$this->Ln(1);
	$this->SetX(4);
	$this->SetFillColor(255,255,255);
	$this->Cell(203,6,"Detalle de Gastos Periodo: $eg_mes-$eg_anio",1,0,'C',true);
	$this->Ln(6);
	$this->Ln(6);

	$this->Image('lt.jpg',6,4,40,20);
	$this->Image('logo_adm.jpg',160,4,40,20);



    }



    function dis(){

	global $eg_mes,$eg_anio,$eg_idptov,$codemp,$nomptv,$feccie;


	if($eg_mes<10) $elmes='0'.$eg_mes; else $elmes=$eg_mes;
	$fechaini='01-'.$elmes.'-'.$eg_anio;
	if($eg_mes==12) {$elmesp=1; $elaniop=$eg_anio+1;} else {$elmesp=$eg_mes+1; $elaniop=$eg_anio;}
	if($elmesp<10) $elmesp='0'.$elmesp;
	$fechafin='01-'.$elmesp.'-'.$elaniop;

	$ash_idptov=$eg_idptov;
	$ash_codemp=$codemp;
	if(!$eg_centroc)
	    $eg_centroc=@UserQuery("select cco_id from centroc where cco_codemp=$codemp and cco_idptov=$eg_idptov limit 1;",0);
	if(!$eg_division)
	    $eg_division=@UserQuery("select cco_coddiv from centroc where cco_codemp=$codemp and cco_idptov=$eg_idptov limit 1;",0);

	$eg_mes=@UserQuery("select lpad('$eg_mes',2,'0');",0);

	$ash_idptov=$eg_idptov;
	$ash_centro=$eg_centroc;
	$ash_division=$eg_division;

	$comprobdi=@UserQuery("select valvaramb($ash_codemp,$ash_idptov,'CMPDI')",0);
	if(!$comprobdi)
	    $comprobdi=@UserQuery("select valvaramb($ash_codemp,0,'CMPDI')",0);
	$compbtedi=@UserQuery("select idcomp($ash_codemp,$ash_idptov,'$comprobdi')",0);
	if(!$compbtedi)
	    $compbtedi=@UserQuery("select idcomp($ash_codemp,0,'$comprobdi')",0);

	$comprobid=@UserQuery("select valvaramb($ash_codemp,$ash_idptov,'CMPID')",0);
	if(!$comprobid)
	    $comprobid=@UserQuery("select valvaramb($ash_codemp,0,'CMPID')",0);
	$compbteid=@UserQuery("select idcomp($ash_codemp,$ash_idptov,'$comprobid')",0);
	if(!$compbteid)
	    $compbteid=@UserQuery("select idcomp($ash_codemp,0,'$comprobid')",0);



	$this->SetY(0);
	$this->Ln(1);
	$this->SetFillColor(136,174,195);
	$this->SetTextColor(0,0,0);
	$this->SetLineWidth(0.5);
	$this->SetFont('Arial','B',8);
	$this->SetX(4);
//	$this->Image('lt.jpg',$this->GetX()+10,$this->GetY()+2,40,20);
	$this->Cell(203,32,'',1,0,'C',true);
	$this->Ln(22);
	$this->Ln(-22);
	$this->Ln(1);
	$this->Cell(80);
	$this->Cell(0,6,utf8_decode(html_entity_decode('Administraci&oacute;n del Oeste')),0);
	$this->Ln(6);
	$this->Cell(80);
	$this->Cell(30,6,utf8_decode(html_entity_decode('Tel&eacute;fono: 113 059 6961')),0);
	$this->SetFont('Arial','BU',8);
//	$this->Cell(0,6,'ESTA PROHIBIDO EL PAGO DE LAS EXPENSAS EN EFECTIVO',0,0,'C');
	$this->SetFont('Arial','B',8);
	$this->Ln(6);
	$this->Cell(80);
	$this->Cell(30,6,'Email: ado.lostroncos@gmail.com',0);
	$this->SetFont('Arial','BU',8);
//	$this->Cell(0,6,'SOLO DEPOSITAR EN CTA CTE DEL CONSORCIO DEL BANCO SANTANDER',0,0,'C');
	$this->SetFont('Arial','B',8);
	$this->Ln(6);
	$this->Cell(80);
	$this->Cell(0,6,'Lunes a Viernes de 10 a 17hs',0);
	$this->Ln(6);
	$this->Ln(1);
	$this->SetX(4);
	$this->SetFillColor(255,255,255);
	$this->Cell(203,6,utf8_decode(html_entity_decode("Dep&oacute;sitos sin Identificar Periodo: $eg_mes-$eg_anio")),1,0,'C',true);
	$this->Ln(6);
	$this->Ln(6);

	$this->Image('lt.jpg',6,4,40,20);
	$this->Image('logo_adm.jpg',160,4,40,20);

	$bcos=PgDoQuery("select cte_id,cte_nombre from ctes where cte_codemp=$codemp and cte_tipcta=1 and cte_idptov=$eg_idptov;",0);
	$fbcos=pg_numRows($bcos);
	$altoLn=4;
	for($k=0;$k<$fbcos;$k++){
	    $astc_ctacte=Resultado($bcos,$k,"cte_id",1);
	    $nombco=Resultado($bcos,$k,"cte_nombre",1);
	    $Query="select * from astoctas a where astc_numero not in (select astc_numero from astoctas where astc_idptov=$ash_idptov and astc_estado=2 and astc_comprob=$compbteid and astc_fecval<='$feccie') 
			    and astc_codemp=$codemp and astc_comprob=$compbtedi and astc_idptov=$ash_idptov and astc_ctacte=$astc_ctacte and astc_tipcta=1 and astc_estado=2 and astc_fecval<='$feccie' order by astc_fecvto;";
	    $descriptor=PgDoQuery($Query);
	    $rows1=Pg_NumRows($descriptor);
	    if($rows1){
		$this->SetFont('Arial','',8);
		$this->SetFillColor(136,174,195);
		$this->SetLineWidth(0.2);

		$this->SetFont('Arial','B',8);
		$this->Cell(50);
		$this->Cell(90,7,utf8_decode(html_entity_decode('Banco: '.$nombco)),1,0,'C',true);
		$this->SetFont('Arial','',8);
		$this->Ln(7);
		$this->Cell(50);
		$this->Cell(30,$altoLn,utf8_decode(html_entity_decode('Fecha')),1,0,'C',true);
		$this->Cell(30,$altoLn,utf8_decode(html_entity_decode('Importe')),1,0,'C',true);
		$this->Cell(30,$altoLn,utf8_decode(html_entity_decode('Comprobante')),1,0,'C',true);
		$this->Ln($altoLn);

		for($m=0;$m<$rows1;$m++){
		    $id=Resultado($descriptor,$m,"astc_id",1);
		    $astc_numero=Resultado($descriptor,$m,"astc_numero",1);
		    $astc_fecvto=Resultado($descriptor,$m,"astc_fecvto",1);
		    $astc_importe=Resultado($descriptor,$m,"astc_importe",1);
		    $astc_fecvto=@UserQuery("select '$astc_fecvto'::date;",0);

		    $astc_importe=number_format($astc_importe,2,',','.');

		    $this->Cell(50);
		    $this->Cell(30,$altoLn,utf8_decode(html_entity_decode($astc_fecvto)),1,0,'C');
		    $this->Cell(30,$altoLn,$astc_importe,1,0,'R');
		    $this->Cell(30,$altoLn,utf8_decode(html_entity_decode($comprobdi.' - '.$astc_numero)),1,0,'C');
		    $this->Ln($altoLn);
		}
	    }
	}





    }







}


$pdf=new PDF('L','mm','A4');
//BORRO PDF's ANTERIORES
exec("./borropdf.sh");
$pdf->SetAuthor('CatWare - Soluciones Informaticas');
$pdf->SetCreator('CatWare - Soluciones Informaticas');
$pdf->SetTitle('CatWare - Soluciones Informaticas');
$pdf->SetSubject('CatWare - Soluciones Informaticas');
$pdf->SetFont('Arial','',14);
$pdf->SetAutoPageBreak(false);

$pdf->AddPage();
$pdf->head_simp();
$pdf->body_simp();

$pdf->AddPage();
$pdf->head_det();
$pdf->body_det();

$pdf->AddPage();
$pdf->res_fin();

$pdf->AddPage('P');
$pdf->h_gastos();
$pdf->gastos();

$pdf->AddPage('P');
$pdf->dis();



$math=rand(0,100);
$file = 'Lq.pdf';
$file=str_replace("\/","-",$file);
$pdf->Output($file,'I');
//header('Location: '.$file);






break;






case 'EXCEL':


	if(!$codemp)
	    $existe=@UserQuery("select emp_codigo from empresa where emp_codigo=$astc_codemp",0);

	if(!$existe && !$codemp)
		$mensaje='La Empresa Definida no Existe Utilize la Busqueda';

	if($mensaje)
	    {
	    echo("<BR></BR>");
	    echo(" <CENTER><H3> <Caption class=\"text\">$mensaje</Caption></H3></CENTER>\n");
	    echo("<BR></BR>");
	    echo("<CENTER><A HREF=\"javascript:history.go(-1)\">Volver</A></CENTER>");
	    exit();
	    } 

	$fecha = date("d-;m-Y");
	$nomemp=UserQuery("select nomemp($astc_codemp)",0);
	$nomptv=UserQuery("select nomptv($elidptov)",0);
	$clq_comprob=@UserQuery("select idcomp($codemp,$elidptov,valvaramb($codemp,$elidptov,'CMPQL'));",0);

	$eg_codemp=$codemp;
	$eg_idptov=$elidptov;

	$cta_depsi=@UserQuery("select idcble($codemp,$elidptov,'CTADEPSI')",0);
	$cta_caja=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'CAJA')::smallint)",0);
	$cta_cheque=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'CHEQUE')::smallint)",0);
	$cta_deudxv=UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'DEUDXV')::smallint)",0);
	$cta_banco=@UserQuery("select idcble($codemp,$elidptov,'BANCO')",0);
	$tcta_banco=@UserQuery("select tipctacbl($cta_banco)",0);
	$cta_ff=@UserQuery("select idcble($codemp,$elidptov,'CTAFF')",0);
	$tcta_ff=@UserQuery("select tipctacbl($cta_ff)",0);
	$cta_monex=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'MONEX')::smallint)",0);
	$cta_ajuste=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'AJUSTE')::smallint)",0);
	$cta_1242=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'1242')::smallint)",0);
	$cta_1245=@UserQuery("select idcbl($codemp,$elidptov,valvaramb($codemp,$elidptov,'1245')::smallint)",0);
	$cargoCesped=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOCESPED')",0);
	$cargoEnergia=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOENERGIA')",0);
	$cargoFEventos=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOFEVENTOS')",0);
	$cargoFamiliar=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOFAMILIAR')",0);
	$cargoRedondeo=@UserQuery("select valvaramb($codemp,$elidptov,'REDONDEO')",0);
	$cargoIduf=@UserQuery("select valvaramb($codemp,$elidptov,'IDUF')",0);
	$cargoInteres=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOINT')",0);
	$cargoQuincho=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOHOUSE')",0);
	$cargoReserva=@UserQuery("select valvaramb($codemp,$elidptov,'CARGORESERVA')",0);
	$cargoMant=@UserQuery("select valvaramb($codemp,$elidptov,'CARGOMANT')",0);
	$rubcarord=@UserQuery("select valvaramb($codemp,$astc_idptov,'RUBROORDINARIAS')");

	$qLiq=PgDoQuery("select l_id,l_comprob,l_numero,l_fecvto,l_feccie from liquidacion where l_idptov=$elidptov and l_feccie<='$fechah' and l_estado=2 order by 1 desc limit 1;");
	$rLiq=pg_numRows($qLiq);
	if($rLiq){
	    $idliq=Resultado($qLiq,0,"l_id",1);
	    $comprob=Resultado($qLiq,0,"l_comprob",1);
	    $numero=Resultado($qLiq,0,"l_numero",1);
	    $fecvto=Resultado($qLiq,0,"l_fecvto",1);
	    $feccie=Resultado($qLiq,0,"l_feccie",1);
	}
	$mes=@UserQuery("select date_part('month','$feccie'::date);",0);
	$anio=@UserQuery("select date_part('year','$feccie'::date);",0);

	$eg_mes=$mes;
	$eg_anio=$anio;
	$qCompliqCar=PgDoQuery("select distinct(cl_cargo) as cargo,cl_tipo from compliquid where cl_idliq=$idliq and cl_tipo not in (4) order by cl_tipo");
	$fCompliqCar=pg_numRows($qCompliqCar);
	for($jjj=0;$jjj<$fCompliqCar;$jjj++){
	    $cargoCompliquid=Resultado($qCompliqCar,$jjj,"cargo",1);
	    if($jjj==0)
		$cargosProrrata=$cargoCompliquid;
	    else
		$cargosProrrata.=",".$cargoCompliquid;
	}
	if(!$cargosProrrata) $cargosProrrata=-10;

	$columnas=11;
	$tieneDescuf=@UserQuery("select count(distinct(cop_descuf)) from coprop where cop_descuf!='NN' and cop_descuf!='1' and cop_descuf!=cop_unifun::varchar and cop_idptov=$elidptov;",0);
	$aplicaDescuento=@UserQuery("select ptv_aplicadesc from ptovta where ptv_id=$elidptov;",0);
	$tieneRedondeo=@UserQuery("select sum(clq_impngi) from compliq where (clq_cargo=$cargoRedondeo or clq_cargo=$cargoIduf) and clq_idliq=$idliq",0);
	$tieneQuincho=@UserQuery("select sum(clq_importe) from compliq where clq_cargo in ($cargoQuincho) and clq_idliq=$idliq",0);
	$tieneMant=@UserQuery("select sum(clq_importe) from compliq where clq_cargo in ($cargoMant) and clq_idliq=$idliq",0);

	if($tieneDescuf!=0)$columnas=$columnas+2;
	if($aplicaDescuento==3)$columnas=$columnas+2; else $columnas++;
	if($tieneRedondeo)$columnas++;
	if($tieneQuincho)$columnas++;
	if($tieneMant)$columnas++;
	$qCompliquid=PgDoQuery("select distinct(trim(cl_leyen)) as leyen,cl_tipo from compliquid where cl_idliq=$idliq and cl_tipo not in (4) order by leyen asc");
	$fCompliquid=pg_numRows($qCompliquid);
	for($iii=0;$iii<$fCompliquid;$iii++){
	    $columnas++;
	}
	$qCompliq=PgDoQuery("select distinct clq_cargo,car_orden from compliq,cargos where clq_idliq=$idliq and clq_cargo=car_id and clq_cargo not in ($cargoMant,$cargoQuincho,$cargosProrrata,$cargoRedondeo,$cargoIduf) and (clq_importe!=0 or clq_impngi!=0) order by 2,1;");
	$fCompliq=pg_numRows($qCompliq);
	for($kk=0;$kk<$fCompliq;$kk++){
	    $columnas++;
	}

	$encabezadoBarrio=@UserQuery("select lpt_link from logosptv where lpt_idptov=$elidptov and lpt_tipo=2",0);

	$filename="Liq. $nomptv $mes-$anio.xls";
	header("Content-type: application/vnd.ms-excel");
	header("Content-Disposition: attachment; filename=$filename" );
	header("Expires: 0");
	header("Cache-Control: must-revalidate, post-check=0,pre-check=0");
	header("Pragma: public");


	$workbook = new Workbook("-");
	$worksheet1 =& $workbook->add_worksheet("GRILLA");

	// letra 10, negrita, fondo azul
	$workbook->set_custom_color(12, 217, 217, 217);
	$encabezado =& $workbook->add_format();
	$encabezado->set_size(10);
	$encabezado->set_align('center');
	$encabezado->set_align('vcenter');
	$encabezado->set_bold();
	$encabezado->set_color('black');
	$encabezado->set_pattern();
	$encabezado->set_fg_color('white');
	$encabezado->set_border(2);
	$encabezado->set_text_wrap();

	$encabezado1 =& $workbook->add_format();
	$encabezado1->set_size(10);
	$encabezado1->set_align('center');
	$encabezado1->set_align('vcenter');
	$encabezado1->set_bold();
	$encabezado1->set_color('white');
	$encabezado1->set_pattern();
	$encabezado1->set_fg_color('black');
	$encabezado1->set_border(2);
//	$encabezado1->set_right_color('white');
//	$encabezado1->set_left_color('white');
	$encabezado1->set_text_wrap();

	$encabezado2 =& $workbook->add_format();
	$encabezado2->set_size(10);
	$encabezado2->set_align('left');
	$encabezado2->set_align('vcenter');
	$encabezado2->set_bold();
	$encabezado2->set_color('white');
	$encabezado2->set_pattern();
	$encabezado2->set_fg_color('black');
	$encabezado2->set_border(2);
//	$encabezado2->set_right_color('white');
//	$encabezado2->set_left_color('white');
	$encabezado2->set_text_wrap();

	$encabezado3 =& $workbook->add_format();
	$encabezado3->set_size(10);
	$encabezado3->set_align('left');
	$encabezado3->set_align('vcenter');
	$encabezado3->set_bold();
	$encabezado3->set_color('black');
	$encabezado3->set_pattern();
	$encabezado3->set_fg_color('white');
	$encabezado3->set_border(2);
	$encabezado3->set_text_wrap();

	$titulos =& $workbook->add_format();
	$titulos->set_size(12);
	$titulos->set_align('center');
	$titulos->set_bold();
	$titulos->set_border(2);
	$titulos->set_pattern();
	$titulos->set_fg_color('white');

	$numero5 =& $workbook->add_format();
	$numero5->set_size(10);
	$numero5->set_align('right');
	$numero5->set_pattern();
	$numero5->set_fg_color('white');
	$numero5->set_border(1);
//	$numero5->set_num_format('0.00000');

	$numero5c =& $workbook->add_format();
	$numero5c->set_size(10);
	$numero5c->set_align('right');
	$numero5c->set_pattern();
	$numero5c->set_fg_color(12);
	$numero5c->set_border(1);
//	$numero5c->set_num_format('0.00000');


	$numero =& $workbook->add_format();
	$numero->set_size(10);
	$numero->set_align('right');
	$numero->set_pattern();
	$numero->set_fg_color('white');
	$numero->set_border(1);
	$numero->set_num_format('0.00');

	$numerorb =& $workbook->add_format();
	$numerorb->set_size(10);
	$numerorb->set_align('right');
	$numerorb->set_pattern();
	$numerorb->set_fg_color('white');
	$numerorb->set_right(1);
	$numerorb->set_num_format('0.00');

	$numerorba =& $workbook->add_format();
	$numerorba->set_size(10);
	$numerorba->set_align('right');
	$numerorba->set_pattern();
	$numerorba->set_fg_color('white');
	$numerorba->set_right(1);
	$numerorba->set_bottom(1);
	$numerorba->set_num_format('0.00');


	$numeroc =& $workbook->add_format();
	$numeroc->set_size(10);
	$numeroc->set_align('right');
	$numeroc->set_pattern();
	$numeroc->set_fg_color(12);
	$numeroc->set_border(1);
	$numeroc->set_num_format('0.00');

	$cuerpo =& $workbook->add_format();
	$cuerpo->set_size(10);
	$cuerpo->set_align('left');
	$cuerpo->set_pattern();
	$cuerpo->set_fg_color('white');
	$cuerpo->set_border(1);

	$cuerpoc =& $workbook->add_format();
	$cuerpoc->set_size(10);
	$cuerpoc->set_align('left');
	$cuerpoc->set_pattern();
	$cuerpoc->set_fg_color(12);
	$cuerpoc->set_border(1);

	$cuerpoz =& $workbook->add_format();
	$cuerpoz->set_size(9);
	$cuerpoz->set_align('center');
	$cuerpoz->set_align('vcenter');
	$cuerpoz->set_fg_color('white');
	$cuerpoz->set_border(1);
	$cuerpoz->set_text_wrap();

	$cuerpocen =& $workbook->add_format();
	$cuerpocen->set_size(10);
	$cuerpocen->set_align('center');
	$cuerpocen->set_pattern();
	$cuerpocen->set_fg_color('white');
	$cuerpocen->set_border(1);

	$cuerpocenc =& $workbook->add_format();
	$cuerpocenc->set_size(10);
	$cuerpocenc->set_align('center');
	$cuerpocenc->set_pattern();
	$cuerpocenc->set_fg_color(12);
	$cuerpocenc->set_border(1);

	$cabez=1;
	$intro=5;
	$cuerpo1=9;

	$mes=@UserQuery("select lpad('$mes',2,'0');",0);
	$worksheet1->write_string($intro,0, "$nomptv Liquidacion del mes de $mes-$anio",$titulos);
	for($kk=1;$kk<$columnas;$kk++){
	    $worksheet1->write_blank($intro,$kk,$titulos);
	}
	$worksheet1->merge_cells($intro,0,$intro,$columnas-1);

	$nCol=0;
	$worksheet1->write_string($cuerpo1-2, $nCol,'UF',$encabezado1);
	$worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	$worksheet1->set_column($nCol,$nCol,5);
	$nCol++;
	if($tieneDescuf!=0){
	    $worksheet1->write_string($cuerpo1-2, $nCol,'Desc. UF',$encabezado1);
	    $worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	    $worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	    $worksheet1->set_column($nCol,$nCol,30);
	    $nCol++;
	}
	$worksheet1->write_string($cuerpo1-2, $nCol,'Propietario',$encabezado1);
	$worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	$worksheet1->set_column($nCol,$nCol,42);
	$nCol++;

	$worksheet1->write_string($cuerpo1-2, $nCol,'Mayores',$encabezado1);
	$worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	$worksheet1->set_column($nCol,$nCol,8);
	$nCol++;

	$worksheet1->write_string($cuerpo1-2, $nCol,'Menores',$encabezado1);
	$worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	$worksheet1->set_column($nCol,$nCol,8);
	$nCol++;

	$worksheet1->write_string($cuerpo1-2, $nCol,'%',$encabezado1);
	$worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	$worksheet1->set_column($nCol,$nCol,6);
	$nCol++;

	$worksheet1->write_string($cuerpo1-2, $nCol,'SALDOS ANTERIORES',$encabezado1);
	$worksheet1->write_blank($cuerpo1-2,$nCol+1,$encabezado1);
	$worksheet1->write_blank($cuerpo1-2,$nCol+2,$encabezado1);
	$worksheet1->write_blank($cuerpo1-2,$nCol+3,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1-2,$nCol+3);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	$worksheet1->write_blank($cuerpo1,$nCol+1,$encabezado);
	$worksheet1->write_blank($cuerpo1,$nCol+2,$encabezado);
	$worksheet1->write_blank($cuerpo1,$nCol+3,$encabezado);
	$worksheet1->set_column($nCol,$nCol+3,12);

	$worksheet1->write_string($cuerpo1-1, $nCol,'Sal. Ant.',$encabezado);
	$worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	$nCol++;
	$worksheet1->write_string($cuerpo1-1, $nCol,'Ajustes',$encabezado);
	$worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	$nCol++;
	$worksheet1->write_string($cuerpo1-1, $nCol,'Pagos',$encabezado);
	$worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	$nCol++;
	$worksheet1->write_string($cuerpo1-1, $nCol,'Importe Mora',$encabezado);
	$worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	$nCol++;
	$nColInicial=$nCol;
	$worksheet1->write_string($cuerpo1-2, $nCol,'CARGOS DEL PERIODO',$encabezado1);
	$worksheet1->write_blank($cuerpo1, $nCol,$encabezado);
	$worksheet1->write_string($cuerpo1-1, $nCol,'Interes Mora',$encabezado);
	$worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	$nCol++;
	for($iii=0;$iii<$fCompliquid;$iii++){
	    $leyen=ucwords(strtolower(Resultado($qCompliquid,$iii,"leyen",1)));
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,$leyen,$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $worksheet1->set_column($nCol,$nCol,12);
	    $nCol++;
	}
	for($kk=0;$kk<$fCompliq;$kk++){
	    $carn=Resultado($qCompliq,$kk,"clq_cargo",1);
	    $leyen=ucwords(strtolower(@UserQuery("select car_leyen from cargos where car_id=$carn",0)));
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,$leyen,$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $worksheet1->set_column($nCol,$nCol,12);
	    $nCol++;
	}
	if($tieneMant){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Mant x Lote / Trab. Tarifado / Tarj. Acceso',$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $worksheet1->set_column($nCol,$nCol,22);
	    $nCol++;
	}
	if($tieneQuincho){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Alquiler SUM / Quincho',$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $worksheet1->set_column($nCol,$nCol,16);
	    $nCol++;
	}
	if($tieneRedondeo){
	    $worksheet1->write_blank($cuerpo1-2,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado);
	    $worksheet1->write_string($cuerpo1-1, $nCol,'Redondeo',$encabezado);
	    $worksheet1->merge_cells($cuerpo1-1,$nCol,$cuerpo1,$nCol);
	    $worksheet1->set_column($nCol,$nCol,10);
	    $nCol++;
	}
	$worksheet1->merge_cells($cuerpo1-2,$nColInicial,$cuerpo1-2,$nCol-1);
	if($aplicaDescuento==3){
	    $fecint=@UserQuery("select date_part('day',l_fecvto) from liquidacion where l_id=$idliq",0);
	    $worksheet1->write_string($cuerpo1-2, $nCol,'Total A Pagar Antes del '."$fecint",$encabezado1);
	    $worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	    $worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	    $worksheet1->set_column($nCol,$nCol,15);
	    $nCol++;
	    $worksheet1->write_string($cuerpo1-2, $nCol,'Total A Pagar Despues del '."$fecint",$encabezado1);
	    $worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	    $worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	    $worksheet1->set_column($nCol,$nCol,15);
	    $nCol++;
	}else{
	    $worksheet1->write_string($cuerpo1-2, $nCol,'Total',$encabezado1);
	    $worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	    $worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	    $worksheet1->set_column($nCol,$nCol,15);
	    $nCol++;
	}
	if($tieneDescuf!=0){
	    $worksheet1->write_string($cuerpo1-2, $nCol,'Desc. UF',$encabezado1);
	    $worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	    $worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	    $worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	    $worksheet1->set_column($nCol,$nCol,30);
	    $nCol++;
	}
	$worksheet1->write_string($cuerpo1-2, $nCol,'UF',$encabezado1);
	$worksheet1->write_blank($cuerpo1-1,$nCol,$encabezado1);
	$worksheet1->write_blank($cuerpo1,$nCol,$encabezado1);
	$worksheet1->merge_cells($cuerpo1-2,$nCol,$cuerpo1,$nCol);
	$worksheet1->set_column($nCol,$nCol,5);
	$nCol++;

	$columnas=$nCol;
	$worksheet1->repeat_rows(1,$cuerpo1);
	$worksheet1->set_landscape();
	$worksheet1->fit_to_pages(1,0);


	$fechaini=@UserQuery("select '01-'||lpad(date_part('month','$feccie'::date)::text,2,'0')||'-'||date_part('Y','$feccie'::date);",0);

	$tsalant=$tcobran=$tajus=$tsaldo=$tcargos=0;


	$query="select * from coprop 
			where cop_codemp=$codemp and cop_idptov=$elidptov and cop_estado!=3 order by cop_unifun;";
	$r=PgDoQuery($query);
	$rows=pg_NumRows($r);
	$leyenCargos=array();
	$indexCargos=0;
	$desde=$cuerpo1+1;
	for($i=0; $i < $rows ; $i++){
	    $nCol=0;
	    $salant=$cobran=$ajus=$saldo=$cargos=$totlinea=0;
	    $cop_id=Resultado($r,$i,"cop_id",1);
	    $cop_unifun=Resultado($r,$i,"cop_unifun",1);
	    $cop_descuf=Resultado($r,$i,"cop_descuf",1);
	    $cop_nombre=Resultado($r,$i,"cop_nombre",1);
	    $cop_porc=Resultado($r,$i,"cop_porc1",1);

//	    $cop_nombre=utf8_decode($cop_nombre);

	    $cero=@UserQuery("select 0::numeric(15,2);",0);
	    $salant=@UserQuery("select sum(astc_importe)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado=2 and astc_ctacble=$cta_deudxv and astc_tipcta=99 and astc_ctacte=$cop_id and date_lt(astc_fecval,'$fechaini'::date);",0);
	    if(!$salant)$salant=$cero;
	    $ajus=@UserQuery("select sum(astc_importe)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado=2 and astc_ctacble=$cta_ajuste and astc_ctacte=$cop_id and date_ge(astc_fecval,'$fechaini'::date) and date_le(astc_fecval,'$feccie'::date);",0);
	    $aj2=@UserQuery("select sum(astc_importe)::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado=2 and codcble(astc_ctacble)>2999 and codcble(astc_ctacble)<4000 and astc_ctacte=$cop_id and date_ge(astc_fecval,'$fechaini'::date) and date_le(astc_fecval,'$feccie'::date);",0);
	    if($aj2) $ajus+=$aj2;
	    if(!$ajus)$ajus=$cero;
	    $cobran=@UserQuery("select (sum(astc_importe*-1)-($ajus))::numeric(15,2) from astoctas where astc_codemp=$codemp and astc_idptov=$elidptov and astc_estado!=999 and astc_ctacte=$cop_id and astc_comprob!=10 and astc_ctacble=$cta_deudxv and date_ge(astc_fecval,'$fechaini'::date) and date_le(astc_fecval,'$feccie'::date);",0);
	    if(!$cobran)$cobran=$cero;
	    $saldo=$salant-$ajus-$cobran;
	    $saldo=@UserQuery("select $saldo::numeric(15,2);",0);

	    $intmora=@UserQuery("select sum(clq_interes)::numeric(15,2) from compliq where clq_idcopr=$cop_id and clq_idliq=$idliq and clq_estado=2",0);
	    if(!$intmora) $intmora=$cero;

	    if($ajus!=0)
		$ajus*=-1;

	    if($i%2==0){
		$fnum=$numeroc;
		$flet=$cuerpoc;
		$fletcent=$cuerpocenc;
		$fuf=$numero5c;
	    }else{
		$fnum=$numero;
		$flet=$cuerpo;
		$fletcent=$cuerpocen;
		$fuf=$numero5;
	    }

	    $tsalant+=$salant;
	    $tcobran+=$cobran;
	    $tajus+=$ajus;
	    $tsaldo+=$saldo;
	    $tintmora+=$intmora;

	    $contr_id=@UserQuery("select ct_id from contratos where ct_idcopr=$cop_id and ct_estado=1 and date_le(ct_inicio,'$feccie'::date)",0);
	    if($contr_id){
		$may=@UserQuery("select sum(gf_mayor) from grupof_inq where gf_idcopr=$cop_id and gf_idcontr=$contr_id and gf_estado=1",0);
		$men=@UserQuery("select sum(gf_menor) from grupof_inq where gf_idcopr=$cop_id and gf_idcontr=$contr_id and gf_estado=1",0);
	    }else{
		$may=@UserQuery("select sum(gf_mayor) from grupof_d where gf_idcopr=$cop_id and gf_estado=1",0);
		$men=@UserQuery("select sum(gf_menor) from grupof_d where gf_idcopr=$cop_id and gf_estado=1",0);
	    }

//	    if(!$may) $may="-";
//	    if(!$men) $men="-";

	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$cop_unifun",$fuf);
	    $nCol++;
	    if($tieneDescuf!=0){
		$worksheet1->write_string($cuerpo1+1+$i, $nCol,"$cop_descuf",$flet);
		$nCol++;
	    }

	    $nombre=(html_entity_decode(Decode($cop_nombre)));
	    $worksheet1->write_string($cuerpo1+1+$i, $nCol,"$nombre",$flet);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$may",$flet);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$men",$flet);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$cop_porc",$fnum);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$salant",$fnum);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$ajus",$fnum);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$cobran",$fnum);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$saldo",$fnum);
	    $nCol++;
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$intmora",$fnum);
	    $nCol++;

	    $totlinea=$saldo+$intmora;
	    $totlineaAnt=$saldo+$intmora;

	    $totExpensas=0;
	    for($iii=0;$iii<$fCompliquid;$iii++){
		$leyen=Resultado($qCompliquid,$iii,"leyen",1);
		$importeCl=@UserQuery("select sum(clq_importe+clq_impngi+clq_interes)::numeric(15,2) from compliq where trim(clq_leyen)=trim('$leyen') and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		$cargoCl=@UserQuery("select clq_rubcar from compliq where trim(clq_leyen)=trim('$leyen') and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		if($cargoCl==$rubcarord){
		    $totExpensas+=$importeCl;
		}else{
		    $totlineaAnt+=$importeCl;
		}
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeCl",$fnum);
		$nCol++;
		$totlinea+=$importeCl;
	    }
	    for($kk=0;$kk<$fCompliq;$kk++){
		$cargo=Resultado($qCompliq,$kk,"clq_cargo",1);
		$importeCl=@UserQuery("select sum(clq_importe+clq_impngi+clq_interes)::numeric(15,2) from compliq where clq_cargo=$cargo and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2;");
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeCl",$fnum);
		$nCol++;
		$totlinea+=$importeCl;
		$totlineaAnt+=$importeCl;
	    }
	    if($tieneMant){
		$importeMant=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo in ($cargoMant) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeMant",$fnum);
		$nCol++;
		$totlinea+=$importeMant;
		$totlineaAnt+=$importeMant;
	    }
	    if($tieneQuincho){
		$importeQuincho=@UserQuery("select sum(clq_importe)::numeric(15,2) from compliq where clq_cargo in ($cargoQuincho) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeQuincho",$fnum);
		$nCol++;
		$totlinea+=$importeQuincho;
		$totlineaAnt+=$importeQuincho;
	    }
	    if($tieneRedondeo){
		$importeRedondeo=@UserQuery("select sum(clq_impngi)::numeric(15,2) from compliq where (clq_cargo=$cargoRedondeo or clq_cargo=$cargoIduf) and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		$identificador=@UserQuery("select sum(clq_impngi)::numeric(15,2) from compliq where clq_cargo=$cargoIduf and clq_idliq=$idliq and clq_idcopr=$cop_id and clq_estado=2",0);
		if(!$identificador) $identificador=0;
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$importeRedondeo",$fnum);
		$nCol++;
		$totlinea+=$importeRedondeo;
	    }
	    if($aplicaDescuento==3){
		$tasaDescuento=@UserQuery("select int_valor from interes where int_idptov=$elidptov and int_tipo=2 order by int_fecha desc limit 1");
		if(!$tasaDescuento) $tasaDescuento=10;
		$importeExp=($totExpensas*((100-$tasaDescuento)/100))+$totlineaAnt;
		$importeFinalExpensas=round($importeExp)+$identificador;
		$totlineaAnt=$importeFinalExpensas;
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$totlineaAnt",$fnum);
		$nCol++;
	        $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$totlinea",$fnum);
		$nCol++;
	    }else{
		$worksheet1->write_number($cuerpo1+1+$i, $nCol,"$totlinea",$fnum);
		$nCol++;
	    }
	    if($tieneDescuf!=0){
		$worksheet1->write_string($cuerpo1+1+$i, $nCol,"$cop_descuf",$flet);
		$nCol++;
	    }
	    $worksheet1->write_number($cuerpo1+1+$i, $nCol,"$cop_unifun",$fuf);
	    $nCol++;
	}
	$hasta=$cuerpo1+$rows+1;

	if($tieneDescuf!=0){
	    $empiezo=3;
	    $fin=$columnas-2;
	}else{
	    $empiezo=2;
	    $fin=$columnas-1;
	}
	for($l=$empiezo; $l < $fin ; $l++){
	    $ini=columna_exc($l);
	    $inicio=$ini.$desde;
	    $final=$ini.$hasta;
	    if($l<27)
		$worksheet1->write_formula($hasta, $l,  "= SUM($inicio:$final)",$numero);
	    else
		if($l==27)
		    $worksheet1->write_formula($hasta, $l,"=SUM(BA$desde:BA$hasta)",$numero);
		else
		    if($l==28)
			$worksheet1->write_formula($hasta, $l,  "= SUM(CA$desde:CA$hasta)",$numero);
		    else
			if($l==29)
			    $worksheet1->write_formula($hasta, $l,  "= SUM(DA$desde:DA$hasta)",$numero);
			else
			    if($l==30)
				$worksheet1->write_formula($hasta, $l,  "= SUM(EA$desde:EA$hasta)",$numero);
			    else
				if($l==31)
				    $worksheet1->write_formula($hasta, $l,  "= SUM(FA$desde:FA$hasta)",$numero);
				else
				    if($l==32)
					$worksheet1->write_formula($hasta, $l,  "= SUM(GA$desde:GA$hasta)",$numero);
	}






	//RESUMEN FINANCIERO


	if($eg_mes<10) $elmes='0'.$eg_mes; else $elmes=$eg_mes;
	$fechaini='01-'.$elmes.'-'.$eg_anio;
	if($eg_mes==12) {$elmesp=1; $elaniop=$eg_anio+1;} else {$elmesp=$eg_mes+1; $elaniop=$eg_anio;}
	if($elmesp<10) $elmesp='0'.$elmesp;
	$fechafin='01-'.$elmesp.'-'.$elaniop;

	$ash_idptov=$eg_idptov;
	$ash_codemp=$codemp;

	$eg_mes=@UserQuery("select lpad('$eg_mes',2,'0');",0);
	$cbte_ID=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPID'));",0);
	$cbte_OI=@UserQuery("select idcomp($codemp,$eg_idptov,'OI');",0);
	$cbte_OE=@UserQuery("select idcomp($codemp,$eg_idptov,'OE');",0);
	$cbte_RC=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPRC'));",0);
	$cbte_RN=@UserQuery("select idcomp($codemp,$eg_idptov,valvaramb($codemp,$eg_idptov,'CMPRN'));",0);

	$cta_depsi=@UserQuery("select idcble($codemp,$eg_idptov,'CTADEPSI')",0);
	$cta_caja=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'CAJA')::smallint)",0);
	$cta_cheque=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'CHEQUE')::smallint)",0);
	$cta_deudxv=UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'DEUDXV')::smallint)",0);
	$cta_banco=@UserQuery("select idcble($codemp,$ash_idptov,'BANCO')",0);
	$tcta_banco=@UserQuery("select tipctacbl($cta_banco)",0);
	$cta_ff=@UserQuery("select idcble($codemp,$ash_idptov,'CTAFF')",0);
	$tcta_ff=@UserQuery("select tipctacbl($cta_ff)",0);
	$cta_monex=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'MONEX')::smallint)",0);
	$cta_ajuste=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'AJUSTE')::smallint)",0);
	$cta_1242=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'1242')::smallint)",0);
	$cta_1245=@UserQuery("select idcbl($codemp,$ash_idptov,valvaramb($ash_codemp,$ash_idptov,'1245')::smallint)",0);

	$salant=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and codcble(astc_ctacble)<3000 and codcble(astc_ctacble)!=1500 and astc_ctacble not in ($cta_deudxv,$cta_ajuste,$cta_depsi) and date_lt(astc_fecval,'$fechaini'::date);",0);
	if(!$salant)$salant=0;
	$salant=@UserQuery("select $salant::numeric(15,2);",0);

	$ingper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_RN,$cbte_RC,$cbte_ID) and astc_ctacble in ($cta_caja,$cta_cheque,$cta_banco,$cta_ff,$cta_monex,$cta_1242,$cta_1245,$cta_depsi) and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$ingper)$ingper=0;
	$ingper=@UserQuery("select $ingper::numeric(15,2);",0);

	$oingper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_OI) and astc_importe>0 and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$oingper)$oingper=0;
	$oingper=@UserQuery("select $oingper::numeric(15,2);",0);

	$suming=$ingper+$oingper;
	if(!$suming)$suming=0;
	$suming=@UserQuery("select $suming::numeric(15,2);",0);

	$depsia=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_ctacble=$cta_depsi and date_lt(astc_fecval,'$fechaini'::date);",0);
	if(!$depsia)$depsia=0;
	$depsia=@UserQuery("select $depsia::numeric(15,2);",0);

	$depsi=@UserQuery("select sum(astc_importe)*-1 from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_ctacble=$cta_depsi and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$depsi)$depsi=0;
	$depsi=@UserQuery("select $depsi::numeric(15,2);",0);

	$sumds=$depsia+$depsi;
	if(!$sumds)$sumds=0;
	$sumds=@UserQuery("select $sumds::numeric(15,2);",0);


	$gasper=@UserQuery("select sum(eg_importe)*-1 from liqegr where eg_codemp=$codemp and eg_idptov=$eg_idptov and eg_anio=$eg_anio and eg_mes=$eg_mes and eg_estado=2;",0);
	if(!$gasper)$gasper=0;
	$gasper=@UserQuery("select $gasper::numeric(15,2);",0);

	$oegper=@UserQuery("select sum(astc_importe) from astoctas where astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and astc_comprob in ($cbte_OE) and astc_importe<0 and date_ge(astc_fecval,'$fechaini'::date) and date_lt(astc_fecval,'$fechafin'::date);",0);
	if(!$oegper)$oegper=0;
	$oegper=@UserQuery("select $oegper::numeric(15,2);",0);

	$sumeg=$gasper+$oegper;
	if(!$sumeg)$sumeg=0;
	$sumeg=@UserQuery("select $sumeg::numeric(15,2);",0);

	$saldo=$salant+$ingper+$oingper+$depsia+$depsi+$gasper+$oegper;
	if(!$saldo)$saldo=0;
	$saldo=@UserQuery("select $saldo::numeric(15,2);",0);

	$worksheet2 =& $workbook->add_worksheet("Resumen Financiero");
	$intro1=1;
	$cuerpods=3;
	$worksheet2->set_column(0,0,80);
	$worksheet2->set_column(1,2,20);

	$numeroenc =& $workbook->add_format();
	$numeroenc->set_size(10);
	$numeroenc->set_align('right');
	$numeroenc->set_align('vcenter');
	$numeroenc->set_bold();
	$numeroenc->set_color('black');
	$numeroenc->set_pattern();
	$numeroenc->set_fg_color('white');
	$numeroenc->set_border(2);
	$numeroenc->set_num_format('0.00');


	$worksheet2->write_string($intro1,0, "$nomptv Resumen Financiero Periodo:  $eg_mes-$eg_anio",$titulos);
	$worksheet2->write_blank($intro1,1,$titulos);
	$worksheet2->write_blank($intro1,2,$titulos);
	$worksheet2->merge_cells($intro1,0,$intro1,2);

	$worksheet2->write_string($cuerpods, 0,'Determinacion de Saldos',$encabezado1);
	$worksheet2->write_blank($cuerpods,1,$encabezado1);
	$worksheet2->write_blank($cuerpods,2,$encabezado1);
	$worksheet2->merge_cells($cuerpods,0,$cuerpods,2);

	$worksheet2->write_string($cuerpods+1, 0,'Saldo mes anterior',$cuerpo);
	$worksheet2->write_number($cuerpods+1,1,"$salant",$numero);
	$worksheet2->write_blank($cuerpods+1,2,$numero);
	$worksheet2->merge_cells($cuerpods+1,1,$cuerpods+1,2);

	$worksheet2->write_string($cuerpods+2, 0,'Ingresos del Periodo',$encabezado3);
	$worksheet2->write_blank($cuerpods+2,1,$encabezado3);
	$worksheet2->write_blank($cuerpods+2,2,$encabezado3);
	$worksheet2->merge_cells($cuerpods+2,0,$cuerpods+2,2);

	$worksheet2->write_string($cuerpods+3, 0,'Ingresos por cobranzas',$cuerpo);
	$worksheet2->write_number($cuerpods+3,1,"$ingper",$numero);
	$worksheet2->write_blank($cuerpods+3,2,$numero);

	$worksheet2->write_string($cuerpods+4, 0,'Otros Ingresos',$cuerpo);
	$worksheet2->write_number($cuerpods+4,1,"$oingper",$numero);
	$worksheet2->write_blank($cuerpods+4,2,$numero);

	$worksheet2->write_blank($cuerpods+5,0,$numero);
	$worksheet2->write_blank($cuerpods+5,1,$numero);
	$worksheet2->write_number($cuerpods+5,2,"$suming",$numero);
	$worksheet2->merge_cells($cuerpods+5,0,$cuerpods+5,1);

	$worksheet2->write_string($cuerpods+6, 0,'Depositos Sin Identificar',$encabezado3);
	$worksheet2->write_blank($cuerpods+6,1,$encabezado3);
	$worksheet2->write_blank($cuerpods+6,2,$encabezado3);
	$worksheet2->merge_cells($cuerpods+6,0,$cuerpods+6,2);

	$worksheet2->write_string($cuerpods+7, 0,'Depositos sin identificar al cierre anterior',$cuerpo);
	$worksheet2->write_number($cuerpods+7,1,"$depsia",$numero);
	$worksheet2->write_blank($cuerpods+7,2,$numero);

	$worksheet2->write_string($cuerpods+8, 0,'Depositos sin identificar a la fecha',$cuerpo);
	$worksheet2->write_number($cuerpods+8,1,"$depsi",$numero);
	$worksheet2->write_blank($cuerpods+8,2,$numero);

	$worksheet2->write_blank($cuerpods+9,0,$numero);
	$worksheet2->write_blank($cuerpods+9,1,$numero);
	$worksheet2->write_number($cuerpods+9,2,"$sumds",$numero);
	$worksheet2->merge_cells($cuerpods+9,0,$cuerpods+9,1);

	$worksheet2->write_string($cuerpods+10, 0,'Egresos del Periodo',$encabezado3);
	$worksheet2->write_blank($cuerpods+10,1,$encabezado3);
	$worksheet2->write_blank($cuerpods+10,2,$encabezado3);
	$worksheet2->merge_cells($cuerpods+10,0,$cuerpods+10,2);

	$worksheet2->write_string($cuerpods+11, 0,'Total gastos del periodo',$cuerpo);
	$worksheet2->write_number($cuerpods+11,1,"$gasper",$numero);
	$worksheet2->write_blank($cuerpods+11,2,$numero);

	$worksheet2->write_string($cuerpods+12, 0,'Otros egresos del periodo',$cuerpo);
	$worksheet2->write_number($cuerpods+12,1,"$oegper",$numero);
	$worksheet2->write_blank($cuerpods+12,2,$numero);

	$worksheet2->write_blank($cuerpods+13,0,$numero);
	$worksheet2->write_blank($cuerpods+13,1,$numero);
	$worksheet2->write_number($cuerpods+13,2,"$sumeg",$numero);
	$worksheet2->merge_cells($cuerpods+13,0,$cuerpods+13,1);

	$worksheet2->write_string($cuerpods+14,0,'Saldo Actual',$encabezado3);
	$worksheet2->write_blank($cuerpods+14,1,$encabezado3);
	$worksheet2->write_number($cuerpods+14,2,"$saldo",$numeroenc);
	$worksheet2->merge_cells($cuerpods+14,0,$cuerpods+14,1);

	$cuerpocs=$cuerpods+16;

	$worksheet2->write_string($cuerpocs, 0,'Conformacion de Saldos',$encabezado1);
	$worksheet2->write_blank($cuerpocs,1,$encabezado1);
	$worksheet2->write_blank($cuerpocs,2,$encabezado1);
	$worksheet2->merge_cells($cuerpocs,0,$cuerpocs,2);

	$Query1="select astc_ctacble,nomcble(astc_ctacble) as lacuenta,astc_tipcta,astc_ctacte,sum(astc_importe)::numeric(15,2) as lasumaastc from astoctas where 
			astc_codemp=$codemp and astc_idptov=$eg_idptov and astc_estado=2 and 
			codcble(astc_ctacble)<3000 and codcble(astc_ctacble)!=1500 and astc_ctacble not in ($cta_deudxv,$cta_ajuste,$cta_depsi) and date_lt(astc_fecval,'$fechafin'::date) group by 1,2,3,4 having sum(astc_importe)!=0 order by 2,3,4;";
	$descriptor1=PgDoQuery($Query1);
	$rows2=Pg_NumRows($descriptor1);

	$lacaja=0;
	$totalastc=0;
	$imp=$cuerpocs+1;
	if($rows2>0){
	    for($j=0; $j < $rows2 ; $j++){
		$astc_ctacble=Resultado($descriptor1,$j,"astc_ctacble",1);
		$lacuenta=Resultado($descriptor1,$j,"lacuenta",1);
		$lasumaastc=Resultado($descriptor1,$j,"lasumaastc",1);
		$astc_ctacte=Resultado($descriptor1,$j,"astc_ctacte",1);
		$astc_tipcta=Resultado($descriptor1,$j,"astc_tipcta",1);
		if($astc_tipcta && $astc_ctacte)
		    $lacuenta=UserQuery("select tct_nombre||' - '||cte_nombre from ctes,tipcta where tct_codigo=cte_tipcta and cte_id=$astc_ctacte;",0);
		$totalastc+=$lasumaastc;
		if($astc_ctacble==$cta_caja || $astc_ctacble==$cta_1242 || $astc_ctacble==$cta_1245){
		    $lacaja+=$lasumaastc;
		}else{
		    $worksheet2->write_string($imp, 0,"$lacuenta",$cuerpo);
		    $worksheet2->write_number($imp,1,"$lasumaastc",$numero);
		    $worksheet2->write_blank($imp,2,$numero);
		    $worksheet2->merge_cells($imp,1,$imp,2);
		    $imp++;
		}
	    }
	    $worksheet2->write_string($imp, 0,'CAJA ADMINISTRACION',$cuerpo);
	    $worksheet2->write_number($imp,1,"$lacaja",$numero);
	    $worksheet2->write_blank($imp,2,$numero);
	    $worksheet2->merge_cells($imp,1,$imp,2);
	    $imp++;
	}

	$worksheet2->write_string($imp,0,'Saldo Actual',$encabezado3);
	$worksheet2->write_blank($imp,1,$encabezado3);
	$worksheet2->write_number($imp,2,"$totalastc",$numeroenc);
	$worksheet2->merge_cells($imp,0,$imp,1);
	$imp++;

	$cuerpocf=$imp+1;

	$worksheet22 =& $workbook->add_worksheet("Gastos");
	$worksheet22->set_column(0,0,12);
	$worksheet22->set_column(1,1,70);
	$worksheet22->set_column(2,4,20);
	$imprimo=$cuerpogs=1;


	if(!$eg_centroc)
	    $eg_centroc=@UserQuery("select cco_id from centroc where cco_codemp=$codemp and cco_idptov=$eg_idptov limit 1;",0);
	if(!$eg_division)
	    $eg_division=@UserQuery("select cco_coddiv from centroc where cco_codemp=$codemp and cco_idptov=$eg_idptov limit 1;",0);

	$worksheet22->write_string($imprimo, 0,'Detalle de gastos del Periodo',$encabezado1);
	$worksheet22->write_blank($imprimo,1,$encabezado1);
	$worksheet22->write_blank($imprimo,2,$encabezado1);
	$worksheet22->write_blank($imprimo,3,$encabezado1);
	$worksheet22->write_blank($imprimo,4,$encabezado1);
	$worksheet22->merge_cells($imprimo,0,$imprimo,4);
	$imprimo+=2;

	$worksheet22->write_string($imprimo, 0,'Fecha',$encabezado);
	$worksheet22->write_string($imprimo, 1,'Concepto',$encabezado);
	$worksheet22->write_string($imprimo, 2,'Importe',$encabezado);
	$worksheet22->write_string($imprimo, 3,'Total',$encabezado);
	$worksheet22->write_blank($imprimo,4,$encabezado);
	$imprimo++;

	$sumeg*=-1;
	$Query="select eg_rubro,eg_subrub,eg_importe,eg_leyen,eg_id,eg_idastoh from liqegr where eg_codemp=$eg_codemp and eg_idptov=$eg_idptov and eg_anio=$eg_anio and eg_mes=$eg_mes and eg_centro=$eg_centroc and eg_division=$eg_division and eg_estado=2 order by 1,2;";
	$descriptor=PgDoQuery($Query);
	$rows1=Pg_NumRows($descriptor);
	if($rows1>0){
	    $sumaeg=0;
	    $rubroact=0;
	    $srubroact=0;
	    $totrub=0;
	    for($i=0; $i < $rows1 ; $i++){
		$noanul=0;
		$eg_id=Resultado($descriptor,$i,"eg_id",1);
		$rubro=Resultado($descriptor,$i,"eg_rubro",1);
		$eg_rubro=@UserQuery("select rub_nombre from rubros where rub_id=$rubro",0);
		$subrub=Resultado($descriptor,$i,"eg_subrub",1);
		$eg_subrub=@UserQuery("select srb_nombre from subrub where srb_id=$subrub",0);
		$eg_importe=Resultado($descriptor,$i,"eg_importe",1);
		$eg_leyen=Resultado($descriptor,$i,"eg_leyen",1);
		$eg_idastoh=Resultado($descriptor,$i,"eg_idastoh",1);
		$quer="select * from gtoxliqe where gxl_liqegr=$eg_id order by gxl_gasto asc;";
		$desc=PgDoQuery($quer);
		$row=Pg_NumRows($desc);
		$noanul=$row;
		$sumaeg+=$eg_importe;

		for($p=0;$p<$row;$p++){
		    $gasto_id=Resultado($desc,$p,"gxl_gasto",1);
		    $gasto_estado=@UserQuery("select gto_estado from gastos where gto_id=$gasto_id",0);
		    if($gasto_estado==999)
			$noanul--;
		}
		if($noanul==1){
		    for($p=0;$p<$row;$p++){
			$gasto_id=Resultado($desc,$p,"gxl_gasto",1);
			$gasto_estado=@UserQuery("select gto_estado from gastos where gto_id=$gasto_id",0);
			if($gasto_estado!=999)
			    $gto_id=$gasto_id;
		    }
		    $eg_fecval=@UserQuery("select gto_fecval from gastos where gto_id=$gto_id",0);
		}else if($noanul>1){
		    $gto_id=Resultado($desc,0,"gxl_gasto",1);
		    $eg_fecval=@UserQuery("select gto_fecval from gastos where gto_id=$gto_id",0);
		}



		if($rubro!=$rubroact){
		    if($totrub!=0){
			$totrub=@UserQuery("select $totrub::numeric(15,2);",0);
			$worksheet22->write_number($imprimo-1, 3,"$totrub",$numerorba);
			$porc=$totrub/$sumeg*100;
			$worksheet22->write_number($imprimo-1, 4,"$porc",$numerorba);
		    }
		    $totrub=0;
		    $worksheet22->write_string($imprimo, 0,"Rubro: $eg_rubro",$encabezado2);
		    $worksheet22->write_blank($imprimo,1,$encabezado2);
		    $worksheet22->write_blank($imprimo,2,$encabezado2);
		    $worksheet22->write_blank($imprimo,3,$encabezado2);
		    $worksheet22->write_blank($imprimo,4,$encabezado2);
		    $worksheet22->merge_cells($imprimo,0,$imprimo,2);
		    $imprimo++;
		}
		$totrub+=$eg_importe;
		for($p=0;$p<$row;$p++){
		    $gasto_id=Resultado($desc,$p,"gxl_gasto",1);
		    $gasto_estado=@UserQuery("select gto_estado from gastos where gto_id=$gasto_id",0);
		    if($gasto_estado==999)
			$noanul--;
		}

		$ley=utf8_decode($eg_leyen);
		$eg_estado=@UserQuery("select eg_estado from liqegr where eg_id=$eg_id;",0);
		if($eg_estado!=999){
		    $worksheet22->write_string($imprimo, 0,"$eg_fecval",$cuerpo);
		    $worksheet22->write_string($imprimo, 1,"$ley",$cuerpo);
		    $worksheet22->write_number($imprimo, 2,"$eg_importe",$numero);
		    $worksheet22->write_blank($imprimo, 3,$cuerpo);
		    $worksheet22->write_blank($imprimo, 4,$cuerpo);
		    $imprimo++;
		    $rubroact=$rubro;
		}
	    }
	    if($totrub!=0){
		$totrub=@UserQuery("select $totrub::numeric(15,2);",0);
		$worksheet22->write_number($imprimo-1, 3,"$totrub",$numerorba);
		$porc=$totrub/$sumeg*100;
		$worksheet22->write_number($imprimo-1, 4,"$porc",$numerorba);
		$imprimo++;
	    }

	    $worksheet22->write_string($imprimo, 0,"Total Gastos: ",$encabezado);
	    $worksheet22->write_blank($imprimo, 1,$encabezado);
	    $worksheet22->write_number($imprimo, 2,"$sumaeg",$numeroenc);
	    $worksheet22->write_blank($imprimo, 3,$encabezado);
	    $worksheet22->write_blank($imprimo, 4,$encabezado);
	    $imprimo++;
	}




    $ash_idptov=$eg_idptov;
    $ash_centro=$eg_centroc;
    $ash_division=$eg_division;

    $comprobdi=@UserQuery("select valvaramb($ash_codemp,$ash_idptov,'CMPDI')",0);
    if(!$comprobdi)
	$comprobdi=@UserQuery("select valvaramb($ash_codemp,0,'CMPDI')",0);
    $compbtedi=@UserQuery("select idcomp($ash_codemp,$ash_idptov,'$comprobdi')",0);
    if(!$compbtedi)
	$compbtedi=@UserQuery("select idcomp($ash_codemp,0,'$comprobdi')",0);

    $comprobid=@UserQuery("select valvaramb($ash_codemp,$ash_idptov,'CMPID')",0);
    if(!$comprobid)
	$comprobid=@UserQuery("select valvaramb($ash_codemp,0,'CMPID')",0);
    $compbteid=@UserQuery("select idcomp($ash_codemp,$ash_idptov,'$comprobid')",0);
    if(!$compbteid)
	$compbteid=@UserQuery("select idcomp($ash_codemp,0,'$comprobid')",0);


	$worksheet3 =& $workbook->add_worksheet("Depsi");
	$worksheet3->set_column(0,0,25);
	$worksheet3->set_column(1,1,45);
	$worksheet3->set_column(2,2,25);

	$intro=1;
	$cuerpoexc=3;

	$worksheet3->write_string($intro,0, "$nomptv Depositos sin identificar:  $eg_mes-$eg_anio",$titulos);
	$worksheet3->write_blank($intro,1,$titulos);
	$worksheet3->write_blank($intro,2,$titulos);
	$worksheet3->merge_cells($intro,0,$intro,2);

	$bcos=PgDoQuery("select cte_id,cte_nombre from ctes where cte_codemp=$astc_codemp and cte_tipcta=1 and cte_idptov=$eg_idptov;",0);
	$fbcos=pg_numRows($bcos);
	$p=6;
	for($k=0;$k<$fbcos;$k++){
	    $astc_ctacte=Resultado($bcos,$k,"cte_id",1);
	    $nombco=Resultado($bcos,$k,"cte_nombre",1);
	    $Query="select * from astoctas a where astc_numero not in (select astc_numero from astoctas where astc_idptov=$ash_idptov and astc_estado=2 and astc_comprob=$compbteid and astc_fecval<='$feccie') 
			    and astc_codemp=$ash_codemp and astc_comprob=$compbtedi and astc_idptov=$ash_idptov and astc_ctacte=$astc_ctacte and astc_tipcta=1 and astc_estado=2 and astc_fecval<='$feccie' order by astc_fecvto;";
	    $descriptor=PgDoQuery($Query);
	    $rows1=Pg_NumRows($descriptor);
	    if($rows1){
		$worksheet3->write_string($p+1,0, "Banco: $nombco",$encabezado1);
		$worksheet3->write_blank($p+1,1,$encabezado1);
		$worksheet3->write_blank($p+1,2,$encabezado1);
		$worksheet3->merge_cells($p+1,0,$p+1,2);
		$p++;
		$worksheet3->write_string($p+1,0, "Fecha",$encabezado);
		$worksheet3->write_string($p+1,1, "Importe",$encabezado);
		$worksheet3->write_string($p+1,2, "Comprobante",$encabezado);
		$p++;
		for($m=0;$m<$rows1;$m++){
		    $id=Resultado($descriptor,$m,"astc_id",1);
		    $astc_numero=Resultado($descriptor,$m,"astc_numero",1);
		    $astc_fecvto=Resultado($descriptor,$m,"astc_fecvto",1);
		    $astc_importe=Resultado($descriptor,$m,"astc_importe",1);
		    $astc_fecvto=@UserQuery("select '$astc_fecvto'::date;",0);
		    $worksheet3->write_string($p+1,0, $astc_fecvto,$cuerpo);
		    $worksheet3->write_number($p+1,1, $astc_importe,$numero);
		    $worksheet3->write_string($p+1,2, $comprobdi." - ".$astc_numero,$cuerpo);
		    $p++;
		}
	    }
	}






	if($ash_idptov) $astc_idptov=$ash_idptov;
	$cta_banco=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'BANCO')::smallint",0);
	$cta_perib=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'CTAPERIB')::smallint",0);
	$cta_retib=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'SIRCREBB')::smallint",0);
	$cta_ivac=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'CTAIVAC')::smallint",0);
	$cta_impcheq=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'CTAIMPCHEQ')::smallint",0);
	$cta_gasban=@UserQuery("select cbl_id from ctacble where cbl_codemp=$astc_codemp and cbl_codigo=valvaramb($astc_codemp,$astc_idptov,'GASBAN')::smallint",0);

	$ash_mes=$eg_mes;
	$ash_anio=$eg_anio;
	$codemp=$astc_codemp;

	$ash_comprob= @UserQuery("select idcomp($codemp,$ash_idptov,'AD');",0);

	$worksheet4 =& $workbook->add_worksheet("Concilia");
	$worksheet4->set_column(0,0,15);
	$worksheet4->set_column(1,1,60);
	$worksheet4->set_column(2,5,15);

	$intro=1;
	$cuerpoexc=3;

	$worksheet4->write_string($intro,0, "$nomptv Conciliacion Bancaria:  $eg_mes-$eg_anio",$titulos);
	$worksheet4->write_blank($intro,1,$titulos);
	$worksheet4->write_blank($intro,2,$titulos);
	$worksheet4->write_blank($intro,3,$titulos);
	$worksheet4->write_blank($intro,4,$titulos);
	$worksheet4->write_blank($intro,5,$titulos);
	$worksheet4->merge_cells($intro,0,$intro,5);


	$bcos=PgDoQuery("select cte_id,cte_nombre from ctes where cte_codemp=$astc_codemp and cte_tipcta=1 and cte_idptov=$eg_idptov;",0);
	$fbcos=pg_numRows($bcos);
	$p=6;
	for($k=0;$k<$fbcos;$k++){
	    $astc_ctacte=Resultado($bcos,$k,"cte_id",1);
	    $nombco=Resultado($bcos,$k,"cte_nombre",1);
	    $ash_id=NULL;
	    $titulo='Gtos. Bancarios ' . $ash_mes . '-'. $ash_anio . '  ';
	    $titulo.=@UserQuery("select nomctes($astc_ctacte);",0);
	    $ash_id=@UserQuery("select ash_id from astoh where ash_codemp=$codemp and ash_comprob=$ash_comprob and ash_anio=$ash_anio and ash_mes=$ash_mes and ash_titulo='$titulo'",0);
	    $grabado=$nograbado=$ivac=$retib=$perib=$impcheq=0;

	    if($ash_id)
		$ash_fecval= @UserQuery("select ash_fecval from astoh where ash_id=$ash_id;",0);
	    else{
		if($ash_mes==1){$mesant=12; $anioant=$ash_anio-1;} else {$mesant=$ash_mes-1; $anioant=$ash_anio;}
		$mesant=@UserQuery("select lpad($mesant::text,2,'0');",0);
		$titulo='Gtos. Bancarios ' . $mesant . '-'. $anioant . '&nbsp; ';
		$titulo.=@UserQuery("select trim(nomctes($astc_ctacte));",0);
		$lacuentac.=@UserQuery("select trim(nomctes($astc_ctacte));",0);

		$queryy=" select ash_id from astoh where ash_codemp=$codemp and ash_idptov=$ash_idptov and ash_comprob=$ash_comprob and ash_anio=$anioant and ash_mes=$mesant and ash_titulo like 'Gtos. Bancarios $mesant-$anioant  $lacuentac%' order by ash_id desc limit 1; ";

		$ash_ida=@UserQuery("$queryy",0);
		if($ash_ida)
		    $ash_fecval= @UserQuery("select ash_fecval from astoh where ash_id=$ash_ida;",0);
	    }

	    $query="select astc_id, trim(codcomp(astc_comprob)) as codcomp,astc_numero,titastoh(astc_idastoh)as titulo,astc_idastoh,
			astc_nucheq,astc_fecvto as astc_fecval,astc_importe,astc_leyen,astc_nucheq,astc_idastoh 
			    from astoctas where astc_codemp=$astc_codemp and astc_idptov=$astc_idptov and astc_tipcta=1 and astc_estado=2 
				and astc_ctacte=$astc_ctacte and astc_fecval<='$feccie' and 
				(astc_cierra=1 or 
				    (astc_cierra=2 and astc_id in 
					(select cxlia_idastc from conxclia where cxlia_idclia in 
					    (select clia_id from concilia where clia_cte=$astc_ctacte and date(clia_fechacon)>'$feccie')
					)
				    )
				) 
				and astc_fecval<='$feccie' order by astc_fecvto, astc_id;";

	    $r=PgDoQuery($query);
	    $rows=pg_NumRows($r);

	    $query="select sum(astc_importe) from astoctas 
		  where astc_codemp=$astc_codemp 
			and astc_idptov=$astc_idptov 
			and astc_tipcta=1 and astc_estado=2 
			and astc_ctacte=$astc_ctacte 
			and astc_fecval<='$feccie' 
			and astc_cierra=2 
			and astc_id not in 
				    (select cxlia_idastc from conxclia where cxlia_idclia in 
					(select clia_id from concilia where clia_cte=$astc_ctacte and date(clia_fechacon)>'$feccie'));";
	    $salant=@UserQuery($query,0);
	    if(!$salant) $salant=0;
	    if($rows || $salant){
		$worksheet4->write_string($p+1,0, "Banco: $nombco",$encabezado1);
		$worksheet4->write_blank($p+1,1,$encabezado1);
		$worksheet4->write_blank($p+1,2,$encabezado1);
		$worksheet4->write_blank($p+1,3,$encabezado1);
		$worksheet4->write_blank($p+1,4,$encabezado1);
		$worksheet4->write_blank($p+1,5,$encabezado1);
		$worksheet4->merge_cells($p+1,0,$p+1,5);
		$p++;
		$worksheet4->write_string($p+1,0, "Comprobante",$encabezado);
		$worksheet4->write_string($p+1,1, "Titulo",$encabezado);
		$worksheet4->write_string($p+1,2, "Fecha Vto.",$encabezado);
		$worksheet4->write_string($p+1,3, "Debe",$encabezado);
		$worksheet4->write_string($p+1,4, "Haber",$encabezado);
		$worksheet4->write_string($p+1,5, "Saldo",$encabezado);
		$p++;
		if($salant){
		    if($salant>0) 
			{$debe=$salant; $haber='&nbsp;';} 
		    else
			{$haber=$salant; $debe='&nbsp;';}
		    $totfab=$saldo=$salant;
		    $worksheet4->write_string($p+1,0, "",$cuerpo);
		    $worksheet4->write_string($p+1,1, "SALDO ANTERIOR CONCILIADO",$cuerpo);
		    $worksheet4->write_string($p+1,2, $ash_fecval,$cuerpoz);
		    $worksheet4->write_number($p+1,3, $debe,$numero);
		    $worksheet4->write_number($p+1,4, $haber,$numero);
		    $worksheet4->write_number($p+1,5, $totfab,$numero);
		    $p++;
		}
		else
		    $saldo=$salant=$totfab=0;
		for($m=0;$m<$rows;$m++){
		    $astc_fecha=Resultado($r,$m,"astc_fecval",1);
		    $astc_idastoh=Resultado($r,$m,"astc_idastoh",1);
		    $codcomp=Resultado($r,$m,"codcomp",1);
		    $titulo=Resultado($r,$m,"titulo",1);
		    $astc_numero=Resultado($r,$m,"astc_numero",1);
		    $astc_id=Resultado($r,$m,"astc_id",1);
		    $astc_idastoh=Resultado($r,$m,"astc_idastoh",1);
		    $astc_nucheq=Resultado($r,$m,"astc_nucheq",1);
		    $astc_leyen=Resultado($r,$m,"astc_leyen",1);
		    $astc_importe=Resultado($r,$m,"astc_importe",1);
		    $debe='';
		    $haber='';
		    $comprob= $codcomp . ' - ' .$astc_numero;
		    if($astc_importe>0)
			$debe=$astc_importe;
		    else
			$haber=$astc_importe;

		    $compbteID=@UserQuery("select trim(valvaramb($codemp,$astc_idptov,'CMPIG'));",0);
		    if($codcomp==$compbteID)
			$titulo=@UserQuery("select gto_leyen from gastos where gto_idastoh=$astc_idastoh",0);;
		    if($astc_nucheq)
			$titulo=$titulo . "  Cheque Nro: " . $astc_nucheq;
		    if($astc_leyen)
			$titulo=$titulo . "  -   " . $astc_leyen;

		    $saldo=$saldo+$astc_importe;
		    $saldo=@UserQuery("select $saldo::numeric(15,2);",0);

		    $worksheet4->write_string($p+1,0, $comprob,$cuerpo);
		    $worksheet4->write_string($p+1,1, $titulo,$cuerpo);
		    $worksheet4->write_string($p+1,2, $astc_fecha,$cuerpoz);
		    $worksheet4->write_number($p+1,3, $debe,$numero);
		    $worksheet4->write_number($p+1,4, $haber,$numero);
		    $worksheet4->write_number($p+1,5, $saldo,$numero);
		    $p++;

		    $debe='';
		    $haber='';
		}
	    }
	}



    $workbook->close();
break; 




default:
	echo("<HTML>\n");
	echo("<HEAD>\n");
	echo("	<TITLE>Consulta de Cuentas Corrientes</TITLE>\n");
	include("../js/style.php");

	echo("<script language=\"JavaScript1.2\" src=\"../js/date.js\"></script>");

	echo("<script language=\"JavaScript\"><!--\n");
	echo("function Validate(frm,boton){\n");
	echo("switch(boton){\n");
	echo("case 0:\n");
	if(!$codemp)
	    {
	    echo("    if(Blank(frm.astc_codemp)){\n");
	    echo("alert('Debe definir la Empresa');\n");
	    echo("frm.astc_ctacble.focus();\n");
	    echo("return(false);\n");
	    echo("}\n");
	    }
	echo("break;\n");
	echo("}\n");
	echo("}\n");
	echo("//-->\n");
	echo("</script>\n");

	echo("<SCRIPT language=\"JavaScript\"> ");
	echo("function Init(frm)\n");
	echo("{\n");
	echo("frm.puntoventa.focus();");
	echo("}");
	echo("</SCRIPT>");

	echo("<script type=\"text/javascript\" src=\"../js/jq.js\"></script>\n");
	echo("<script type=\"text/javascript\" src=\"https://www.admsanjorge.com/sanjor/CS/implementaciones/divcco1.php?ash_idptov=ptovtaid&codempid=$codemp&ash_idptov1=ptovtaid1\"></script>");

	echo("</HEAD>\n");
	echo("<body bgcolor=\"#C0C0C0\" topmargin=\"30\" leftmargin=\"0\" onload=\"Init(document.consulta)\">\n");

//	echo("<script type=\"text/javascript\" src=\"../js/noloadpage.js\"></script>\n");

	echo("  <link rel=\"stylesheet\" type=\"text/css\" media=\"all\" href=\"../js/calendar/calendar-green.css\" title=\"win2k-cold-1\" />\n");
	echo("  <script type=\"text/javascript\" src=\"../js/calendar/calendar.js\"></script>\n");
	echo("  <script type=\"text/javascript\" src=\"../js/calendar/calendar-es.js\"></script>\n");
	echo("  <script type=\"text/javascript\" src=\"../js/calendar/calendar-setup.js\"></script>\n");

	echo("<FORM name=\"consulta\" ACTION=\"exportoliqgf.php\">\n");

	echo("<CENTER><H2>Reimpresion de Liquidaciones - Total</H2></CENTER>\n");

	echo("<hr><br>");

	echo("<TABLE cellSpacing=0 cellPadding=0 align=center border=0 width=50%>\n");

	$astc_codemp=$codemp;
	if(!$ptovta)
	    {
	    echo("  <tr> \n");
	    echo("   <td class=\"textlow\" align=\"left\">Punto de Venta:</td>\n");
	    echo("   <td align=\"left\">\n");
	    echo("<input type=\"text\" class=\"input_text\" name=\"puntoventa\" size=\"4\" id=\"ptovtaid1\">\n");
	    ShowQueryAsComboActionId("select ptv_id,ptv_codigo||' - '||ptv_nombre from ptovta where ptv_codemp=$codemp and ptv_estado=1 order by ptv_codigo;","elidptov",1,1,1,"","ptovtaid");
	    echo("   </td>\n");
	    echo("  </tr>\n");
	    }	
	else{
	    $astc_idptov=$ptovta;
	    echo("<input type=\"hidden\" name=\"elidptov\" value=\"$ptovta\">");
	}
	$fecha = date("d-m-Y");
	echo("  <tr> \n");
	echo("   <td class=\"textlow\" align=\"left\">Fecha del Cierre:&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;</td>\n");
	echo("   <td align=\"left\"><input type=\"text\" class=\"input_text\" name=\"fechah\" id=\"fecha1\"  size=\"10\" maxlength=\"10\"  value=$fecha  onFocus=\"javascript:vDateType='3'\" onKeyUp=\"DateFormat(this,this.value,event,false,'3')\" onBlur=\"DateFormat(this,this.value,event,true,'3')\"onFocus=\"javascript:vDateType='3'\" onKeyUp=\"DateFormat(this,this.value,event,false,'3')\" onBlur=\"DateFormat(this,this.value,event,true,'3')\">\n");
	echo("<input type=\"button\" id=\"lanzador\" value=\".\" class=\"input_text\">\n");
	echo("<!-- script que define y configura el calendario-->\n");
	echo("<script type=\"text/javascript\">\n");
	echo("    Calendar.setup({\n");
	echo("        inputField     :    \"fecha1\",      // id del campo de texto\n");
	echo("        ifFormat       :    \"%d-%m-%Y\",       // formato de la fecha, cuando se escriba en el campo de texto\n");
	echo("        button         :    \"lanzador\"	// el id del boton que lanzara el calendario\n");
	echo("    });\n");
	echo("</script>\n");
	echo("</td>\n");
	echo("  </tr>\n");

	echo("</TABLE>\n");

	echo("<br><hr><br>");

	echo("<TABLE cellSpacing=0 cellPadding=2 align=center border=0 Align=center>\n");
	echo("  <TR>\n");
//	echo("    <TD><INPUT class=botonazo type=\"SUBMIT\" value=\"CONSULTA\" name=\"accion\" onclick='return Validate(this.form,0);'></TD>\n");
//	echo("<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  </td>\n");
//	echo("<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;  </td>\n");
	echo("    <TD><INPUT class=botonazo type=\"SUBMIT\" value=\"EXCEL\" name=\"accion\" onclick='return Validate(this.form,0);'></TD>\n");
	echo("    <TD><INPUT class=botonazo type=\"SUBMIT\" value=\"PDF\" name=\"accion\" onclick='return Validate(this.form,0);'></TD>\n");
	echo("  </TR>\n");
	echo("</TABLE>\n");
	echo("</FORM>\n");
	echo("</BODY>\n");
	echo("</HTML>\n");
break;
}
?>


