<?php
/**DOC:results.php
   ---------------------------------------------------------------------- 

    ShowResults($result) 
	Muestra el resultado de un query ($result) en una tabla
    ShowResultsAsForm($result) 
	$result en forma de form (una tabla por registro)
    ShowResultsAsCustomForm($result) 
	llama a ShowCustomRow por cada registro, funcion que hay que
	escribir del lado del cliente
    ShowResultsAsTemplateTable($template, $result) 
	recibe un array $template que describe como imprimir cada campo

    Las versiones ShowSelect toman directamente un query SQL, las
    ShowResult un $result de una base.
	ShowSelectAsForm($select)
	ShowSelectAsTable($select)
	ShowSelectAsTemplateTable($template) -
	    el query SQL viene en $template["sql"]
	ShowSelectAsCustomForm($select, $displaycount)
	
    Extras:
	ShowQueryAsList($select)
	    Imprime el resultado de un query SQL como una lista de
	    la forma <option> text
	ShowQueryAsCombo($select,$dato)
	    Lo mismo que ShowQueryAsList, pero el primer campo es el
	    valor y el segundo el texto a mostrar <option value=..>text
	ShowQueryAsComboAndText($select)
	    No contento con ShowQueryAsCombo, este pone ademas un
	    textbox que busca con javascript los valores del combo
 * ---------------------------------------------------------------------- */

Function  ShowResults($result)  
{ 
  if  ($result)  { 
	  $rows  =  pg_NumRows($result); 
	  $cols  =  pg_NumFields($result); 

	  echo( "<table  border=1>\n"); 
	  /*  Create  the  headers  */ 
	  echo( "<tr>\n"); 
	  for($i  =  0;  $i  <  $cols;  $i++)  { 
		  printf( "<th>%s</th>\n",  pg_FieldName($result,  $i)); 
	  } 
	  echo( "</tr>"); 
	  for($j  =  0;  $j  <  $rows;  $j++)  { 
		  echo( "<tr>\n"); 
		  for($i  =  0;  $i  <  $cols;  $i++)  { 
			  printf( "<td>%s</td>\n",  pg_result($result,  $j,  $i)); 
		  } 
		  echo( "</tr>"); 
	  } 
	  echo( "</table>"); 
  }  else  { 
	  echo(pg_errormessage); 
  } 
  return;
} 


Function  ShowResultsAsForm($select, $result, $displaycount, $start)  
{ 
  if  ($result)  { 
	  $rows  =  pg_NumRows($result); 
	  $cols  =  pg_NumFields($result); 

	  if($displaycount) {
	      printf ("Your query found %s records<br>", 
	          ($rows ? strval($rows) : "no"));
	  }
	  $end = min($rows, 25+$start);
	  
	  if($rows > 25) {
	      printf ("Showing 25 records<br>");
	      printf ("Records %d to %d<br>", $start, $end);
	      PrintNavigationBar($select, $rows, $end);	  
	  }
	  
	  for($j  =  $start;  $j  < $end ;  $j++)  { 
	      echo( "<table  border=0>\n"); 
	      echo( "<tr>\n"); 
	      for($i  =  0;  $i  <  $cols;  $i++)  { 
	    	  echo( "<tr>\n");
		  printf( "<td valign=\"top\"><i>%s</i></td><td>%s</td>\n",
			    FormatFieldName(pg_FieldName($result,  $i)),
			    FormatField(pg_FieldName($result,  $i), pg_result($result,  $j,  $i)) ); 
		  echo( "</tr>"); 
	      } 
	      echo( "</table>"); 
	      if ($rows > 1) 
	          echo("<p><hr width=\"85%\"><p>");
	  } 
    } else  { 
	  echo(pg_errormessage($conn)); 
    } 
} 


Function  ShowResultsAsTable($select, $result, $displaycount, $start)  
{ 
  if  ($result)  { 
	  $rows  =  pg_NumRows($result); 
	  $cols  =  pg_NumFields($result); 

	  if($displaycount) {
	      printf ("Your query found %s records<br>", 
	          ($rows ? strval($rows) : "no"));
	  }
	  $end = min($rows, 25+$start);
	  
	  if($rows > 25) {
	      printf ("Showing 25 records<br>");
	      printf ("Records %d to %d<br>", $start, $end);
	      PrintNavigationBar($select, $rows, $end);	  
	  }
	  
          echo( "<table  border=1>\n"); 
	  echo( "<tr>\n"); 
	  // Print header
	  for($i  =  0;  $i  <  $cols;  $i++)  { 
	      printf( "<td valign=\"top\"><b>%s</b></td>",
		    pg_FieldName($result,  $i));
	  } 
	  echo "</tr>";
	  for($j  =  $start;  $j  < $end ;  $j++)  { 
	      echo( "<tr>\n");
	      for($i  =  0;  $i  <  $cols;  $i++)  { 
		  printf( "<td valign=\"top\">%s</td>\n",
			    FormatField(pg_FieldName($result,  $i), pg_result($result,  $j,  $i)) ); 
	      } 
	      echo( "</tr>"); 
	  } 
          echo( "</table>"); 
    } else  { 
	  echo(pg_errormessage($conn)); 
    } 
} 


Function  ShowResultsAsTemplateTable($template, $result, $displaycount, $start)  
{ 
    if (!$result)  { 
	echo(pg_errormessage($conn)); 
	return;
    }
    if($GLOBALS["action"] == "outputcsv") {
	ShowResultsAsCSV($template, $result);
	return;
    }

    $rows  =  pg_NumRows($result); 
    $cols  =  pg_NumFields($result); 

    if(!$rows) {
        $x=getenv("HTTP_REFERER");
	$x=strtok($x,"?");
    	      ErrMsg($x,501);
	      return;
    //printf ("Your query found %s records<br>",($rows ? strval($rows) : "no"));
		    }

    $end = $rows;
    if($displaycount) {
    $end = min($rows, 25+$start);
    if($rows > 25) {
          printf ("Showing 25 records<br>");
          printf ("Records %d to %d<br>", $start, $end);
          PrintNavigationBar($select, $rows, $end);	  
		    }
    }

    // Print header
    echo( "<table  border=1>\n"); 
    
    if($template["noheaders"] == NULL) {
    echo( "<tr>\n"); 
    for($i  =  0;  $i  <  $cols;  $i++)  { 
	$t_fieldname = pg_FieldName($result,  $i);
	echo("<td valign=\"top\"");
	if($template[$t_fieldname]["width"] != NULL) {
	    printf(" width=\"%s\"", $template[$t_fieldname]["width"]);
	}
	if($template[$t_fieldname] != NULL) {
	    $t_fieldname = $template[$t_fieldname]["title"];
	}
	printf("><b><center>%s</center></b></td>", $t_fieldname);
    } 

    if($template["extrafields"]) {
	while($i = each($template["extrafields"])) {
    	    printf(" <td><b> %s</b></td>", $i["key"]);
	}
    }
    echo "</tr>";
    }
    // Print body of table
    for($j  =  $start;  $j  < $end ;  $j++)  { 
	$therow = pg_fetch_object($result, $j);
	echo( "<tr>\n");
	for($i  =  0;  $i  <  $cols;  $i++)  { 
	    $t_fieldname = pg_FieldName($result,  $i);
	    if(($t_align = $template[$t_fieldname]["align"]) == NULL) { 
		$t_align = "left";
	    }
	    if(($h = $template[$t_fieldname]["cell"]) != NULL) { 
    		echo(" <td align=\"$t_align\">");
		PrintTemplatedRow($h, $therow);
		echo("</td>");
	    } else if(($h = $template[$t_fieldname]["cellraw"]) != NULL) { 
		PrintRawTemplatedRow($h, $therow);
	    } else {
		printf( "<td valign=\"top\" align=\"$t_align\">%s</td>\n",
		    FormatField($t_fieldname, pg_result($result,  $j,  $i)) ); 
	    }
	} 
	if($template["extrafields"]) {
	    reset($template["extrafields"]);
	    while($h = each($template["extrafields"])) {
    		echo(" <td>");
		PrintTemplatedRow($h["value"], $therow);
		echo("</td>");
	    }
	}
	echo( "</tr>"); 
    } 
    echo( "</table>");     
    if($template["nocsv"] == NULL)
        echo("<center><a href=\"" . getenv("SCRIPT_NAME") 
	    . "?action=outputcsv&output=quiet&sql= " . urlencode($template["sql"])
	    . "\" ONMOUSEOVER=\"window.status='Tamo linds ';return true;\" ONMOUSEOUT=\"window.status='';return true;\" >Bajar como archivo Excel</a></center>");
/*	    
<a href="http://10.1.100.222" ONMOUSEOVER="window.status='Whatever you want to say';return true;" ONMOUSEOUT="window.status='';return true;">ruflo</a>
*/	    
} 

Function PrintTemplatedRow($t_row, $therow)
{
    // Handle \" (-> \\\\") and $vars
    $t_echo = $t_row;
    $t_echo = preg_replace(array("/\"/"), array("\\\""), $t_echo);
    $t_echo = "echo(\"" . $t_echo . "\");";
    eval($t_echo);
}

Function PrintRawTemplatedRow($t_row, $therow)
{
    // Handle \" (-> \\\\") and $vars
    $t_code = $t_row;
//    $t_code = preg_replace(array("/\"/"), array("\\\""), $t_echo);
    eval($t_code);
}


Function  ShowResultsAsCSV($template, $result)  
{ 
    if (!$result)  { 
	echo(pg_errormessage($conn)); 
	return;
    }
    header("Content-Type: application/csv; filename=download.csv");
    header("Content-disposition: filename=download.csv");

    $rows  =  pg_NumRows($result); 
    $cols  =  pg_NumFields($result); 

    // Print header
    for($i  =  0;  $i  <  $cols;  $i++)  { 
	$t_fieldname = pg_FieldName($result,  $i);
	if($template[$t_fieldname] != NULL) {
	    $t_fieldname = $template[$t_fieldname]["title"];
	}
	printf("%s,", strip_tags($t_fieldname));
    } 
    printf("\n");

    // Print body of table
    for($j  =  0;  $j  < $rows;  $j++)  { 
	for($i  =  0;  $i  <  $cols;  $i++)  
	    printf( "%s,", FormatField(pg_FieldName($result,  $i), pg_result($result,  $j,  $i)) ); 

	printf("\n");
    } 
    exit();
} 

Function  ShowResultsAsCustomForm($select, $result, $displaycount)  
{ 
  if  ($result)  { 
	  $rows  =  pg_NumRows($result); 
	  $cols  =  pg_NumFields($result); 

	  if($displaycount) {
	      printf ("SON %d<br>", ($rows ? strval($rows) : "no"));
	  }
	  
	  for($j  =  0;  $j  < $rows ;  $j++)  { 
	      ShowCustomRow (pg_fetch_object($result, $j));
	  } 
    } else  { 
	  echo(pg_errormessage($conn)); 
    } 
} 

Function ShowSelectAsForm($select, $displaycount)
{
    $db = OpenDatabase();
    $result = QueryDatabase($db, $select);
    ShowResultsAsForm($select, $result, $displaycount,0);
    CloseDatabase($db);
}

Function ShowSelectAsTable($select, $displaycount)
{
    $db = OpenDatabase();
    $result = QueryDatabase($db, $select);
    ShowResultsAsTable($select, $result, $displaycount,0);
    CloseDatabase($db);
}

Function ShowSelectAsTemplateTable($template, $displaycount)
{
    $db = OpenDatabase();
    if($GLOBALS["action"] == "outputcsv") {
    $value=str_replace("\\\\","",$GLOBALS["sql"]);
    $result = QueryDatabase($db, $value);
    /*    $result = QueryDatabase($db, $GLOBALS["sql"]);*/
    }
    else {
	$result = QueryDatabase($db, $template["sql"]);
    }
    ShowResultsAsTemplateTable($template, $result, $displaycount,0);
    CloseDatabase($db);
}


Function ShowSelectAsCustomForm($select, $displaycount)
{
    $db = OpenDatabase();
    $result = QueryDatabase($db, $select);	 
    ShowResultsAsCustomForm($select, $result, $displaycount, 0);
    CloseDatabase($db);
}


Function  FormatField($fieldname, $value)
{
    switch ($fieldname) {
	case "region":	    return (MapRegionInt2Str($value));    
	case "address":	    return (nl2br($value));		/* convert newlines to <br> */
	case "name":	    return ("<b>" . $value . "</b>");		/* pretty print */
	case "e_mail":	    return ("<A HREF=\"mailto:" . $value . "\">" . $value . "</a>");
	case "weburl":	    return ("<A HREF=\"" . $value . "\">" . $value . "</a>");
	case "contact":			/* a name reference */
	    return ("<A HREF=\"/people/search-exact.php3?name=" . rawurlencode($value) . "\">" . $value . "</a>");
	case "contactid":			/* a name reference */
	    return ("<A HREF=\"/people/search-exact.php3?nameid=" . rawurlencode($value) . "\">" . $value . "</a>");
	default:
		    return ($value);    
    }
} 


Function  FormatFieldName($value)
{
    switch($value) {
	case "e_mail":	    return ("e-Mail:");
	case "weburl":	    return ("WWW Page:");
	default:	    return (ucfirst($value) . ":");
    }
}


Function PrintNavigationBar($select, $rows, $start)
{
    printf("<form  action=\"/bin/php/browse.php3\" method=\"POST\">");
    
    printf("<input type=\"hidden\" name=\"select\" value=\"" . $select . "\">");
    printf("<input type=\"hidden\" name=\"start\" value=\"" . $start . "\">");
    printf("<input type=\"submit\" name=\"prev\" value=\"Prev 25\">");
    if ($rows > $start)
        printf("<input type=\"submit\" name=\"next\" value=\"Next 25\">");
    printf("</form>");

}



Function ShowQueryAsList($select)
{
    $db = OpenDatabase();
    $result = QueryDatabase($db, $select);
    echo ("<SELECT NAME=\"usuario\" SIZE=13>");
    $rows = pg_NumRows($result);
    echo "<OPTION> NOT SELECTED";
    for($i=0; $i<$rows; $i++) {
        echo "<OPTION> " . pg_Result($result,$i,$campo);
    }
    echo ("</SELECT>");
    CloseDatabase($db);
}





Function ShowQueryAsCombo($select, $name,$size,$default_id,$sizefont)
{
    $db = PgOpenDatabase();
    $result = PgQueryDatabase($db, $select);
    $rows = pg_NumRows($result);
    if(!$default_id) $default="NOT SELECTED";
    if($rows){
	echo ("<SELECT NAME=\"$name\" SIZE=\"$size\"  class=\"input_text\"     >");
        if($default_id){
    		for($i=0; $i<$rows; $i++) {
		$row = pg_Fetch_Array($result,$i);
		if($default_id==$row[0]) echo "<OPTION SELECTED VALUE=\"" . $row[0] . "\"> " . $row[1];
		}
	    }
	else    
    	    echo "<OPTION SELECTED VALUE=\"". $default_id .  "\">" . $default;
        for($i=0; $i<$rows; $i++){
	    $row = pg_Fetch_Array($result,$i);
	    if($default_id !=$row[0]) echo "<OPTION VALUE=\"" . $row[0] ."\"> " . $row[1];
	    }
	echo ("</SELECT>");
    }
        else {
	printf("<INPUT TYPE=\"hidden\" value=\"%s\" NAME=\"%s\">",0,$name);    
	echo ("No hay opciones");
     }
	PgCloseDatabase($db);
/*

//    if($rows)
//		echo ("<SELECT NAME=\"$name\"");
//        else 
//		echo ("<SELECT NAME=\"$name\"");

    if($size)
	echo ("SIZE=\"$size\">");
	else
	echo ("SIZE=\"4\">");
    if(!$default) $default="NOT SELECTED";
    if($sizefont) $default="<FONT SIZE=\"" . $sizefont . "\">" . $default . "</FONT>";
    echo "<OPTION SELECTED VALUE=\"NOT SELECTED\">". $default;
    for($i=0; $i<$rows; $i++) {
	$row = pg_Fetch_Array($result,$i);
	$default=$row[1];
	if ($sizefont)    $default="<FONT SIZE=\"" . $sizefont  . ">" . $row[1] . "</FONT>"; 
        echo "<OPTION VALUE=\"" . $row[0] . "\"> " . $default;
    }
    echo ("</SELECT>");
    CloseDatabase($db);

*/
}



Function ShowQueryAsComboAction($select, $name,$size,$default_id,$sizefont,$javaactions)
{
    $db = PgOpenDatabase();
    $result = PgQueryDatabase($db, $select);
    $rows = pg_NumRows($result);
    if(!$default_id) $default="NOT SELECTED";
    if($rows){
		echo ("<SELECT NAME=\"$name\" SIZE=\"$size\" $javaactions >");
        if($default_id){
    		for($i=0; $i<$rows; $i++) {
		$row = pg_Fetch_Array($result,$i);
		if($default_id==$row[0]) echo "<OPTION SELECTED VALUE=\"" . $row[0] . "\"> " . $row[1];
		}
	    }
	else    
    	    echo "<OPTION SELECTED VALUE=\"". $default_id .  "\">" . $default;
        for($i=0; $i<$rows; $i++){
	    $row = pg_Fetch_Array($result,$i);
	    if($default_id !=$row[0]) echo "<OPTION VALUE=\"" . $row[0] ."\"> " . $row[1];
	    }
	echo ("</SELECT>");
    }
        else {
	printf("<INPUT TYPE=\"hidden\" value=\"%s\" NAME=\"%s\">",0,$name);    
	echo ("No hay opciones");
     }
	PgCloseDatabase($db);
/*

//    if($rows)
//		echo ("<SELECT NAME=\"$name\"");
//        else 
//		echo ("<SELECT NAME=\"$name\"");

    if($size)
	echo ("SIZE=\"$size\">");
	else
	echo ("SIZE=\"4\">");
    if(!$default) $default="NOT SELECTED";
    if($sizefont) $default="<FONT SIZE=\"" . $sizefont . "\">" . $default . "</FONT>";
    echo "<OPTION SELECTED VALUE=\"NOT SELECTED\">". $default;
    for($i=0; $i<$rows; $i++) {
	$row = pg_Fetch_Array($result,$i);
	$default=$row[1];
	if ($sizefont)    $default="<FONT SIZE=\"" . $sizefont  . ">" . $row[1] . "</FONT>"; 
        echo "<OPTION VALUE=\"" . $row[0] . "\"> " . $default;
    }
    echo ("</SELECT>");
    CloseDatabase($db);

*/
}





Function ShowQueryAsComboJava($select, $name,$size,$default,$sizefont,$cli,$liq,$comp)
{
/*
    <select name="menu" size="1" onChange ="irA(this)">
    <option value="">Ninguno
    <option value="estado_abajo.php3?estado=1">Inicial
    <option value="estado_abajo.php3?estado=2">Pendiente
    <option value="estado_abajo.php3?estado=3">Definitivo
    </select>

*/

    $db = OpenDatabase();
    $result = QueryDatabase($db, $select);
    $rows = pg_NumRows($result);

    if($rows)
		echo ("<SELECT NAME=\"$name\"  onChange =\"irA(this)\"  ");
        else 
	    {
		echo ("No se registran datos para esta consulta<br>");
		echo ("<SELECT NAME=\"$name\"");
	    }
    
    if($size)
	echo ("SIZE=\"$size\">");
	else
	echo ("SIZE=\"4\">");

if(!$default)    $default="NOT SELECTED";
if($sizefont)    $default="<FONT SIZE=\"" . $sizefont . "\">" . $default . "</FONT>";
    echo "<OPTION SELECTED VALUE=\"NOT SELECTED\">". $default;
    for($i=0; $i<$rows; $i++) {
	$row = pg_Fetch_Array($result,$i);
	$default=$row[1];
	if ($sizefont)    $default="<FONT SIZE=\"" . $sizefont  . ">" . $row[1] . "</FONT>"; 
        echo "<OPTION VALUE=\"" ."factur1.php?liq=" . $row[0] . $liq . "&cli=" . $cli . "&comp=". $comp ."\"> " . $default;
    }
    echo ("</SELECT>");
    CloseDatabase($db);
}


Function ShowQueryAsComboAndText($select, $name)
{
    $db = OpenDatabase();
    $result = QueryDatabase($db, $select);
    $rows = pg_NumRows($result);

    echo("<input type=\"text\" name=\"");
    echo($name . "text\" size=\"20\" onKeyup=\"combotext_onKeyUp(this, document.form.");
    echo($name. ")\">");

    if($rows) {
	echo ("<SELECT NAME=\"$name\" SIZE=\"4\"");
	echo (" onChange=\"combo_onChange(this, document.form." . $name . "text)\">");
    }
    else {
	echo ("No se registran datos para esta consulta<br>");
	echo ("<SELECT NAME=\"$name\" SIZE=\"1\">");
    }    
    echo "<OPTION SELECTED VALUE=\"NOT SELECTED\">NOT SELECTED";
    for($i=0; $i<$rows; $i++) {
	$row = pg_Fetch_Array($result,$i);
        echo "<OPTION VALUE=\"" . $row[0] ."\"> " . $row[1];
    }
    echo ("</SELECT>");
    CloseDatabase($db);
}


Function ShowOptionsAsCombo($name,$size,$options,$default)
{
    if(!$default) $default = 1;
    $pepe = split(",",$options,$default + 1 );
    $h = $pepe [ $default  - 1 ];
    $tok = strtok($options,",");
    echo("<SELECT NAME=\"$name\" SIZE=$size>");
    $x=0;
    echo "<OPTION VALUE=\"" . $default ."\"> " . $h;
    while($tok) {
	$x++;        
	if($default != $x)echo "<OPTION VALUE=\"" . $x ."\"> " . $tok;
        $tok=strtok(",");
    }
    echo ("</SELECT>");

}



Function ShowQueryAsComboForForeign($tabla,$campo1,$campo2,$name,$size,$default_id,$igualo,$caso)
{

    if(!$size)$size=4;
    $db = OpenDatabase();
    if($caso){
    $s0="select " . $campo1 . "," . $campo2 . " from " . $tabla  . " where " . $igualo . $campo1 . ",'" . $default_id . "');";  
    }
    else{
    $s0="select " . $campo1 . "," . $campo2 . " from " . $tabla  . " where  " . $igualo . $campo1 . "," . $default_id . ");";  
    }
    $s1="select " . $campo1 . "," . $campo2 . " from " . $tabla  . "  order by " . $campo2 . ";";  
    if(!$default_id)
        $default="NOT SELECTED";
	else
	{
	    $r1 = QueryDatabase($db, $s0);
    	    $default= pg_Result($r1,0,1);
	}
    $result = QueryDatabase($db, $s1);
    $rows = pg_NumRows($result);
    if($rows)
	echo ("<SELECT NAME=\"$name\" SIZE=\"$size\">");
    else {
	echo ("No se registran datos para esta consulta<br>");
	echo ("<SELECT NAME=\"$name\" SIZE=\"1\">");
    }
    
    echo "<OPTION SELECTED VALUE=\"$default_id\">$default";
    for($i=0; $i<$rows; $i++) {
	    $row = pg_Fetch_Array($result,$i);
	    if($default_id !=$row[0])
	        echo "<OPTION VALUE=\"" . $row[0] ."\"> " . $row[1];
    }
    echo ("</SELECT>");
    CloseDatabase($db);
}



Function OldShowQueryAsComboWithDefault($select, $name,$size,$default_id,$default)
{
    if(!$size)$size=4;
    $db = OpenDatabase();
    $s1="select " . $campo1 . "," . $campo2 . " from " . $tabla  . "  order by " . $campo2 . ";";  
    $result = QueryDatabase($db, $s1);
    $rows = pg_NumRows($result);
    if($rows)
	echo ("<SELECT NAME=\"$name\" SIZE=\"$size\">");
    else {
	echo ("No se registran datos para esta consulta<br>");
	echo ("<SELECT NAME=\"$name\" SIZE=\"1\">");
    }    
    echo "<OPTION SELECTED VALUE=\"$default_id\">$default";
    for($i=0; $i<$rows; $i++) {
	$row = pg_Fetch_Array($result,$i);
    if($default !=$row[1])
        echo "<OPTION VALUE=\"" . $row[0] ."\"> " . $row[1];
    }
    echo ("</SELECT>");
    CloseDatabase($db);
}



Function ShowQueryAsComboWithDefault($select,$name,$size,$default_id,$default)
{
    if(strlen($default_id)==0)$default_id=0;
    if(!$size)$size=4;
    $db = OpenDatabase();
    $result = QueryDatabase($db, $select);
    $rows = pg_NumRows($result);
    if($rows)
	{
	echo ("<SELECT NAME=\"$name\" SIZE=\"$size\">");
        if($default_id){
    		for($i=0; $i<$rows; $i++) {
		$row = pg_Fetch_Array($result,$i);
		if($default_id==$row[0]) echo "<OPTION SELECTED VALUE=\"" . $row[0] . "\"> " . $row[1];
		}
	    }
	else    
    	    echo "<OPTION SELECTED VALUE=\"". $default_id .  "\">" . $default;
        for($i=0; $i<$rows; $i++) {
	    $row = pg_Fetch_Array($result,$i);
	    if($default_id !=$row[0]) echo "<OPTION VALUE=\"" . $row[0] ."\"> " . $row[1];
	    }
	echo ("</SELECT>");

    }
        else {
	printf("<INPUT TYPE=\"hidden\" value=\"%s\" NAME=\"%s\">",0,$name);    
	echo ("No hay opciones");
     }
	CloseDatabase($db);
}


Function HayRows($select)
{
    $db = OpenDatabase();
    $result = QueryDatabase($db, $select);
    $rows = pg_NumRows($result);
    return $rows;
}

Function ShowOptionsAsCombo2($name,$size,$options,$default,$valores)
{
/*  name=nombre HTML
    size=cantidad de elementos a mostrar del combo
    options= elementos del combo
    default=Nro de ocurrencia de las option que muestra 
    valores= son los values del combo(Lo que devuelve)
*/
    $vec1 = split(",",$options);
    $vec2 = split(",",$valores);

    echo("<SELECT NAME=\"$name\"  SIZE=$size>");
    for ($i=0;$i< count($vec1);$i++){
    $def=$default==$vec2[$i]?" SELECTED ":"";
        echo "<OPTION VALUE=\"" . $vec2[$i] ."\"".$def." > " . $vec1[$i] . "</OPTION>";
    }
    
    echo ("</SELECT>");


}



?>