<?php
header('Content-Type: application/json');

$dsn = 'pgsql:host=127.0.0.1;dbname=campus';
$user = 'zona';
$password = 'zona2020';


try {
    $dbh = new PDO($dsn, $user, $password);
    $dbh->beginTransaction();

    $fecha_cotizacion = $_POST['fechaCotizacion'];
    $cliente_nombre = $_POST['clienteNombre'];
    $cliente_dni = $_POST['clienteDNI'];
    $cliente_domicilio = $_POST['clienteDomicilio'];
    $cliente_telefono = $_POST['clienteTelefono'];
    $cliente_contacto = $_POST['clienteContacto'];

    // Insertar cliente
    $stmt = $dbh->prepare("INSERT INTO clientes (nombre, dni, domicilio, telefono, contacto) VALUES (?, ?, ?, ?, ?) RETURNING id_cliente");
    $stmt->execute([$cliente_nombre, $cliente_dni, $cliente_domicilio, $cliente_telefono, $cliente_contacto]);
    $id_cliente = $stmt->fetchColumn();

    // Insertar cotización
    $stmt = $dbh->prepare("INSERT INTO cotizaciones (fecha_cotizacion, id_cliente) VALUES (?, ?) RETURNING id_cotizacion");
    $stmt->execute([$fecha_cotizacion, $id_cliente]);
    $id_cotizacion = $stmt->fetchColumn();

    $totalAdeudado = 0;
    $totalCosto = 0;
    $totalAbonar = 0;

    // Insertar dominios e infracciones
    foreach ($_POST['dominio'] as $index => $dominio) {
        $jurisdiccion = $_POST['jurisdiccion'][$index];

        // Insertar dominio
        $stmt = $dbh->prepare("INSERT INTO dominios (dominio, id_cotizacion, id_cliente, jurisdiccion) VALUES (?, ?, ?, ?) RETURNING id_dominio");
        $stmt->execute([$dominio, $id_cotizacion, $id_cliente, $jurisdiccion]);
        $id_dominio = $stmt->fetchColumn();

        // Insertar infracciones
        foreach ($_POST['nroActa'][$index] as $i => $nroActa) {
            $importe = $_POST['importe'][$index][$i];
            $porcentajeCosto = $_POST['porcentajeCosto'][$index][$i];
            $porcentajeDescuento = $_POST['porcentajeDescuento'][$index][$i];
            $observaciones = $_POST['observaciones'][$index][$i];

            $stmt = $dbh->prepare("INSERT INTO infracciones (nro_acta, importe, porcentaje_costo_estudio, porcentaje_descuento, observaciones, id_dominio) VALUES (?, ?, ?, ?, ?, ?)");
            $stmt->execute([$nroActa, $importe, $porcentajeCosto, $porcentajeDescuento, $observaciones, $id_dominio]);

            // Calcular totales
            $totalAdeudado += $importe;
            $totalCosto += $importe * ($porcentajeCosto / 100);
            $totalAbonar += $importe - ($importe * ($porcentajeDescuento / 100));
        }
    }

    // Actualizar cotización con los totales calculados
    $stmt = $dbh->prepare("UPDATE cotizaciones SET total_adeudado = ?, total_costo = ?, total_abonar_cliente = ? WHERE id_cotizacion = ?");
    $stmt->execute([$totalAdeudado, $totalCosto, $totalAbonar, $id_cotizacion]);

    $dbh->commit();

    echo json_encode(['success' => true, 'id_cotizacion' => $id_cotizacion]);

} catch (PDOException $e) {
    $dbh->rollBack();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
