<?php
require('fpdf/fpdf.php');

// Conexión a la base de datos
$dsn = 'pgsql:host=localhost;dbname=campus';
$user = 'zona';
$password = 'zona2020';

class PDF extends FPDF {
    function Header() {
        // Logo
        $this->Image('infracciones_logo.jpg', 10, 6, 30);
        // Arial bold 15
        $this->SetFont('Arial', 'B', 15);
        // Movernos a la derecha
        $this->Cell(80);
        // Título
        $this->Cell(30, 10, utf8_decode('Cotización de Infracciones'), 0, 1, 'C');
        // Línea de división roja
        $this->SetDrawColor(255, 0, 0);
        $this->SetLineWidth(0.5);
        $this->Line(10, 28, 200, 28);
        // Salto de línea
        $this->Ln(10);
    }

    function Footer() {
        // Posición: a 1.5 cm del final
        $this->SetY(-15);
        // Arial italic 8
        $this->SetFont('Arial', 'I', 8);
        // Número de página
        $this->Cell(0, 10, utf8_decode('Página ') . $this->PageNo() . '/{nb}', 0, 0, 'C');
    }

    function ChapterTitle($label) {
        // Arial 12
        $this->SetFont('Arial', 'B', 12);
        // Color de fondo (color de fondo del logo)
        $this->SetFillColor(244, 236, 225); // Ajustar el color según sea necesario
        // Título
        $this->Cell(180, 6, utf8_decode($label), 0, 1, 'L', true);
        // Salto de línea
        $this->Ln(4);
    }

    function ChapterBody($data) {
        // Arial 12
        $this->SetFont('Arial', '', 12);
        // Salto de línea
        $this->Ln();
        // Datos
        $this->MultiCell(0, 10, utf8_decode($data));
        // Salto de línea
        $this->Ln();
    }

    function ImprovedTable($header, $data) {
        // Anchuras de las columnas
        $w = array(40, 35, 45, 60);
        // Cabeceras
        $this->SetFillColor(244, 236, 225); // Ajustar el color según sea necesario
        $this->SetTextColor(230, 51, 51);
        $this->SetDrawColor(230, 51, 51); // Color rojo
        $this->SetLineWidth(0.3);
        $this->SetFont('Arial', 'B', 12);
        for ($i = 0; $i < count($header); $i++)
            $this->Cell($w[$i], 7, utf8_decode($header[$i]), 1, 0, 'C', true);
        $this->Ln();
        // Datos
        $this->SetTextColor(0);
        $this->SetFont('Arial', '', 9);
        foreach ($data as $row) {
            $this->Cell($w[0], 6, utf8_decode($row['nro_acta']), 'LR');
            $this->Cell($w[1], 6, number_format($row['importe_original'], 2, ',', '.'), 'LR', 0, 'R');
            $this->Cell($w[2], 6, number_format($row['importe_abonar_cliente'], 2, ',', '.'), 'LR', 0, 'R');
            $this->Cell($w[3], 6, utf8_decode($row['observaciones']), 'LR');
            $this->Ln();
        }
        // Totales
        $total_importe_original = array_sum(array_column($data, 'importe_original'));
        $total_importe_abonar = array_sum(array_column($data, 'importe_abonar_cliente'));
        $this->Cell($w[0], 6, 'Total', 'LR', 0, 'R');
        $this->Cell($w[1], 6, number_format($total_importe_original, 2, ',', '.'), 'LR', 0, 'R');
        $this->Cell($w[2], 6, number_format($total_importe_abonar, 2, ',', '.'), 'LR', 0, 'R');
        $this->Cell($w[3], 6, '', 'LR');
        $this->Ln();
        // Línea de cierre
        $this->Cell(array_sum($w), 0, '', 'T');
    }
}

try {
    $dbh = new PDO($dsn, $user, $password);

    // Obtener datos de la cotización
    $id_cotizacion = $_GET['id_cotizacion'];
    $stmt = $dbh->prepare("SELECT c.fecha_cotizacion, c.total_adeudado, c.total_costo, c.total_abonar_cliente, cl.nombre, cl.dni, cl.domicilio, cl.telefono, cl.contacto
                           FROM cotizaciones c
                           JOIN clientes cl ON c.id_cliente = cl.id_cliente
                           WHERE c.id_cotizacion = ?");
    $stmt->execute([$id_cotizacion]);
    $cotizacion = $stmt->fetch(PDO::FETCH_ASSOC);

    // Obtener datos de los dominios y sus infracciones
    $stmt = $dbh->prepare("SELECT d.dominio, j.nombre AS jurisdiccion, i.nro_acta, i.importe AS importe_original, 
                                  i.importe - (i.importe * (i.porcentaje_descuento / 100)) AS importe_abonar_cliente, i.observaciones
                           FROM dominios d
                           JOIN infracciones i ON d.id_dominio = i.id_dominio
                           JOIN jurisdicciones j ON d.jurisdiccion = j.id
                           WHERE d.id_cotizacion = ?");
    $stmt->execute([$id_cotizacion]);
    $dominios = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Generar PDF
    $pdf = new PDF();
    $pdf->AliasNbPages();
    $pdf->AddPage();

    // Datos del cliente
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(0, 10, 'Fecha: '.$cotizacion['fecha_cotizacion'], 0, 1,'R');
    $pdf->Cell(0, 10, 'Datos del Cliente', 0, 1);
    $pdf->SetFont('Arial', '', 12);
    $pdf->Cell(0, 10, 'Nombre: ' . utf8_decode($cotizacion['nombre']), 0, 1);
    if (!empty($cotizacion['dni'])) $pdf->Cell(0, 10, 'DNI: ' . utf8_decode($cotizacion['dni']), 0, 1);
    if (!empty($cotizacion['domicilio'])) $pdf->Cell(0, 10, 'Domicilio: ' . utf8_decode($cotizacion['domicilio']), 0, 1);
    if (!empty($cotizacion['telefono'])) $pdf->Cell(0, 10, 'Telefono: ' . utf8_decode($cotizacion['telefono']), 0, 1);
    $pdf->Ln(10);

    // Cuadros de infracciones por dominio/jurisdicción
    $pdf->SetFont('Arial', 'B', 12);
    $currentDominio = '';
    $currentJurisdiccion = '';
    $infracciones = [];
    foreach ($dominios as $dominio) {
        if ($currentDominio !== $dominio['dominio'] || $currentJurisdiccion !== $dominio['jurisdiccion']) {
            if (!empty($infracciones)) {
                // Mostrar cuadro de infracciones
                $pdf->ChapterTitle('Dominio: ' . $currentDominio . '          -           Jurisdicción: ' . $currentJurisdiccion);
                $pdf->ImprovedTable(['Nro de Acta', 'Importe Original', 'A Abonar', 'Observaciones'], $infracciones);
                $infracciones = [];
            }
            $currentDominio = $dominio['dominio'];
            $currentJurisdiccion = $dominio['jurisdiccion'];
        }
        $infracciones[] = $dominio;
    }
    if (!empty($infracciones)) {
        // Mostrar el último cuadro de infracciones
        $pdf->ChapterTitle('Dominio: ' . $currentDominio . '          -           Jurisdicción: ' . $currentJurisdiccion);
        $pdf->ImprovedTable(['Nro de Acta', 'Importe Original', 'A Abonar', 'Observaciones'], $infracciones);
    }

    // Totales de la cotización
    $pdf->Ln(20);
    $pdf->SetTextColor(230, 51, 51);
    $pdf->SetFont('Arial', 'B', 12);
    $pdf->Cell(0, 10, 'Total Adeudado: ' . number_format($cotizacion['total_adeudado'], 2, ',', '.'), 0, 1);
    $pdf->Cell(0, 10, 'Total a Abonar Cliente: ' . number_format($cotizacion['total_abonar_cliente'], 2, ',', '.'), 0, 1);
    $pdf->SetTextColor(0);

    // Leyendas
    $pdf->Ln(20);
    $pdf->SetFont('Arial', 'I', 10);
    $pdf->MultiCell(0, 7, utf8_decode("La presente cotización tiene una validez de 7 días de corrido. Pasado ese tiempo se debe volver a consultar."));
    $pdf->Ln(5);
    $pdf->MultiCell(0, 7, utf8_decode("Si su cotización tiene en observaciones la leyenda PUNTOS ROJOS y la misma no se abona en el día de la misma, se deberá volver a cotizar diariamente, ya que puede sufrir cambios."));
    $pdf->Ln(5);
    $pdf->MultiCell(0, 7, utf8_decode("Se puede abonar por transferencia o en efectivo."));

    $pdf->Output();
} catch (PDOException $e) {
    echo 'Error: ' . $e->getMessage();
}
?>
