document.addEventListener('DOMContentLoaded', () => {
    const addDominioBtn = document.getElementById('addDominioBtn');
    const dominiosContainer = document.getElementById('dominiosContainer');
    const cotizacionForm = document.getElementById('cotizacionForm');

    // Set today's date as the default value for the cotizacion date
    const today = new Date().toISOString().split('T')[0];
    document.getElementById('fechaCotizacion').value = today;

    addDominioBtn.addEventListener('click', () => {
        dominiosContainer.style.display = 'block';
        addNewDominio();
    });

    cotizacionForm.addEventListener('input', updateTotals);

    cotizacionForm.addEventListener('submit', (event) => {
        event.preventDefault();
        const formData = new FormData(event.target);
        fetch('registrar_cotizacion.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Cotización registrada con éxito');
                // Aquí podrías redirigir o limpiar el formulario
            } else {
                alert('Error al registrar la cotización');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error al registrar la cotización');
        });
    });

    function addNewDominio() {
        const newDominioIndex = document.querySelectorAll('.dominio').length;
        const newDominio = document.createElement('div');
        newDominio.classList.add('dominio', 'mb-4', 'p-3', 'border', 'rounded');
        newDominio.innerHTML = `
            <div class="form-group">
                <label for="dominio">Dominio:</label>
                <input type="text" class="form-control" name="dominio[]" required>
            </div>
            <table class="table">
                <thead>
                    <tr>
                        <th>Nro de Acta</th>
                        <th>Fecha de Acta</th>
                        <th>Importe</th>
                        <th>Jurisdicción</th>
                        <th>% de Costo</th>
                        <th>% de Descuento</th>
                    </tr>
                </thead>
                <tbody class="infraccionesContainer">
                    <tr class="infraccion">
                        <td><input type="text" class="form-control" name="nroActa[${newDominioIndex}][]" required></td>
                        <td><input type="date" class="form-control" name="fechaInfraccion[${newDominioIndex}][]"></td>
                        <td><input type="number" class="form-control importe" step="0.01" name="importe[${newDominioIndex}][]" required></td>
                        <td>
                            <select class="form-control jurisdiccion" name="jurisdiccion[${newDominioIndex}][]" required>
                                <!-- Opciones de jurisdicción cargadas dinámicamente -->
                            </select>
                        </td>
                        <td><input type="number" class="form-control porcentajeCosto" step="0.01" name="porcentajeCosto[${newDominioIndex}][]" required></td>
                        <td><input type="number" class="form-control" step="0.01" name="porcentajeDescuento[${newDominioIndex}][]" value="50" required></td>
                    </tr>
                </tbody>
            </table>
            <button type="button" class="btn btn-secondary addInfraccionBtn">Agregar Infracción</button>
        `;
        dominiosContainer.appendChild(newDominio);

        newDominio.querySelector('.addInfraccionBtn').addEventListener('click', () => {
            const newInfraccion = document.createElement('tr');
            newInfraccion.classList.add('infraccion');
            newInfraccion.innerHTML = `
                <td><input type="text" class="form-control" name="nroActa[${newDominioIndex}][]" required></td>
                <td><input type="date" class="form-control" name="fechaInfraccion[${newDominioIndex}][]"></td>
                <td><input type="number" class="form-control importe" step="0.01" name="importe[${newDominioIndex}][]" required></td>
                <td>
                    <select class="form-control jurisdiccion" name="jurisdiccion[${newDominioIndex}][]" required>
                        <!-- Opciones de jurisdicción cargadas dinámicamente -->
                    </select>
                </td>
                <td><input type="number" class="form-control porcentajeCosto" step="0.01" name="porcentajeCosto[${newDominioIndex}][]" required></td>
                <td><input type="number" class="form-control" step="0.01" name="porcentajeDescuento[${newDominioIndex}][]" value="50" required></td>
            `;
            newDominio.querySelector('.infraccionesContainer').appendChild(newInfraccion);
            loadJurisdicciones(newInfraccion);
            updateTotals();
        });

        loadJurisdicciones(newDominio);
        updateTotals();
    }

    function loadJurisdicciones(element) {
        fetch('obtener_jurisdicciones.php')
        .then(response => response.json())
        .then(data => {
            const jurisdicciones = data.jurisdicciones;
            const jurisdiccionSelects = element.querySelectorAll('.jurisdiccion');
            jurisdiccionSelects.forEach(select => {
                jurisdicciones.forEach(jurisdiccion => {
                    const option = document.createElement('option');
                    option.value = jurisdiccion.id;
                    option.textContent = jurisdiccion.nombre;
                    option.dataset.porcentajeCosto = jurisdiccion.porcentaje_costo;
                    select.appendChild(option);
                });
                // Set default percentage cost when loading jurisdictions
                const firstOption = select.options[select.selectedIndex];
                const porcentajeCostoInput = select.closest('tr').querySelector('.porcentajeCosto');
                porcentajeCostoInput.value = firstOption.dataset.porcentajeCosto;

                select.addEventListener('change', function() {
                    const selectedOption = this.options[this.selectedIndex];
                    const porcentajeCostoInput = this.closest('tr').querySelector('.porcentajeCosto');
                    porcentajeCostoInput.value = selectedOption.dataset.porcentajeCosto;
                    updateTotals();
                });
            });
        })
        .catch(error => console.error('Error al cargar las jurisdicciones:', error));
    }

    function updateTotals() {
        let totalAdeudado = 0;
        let totalCosto = 0;
        let totalAbonar = 0;

        document.querySelectorAll('.infraccion').forEach(row => {
            const importe = parseFloat(row.querySelector('.importe').value) || 0;
            const porcentajeCosto = parseFloat(row.querySelector('.porcentajeCosto').value) || 0;
            const porcentajeDescuento = parseFloat(row.querySelector('input[name^="porcentajeDescuento"]').value) || 0;

            totalAdeudado += importe;
            totalCosto += importe * (porcentajeCosto / 100);
            totalAbonar += importe - (importe * (porcentajeDescuento / 100));
        });

        document.getElementById('totalAdeudado').textContent = totalAdeudado.toFixed(2);
        document.getElementById('totalCosto').textContent = totalCosto.toFixed(2);
        document.getElementById('totalAbonar').textContent = totalAbonar.toFixed(2);
    }

    // Load jurisdictions for the initial domain
    loadJurisdicciones(document.querySelector('.dominio'));
});
