<?php
require_once('TCPDF/tcpdf.php');

function generarPDF($id_cotizacion) {
    // Conexión a la base de datos
    $dsn = 'pgsql:host=localhost;dbname=campus';
    $user = 'zona';
    $password = 'zona2020';

    try {
        $dbh = new PDO($dsn, $user, $password);

        // Obtener datos de la cotización
        $stmt = $dbh->prepare("
            SELECT c.fecha_cotizacion, cl.nombre, cl.dni, cl.domicilio, cl.telefono, cl.contacto, c.total_adeudado, c.total_costo, c.total_abonar_cliente
            FROM cotizaciones c
            JOIN clientes cl ON c.id_cliente = cl.id_cliente
            WHERE c.id_cotizacion = ?
        ");
        $stmt->execute([$id_cotizacion]);
        $cotizacion = $stmt->fetch(PDO::FETCH_ASSOC);

        // Obtener datos de los dominios e infracciones
        $stmt = $dbh->prepare("
            SELECT d.dominio, i.nro_acta, i.fecha_infraccion, i.importe, i.porcentaje_costo_estudio, i.porcentaje_descuento
            FROM dominios d
            JOIN infracciones i ON d.id_dominio = i.id_dominio
            WHERE d.id_cotizacion = ?
        ");
        $stmt->execute([$id_cotizacion]);
        $infracciones = $stmt->fetchAll(PDO::FETCH_ASSOC);

        // Crear el PDF
        $pdf = new TCPDF();
        $pdf->AddPage();

        // Agregar contenido al PDF
        $pdf->SetFont('helvetica', 'B', 12);
        $pdf->Cell(0, 10, 'Cotización', 0, 1, 'C');

        $pdf->SetFont('helvetica', '', 10);
        $pdf->Cell(0, 10, 'Fecha de Cotización: ' . $cotizacion['fecha_cotizacion'], 0, 1);
        $pdf->Cell(0, 10, 'Cliente: ' . $cotizacion['nombre'], 0, 1);
        $pdf->Cell(0, 10, 'DNI: ' . $cotizacion['dni'], 0, 1);
        $pdf->Cell(0, 10, 'Domicilio: ' . $cotizacion['domicilio'], 0, 1);
        $pdf->Cell(0, 10, 'Teléfono: ' . $cotizacion['telefono'], 0, 1);
        $pdf->Cell(0, 10, 'Contacto: ' . $cotizacion['contacto'], 0, 1);
        $pdf->Ln(10);
        $pdf->SetFont('helvetica', 'B', 10);
        $pdf->Cell(30, 10, 'Dominio', 1);
        $pdf->Cell(30, 10, 'Nro de Acta', 1);
        $pdf->Cell(30, 10, 'Fecha de Acta', 1);
        $pdf->Cell(30, 10, 'Importe', 1);
        $pdf->Cell(30, 10, '% de Costo', 1);
        $pdf->Cell(30, 10, '% de Descuento', 1);
        $pdf->Ln();

        $pdf->SetFont('helvetica', '', 10);
        foreach ($infracciones as $infraccion) {
            $pdf->Cell(30, 10, $infraccion['dominio'], 1);
            $pdf->Cell(30, 10, $infraccion['nro_acta'], 1);
            $pdf->Cell(30, 10, $infraccion['fecha_infraccion'], 1);
            $pdf->Cell(30, 10, $infraccion['importe'], 1);
            $pdf->Cell(30, 10, $infraccion['porcentaje_costo_estudio'], 1);
            $pdf->Cell(30, 10, $infraccion['porcentaje_descuento'], 1);
            $pdf->Ln();
        }

        $pdf->Ln(10);
        $pdf->SetFont('helvetica', 'B', 10);
        $pdf->Cell(0, 10, 'Total Adeudado: ' . $cotizacion['total_adeudado'], 0, 1);
        $pdf->Cell(0, 10, 'Total Costo: ' . $cotizacion['total_costo'], 0, 1);
        $pdf->Cell(0, 10, 'Total a Abonar por el Cliente: ' . $cotizacion['total_abonar_cliente'], 0, 1);
        $pdf->Cell(0, 10, 'Ganancia: ' . ($cotizacion['total_abonar_cliente'] - $cotizacion['total_costo']), 0, 1);

        // Salida del PDF
        $pdf->Output('cotizacion_' . $id_cotizacion . '.pdf', 'I');

    } catch (PDOException $e) {
        echo 'Error: ' . $e->getMessage();
    }
}

// Obtener el ID de la cotización de la URL
if (isset($_GET['id_cotizacion'])) {
    generarPDF($_GET['id_cotizacion']);
}
?>
