<?php
$dsn = 'pgsql:host=127.0.0.1;dbname=campus';
$user = 'zona';
$password = 'zona2020';

try {
    $dbh = new PDO($dsn, $user, $password);

    $fecha_cotizacion = $_POST['fechaCotizacion'];
    $nombre = $_POST['clienteNombre'];
    $dni = $_POST['clienteDNI'] ?? null;
    $domicilio = $_POST['clienteDomicilio'] ?? null;
    $telefono = $_POST['clienteTelefono'] ?? null;
    $contacto = $_POST['clienteContacto'] ?? null;

    $dbh->beginTransaction();

    // Agregar o obtener cliente
    $stmt = $dbh->prepare("SELECT id_cliente FROM clientes WHERE nombre = ?");
    $stmt->execute([$nombre]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($cliente) {
        $id_cliente = $cliente['id_cliente'];
    } else {
        $stmt = $dbh->prepare("INSERT INTO clientes (nombre, dni, domicilio, telefono, contacto) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$nombre, $dni, $domicilio, $telefono, $contacto]);
        $id_cliente = $dbh->lastInsertId();
    }

    // Insertar cotización
    $stmt = $dbh->prepare("INSERT INTO cotizaciones (fecha_cotizacion, id_cliente, total_adeudado, total_costo, total_abonar_cliente) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$fecha_cotizacion, $id_cliente, 0, 0, 0]);
    $id_cotizacion = $dbh->lastInsertId();

    $total_adeudado = 0;
    $total_costo = 0;
    $total_abonar_cliente = 0;

    $dominios = $_POST['dominio'];
    foreach ($dominios as $dominioIndex => $dominio) {
        $stmt = $dbh->prepare("INSERT INTO dominios (dominio, id_cliente, id_cotizacion) VALUES (?, ?, ?)");
        $stmt->execute([$dominio, $id_cliente, $id_cotizacion]);
        $id_dominio = $dbh->lastInsertId();

        foreach ($_POST['nroActa'][$dominioIndex] as $infraccionIndex => $nro_acta) {
            $fecha_infraccion = !empty($_POST['fechaInfraccion'][$dominioIndex][$infraccionIndex]) ? $_POST['fechaInfraccion'][$dominioIndex][$infraccionIndex] : null;
            $importe = $_POST['importe'][$dominioIndex][$infraccionIndex];
            $porcentaje_costo = $_POST['porcentajeCosto'][$dominioIndex][$infraccionIndex];
            $porcentaje_descuento = $_POST['porcentajeDescuento'][$dominioIndex][$infraccionIndex];
            $jurisdiccion = $_POST['jurisdiccion'][$dominioIndex][$infraccionIndex];

            $stmt = $dbh->prepare("INSERT INTO infracciones (nro_acta, fecha_infraccion, importe, porcentaje_costo_estudio, porcentaje_descuento, id_dominio, id_cotizacion, id_jurisdiccion) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([$nro_acta, $fecha_infraccion, $importe, $porcentaje_costo, $porcentaje_descuento, $id_dominio, $id_cotizacion, $jurisdiccion]);

            $total_adeudado += $importe;
            $total_costo += $importe * ($porcentaje_costo / 100);
            $total_abonar_cliente += $importe - ($importe * ($porcentaje_descuento / 100));
        }
    }

    // Actualizar totales en cotización
    $stmt = $dbh->prepare("UPDATE cotizaciones SET total_adeudado = ?, total_costo = ?, total_abonar_cliente = ? WHERE id_cotizacion = ?");
    $stmt->execute([$total_adeudado, $total_costo, $total_abonar_cliente, $id_cotizacion]);

    $dbh->commit();

    echo json_encode(['success' => true]);

} catch (PDOException $e) {
    $dbh->rollBack();
    echo json_encode(['success' => false, 'message' => $e->getMessage()]);
}
?>
