document.addEventListener('DOMContentLoaded', () => {
    const addDominioBtn = document.getElementById('addDominioBtn');
    const dominiosContainer = document.getElementById('dominiosContainer');

    addDominioBtn.addEventListener('click', () => {
        dominiosContainer.style.display = 'block';
    });

    document.getElementById('cotizacionForm').addEventListener('input', updateTotals);

    document.querySelector('.addInfraccionBtn').addEventListener('click', () => {
        const newInfraccion = document.createElement('tr');
        newInfraccion.classList.add('infraccion');
        newInfraccion.innerHTML = `
            <td><input type="text" name="nroActa[]" required></td>
            <td><input type="date" name="fechaInfraccion[]"></td>
            <td><input type="number" step="0.01" name="importe[]" required></td>
            <td><input type="number" step="0.01" name="porcentajeCosto[]" required></td>
            <td><input type="number" step="0.01" name="porcentajeDescuento[]" required></td>
        `;
        document.querySelector('.infraccionesContainer').appendChild(newInfraccion);
        updateTotals();
    });

    document.getElementById('cotizacionForm').addEventListener('submit', (event) => {
        event.preventDefault();
        const formData = new FormData(event.target);
        fetch('registrar_cotizacion.php', {
            method: 'POST',
            body: formData
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('Cotización registrada con éxito');
                // Aquí podrías redirigir o limpiar el formulario
            } else {
                alert('Error al registrar la cotización');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            alert('Error al registrar la cotización');
        });
    });

    function updateTotals() {
        let totalAdeudado = 0;
        let totalCosto = 0;
        let totalAbonar = 0;

        document.querySelectorAll('.infraccion').forEach(row => {
            const importe = parseFloat(row.querySelector('input[name="importe[]"]').value) || 0;
            const porcentajeCosto = parseFloat(row.querySelector('input[name="porcentajeCosto[]"]').value) || 0;
            const porcentajeDescuento = parseFloat(row.querySelector('input[name="porcentajeDescuento[]"]').value) || 0;

            totalAdeudado += importe;
            totalCosto += importe * (porcentajeCosto / 100);
            totalAbonar += importe - (importe * (porcentajeDescuento / 100));
        });

        document.getElementById('totalAdeudado').textContent = totalAdeudado.toFixed(2);
        document.getElementById('totalCosto').textContent = totalCosto.toFixed(2);
        document.getElementById('totalAbonar').textContent = totalAbonar.toFixed(2);
    }
});
